/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/data/modify"})
public class EruptTabController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptTabController.class);
    private final Gson gson = GsonFactory.getGson();

    @PostMapping(value={"/tab-add/{erupt}/{tabName}"})
    @EruptRouter(skipAuthIndex=3, authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel addTabEruptData(@PathVariable(value="erupt") String erupt, @PathVariable(value="tabName") String tabName, @RequestBody JsonObject data) {
        EruptModel eruptModel = this.getTabErupt(erupt, tabName);
        Object obj = this.gson.fromJson(data.toString(), eruptModel.getClazz());
        EruptApiModel eruptApiModel = this.tabValidate(eruptModel, data, dp -> {
            dp.beforeAdd(obj);
            dp.afterAdd(obj);
        });
        eruptApiModel.setData(obj);
        return eruptApiModel;
    }

    @PostMapping(value={"/tab-update/{erupt}/{tabName}"})
    @EruptRouter(skipAuthIndex=3, authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel updateTabEruptData(@PathVariable(value="erupt") String erupt, @PathVariable(value="tabName") String tabName, @RequestBody JsonObject data) {
        EruptModel eruptModel = this.getTabErupt(erupt, tabName);
        Object obj = this.gson.fromJson(data.toString(), eruptModel.getClazz());
        EruptApiModel eruptApiModel = this.tabValidate(eruptModel, data, dp -> {
            dp.beforeUpdate(obj);
            dp.afterUpdate(obj);
        });
        eruptApiModel.setData(obj);
        return eruptApiModel;
    }

    @PostMapping(value={"/tab-delete/{erupt}/{tabName}"})
    @EruptRouter(skipAuthIndex=3, authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel deleteTabEruptData(@PathVariable(value="erupt") String erupt, @PathVariable(value="tabName") String tabName, @RequestBody JsonObject data) {
        EruptApiModel eruptApiModel = EruptApiModel.successApi();
        EruptModel eruptModel = this.getTabErupt(erupt, tabName);
        Object obj = this.gson.fromJson(data.toString(), eruptModel.getClazz());
        DataProxyInvoke.invoke(eruptModel, dp -> {
            dp.beforeDelete(obj);
            dp.afterDelete(obj);
        });
        eruptApiModel.setPromptWay(EruptApiModel.PromptWay.MESSAGE);
        return eruptApiModel;
    }

    private EruptApiModel tabValidate(EruptModel eruptModel, JsonObject data, Consumer<DataProxy<Object>> consumer) {
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.SUCCESS) {
            DataProxyInvoke.invoke(eruptModel, consumer);
        }
        eruptApiModel.setPromptWay(EruptApiModel.PromptWay.MESSAGE);
        return eruptApiModel;
    }

    private EruptModel getTabErupt(String erupt, String tabName) {
        EruptFieldModel tabField = EruptCoreService.getErupt(erupt).getEruptFieldMap().get(tabName);
        if (null == tabField) {
            throw new EruptWebApiRuntimeException(tabName + "not found");
        }
        return EruptCoreService.getErupt(tabField.getFieldReturnName());
    }

    @Generated
    public EruptTabController() {
    }
}

