/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.log;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import lombok.Generated;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import xyz.erupt.core.log.EruptLog4J2Appender;
import xyz.erupt.core.log.EruptLogbackAppender;
import xyz.erupt.core.log.LogMessage;
import xyz.erupt.core.prop.EruptProp;

@Component
public class EruptLogManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptLogManager.class);
    private static final Deque<LogMessage> EVENT_QUEUE = new LinkedBlockingDeque<LogMessage>();
    private static int LOG_TRACK_CACHE_SIZE;
    private final EruptProp eruptProp;

    public EruptLogManager(EruptProp eruptProp) {
        this.eruptProp = eruptProp;
        LOG_TRACK_CACHE_SIZE = eruptProp.getLogTrackCacheSize();
    }

    @PostConstruct
    public void appender() {
        if (this.eruptProp.isLogTrack()) {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            String loggerFactoryClassName = loggerFactory.getClass().getName();
            if ("ch.qos.logback.classic.LoggerContext".equalsIgnoreCase(loggerFactoryClassName)) {
                new EruptLogbackAppender().init();
            } else if ("org.apache.logging.slf4j.Log4jLoggerFactory".equalsIgnoreCase(loggerFactoryClassName)) {
                new EruptLog4J2Appender().init();
            } else {
                log.error("EruptLog Unsupported log library :{}", (Object)loggerFactoryClassName);
            }
        }
    }

    public static void log(String message) {
        if (EVENT_QUEUE.size() > LOG_TRACK_CACHE_SIZE) {
            EVENT_QUEUE.poll();
        }
        EVENT_QUEUE.add(new LogMessage(message));
    }

    public static List<LogMessage> getEventQueue(Long size, Long offset) {
        ArrayList<LogMessage> result = new ArrayList<LogMessage>();
        if (null == offset) {
            offset = 0L;
        }
        if (offset == LogMessage.getMax()) {
            return result;
        }
        int i = 0;
        for (LogMessage message : EVENT_QUEUE) {
            if (message.getNum() >= offset) {
                result.add(message);
            }
            if ((long)(++i) <= size + offset) continue;
            break;
        }
        return result;
    }
}

