/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.log;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.slf4j.LoggerFactory;
import xyz.erupt.core.log.EruptAppender;
import xyz.erupt.core.log.EruptLogManager;
import xyz.erupt.core.log.Formatter;

public class EruptLogbackAppender
implements EruptAppender {
    @Override
    public void init() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("ROOT");
        Appender appender = new Appender();
        appender.setContext((Context)context);
        appender.setName("erupt");
        appender.start();
        logger.addAppender((ch.qos.logback.core.Appender)appender);
    }

    public static class Appender
    extends UnsynchronizedAppenderBase<ILoggingEvent> {
        protected void append(ILoggingEvent event) {
            IThrowableProxy proxy = event.getThrowableProxy();
            Formatter formatter = new Formatter().timestamp(event.getTimeStamp()).space().level(event.getLevel().toString()).value(" --- [").thread(event.getThreadName()).value("] ").name(event.getLoggerName()).value(" : ").value(event.getFormattedMessage());
            if (proxy instanceof ThrowableProxy) {
                formatter.throwable(((ThrowableProxy)proxy).getThrowable());
            }
            EruptLogManager.log(formatter.toString());
        }
    }
}

