/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.operator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import xyz.erupt.core.constant.UpmsScope;
import xyz.erupt.core.operator.OperatorExpr;
import xyz.erupt.core.operator.OperatorType;
import xyz.erupt.core.operator.SqlParams;

public class EruptSearchModel {
    private String field;
    private OperatorType operatorType;
    private UpmsScope upmsScope;
    private String operator;
    private Object value;

    public static SqlParams convertCondition(List<List<EruptSearchModel>> conditions) {
        SqlParams sqlParams = new SqlParams();
        if (conditions == null || conditions.isEmpty()) {
            return sqlParams;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<CallSite> orConditions = new ArrayList<CallSite>();
        for (List<EruptSearchModel> andGroup : conditions) {
            if (andGroup == null || andGroup.isEmpty()) continue;
            ArrayList<String> andConditions = new ArrayList<String>();
            for (EruptSearchModel search : andGroup) {
                if (search == null || search.getField() == null) continue;
                Class<? extends Enum<?>> operatorClass = search.getOperatorType().operatorClass;
                OperatorExpr operatorExpr = (OperatorExpr)((Object)Enum.valueOf(operatorClass, search.getOperator()));
                String condition = operatorExpr.expr(search.getField(), search.getValue(), sqlParams.getParams());
                andConditions.add(condition);
            }
            if (andConditions.isEmpty()) continue;
            orConditions.add((CallSite)((Object)("(" + String.join((CharSequence)" AND ", andConditions) + ")")));
        }
        if (!orConditions.isEmpty()) {
            sb.append("(").append(String.join((CharSequence)" OR ", orConditions)).append(")");
        }
        sqlParams.setSql(sb.toString());
        return sqlParams;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    @Generated
    public UpmsScope getUpmsScope() {
        return this.upmsScope;
    }

    @Generated
    public String getOperator() {
        return this.operator;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public void setOperatorType(OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    @Generated
    public void setUpmsScope(UpmsScope upmsScope) {
        this.upmsScope = upmsScope;
    }

    @Generated
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }
}

