/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import xyz.erupt.core.annotation.EruptScan;

public class EruptApplication
implements ImportBeanDefinitionRegistrar {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptApplication.class);
    private static Class<?> primarySource;
    private static final Set<String> scanPackage;

    public static String[] getScanPackage() {
        return scanPackage.toArray(new String[0]);
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, @NonNull BeanDefinitionRegistry registry) {
        Class clazz = ClassUtils.forName((String)importingClassMetadata.getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        Optional.ofNullable(clazz.getAnnotation(SpringBootApplication.class)).ifPresent(it -> {
            primarySource = clazz;
        });
        EruptScan eruptScan = clazz.getAnnotation(EruptScan.class);
        try {
            Class.forName("org.springframework.boot.devtools.RemoteUrlPropertyExtractor");
            log.error("If  spring-boot-devtools  is on the classpath together with Erupt, weird bugs start to pop up.\nJust drop the devtools dependency\u2014problem solved.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (eruptScan.value().length == 0) {
            scanPackage.add(clazz.getPackage().getName());
        } else {
            Stream.of(eruptScan.value()).filter(pack -> !pack.equals("xyz.erupt")).forEach(scanPackage::add);
        }
    }

    @Generated
    public static Class<?> getPrimarySource() {
        return primarySource;
    }

    static {
        scanPackage = new HashSet<String>();
    }
}

