/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import jakarta.annotation.Resource;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import xyz.erupt.annotation.fun.AttachmentProxy;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptUtil;

@Service
public class EruptFileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptFileService.class);
    @Resource
    private EruptProp eruptProp;

    public String createPath(MultipartFile file) {
        if (file.isEmpty() || StringUtils.isBlank((CharSequence)file.getOriginalFilename())) {
            throw new EruptWebApiRuntimeException("not found file");
        }
        if (this.eruptProp.isKeepUploadFileName()) {
            return File.separator + DateUtil.getFormatDate(new Date(), "yyyy-MM-dd") + File.separator + file.getOriginalFilename().replaceAll("&|#|\\?|\\s", "");
        }
        String[] fileNameSplit = file.getOriginalFilename().split("\\.");
        return File.separator + DateUtil.getFormatDate(new Date(), "yyyy-MM-dd") + File.separator + RandomStringUtils.randomAlphabetic((int)12) + "." + fileNameSplit[fileNameSplit.length - 1];
    }

    public String upload(MultipartFile file, String path) {
        try {
            boolean localSave = true;
            AttachmentProxy attachmentProxy = EruptUtil.findAttachmentProxy();
            if (null != attachmentProxy) {
                path = attachmentProxy.upLoad(file.getInputStream(), path.replace("\\", "/"));
                localSave = attachmentProxy.isLocalSave();
            }
            if (localSave) {
                Path uploadRoot = Paths.get(this.eruptProp.getUploadPath(), new String[0]);
                Path target = uploadRoot.resolve(path.substring(1)).normalize();
                if (!target.startsWith(uploadRoot)) {
                    throw new EruptWebApiRuntimeException("Illegal path");
                }
                if (!target.toFile().getParentFile().exists() && !target.toFile().getParentFile().mkdirs()) {
                    throw new EruptWebApiRuntimeException(I18nTranslate.$translate("erupt.upload_error.cannot_created") + ": " + target.toFile().getParentFile().getAbsolutePath());
                }
                file.transferTo(target.toFile());
            }
            return path.replace("\\", "/");
        }
        catch (Exception e) {
            log.error("erupt upload error", (Throwable)e);
            throw new EruptWebApiRuntimeException(I18nTranslate.$translate("erupt.upload_error") + " " + e.getMessage());
        }
    }
}

