/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.sub_erupt.LinkTree;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.event.EruptAddEvent;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;

@Service
public class EruptModifyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptModifyService.class);
    private final EruptService eruptService;
    private final HttpServletRequest request;
    private final ApplicationEventPublisher applicationEventPublisher;

    public Object eruptInsertDataProcess(EruptModel eruptModel, JsonObject data) {
        HashMap<String, Object> extraData = new HashMap<String, Object>();
        this.setLinkValue(eruptModel, extraData);
        this.setDrillValue(eruptModel, extraData);
        return EruptUtil.jsonToEruptEntity(eruptModel, data, extraData);
    }

    private void setLinkValue(EruptModel eruptModel, Map<String, Object> extraData) {
        LinkTree dependTree = eruptModel.getErupt().linkTree();
        if (StringUtils.isNotBlank((CharSequence)dependTree.field()) && dependTree.dependNode()) {
            String linkVal = this.request.getHeader("link");
            if (dependTree.dependNode()) {
                if (StringUtils.isBlank((CharSequence)linkVal)) {
                    throw new EruptWebApiRuntimeException("Place select tree node");
                }
                String rm = ReflectUtil.findClassField(eruptModel.getClazz(), dependTree.field()).getType().getSimpleName();
                JsonObject sub = new JsonObject();
                sub.addProperty(EruptCoreService.getErupt(rm).getErupt().primaryKeyCol(), linkVal);
                extraData.put(dependTree.field(), sub);
            }
        }
    }

    private void setDrillValue(EruptModel eruptModel, Map<String, Object> extraData) {
        this.eruptService.drillProcess(eruptModel, (link, val) -> {
            String joinColumn = link.joinColumn();
            if (joinColumn.contains(".")) {
                String[] jc = joinColumn.split("\\.");
                JsonObject jo2 = new JsonObject();
                jo2.addProperty(jc[1], val.toString());
                extraData.put(jc[0], jo2);
            } else {
                extraData.put(joinColumn, val.toString());
            }
        });
    }

    public void modifyLog(EruptModel eruptModel, String action, String content) {
        log.info("ERUPT CURD | {} | {} | {} | {}", new Object[]{MetaContext.getUser().getName(), eruptModel.getEruptName(), action, content});
    }

    @Transactional
    public Object insertEruptData(EruptModel eruptModel, JsonObject data) {
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
            throw new EruptApiErrorTip(eruptApiModel.getMessage(), EruptApiModel.PromptWay.MESSAGE);
        }
        Object obj = this.eruptInsertDataProcess(eruptModel, data);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(obj));
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).addData(eruptModel, obj);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterAdd(obj));
        this.applicationEventPublisher.publishEvent(new EruptAddEvent<Object>(eruptModel.getClazz(), obj));
        Object pk = ReflectUtil.findClassField(eruptModel.getClazz(), eruptModel.getErupt().primaryKeyCol()).get(obj);
        this.modifyLog(eruptModel, "ADD", GsonFactory.getGson().toJson(obj));
        return pk;
    }

    @Generated
    public EruptModifyService(EruptService eruptService, HttpServletRequest request, ApplicationEventPublisher applicationEventPublisher) {
        this.eruptService = eruptService;
        this.request = request;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

