/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.Viz;
import xyz.erupt.annotation.config.QueryExpression;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.annotation.sub_erupt.Layout;
import xyz.erupt.annotation.sub_erupt.Link;
import xyz.erupt.annotation.sub_erupt.LinkTree;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.DataHandlerUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.util.TypeUtil;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.core.view.TableQuery;

@Service
public class EruptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptService.class);
    @Resource
    private HttpServletRequest request;

    public Page getEruptData(EruptModel eruptModel, TableQuery tableQuery, List<Condition> serverCondition, String ... customCondition) {
        Layout layout;
        Erupts.powerLegal(eruptModel, PowerObject::isQuery);
        List<Condition> legalConditions = EruptUtil.geneEruptSearchCondition(eruptModel, tableQuery.getCondition());
        ArrayList<String> conditionStrings = new ArrayList<String>();
        LinkTree dependTree = eruptModel.getErupt().linkTree();
        if (StringUtils.isNotBlank((CharSequence)dependTree.field())) {
            if (null == tableQuery.getLinkTreeVal()) {
                if (dependTree.dependNode()) {
                    return new Page();
                }
            } else {
                EruptModel treeErupt = EruptCoreService.getErupt(ReflectUtil.findClassField(eruptModel.getClazz(), dependTree.field()).getType().getSimpleName());
                Viz[] pk = treeErupt.getEruptFieldMap().get(treeErupt.getErupt().primaryKeyCol());
                conditionStrings.add(String.format("%s in (%s)", dependTree.field() + "." + pk.getFieldName(), TypeUtil.arrayToConditonString(tableQuery.getLinkTreeVal(), pk.getField().getType())));
            }
        }
        if (Layout.PagingType.FRONT == (layout = eruptModel.getErupt().layout()).pagingType() || Layout.PagingType.NONE == layout.pagingType()) {
            tableQuery.setPageSize(layout.pageSizes()[layout.pageSizes().length - 1]);
        }
        this.drillProcess(eruptModel, (link, val) -> {
            conditionStrings.add(String.format(val instanceof String ? "%s = '%s'" : "%s = %s", link.linkErupt().getSimpleName() + "." + link.joinColumn(), val));
            if (StringUtils.isNotBlank((CharSequence)link.linkCondition())) {
                conditionStrings.add(link.linkCondition());
            }
        });
        conditionStrings.addAll(Arrays.asList(customCondition));
        DataProxyInvoke.invoke(eruptModel, dataProxy -> Optional.ofNullable(dataProxy.beforeFetch(legalConditions)).ifPresent(conditionStrings::add));
        if (null != tableQuery.getViz()) {
            for (Viz viz : eruptModel.getErupt().viz()) {
                if (!viz.code().equals(tableQuery.getViz())) continue;
                for (Filter filter : viz.filter()) {
                    conditionStrings.add(filter.value());
                }
            }
        }
        Optional.ofNullable(serverCondition).ifPresent(legalConditions::addAll);
        Page page = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).queryList(eruptModel, tableQuery, EruptQuery.builder().sort(tableQuery.getSort()).conditionStrings(conditionStrings).conditions(legalConditions).build());
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterFetch(page.getList()));
        Optional.ofNullable(page.getList()).ifPresent(it -> DataHandlerUtil.convertDataToEruptView(eruptModel, it));
        DataProxyInvoke.invoke(eruptModel, dataProxy -> Optional.ofNullable(dataProxy.alert(legalConditions)).ifPresent(page::setAlert));
        return page;
    }

    public void drillProcess(EruptModel eruptModel, BiConsumer<Link, Object> consumer) {
        String drill = this.request.getHeader("Drill");
        if (null != drill) {
            String drillValue = this.request.getHeader("DrillValue");
            String sourceErupt = this.request.getHeader("DrillSourceErupt");
            if (null == drillValue || null == sourceErupt) {
                throw new EruptWebApiRuntimeException("Drill Header Illegal \uff0cLack\uff1aDrillValue,DrillSourceErupt");
            }
            EruptModel sourceModel = EruptCoreService.getErupt(sourceErupt);
            Link link = Stream.of(sourceModel.getErupt().drills()).filter(it -> drill.equals(it.code())).findFirst().orElseThrow(EruptNoLegalPowerException::new).link();
            if (!link.linkErupt().getSimpleName().equals(eruptModel.getEruptName())) {
                throw new EruptWebApiRuntimeException("Illegal erupt from " + drill);
            }
            Object data = DataProcessorManager.getEruptDataProcessor(sourceModel.getClazz()).findDataById(sourceModel, EruptUtil.toEruptId(sourceModel, drillValue));
            Field field = ReflectUtil.findClassField(sourceModel.getClazz(), link.column());
            field.setAccessible(true);
            Object val = field.get(data);
            consumer.accept(link, val);
        }
    }

    public void verifyIdPermissions(EruptModel eruptModel, String id) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        conditions.add(new Condition(eruptModel.getErupt().primaryKeyCol(), (Object)id, QueryExpression.EQ));
        Page page = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).queryList(eruptModel, new Page(1, 1), EruptQuery.builder().conditions(conditions).build());
        if (page.getList().isEmpty()) {
            throw new EruptNoLegalPowerException();
        }
    }
}

