/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import com.google.gson.reflect.TypeToken;
import java.text.ParseException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.quartz.SchedulerException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Service;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.toolkit.notify.DataAction;
import xyz.erupt.toolkit.notify.NotifyData;

@Service
public class JobMessageListener {
    public static final String JOB_TOPIC = "erupt-job:data-proxy:notify";
    @Resource
    private RedisConnectionFactory redisConnectionFactory;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private EruptJobService eruptJobService;

    @PostConstruct
    public void post() {
        if (this.eruptProp.isRedisSession()) {
            this.redisConnectionFactory.getConnection().subscribe((message, pattern) -> {
                NotifyData notifyData = (NotifyData)GsonFactory.getGson().fromJson(message.toString(), new TypeToken<NotifyData<EruptJob>>(){}.getType());
                try {
                    if (DataAction.ADD.equals((Object)notifyData.getAction())) {
                        this.eruptJobService.addJob((EruptJob)((Object)((Object)notifyData.getData())));
                    } else if (DataAction.UPDATE.equals((Object)notifyData.getAction())) {
                        this.eruptJobService.modifyJob((EruptJob)((Object)((Object)notifyData.getData())));
                    } else if (DataAction.DELETE.equals((Object)notifyData.getAction())) {
                        this.eruptJobService.deleteJob((EruptJob)((Object)((Object)notifyData.getData())));
                    }
                }
                catch (ParseException | SchedulerException e) {
                    throw new RuntimeException(e);
                }
            }, (byte[][])new byte[][]{JOB_TOPIC.getBytes()});
        }
    }
}

