/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.advice;

import lombok.Generated;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.view.R;

@Order(value=0x7FFFFFFD)
@ControllerAdvice
public class JpaExceptionAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaExceptionAdvice.class);

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<R<Void>> handleHibernateConstraint(ConstraintViolationException ex) {
        log.error("JDBC ConstraintViolationException: ", (Throwable)ex);
        String sqlState = ex.getSQLState();
        int errorCode = ex.getErrorCode();
        ResponseEntity.BodyBuilder rb = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        if (1451 == errorCode) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.delete_fail_may_be_associated_data")));
        }
        if (1062 == errorCode) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.data_duplication")));
        }
        if (1265 == errorCode) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.limit_length")));
        }
        if (547 == errorCode) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.delete_fail_may_be_associated_data")));
        }
        if (2627 == errorCode || 2601 == errorCode) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.data_duplication")));
        }
        if (8152 == errorCode) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.limit_length")));
        }
        if ("23503".equals(sqlState)) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.delete_fail_may_be_associated_data")));
        }
        if ("23505".equals(sqlState)) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.data_duplication")));
        }
        if ("22003".equals(sqlState)) {
            return rb.body((Object)R.error((String)"Number out of range"));
        }
        if ("23000".equals(sqlState)) {
            return rb.body((Object)R.error((String)ex.getMessage()));
        }
        if ("2291".equals(sqlState)) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.delete_fail_may_be_associated_data")));
        }
        if ("1".equals(sqlState)) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.data_duplication")));
        }
        if ("12899".equals(sqlState)) {
            return rb.body((Object)R.error((String)I18nTranslate.$translate((String)"erupt.data.limit_length")));
        }
        throw ex;
    }
}

