/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.support;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.util.ReflectUtil;

@Component
public class CommentIntegrator
implements Integrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommentIntegrator.class);
    private final I18nTranslate i18nTranslate;

    public void integrate(@NonNull Metadata metadata, @NonNull SessionFactoryImplementor sessionFactory, @NonNull SessionFactoryServiceRegistry serviceRegistry) {
        this.processComment(metadata);
    }

    public void disintegrate(@NonNull SessionFactoryImplementor sessionFactoryImplementor, @NonNull SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
    }

    private void processComment(Metadata metadata) {
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            Class clazz = persistentClass.getMappedClass();
            if (!clazz.isAnnotationPresent(Erupt.class)) continue;
            Erupt erupt = clazz.getAnnotation(Erupt.class);
            persistentClass.getTable().setComment(this.i18nTranslate.translate(erupt.name()));
            Optional.ofNullable(persistentClass.getIdentifierProperty()).ifPresent(it -> this.fieldComment(persistentClass, it.getName()));
            for (Property p : persistentClass.getProperties()) {
                this.fieldComment(persistentClass, p.getName());
            }
        }
    }

    private void fieldComment(PersistentClass persistentClass, String columnName) {
        block6: {
            try {
                Field field = ReflectUtil.findClassField((Class)persistentClass.getMappedClass(), (String)columnName);
                if (null == field) {
                    return;
                }
                if (!field.isAnnotationPresent(EruptField.class) || field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class) || field.isAnnotationPresent(ElementCollection.class)) break block6;
                EruptField eruptField = field.getAnnotation(EruptField.class);
                String comment = eruptField.edit().title();
                if (StringUtils.isBlank((CharSequence)comment) && eruptField.views().length > 0) {
                    comment = eruptField.views()[0].title();
                }
                if (!StringUtils.isNotBlank((CharSequence)comment)) break block6;
                String sqlColumnName = ((Column)persistentClass.getProperty(columnName).getValue().getColumns().iterator().next()).getText();
                for (Column column : persistentClass.getTable().getColumns()) {
                    if (!sqlColumnName.equalsIgnoreCase(column.getName())) continue;
                    column.setComment(this.i18nTranslate.translate(comment));
                    break;
                }
            }
            catch (SecurityException field) {
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Generated
    public CommentIntegrator(I18nTranslate i18nTranslate) {
        this.i18nTranslate = i18nTranslate;
    }
}

