/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.text.DecimalFormat;
import oshi.software.os.OSFileStore;
import xyz.erupt.monitor.util.SystemUtil;

public class SysFile {
    private String dirName;
    private String sysTypeName;
    private String typeName;
    private String total;
    private String free;
    private String used;
    private String usage;

    SysFile(OSFileStore fs) {
        long free = fs.getUsableSpace();
        long total = fs.getTotalSpace();
        long used = total - free;
        this.setDirName(fs.getMount());
        this.setSysTypeName(fs.getType());
        this.setTypeName(fs.getName());
        this.setTotal(SystemUtil.formatByte(total));
        this.setFree(SystemUtil.formatByte(free));
        this.setUsed(SystemUtil.formatByte(used));
        this.setUsage(new DecimalFormat("#.##%").format((double)(total - free) * 1.0 / (double)total));
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getSysTypeName() {
        return this.sysTypeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTotal() {
        return this.total;
    }

    public String getFree() {
        return this.free;
    }

    public String getUsed() {
        return this.used;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public void setSysTypeName(String sysTypeName) {
        this.sysTypeName = sysTypeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public void setFree(String free) {
        this.free = free;
    }

    public void setUsed(String used) {
        this.used = used;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }
}

