/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.lionsoul.ip2region.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static byte[] fileByte;

    public static String getIpAddr(HttpServletRequest request) {
        try {
            InetAddress inet;
            String ip = request.getHeader("x-forwarded-for");
            if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) && ("127.0.0.1".equals(ip = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ip)) && (ip = (inet = InetAddress.getLocalHost()).getHostAddress()) != null && ip.length() > 15 && ip.indexOf(44) > 0) {
                ip = ip.substring(0, ip.indexOf(44));
            }
            if (ip != null && ip.length() > 15 && ip.indexOf(44) > 0) {
                ip = ip.substring(0, ip.indexOf(44));
            }
            return ip;
        }
        catch (Exception e) {
            log.warn("get ip error " + e.getMessage());
            return null;
        }
    }

    public static String getCityInfo(String ip) {
        if (!Util.isIpAddress((String)ip)) {
            log.warn("Error: Invalid ip address: {}", (Object)ip);
            return "";
        }
        try {
            return new DbSearcher(new DbConfig(), fileByte).memorySearch(ip).getRegion();
        }
        catch (Exception e) {
            log.warn("ip2region error " + ip, (Throwable)e);
            return null;
        }
    }

    static {
        try (InputStream input = IpUtil.class.getClassLoader().getResourceAsStream("ip2region.db");){
            if (null == input) {
                throw new RuntimeException("ip2region.db not found");
            }
            fileByte = StreamUtils.copyToByteArray((InputStream)input);
        }
        catch (IOException e) {
            log.warn("ip2region load error", (Throwable)e);
        }
    }
}

