/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.controller;

import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.view.R;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.model.EruptOpenApi;
import xyz.erupt.upms.service.EruptTokenService;
import xyz.erupt.upms.vo.OpenApiTokenVo;

@RestController
@RequestMapping(value={"/erupt-api/open-api"})
public class EruptOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptOpenApiController.class);
    private final EruptDao eruptDao;
    private final EruptTokenService eruptTokenService;

    @GetMapping(value={"/create-token"})
    @Transactional
    public R<OpenApiTokenVo> createToken(@RequestParam(value="appid") String appid, @RequestParam(value="secret") String secret) {
        EruptOpenApi eruptOpenApi = (EruptOpenApi)((Object)this.eruptDao.lambdaQuery(EruptOpenApi.class).eq(EruptOpenApi::getAppid, (Object)appid).one());
        if (eruptOpenApi == null) {
            throw new EruptWebApiRuntimeException("appid not found");
        }
        if (!secret.equals(eruptOpenApi.getSecret())) {
            throw new EruptWebApiRuntimeException("secret error");
        }
        if (!eruptOpenApi.getStatus().booleanValue()) {
            throw new EruptWebApiRuntimeException("locked down");
        }
        String token = "ER" + RandomStringUtils.randomAlphanumeric((int)24).toUpperCase();
        LocalDateTime expire = LocalDateTime.now().plusMinutes(eruptOpenApi.getExpire().intValue());
        this.eruptTokenService.loginToken(eruptOpenApi.getEruptUser(), token, eruptOpenApi.getExpire());
        if (null != eruptOpenApi.getCurrentToken()) {
            log.info("open-api remove old token {}", (Object)eruptOpenApi.getName());
            this.eruptTokenService.logoutToken(eruptOpenApi.getName(), eruptOpenApi.getCurrentToken());
        }
        eruptOpenApi.setCurrentToken(token);
        return R.ok((Object)new OpenApiTokenVo(token, expire));
    }

    @Generated
    public EruptOpenApiController(EruptDao eruptDao, EruptTokenService eruptTokenService) {
        this.eruptDao = eruptDao;
        this.eruptTokenService = eruptTokenService;
    }
}

