/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.looker;

import jakarta.annotation.Resource;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.PreDataProxy;
import xyz.erupt.annotation.config.EruptSmartSkipSerialize;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.Readonly;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.DateType;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.invoke.DataProxyContext;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.EruptUserPostVo;
import xyz.erupt.upms.service.EruptUserService;

@MappedSuperclass
@PreDataProxy(value=Comp.class)
public class LookerOrg
extends BaseModel {
    @ManyToOne
    @EruptField(views={@View(title="\u521b\u5efa\u4eba", column="name"), @View(title="\u6240\u5c5e\u7ec4\u7ec7", column="eruptOrg.name")}, edit=@Edit(title="\u521b\u5efa\u4eba", readonly=@Readonly, type=EditType.REFERENCE_TABLE))
    @EruptSmartSkipSerialize
    private EruptUserPostVo createUser;
    @EruptField(views={@View(title="\u521b\u5efa\u65f6\u95f4", sortable=true)}, edit=@Edit(title="\u521b\u5efa\u65f6\u95f4", readonly=@Readonly, dateType=@DateType(type=DateType.Type.DATE_TIME)))
    @EruptSmartSkipSerialize
    private Date createTime;
    @EruptSmartSkipSerialize
    private Date updateTime;
    @EruptSmartSkipSerialize
    @ManyToOne
    private EruptUserPostVo updateUser;

    @Generated
    public EruptUserPostVo getCreateUser() {
        return this.createUser;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public EruptUserPostVo getUpdateUser() {
        return this.updateUser;
    }

    @Generated
    public void setCreateUser(EruptUserPostVo createUser) {
        this.createUser = createUser;
    }

    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setUpdateUser(EruptUserPostVo updateUser) {
        this.updateUser = updateUser;
    }

    @Component
    static class Comp
    implements DataProxy<LookerOrg> {
        @Resource
        private EruptUserService eruptUserService;

        Comp() {
        }

        public String beforeFetch(List<Condition> conditions) {
            EruptUser eruptUser = this.eruptUserService.getCurrentEruptUser();
            if (eruptUser.getIsAdmin().booleanValue()) {
                return null;
            }
            if (null == eruptUser.getEruptOrg()) {
                throw new EruptWebApiRuntimeException(eruptUser.getName() + " " + I18nTranslate.$translate((String)"upms.no_bind_org"));
            }
            return DataProxyContext.currentClass().getSimpleName() + ".createUser.eruptOrg.id = " + eruptUser.getEruptOrg().getId();
        }

        public void beforeAdd(LookerOrg lookerOrg) {
            lookerOrg.setCreateTime(new Date());
            lookerOrg.setCreateUser(new EruptUserPostVo(this.eruptUserService.getCurrentUid()));
        }

        public void beforeUpdate(LookerOrg lookerOrg) {
            lookerOrg.setUpdateTime(new Date());
            lookerOrg.setUpdateUser(new EruptUserPostVo(this.eruptUserService.getCurrentUid()));
        }
    }
}

