/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.annotation.sub_erupt.Tree;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.Readonly;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.ChoiceType;
import xyz.erupt.annotation.sub_field.sub_edit.CodeEditorType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTreeType;
import xyz.erupt.core.constant.MenuStatus;
import xyz.erupt.core.constant.MenuTypeEnum;
import xyz.erupt.core.module.MetaMenu;
import xyz.erupt.jpa.model.MetaModel;
import xyz.erupt.upms.service.EruptMenuService;

@Entity
@Table(name="e_upms_menu")
@Erupt(name="\u83dc\u5355\u7ba1\u7406", orderBy="EruptMenu.sort asc", tree=@Tree(pid="parentMenu.id", expandLevel=5), dataProxy={EruptMenuService.class})
@EruptI18n
public class EruptMenu
extends MetaModel {
    @EruptField(views={@View(title="\u540d\u79f0")}, edit=@Edit(title="\u540d\u79f0", notNull=true))
    private String name;
    @EruptField(edit=@Edit(notNull=true, title="\u72b6\u6001", type=EditType.CHOICE, choiceType=@ChoiceType(fetchHandler={MenuStatus.ChoiceFetch.class})))
    private Integer status;
    @ManyToOne
    @EruptField(edit=@Edit(title="\u4e0a\u7ea7\u83dc\u5355", type=EditType.REFERENCE_TREE, referenceTreeType=@ReferenceTreeType(pid="parentMenu.id", expandLevel=3)))
    private EruptMenu parentMenu;
    @EruptField(edit=@Edit(title="\u83dc\u5355\u7c7b\u578b", type=EditType.CHOICE, choiceType=@ChoiceType(fetchHandler={MenuTypeEnum.ChoiceFetch.class})))
    private String type;
    @EruptField(edit=@Edit(title="\u7c7b\u578b\u503c"))
    private String value;
    @EruptField(edit=@Edit(title="\u987a\u5e8f"))
    private Integer sort = 0;
    @EruptField(edit=@Edit(title="\u56fe\u6807", desc="\u8bf7\u53c2\u8003\u56fe\u6807\u5e93font-awesome"))
    private String icon;
    @Column(length=64, unique=true)
    @EruptField(edit=@Edit(title="\u7f16\u7801", readonly=@Readonly))
    private String code;
    @Column(length=2000)
    @EruptField(edit=@Edit(title="\u81ea\u5b9a\u4e49\u53c2\u6570", type=EditType.CODE_EDITOR, codeEditType=@CodeEditorType(language="json")))
    private String param;

    public EruptMenu(String code, String name, String type, String value, Integer status, Integer sort, String icon, EruptMenu parentMenu) {
        this.code = code;
        this.name = name;
        this.status = status;
        this.type = type;
        this.value = value;
        this.sort = sort;
        this.icon = icon;
        this.parentMenu = parentMenu;
        this.setCreateTime(LocalDateTime.now());
    }

    public EruptMenu(String code, String name, String type, String value, EruptMenu parentMenu, Integer sort) {
        this.code = code;
        this.name = name;
        this.parentMenu = parentMenu;
        this.type = type;
        this.value = value;
        this.sort = sort;
        this.setStatus(MenuStatus.OPEN.getValue());
        this.setCreateTime(LocalDateTime.now());
    }

    public MetaMenu toMetaMenu() {
        MetaMenu metaMenu = new MetaMenu();
        metaMenu.setId(this.getId());
        metaMenu.setCode(this.getCode());
        metaMenu.setName(this.getName());
        metaMenu.setType(this.getType());
        metaMenu.setValue(this.getValue());
        metaMenu.setStatus(null != this.getStatus() ? MenuStatus.valueOf((int)this.getStatus()) : MenuStatus.OPEN);
        metaMenu.setSort(this.getSort());
        metaMenu.setIcon(this.getIcon());
        metaMenu.setParentMenu(null == this.getParentMenu() ? null : this.getParentMenu().toMetaMenu());
        return metaMenu;
    }

    public static EruptMenu fromMetaMenu(MetaMenu metaMenu) {
        if (null == metaMenu) {
            return null;
        }
        EruptMenu eruptMenu = new EruptMenu(metaMenu.getCode(), metaMenu.getName(), null == metaMenu.getType() ? null : metaMenu.getType(), metaMenu.getValue(), null == metaMenu.getStatus() ? null : Integer.valueOf(metaMenu.getStatus().getValue()), metaMenu.getSort(), metaMenu.getIcon(), EruptMenu.fromMetaMenu(metaMenu.getParentMenu()));
        eruptMenu.setId(metaMenu.getId());
        return eruptMenu;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public EruptMenu getParentMenu() {
        return this.parentMenu;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Integer getSort() {
        return this.sort;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getParam() {
        return this.param;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setParentMenu(EruptMenu parentMenu) {
        this.parentMenu = parentMenu;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setParam(String param) {
        this.param = param;
    }

    @Generated
    public EruptMenu() {
    }
}

