/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.Gson;
import jakarta.annotation.Resource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.upms.service.EruptLocalSession;

@Component
public class EruptSessionService {
    @Resource
    private EruptProp eruptProp;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private EruptLocalSession eruptLocalSession;
    private final Gson gson = GsonFactory.getGson();

    public void put(String key, String str, long timeout, TimeUnit timeUnit) {
        if (this.eruptProp.isRedisSession()) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)str, timeout, timeUnit);
        } else {
            this.eruptLocalSession.put(key, str, timeUnit.toMillis(timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long increment(String key, long timeout, TimeUnit timeUnit) {
        if (this.eruptProp.isRedisSession()) {
            try {
                Long l = this.stringRedisTemplate.opsForValue().increment((Object)key, 1L);
                return l;
            }
            finally {
                this.stringRedisTemplate.expire((Object)key, timeout, timeUnit);
            }
        }
        EruptSessionService eruptSessionService = this;
        synchronized (eruptSessionService) {
            Long num = (Long)this.eruptLocalSession.get(key);
            if (null == num) {
                num = 0L;
            }
            num = num + 1L;
            this.eruptLocalSession.put(key, num, timeUnit.toMillis(timeout));
            return num;
        }
    }

    public boolean exist(String key) {
        if (this.eruptProp.isRedisSession()) {
            return this.stringRedisTemplate.hasKey((Object)key);
        }
        return null != this.eruptLocalSession.get(key);
    }

    public void remove(String key) {
        if (this.eruptProp.isRedisSession()) {
            this.stringRedisTemplate.delete((Object)key);
        } else {
            this.eruptLocalSession.delete(key);
        }
    }

    public void expire(String key, long timeout, TimeUnit unit) {
        if (this.eruptProp.isRedisSession()) {
            this.stringRedisTemplate.expire((Object)key, timeout, unit);
        } else {
            this.eruptLocalSession.expire(key, unit.toMillis(timeout));
        }
    }

    public Object get(String key) {
        if (this.eruptProp.isRedisSession()) {
            return this.stringRedisTemplate.opsForValue().get((Object)key);
        }
        return this.eruptLocalSession.get(key);
    }

    public <T> T get(String key, Type type) {
        if (this.eruptProp.isRedisSession()) {
            if (null == this.get(key)) {
                return null;
            }
            return (T)this.gson.fromJson(this.get(key).toString(), type);
        }
        return (T)this.gson.fromJson(this.eruptLocalSession.get(key).toString(), type);
    }

    public void putMap(String key, Map<String, Object> map, long expire, TimeUnit timeUnit) {
        if (this.eruptProp.isRedisSession()) {
            BoundHashOperations boundHashOperations = this.stringRedisTemplate.boundHashOps((Object)key);
            map.replaceAll((k, v) -> this.gson.toJson(v));
            boundHashOperations.putAll(map);
            boundHashOperations.expire(expire, timeUnit);
        } else {
            this.eruptLocalSession.put(key, map, timeUnit.toMillis(expire));
        }
    }

    public List<String> getMapKeys(String key) {
        if (this.eruptProp.isRedisSession()) {
            Set set = this.stringRedisTemplate.opsForHash().keys((Object)key);
            return set.stream().map(Object::toString).collect(Collectors.toList());
        }
        Map map = (Map)this.eruptLocalSession.get(key);
        if (null == map) {
            return null;
        }
        return new ArrayList<String>(map.keySet());
    }

    public <T> T getMapValue(String key, String mapKey, Class<T> type) {
        if (this.eruptProp.isRedisSession()) {
            Object obj = this.stringRedisTemplate.boundHashOps((Object)key).get((Object)mapKey);
            if (null == obj) {
                return null;
            }
            return (T)this.gson.fromJson(obj.toString(), type);
        }
        Map map = (Map)this.eruptLocalSession.get(key);
        if (null == map) {
            return null;
        }
        return (T)map.get(mapKey);
    }
}

