/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.sub_erupt.Power;
import xyz.erupt.core.constant.MenuTypeEnum;
import xyz.erupt.core.module.EruptModuleInvoke;
import xyz.erupt.core.module.MetaMenu;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.prop.InitMethodEnum;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.MD5Util;
import xyz.erupt.core.util.ProjectUtil;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.linq.lambda.LambdaSee;
import xyz.erupt.upms.enums.EruptFunPermissions;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.prop.EruptUpmsProp;
import xyz.erupt.upms.util.UPMSUtil;

@Service
@Order
public class UpmsDataLoadService
implements CommandLineRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpmsDataLoadService.class);
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private EruptUpmsProp eruptUpmsProp;

    @Transactional
    public void run(String ... args) {
        if (this.eruptDao.lambdaQuery(EruptUser.class).count() <= 0L) {
            try {
                FileUtils.deleteDirectory((File)new File(System.getProperty("user.dir") + "/.erupt"));
            }
            catch (IOException e) {
                log.error("Table 'e_upms_user' no user data. Re-initialization failed \uff1a", (Throwable)e);
            }
        }
        if (InitMethodEnum.NONE != this.eruptProp.getInitMethodEnum()) {
            EruptModuleInvoke.invoke(module -> Optional.ofNullable(module.initMenus()).ifPresent(metaMenus -> new ProjectUtil().projectStartLoaded(module.info().getName(), first -> {
                Runnable runnable = () -> {
                    module.initFun();
                    for (MetaMenu metaMenu : metaMenus) {
                        EruptMenu eruptMenu = (EruptMenu)((Object)((Object)((Object)((Object)((Object)this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)EruptMenu.fromMetaMenu(metaMenu), LambdaSee.field(EruptMenu::getCode), metaMenu.getCode()))))));
                        metaMenu.setId(eruptMenu.getId());
                        if (null == eruptMenu.getType() || null == eruptMenu.getValue() || !MenuTypeEnum.TABLE.getCode().equals(eruptMenu.getType()) && !MenuTypeEnum.TREE.getCode().equals(eruptMenu.getType())) continue;
                        AtomicInteger i = new AtomicInteger();
                        Optional.ofNullable(EruptCoreService.getErupt((String)eruptMenu.getValue())).ifPresent(it -> {
                            Power power = it.getErupt().power();
                            for (EruptFunPermissions value : EruptFunPermissions.values()) {
                                if (!value.verifyPower(power)) continue;
                                this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value), value.getName(), MenuTypeEnum.BUTTON.getCode(), UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value), eruptMenu, i.addAndGet(10)), LambdaSee.field(EruptMenu::getCode), UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value));
                            }
                        });
                    }
                };
                switch (this.eruptProp.getInitMethodEnum()) {
                    case EVERY: {
                        runnable.run();
                        break;
                    }
                    case FILE: {
                        if (!first.booleanValue()) break;
                        runnable.run();
                    }
                }
            })));
        }
        new ProjectUtil().projectStartLoaded("erupt-upms-user", first -> {
            if (first.booleanValue() && this.eruptDao.lambdaQuery(EruptUser.class).eq(EruptUser::getIsAdmin, (Object)true).list().isEmpty()) {
                EruptUser eruptUser = new EruptUser();
                eruptUser.setIsAdmin(true);
                eruptUser.setIsMd5(true);
                eruptUser.setStatus(true);
                eruptUser.setCreateTime(new Date());
                eruptUser.setAccount(this.eruptUpmsProp.getDefaultAccount());
                eruptUser.setPassword(MD5Util.digest((String)this.eruptUpmsProp.getDefaultPassword()));
                eruptUser.setName(this.eruptUpmsProp.getDefaultAccount());
                this.eruptDao.persistIfNotExist(EruptUser.class, (Object)eruptUser, LambdaSee.field(EruptUser::getAccount), eruptUser.getAccount());
            }
        });
    }
}

