/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.webscoket;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import xyz.erupt.core.module.EruptModule;
import xyz.erupt.core.module.EruptModuleInvoke;
import xyz.erupt.core.module.ModuleInfo;
import xyz.erupt.upms.prop.EruptAppProp;

@Configuration
@ComponentScan
@EnableWebSocket
@EnableConfigurationProperties
public class EruptWebSocketAutoConfiguration
implements EruptModule {
    public static final String ERUPT_WEBSOCKET = "erupt-websocket";
    @Resource
    private EruptAppProp eruptAppProp;

    @PostConstruct
    public void post() {
        this.eruptAppProp.registerProp(ERUPT_WEBSOCKET, (Object)true);
    }

    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    public ModuleInfo info() {
        return ModuleInfo.builder().name(ERUPT_WEBSOCKET).build();
    }

    static {
        EruptModuleInvoke.addEruptModule(EruptWebSocketAutoConfiguration.class);
    }
}

