/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.webscoket.channel;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.upms.service.EruptTokenService;
import xyz.erupt.webscoket.channel.EruptChannelManager;
import xyz.erupt.webscoket.command.base.SocketCommand;

@Component
@ServerEndpoint(value="/erupt")
public class EruptChannel {
    private static final Logger log = LoggerFactory.getLogger(EruptChannel.class);

    @OnOpen
    public void open(Session session) {
        List token = (List)session.getRequestParameterMap().get("token");
        if (null == token || !((EruptTokenService)EruptSpringUtil.getBean(EruptTokenService.class)).tokenExist((String)token.get(0))) {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Token error"));
            return;
        }
        EruptChannelManager.register((String)token.get(0), session);
    }

    @OnMessage
    public void message(Session session, String message) {
        List command = (List)GsonFactory.getGson().fromJson(message, new TypeToken<ArrayList<String>>(){}.getType());
        SocketCommand socketCommand = SocketCommand.getCommand((String)command.get(0));
        try {
            socketCommand.handler(session, GsonFactory.getGson().fromJson(command.size() == 1 ? null : (String)command.get(1), socketCommand.type));
        }
        catch (Exception e) {
            log.error("[websocket] Command execution error\uff1a{}", (Object)e.getMessage());
        }
    }

    @OnClose
    public void close(Session session, CloseReason closeReason) {
        if (closeReason.getCloseCode() != CloseReason.CloseCodes.NORMAL_CLOSURE && closeReason.getCloseCode() != CloseReason.CloseCodes.GOING_AWAY) {
            log.warn("[websocket] disconnect\uff1aid={}\uff0c{}", (Object)session.getId(), (Object)closeReason);
        }
        EruptChannelManager.close(session);
    }

    @OnError
    public void error(Session session, Throwable throwable) throws IOException {
        log.error("[websocket] Connection exception\uff1aid={}\uff0cthrowable={}", (Object)session.getId(), (Object)throwable.getMessage());
        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, throwable.getMessage()));
    }
}

