/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.linq.schema;

import java.util.List;
import java.util.function.BiFunction;
import xyz.erupt.linq.consts.JoinExchange;
import xyz.erupt.linq.consts.JoinMethod;
import xyz.erupt.linq.lambda.LambdaSee;
import xyz.erupt.linq.lambda.SFunction;
import xyz.erupt.linq.schema.Row;

public class JoinSchema<T> {
    private final JoinMethod joinMethod;
    private final JoinExchange joinExchange;
    private final List<T> target;
    private final Class<T> clazz;
    private BiFunction<T, Row, Boolean> on;
    private SFunction<T, ?> lon;
    private SFunction<?, ?> ron;

    public JoinSchema(JoinMethod joinMethod, List<T> target, SFunction<T, ?> lon, SFunction<?, ?> ron) {
        this.joinMethod = joinMethod;
        this.target = target;
        this.lon = lon;
        this.ron = ron;
        this.clazz = LambdaSee.info(lon).getClazz();
        this.joinExchange = JoinExchange.HASH;
    }

    public JoinSchema(JoinMethod joinMethod, List<T> target, BiFunction<T, Row, Boolean> on) {
        this.joinMethod = joinMethod;
        this.target = target;
        this.on = on;
        this.clazz = target.getClass().getGenericSuperclass().getClass();
        this.joinExchange = JoinExchange.NESTED_LOOP;
    }

    public JoinMethod getJoinMethod() {
        return this.joinMethod;
    }

    public JoinExchange getJoinExchange() {
        return this.joinExchange;
    }

    public List<T> getTarget() {
        return this.target;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public SFunction<T, ?> getLon() {
        return this.lon;
    }

    public SFunction<?, ?> getRon() {
        return this.ron;
    }
}

