/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.linq.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import xyz.erupt.linq.consts.CompareSymbol;
import xyz.erupt.linq.lambda.LambdaInfo;
import xyz.erupt.linq.lambda.LambdaSee;
import xyz.erupt.linq.lambda.SFunction;
import xyz.erupt.linq.schema.Column;
import xyz.erupt.linq.schema.Row;
import xyz.erupt.linq.util.CompareUtil;
import xyz.erupt.linq.util.RowUtil;
import xyz.erupt.linq.util.VirtualColumn;

public class Columns {
    public static <R> Column of(SFunction<R, ?> fun) {
        return Columns.of(fun, LambdaSee.field(fun));
    }

    public static <R> Column of(SFunction<R, ?> fun, String alias) {
        LambdaInfo lambdaInfo = LambdaSee.info(fun);
        Column column = new Column();
        column.setTable(lambdaInfo.getClazz());
        column.setField(lambdaInfo.getField());
        column.setAlias(alias);
        return column;
    }

    public static <R, A> Column of(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.of(fun, LambdaSee.field(alias));
    }

    @Deprecated
    public static <R, S> Column ofx(SFunction<R, S> fun, Function<S, Object> convert, String alias) {
        Column column = Columns.of(fun);
        column.setAlias(alias);
        column.setRowConvert(row -> convert.apply(row.get(fun)));
        return column;
    }

    @Deprecated
    public static <R, S> Column ofx(SFunction<R, S> fun, Function<S, Object> convert) {
        return Columns.ofx(fun, convert, LambdaSee.field(fun));
    }

    @Deprecated
    public static Column ofs(Function<Row, ?> fun, String alias) {
        Column column = new Column();
        column.setTable(VirtualColumn.class);
        column.setField(VirtualColumn.lambdaColumn().getField());
        column.setAlias(alias);
        column.setRowConvert(fun);
        return column;
    }

    @Deprecated
    public static <A> Column ofs(Function<Row, ?> fun, SFunction<A, ?> alias) {
        return Columns.ofs(fun, LambdaSee.field(alias));
    }

    public static Column count(String alias) {
        Column column = new Column(VirtualColumn.class, VirtualColumn.lambdaColumn().getField(), alias);
        column.setGroupByFun(it -> BigDecimal.valueOf(it.size()));
        return column;
    }

    public static <A> Column count(SFunction<A, ?> alias) {
        return Columns.count(LambdaSee.field(alias));
    }

    public static <R> Column count(SFunction<R, ?> fun, String alias) {
        return Columns.groupByProcess(fun, alias, (column, list) -> {
            int i = 0;
            for (Row row : list) {
                if (null == row.get((Column)column)) continue;
                ++i;
            }
            return BigDecimal.valueOf(i);
        });
    }

    public static <R, A> Column count(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.count(fun, LambdaSee.field(alias));
    }

    public static <R> Column countDistinct(SFunction<R, ?> fun, String alias) {
        return Columns.groupByProcess(fun, alias, (column, list) -> {
            HashMap distinctMap = new HashMap();
            for (Row row : list) {
                Optional.ofNullable(row.get((Column)column)).ifPresent(it -> distinctMap.put(it, null));
            }
            return BigDecimal.valueOf(distinctMap.size());
        });
    }

    public static <R, A> Column countDistinct(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.countDistinct(fun, LambdaSee.field(alias));
    }

    public static <R> Column max(SFunction<R, ?> fun, String alias) {
        return Columns.groupByProcess(fun, alias, (column, list) -> {
            Object result = null;
            for (Row row : list) {
                Object val = row.get((Column)column);
                if (null == result) {
                    result = val;
                }
                if (!CompareUtil.compare(val, result, CompareSymbol.GT)) continue;
                result = val;
            }
            if (result instanceof Number) {
                return RowUtil.numberToBigDecimal((Number)result);
            }
            return result;
        });
    }

    public static <R, A> Column max(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.max(fun, LambdaSee.field(alias));
    }

    public static <R> Column min(SFunction<R, ?> fun, String alias) {
        return Columns.groupByProcess(fun, alias, (column, list) -> {
            Object result = null;
            for (Row row : list) {
                Object val = row.get((Column)column);
                if (null == result) {
                    result = val;
                }
                if (!CompareUtil.compare(val, result, CompareSymbol.LT)) continue;
                result = val;
            }
            if (result instanceof Number) {
                return RowUtil.numberToBigDecimal((Number)result);
            }
            return result;
        });
    }

    public static <R, A> Column min(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.min(fun, LambdaSee.field(alias));
    }

    public static <R> Column avg(SFunction<R, ?> fun, String alias) {
        return Columns.groupByProcess(fun, alias, (column, list) -> {
            BigDecimal bigDecimal = new BigDecimal(0);
            int count = 0;
            for (Row row : list) {
                Object val = row.get((Column)column);
                if (!(val instanceof Number)) continue;
                bigDecimal = bigDecimal.add(new BigDecimal(String.valueOf(val)));
                ++count;
            }
            return count > 0 ? BigDecimal.valueOf(bigDecimal.doubleValue() / (double)count) : BigDecimal.valueOf(0L);
        });
    }

    public static <R, A> Column avg(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.avg(fun, LambdaSee.field(alias));
    }

    public static <R> Column sum(SFunction<R, ?> fun, String alias) {
        return Columns.groupByProcess(fun, alias, (column, list) -> {
            BigDecimal bigDecimal = new BigDecimal(0);
            for (Row row : list) {
                Object val = row.get((Column)column);
                if (!(val instanceof Number)) continue;
                bigDecimal = bigDecimal.add(new BigDecimal(String.valueOf(val)));
            }
            return bigDecimal;
        });
    }

    public static <R, A> Column sum(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.sum(fun, LambdaSee.field(alias));
    }

    public static <R> Column groupArray(SFunction<R, ?> fun, String alias) {
        return Columns.groupByProcess(fun, alias, (column, list) -> {
            ArrayList result = new ArrayList();
            for (Row row : list) {
                Optional.ofNullable(row.get((Column)column)).ifPresent(result::add);
            }
            return result;
        });
    }

    public static <R, A> Column groupArray(SFunction<R, ?> fun, SFunction<A, ?> alias) {
        return Columns.groupArray(fun, LambdaSee.field(alias));
    }

    public static <R> Column groupByProcess(SFunction<R, ?> fun, String alias, BiFunction<Column, List<Row>, Object> groupByProcess) {
        Column column = Columns.of(fun, alias);
        column.setGroupByFun(it -> groupByProcess.apply(column.getRawColumn(), (List<Row>)it));
        return column;
    }
}

