/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.linq.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import xyz.erupt.linq.exception.LinqException;
import xyz.erupt.linq.lambda.Th;
import xyz.erupt.linq.schema.Column;
import xyz.erupt.linq.schema.Row;
import xyz.erupt.linq.util.Columns;
import xyz.erupt.linq.util.ReflectField;

public class RowUtil {
    public static final Class<?>[] SIMPLE_CLASS = new Class[]{CharSequence.class, Character.class, Number.class, Date.class, Temporal.class, Boolean.class, CharSequence[].class, Character[].class, Number[].class, Date[].class, Temporal[].class, Boolean[].class};

    public static List<Row> listToTable(List<?> objects) {
        ArrayList<Row> list = new ArrayList<Row>(objects.size());
        Class<?> clazz = null;
        List<Field> fields = null;
        boolean simpleClass = false;
        boolean first = true;
        for (final Object obj : objects) {
            if (null == obj) continue;
            if (first) {
                clazz = obj.getClass();
                fields = ReflectField.getFields(clazz);
                for (Class<?> sc : SIMPLE_CLASS) {
                    if (!sc.isAssignableFrom(clazz)) continue;
                    simpleClass = true;
                }
                first = false;
            }
            if (simpleClass) {
                list.add(new Row(1){
                    {
                        super(initialCapacity);
                        this.put(Columns.of(Th::is), obj);
                    }
                });
                continue;
            }
            Row row = new Row(fields.size());
            try {
                for (Field field : fields) {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    row.put(new Column(clazz, field.getName(), field.getName()), field.get(obj));
                }
            }
            catch (Exception e) {
                throw new LinqException(e);
            }
            list.add(row);
        }
        return list;
    }

    public static <T> T rowToObject(Row row, Class<T> clazz) {
        if (row.size() == 1) {
            Object val = row.get((Column)row.keySet().iterator().next());
            if (null != val && clazz == val.getClass()) {
                return (T)val;
            }
            for (Class<T> clazz2 : SIMPLE_CLASS) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return (T)(val instanceof BigDecimal ? RowUtil.bigDecimalConvert((BigDecimal)val, clazz) : val);
            }
        }
        try {
            T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map<String, Field> fieldMap = ReflectField.getFields(clazz).stream().collect(Collectors.toMap(Field::getName, it -> it));
            for (Map.Entry entry : row.entrySet()) {
                if (!fieldMap.containsKey(((Column)entry.getKey()).getAlias())) continue;
                Field field = fieldMap.get(((Column)entry.getKey()).getAlias());
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if (entry.getValue() instanceof BigDecimal) {
                    field.set(instance, RowUtil.bigDecimalConvert((BigDecimal)entry.getValue(), field.getType()));
                    continue;
                }
                field.set(instance, entry.getValue());
            }
            return instance;
        }
        catch (Exception e) {
            throw new LinqException(e);
        }
    }

    public static Object bigDecimalConvert(BigDecimal bigDecimal, Class<?> target) {
        if (Integer.class == target) {
            return bigDecimal.intValue();
        }
        if (Short.class == target) {
            return bigDecimal.shortValue();
        }
        if (Float.class == target) {
            return Float.valueOf(bigDecimal.floatValue());
        }
        if (Double.class == target) {
            return bigDecimal.doubleValue();
        }
        if (Byte.class == target) {
            return bigDecimal.byteValue();
        }
        if (Long.class == target) {
            return bigDecimal.longValue();
        }
        if (BigDecimal.class == target) {
            return bigDecimal;
        }
        if (target.isAssignableFrom(String.class)) {
            return bigDecimal.toString();
        }
        throw new LinqException("unknown 'bigDecimal' target type: " + target.getName());
    }

    public static BigDecimal numberToBigDecimal(Number number) {
        if (number instanceof Integer) {
            return BigDecimal.valueOf(((Integer)number).intValue());
        }
        if (number instanceof Short) {
            return BigDecimal.valueOf(((Short)number).shortValue());
        }
        if (number instanceof Float) {
            return BigDecimal.valueOf(((Float)number).floatValue());
        }
        if (number instanceof Double) {
            return BigDecimal.valueOf((Double)number);
        }
        if (number instanceof Byte) {
            return BigDecimal.valueOf(((Byte)number).byteValue());
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return BigDecimal.valueOf(number.doubleValue());
    }
}

