/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.common;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class VersionInfo {
    public static final String RCS_ID = "$Header: VersionInfo.java 120.0 2005/05/07 09:29:35 appldev ship $";
    public static final String AOLJ_VERSION = new String("Applications Object Library, Core Java Roll Up Patch J");
    private static Vector mRCS_IDs = new Vector(500, 100);

    public static Vector getRCS_IDs() {
        return mRCS_IDs;
    }

    public static final boolean recordClassVersion(String string, String string2) {
        if (string != null) {
            mRCS_IDs.addElement(string2 + "#" + string);
            return true;
        }
        return false;
    }

    public static final String recordVersion(String string, String string2) {
        if (string != null) {
            mRCS_IDs.addElement(string2 + "#" + string);
            return string;
        }
        return null;
    }

    public static final boolean recordClassVersion(Class clazz) {
        try {
            return null != VersionInfo.recordVersion((String)clazz.getField("RCS_ID").get(null), clazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final String recordVersion(String string, Class clazz) {
        try {
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(".");
            String string3 = n < 0 ? "" : string2.substring(0, n);
            if (VersionInfo.recordClassVersion(string, string3)) {
                return string;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void printVersionInfo() {
        VersionInfo.printVersionInfo(System.out);
    }

    public static void printVersionInfo(PrintStream printStream) {
        VersionInfo.printVersionInfo(new PrintWriter(printStream));
    }

    public static void printVersionInfo(PrintWriter printWriter) {
        Enumeration enumeration = VersionInfo.getPrettyVersionInfo();
        while (enumeration.hasMoreElements()) {
            printWriter.println(enumeration.nextElement());
        }
        printWriter.flush();
    }

    public static Enumeration getVersionInfo() {
        Enumeration enumeration = VersionInfo.getRCS_IDs().elements();
        Vector<String> vector = new Vector<String>(VersionInfo.getRCS_IDs().size());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = 0;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements() && string.compareTo((String)enumeration2.nextElement()) > 0) {
                ++n;
            }
            vector.insertElementAt(string, n);
        }
        return vector.elements();
    }

    public static Enumeration getPrettyVersionInfo() {
        Enumeration enumeration = VersionInfo.getVersionInfo();
        Vector<String> vector = new Vector<String>(VersionInfo.getRCS_IDs().size(), 10);
        String string = "";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.substring(0, string2.indexOf("#"));
            String string4 = string2.substring(string2.indexOf("#") + 1);
            if (string3.compareTo(string) != 0) {
                string = string3;
                vector.insertElementAt(string3, vector.size());
            }
            vector.insertElementAt(string4, vector.size());
        }
        return vector.elements();
    }

    public static void displayClassVersion(String string) {
        VersionInfo.displayClassVersion(string, System.out);
    }

    public static void displayClassVersion(String string, PrintStream printStream) {
        VersionInfo.displayClassVersion(string, new PrintWriter(printStream));
    }

    public static void displayClassVersion(String string, PrintWriter printWriter) {
        try {
            printWriter.println(">>> Class: " + string);
            printWriter.println(Class.forName(string).getDeclaredField("RCS_ID").get(null));
        }
        catch (ClassNotFoundException classNotFoundException) {
            printWriter.println("Unable to find class " + string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            printWriter.println("Class " + string + " does not have an RCS_ID field");
        }
        catch (SecurityException securityException) {
            printWriter.println("Security exception, unable to access field");
        }
        catch (IllegalAccessException illegalAccessException) {
            printWriter.println("IllegalAccessException, unable to access field");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    public static void AOLJ_RUP(String string) {
        System.out.println(AOLJ_VERSION);
        System.out.println(RCS_ID);
    }

    public static void main(String[] stringArray) {
        VersionInfo.AOLJ_RUP(null);
        for (int i = 0; i < stringArray.length; ++i) {
            VersionInfo.displayClassVersion(stringArray[i]);
        }
    }
}

