/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DefaultCheckNumberFormatter;
import oracle.apps.fnd.i18n.common.util.FormatMaskUtil;

public abstract class CheckNumberFormatter {
    public static final String RCS_ID = "$Header: CheckNumberFormatter.java 120.1 2010/04/30 21:01:02 rsuzuki noship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: CheckNumberFormatter.java 120.1 2010/04/30 21:01:02 rsuzuki noship $", "oracle.apps.fnd.i18n.common.text");
    public static final int CASE_INIT_CAP = 10;
    public static final int CASE_UPPER = 20;
    public static final int CASE_LOWER = 30;
    private static final int CASE_DEFAULT = 10;
    public static final int DECIMAL_STYLE_FRACTION1 = 10;
    public static final int DECIMAL_STYLE_FRACTION2 = 11;
    public static final int DECIMAL_STYLE_WORDS = 20;
    public static final int DECIMAL_STYLE_NUMBER = 30;
    public static final int DECIMAL_STYLE_NOT_SHOWN = 40;
    public static final int INTEGER_STYLE_WORDS = 100;
    public static final int INTEGER_STYLE_NOT_SHOWN = 200;

    public static CheckNumberFormatter getInstance(Locale locale) {
        return new DefaultCheckNumberFormatter(locale, 10);
    }

    public static CheckNumberFormatter getInstance(Locale locale, int n) {
        return new DefaultCheckNumberFormatter(locale, n);
    }

    public String format(BigDecimal bigDecimal, String string) {
        int n = FormatMaskUtil.getCurrencyPrecision(string);
        return this.format(bigDecimal, n);
    }

    public abstract String format(BigDecimal var1, int var2);

    public abstract void setDecimalStyle(int var1);

    public abstract void setIntegerStyle(int var1);

    public abstract void setRoundingMode(int var1);
}

