/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.FieldPosition;
import oracle.apps.fnd.i18n.common.text.Format;
import oracle.apps.fnd.i18n.common.text.NumberFormat;
import oracle.apps.fnd.i18n.common.text.ParsePosition;
import oracle.apps.fnd.i18n.common.text.SimpleDateFormat;
import oracle.apps.fnd.i18n.common.util.Calendar;

public abstract class DateFormat
extends Format {
    public static final String RCS_ID = "$Header: DateFormat.java 120.2 2011/11/14 18:48:12 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DateFormat.java 120.2 2011/11/14 18:48:12 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    protected Calendar mCalendar;
    protected NumberFormat mNumberFormat;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    public static final int TIMEZONE_HOUR_FIELD = 18;
    public static final int TIMEZONE_MINUTE_FIELD = 19;
    public static final int NANOSECOND_FIELD = 20;
    public static final int CENTURY_FIELD = 21;
    public static final int ISO_WEEK_OF_YEAR_FIELD = 22;
    public static final int SHORT = 10;
    public static final int MEDIUM = 11;
    public static final int LONG = 12;
    public static final int SHORT_TZ = 30;
    public static final int MEDIUM_TZ = 31;
    public static final int LONG_TZ = 32;
    private static final int FORMAT_TYPE_DATE_DEFAULT = 11;
    private static final int FORMAT_TYPE_TIME_DEFAULT = 11;

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Timestamp) {
            return this.format((Timestamp)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format((Number)object, stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Date");
    }

    public abstract StringBuffer format(Timestamp var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(Number var1, StringBuffer var2, FieldPosition var3);

    public final String format(Date date) {
        return this.format(date, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final String format(Timestamp timestamp) {
        return this.format(timestamp, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final String format(Number number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (parsePosition.mIndex == 0) {
            throw new ParseException("Unparseable date: \"" + string + "\"", parsePosition.mErrorIndex);
        }
        return date;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.get(11, 0, 1, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n) {
        return DateFormat.get(n, 0, 1, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n, Locale locale) {
        return DateFormat.get(n, 0, 1, locale);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.get(0, 11, 2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n) {
        return DateFormat.get(0, n, 2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n, Locale locale) {
        return DateFormat.get(0, n, 2, locale);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.get(11, 11, 3, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2) {
        return DateFormat.get(n2, n, 3, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        return DateFormat.get(n2, n, 3, locale);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(11, 11);
    }

    public void setCalendar(Calendar calendar) {
        this.mCalendar = calendar;
    }

    public Calendar getCalendar() {
        return this.mCalendar;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.mCalendar.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.mCalendar.getTimeZone();
    }

    public static synchronized Locale[] getAvailableLocales() {
        return java.text.DateFormat.getAvailableLocales();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.mNumberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.mNumberFormat;
    }

    public void setLenient(boolean bl) {
        this.mCalendar.setLenient(bl);
    }

    public boolean isLenient() {
        return this.mCalendar.isLenient();
    }

    public int hashCode() {
        return this.mNumberFormat.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateFormat dateFormat = (DateFormat)object;
        return this.mCalendar.getFirstDayOfWeek() == dateFormat.mCalendar.getFirstDayOfWeek() && this.mCalendar.getMinimalDaysInFirstWeek() == dateFormat.mCalendar.getMinimalDaysInFirstWeek() && this.mCalendar.isLenient() == dateFormat.mCalendar.isLenient() && this.mCalendar.getTimeZone().equals(dateFormat.mCalendar.getTimeZone()) && this.mNumberFormat.equals(dateFormat.mNumberFormat);
    }

    public Object clone() {
        DateFormat dateFormat = (DateFormat)super.clone();
        dateFormat.mCalendar = (Calendar)this.mCalendar.clone();
        dateFormat.mNumberFormat = (NumberFormat)this.mNumberFormat.clone();
        return dateFormat;
    }

    private static DateFormat get(int n, int n2, int n3, Locale locale) {
        if ((n3 & 1) != 0) {
            if (n < 10 || n > 32 || n > 12 && n < 30) {
                throw new IllegalArgumentException("Illegal time style " + n);
            }
        } else {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            if (n2 < 10 || n2 > 12) {
                throw new IllegalArgumentException("Illegal date style " + n2);
            }
        } else {
            n2 = -1;
        }
        try {
            return new SimpleDateFormat(n, n2, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return new SimpleDateFormat(11, "M/d/yy h:mm a");
        }
    }
}

