/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.resources.CalendarResourceAccessor;
import oracle.apps.fnd.i18n.common.text.resources.DateResourceAccessor;

public class DateFormatSymbols
implements Cloneable,
Serializable {
    public static final String RCS_ID = "$Header: DateFormatSymbols.java 120.3 2011/11/14 18:49:24 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DateFormatSymbols.java 120.3 2011/11/14 18:49:24 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    public static final int RESOURCE_JAVA = 7;
    public static final int RESOURCE_ORACLE_V8 = 8;
    public static final int RESOURCE_ORACLE_V9 = 9;
    public static final int RESOURCE_ORACLE = 9;
    private static final int RESOURCE_DEFAULT = 7;
    private static final int DEFAULT_CALENDAR = 0;
    String[] mEras = null;
    String[] mShortEras = null;
    String[] mMonths = null;
    String[] mShortMonths = null;
    String[] mWeekdays = null;
    String[] mShortWeekdays = null;
    String[] mAmpms = null;
    String[][] mZoneStrings = null;
    static final String mPatternChars = "GyMdkHmsSEDFwWahKzZtTfCYOAxRrgoUuI";
    Locale mLocale;
    int mResourceId;
    private Hashtable m_ZoneIndexCache = new Hashtable(3);

    public DateFormatSymbols() {
        this(Locale.getDefault(), 7);
    }

    public DateFormatSymbols(Locale locale) {
        this(locale, 7);
    }

    public DateFormatSymbols(Locale locale, int n) {
        this.initialize(locale, n, 0);
    }

    public DateFormatSymbols(Locale locale, int n, int n2) {
        this.initialize(locale, n, n2);
    }

    public String[] getEras() {
        return this.duplicate(this.mEras);
    }

    public void setEras(String[] stringArray) {
        this.mEras = this.duplicate(stringArray);
    }

    public String[] getShortEras() {
        return this.duplicate(this.mShortEras);
    }

    public void setShortEras(String[] stringArray) {
        this.mShortEras = this.duplicate(stringArray);
    }

    public String[] getMonths() {
        return this.duplicate(this.mMonths);
    }

    public void setMonths(String[] stringArray) {
        this.mMonths = this.duplicate(stringArray);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.mShortMonths);
    }

    public void setShortMonths(String[] stringArray) {
        this.mShortMonths = this.duplicate(stringArray);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.mWeekdays);
    }

    public void setWeekdays(String[] stringArray) {
        this.mWeekdays = this.duplicate(stringArray);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.mShortWeekdays);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.mShortWeekdays = this.duplicate(stringArray);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.mAmpms);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.mAmpms = this.duplicate(stringArray);
    }

    public String[][] getZoneStrings() {
        String[][] stringArray = new String[this.mZoneStrings.length][];
        for (int i = 0; i < this.mZoneStrings.length; ++i) {
            stringArray[i] = this.duplicate(this.mZoneStrings[i]);
        }
        return stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        String[][] stringArrayArray = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArrayArray[i] = this.duplicate(stringArray[i]);
        }
        this.mZoneStrings = stringArrayArray;
        this.m_ZoneIndexCache.clear();
    }

    public Object clone() {
        try {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)super.clone();
            this.copyMembers(this, dateFormatSymbols);
            return dateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.mZoneStrings[0].length; ++i) {
            n ^= this.mZoneStrings[0][i].hashCode();
        }
        return n;
    }

    final int getZoneIndex(String string) {
        Integer n = (Integer)this.m_ZoneIndexCache.get(string);
        if (n == null) {
            for (int i = 0; i < this.mZoneStrings.length; ++i) {
                if (!string.equalsIgnoreCase(this.mZoneStrings[i][0])) continue;
                this.m_ZoneIndexCache.put(string, new Integer(i));
                return i;
            }
            this.m_ZoneIndexCache.put(string, new Integer(-1));
            return -1;
        }
        return n;
    }

    private final String[] duplicate(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private final void copyMembers(DateFormatSymbols dateFormatSymbols, DateFormatSymbols dateFormatSymbols2) {
        dateFormatSymbols2.mEras = this.duplicate(dateFormatSymbols.mEras);
        dateFormatSymbols2.mShortEras = this.duplicate(dateFormatSymbols.mShortEras);
        dateFormatSymbols2.mMonths = this.duplicate(dateFormatSymbols.mMonths);
        dateFormatSymbols2.mShortMonths = this.duplicate(dateFormatSymbols.mShortMonths);
        dateFormatSymbols2.mWeekdays = this.duplicate(dateFormatSymbols.mWeekdays);
        dateFormatSymbols2.mShortWeekdays = this.duplicate(dateFormatSymbols.mShortWeekdays);
        dateFormatSymbols2.mAmpms = this.duplicate(dateFormatSymbols.mAmpms);
        for (int i = 0; i < dateFormatSymbols2.mZoneStrings.length; ++i) {
            dateFormatSymbols2.mZoneStrings[i] = this.duplicate(dateFormatSymbols.mZoneStrings[i]);
        }
    }

    private void initialize(Locale locale, int n, int n2) {
        this.mLocale = locale;
        this.mResourceId = n;
        DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(locale, n);
        this.setCalendarResources(n2);
        this.setWeekdays(dateResourceAccessor.getDowNames());
        this.setShortWeekdays(dateResourceAccessor.getShortDowNames());
        this.setAmPmStrings(dateResourceAccessor.getAmPmMarkers());
        this.setZoneStrings(dateResourceAccessor.getTimeZoneStrings());
    }

    void setCalendarResources(int n) {
        if (n == 0) {
            DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(this.mLocale, this.mResourceId);
            this.setMonths(dateResourceAccessor.getMonthNames());
            this.setShortMonths(dateResourceAccessor.getShortMonthNames());
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.mLocale);
            this.setEras(calendarResourceAccessor.getEraResources());
            this.setShortEras(calendarResourceAccessor.getShortEraResources());
        } else if (n == 4) {
            DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(new Locale("ar", ""), this.mResourceId);
            this.setMonths(dateResourceAccessor.getHijrahMonthNames());
            this.setShortMonths(dateResourceAccessor.getHijrahShortMonthNames());
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.mLocale);
            this.setEras(calendarResourceAccessor.getHijrahEraResources());
            this.setShortEras(calendarResourceAccessor.getHijrahShortEraResources());
        } else if (n == 3) {
            DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(new Locale("en", ""), this.mResourceId);
            this.setMonths(dateResourceAccessor.getHijrahMonthNames());
            this.setShortMonths(dateResourceAccessor.getHijrahShortMonthNames());
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.mLocale);
            this.setEras(calendarResourceAccessor.getHijrahEraResources());
            this.setShortEras(calendarResourceAccessor.getHijrahShortEraResources());
        } else if (n == 1) {
            DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(this.mLocale, this.mResourceId);
            this.setMonths(dateResourceAccessor.getMonthNames());
            this.setShortMonths(dateResourceAccessor.getShortMonthNames());
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.mLocale);
            this.setEras(calendarResourceAccessor.getJapaneseEraResources());
            this.setShortEras(calendarResourceAccessor.getJapaneseShortEraResources());
        } else if (n == 2) {
            DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(this.mLocale, this.mResourceId);
            this.setMonths(dateResourceAccessor.getMonthNames());
            this.setShortMonths(dateResourceAccessor.getShortMonthNames());
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.mLocale);
            this.setEras(calendarResourceAccessor.getThaiEraResources());
            this.setShortEras(calendarResourceAccessor.getThaiShortEraResources());
        } else if (n == 5) {
            DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(this.mLocale, this.mResourceId);
            this.setMonths(dateResourceAccessor.getMonthNames());
            this.setShortMonths(dateResourceAccessor.getShortMonthNames());
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.mLocale);
            this.setEras(calendarResourceAccessor.getChinaEraResources());
            this.setShortEras(calendarResourceAccessor.getChinaShortEraResources());
        }
    }
}

