/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DefaultDateFormatter;
import oracle.apps.fnd.i18n.common.util.Calendar;

public abstract class DateFormatter {
    public static final String RCS_ID = "$Header: DateFormatter.java 120.4 2006/05/17 20:35:02 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DateFormatter.java 120.4 2006/05/17 20:35:02 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    public static final int FORMAT_ORACLE = 10;
    public static final int FORMAT_JAVA = 11;
    public static final int FORMAT_MS = 12;
    public static final int RESOURCE_ORACLE_V8 = 8;
    public static final int RESOURCE_ORACLE_V9 = 9;
    public static final int RESOURCE_JAVA = 7;
    public static final int RESOURCE_ORACLE = 9;
    private static final int RESOURCE_DEFAULT = 7;
    public static final int SHORT = 10;
    public static final int MEDIUM = 11;
    public static final int LONG = 12;
    public static final int SHORT_TIME = 20;
    public static final int MEDIUM_TIME = 21;
    public static final int LONG_TIME = 22;
    public static final int SHORT_TIME_TZ = 30;
    public static final int MEDIUM_TIME_TZ = 31;
    public static final int LONG_TIME_TZ = 32;
    protected Calendar mCalendar;

    public static DateFormatter getInstance(Locale locale) {
        return new DefaultDateFormatter(locale);
    }

    public static DateFormatter getInstance(TimeZone timeZone, Locale locale) {
        return new DefaultDateFormatter(timeZone, locale);
    }

    public abstract String format(Date var1, int var2, String var3, int var4);

    public String format(Date date, int n) {
        return this.format(date, n, 7);
    }

    public abstract String format(Date var1, int var2, int var3);

    public abstract String format(Timestamp var1, int var2, String var3, int var4);

    public String format(Timestamp timestamp, int n) {
        return this.format(timestamp, n, 7);
    }

    public abstract String format(Timestamp var1, int var2, int var3);

    public abstract Date parse(String var1, int var2, String var3, int var4) throws ParseException;

    public Date parse(String string, int n) throws ParseException {
        return this.parse(string, n, 7);
    }

    public abstract Date parse(String var1, int var2, int var3) throws ParseException;

    public void setTimeZone(TimeZone timeZone) {
        this.mCalendar.setTimeZone(timeZone);
    }

    public void setTimeZone(String string) {
        this.setTimeZone(TimeZone.getTimeZone(string));
    }

    public void setCalendar(Calendar calendar) {
        this.mCalendar = calendar;
    }

    public void setLenient(boolean bl) {
        this.mCalendar.setLenient(bl);
    }

    public boolean isLenient() {
        return this.mCalendar.isLenient();
    }
}

