/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DecimalFormatSymbols;
import oracle.apps.fnd.i18n.common.text.DigitList;
import oracle.apps.fnd.i18n.common.text.FieldPosition;
import oracle.apps.fnd.i18n.common.text.NumberFormat;
import oracle.apps.fnd.i18n.common.text.ParsePosition;

public class DecimalFormat
extends NumberFormat {
    public static final String RCS_ID = "$Header: DecimalFormat.java 120.7 2010/02/25 03:41:51 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DecimalFormat.java 120.7 2010/02/25 03:41:51 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    private static Hashtable m_CachedLocaleData = new Hashtable(3);
    private static Hashtable m_CachedConvertedPatternOracleToJava = new Hashtable(10);
    private DecimalFormatSymbols m_Symbols = null;
    private int m_GroupingSize = 3;
    private int m_SecondGroupingSize = 3;
    private int m_Multiplier = 1;
    private int m_Divider = 1;
    private int m_Scale = 0;
    private boolean m_DecimalSeparatorAlwaysShown = false;
    private transient boolean m_IsCurrencyFormat = false;
    private int m_RoundingMode = 6;
    private boolean m_UseExponentialNotation;
    private boolean m_UseExponentialSign = false;
    private byte m_MinExponentDigits;
    private transient DigitList m_DigitList = new DigitList();
    private String m_PositivePrefix = "";
    private String m_PositiveSuffix = "";
    private String m_NegativePrefix = "-";
    private String m_NegativeSuffix = "";
    private String m_PosPrefixPattern;
    private String m_PosSuffixPattern;
    private String m_NegPrefixPattern;
    private String m_NegSuffixPattern;
    private String m_OriginalPattern;
    private boolean m_IgnorePrefix = false;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char PATTERN_PLUS = '+';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static final int DOUBLE_INTEGER_DIGITS = 309;
    private static final int DOUBLE_FRACTION_DIGITS = 340;
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private static final int SCALE_SIZE = 3;

    public DecimalFormat() {
        this(Locale.getDefault());
    }

    public DecimalFormat(int n, String string) {
        this(n, string, Locale.getDefault());
    }

    public DecimalFormat(Locale locale) {
        String string = (String)m_CachedLocaleData.get(locale);
        if (string == null) {
            java.text.NumberFormat numberFormat = java.text.NumberFormat.getNumberInstance(locale);
            string = ((java.text.DecimalFormat)numberFormat).toPattern();
            m_CachedLocaleData.put(locale, string);
        }
        this.m_Symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(11, string, false);
    }

    public DecimalFormat(int n, String string, Locale locale) {
        this.m_Symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(n, string, false);
    }

    public DecimalFormat(int n, String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.m_Symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(n, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        if (Double.isNaN(d)) {
            if (fieldPosition.mField == 0) {
                fieldPosition.mBeginIndex = stringBuffer.length();
            }
            stringBuffer.append(this.m_Symbols.mNaN);
            if (fieldPosition.mField == 0) {
                fieldPosition.mEndIndex = stringBuffer.length();
            }
            return stringBuffer;
        }
        boolean bl2 = bl = d * (double)this.m_Multiplier < 0.0 || d == 0.0 && 1.0 / (d * (double)this.m_Multiplier) < 0.0;
        if (bl) {
            d = -d;
        }
        if (this.m_Multiplier != 1) {
            d *= (double)this.m_Multiplier;
        }
        if (this.m_Scale != 0) {
            d /= (double)this.m_Divider;
        }
        if (Double.isInfinite(d)) {
            int n = this.appendAffix(stringBuffer, bl, true);
            if (fieldPosition.mField == 0) {
                fieldPosition.mBeginIndex = stringBuffer.length();
            }
            stringBuffer.append(this.m_Symbols.mInfinity);
            if (fieldPosition.mField == 0) {
                fieldPosition.mEndIndex = stringBuffer.length();
            }
            int n2 = this.appendAffix(stringBuffer, bl, false);
            return stringBuffer;
        }
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(d, this.m_UseExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.m_UseExponentialNotation, this.m_RoundingMode, bl);
            return this.subformat(stringBuffer, fieldPosition, bl, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        boolean bl2 = bl = l * (long)this.m_Multiplier < 0L;
        if (bl) {
            l = -l;
        }
        if (this.m_Multiplier != 1 && this.m_Multiplier != 0) {
            long l2;
            boolean bl3 = false;
            if (l < 0L) {
                l2 = Long.MIN_VALUE / (long)Math.abs(this.m_Multiplier);
                bl3 = l < l2;
            } else {
                l2 = Long.MAX_VALUE / (long)Math.abs(this.m_Multiplier);
                boolean bl4 = bl3 = l > l2;
            }
            if (bl3) {
                double d = bl ? -l : l;
                return this.format(d, stringBuffer, fieldPosition);
            }
        }
        if (this.m_Scale != 0) {
            long l3 = bl ? -l : l;
            return this.format(BigDecimal.valueOf(l3), stringBuffer, fieldPosition);
        }
        l *= (long)this.m_Multiplier;
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(l, this.m_UseExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : 0, this.m_RoundingMode);
            return this.subformat(stringBuffer, fieldPosition, bl, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.m_Multiplier != 1) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(this.m_Multiplier));
        }
        if (this.m_Scale != 0) {
            bigDecimal = bigDecimal.movePointLeft(this.m_Scale);
        }
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(bigDecimal, this.m_UseExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.m_UseExponentialNotation, this.m_RoundingMode);
            return this.subformat(stringBuffer, fieldPosition, bigDecimal.signum() < 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.m_Scale != 0) {
            return this.format(new BigDecimal(bigInteger), stringBuffer, fieldPosition);
        }
        if (this.m_Multiplier != 1) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(this.m_Multiplier));
        }
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(bigInteger, this.m_UseExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : 0, this.m_RoundingMode);
            return this.subformat(stringBuffer, fieldPosition, bigInteger.signum() < 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.mIndex, this.m_Symbols.mNaN, 0, this.m_Symbols.mNaN.length())) {
            parsePosition.mIndex += this.m_Symbols.mNaN.length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            if (!this.subparse(string, parsePosition, this.m_DigitList, false, blArray)) {
                return null;
            }
            Number number = null;
            if (blArray[0]) {
                number = new Double(blArray[1] ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
            } else if (!blArray[1] && this.m_DigitList.isZero()) {
                number = new Double(-0.0);
            } else {
                int n = this.m_Multiplier;
                while (n % 10 == 0) {
                    --this.m_DigitList.mDecimalAt;
                    n /= 10;
                }
                int n2 = this.m_Divider;
                while (n2 % 10 == 0) {
                    ++this.m_DigitList.mDecimalAt;
                    n2 /= 10;
                }
                if (n == 1 && this.m_DigitList.isIntegral()) {
                    BigInteger bigInteger = this.m_DigitList.getBigInteger(blArray[1]);
                    number = bigInteger.bitLength() < 64 ? new Long(bigInteger.longValue()) : bigInteger;
                } else {
                    BigDecimal bigDecimal = this.m_DigitList.getBigDecimal(blArray[1]);
                    number = bigDecimal;
                    if (n != 1) {
                        number = bigDecimal.divide(BigDecimal.valueOf(n), this.m_RoundingMode);
                    }
                }
            }
            return number;
        }
    }

    public void applyPattern(int n, String string) {
        this.applyPattern(n, string, false);
    }

    public void setMaximumIntegerDigits(int n) {
        super.setMaximumIntegerDigits(Math.min(n, 309));
    }

    public void setMinimumIntegerDigits(int n) {
        super.setMinimumIntegerDigits(Math.min(n, 309));
    }

    public void setMaximumFractionDigits(int n) {
        super.setMaximumFractionDigits(Math.min(n, 340));
    }

    public void setMinimumFractionDigits(int n) {
        super.setMinimumFractionDigits(Math.min(n, 340));
    }

    public void setRoundingMode(int n) {
        this.m_RoundingMode = n;
    }

    public int getRoundingMode() {
        return this.m_RoundingMode;
    }

    public int getGroupingSize() {
        return this.getFirstGroupingSize();
    }

    public int getFirstGroupingSize() {
        return this.m_GroupingSize;
    }

    public int getSecondGroupingSize() {
        return this.m_SecondGroupingSize;
    }

    public void setGroupingSize(int n) {
        this.setFirstGroupingSize(n);
        this.setSecondGroupingSize(n);
    }

    public void setFirstGroupingSize(int n) {
        this.m_GroupingSize = (byte)n;
    }

    public void setSecondGroupingSize(int n) {
        this.m_SecondGroupingSize = (byte)n;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.m_Symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.m_Symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            this.expandAffixes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.m_PositivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.m_PositivePrefix = string;
        this.m_PosPrefixPattern = null;
    }

    public String getNegativePrefix() {
        return this.m_NegativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.m_NegativePrefix = string;
        this.m_NegPrefixPattern = null;
    }

    public String getPositiveSuffix() {
        return this.m_PositiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.m_PositiveSuffix = string;
        this.m_PosSuffixPattern = null;
    }

    public String getNegativeSuffix() {
        return this.m_NegativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.m_NegativeSuffix = string;
        this.m_NegSuffixPattern = null;
    }

    public int getMultiplier() {
        return this.m_Multiplier;
    }

    public void setMultiplier(int n) {
        this.m_Multiplier = n;
    }

    public int getScale() {
        return this.m_Scale;
    }

    public void setScale(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative scale");
        }
        this.m_Scale = n;
        int n2 = 1;
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                n2 *= 10;
            }
        }
        this.m_Divider = n2;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.m_DecimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.m_DecimalSeparatorAlwaysShown = bl;
    }

    void ignorePrefixWhenParsing(boolean bl) {
        this.m_IgnorePrefix = bl;
    }

    private int appendAffix(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        String string = null;
        string = bl2 ? (bl ? this.m_NegativePrefix : this.m_PositivePrefix) : (bl ? this.m_NegativeSuffix : this.m_PositiveSuffix);
        stringBuffer.append(string);
        return string.length();
    }

    private StringBuffer subformat(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2) {
        int n;
        int n2;
        char c;
        char c2 = this.m_Symbols.mZeroDigit;
        int n3 = c2 - 48;
        char c3 = this.m_Symbols.mGroupingSeparator;
        char c4 = c = this.m_IsCurrencyFormat ? this.m_Symbols.mMonetarySeparator : this.m_Symbols.mDecimalSeparator;
        if (this.m_DigitList.isZero()) {
            this.m_DigitList.mDecimalAt = 0;
        }
        int n4 = stringBuffer.length();
        int n5 = this.appendAffix(stringBuffer, bl, true);
        int n6 = fieldPosition.mField;
        int n7 = stringBuffer.length();
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        if (n6 == 0) {
            fieldPosition.mBeginIndex = n7;
            fieldPosition.mEndIndex = n8;
        } else if (n6 == 1) {
            fieldPosition.mBeginIndex = n9;
            fieldPosition.mEndIndex = n10;
        }
        if (this.m_UseExponentialNotation) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            n2 = this.m_DigitList.mDecimalAt;
            n = this.getMaximumIntegerDigits();
            int n16 = this.getMinimumIntegerDigits();
            if (n > 1 && n > n16) {
                n2 = n2 >= 1 ? (n2 - 1) / n * n : (n2 - n) / n * n;
                n16 = 1;
            } else {
                n2 -= n16;
            }
            int n17 = n16 + this.getMinimumFractionDigits();
            int n18 = n15 = this.m_DigitList.isZero() ? n16 : this.m_DigitList.mDecimalAt - n2;
            if (n17 < n15) {
                n17 = n15;
            }
            if (n17 > (n14 = n15 + this.getMaximumFractionDigits())) {
                n14 = n17;
            }
            if (this.m_DigitList.mCount > (n13 = n15 + this.getMinimumFractionDigits())) {
                n13 = this.m_DigitList.mCount;
            }
            boolean bl3 = false;
            for (n12 = 0; n12 < n14; ++n12) {
                if (n12 == n15) {
                    n8 = stringBuffer.length();
                    stringBuffer.append(c);
                    bl3 = true;
                    n9 = stringBuffer.length();
                }
                if (n12 >= n13) continue;
                stringBuffer.append(n12 < this.m_DigitList.mCount ? (char)(this.m_DigitList.mDigits[n12] + n3) : c2);
            }
            if (n8 == -1) {
                n8 = stringBuffer.length();
            }
            if (n9 == -1) {
                n9 = stringBuffer.length();
            }
            if (n6 == 0) {
                fieldPosition.mEndIndex = n8;
            } else if (n6 == 1) {
                fieldPosition.mBeginIndex = n9;
                fieldPosition.mEndIndex = n9;
            }
            stringBuffer.append(this.m_Symbols.mExponential);
            if (this.m_DigitList.isZero()) {
                n2 = 0;
            }
            int n19 = n12 = n2 < 0 ? 1 : 0;
            if (n12 != 0) {
                n2 = -n2;
                stringBuffer.append(this.m_NegativePrefix);
            } else {
                stringBuffer.append(this.m_PositivePrefix);
                if (this.m_UseExponentialSign && ("".equals(this.m_PositivePrefix) || this.m_PositivePrefix.length() == 0)) {
                    stringBuffer.append(this.m_Symbols.mPlusSign);
                }
            }
            this.m_DigitList.set(n2, this.m_RoundingMode);
            for (n11 = this.m_DigitList.mDecimalAt; n11 < this.m_MinExponentDigits; ++n11) {
                stringBuffer.append(c2);
            }
            for (n11 = 0; n11 < this.m_DigitList.mDecimalAt; ++n11) {
                stringBuffer.append(n11 < this.m_DigitList.mCount ? (char)(this.m_DigitList.mDigits[n11] + n3) : c2);
            }
            n10 = stringBuffer.length();
            if (n6 == 1) {
                fieldPosition.mEndIndex = n10;
            }
        } else {
            char c5;
            int n20;
            int n21;
            int n22;
            n2 = this.getMinimumIntegerDigits();
            n = this.m_DigitList.mDecimalAt;
            if (this.m_DigitList.mDecimalAt > 0 && n2 < this.m_DigitList.mDecimalAt) {
                n2 = this.m_DigitList.mDecimalAt;
            }
            if (n2 > (n22 = this.getMaximumIntegerDigits())) {
                n2 = n22;
            }
            int n23 = stringBuffer.length();
            boolean bl4 = this.isGroupingUsed();
            boolean bl5 = false;
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n21 = 1; n21 <= n2; ++n21) {
                int n24 = n20 = bl5 ? this.m_SecondGroupingSize : this.m_GroupingSize;
                if (n > 0) {
                    c5 = (char)(this.m_DigitList.mDigits[--n] + n3);
                    if (n < this.m_DigitList.mCount) {
                        stringBuffer2.insert(0, c5);
                    } else {
                        stringBuffer2.insert(0, c2);
                    }
                    if (!bl4 || n20 == 0 || (n21 - (bl5 ? this.m_GroupingSize : 0)) % n20 != 0 || n21 >= n2) continue;
                    stringBuffer2.insert(0, c3);
                    bl5 = true;
                    continue;
                }
                if (n21 <= n2) {
                    stringBuffer2.insert(0, c2);
                }
                if (!bl4 || n20 == 0 || (n21 - (bl5 ? this.m_GroupingSize : 0)) % n20 != 0 || n21 >= n2) continue;
                stringBuffer2.insert(0, c3);
                bl5 = true;
            }
            stringBuffer.append(stringBuffer2.toString());
            n8 = stringBuffer.length();
            if (n6 == 0) {
                fieldPosition.mEndIndex = n8;
            }
            n = this.m_DigitList.mDecimalAt > 0 ? this.m_DigitList.mDecimalAt : 0;
            n21 = this.getMaximumFractionDigits();
            n20 = this.getMinimumFractionDigits();
            char c6 = c5 = n20 > 0 || !bl2 && n < this.m_DigitList.mCount ? (char)'\u0001' : '\u0000';
            if (c5 == '\u0000' && stringBuffer.length() == n23) {
                stringBuffer.append(c2);
            }
            if (this.m_DecimalSeparatorAlwaysShown || c5 != '\u0000') {
                stringBuffer.append(c);
            }
            n9 = stringBuffer.length();
            if (n6 == 1) {
                fieldPosition.mBeginIndex = n9;
                fieldPosition.mEndIndex = n9;
            }
            for (int i = 0; i < n21 && (i < n20 || !bl2 && n < this.m_DigitList.mCount); ++i) {
                if (-1 - i > this.m_DigitList.mDecimalAt - 1) {
                    stringBuffer.append(c2);
                    continue;
                }
                if (!bl2 && n < this.m_DigitList.mCount) {
                    stringBuffer.append((char)(this.m_DigitList.mDigits[n++] + n3));
                    continue;
                }
                stringBuffer.append(c2);
            }
        }
        n10 = stringBuffer.length();
        if (n6 == 1) {
            fieldPosition.mEndIndex = n10;
        }
        n2 = stringBuffer.length();
        n = this.appendAffix(stringBuffer, bl, false);
        return stringBuffer;
    }

    private void applyPattern(int n, String string, boolean bl) {
        int n2 = 48;
        int n3 = 44;
        int n4 = 46;
        int n5 = 37;
        int n6 = 8240;
        int n7 = 35;
        int n8 = 59;
        int n9 = 69;
        int n10 = 45;
        char c = '+';
        this.m_OriginalPattern = string;
        if (n == 10) {
            string = DecimalFormat.getJavaNumberFormatFromOracle(string);
        }
        if (bl) {
            n2 = this.m_Symbols.mZeroDigit;
            n3 = this.m_Symbols.mGroupingSeparator;
            n4 = this.m_Symbols.mDecimalSeparator;
            n5 = this.m_Symbols.mPercent;
            n6 = this.m_Symbols.mPerMill;
            n7 = this.m_Symbols.mDigit;
            n8 = this.m_Symbols.mPatternSeparator;
            n9 = Character.toUpperCase(this.m_Symbols.mExponential);
            n10 = this.m_Symbols.mMinusSign;
            c = this.m_Symbols.mPlusSign;
        }
        boolean bl2 = false;
        this.m_DecimalSeparatorAlwaysShown = false;
        this.m_IsCurrencyFormat = false;
        this.m_UseExponentialNotation = false;
        this.m_UseExponentialSign = false;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (int i = 1; i >= 0 && n13 < string.length(); --i) {
            int n14;
            int n15;
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n16 = -1;
            int n17 = 1;
            int n18 = 0;
            boolean bl4 = true;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = -1;
            int n23 = -1;
            boolean bl5 = false;
            int n24 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            block5: for (n15 = n13; n15 < string.length(); ++n15) {
                n14 = string.charAt(n15);
                switch (n24) {
                    case 0: 
                    case 2: {
                        if (bl3) {
                            if (n14 == 39) {
                                if (n15 + 1 < string.length() && string.charAt(n15 + 1) == '\'') {
                                    ++n15;
                                    stringBuffer3.append("''");
                                    continue block5;
                                }
                                bl3 = false;
                                continue block5;
                            }
                        } else {
                            if (n14 == n7 || n14 == n2 || n14 == n3 || n14 == n4) {
                                n24 = 1;
                                if (i == 1) {
                                    n11 = n15;
                                }
                                --n15;
                                continue block5;
                            }
                            if (n14 == 164) {
                                boolean bl6;
                                boolean bl7 = bl6 = n15 + 1 < string.length() && string.charAt(n15 + 1) == '\u00a4';
                                if (bl6) {
                                    ++n15;
                                }
                                this.m_IsCurrencyFormat = true;
                                stringBuffer3.append(bl6 ? "'\u00a4\u00a4" : "'\u00a4");
                                continue block5;
                            }
                            if (n14 == 39) {
                                if (n15 + 1 < string.length() && string.charAt(n15 + 1) == '\'') {
                                    ++n15;
                                    stringBuffer3.append("''");
                                    continue block5;
                                }
                                bl3 = true;
                                continue block5;
                            }
                            if (n14 == n8) {
                                if (n24 == 0 || i == 0) {
                                    throw new IllegalArgumentException("Unquoted special character '" + (char)n14 + "' in pattern \"" + string + '\"');
                                }
                                n13 = n15 + 1;
                                n15 = string.length();
                                continue block5;
                            }
                            if (n14 == n5) {
                                if (n17 != 1) {
                                    throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                }
                                n17 = 100;
                                stringBuffer3.append("'%");
                                continue block5;
                            }
                            if (n14 == n6) {
                                if (n17 != 1) {
                                    throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                }
                                n17 = 1000;
                                stringBuffer3.append("'\u2030");
                                continue block5;
                            }
                            if (n14 == n10) {
                                stringBuffer3.append("'-");
                                continue block5;
                            }
                        }
                        stringBuffer3.append((char)n14);
                        continue block5;
                    }
                    case 1: {
                        if (i == 1) {
                            ++n12;
                        } else {
                            if (--n12 != 0) continue block5;
                            n24 = 2;
                            stringBuffer3 = stringBuffer2;
                            continue block5;
                        }
                        if (n14 == n7) {
                            if (n20 > 0) {
                                ++n21;
                            } else {
                                ++n19;
                            }
                            if (n22 < 0 || n16 >= 0) continue block5;
                            n22 = (byte)(n22 + 1);
                            continue block5;
                        }
                        if (n14 == n2) {
                            if (n21 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + this.m_OriginalPattern + '\"');
                            }
                            ++n20;
                            if (n22 < 0 || n16 >= 0) continue block5;
                            n22 = (byte)(n22 + 1);
                            continue block5;
                        }
                        if (n14 == n3) {
                            if (n == 12) {
                                if (n15 + 1 < string.length() && string.charAt(n15 + 1) == n3) {
                                    n18 += bl5 ? n22 : 3;
                                    continue block5;
                                }
                                if (n15 + 1 < string.length() && string.charAt(n15 + 1) == n4) {
                                    n18 += bl5 ? n22 : 3;
                                    continue block5;
                                }
                                if (n15 + 1 < string.length() && string.charAt(n15 + 1) == n8) {
                                    n18 += bl5 ? n22 : 3;
                                    continue block5;
                                }
                                if (n15 == string.length() - 1) {
                                    n18 += bl5 ? n22 : 3;
                                    continue block5;
                                }
                                if (bl5) {
                                    n23 = n22;
                                }
                                n22 = 0;
                                bl5 = true;
                                continue block5;
                            }
                            if (bl5) {
                                n23 = n22;
                            }
                            n22 = 0;
                            bl5 = true;
                            continue block5;
                        }
                        if (n14 == n4) {
                            if (n16 >= 0) {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"');
                            }
                            n16 = n19 + n20 + n21;
                            continue block5;
                        }
                        if (n14 == n9 || n14 == Character.toLowerCase((char)n9)) {
                            if (this.m_UseExponentialNotation) {
                                throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + string + '\"');
                            }
                            this.m_UseExponentialNotation = true;
                            if (n15 + 1 < string.length()) {
                                if (string.charAt(n15 + 1) == c) {
                                    this.m_UseExponentialSign = true;
                                    ++n15;
                                } else if (string.charAt(n15 + 1) == n10) {
                                    ++n15;
                                }
                            }
                            this.m_MinExponentDigits = 0;
                            while (++n15 < string.length() && string.charAt(n15) == n2) {
                                this.m_MinExponentDigits = (byte)(this.m_MinExponentDigits + 1);
                                ++n12;
                            }
                            if (n19 + n20 < 1 || this.m_MinExponentDigits < 1) {
                                throw new IllegalArgumentException("Malformed exponential pattern \"" + this.m_OriginalPattern + '\"');
                            }
                            n24 = 2;
                            stringBuffer3 = stringBuffer2;
                            --n15;
                            continue block5;
                        }
                        n24 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n15;
                        --n12;
                        continue block5;
                    }
                }
            }
            if (n20 == 0 && n19 > 0 && n16 >= 0) {
                n15 = n16;
                if (n15 == 0) {
                    ++n15;
                }
                n21 = n19 - n15;
                n19 = n15 - 1;
                n20 = 1;
            }
            if (n16 < 0 && n21 > 0 || n16 >= 0 && (n16 < n19 || n16 > n19 + n20) || n22 == 0 || bl3) {
                throw new IllegalArgumentException("Malformed pattern \"" + this.m_OriginalPattern + '\"');
            }
            if (i == 1) {
                this.m_PosPrefixPattern = stringBuffer.toString();
                this.m_PosSuffixPattern = stringBuffer2.toString();
                this.m_NegPrefixPattern = this.m_PosPrefixPattern;
                this.m_NegSuffixPattern = this.m_PosSuffixPattern;
                n15 = n19 + n20 + n21;
                n14 = n16 >= 0 ? n16 : n15;
                this.setMinimumIntegerDigits(n14 - n19);
                this.setMaximumIntegerDigits(this.m_UseExponentialNotation ? n19 + this.getMinimumIntegerDigits() : 309);
                this.setMaximumFractionDigits(n16 >= 0 ? n15 - n16 : 0);
                this.setMinimumFractionDigits(n16 >= 0 ? n19 + n20 - n16 : 0);
                this.setGroupingUsed(n22 > 0);
                if (n != 12) {
                    this.m_GroupingSize = n22 > 0 ? n22 : 0;
                    this.m_SecondGroupingSize = n23 > 0 && n23 != n22 ? n23 : this.m_GroupingSize;
                } else {
                    int n25 = n22 > 0 ? (n22 == 1 ? 3 : n22) : (this.m_GroupingSize = 0);
                    this.m_SecondGroupingSize = n23 > 0 && n23 != n22 ? (n23 == 1 ? 3 : n23) : this.m_GroupingSize;
                }
                this.setMultiplier(n17);
                this.setScale(n18);
                this.setDecimalSeparatorAlwaysShown(n16 == 0 || n16 == n15);
                continue;
            }
            this.m_NegPrefixPattern = stringBuffer.toString();
            this.m_NegSuffixPattern = stringBuffer2.toString();
            bl2 = true;
        }
        if (string.length() == 0) {
            this.m_PosSuffixPattern = "";
            this.m_PosPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(309);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(340);
        }
        if (!bl2 || this.m_NegPrefixPattern.equals(this.m_PosPrefixPattern) && this.m_NegSuffixPattern.equals(this.m_PosSuffixPattern)) {
            this.m_NegSuffixPattern = this.m_PosSuffixPattern;
            this.m_NegPrefixPattern = "'-" + this.m_PosPrefixPattern;
        }
        this.expandAffixes();
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_PosPrefixPattern != null) {
            this.m_PositivePrefix = this.expandAffix(this.m_PosPrefixPattern, stringBuffer);
        }
        if (this.m_PosSuffixPattern != null) {
            this.m_PositiveSuffix = this.expandAffix(this.m_PosSuffixPattern, stringBuffer);
        }
        if (this.m_NegPrefixPattern != null) {
            this.m_NegativePrefix = this.expandAffix(this.m_NegPrefixPattern, stringBuffer);
        }
        if (this.m_NegSuffixPattern != null) {
            this.m_NegativeSuffix = this.expandAffix(this.m_NegSuffixPattern, stringBuffer);
        }
    }

    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        block6: while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\'') {
                c = string.charAt(n++);
                switch (c) {
                    case '\u00a4': {
                        if (n < string.length() && string.charAt(n) == '\u00a4') {
                            ++n;
                            stringBuffer.append(this.m_Symbols.mIntlCurrencySymbol);
                            continue block6;
                        }
                        stringBuffer.append(this.m_Symbols.mCurrencySymbol);
                        continue block6;
                    }
                    case '%': {
                        c = this.m_Symbols.mPercent;
                        break;
                    }
                    case '\u2030': {
                        c = this.m_Symbols.mPerMill;
                        break;
                    }
                    case '-': {
                        c = this.m_Symbols.mMinusSign;
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean subparse(String string, ParsePosition parsePosition, DigitList digitList, boolean bl, boolean[] blArray) {
        int n = parsePosition.mIndex;
        int n2 = parsePosition.mIndex;
        boolean bl2 = string.regionMatches(n, this.m_PositivePrefix, 0, this.m_PositivePrefix.length());
        boolean bl3 = string.regionMatches(n, this.m_NegativePrefix, 0, this.m_NegativePrefix.length());
        if (bl2 && bl3) {
            if (this.m_PositivePrefix.length() > this.m_NegativePrefix.length()) {
                bl3 = false;
            } else if (this.m_PositivePrefix.length() < this.m_NegativePrefix.length()) {
                bl2 = false;
            }
        }
        if (bl2) {
            n += this.m_PositivePrefix.length();
        } else if (bl3) {
            n += this.m_NegativePrefix.length();
        } else {
            parsePosition.mErrorIndex = n;
            return false;
        }
        blArray[0] = false;
        if (!bl && string.regionMatches(n, this.m_Symbols.mInfinity, 0, this.m_Symbols.mInfinity.length())) {
            n += this.m_Symbols.mInfinity.length();
            blArray[0] = true;
        } else {
            digitList.mCount = 0;
            digitList.mDecimalAt = 0;
            char c = this.m_Symbols.mZeroDigit;
            char c2 = this.m_IsCurrencyFormat ? this.m_Symbols.mMonetarySeparator : this.m_Symbols.mDecimalSeparator;
            char c3 = this.m_Symbols.mGroupingSeparator;
            char c4 = Character.toUpperCase(this.m_Symbols.mExponential);
            char c5 = this.m_Symbols.mPlusSign;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            while (n < string.length()) {
                char c6 = string.charAt(n);
                int n6 = c6 - c;
                if (n6 < 0 || n6 > 9) {
                    n6 = Character.digit(c6, 10);
                }
                if (n6 == 0) {
                    n5 = -1;
                    bl6 = true;
                    if (digitList.mCount == 0) {
                        if (bl4) {
                            --digitList.mDecimalAt;
                        }
                    } else {
                        ++n4;
                        digitList.append((char)(n6 + 48));
                    }
                } else if (n6 > 0 && n6 <= 9) {
                    bl6 = true;
                    ++n4;
                    digitList.append((char)(n6 + 48));
                    n5 = -1;
                } else if (!bl && c6 == c2) {
                    if (this.isParseIntegerOnly() || bl4) break;
                    digitList.mDecimalAt = n4;
                    bl4 = true;
                } else if (!bl && c6 == c3 && this.isGroupingUsed()) {
                    if (bl4) break;
                    n5 = n;
                } else {
                    if (!(bl || c6 != c4 && c6 != Character.toLowerCase(c4) || bl5)) {
                        boolean[] blArray2;
                        DigitList digitList2;
                        ParsePosition parsePosition2;
                        if (n + 1 < string.length() && string.charAt(n + 1) == c5) {
                            ++n;
                        }
                        if (!this.subparse(string, parsePosition2 = new ParsePosition(n + 1), digitList2 = new DigitList(), true, blArray2 = new boolean[2])) break;
                        n = parsePosition2.mIndex;
                        n3 = (int)digitList2.getLong();
                        if (!blArray2[1]) {
                            n3 = -n3;
                        }
                        bl5 = true;
                        break;
                    }
                    if (!bl && c6 == '\'') {
                        while (n < string.length()) {
                            char c7 = string.charAt(n);
                            if (c6 != '\'') {
                                ++n;
                                continue;
                            }
                            break;
                        }
                    } else if (!this.m_IgnorePrefix || bl6) break;
                }
                ++n;
            }
            if (n5 != -1) {
                n = n5;
            }
            if (!bl4) {
                digitList.mDecimalAt = n4;
            }
            digitList.mDecimalAt += n3;
            if (!bl6 && n4 == 0) {
                parsePosition.mIndex = n2;
                parsePosition.mErrorIndex = n2;
                return false;
            }
        }
        if (bl2) {
            bl2 = string.regionMatches(n, this.m_PositiveSuffix, 0, this.m_PositiveSuffix.length());
        }
        if (bl3) {
            bl3 = string.regionMatches(n, this.m_NegativeSuffix, 0, this.m_NegativeSuffix.length());
        }
        if (bl2 && bl3) {
            if (this.m_PositiveSuffix.length() > this.m_NegativeSuffix.length()) {
                bl3 = false;
            } else if (this.m_PositiveSuffix.length() < this.m_NegativeSuffix.length()) {
                bl2 = false;
            }
        }
        if (bl2 == bl3) {
            parsePosition.mErrorIndex = n;
            return false;
        }
        parsePosition.mIndex = n + (bl2 ? this.m_PositiveSuffix.length() : this.m_NegativeSuffix.length());
        blArray[1] = bl2;
        if (parsePosition.mIndex == n2) {
            parsePosition.mErrorIndex = n;
            return false;
        }
        return true;
    }

    private static String getJavaNumberFormatFromOracle(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternOracleToJava.get(string);
        if (string2 == null) {
            String[] stringArray = new String[]{string, new String(), new String()};
            DecimalFormat.convert(stringArray, false);
            string2 = stringArray[1];
            m_CachedConvertedPatternOracleToJava.put(string, string2);
        }
        return string2;
    }

    private static void convert(String[] stringArray, boolean bl) {
        if (stringArray[0] == null || stringArray[0].length() == 0) {
            stringArray[1] = stringArray[2].equals("(xxx)") ? stringArray[1] + ";(" + stringArray[1] + ")" : (stringArray[2].equals("<xxx>") ? stringArray[1] + ";<" + stringArray[1] + ">" : (stringArray[2].equals("xxx-") ? stringArray[1] + ";" + stringArray[1] + "-" : (stringArray[2].equals("xxx+") ? stringArray[1] + "+;" + stringArray[1] + "-" : (stringArray[2].equals("+xxx") ? "+" + stringArray[1] + ";-" + stringArray[1] : stringArray[1] + ";-" + stringArray[1]))));
            return;
        }
        if (stringArray[0].startsWith("L")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + "\u00a4";
            DecimalFormat.convert(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("C")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + "\u00a4\u00a4";
            DecimalFormat.convert(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("$")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + "$";
            DecimalFormat.convert(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith(" ")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + " ";
            DecimalFormat.convert(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("9")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = bl ? stringArray[1] + "0" : stringArray[1] + "#";
            DecimalFormat.convert(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("0")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + "0";
            DecimalFormat.convert(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("G") || stringArray[0].startsWith(",")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + ",";
            DecimalFormat.convert(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("D") || stringArray[0].startsWith(".")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + ".";
            DecimalFormat.convert(stringArray, true);
            return;
        }
        if (stringArray[0].startsWith("EEEE")) {
            stringArray[0] = stringArray[0].substring(4);
            stringArray[1] = stringArray[1] + "E+00";
            DecimalFormat.convert(stringArray, bl);
        } else {
            if (stringArray[0].startsWith("FM")) {
                stringArray[0] = stringArray[0].substring(2);
                DecimalFormat.convert(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("MI")) {
                stringArray[0] = stringArray[0].substring(2);
                stringArray[2] = "xxx-";
                DecimalFormat.convert(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("PR")) {
                stringArray[0] = stringArray[0].substring(2);
                stringArray[2] = "<xxx>";
                DecimalFormat.convert(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("PT")) {
                stringArray[0] = stringArray[0].substring(2);
                stringArray[2] = "(xxx)";
                DecimalFormat.convert(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("S")) {
                stringArray[0] = stringArray[0].substring(1);
                stringArray[2] = stringArray[1].length() > 0 ? "xxx+" : "+xxx";
                DecimalFormat.convert(stringArray, bl);
                return;
            }
        }
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.m_PositivePrefix.hashCode();
    }

    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.m_Symbols = (DecimalFormatSymbols)this.m_Symbols.clone();
            decimalFormat.m_DigitList = (DigitList)this.m_DigitList.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return (this.m_PosPrefixPattern == decimalFormat.m_PosPrefixPattern && this.m_PositivePrefix.equals(decimalFormat.m_PositivePrefix) || this.m_PosPrefixPattern != null && this.m_PosPrefixPattern.equals(decimalFormat.m_PosPrefixPattern)) && (this.m_PosSuffixPattern == decimalFormat.m_PosSuffixPattern && this.m_PositiveSuffix.equals(decimalFormat.m_PositiveSuffix) || this.m_PosSuffixPattern != null && this.m_PosSuffixPattern.equals(decimalFormat.m_PosSuffixPattern)) && (this.m_NegPrefixPattern == decimalFormat.m_NegPrefixPattern && this.m_NegativePrefix.equals(decimalFormat.m_NegativePrefix) || this.m_NegPrefixPattern != null && this.m_NegPrefixPattern.equals(decimalFormat.m_NegPrefixPattern)) && (this.m_NegSuffixPattern == decimalFormat.m_NegSuffixPattern && this.m_NegativeSuffix.equals(decimalFormat.m_NegativeSuffix) || this.m_NegSuffixPattern != null && this.m_NegSuffixPattern.equals(decimalFormat.m_NegSuffixPattern)) && this.m_Multiplier == decimalFormat.m_Multiplier && this.m_GroupingSize == decimalFormat.m_GroupingSize && this.m_SecondGroupingSize == decimalFormat.m_SecondGroupingSize && this.m_Divider == decimalFormat.m_Divider && this.m_Scale == decimalFormat.m_Scale && this.m_DecimalSeparatorAlwaysShown == decimalFormat.m_DecimalSeparatorAlwaysShown && this.m_UseExponentialNotation == decimalFormat.m_UseExponentialNotation && this.m_UseExponentialSign == decimalFormat.m_UseExponentialSign && (!this.m_UseExponentialNotation || this.m_MinExponentDigits == decimalFormat.m_MinExponentDigits) && this.m_Symbols.equals(decimalFormat.m_Symbols);
    }

    public String toPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i >= 0; --i) {
            int n;
            if (i == 1) {
                this.appendAffixPattern(stringBuffer, this.m_PosPrefixPattern, this.m_PositivePrefix);
            } else {
                this.appendAffixPattern(stringBuffer, this.m_NegPrefixPattern, this.m_NegativePrefix);
            }
            int n2 = this.m_UseExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.m_GroupingSize == this.m_SecondGroupingSize ? this.m_GroupingSize : this.m_GroupingSize + this.m_SecondGroupingSize, this.getMinimumIntegerDigits()) + 1;
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            for (n = 1; n <= n2; ++n) {
                int n3;
                stringBuffer2.insert(0, n <= this.getMinimumIntegerDigits() ? (char)'0' : '#');
                int n4 = n3 = bl ? this.m_SecondGroupingSize : this.m_GroupingSize;
                if (!this.isGroupingUsed() || n3 == 0 || (n - (bl ? this.m_GroupingSize : 0)) % n3 != 0 || n >= n2) continue;
                stringBuffer2.insert(0, ',');
                bl = true;
            }
            stringBuffer.append(stringBuffer2.toString());
            if (this.getMaximumFractionDigits() > 0 || this.m_DecimalSeparatorAlwaysShown) {
                stringBuffer.append('.');
            }
            for (n = 0; n < this.getMaximumFractionDigits(); ++n) {
                if (n < this.getMinimumFractionDigits()) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append('#');
            }
            if (this.m_UseExponentialNotation) {
                stringBuffer.append('E');
                for (n = 0; n < this.m_MinExponentDigits; ++n) {
                    stringBuffer.append('0');
                }
            }
            if (i == 1) {
                this.appendAffixPattern(stringBuffer, this.m_PosSuffixPattern, this.m_PositiveSuffix);
                if ((this.m_NegSuffixPattern == this.m_PosSuffixPattern && this.m_NegativeSuffix.equals(this.m_PositiveSuffix) || this.m_NegSuffixPattern != null && this.m_NegSuffixPattern.equals(this.m_PosSuffixPattern)) && (this.m_NegPrefixPattern != null && this.m_PosPrefixPattern != null && this.m_NegPrefixPattern.equals("'-" + this.m_PosPrefixPattern) || this.m_NegPrefixPattern == this.m_PosPrefixPattern && this.m_NegativePrefix.equals(this.m_Symbols.getMinusSign() + this.m_PositivePrefix))) break;
                stringBuffer.append(';');
                continue;
            }
            this.appendAffixPattern(stringBuffer, this.m_NegSuffixPattern, this.m_NegativeSuffix);
        }
        return stringBuffer.toString();
    }

    private int appendAffixPattern(StringBuffer stringBuffer, String string, String string2) {
        if (string == null) {
            boolean bl = false;
            int n = 0;
            while (n < string2.length()) {
                char c;
                if ((c = string2.charAt(n++)) == '\'') {
                    if (!bl) {
                        bl = true;
                    }
                    stringBuffer.append(c);
                } else if (!bl) {
                    stringBuffer.append("'");
                    bl = true;
                }
                stringBuffer.append(c);
            }
            if (bl) {
                stringBuffer.append("'");
            }
        } else {
            boolean bl = false;
            int n = 0;
            while (n < string.length()) {
                char c;
                if ((c = string.charAt(n++)) == '\'') {
                    char c2;
                    if ((c2 = string.charAt(n++)) == '%' || c2 == '\u2030' || c2 == '#' || c2 == ';' || c2 == ',' || c2 == '.' || c2 == '-' || c2 == '+' || c2 == '\u00a4') {
                        if (c2 == '\u00a4' && n < string.length() && string.charAt(n) == '\u00a4') {
                            ++n;
                            if (bl) {
                                stringBuffer.append("'");
                            }
                            bl = false;
                            stringBuffer.append(c2);
                        }
                        if (bl) {
                            bl = false;
                            stringBuffer.append("'");
                        }
                    } else if (c2 == '\'') {
                        stringBuffer.append(c);
                    } else {
                        stringBuffer.append("'");
                        stringBuffer.append(c);
                        if (!bl) {
                            bl = true;
                        }
                    }
                    stringBuffer.append(c2);
                    continue;
                }
                if (c == '%' || c == '\u2030' || c == '.' || c == '#' || c == ';' || c == ',' || c == '-' || c == '+' || c == '\u00a4') {
                    if (bl) {
                        stringBuffer.append("'");
                    }
                    bl = false;
                    stringBuffer.append(c);
                    continue;
                }
                if (bl) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append("'");
                stringBuffer.append(c);
                if (bl) continue;
                bl = true;
            }
            if (bl) {
                stringBuffer.append("'");
            }
        }
        return stringBuffer.length();
    }
}

