/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.CalendarFormatter;
import oracle.apps.fnd.i18n.common.text.DateFormatSymbols;
import oracle.apps.fnd.i18n.common.text.SimpleDateFormat;
import oracle.apps.fnd.i18n.common.text.resources.CalendarResourceAccessor;

class DefaultCalendarFormatter
extends CalendarFormatter {
    public static final String RCS_ID = "$Header: DefaultCalendarFormatter.java 120.1 2005/06/03 01:24:29 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultCalendarFormatter.java 120.1 2005/06/03 01:24:29 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    private static final int RESOURCE_ORACLE = 9;
    private static final int RESOURCE_JAVA = 7;
    private static final int RESOURCE_DEFAULT = 7;
    private SimpleDateFormat m_SimpleDateFormat;
    private Locale m_Locale;

    DefaultCalendarFormatter(Locale locale) {
        this(locale, 7);
    }

    DefaultCalendarFormatter(TimeZone timeZone, Locale locale) {
        this(timeZone, locale, 7);
    }

    DefaultCalendarFormatter(Locale locale, int n) {
        this(TimeZone.getDefault(), locale, n);
    }

    DefaultCalendarFormatter(TimeZone timeZone, Locale locale, int n) {
        this.m_Locale = locale;
        this.m_SimpleDateFormat = new SimpleDateFormat(11, "dd mm yyyy", new DateFormatSymbols(locale, n));
        this.m_SimpleDateFormat.setTimeZone(timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date, int n) {
        SimpleDateFormat simpleDateFormat = this.m_SimpleDateFormat;
        synchronized (simpleDateFormat) {
            this.m_SimpleDateFormat.applyPattern(11, CalendarResourceAccessor.getDateTimeFormatMask(n, this.m_Locale));
            return this.m_SimpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Timestamp timestamp, int n) {
        SimpleDateFormat simpleDateFormat = this.m_SimpleDateFormat;
        synchronized (simpleDateFormat) {
            this.m_SimpleDateFormat.applyPattern(11, CalendarResourceAccessor.getDateTimeFormatMask(n, this.m_Locale));
            return this.m_SimpleDateFormat.format(timestamp);
        }
    }
}

