/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.CheckNumberFormatter;
import oracle.apps.fnd.i18n.common.text.DigitList;
import oracle.apps.fnd.i18n.common.text.resources.CheckNumberResourceAccessor;

class DefaultCheckNumberFormatter
extends CheckNumberFormatter {
    public static final String RCS_ID = "$Header: DefaultCheckNumberFormatter.java 120.4 2013/02/15 18:10:56 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultCheckNumberFormatter.java 120.4 2013/02/15 18:10:56 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    private static final Integer INDEX_DATA = new Integer(10);
    private static final Integer LINES_DATA = new Integer(20);
    private static final int CACHE_SIZE = 1000;
    private static final String DEFAULT_RULE_NAME = "default";
    private static final String NEGATIVE_RULE_NAME = "minus";
    private static final String DECIMAL_RULE_NAME = "decimal";
    private Hashtable m_ToWordsRule;
    private CheckNumberResourceAccessor m_Resource;
    private Locale m_Locale;
    private int m_CaseStyle;
    private int m_DecimalStyle;
    private int m_IntegerStyle = 100;
    private boolean m_IsChinese = false;
    private int m_RoundingMode = 6;

    DefaultCheckNumberFormatter(Locale locale, int n) {
        this.init(locale, n);
    }

    public String format(BigDecimal bigDecimal, int n) {
        if (bigDecimal.longValue() > Long.MAX_VALUE || bigDecimal.longValue() < Long.MIN_VALUE) {
            throw new IllegalArgumentException("The number given, " + bigDecimal.toString() + ", is too big or too small. " + "The number has to be smaller than Long.MAX_VALUE, and bigger than Long.MIN_VALUE");
        }
        BigDecimal bigDecimal2 = this.applyRounding(bigDecimal, n, this.m_RoundingMode);
        long l = bigDecimal2.longValue();
        long l2 = 0L;
        BigDecimal bigDecimal3 = bigDecimal2.subtract(BigDecimal.valueOf(l)).abs();
        if (bigDecimal3.signum() > 0) {
            bigDecimal3 = bigDecimal3.movePointRight(n);
            try {
                l2 = Long.parseLong(bigDecimal3.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The given number, " + bigDecimal.toString() + ", has more decimal digit than the given precision.");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.m_IntegerStyle == 200) {
                if (n > 0) {
                    if (this.m_DecimalStyle != 40) {
                        if (this.m_DecimalStyle == 20) {
                            this.toWords(l2, stringBuffer, DECIMAL_RULE_NAME);
                        } else if (this.m_DecimalStyle == 30) {
                            stringBuffer.append(l2);
                        } else {
                            this.toFraction(l2, stringBuffer, n, this.m_DecimalStyle);
                        }
                    }
                } else if (l2 != 0L) {
                    throw new IllegalArgumentException("The given number has decimal value although the precision is 0.");
                }
            } else {
                this.toWords(l, stringBuffer, DEFAULT_RULE_NAME);
                if (n > 0 || this.m_IsChinese) {
                    if (this.m_DecimalStyle != 40) {
                        stringBuffer.append(this.m_Resource.getAndData());
                        if (this.m_DecimalStyle == 20) {
                            this.toWords(l2, stringBuffer, DECIMAL_RULE_NAME);
                        } else if (this.m_DecimalStyle == 30) {
                            stringBuffer.append(l2);
                        } else {
                            this.toFraction(l2, stringBuffer, n, this.m_DecimalStyle);
                        }
                    }
                } else if (l2 != 0L) {
                    throw new IllegalArgumentException("The given number has decimal value although the precision is 0.");
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return this.applyCase(stringBuffer.toString().trim());
    }

    public void setDecimalStyle(int n) {
        this.m_Resource = CheckNumberResourceAccessor.getInstance(this.m_Locale, n);
        this.m_DecimalStyle = this.m_Resource.getDecimalStyle();
    }

    public void setIntegerStyle(int n) {
        this.m_IntegerStyle = n;
    }

    public void setRoundingMode(int n) {
        this.m_RoundingMode = n;
    }

    private void init(Locale locale, int n) {
        this.m_Locale = locale;
        this.m_CaseStyle = n;
        this.m_Resource = CheckNumberResourceAccessor.getInstance(locale);
        this.m_DecimalStyle = this.m_Resource.getDecimalStyle();
        if ("zh".equals(this.m_Resource.getLocale().getLanguage())) {
            this.m_IsChinese = true;
        }
        Hashtable hashtable = this.m_Resource.getRuleDefinition();
        try {
            this.initRule(hashtable);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void initRule(Hashtable hashtable) throws Exception {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = (String[])hashtable.get(string);
            Hashtable<Integer, Cloneable> hashtable3 = new Hashtable<Integer, Cloneable>();
            hashtable2.put(string, hashtable3);
            Vector<RuleDefinition> vector = new Vector<RuleDefinition>();
            Hashtable<Long, Hashtable<Long, RuleDefinition>> hashtable4 = new Hashtable<Long, Hashtable<Long, RuleDefinition>>();
            hashtable3.put(LINES_DATA, vector);
            hashtable3.put(INDEX_DATA, hashtable4);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                String string2 = stringArray[i];
                RuleDefinition ruleDefinition = new RuleDefinition(string2, string);
                vector.addElement(ruleDefinition);
                Hashtable<Long, RuleDefinition> hashtable5 = (Hashtable<Long, RuleDefinition>)hashtable4.get(new Long(ruleDefinition.mDigit));
                if (hashtable5 == null) {
                    hashtable5 = new Hashtable<Long, RuleDefinition>();
                    hashtable4.put(new Long(ruleDefinition.mDigit), hashtable5);
                }
                hashtable5.put(new Long(ruleDefinition.mNumber), ruleDefinition);
            }
        }
        this.m_ToWordsRule = hashtable2;
    }

    private void toFraction(long l, StringBuffer stringBuffer, int n, int n2) {
        String string = this.m_Resource.getZeroString();
        if (n2 == 10) {
            if (n > 0) {
                if (l == 0L) {
                    int n3;
                    for (n3 = 0; n3 < n; ++n3) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append("/1");
                    for (n3 = 0; n3 < n; ++n3) {
                        stringBuffer.append("0");
                    }
                } else {
                    stringBuffer.append(Long.toString(l));
                    stringBuffer.append("/1");
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append("0");
                    }
                }
            }
        } else if (n > 0) {
            if (l == 0L) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(string);
                }
            } else {
                String string2 = Long.toString(l);
                if (string2.length() < n) {
                    for (int i = 0; i < n - string2.length(); ++i) {
                        stringBuffer.append(string);
                    }
                }
                stringBuffer.append(string2);
            }
        }
    }

    private void toWords(long l, StringBuffer stringBuffer, String string) throws Exception {
        if (l < 0L) {
            this.toWords(0L - l, stringBuffer, NEGATIVE_RULE_NAME);
        } else {
            Object object;
            Hashtable hashtable = (Hashtable)this.m_ToWordsRule.get(string);
            if (hashtable == null || hashtable.size() == 0) {
                throw new Exception("No rule is found: " + string);
            }
            int n = this.countDigit(l);
            Hashtable hashtable2 = (Hashtable)hashtable.get(INDEX_DATA);
            Hashtable<Long, RuleDefinition> hashtable3 = (Hashtable<Long, RuleDefinition>)hashtable2.get(new Long(n));
            if (hashtable3 != null && (object = (RuleDefinition)hashtable3.get(new Long(l))) != null) {
                if (((RuleDefinition)object).mElems.mJustFormat) {
                    stringBuffer.append(((RuleDefinition)object).mElems.mFormattedString);
                    return;
                }
                RuleDefinition ruleDefinition = ((RuleDefinition)object).cloneRuleDefinition();
                ruleDefinition.mNumber = l;
                StringBuffer stringBuffer2 = new StringBuffer();
                this.applyRule(stringBuffer2, l, ((RuleDefinition)object).mPow, ((RuleDefinition)object).mElems);
                ruleDefinition.mElems.mFormattedString = stringBuffer2.toString();
                ruleDefinition.mElems.mJustFormat = true;
                hashtable3.put(new Long(l), ruleDefinition);
                stringBuffer.append(ruleDefinition.mElems.mFormattedString);
                return;
            }
            object = (Vector)hashtable.get(LINES_DATA);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                RuleDefinition ruleDefinition = (RuleDefinition)((Vector)object).elementAt(i);
                if ((long)n < ruleDefinition.mDigit || l < ruleDefinition.mNumber) continue;
                if (l < 1000L) {
                    if (hashtable3 == null) {
                        hashtable3 = new Hashtable<Long, RuleDefinition>();
                        hashtable2.put(new Long(n), hashtable3);
                    }
                    RuleDefinition ruleDefinition2 = ruleDefinition.cloneRuleDefinition();
                    ruleDefinition2.mNumber = l;
                    StringBuffer stringBuffer3 = new StringBuffer();
                    this.applyRule(stringBuffer3, l, ruleDefinition.mPow, ruleDefinition.mElems);
                    ruleDefinition2.mElems.mFormattedString = stringBuffer3.toString();
                    ruleDefinition2.mElems.mJustFormat = true;
                    hashtable3.put(new Long(l), ruleDefinition2);
                    stringBuffer.append(ruleDefinition2.mElems.mFormattedString);
                    return;
                }
                if (ruleDefinition.mElems.mJustFormat) {
                    stringBuffer.append(ruleDefinition.mElems.mFormattedString);
                    return;
                }
                this.applyRule(stringBuffer, l, ruleDefinition.mPow, ruleDefinition.mElems);
                return;
            }
        }
    }

    private void applyRule(StringBuffer stringBuffer, long l, long l2, RuleDefElems ruleDefElems) throws Exception {
        if (ruleDefElems.mHasFormatRule) {
            if (ruleDefElems.mFormatRuleName.indexOf("#") != -1) {
                DecimalFormat decimalFormat = new DecimalFormat(ruleDefElems.mFormatRuleName, this.m_Resource.getDecimalFormatSymbols());
                stringBuffer.append(decimalFormat.format(l));
            } else {
                stringBuffer.append(ruleDefElems.mPrefix);
                stringBuffer.append(ruleDefElems.mBody);
                this.toWords(l, stringBuffer, ruleDefElems.mFormatRuleName);
                stringBuffer.append(ruleDefElems.mSuffix);
            }
        } else {
            long l3;
            stringBuffer.append(ruleDefElems.mPrefix);
            if (ruleDefElems.mHasPrefixRule) {
                l3 = l / l2;
                this.toWords(l3, stringBuffer, ruleDefElems.mPrefixRuleName);
            }
            stringBuffer.append(ruleDefElems.mBody);
            if (ruleDefElems.mHasSuffixRule) {
                l3 = l % l2;
                if (ruleDefElems.mIsOmitSuffix && l3 == 0L) {
                    stringBuffer.append(ruleDefElems.mAppendableSuffix);
                } else {
                    stringBuffer.append(ruleDefElems.mOmmitableBeforeSuffix);
                    if (this.m_IsChinese && this.countDigit(l2) - 1 > this.countDigit(l3)) {
                        stringBuffer.append("\u96f6");
                    }
                    this.toWords(l3, stringBuffer, ruleDefElems.mSuffixRuleName);
                    stringBuffer.append(ruleDefElems.mOmmitableAfterSuffix);
                }
            }
            stringBuffer.append(ruleDefElems.mSuffix);
        }
    }

    private String applyCase(String string) {
        String string2 = string;
        switch (this.m_CaseStyle) {
            case 10: {
                if (string2.length() > 1) {
                    string2 = string2.substring(0, 1).toUpperCase(this.m_Locale) + string2.substring(1, string2.length());
                    break;
                }
                string2 = string2.toUpperCase(this.m_Locale);
                break;
            }
            case 20: {
                string2 = string2.toUpperCase(this.m_Locale);
                break;
            }
            case 30: {
                break;
            }
        }
        return string2;
    }

    private BigDecimal applyRounding(BigDecimal bigDecimal, int n, int n2) {
        boolean bl = bigDecimal.signum() > 0;
        int n3 = this.countDigit(bigDecimal.longValue());
        DigitList digitList = new DigitList();
        digitList.set(bigDecimal, n3 + n, false, this.m_RoundingMode);
        BigDecimal bigDecimal2 = digitList.getBigDecimal(bl);
        return bigDecimal2;
    }

    private int countDigit(long l) {
        String string = l >= 0L ? Long.toString(l) : Long.toString(-l);
        return string.length();
    }

    private class RuleDefElems {
        String mPrefix;
        String mPrefixRuleName;
        String mBody;
        String mSuffixRuleName;
        String mOmmitableBeforeSuffix;
        String mOmmitableAfterSuffix;
        String mAppendableSuffix;
        String mFormatRuleName;
        boolean mIsOmitSuffix;
        String mSuffix;
        boolean mHasPrefixRule;
        boolean mHasSuffixRule;
        boolean mHasFormatRule;
        String mFormattedString;
        boolean mJustFormat;

        private RuleDefElems() {
        }

        RuleDefElems(String string, String string2) {
            this.init(string, string2);
        }

        private void init(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this.mPrefix = this.handleToken(stringTokenizer);
            this.mPrefixRuleName = this.handleToken(stringTokenizer);
            this.mBody = this.handleToken(stringTokenizer);
            this.mSuffixRuleName = this.handleToken(stringTokenizer);
            this.mOmmitableBeforeSuffix = this.handleToken(stringTokenizer);
            this.mOmmitableAfterSuffix = this.handleToken(stringTokenizer);
            this.mFormatRuleName = this.handleToken(stringTokenizer);
            this.mAppendableSuffix = this.handleToken(stringTokenizer);
            this.mIsOmitSuffix = Boolean.valueOf(this.handleToken(stringTokenizer));
            this.mSuffix = this.handleToken(stringTokenizer);
            this.mFormattedString = this.handleToken(stringTokenizer);
            this.mHasPrefixRule = !"".equals(this.mPrefixRuleName);
            this.mHasSuffixRule = !"".equals(this.mSuffixRuleName);
            this.mHasFormatRule = !"".equals(this.mFormatRuleName);
            this.mJustFormat = !"".equals(this.mFormattedString);
        }

        private String handleToken(StringTokenizer stringTokenizer) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("[") && string.endsWith("]")) {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }

        RuleDefElems cloneRuleDefElems() {
            RuleDefElems ruleDefElems = new RuleDefElems();
            ruleDefElems.mPrefix = this.mPrefix;
            ruleDefElems.mPrefixRuleName = this.mPrefixRuleName;
            ruleDefElems.mBody = this.mBody;
            ruleDefElems.mSuffixRuleName = this.mSuffixRuleName;
            ruleDefElems.mAppendableSuffix = this.mAppendableSuffix;
            ruleDefElems.mOmmitableBeforeSuffix = this.mOmmitableBeforeSuffix;
            ruleDefElems.mOmmitableAfterSuffix = this.mOmmitableAfterSuffix;
            ruleDefElems.mFormatRuleName = this.mFormatRuleName;
            ruleDefElems.mIsOmitSuffix = this.mIsOmitSuffix;
            ruleDefElems.mSuffix = this.mSuffix;
            ruleDefElems.mHasPrefixRule = this.mHasPrefixRule;
            ruleDefElems.mHasSuffixRule = this.mHasSuffixRule;
            ruleDefElems.mHasFormatRule = this.mHasFormatRule;
            ruleDefElems.mFormattedString = this.mFormattedString;
            ruleDefElems.mJustFormat = this.mJustFormat;
            return ruleDefElems;
        }

        void printData(StringBuffer stringBuffer) {
            String string = System.getProperty("line.separator");
            stringBuffer.append("prefix: '" + this.mPrefix + "'" + string);
            stringBuffer.append("prefixRuleName: '" + this.mPrefixRuleName + "'" + string);
            stringBuffer.append("main: '" + this.mBody + "'" + string);
            stringBuffer.append("suffixRuleName: '" + this.mSuffixRuleName + "'" + string);
            stringBuffer.append("ommitableBeforeSuffix: '" + this.mOmmitableBeforeSuffix + "'" + string);
            stringBuffer.append("ommitableAfterSuffix: '" + this.mOmmitableAfterSuffix + "'" + string);
            stringBuffer.append("formatRuleName: '" + this.mFormatRuleName + "'" + string);
            stringBuffer.append("appendableSuffix: '" + this.mAppendableSuffix + "'" + string);
            stringBuffer.append("isOmitSuffix: '" + this.mIsOmitSuffix + "'" + string);
            stringBuffer.append("suffix: '" + this.mSuffix + "'" + string);
            stringBuffer.append("hasPrefixRule: " + this.mHasPrefixRule + string);
            stringBuffer.append("hasSuffixRule: " + this.mHasSuffixRule + string);
            stringBuffer.append("hasFormatRule: " + this.mHasFormatRule + string);
            stringBuffer.append("formattedString: " + this.mFormattedString + string);
            stringBuffer.append("justFormat?: " + this.mJustFormat + string);
        }
    }

    private class RuleDefinition {
        long mNumber;
        long mPow;
        long mDigit;
        RuleDefElems mElems;

        private RuleDefinition() {
        }

        RuleDefinition(String string, String string2) {
            this.init(string, string2);
        }

        private void init(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "/");
            this.mNumber = Long.valueOf((String)stringTokenizer2.nextElement());
            this.mPow = Long.valueOf((String)stringTokenizer2.nextElement());
            this.mDigit = Long.valueOf((String)stringTokenizer2.nextElement());
            this.mElems = new RuleDefElems(string4, string2);
        }

        RuleDefinition cloneRuleDefinition() {
            RuleDefinition ruleDefinition = new RuleDefinition();
            ruleDefinition.mNumber = this.mNumber;
            ruleDefinition.mPow = this.mPow;
            ruleDefinition.mDigit = this.mDigit;
            ruleDefinition.mElems = this.mElems.cloneRuleDefElems();
            return ruleDefinition;
        }

        String printData() {
            String string = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("number: '" + this.mNumber + "'" + string);
            stringBuffer.append("pow: '" + this.mPow + "'" + string);
            stringBuffer.append("digit: '" + this.mDigit + "'" + string);
            stringBuffer.append("elements:" + string);
            this.mElems.printData(stringBuffer);
            return stringBuffer.toString();
        }
    }
}

