/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DateFormatSymbols;
import oracle.apps.fnd.i18n.common.text.DateFormatter;
import oracle.apps.fnd.i18n.common.text.SimpleDateFormat;
import oracle.apps.fnd.i18n.common.text.resources.CalendarResourceAccessor;
import oracle.apps.fnd.i18n.common.text.resources.DateResourceAccessor;
import oracle.apps.fnd.i18n.common.util.Calendar;

class DefaultDateFormatter
extends DateFormatter {
    public static final String RCS_ID = "$Header: DefaultDateFormatter.java 120.5 2011/06/27 19:06:47 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultDateFormatter.java 120.5 2011/06/27 19:06:47 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    private static final int CACHE_SIZE = 100;
    private Hashtable m_CachedDateFormat = new Hashtable(100);
    private static Hashtable m_CachedDateFormatSymbols = new Hashtable(100);
    private Locale m_Locale;

    DefaultDateFormatter(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    DefaultDateFormatter(TimeZone timeZone, Locale locale) {
        this.m_Locale = locale;
        this.mCalendar = Calendar.getInstance(timeZone, locale);
    }

    public String format(Date date, int n, String string, int n2) {
        SimpleDateFormat simpleDateFormat = this.getDateFormat(n, string, n2);
        return simpleDateFormat.format(date);
    }

    public String format(Date date, int n, int n2) {
        SimpleDateFormat simpleDateFormat = this.getDateFormat(11, CalendarResourceAccessor.getDateTimeFormatMask(n, this.m_Locale), n2);
        return simpleDateFormat.format(date);
    }

    public String format(Timestamp timestamp, int n, String string, int n2) {
        SimpleDateFormat simpleDateFormat = this.getDateFormat(n, string, n2);
        return simpleDateFormat.format(timestamp);
    }

    public String format(Timestamp timestamp, int n, int n2) {
        SimpleDateFormat simpleDateFormat = this.getDateFormat(11, CalendarResourceAccessor.getDateTimeFormatMask(n, this.m_Locale), n2);
        return simpleDateFormat.format(timestamp);
    }

    public Date parse(String string, int n, int n2) throws ParseException {
        String string2 = CalendarResourceAccessor.getDateTimeFormatMask(n, this.m_Locale);
        SimpleDateFormat simpleDateFormat = this.getDateFormat(11, string2, n2);
        return simpleDateFormat.parse(string);
    }

    public Date parse(String string, int n, String string2, int n2) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.getDateFormat(n, string2, n2);
        return simpleDateFormat.parse(string);
    }

    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        Enumeration enumeration = this.m_CachedDateFormat.elements();
        while (enumeration.hasMoreElements()) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)enumeration.nextElement();
            simpleDateFormat.setTimeZone(timeZone);
        }
    }

    public void setCalendar(Calendar calendar) {
        Object object;
        Object object2;
        super.setCalendar(calendar);
        switch (calendar.getType()) {
            case 1: {
                object2 = this.m_Locale.getLanguage().toLowerCase(Locale.US);
                object = this.m_Locale.getCountry().toUpperCase(Locale.US);
                if (!((String)object2).equals("ja") && !((String)object2).equals("en") || !((String)object).equals("JP") && !((String)object).equals("")) break;
                this.m_Locale = new Locale((String)object2, (String)object, "JCAL");
                break;
            }
            case 5: {
                object2 = this.m_Locale.getLanguage().toLowerCase(Locale.US);
                object = this.m_Locale.getCountry().toUpperCase(Locale.US);
                if (!((String)object2).equals("zh") && !((String)object2).equals("en") || !((String)object).equals("TW") && !((String)object).equals("")) break;
                this.m_Locale = new Locale((String)object2, (String)object, "ROCCAL");
                break;
            }
        }
        object2 = this.m_CachedDateFormat.elements();
        while (object2.hasMoreElements()) {
            object = (SimpleDateFormat)object2.nextElement();
            ((SimpleDateFormat)object).setCalendar(calendar);
        }
    }

    private synchronized SimpleDateFormat getDateFormat(int n, String string, int n2) {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.m_CachedDateFormat.get(n + string + n2);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(n, string, DefaultDateFormatter.getDateFormatSymbols(this.m_Locale, n2));
            simpleDateFormat.setCalendar(this.mCalendar);
            if (simpleDateFormat.isLocaleCalendarMode()) {
                simpleDateFormat.setTimeZone(this.mCalendar.getTimeZone());
            }
            DateResourceAccessor dateResourceAccessor = DateResourceAccessor.getInstance(this.m_Locale, n2);
            simpleDateFormat.set2DigitYearStart(dateResourceAccessor.get2DigitYearStart());
            this.m_CachedDateFormat.put(n + string + n2, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    private static DateFormatSymbols getDateFormatSymbols(Locale locale, int n) {
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)m_CachedDateFormatSymbols.get(locale.toString() + n);
        if (dateFormatSymbols == null) {
            dateFormatSymbols = new DateFormatSymbols(locale, n);
            m_CachedDateFormatSymbols.put(locale.toString() + n, dateFormatSymbols);
        }
        return dateFormatSymbols;
    }
}

