/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DecimalFormat;
import oracle.apps.fnd.i18n.common.text.DecimalFormatSymbols;
import oracle.apps.fnd.i18n.common.text.NumberFormatter;

class DefaultNumberFormatter
extends NumberFormatter {
    public static final String RCS_ID = "$Header: DefaultNumberFormatter.java 120.0 2005/05/07 08:29:27 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultNumberFormatter.java 120.0 2005/05/07 08:29:27 appldev ship $", "oracle.apps.fnd.i18n.common.text");
    private Hashtable m_CachedDecimalFormat = new Hashtable(100);
    private Locale m_Locale;
    private char m_DecimalSeparator;
    private char m_GroupingSeparator;

    DefaultNumberFormatter(Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        this.m_DecimalSeparator = decimalFormatSymbols.getDecimalSeparator();
        this.m_GroupingSeparator = decimalFormatSymbols.getGroupingSeparator();
        this.m_Locale = locale;
    }

    public String format(double d, int n, String string, char[] cArray) {
        DecimalFormat decimalFormat = this.getDecimalFormat(n, string, cArray);
        return decimalFormat.format(d);
    }

    public String format(long l, int n, String string, char[] cArray) {
        DecimalFormat decimalFormat = this.getDecimalFormat(n, string, cArray);
        return decimalFormat.format(l);
    }

    public String format(BigInteger bigInteger, int n, String string, char[] cArray) {
        DecimalFormat decimalFormat = this.getDecimalFormat(n, string, cArray);
        return decimalFormat.format(bigInteger);
    }

    public String format(BigDecimal bigDecimal, int n, String string, char[] cArray) {
        DecimalFormat decimalFormat = this.getDecimalFormat(n, string, cArray);
        return decimalFormat.format(bigDecimal);
    }

    public String format(Number number, int n, String string, char[] cArray) {
        DecimalFormat decimalFormat = this.getDecimalFormat(n, string, cArray);
        return decimalFormat.format(number);
    }

    public Number parse(String string, int n, String string2, char[] cArray) throws ParseException {
        DecimalFormat decimalFormat = this.getDecimalFormat(n, string2, cArray);
        return decimalFormat.parse(string);
    }

    public void setRoundingMode(int n) {
        super.setRoundingMode(n);
        Enumeration enumeration = this.m_CachedDecimalFormat.elements();
        while (enumeration.hasMoreElements()) {
            DecimalFormat decimalFormat = (DecimalFormat)enumeration.nextElement();
            decimalFormat.setRoundingMode(n);
        }
    }

    public void setScale(int n) {
        super.setScale(n);
        Enumeration enumeration = this.m_CachedDecimalFormat.elements();
        while (enumeration.hasMoreElements()) {
            DecimalFormat decimalFormat = (DecimalFormat)enumeration.nextElement();
            decimalFormat.setScale(n);
        }
    }

    private synchronized DecimalFormat getDecimalFormat(int n, String string, char[] cArray) {
        String string2 = n + string;
        string2 = cArray != null ? string2 + cArray[0] + cArray[1] : string2 + this.m_DecimalSeparator + this.m_GroupingSeparator;
        DecimalFormat decimalFormat = (DecimalFormat)this.m_CachedDecimalFormat.get(string2);
        if (decimalFormat == null) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(this.m_Locale);
            if (cArray != null) {
                decimalFormatSymbols.setDecimalSeparator(cArray[0]);
                decimalFormatSymbols.setGroupingSeparator(cArray[1]);
            }
            decimalFormat = new DecimalFormat(n, string, decimalFormatSymbols);
            decimalFormat.setScale(this.mScale);
            decimalFormat.setRoundingMode(this.mRoundingMode);
            this.m_CachedDecimalFormat.put(string2, decimalFormat);
        }
        return decimalFormat;
    }
}

