/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import oracle.apps.fnd.common.VersionInfo;

class DigitList
implements Cloneable {
    public static final String RCS_ID = "$Header: DigitList.java 120.2 2005/09/21 00:27:09 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DigitList.java 120.2 2005/09/21 00:27:09 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    public static final int MAX_LONG_COUNT = 19;
    int mDecimalAt = 0;
    int mCount = 0;
    char[] mDigits = new char[19];
    private static final char[] LONG_MIN_REP = "9223372036854775808".toCharArray();

    DigitList() {
    }

    boolean isZero() {
        for (int i = 0; i < this.mCount; ++i) {
            if (this.mDigits[i] == '0') continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.mDecimalAt = 0;
        this.mCount = 0;
    }

    public void append(char c) {
        this.ensureCapacity(this.mCount + 1, this.mCount);
        this.mDigits[this.mCount++] = c;
    }

    public double getDouble() {
        if (this.mCount == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = new StringBuffer(19);
        stringBuffer.append('.').append(this.mDigits, 0, this.mCount);
        stringBuffer.append('E');
        stringBuffer.append(this.mDecimalAt);
        return Double.valueOf(stringBuffer.toString());
    }

    public long getLong() {
        if (this.mCount == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(19);
        stringBuffer.append(this.mDigits, 0, this.mCount);
        for (int i = this.mCount; i < this.mDecimalAt; ++i) {
            stringBuffer.append('0');
        }
        return Long.parseLong(stringBuffer.toString());
    }

    public BigInteger getBigInteger(boolean bl) {
        int n;
        int n2;
        if (this.isZero()) {
            return BigInteger.valueOf(0L);
        }
        int n3 = n2 = this.mDecimalAt > this.mCount ? this.mDecimalAt : this.mCount;
        if (!bl) {
            ++n2;
        }
        char[] cArray = new char[n2];
        int n4 = 0;
        if (!bl) {
            cArray[0] = 45;
            for (n = 0; n < this.mCount; ++n) {
                cArray[n + 1] = this.mDigits[n];
            }
            n4 = this.mCount + 1;
        } else {
            for (n = 0; n < this.mCount; ++n) {
                cArray[n] = this.mDigits[n];
            }
            n4 = this.mCount;
        }
        for (n = n4; n < cArray.length; ++n) {
            cArray[n] = 48;
        }
        return new BigInteger(new String(cArray));
    }

    public BigDecimal getBigDecimal(boolean bl) {
        int n;
        if (this.isZero()) {
            return BigDecimal.valueOf(0L);
        }
        StringBuffer stringBuffer = new StringBuffer(this.mCount + 1);
        if (!bl) {
            stringBuffer.append('-');
        }
        if ((n = this.mDecimalAt) < 0) {
            stringBuffer.append('.');
            while (n < 0) {
                stringBuffer.append('0');
                ++n;
            }
            n = -1;
        }
        for (int i = 0; i < this.mCount; ++i) {
            if (n == i) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.mDigits[i]);
        }
        while (n-- > this.mCount) {
            stringBuffer.append('0');
        }
        return new BigDecimal(stringBuffer.toString());
    }

    public boolean isIntegral() {
        while (this.mCount > 0 && this.mDigits[this.mCount - 1] == '0') {
            --this.mCount;
        }
        return this.mCount == 0 || this.mDecimalAt >= this.mCount;
    }

    public void set(double d, int n, boolean bl, int n2, boolean bl2) {
        if (d == 0.0) {
            d = 0.0;
        }
        this.mDecimalAt = -1;
        this.mCount = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.set(Double.toString(d), 19);
        if (bl) {
            if (-this.mDecimalAt > n) {
                this.mCount = 0;
                return;
            }
            if (-this.mDecimalAt == n) {
                if (this.shouldRoundUp(0, bl2, n2)) {
                    this.mCount = 1;
                    ++this.mDecimalAt;
                    this.mDigits[0] = 49;
                } else {
                    this.mCount = 0;
                }
                return;
            }
        }
        while (this.mCount > 1 && this.mDigits[this.mCount - 1] == '0') {
            --this.mCount;
        }
        this.round(bl ? n + this.mDecimalAt : n, bl2, n2);
    }

    public void set(long l, int n) {
        this.set(l, 0, n);
    }

    public void set(long l, int n, int n2) {
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                this.mCount = 19;
                this.mDecimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.mDigits, 0, this.mCount);
            } else {
                this.mCount = 0;
                this.mDecimalAt = 0;
            }
        } else {
            int n3 = 19;
            while (l > 0L) {
                this.mDigits[--n3] = (char)(48L + l % 10L);
                l /= 10L;
            }
            this.mDecimalAt = 19 - n3;
            int n4 = 18;
            while (this.mDigits[n4] == '0') {
                --n4;
            }
            this.mCount = n4 - n3 + 1;
            System.arraycopy(this.mDigits, n3, this.mDigits, 0, this.mCount);
        }
        if (n > 0) {
            this.round(n, l < 0L, n2);
        }
    }

    private void round(int n, boolean bl, int n2) {
        if (n >= 0 && n < this.mCount) {
            if (this.shouldRoundUp(n, bl, n2)) {
                do {
                    if (--n < 0) {
                        this.mDigits[0] = 49;
                        ++this.mDecimalAt;
                        n = 0;
                        break;
                    }
                    int n3 = n;
                    this.mDigits[n3] = (char)(this.mDigits[n3] + '\u0001');
                } while (this.mDigits[n] > '9');
                ++n;
            }
            this.mCount = n;
            while (this.mCount > 1 && this.mDigits[this.mCount - 1] == '0') {
                --this.mCount;
            }
        }
    }

    public void set(BigInteger bigInteger, int n, int n2) {
        String string = bigInteger.toString();
        this.mCount = this.mDecimalAt = string.length();
        while (this.mCount > 1 && string.charAt(this.mCount - 1) == '0') {
            --this.mCount;
        }
        int n3 = 0;
        if (string.charAt(0) == '-') {
            ++n3;
            --this.mCount;
            --this.mDecimalAt;
        }
        this.ensureCapacity(this.mCount, 0);
        for (int i = 0; i < this.mCount; ++i) {
            this.mDigits[i] = string.charAt(i + n3);
        }
        if (n > 0) {
            this.round(n, false, n2);
        }
    }

    public void set(BigDecimal bigDecimal, int n, boolean bl, int n2) {
        String string = bigDecimal.toString();
        this.set(string, string.length());
        if (bl) {
            if (-this.mDecimalAt > n) {
                this.mCount = 0;
                return;
            }
            if (-this.mDecimalAt == n) {
                if (this.shouldRoundUp(0, bigDecimal.signum() < 0, n2)) {
                    this.mCount = 1;
                    ++this.mDecimalAt;
                    this.mDigits[0] = 49;
                } else {
                    this.mCount = 0;
                }
                return;
            }
        }
        while (this.mCount > 1 && this.mDigits[this.mCount - 1] == '0') {
            --this.mCount;
        }
        this.round(bl ? n + this.mDecimalAt : n, bigDecimal.signum() == -1, n2);
    }

    private void set(String string, int n) {
        char[] cArray = string.toCharArray();
        this.mDecimalAt = -1;
        this.mCount = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        this.ensureCapacity(n + 1, 0);
        int n4 = 0;
        if (cArray[n4] == '-') {
            ++n4;
        }
        while (n4 < cArray.length) {
            char c;
            if ((c = cArray[n4++]) == '.') {
                this.mDecimalAt = this.mCount;
                continue;
            }
            if (c == 'e' || c == 'E') {
                n2 = DigitList.parseInt(cArray, n4);
                break;
            }
            if (this.mCount >= n) continue;
            if (!bl) {
                boolean bl2 = bl = c != '0';
                if (!bl && this.mDecimalAt != -1) {
                    ++n3;
                }
            }
            if (!bl) continue;
            this.mDigits[this.mCount++] = c;
        }
        if (this.mDecimalAt == -1) {
            this.mDecimalAt = this.mCount;
        }
        if (bl) {
            this.mDecimalAt += n2 - n3;
        }
    }

    private void ensureCapacity(int n, int n2) {
        if (n > this.mDigits.length) {
            char[] cArray = new char[n * 2];
            System.arraycopy(this.mDigits, 0, cArray, 0, n2);
            this.mDigits = cArray;
        }
    }

    private boolean shouldRoundUp(int n, boolean bl, int n2) {
        boolean bl2 = false;
        switch (n2) {
            case 2: {
                if (!bl) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case 1: {
                bl2 = false;
                break;
            }
            case 3: {
                if (bl) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case 5: {
                bl2 = this.halfDownRounding(n);
                break;
            }
            case 6: {
                bl2 = this.halfEvenRounding(n);
                break;
            }
            case 4: {
                bl2 = this.halfUpRounding(n);
                break;
            }
            case 0: {
                bl2 = true;
                break;
            }
            case 7: {
                throw new ArithmeticException("Rounding necessary");
            }
            default: {
                bl2 = false;
            }
        }
        return bl2;
    }

    private boolean halfEvenRounding(int n) {
        boolean bl = false;
        if (n < this.mCount) {
            if (this.mDigits[n] > '5') {
                return true;
            }
            if (this.mDigits[n] == '5') {
                for (int i = n + 1; i < this.mCount; ++i) {
                    if (this.mDigits[i] == '0') continue;
                    return true;
                }
                return n > 0 && this.mDigits[n - 1] % 2 != 0;
            }
        }
        return false;
    }

    private boolean halfDownRounding(int n) {
        if (n < this.mCount) {
            return this.mDigits[n] > '5';
        }
        return false;
    }

    private boolean halfUpRounding(int n) {
        if (n < this.mCount) {
            return this.mDigits[n] >= '5';
        }
        return false;
    }

    private static int parseInt(char[] cArray, int n) {
        boolean bl = true;
        char c = cArray[n];
        if (c == '-') {
            bl = false;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        int n2 = 0;
        while (n < cArray.length && (c = cArray[n++]) >= '0' && c <= '9') {
            n2 = n2 * 10 + (c - 48);
        }
        return bl ? n2 : -n2;
    }

    private boolean isLongMIN_VALUE() {
        if (this.mDecimalAt != this.mCount || this.mCount != 19) {
            return false;
        }
        for (int i = 0; i < this.mCount; ++i) {
            if (this.mDigits[i] == LONG_MIN_REP[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            DigitList digitList = (DigitList)super.clone();
            char[] cArray = new char[this.mDigits.length];
            System.arraycopy(this.mDigits, 0, cArray, 0, this.mDigits.length);
            digitList.mDigits = cArray;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.mCount != digitList.mCount || this.mDecimalAt != digitList.mDecimalAt) {
            return false;
        }
        for (int i = 0; i < this.mCount; ++i) {
            if (this.mDigits[i] == digitList.mDigits[i]) continue;
            return false;
        }
        return true;
    }
}

