/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DateFormat;
import oracle.apps.fnd.i18n.common.text.DateFormatSymbols;
import oracle.apps.fnd.i18n.common.text.DecimalFormat;
import oracle.apps.fnd.i18n.common.text.FieldPosition;
import oracle.apps.fnd.i18n.common.text.NumberFormat;
import oracle.apps.fnd.i18n.common.text.ParsePosition;
import oracle.apps.fnd.i18n.common.text.resources.CalendarResourceAccessor;
import oracle.apps.fnd.i18n.common.util.Calendar;
import oracle.apps.fnd.i18n.common.util.GregorianCalendar;

public class ExcelDateFormat
extends DateFormat {
    public static final String RCS_ID = "$Header: ExcelDateFormat.java 120.1 2011/06/27 19:09:16 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: ExcelDateFormat.java 120.1 2011/06/27 19:09:16 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    private static final String GMT = "GMT";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT_PLUS = "GMT+";
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15, 15, 17, 18, 19, 20, 1, 2, 5, 14, 1, 1, 0, 1};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 1, 2, 3, 8, 1, 1, 0, 1};
    private static final String[] DIGIT_WEEK_STRINGS = new String[]{"1", "2", "3", "4", "5", "6", "7"};
    private static final String[] DIGIT_MONTH_STRINGS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static final String[] DIGIT_MONTH_STRINGS_WITH_ZERO = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final char[] HAN_YEAR_CHARS = new char[]{'\u3007', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final String[] HAN_MONTH_STRINGS = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    private static final String[] HAN_DATE_STRINGS = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u4e8c\u5341\u4e00", "\u4e8c\u5341\u4e8c", "\u4e8c\u5341\u4e09", "\u4e8c\u5341\u56db", "\u4e8c\u5341\u4e94", "\u4e8c\u5341\u516d", "\u4e8c\u5341\u4e03", "\u4e8c\u5341\u516b", "\u4e8c\u5341\u4e5d", "\u4e09\u5341", "\u4e09\u5341\u4e00"};
    private static final String[] profibitedMask = new String[]{"#", "?", "%", "*", "@", "\\", "E+", "E-", "e+", "e-", "_"};
    private static Hashtable m_CachedConvertedPattern = new Hashtable(50);
    private DateFormatSymbols m_Symbols;
    private Date m_DefaultCenturyStart;
    private transient int m_DefaultCenturyStartYear;
    private String m_Pattern;
    private String m_OriginalPattern;
    private int m_RoundingMode = 1;
    private transient char m_ZeroDigit;
    private char m_DecimalSeparator = (char)46;
    private Locale m_Locale;
    private Calendar m_LocalCalendar;
    private Calendar m_DefaultCalendar;
    private boolean m_LocalCalendarMode = false;
    private int m_FormatWidth = -1;

    public ExcelDateFormat() {
        this(11, 11, Locale.getDefault());
    }

    public ExcelDateFormat(Locale locale) {
        this(11, 11, locale);
    }

    ExcelDateFormat(int n, int n2, Locale locale) {
        this.m_Symbols = new DateFormatSymbols(locale, 9);
        if (n >= 0 && n2 >= 0) {
            this.m_Pattern = CalendarResourceAccessor.getDateFormatMask(n2, locale) + " " + CalendarResourceAccessor.getTimeFormatMask(n, locale);
        } else if (n >= 0) {
            this.m_Pattern = CalendarResourceAccessor.getTimeFormatMask(n, locale);
        } else if (n2 >= 0) {
            this.m_Pattern = CalendarResourceAccessor.getDateFormatMask(n2, locale);
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(locale);
        this.applyPattern(this.m_Pattern);
    }

    public ExcelDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public ExcelDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.m_Symbols = (DateFormatSymbols)dateFormatSymbols.clone();
        this.initialize(this.m_Symbols.mLocale);
        this.applyPattern(string);
    }

    public ExcelDateFormat(String string, Locale locale) {
        this.m_Symbols = new DateFormatSymbols(locale, 9);
        this.initialize(locale);
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        if (this.useLocalCalendar(string, this.m_Locale)) {
            this.m_LocalCalendarMode = true;
            if (this.mCalendar.getType() != this.m_LocalCalendar.getType()) {
                this.m_LocalCalendar.setTimestamp(this.mCalendar.getTimestamp());
                this.mCalendar = this.m_LocalCalendar;
                this.m_Symbols.setCalendarResources(this.mCalendar.getType());
            }
        } else {
            this.m_LocalCalendarMode = false;
            if (this.mCalendar.getType() != this.m_DefaultCalendar.getType()) {
                this.m_DefaultCalendar.setTimestamp(this.mCalendar.getTimestamp());
                this.mCalendar = this.m_DefaultCalendar;
                this.m_Symbols.setCalendarResources(this.mCalendar.getType());
            }
        }
        this.m_OriginalPattern = string;
        this.m_Pattern = this.translatePattern(string);
    }

    public Date get2DigitYearStart() {
        return this.m_DefaultCenturyStart;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.m_Symbols.clone();
    }

    public void set2DigitYearStart(Date date) {
        this.parseAmbiguousDatesAsAfter(date);
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.m_Symbols = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    public void setCalendar(Calendar calendar) {
        if (!this.m_LocalCalendarMode) {
            super.setCalendar(calendar);
            this.m_DefaultCalendar = calendar;
            this.m_Symbols.setCalendarResources(calendar.getType());
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.m_LocalCalendar.setTimeZone(timeZone);
        this.m_DefaultCalendar.setTimeZone(timeZone);
    }

    public void setLenient(boolean bl) {
        super.setLenient(bl);
        this.m_LocalCalendar.setLenient(bl);
        this.m_DefaultCalendar.setLenient(bl);
    }

    public void setFormatWidth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Zero or Negative number is not allowed.");
        }
        this.m_FormatWidth = n;
    }

    public int getFormatWidth() {
        return this.m_FormatWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            this.mCalendar.setTime(date);
            return this.formatImpl(stringBuffer, fieldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Timestamp timestamp, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            this.mCalendar.setTimestamp(timestamp);
            return this.formatImpl(stringBuffer, fieldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Number number, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            this.mCalendar.setTime(this.getDateFromNumber(number));
            return this.formatImpl(stringBuffer, fieldPosition);
        }
    }

    private StringBuffer formatImpl(StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.m_Pattern.length(); ++i) {
            n = this.m_Pattern.charAt(i);
            if (n != n2 && n3 > 0) {
                this.subFormat((char)n2, n3, fieldPosition, stringBuffer);
                n3 = 0;
            }
            if (n == 39) {
                if (i + 1 < this.m_Pattern.length() && this.m_Pattern.charAt(i + 1) == '\'') {
                    stringBuffer.append('\'');
                    ++i;
                    continue;
                }
                bl = !bl;
                continue;
            }
            if (!bl && (n >= 97 && n <= 122 || n >= 65 && n <= 90)) {
                n2 = n;
                ++n3;
                continue;
            }
            stringBuffer.append((char)n);
        }
        if (n3 > 0) {
            this.subFormat((char)n2, n3, fieldPosition, stringBuffer);
        }
        if (this.m_FormatWidth != -1 && this.m_FormatWidth < stringBuffer.length()) {
            fieldPosition.mBeginIndex = 0;
            fieldPosition.mEndIndex = this.m_FormatWidth;
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n = 0; n < this.m_FormatWidth; ++n) {
                stringBuffer2.append("#");
            }
            return stringBuffer2;
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = n = parsePosition.mIndex;
        boolean[] blArray = new boolean[]{false};
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            Date date;
            int n3;
            this.mCalendar.clear();
            boolean bl = false;
            char c = '\u0000';
            int n4 = 0;
            int n5 = 1;
            for (n3 = 0; n3 < this.m_Pattern.length(); ++n3) {
                int n6;
                char c2 = this.m_Pattern.charAt(n3);
                if (bl) {
                    if (c2 == '\'') {
                        bl = false;
                        if (n4 == 0) {
                            if (n >= string.length() || c2 != string.charAt(n)) {
                                parsePosition.mIndex = n2;
                                parsePosition.mErrorIndex = n;
                                return null;
                            }
                            ++n;
                        }
                        n4 = 0;
                        n5 = 0;
                        continue;
                    }
                    if (n >= string.length() || c2 != string.charAt(n)) {
                        parsePosition.mIndex = n2;
                        parsePosition.mErrorIndex = n;
                        return null;
                    }
                    ++n4;
                    ++n;
                    continue;
                }
                if (c2 == '\'') {
                    bl = true;
                    if (n4 > 0) {
                        n6 = n;
                        if ((n = this.subParse(string, n, c, n4, false, blArray)) < 0) {
                            parsePosition.mErrorIndex = n6;
                            parsePosition.mIndex = n2;
                            return null;
                        }
                        n4 = 0;
                    }
                    if (n5 == 0) {
                        n6 = n;
                        if (n >= string.length() || c2 != string.charAt(n)) {
                            parsePosition.mErrorIndex = n6;
                            parsePosition.mIndex = n2;
                            return null;
                        }
                        ++n;
                        n4 = 1;
                    }
                } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                    if (c2 != c && n4 > 0) {
                        n6 = n;
                        if ((n = this.subParse(string, n, c, n4, true, blArray)) < 0) {
                            parsePosition.mErrorIndex = n6;
                            parsePosition.mIndex = n2;
                            return null;
                        }
                        c = c2;
                        n4 = 1;
                    } else {
                        if (c2 != c) {
                            c = c2;
                        }
                        ++n4;
                    }
                } else if (n4 > 0) {
                    n6 = n;
                    if ((n = this.subParse(string, n, c, n4, false, blArray)) < 0) {
                        parsePosition.mErrorIndex = n6;
                        parsePosition.mIndex = n2;
                        return null;
                    }
                    if ((n >= string.length() || string.charAt(n) != '/' && string.charAt(n) != '-' && string.charAt(n) != '.' && string.charAt(n) != ' ' && string.charAt(n) != ':' && string.charAt(n) != ',') && (n >= string.length() || c2 != string.charAt(n))) {
                        parsePosition.mErrorIndex = n;
                        parsePosition.mIndex = n2;
                        return null;
                    }
                    ++n;
                    n4 = 0;
                    c = '\u0000';
                } else {
                    if (n >= string.length() || c2 != string.charAt(n)) {
                        parsePosition.mErrorIndex = n;
                        parsePosition.mIndex = n2;
                        return null;
                    }
                    ++n;
                }
                ++n5;
            }
            if (n4 > 0) {
                n3 = n;
                if ((n = this.subParse(string, n, c, n4, false, blArray)) < 0) {
                    parsePosition.mErrorIndex = n3;
                    parsePosition.mIndex = n2;
                    return null;
                }
            }
            parsePosition.mIndex = n;
            try {
                if (blArray[0]) {
                    Calendar calendar2 = (Calendar)this.mCalendar.clone();
                    date = this.mCalendar.getTime();
                    if (date.before(this.m_DefaultCenturyStart)) {
                        calendar2.set(1, this.m_DefaultCenturyStartYear + 100);
                        date = calendar2.getTime();
                    }
                } else {
                    date = this.mCalendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                parsePosition.mErrorIndex = n;
                parsePosition.mIndex = n2;
                return null;
            }
            return date;
        }
    }

    private void initialize(Locale locale) {
        this.m_Locale = locale;
        this.mCalendar = this.m_DefaultCalendar = Calendar.getInstance(TimeZone.getDefault(), locale);
        this.m_LocalCalendar = this.createLocalCalendar(locale);
        this.mNumberFormat = NumberFormat.getInstance(locale);
        this.mNumberFormat.setGroupingUsed(false);
        if (this.mNumberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.mNumberFormat).applyPattern(11, "#;#");
            ((DecimalFormat)this.mNumberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.mNumberFormat.setParseIntegerOnly(true);
        this.mNumberFormat.setMinimumFractionDigits(0);
        this.initializeDefaultCentury();
    }

    private boolean useLocalCalendar(String string, Locale locale) {
        return string != null && string.indexOf("EE") == -1 && string.toLowerCase(Locale.US).indexOf("e") != -1 && locale.getLanguage().compareTo("ja") == 0 && locale.getCountry().compareTo("JP") == 0;
    }

    private Calendar createLocalCalendar(Locale locale) {
        if (locale.getLanguage().compareTo("ja") == 0 && locale.getCountry().compareTo("JP") == 0) {
            return Calendar.getInstance(TimeZone.getDefault(), locale, 1);
        }
        return Calendar.getInstance(TimeZone.getDefault(), locale);
    }

    private void initializeDefaultCentury() {
        this.mCalendar.setTime(new Date());
        this.mCalendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.mCalendar.getTime());
    }

    private int matchString(String string, int n, int n2, String[] stringArray) {
        int n3 = 0;
        int n4 = stringArray.length;
        if (n2 == 7) {
            n3 = 1;
        }
        int n5 = 0;
        int n6 = -1;
        while (n3 < n4) {
            int n7 = stringArray[n3].length();
            if (n7 > n5 && string.regionMatches(true, n, stringArray[n3], 0, n7)) {
                n6 = n3;
                n5 = n7;
            }
            ++n3;
        }
        if (n6 >= 0) {
            if (n2 == 0) {
                this.mCalendar.set(n2, n4 - n6 - 1);
            } else {
                this.mCalendar.set(n2, n6);
            }
            return n + n5;
        }
        return -n;
    }

    private int matchZoneString(String string, int n, int n2) {
        int n3;
        for (n3 = 4; n3 >= 1 && !string.regionMatches(true, n, this.m_Symbols.mZoneStrings[n2][n3], 0, this.m_Symbols.mZoneStrings[n2][n3].length()); --n3) {
        }
        return n3 > 4 ? -1 : n3;
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.m_DefaultCenturyStart = date;
        this.mCalendar.setTime(date);
        this.m_DefaultCenturyStartYear = this.mCalendar.get(1);
    }

    private void subFormat(char c, int n, FieldPosition fieldPosition, StringBuffer stringBuffer) throws IllegalArgumentException {
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        String string = "";
        int n4 = stringBuffer.length();
        n2 = "GyMdkHmsSEDFwWahKzZtTfCYOAxRrgoUuI".indexOf(c);
        if (n2 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + c + "'");
        }
        int n5 = PATTERN_INDEX_TO_CALENDAR_FIELD[n2];
        int n6 = this.mCalendar.get(n5);
        switch (n2) {
            case 0: {
                if (n >= 2) {
                    string = this.m_Symbols.mEras[this.m_Symbols.mEras.length - 1 - n6];
                    break;
                }
                string = this.m_Symbols.mShortEras[this.m_Symbols.mShortEras.length - 1 - n6];
                break;
            }
            case 1: {
                if (n >= 4) {
                    this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                    break;
                }
                if (n == 3) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n == 2) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n6 % 100 < 10) {
                    this.zeroPaddingNumber(n6, 1, 1, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                break;
            }
            case 2: {
                if (n >= 4) {
                    string = this.m_Symbols.mMonths[n6];
                    break;
                }
                if (n == 3) {
                    string = this.m_Symbols.mShortMonths[n6];
                    break;
                }
                this.zeroPaddingNumber(n6 + 1, n, n3, stringBuffer);
                break;
            }
            case 4: {
                if (n6 == 0) {
                    this.zeroPaddingNumber(this.mCalendar.getMaximum(11) + 1, n, n3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                break;
            }
            case 5: {
                if (n == 4 || n == 3) {
                    int n7 = this.mCalendar.get(5) > 1 ? 2 : 1;
                    this.zeroPaddingNumber(n6 += 24 * (n7 - 1), n - 2, n3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                break;
            }
            case 6: {
                if (n == 4 || n == 3) {
                    int n8 = this.mCalendar.get(11) > 0 ? 1 : 0;
                    this.zeroPaddingNumber(n6 += 60 * n8, n - 2, n3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                break;
            }
            case 7: {
                if (n == 4 || n == 3) {
                    int n9 = this.mCalendar.get(12) > 0 ? 1 : 0;
                    this.zeroPaddingNumber(n6 += 60 * n9, n - 2, n3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                break;
            }
            case 9: {
                if (n >= 4) {
                    string = this.m_Symbols.mWeekdays[n6];
                    break;
                }
                if (n >= 2) {
                    string = this.m_Symbols.mShortWeekdays[n6];
                    break;
                }
                stringBuffer.append(n6 + 1);
                break;
            }
            case 14: {
                string = this.m_Symbols.mAmpms[n6];
                break;
            }
            case 15: {
                if (n == 4 || n == 3) {
                    int n10 = this.mCalendar.get(5) != 1 ? 2 : 1;
                    n6 += 24 * (n10 - 1);
                    n -= 2;
                }
                if (n6 == 0) {
                    this.zeroPaddingNumber(this.mCalendar.getLeastMaximum(10) + 1, n, n3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                break;
            }
            case 17: {
                int n11 = this.m_Symbols.getZoneIndex(this.mCalendar.getTimeZone().getID());
                if (n11 == -1) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    n6 = this.mCalendar.get(15) + this.mCalendar.get(16);
                    if (n6 < 0) {
                        stringBuffer2.append(GMT_MINUS);
                        n6 = -n6;
                    } else {
                        stringBuffer2.append(GMT_PLUS);
                    }
                    this.zeroPaddingNumber(n6 / 3600000, 2, 2, stringBuffer2);
                    stringBuffer2.append(':');
                    this.zeroPaddingNumber(n6 % 3600000 / 60000, 2, 2, stringBuffer2);
                    string = stringBuffer2.toString();
                    break;
                }
                if (this.mCalendar.get(16) > 0) {
                    if (n >= 4) {
                        string = this.m_Symbols.mZoneStrings[n11][3];
                        break;
                    }
                    string = this.m_Symbols.mZoneStrings[n11][4];
                    break;
                }
                if (n >= 4) {
                    string = this.m_Symbols.mZoneStrings[n11][1];
                    break;
                }
                string = this.m_Symbols.mZoneStrings[n11][2];
                break;
            }
            case 18: {
                n6 = this.mCalendar.get(15) + this.mCalendar.get(16);
                if (n6 < 0) {
                    stringBuffer.append('-');
                    n6 = -n6;
                } else {
                    stringBuffer.append('+');
                }
                int n12 = n6 / 3600000;
                if (n12 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n12);
                n12 = n6 % 3600000 / 60000;
                if (n12 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n12);
                break;
            }
            case 19: {
                int n13 = this.mCalendar.get(17);
                if (n13 < 0) {
                    stringBuffer.append('-');
                    n13 = -n13;
                } else {
                    stringBuffer.append('+');
                }
                if (n > 1 && n13 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n13);
                break;
            }
            case 20: {
                int n14 = this.mCalendar.get(18);
                n14 = Math.abs(n14);
                if (n > 1 && n14 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n14);
                break;
            }
            case 21: {
                int n15 = 1;
                for (int i = 0; i < 9 - n; ++i) {
                    n15 *= 10;
                }
                this.zeroPaddingNumber(n6 /= n15, n, n, stringBuffer);
                break;
            }
            case 23: {
                String string2 = Long.toString(n6);
                int n16 = string2.length();
                if (n16 < n) {
                    n = n16;
                }
                string2 = string2.substring(n16 - n, n16);
                for (int i = 0; i < n; ++i) {
                    string = string + HAN_YEAR_CHARS[Integer.parseInt(string2.substring(i, i + 1))];
                }
                break;
            }
            case 24: {
                string = HAN_MONTH_STRINGS[n6];
                break;
            }
            case 25: {
                string = HAN_DATE_STRINGS[n6];
                break;
            }
            case 26: {
                string = String.valueOf(this.m_DecimalSeparator);
                break;
            }
            case 27: {
                if (n >= 4) {
                    this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                    break;
                }
                if (n == 3) {
                    this.zeroPaddingNumber(n6, 3, 3, stringBuffer);
                    break;
                }
                if (n == 2) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n6 % 100 < 10) {
                    this.zeroPaddingNumber(n6, 1, 1, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                break;
            }
            case 28: {
                if (n >= 4) {
                    this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                    break;
                }
                if (n == 3) {
                    this.zeroPaddingNumber(n6, 3, 3, stringBuffer);
                    break;
                }
                if (n == 2) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n6 % 100 < 10) {
                    this.zeroPaddingNumber(n6, 1, 1, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                break;
            }
            case 29: {
                if (n >= 2) {
                    string = this.m_Symbols.mEras[this.m_Symbols.mEras.length - 1 - n6];
                    break;
                }
                string = this.m_Symbols.mShortEras[this.m_Symbols.mShortEras.length - 1 - n6];
                break;
            }
            case 30: {
                stringBuffer.append(n6);
                break;
            }
            default: {
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
            }
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        if (fieldPosition.mField == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n2] && fieldPosition.mBeginIndex == 0 && fieldPosition.mEndIndex == 0) {
            fieldPosition.mBeginIndex = n4;
            fieldPosition.mEndIndex = stringBuffer.length();
        }
    }

    private int subParse(String string, int n, char c, int n2, boolean bl, boolean[] blArray) {
        Number number = null;
        int n3 = 0;
        ParsePosition parsePosition = new ParsePosition(0);
        int n4 = -1;
        n4 = "GyMdkHmsSEDFwWahKzZtTfCYOAxRrgoUuI".indexOf(c);
        if (n4 == -1) {
            return -n;
        }
        parsePosition.mIndex = n;
        int n5 = PATTERN_INDEX_TO_CALENDAR_FIELD[n4];
        while (true) {
            if (parsePosition.mIndex >= string.length()) {
                return -n;
            }
            char c2 = string.charAt(parsePosition.mIndex);
            if (c2 != ' ' && c2 != '\t') break;
            ++parsePosition.mIndex;
        }
        if (n4 == 4 || n4 == 15 || n4 == 2 && n2 <= 2 || n4 == 1 || n4 == 27 || n4 == 28 || n4 == 22 || n4 == 30) {
            if (bl) {
                if (n + n2 > string.length()) {
                    return -n;
                }
                number = this.mNumberFormat.parse(string.substring(0, n + n2), parsePosition);
            } else {
                number = this.mNumberFormat.parse(string, parsePosition);
            }
            if (number == null) {
                return -n;
            }
            n3 = number.intValue();
        }
        switch (n4) {
            case 0: {
                if (n2 >= 2) {
                    return this.matchString(string, n, 0, this.m_Symbols.mEras);
                }
                return this.matchString(string, n, 0, this.m_Symbols.mShortEras);
            }
            case 1: {
                n3 = this.adjustYear(n2, bl, parsePosition, n, string, n3, blArray, this.m_DefaultCenturyStartYear);
                if (n3 < 0) {
                    n3 = -n3;
                }
                this.mCalendar.set(1, n3);
                return parsePosition.mIndex;
            }
            case 2: {
                if (n2 <= 2) {
                    this.mCalendar.set(2, n3 - 1);
                    return parsePosition.mIndex;
                }
                int n6 = 0;
                if (n2 >= 4 && (n6 = this.matchString(string, n, 2, this.m_Symbols.mMonths)) > 0) {
                    return n6;
                }
                n6 = this.matchString(string, n, 2, this.m_Symbols.mShortMonths);
                if (n6 > 0) {
                    return n6;
                }
                n6 = this.matchString(string, n, 2, DIGIT_MONTH_STRINGS);
                if (n6 > 0) {
                    return n6;
                }
                return this.matchString(string, n, 2, DIGIT_MONTH_STRINGS_WITH_ZERO);
            }
            case 4: {
                if (n3 == this.mCalendar.getMaximum(11) + 1) {
                    n3 = 0;
                }
                this.mCalendar.set(11, n3);
                return parsePosition.mIndex;
            }
            case 9: {
                int n7 = 0;
                n7 = this.matchString(string, n, 7, this.m_Symbols.mWeekdays);
                if (n7 > 0) {
                    return n7;
                }
                n7 = this.matchString(string, n, 7, this.m_Symbols.mShortWeekdays);
                if (n7 > 0) {
                    return n7;
                }
                return this.matchString(string, n, 7, DIGIT_WEEK_STRINGS);
            }
            case 14: {
                return this.matchString(string, n, 9, this.m_Symbols.mAmpms);
            }
            case 15: {
                if (n3 == this.mCalendar.getLeastMaximum(10) + 1) {
                    n3 = 0;
                }
                this.mCalendar.set(10, n3);
                return parsePosition.mIndex;
            }
            case 17: 
            case 18: {
                int n8;
                int n9 = 0;
                if (string.length() - n >= GMT.length() && string.regionMatches(true, n, GMT, 0, GMT.length())) {
                    this.mCalendar.set(16, 0);
                    parsePosition.mIndex = n + GMT.length();
                    try {
                        if (string.charAt(parsePosition.mIndex) == '+') {
                            n9 = 1;
                        } else if (string.charAt(parsePosition.mIndex) == '-') {
                            n9 = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (n9 == 0) {
                        this.mCalendar.set(15, 0);
                        return parsePosition.mIndex;
                    }
                    ++parsePosition.mIndex;
                    Number number2 = this.mNumberFormat.parse(string, parsePosition);
                    if (number2 == null) {
                        return -n;
                    }
                    if (string.charAt(parsePosition.mIndex) == ':') {
                        n8 = number2.intValue() * 60;
                        ++parsePosition.mIndex;
                        number2 = this.mNumberFormat.parse(string, parsePosition);
                        if (number2 == null) {
                            return -n;
                        }
                        n8 += number2.intValue();
                    } else {
                        n8 = number2.intValue();
                        n8 = n8 < 24 ? (n8 *= 60) : n8 % 100 + n8 / 100 * 60;
                    }
                } else {
                    int n10 = this.subParseZoneString(string, n);
                    if (n10 != 0) {
                        return n10;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(11, "+####;-####");
                    decimalFormat.setParseIntegerOnly(true);
                    Number number3 = decimalFormat.parse(string, parsePosition);
                    if (number3 == null) {
                        return -n;
                    }
                    n8 = number3.intValue();
                    n9 = 1;
                    if (n8 < 0) {
                        n9 = -1;
                        n8 = -n8;
                    }
                    n8 = n8 < 24 ? (n8 *= 60) : n8 % 100 + n8 / 100 * 60;
                }
                if (n9 != 0) {
                    n8 *= 60000 * n9;
                    this.mCalendar.set(16, 3600000);
                    this.mCalendar.set(15, n8 -= 3600000);
                    return parsePosition.mIndex;
                }
                return -n;
            }
            case 19: {
                int n11 = 0;
                this.mCalendar.set(17, 0);
                parsePosition.mIndex = n;
                try {
                    if (string.charAt(parsePosition.mIndex) == '+') {
                        n11 = 1;
                    } else if (string.charAt(parsePosition.mIndex) == '-') {
                        n11 = -1;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (n11 == 0) {
                    this.mCalendar.set(17, 0);
                    return parsePosition.mIndex;
                }
                ++parsePosition.mIndex;
                Number number4 = this.mNumberFormat.parse(string.substring(0, parsePosition.mIndex + n2), parsePosition);
                if (number4 == null) {
                    return -n;
                }
                int n12 = number4.intValue();
                this.mCalendar.set(17, n12 * n11);
                return parsePosition.mIndex;
            }
            case 20: {
                this.mCalendar.set(18, 0);
                parsePosition.mIndex = n;
                Number number5 = this.mNumberFormat.parse(string, parsePosition);
                if (number5 == null) {
                    return -n;
                }
                int n13 = number5.intValue();
                this.mCalendar.set(18, n13);
                return parsePosition.mIndex;
            }
            case 21: {
                int n14 = this.mNumberFormat.parse(string, parsePosition).intValue();
                int n15 = 1;
                for (int i = 0; i < 9 - n2; ++i) {
                    n15 *= 10;
                }
                this.mCalendar.set(n5, n14 * n15);
                return parsePosition.mIndex;
            }
            case 8: {
                int n16 = this.mNumberFormat.parse(string, parsePosition).intValue();
                this.mCalendar.set(14, n16);
                this.mCalendar.set(19, n16 * 1000000);
                return parsePosition.mIndex;
            }
            case 22: {
                this.m_DefaultCenturyStartYear = (n3 - 1) * 100;
                this.mCalendar.set(20, n3);
                return parsePosition.mIndex;
            }
            case 23: {
                int n17;
                int n18 = 0;
                int n19 = 0;
                for (n17 = 0; n17 < n2; ++n17) {
                    char c3 = string.charAt(n + n17);
                    boolean bl2 = false;
                    for (int i = 0; i < HAN_YEAR_CHARS.length; ++i) {
                        if (c3 != HAN_YEAR_CHARS[i]) continue;
                        n18 = n18 * 10 + i;
                        bl2 = true;
                        ++n19;
                        break;
                    }
                    if (!bl2) break;
                }
                if ((n2 == 2 && this.isNLSDigit(string.charAt(n)) && this.isNLSDigit(string.charAt(n + 1)) || n2 == 1 && this.isNLSDigit(string.charAt(n))) && this.mCalendar.getType() == 0 && n3 <= 99) {
                    n17 = this.m_DefaultCenturyStartYear % 100;
                    blArray[0] = n18 == n17;
                    n18 += this.m_DefaultCenturyStartYear / 100 * 100 + (n18 < n17 ? 100 : 0);
                }
                parsePosition.mIndex = n + n19;
                if (n18 < 0) {
                    n18 = -n3;
                }
                this.mCalendar.set(1, n18);
                return parsePosition.mIndex;
            }
            case 24: {
                return this.matchString(string, n, 2, HAN_MONTH_STRINGS);
            }
            case 25: {
                return this.matchString(string, n, 5, HAN_DATE_STRINGS);
            }
            case 26: {
                parsePosition.mIndex = n + 1;
                return parsePosition.mIndex;
            }
            case 27: {
                n3 = this.adjustYear(n2, bl, parsePosition, n, string, n3, blArray, 1950);
                if (n3 < 0) {
                    n3 = -n3;
                }
                this.mCalendar.set(1, n3);
                return parsePosition.mIndex;
            }
            case 28: {
                n3 = this.adjustYear(n2, bl, parsePosition, n, string, n3, blArray, this.m_DefaultCenturyStartYear);
                if (n3 < 0) {
                    n3 = -n3;
                }
                this.mCalendar.set(1, n3);
                return parsePosition.mIndex;
            }
            case 29: {
                if (n2 >= 2) {
                    return this.matchString(string, n, 0, this.m_Symbols.mEras);
                }
                return this.matchString(string, n, 0, this.m_Symbols.mShortEras);
            }
            case 30: {
                n3 = this.adjustYear(n2, bl, parsePosition, n, string, n3, blArray, 1950);
                if (n3 < 0) {
                    n3 = -n3;
                }
                this.mCalendar.set(1, n3);
                return parsePosition.mIndex;
            }
        }
        if (bl) {
            if (n + n2 > string.length()) {
                return -n;
            }
            number = this.mNumberFormat.parse(string.substring(0, n + n2), parsePosition);
        } else {
            number = this.mNumberFormat.parse(string, parsePosition);
        }
        if (number != null) {
            this.mCalendar.set(n5, Math.abs(number.intValue()));
            return parsePosition.mIndex;
        }
        return -n;
    }

    private int adjustYear(int n, boolean bl, ParsePosition parsePosition, int n2, String string, int n3, boolean[] blArray, int n4) {
        if ((n == 2 && (!bl || bl && parsePosition.mIndex - n2 == 2) && Character.isDigit(string.charAt(n2)) && Character.isDigit(string.charAt(n2 + 1)) || n == 1 && (!bl || bl && parsePosition.mIndex - n2 == 1) && Character.isDigit(string.charAt(n2))) && this.mCalendar.getType() == 0 && n3 <= 99) {
            int n5 = n4 % 100;
            blArray[0] = n3 == n5;
            n3 += n4 / 100 * 100 + (n3 < n5 ? 100 : 0);
        }
        return n3;
    }

    private int subParseZoneString(String string, int n) {
        int n2 = this.m_Symbols.getZoneIndex(this.getTimeZone().getID());
        TimeZone timeZone = null;
        int n3 = 0;
        int n4 = 0;
        if (n2 != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.m_Symbols.mZoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null && (n2 = this.m_Symbols.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.m_Symbols.mZoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null) {
            for (n4 = 0; n4 < this.m_Symbols.mZoneStrings.length; ++n4) {
                n3 = this.matchZoneString(string, n, n4);
                if (n3 <= 0) continue;
                timeZone = TimeZone.getTimeZone(this.m_Symbols.mZoneStrings[n4][0]);
                break;
            }
        }
        if (timeZone != null) {
            this.mCalendar.set(15, timeZone.getRawOffset());
            return n + this.m_Symbols.mZoneStrings[n4][n3].length();
        }
        return 0;
    }

    private String translatePattern(String string) {
        return this.getConvertedFormatMask(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zeroPaddingNumber(long l, int n, int n2, StringBuffer stringBuffer) {
        try {
            if (this.m_ZeroDigit == '\u0000') {
                this.m_ZeroDigit = ((DecimalFormat)this.mNumberFormat).getDecimalFormatSymbols().getZeroDigit();
            }
            if (l >= 0L) {
                if (l < 100L && n >= 1 && n <= 2) {
                    if (l < 10L) {
                        if (n == 2) {
                            stringBuffer.append(this.m_ZeroDigit);
                        }
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l));
                    } else {
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l / 10L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l % 10L));
                    }
                    return;
                }
                if (l >= 1000L && l < 10000L) {
                    if (n == 4) {
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l / 1000L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + (l %= 1000L) / 100L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + (l %= 100L) / 10L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l % 10L));
                        return;
                    }
                    if (n == 2 && n2 == 2) {
                        this.zeroPaddingNumber(l % 100L, 2, 2, stringBuffer);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        NumberFormat numberFormat = this.mNumberFormat;
        synchronized (numberFormat) {
            this.mNumberFormat.setMinimumIntegerDigits(n);
            this.mNumberFormat.setMaximumIntegerDigits(n2);
            this.mNumberFormat.format(l, stringBuffer, new FieldPosition(0));
        }
    }

    private boolean isNLSDigit(char c) {
        for (int i = 0; i < HAN_YEAR_CHARS.length; ++i) {
            if (c != HAN_YEAR_CHARS[i]) continue;
            return true;
        }
        return Character.isDigit(c);
    }

    private String getConvertedFormatMask(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPattern.get(string);
        if (string2 == null) {
            boolean[] blArray = new boolean[]{false, false};
            blArray = this.preConvert(string, blArray);
            string2 = this.convert(string, "", blArray);
            m_CachedConvertedPattern.put(string, string2);
        }
        return string2;
    }

    private String convertInText(String string, String string2, boolean[] blArray) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.startsWith("\"\"")) {
            string = string.substring(2);
            string2 = string2 + "''";
            return this.convertInText(string, string2, blArray);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convert(string, string2, blArray);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return this.convertInText(string, string2, blArray);
    }

    private String convert(String string, String string2, boolean[] blArray) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.startsWith("ggg")) {
            string = string.substring(3);
            string2 = string2 + "GG";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("gg")) {
            string = string.substring(2);
            string2 = string2 + "GG";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("g")) {
            string = string.substring(1);
            string2 = string2 + "G";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("mmmm")) {
            string = string.substring(4);
            string2 = string2 + "MMMM";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("mmm")) {
            string = string.substring(3);
            string2 = string2 + "MMM";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("mm")) {
            string = string.substring(2);
            if (blArray[1]) {
                string2 = string2 + "mm";
            } else {
                boolean bl = false;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c - 97 < 0 || 122 - c < 0) continue;
                    if (c != 's') break;
                    bl = true;
                }
                string2 = bl ? string2 + "mm" : string2 + "MM";
            }
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("m")) {
            string = string.substring(1);
            if (blArray[1]) {
                string2 = string2 + "m";
            } else {
                boolean bl = false;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c - 97 < 0 || 122 - c < 0) continue;
                    if (c != 's') break;
                    bl = true;
                }
                string2 = bl ? string2 + "m" : string2 + "M";
            }
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("[hh]")) {
            string = string.substring(4);
            string2 = blArray[0] ? string2 + "hhhh" : string2 + "HHHH";
            blArray[1] = true;
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("[h]")) {
            string = string.substring(3);
            string2 = blArray[0] ? string2 + "hhh" : string2 + "HHH";
            blArray[1] = true;
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("hh")) {
            string = string.substring(2);
            string2 = blArray[0] ? string2 + "hh" : string2 + "HH";
            blArray[1] = true;
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("h")) {
            string = string.substring(1);
            string2 = blArray[0] ? string2 + "h" : string2 + "H";
            blArray[1] = true;
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("[mm]")) {
            string = string.substring(4);
            string2 = string2 + "mmmm";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("[m]")) {
            string = string.substring(3);
            string2 = string2 + "mmm";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("[ss]")) {
            string = string.substring(4);
            string2 = string2 + "ssss";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("[s]")) {
            string = string.substring(3);
            string2 = string2 + "sss";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("000")) {
            string = string.substring(3);
            string2 = string2 + "fff";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("00")) {
            string = string.substring(2);
            string2 = string2 + "ff";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("0")) {
            string = string.substring(1);
            string2 = string2 + "f";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("EEEE")) {
            string = string.substring(4);
            string2 = string2 + "YYYY";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("EEE")) {
            string = string.substring(3);
            string2 = string2 + "YYY";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            string2 = string2 + "YY";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("E")) {
            string = string.substring(1);
            string2 = string2 + "YY";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("ee")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("e")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("\u661f\u671fW")) {
            string = string.substring(3);
            string2 = string2 + "EEEE";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("O")) {
            string = string.substring(1);
            string2 = string2 + "O";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("aaa")) {
            string = string.substring(3);
            string2 = string2 + "EE";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("AM/PM")) {
            string = string.substring(5);
            string2 = string2 + "a";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("AMPM")) {
            string = string.substring(4);
            string2 = string2 + "a";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("A/P")) {
            string = string.substring(3);
            string2 = string2 + "a";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("am/pm")) {
            string = string.substring(5);
            string2 = string2 + "a";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("a/p")) {
            string = string.substring(3);
            string2 = string2 + "a";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("dddd")) {
            string = string.substring(4);
            string2 = string2 + "EEEE";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("ddd")) {
            string = string.substring(3);
            string2 = string2 + "EE";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("yyyyyy")) {
            string = string.substring(6);
            string2 = string2 + "yyyyyy";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("yyyyy")) {
            string = string.substring(5);
            string2 = string2 + "yyyyy";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("yyyy")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("yyy")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("yy")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("y")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("zzzz")) {
            string = string.substring(4);
            string2 = string2 + "tt:TT";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("zzz")) {
            string = string.substring(3);
            string2 = string2 + "tt:TT";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("zz")) {
            string = string.substring(2);
            string2 = string2 + "tt";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("z")) {
            string = string.substring(1);
            string2 = string2 + "t";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("tt")) {
            string = string.substring(2);
            string2 = string2 + "a";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("t")) {
            string = string.substring(1);
            string2 = string2 + "a";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convert(string, string2, blArray);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convertInText(string, string2, blArray);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return this.convert(string, string2, blArray);
    }

    private boolean[] preConvert(String string, boolean[] blArray) {
        if (string == null || string.length() == 0) {
            return blArray;
        }
        if (string.startsWith("AM/PM")) {
            string = string.substring(5);
            blArray[0] = true;
            return this.preConvert(string, blArray);
        }
        if (string.startsWith("AMPM")) {
            string = string.substring(4);
            blArray[0] = true;
            return this.preConvert(string, blArray);
        }
        if (string.startsWith("am/pm")) {
            string = string.substring(5);
            blArray[0] = true;
            return this.preConvert(string, blArray);
        }
        if (string.startsWith("A/P")) {
            string = string.substring(3);
            blArray[0] = true;
            return this.preConvert(string, blArray);
        }
        if (string.startsWith("a/p")) {
            string = string.substring(3);
            blArray[0] = true;
            return this.preConvert(string, blArray);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            return this.preConvertInText(string, blArray);
        }
        String string2 = string.substring(0, 1);
        for (int i = 0; i < profibitedMask.length; ++i) {
            if (!string.startsWith(profibitedMask[i])) continue;
            throw new IllegalArgumentException("'" + profibitedMask[i] + "' in \"" + this.m_OriginalPattern + '\"' + " is not allowed to use in date/time formatting.");
        }
        string = string.substring(1);
        return this.preConvert(string, blArray);
    }

    private boolean[] preConvertInText(String string, boolean[] blArray) {
        if (string == null || string.length() == 0) {
            return blArray;
        }
        if (string.startsWith("\"\"")) {
            string = string.substring(2);
            return this.preConvertInText(string, blArray);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            return this.preConvert(string, blArray);
        }
        String string2 = string.substring(0, 1);
        string = string.substring(1);
        return this.preConvertInText(string, blArray);
    }

    private boolean isProfibitedString(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < profibitedMask.length; ++i) {
            if (!string.startsWith(profibitedMask[i])) continue;
            return true;
        }
        return false;
    }

    private Date getDateFromNumber(Number number) {
        double d = number.doubleValue();
        int n = (int)d;
        if (n > 60) {
            --n;
        } else if (n == 0) {
            n = 1;
        }
        double d2 = d % 1.0;
        long l = 86400000L;
        int n2 = 3600000;
        int n3 = 60000;
        int n4 = 1000;
        long l2 = (long)((double)l * d2 / 1.0);
        int n5 = (int)(l2 / (long)n2);
        int n6 = (int)(l2 - (long)(n5 * n2)) / n3;
        int n7 = (int)(l2 - (long)(n5 * n2) - (long)(n6 * n3)) / n4;
        int n8 = (int)(l2 - (long)(n5 * n2) - (long)(n6 * n3) - (long)(n7 * n4)) * 1000000;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.mCalendar.getTimeZone(), this.m_Locale);
        gregorianCalendar.set(1900, 0, n, n5, n6, n7, n8);
        return gregorianCalendar.getTime();
    }

    public Object clone() {
        ExcelDateFormat excelDateFormat = (ExcelDateFormat)super.clone();
        excelDateFormat.m_Symbols = (DateFormatSymbols)this.m_Symbols.clone();
        return excelDateFormat;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ExcelDateFormat excelDateFormat = (ExcelDateFormat)object;
        return this.m_Pattern.equals(excelDateFormat.m_Pattern) && this.m_Symbols.equals(excelDateFormat.m_Symbols);
    }

    public int hashCode() {
        return this.m_Pattern.hashCode();
    }
}

