/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DigitList;
import oracle.apps.fnd.i18n.common.text.ExcelNumberFormatSymbols;
import oracle.apps.fnd.i18n.common.text.FieldPosition;
import oracle.apps.fnd.i18n.common.text.NumberFormat;
import oracle.apps.fnd.i18n.common.text.ParsePosition;

public class ExcelNumberFormat
extends NumberFormat {
    public static final String RCS_ID = "$Header: ExcelNumberFormat.java 120.1 2010/02/25 03:38:11 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: ExcelNumberFormat.java 120.1 2010/02/25 03:38:11 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    private static Hashtable m_CachedLocaleData = new Hashtable(3);
    private ExcelNumberFormatSymbols m_Symbols = null;
    private int[] m_FirstGroupingSize = new int[]{3, 3, 3, 3};
    private int[] m_SecondGroupingSize = new int[]{3, 3, 3, 3};
    private int[] m_Multiplier = new int[]{1, 1, 1, 1};
    private int[] m_Divider = new int[]{1, 1, 1, 1};
    private int[] m_Scale = new int[]{0, 0, 0, 0};
    private int[] m_IntegerSpaceCount = new int[]{0, 0, 0, 0};
    private int[] m_FractionSpaceCount = new int[]{0, 0, 0, 0};
    private boolean[] m_DigitShown = new boolean[]{false, false, false, false};
    private boolean[] m_TextPlaceHolderShown = new boolean[]{false, false, false, false};
    private boolean[] m_DecimalSeparatorAlwaysShown = new boolean[]{false, false, false, false};
    private transient boolean m_IsCurrencyFormat = false;
    private int m_RoundingMode = 6;
    private boolean[] m_GroupingUsed = new boolean[]{true, true, true, true};
    private boolean[] m_UseFraction = new boolean[]{false, false, false, false};
    private int[] m_MinFractionDigits = new int[]{0, 0, 0, 0};
    private int[] m_FractionNum = new int[]{-1, -1, -1, -1};
    private boolean[] m_UseExponentialNotation = new boolean[]{false, false, false, false};
    private boolean[] m_UseExponentialSign = new boolean[]{false, false, false, false};
    private byte[] m_MinExponentDigits = new byte[]{0, 0, 0, 0};
    private int[] m_MinimumIntegerDigits = new int[]{0, 0, 0, 0};
    private int[] m_MaximumIntegerDigits = new int[]{0, 0, 0, 0};
    private int[] m_MinimumFractionDigits = new int[]{0, 0, 0, 0};
    private int[] m_MaximumFractionDigits = new int[]{0, 0, 0, 0};
    private transient DigitList m_DigitList = new DigitList();
    private String[] m_Prefixes = new String[]{"", "-", "", ""};
    private String[] m_Prefixes2 = new String[]{"", "", "", ""};
    private String[] m_Suffixes = new String[]{"", "", "", ""};
    private String[] m_PrefixPatterns = new String[]{null, null, null, null};
    private String[] m_Prefix2Patterns = new String[]{null, null, null, null};
    private String[] m_SuffixPatterns = new String[]{null, null, null, null};
    private String[] m_RepeatChars = new String[]{null, null, null, null};
    private int[] m_RepeatPositions = new int[]{-1, -1, -1, -1};
    private String[] m_SkipChars = new String[]{null, null, null, null};
    private int[] m_Colors = new int[]{-1, -1, -1, -1};
    private int[] m_Conditions = new int[]{4, 5, 3, -1};
    private BigDecimal[] m_ConditionValues = new BigDecimal[]{new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0")};
    private boolean m_UseCondition = false;
    private String m_OriginalPattern;
    private int m_FormatWidth;
    private boolean m_General_Format = false;
    private int m_Color = -1;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char PATTERN_PLUS = '+';
    private static final char PATTERN_FLACTION = '/';
    private static final char PATTERN_SPACE = '?';
    private static final char PATTERN_REPEAT = '*';
    private static final char PATTERN_SKIP = '_';
    private static final char PATTERN_TEXT = '@';
    private static final char PATTERN_DISPLAY_CHAR = '\\';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\"';
    private static final int DOUBLE_INTEGER_DIGITS = 309;
    private static final int DOUBLE_FRACTION_DIGITS = 340;
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    public static final int SECTION_FIRST = 0;
    public static final int SECTION_SECOND = 1;
    public static final int SECTION_THIRD = 2;
    public static final int SECTION_FOURTH = 3;
    private static final int[] SECTIONS = new int[]{0, 1, 2, 3};
    private static final int REPEAT_BEFORE_PREFIX = 0;
    private static final int REPEAT_AFTER_PREFIX = 1;
    private static final int REPEAT_BEFORE_SUFFIX = 2;
    private static final int REPEAT_AFTER_SUFFIX = 3;
    public static final int COLOR_UNDEFINED = -1;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_BLUE = 1;
    public static final int COLOR_CYAN = 2;
    public static final int COLOR_GREEN = 3;
    public static final int COLOR_MAGENTA = 4;
    public static final int COLOR_RED = 5;
    public static final int COLOR_WHITE = 6;
    public static final int COLOR_YELLOW = 7;
    private static final int CONDITION_UNDEFINED = -1;
    private static final int CONDITION_NOT_EQUAL_TO = 0;
    private static final int CONDITION_GREATER_THAN_OR_EQUAL_TO = 1;
    private static final int CONDITION_LESS_THAN_OR_EQUAL_TO = 2;
    private static final int CONDITION_EQUAL_TO = 3;
    private static final int CONDITION_GREATER_THAN = 4;
    private static final int CONDITION_LESS_THAN = 5;
    private static String[] COLOR_FORMAT_MASKS = new String[]{"Black", "Blue", "Cyan", "Green", "Magenta", "Red", "White", "Yellow"};
    private static int[] COLOR_NUMS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static String[] CONDITION_FORMAT_MASKS = new String[]{"<>", ">=", "<=", "=", ">", "<"};
    private static int[] CONDITION_NUMS = new int[]{0, 1, 2, 3, 4, 5};
    private static final char[] profibitedMask = new char[]{'m', 'd', 'y', 'h', 's'};
    private static final int SCALE_SIZE = 3;

    public ExcelNumberFormat() {
        this(Locale.getDefault());
    }

    public ExcelNumberFormat(String string) {
        this(string, Locale.getDefault());
    }

    public ExcelNumberFormat(Locale locale) {
        String string = (String)m_CachedLocaleData.get(locale);
        if (string == null) {
            java.text.NumberFormat numberFormat = java.text.NumberFormat.getNumberInstance(locale);
            string = ((DecimalFormat)numberFormat).toPattern();
            m_CachedLocaleData.put(locale, string);
        }
        this.m_Symbols = new ExcelNumberFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public ExcelNumberFormat(String string, Locale locale) {
        this.m_Symbols = new ExcelNumberFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public ExcelNumberFormat(String string, ExcelNumberFormatSymbols excelNumberFormatSymbols) {
        this.m_Symbols = (ExcelNumberFormatSymbols)excelNumberFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        this.m_Color = -1;
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        if (Double.isNaN(d)) {
            if (fieldPosition.mField == 0) {
                fieldPosition.mBeginIndex = stringBuffer.length();
            }
            stringBuffer.append(this.m_Symbols.mNaN);
            if (fieldPosition.mField == 0) {
                fieldPosition.mEndIndex = stringBuffer.length();
            }
            return stringBuffer;
        }
        int n = this.identifySection(new Double(d));
        boolean bl2 = bl = d < 0.0 || d == 0.0 && 1.0 / d < 0.0;
        if (bl) {
            d = -d;
        }
        if (this.m_Multiplier[n] != 1) {
            d *= (double)this.m_Multiplier[n];
        }
        if (this.m_Scale[n] != 0) {
            d /= (double)this.m_Divider[n];
        }
        if (Double.isInfinite(d)) {
            int n2 = this.appendAffix(stringBuffer, n, true);
            if (fieldPosition.mField == 0) {
                fieldPosition.mBeginIndex = stringBuffer.length();
            }
            stringBuffer.append(this.m_Symbols.mInfinity);
            if (fieldPosition.mField == 0) {
                fieldPosition.mEndIndex = stringBuffer.length();
            }
            int n3 = this.appendAffix(stringBuffer, n, false);
            return stringBuffer;
        }
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(d, this.m_UseExponentialNotation[n] ? this.getMaximumIntegerDigits(n) + this.getMaximumFractionDigits(n) : this.getMaximumFractionDigits(n), !this.m_UseExponentialNotation[n], this.m_RoundingMode, bl);
            return this.subformat(stringBuffer, fieldPosition, n, false, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        this.m_Color = -1;
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        int n = this.identifySection(new Long(l));
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        if (this.m_Multiplier[n] != 1 && this.m_Multiplier[n] != 0) {
            long l2;
            boolean bl3 = false;
            if (l < 0L) {
                l2 = Long.MIN_VALUE / (long)Math.abs(this.m_Multiplier[n]);
                bl3 = l < l2;
            } else {
                l2 = Long.MAX_VALUE / (long)Math.abs(this.m_Multiplier[n]);
                boolean bl4 = bl3 = l > l2;
            }
            if (bl3) {
                double d = bl ? -l : l;
                return this.format(d, stringBuffer, fieldPosition);
            }
        }
        if (this.m_Scale[n] != 0) {
            long l3 = bl ? -l : l;
            return this.format(BigDecimal.valueOf(l3), stringBuffer, fieldPosition);
        }
        l *= (long)this.m_Multiplier[n];
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(l, this.m_UseExponentialNotation[n] ? this.getMaximumIntegerDigits(n) + this.getMaximumFractionDigits(n) : 0, this.m_RoundingMode);
            return this.subformat(stringBuffer, fieldPosition, n, true, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.m_Color = -1;
        boolean bl = bigDecimal.signum() < 0;
        int n = this.identifySection(bigDecimal);
        if (this.m_Multiplier[n] != 1) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(this.m_Multiplier[n]));
        }
        if (this.m_Scale[n] != 0) {
            bigDecimal = bigDecimal.movePointLeft(this.m_Scale[n]);
        }
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(bigDecimal, this.m_UseExponentialNotation[n] ? this.getMaximumIntegerDigits(n) + this.getMaximumFractionDigits(n) : this.getMaximumFractionDigits(n), !this.m_UseExponentialNotation[n], this.m_RoundingMode);
            return this.subformat(stringBuffer, fieldPosition, n, false, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.m_Color = -1;
        boolean bl = bigInteger.signum() < 0;
        int n = this.identifySection(bigInteger);
        if (this.m_Scale[n] != 0) {
            return this.format(new BigDecimal(bigInteger), stringBuffer, fieldPosition);
        }
        if (this.m_Multiplier[n] != 1) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(this.m_Multiplier[n]));
        }
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            this.m_DigitList.set(bigInteger, this.m_UseExponentialNotation[n] ? this.getMaximumIntegerDigits(n) + this.getMaximumFractionDigits(n) : 0, this.m_RoundingMode);
            return this.subformat(stringBuffer, fieldPosition, n, false, bl);
        }
    }

    public StringBuffer format(String string, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.m_Color = this.m_Colors[3];
        int n = this.appendAffix(stringBuffer, 3, true);
        fieldPosition.mField = stringBuffer.length();
        int n2 = stringBuffer.length();
        stringBuffer.append(string);
        int n3 = stringBuffer.length();
        fieldPosition.mBeginIndex = n2;
        fieldPosition.mEndIndex = n3;
        int n4 = this.appendAffix(stringBuffer, 3, false);
        this.addRepeatChars(stringBuffer, fieldPosition, n, n4, 3);
        return stringBuffer;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Integer) {
            return this.format(((Integer)object).longValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof BigDecimal) {
            return this.format((BigDecimal)object, stringBuffer, fieldPosition);
        }
        if (object instanceof BigInteger) {
            return this.format((BigInteger)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof String) {
            return this.format((String)object, stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number or String");
    }

    public String format(String string) {
        return this.format(string, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public int getColor() {
        return this.m_Color;
    }

    public String getColorName() {
        if (this.m_Color != -1) {
            return COLOR_FORMAT_MASKS[this.m_Color];
        }
        return "Undefined";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.mIndex, this.m_Symbols.mNaN, 0, this.m_Symbols.mNaN.length())) {
            parsePosition.mIndex += this.m_Symbols.mNaN.length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        DigitList digitList = this.m_DigitList;
        synchronized (digitList) {
            if (!this.subparse(string, parsePosition, this.m_DigitList, false, blArray)) {
                return null;
            }
            Number number = null;
            if (blArray[0]) {
                number = new Double(blArray[1] ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
            } else if (!blArray[1] && this.m_DigitList.isZero()) {
                number = new Double(-0.0);
            } else {
                int n = this.m_DigitList.isZero() ? 2 : 1;
                n = blArray[1] ? 0 : 1;
                int n2 = this.m_Multiplier[n];
                while (n2 % 10 == 0) {
                    --this.m_DigitList.mDecimalAt;
                    n2 /= 10;
                }
                int n3 = this.m_Divider[n];
                while (n3 % 10 == 0) {
                    ++this.m_DigitList.mDecimalAt;
                    n3 /= 10;
                }
                if (n2 == 1 && this.m_DigitList.isIntegral()) {
                    BigInteger bigInteger = this.m_DigitList.getBigInteger(blArray[1]);
                    number = bigInteger.bitLength() < 64 ? new Long(bigInteger.longValue()) : bigInteger;
                } else {
                    BigDecimal bigDecimal = this.m_DigitList.getBigDecimal(blArray[1]);
                    number = bigDecimal;
                    if (n2 != 1) {
                        number = bigDecimal.divide(BigDecimal.valueOf(n2), this.m_RoundingMode);
                    }
                }
            }
            return number;
        }
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public int getMaximumIntegerDigits(int n) {
        return this.m_MaximumIntegerDigits[n];
    }

    public void setMaximumIntegerDigits(int n, int n2) {
        this.m_MaximumIntegerDigits[n] = Math.max(0, Math.min(n2, 309));
        if (this.m_MinimumIntegerDigits[n] > this.m_MaximumIntegerDigits[n]) {
            this.m_MinimumIntegerDigits[n] = this.m_MaximumIntegerDigits[n];
        }
    }

    public int getMinimumIntegerDigits(int n) {
        return this.m_MinimumIntegerDigits[n];
    }

    public void setMinimumIntegerDigits(int n, int n2) {
        this.m_MinimumIntegerDigits[n] = Math.max(0, Math.min(n2, 309));
        if (this.m_MinimumIntegerDigits[n] > this.m_MaximumIntegerDigits[n]) {
            this.m_MaximumIntegerDigits[n] = this.m_MinimumIntegerDigits[n];
        }
    }

    public int getMaximumFractionDigits(int n) {
        return this.m_MaximumFractionDigits[n];
    }

    public void setMaximumFractionDigits(int n, int n2) {
        this.m_MaximumFractionDigits[n] = Math.max(0, Math.min(n2, 340));
        if (this.m_MaximumFractionDigits[n] < this.m_MinimumFractionDigits[n]) {
            this.m_MinimumFractionDigits[n] = this.m_MaximumFractionDigits[n];
        }
    }

    public int getMinimumFractionDigits(int n) {
        return this.m_MinimumFractionDigits[n];
    }

    public void setMinimumFractionDigits(int n, int n2) {
        this.m_MinimumFractionDigits[n] = Math.max(0, Math.min(n2, 340));
        if (this.m_MaximumFractionDigits[n] < this.m_MinimumFractionDigits[n]) {
            this.m_MaximumFractionDigits[n] = this.m_MinimumFractionDigits[n];
        }
    }

    public void setMaximumIntegerDigits(int n) {
        super.setMaximumIntegerDigits(Math.min(n, 309));
        for (int i = 0; i < 4; ++i) {
            this.setMaximumIntegerDigits(i, n);
        }
    }

    public void setMinimumIntegerDigits(int n) {
        super.setMinimumIntegerDigits(Math.min(n, 309));
        for (int i = 0; i < 4; ++i) {
            this.setMinimumIntegerDigits(i, n);
        }
    }

    public void setMaximumFractionDigits(int n) {
        super.setMaximumFractionDigits(Math.min(n, 340));
        for (int i = 0; i < 4; ++i) {
            this.setMaximumFractionDigits(i, n);
        }
    }

    public void setMinimumFractionDigits(int n) {
        super.setMinimumFractionDigits(Math.min(n, 340));
        for (int i = 0; i < 4; ++i) {
            this.setMaximumFractionDigits(i, n);
        }
    }

    public void setRoundingMode(int n) {
        this.m_RoundingMode = n;
    }

    public int getRoundingMode() {
        return this.m_RoundingMode;
    }

    public int getFirstGroupingSize(int n) {
        return this.m_FirstGroupingSize[n];
    }

    public int getSecondGroupingSize(int n) {
        return this.m_SecondGroupingSize[n];
    }

    public void setFirstGroupingSize(int n, int n2) {
        this.m_FirstGroupingSize[n] = (byte)n2;
    }

    public void setSecondGroupingSize(int n, int n2) {
        this.m_SecondGroupingSize[n] = (byte)n2;
    }

    public boolean isGroupingUsed() {
        return this.m_GroupingUsed[0];
    }

    public boolean isGroupingUsed(int n) {
        return this.m_GroupingUsed[n];
    }

    public void setGroupingUsed(boolean bl) {
        super.setGroupingUsed(bl);
        for (int i = 0; i < 4; ++i) {
            this.m_GroupingUsed[i] = bl;
        }
    }

    public void setGroupingUsed(int n, boolean bl) {
        this.m_GroupingUsed[n] = bl;
    }

    public ExcelNumberFormatSymbols getExcelNumberFormatSymbols() {
        try {
            return (ExcelNumberFormatSymbols)this.m_Symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFormatSymbols(ExcelNumberFormatSymbols excelNumberFormatSymbols) {
        try {
            this.m_Symbols = (ExcelNumberFormatSymbols)excelNumberFormatSymbols.clone();
            this.expandAffixes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPrefix(int n) {
        return this.m_Prefixes[n];
    }

    public void setPrefix(int n, String string) {
        this.m_Prefixes[n] = string;
        this.m_PrefixPatterns[n] = null;
    }

    public String getSuffix(int n) {
        return this.m_Suffixes[n];
    }

    public void setSuffix(int n, String string) {
        this.m_Suffixes[n] = string;
        this.m_SuffixPatterns[n] = null;
    }

    public int getMultiplier(int n) {
        return this.m_Multiplier[n];
    }

    public void setMultiplier(int n, int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Negative multiplier");
        }
        this.m_Multiplier[n] = n2;
    }

    public int getScale(int n) {
        return this.m_Scale[n];
    }

    public void setScale(int n, int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Negative scale");
        }
        this.m_Scale[n] = n2;
        int n3 = 1;
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                n3 *= 10;
            }
        }
        this.m_Divider[n] = n3;
    }

    public void setFormatWidth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Zero or Negative number is not allowed.");
        }
        this.m_FormatWidth = n;
    }

    public int getFormatWidth() {
        return this.m_FormatWidth;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.m_DecimalSeparatorAlwaysShown[0];
    }

    public boolean isDecimalSeparatorAlwaysShown(int n) {
        return this.m_DecimalSeparatorAlwaysShown[n];
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.m_DecimalSeparatorAlwaysShown[0] = bl;
    }

    public void setDecimalSeparatorAlwaysShown(int n, boolean bl) {
        this.m_DecimalSeparatorAlwaysShown[n] = bl;
    }

    private int identifySection(Number number) {
        if (this.m_UseCondition) {
            BigDecimal bigDecimal;
            if (number instanceof Long) {
                bigDecimal = new BigDecimal(((Long)number).toString());
            } else if (number instanceof Integer) {
                bigDecimal = new BigDecimal(((Integer)number).toString());
            } else if (number instanceof BigDecimal) {
                bigDecimal = (BigDecimal)number;
            } else if (number instanceof BigInteger) {
                bigDecimal = new BigDecimal(((BigInteger)number).toString());
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Number");
            }
            int n = 2;
            for (int i = 0; i < 2; ++i) {
                int n2 = bigDecimal.compareTo(this.m_ConditionValues[i]);
                int n3 = this.m_Conditions[i];
                boolean bl = false;
                switch (n3) {
                    case 4: {
                        if (n2 != 1) break;
                        n = SECTIONS[i];
                        bl = true;
                        break;
                    }
                    case 1: {
                        if (n2 < 0) break;
                        n = SECTIONS[i];
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (n2 != 0) break;
                        n = SECTIONS[i];
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (n2 > 0) break;
                        n = SECTIONS[i];
                        bl = true;
                        break;
                    }
                    case 5: {
                        if (n2 != -1) break;
                        n = SECTIONS[i];
                        bl = true;
                    }
                }
                if (bl) break;
            }
            return n;
        }
        if (number instanceof Long) {
            if ((Long)number > 0L) {
                return 0;
            }
            if ((Long)number < 0L) {
                return 1;
            }
            return 2;
        }
        if (number instanceof Integer) {
            if ((Integer)number > 0) {
                return 0;
            }
            if ((Integer)number < 0) {
                return 1;
            }
            return 2;
        }
        if (number instanceof Double) {
            double d = (Double)number;
            if (d > 0.0 || d == 0.0 && 1.0 / d > 0.0) {
                return 0;
            }
            if (d < 0.0 || d == 0.0 && 1.0 / d < 0.0) {
                return 1;
            }
            return 2;
        }
        if (number instanceof BigDecimal) {
            if (((BigDecimal)number).signum() > 0) {
                return 0;
            }
            if (((BigDecimal)number).signum() < 0) {
                return 1;
            }
            return 2;
        }
        if (number instanceof BigInteger) {
            if (((BigInteger)number).signum() > 0) {
                return 0;
            }
            if (((BigInteger)number).signum() < 0) {
                return 1;
            }
            return 2;
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    private int appendAffix(StringBuffer stringBuffer, int n, boolean bl) {
        String string = null;
        string = bl ? this.m_Prefixes[n] : this.m_Suffixes[n];
        stringBuffer.append(string);
        return string.length();
    }

    private int appendAffix2(StringBuffer stringBuffer, int n) {
        String string = this.m_Prefixes2[n];
        stringBuffer.append(string);
        return string.length();
    }

    private StringBuffer subformat(StringBuffer stringBuffer, FieldPosition fieldPosition, int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        block91: {
            char c;
            int n8;
            int n9;
            int n10;
            int n11;
            char c2;
            int n12;
            char c3;
            char c4;
            block93: {
                block94: {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    char c5;
                    block92: {
                        int n18;
                        int n19;
                        block90: {
                            this.m_Color = this.m_Colors[n];
                            c4 = this.m_Symbols.mZeroDigit;
                            c3 = ' ';
                            n12 = c4 - 48;
                            c5 = this.m_Symbols.mGroupingSeparator;
                            char c6 = c2 = this.m_IsCurrencyFormat ? this.m_Symbols.mMonetarySeparator : this.m_Symbols.mDecimalSeparator;
                            if (this.m_DigitList.isZero()) {
                                this.m_DigitList.mDecimalAt = 0;
                            }
                            int n20 = stringBuffer.length();
                            n7 = this.appendAffix(stringBuffer, n, true);
                            int n21 = this.appendAffix2(stringBuffer, n);
                            n6 = fieldPosition.mField;
                            int n22 = stringBuffer.length();
                            n17 = -1;
                            n11 = -1;
                            n5 = -1;
                            if (n6 == 0) {
                                fieldPosition.mBeginIndex = n22;
                                fieldPosition.mEndIndex = n17;
                            } else if (n6 == 1) {
                                fieldPosition.mBeginIndex = n11;
                                fieldPosition.mEndIndex = n5;
                            }
                            n10 = -1;
                            boolean bl3 = false;
                            int n23 = bl2 ? 5 : 4;
                            int n24 = 11;
                            if (this.m_General_Format) {
                                n4 = this.m_Prefixes[n].length() + this.m_Prefixes2[n].length() + this.m_Suffixes[n].length();
                                n3 = n4 + this.m_DigitList.mDecimalAt != 0 ? this.m_DigitList.mDecimalAt : 1;
                                n16 = n4 + this.m_DigitList.mCount;
                                n16 = bl ? n16 : n16 + 1;
                                n2 = n23 + n4;
                                n15 = this.m_FormatWidth;
                                if (this.m_FormatWidth != 0) {
                                    if (this.m_FormatWidth < n3 || n3 > n24) {
                                        if (this.m_FormatWidth > n2) {
                                            bl3 = true;
                                        }
                                    } else if (this.m_FormatWidth < n16 || n16 > n24) {
                                        n10 = this.m_FormatWidth - n3 - 1;
                                        n14 = n24 - n3;
                                        if (n10 > n14) {
                                            n10 = n14;
                                        }
                                        if ((n19 = this.m_FormatWidth - n4) > this.m_DigitList.mDecimalAt && --n19 > 0 && this.m_DigitList.mDecimalAt == 0) {
                                            --n19;
                                        }
                                        n9 = n19;
                                        if (n19 > n24) {
                                            n9 = n24;
                                        }
                                        this.m_DigitList.set(this.m_DigitList.getBigDecimal(!bl2), n9, false, this.m_RoundingMode);
                                        if (this.m_FormatWidth < n4 + this.m_DigitList.mDecimalAt && this.m_FormatWidth > n2) {
                                            bl3 = true;
                                        }
                                    }
                                } else {
                                    this.m_FormatWidth = n24 + 1;
                                    if (this.m_DigitList.mDecimalAt > n24) {
                                        bl3 = true;
                                    }
                                }
                            }
                            if (!bl3) break block90;
                            n4 = 1;
                            n3 = this.m_FormatWidth - n23 - 1;
                            if (n3 == 0) {
                                n3 = 1;
                            }
                            if (n3 > this.m_DigitList.mCount) {
                                n3 = this.m_DigitList.mCount;
                            }
                            if (n3 > (n16 = n24 - n23)) {
                                n3 = n16;
                            }
                            n17 = stringBuffer.length();
                            if (bl) {
                                this.m_DigitList.set(this.m_DigitList.getBigInteger(!bl2), n3, this.m_RoundingMode);
                            } else {
                                this.m_DigitList.set(this.m_DigitList.getBigDecimal(!bl2), n3, false, this.m_RoundingMode);
                            }
                            if (n3 > this.m_DigitList.mCount) {
                                n3 = this.m_DigitList.mCount;
                            }
                            for (n2 = 0; n2 < n3; ++n2) {
                                if (n2 == n4) {
                                    stringBuffer.append(c2);
                                    n11 = stringBuffer.length();
                                }
                                if (n2 < this.m_DigitList.mCount) {
                                    stringBuffer.append(this.m_DigitList.mDigits[n2]);
                                    continue;
                                }
                                stringBuffer.append(c4);
                            }
                            if (n17 == -1) {
                                n17 = stringBuffer.length();
                            }
                            if (n11 == -1) {
                                n11 = stringBuffer.length();
                            }
                            if (n6 == 0) {
                                fieldPosition.mEndIndex = n17;
                            } else if (n6 == 1) {
                                fieldPosition.mBeginIndex = n11;
                                fieldPosition.mEndIndex = n11;
                            }
                            stringBuffer.append(this.m_Symbols.mExponential);
                            stringBuffer.append(this.m_Symbols.mPlusSign);
                            n2 = this.m_DigitList.mDecimalAt - n4;
                            if (n2 < 10) {
                                stringBuffer.append(c4);
                                stringBuffer.append(n2);
                            } else {
                                stringBuffer.append(n2);
                            }
                            n5 = stringBuffer.length();
                            if (n6 == 1) {
                                fieldPosition.mEndIndex = n5;
                            }
                            break block91;
                        }
                        if (!this.m_UseExponentialNotation[n]) break block92;
                        n4 = this.m_DigitList.mDecimalAt;
                        n3 = this.getMaximumIntegerDigits(n);
                        n16 = this.getMinimumIntegerDigits(n);
                        if (n3 > 1 && n3 > n16) {
                            n4 = n4 >= 1 ? (n4 - 1) / n3 * n3 : (n4 - n3) / n3 * n3;
                            n16 = 1;
                        } else {
                            n4 -= n16;
                        }
                        n2 = n16 + this.getMinimumFractionDigits(n);
                        int n25 = n15 = this.m_DigitList.isZero() ? n16 : this.m_DigitList.mDecimalAt - n4;
                        if (n2 < n15) {
                            n2 = n15;
                        }
                        if (n2 > (n14 = n15 + this.getMaximumFractionDigits(n))) {
                            n14 = n2;
                        }
                        if (this.m_DigitList.mCount > (n19 = n15 + this.getMinimumFractionDigits(n))) {
                            n19 = this.m_DigitList.mCount;
                        }
                        n9 = 0;
                        for (n8 = 0; n8 < n14; ++n8) {
                            if (n8 == n15) {
                                n17 = stringBuffer.length();
                                stringBuffer.append(c2);
                                n9 = 1;
                                n11 = stringBuffer.length();
                            }
                            if (n8 >= n19) continue;
                            stringBuffer.append(n8 < this.m_DigitList.mCount ? (char)(this.m_DigitList.mDigits[n8] + n12) : c4);
                        }
                        if (n17 == -1) {
                            n17 = stringBuffer.length();
                        }
                        if (n11 == -1) {
                            n11 = stringBuffer.length();
                        }
                        if (n6 == 0) {
                            fieldPosition.mEndIndex = n17;
                        } else if (n6 == 1) {
                            fieldPosition.mBeginIndex = n11;
                            fieldPosition.mEndIndex = n11;
                        }
                        stringBuffer.append(this.m_Symbols.mExponential);
                        if (this.m_DigitList.isZero()) {
                            n4 = 0;
                        }
                        int n26 = n8 = n4 < 0 ? 1 : 0;
                        if (n8 != 0) {
                            n4 = -n4;
                            stringBuffer.append(this.m_Prefixes[n]);
                        } else {
                            stringBuffer.append(this.m_Prefixes[n]);
                            if (this.m_UseExponentialSign[n] && ("".equals(this.m_Prefixes[n]) || this.m_Prefixes[n].length() == 0)) {
                                stringBuffer.append(this.m_Symbols.mPlusSign);
                            }
                        }
                        this.m_DigitList.set(n4, this.m_RoundingMode);
                        for (n18 = this.m_DigitList.mDecimalAt; n18 < this.m_MinExponentDigits[n]; ++n18) {
                            stringBuffer.append(c4);
                        }
                        for (n18 = 0; n18 < this.m_DigitList.mDecimalAt; ++n18) {
                            stringBuffer.append(n18 < this.m_DigitList.mCount ? (char)(this.m_DigitList.mDigits[n18] + n12) : c4);
                        }
                        n5 = stringBuffer.length();
                        if (n6 == 1) {
                            fieldPosition.mEndIndex = n5;
                        }
                        break block91;
                    }
                    if (!this.m_DigitShown[n]) break block91;
                    n4 = this.getMinimumIntegerDigits(n);
                    n3 = this.m_DigitList.mDecimalAt;
                    if (this.m_DigitList.mDecimalAt > 0 && n4 < this.m_DigitList.mDecimalAt) {
                        n4 = this.m_DigitList.mDecimalAt;
                    }
                    if (n4 > (n16 = this.getMaximumIntegerDigits(n))) {
                        n4 = n16;
                    }
                    n2 = stringBuffer.length();
                    n15 = this.isGroupingUsed(n);
                    n14 = 0;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (n9 = 1; n9 <= n4; ++n9) {
                        int n27 = n8 = n14 != 0 ? this.m_SecondGroupingSize[n] : this.m_FirstGroupingSize[n];
                        if (n3 > 0) {
                            c = (char)(this.m_DigitList.mDigits[--n3] + n12);
                            if (n3 < this.m_DigitList.mCount) {
                                stringBuffer2.insert(0, c);
                            } else {
                                stringBuffer2.insert(0, c4);
                            }
                            if (n15 == 0 || n8 == 0 || (n9 - (n14 != 0 ? this.m_FirstGroupingSize[n] : 0)) % n8 != 0) continue;
                            if (this.m_DigitList.mDecimalAt != n9) {
                                if (n9 >= n4) continue;
                                if (n9 < n4 - this.m_IntegerSpaceCount[n] || n9 <= this.m_DigitList.mDecimalAt) {
                                    stringBuffer2.insert(0, c5);
                                } else {
                                    stringBuffer2.insert(0, c3);
                                }
                                n14 = 1;
                                continue;
                            }
                            if (n9 >= n4) continue;
                            if (n9 < n4 - this.m_IntegerSpaceCount[n]) {
                                stringBuffer2.insert(0, c5);
                            } else {
                                stringBuffer2.insert(0, c3);
                            }
                            n14 = 1;
                            continue;
                        }
                        if (n9 <= n4 - this.m_IntegerSpaceCount[n]) {
                            stringBuffer2.insert(0, c4);
                        } else {
                            stringBuffer2.insert(0, c3);
                        }
                        if (n15 == 0 || n8 == 0 || (n9 - (n14 != 0 ? this.m_FirstGroupingSize[n] : 0)) % n8 != 0 || n9 >= n4) continue;
                        n14 = 1;
                        if (n9 < n4 - this.m_IntegerSpaceCount[n]) {
                            stringBuffer2.insert(0, c5);
                            continue;
                        }
                        stringBuffer2.insert(0, c3);
                    }
                    if (bl2 && this.m_UseCondition) {
                        stringBuffer2.insert(0, this.m_Symbols.mMinusSign);
                    }
                    stringBuffer.append(stringBuffer2.toString());
                    n17 = stringBuffer.length();
                    if (n6 == 0) {
                        fieldPosition.mEndIndex = n17;
                    }
                    if (!this.m_UseFraction[n]) break block93;
                    if (this.m_DigitList.isIntegral() && this.m_DigitList.isZero()) break block94;
                    double d = this.m_DigitList.getDouble() % 1.0;
                    if (stringBuffer2.length() > 0 || bl2) {
                        stringBuffer.append(" ");
                    }
                    n11 = stringBuffer.length();
                    if (n6 == 1) {
                        fieldPosition.mBeginIndex = n11;
                        fieldPosition.mEndIndex = n11;
                    }
                    int[] nArray = this.m_FractionNum[n] != -1 ? ExcelNumberFormat.getFractionValue(d, this.m_FractionNum[n]) : ExcelNumberFormat.getCloseFractionValue(d, this.m_MinFractionDigits[n]);
                    String string = Integer.toString(nArray[0]);
                    String string2 = Integer.toString(nArray[1]);
                    if (string.length() < this.m_MinFractionDigits[n]) {
                        for (n13 = 0; n13 < this.m_MinFractionDigits[n] - string.length(); ++n13) {
                            string = " " + string;
                        }
                    }
                    if (string2.length() < this.m_MinFractionDigits[n]) {
                        for (n13 = 0; n13 < this.m_MinFractionDigits[n] - string2.length(); ++n13) {
                            string2 = string2 + " ";
                        }
                    }
                    stringBuffer.append(string + "/" + string2);
                    break block91;
                }
                if (this.m_DigitList.isZero()) {
                    stringBuffer.append("0");
                    for (n9 = 0; n9 < this.m_MinFractionDigits[n] * 2 + 1 + 1; ++n9) {
                        stringBuffer.append(" ");
                    }
                }
                n11 = stringBuffer.length();
                if (n6 != 1) break block91;
                fieldPosition.mBeginIndex = n11;
                fieldPosition.mEndIndex = n11;
                break block91;
            }
            n3 = this.m_DigitList.mDecimalAt > 0 ? this.m_DigitList.mDecimalAt : 0;
            n9 = n10 == -1 ? this.getMaximumFractionDigits(n) : n10;
            n8 = this.getMinimumFractionDigits(n);
            n9 = n9 > n8 ? n9 : n8;
            char c7 = c = n8 > 0 || !bl && n3 < this.m_DigitList.mCount ? (char)'\u0001' : '\u0000';
            if (c == '\u0000' && stringBuffer.length() == n2) {
                stringBuffer.append(c4);
            }
            if (this.m_DecimalSeparatorAlwaysShown[n] || c != '\u0000') {
                stringBuffer.append(c2);
            }
            n11 = stringBuffer.length();
            if (n6 == 1) {
                fieldPosition.mBeginIndex = n11;
                fieldPosition.mEndIndex = n11;
            }
            for (int i = 0; i < n9 && (i < n8 || !bl && n3 < this.m_DigitList.mCount); ++i) {
                if (-1 - i > this.m_DigitList.mDecimalAt - 1) {
                    if (i < n9 - this.m_FractionSpaceCount[n]) {
                        stringBuffer.append(c4);
                        continue;
                    }
                    stringBuffer.append(c3);
                    continue;
                }
                if (!bl && n3 < this.m_DigitList.mCount && n3 >= 0) {
                    stringBuffer.append((char)(this.m_DigitList.mDigits[n3++] + n12));
                    continue;
                }
                if (i < n9 - this.m_FractionSpaceCount[n]) {
                    stringBuffer.append(c4);
                    continue;
                }
                stringBuffer.append(c3);
            }
        }
        n5 = stringBuffer.length();
        if (n6 == 1) {
            fieldPosition.mEndIndex = n5;
        }
        n4 = stringBuffer.length();
        n3 = this.appendAffix(stringBuffer, n, false);
        this.addRepeatChars(stringBuffer, fieldPosition, n7, n3, n);
        if (this.m_FormatWidth > 0 && stringBuffer.length() > this.m_FormatWidth) {
            StringBuffer stringBuffer3 = new StringBuffer();
            for (n2 = 0; n2 < this.m_FormatWidth; ++n2) {
                stringBuffer3.append("#");
            }
            if (n6 == 0) {
                fieldPosition.mBeginIndex = 0;
                fieldPosition.mEndIndex = this.m_FormatWidth;
            } else if (n6 == 1) {
                fieldPosition.mBeginIndex = 0;
                fieldPosition.mEndIndex = this.m_FormatWidth;
            }
            return stringBuffer3;
        }
        return stringBuffer;
    }

    private void addRepeatChars(StringBuffer stringBuffer, FieldPosition fieldPosition, int n, int n2, int n3) {
        int n4;
        int n5;
        if (this.m_FormatWidth > 0 && (n5 = this.m_RepeatPositions[n3]) != -1 && (n4 = this.m_FormatWidth - stringBuffer.length()) > 0) {
            String string = "";
            for (int i = 0; i < n4; ++i) {
                string = string + this.m_RepeatChars[n3];
            }
            switch (n5) {
                case 1: {
                    stringBuffer.insert(n, string);
                    break;
                }
                case 0: {
                    stringBuffer.insert(0, string);
                    break;
                }
                case 2: {
                    stringBuffer.insert(stringBuffer.length() - n2, string);
                    break;
                }
                case 3: {
                    stringBuffer.append(string);
                }
            }
            if (n5 == 0 || n5 == 1) {
                fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + n4);
                fieldPosition.setEndIndex(fieldPosition.getEndIndex() + n4);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void applyPattern(String var1_1, boolean var2_2) {
        var3_3 = 48;
        var4_4 = 44;
        var5_5 = 46;
        var6_6 = 37;
        var7_7 = 8240;
        var8_8 = 35;
        var9_9 = 59;
        var10_10 = 69;
        var11_11 = 45;
        var12_12 = '+';
        var13_13 = 47;
        var14_14 = 63;
        var15_15 = 42;
        var16_16 = 95;
        var17_17 = 64;
        var18_18 = 92;
        this.m_OriginalPattern = var1_1;
        if (var2_2) {
            var3_3 = this.m_Symbols.mZeroDigit;
            var4_4 = this.m_Symbols.mGroupingSeparator;
            var5_5 = this.m_Symbols.mDecimalSeparator;
            var6_6 = this.m_Symbols.mPercent;
            var7_7 = this.m_Symbols.mPerMill;
            var8_8 = this.m_Symbols.mDigit;
            var9_9 = this.m_Symbols.mPatternSeparator;
            var10_10 = Character.toUpperCase(this.m_Symbols.mExponential);
            var11_11 = this.m_Symbols.mMinusSign;
            var12_12 = this.m_Symbols.mPlusSign;
            var13_13 = this.m_Symbols.mFraction;
            var14_14 = this.m_Symbols.mSpace;
            var15_15 = this.m_Symbols.mRepeat;
            var16_16 = this.m_Symbols.mSkip;
            var17_17 = this.m_Symbols.mText;
            var18_18 = this.m_Symbols.mChar;
        }
        this.reset();
        var19_19 = false;
        this.m_IsCurrencyFormat = false;
        this.m_General_Format = false;
        var20_20 = 1;
        var21_21 = true;
        var22_22 = 0;
        var23_23 = 3;
        if (var1_1.startsWith("General") || var1_1.equals("@")) {
            var1_1 = "#.##########";
            this.m_General_Format = true;
        }
        for (var24_24 = 0; var24_24 <= var23_23 && var22_22 < var1_1.length(); ++var24_24) {
            this.m_UseExponentialNotation[var24_24] = false;
            this.m_UseExponentialSign[var24_24] = false;
            this.m_DigitShown[var24_24] = false;
            this.m_TextPlaceHolderShown[var24_24] = false;
            this.m_DecimalSeparatorAlwaysShown[var24_24] = false;
            this.m_UseFraction[var24_24] = false;
            this.m_FractionNum[var24_24] = -1;
            this.m_RepeatChars[var24_24] = null;
            this.m_RepeatPositions[var24_24] = -1;
            var25_25 = -1;
            var26_26 = 0;
            var27_27 = 0;
            var28_28 = 0;
            var29_29 = 0;
            var30_30 = 0;
            var31_31 = 0;
            var32_32 = -1;
            var33_33 = -1;
            var34_34 = -1;
            var35_35 = false;
            var36_36 = new StringBuffer();
            var37_37 = new StringBuffer();
            var38_38 = new StringBuffer();
            var39_39 = false;
            var40_40 = 0;
            var41_41 = var36_36;
            block9: for (var42_42 = var22_22; var42_42 < var1_1.length(); ++var42_42) {
                var43_43 = var1_1.charAt(var42_42);
                switch (var40_40) {
                    case 0: 
                    case 2: {
                        if (var35_35) {
                            if (var43_43 == 34) {
                                if (var42_42 + 1 < var1_1.length() && var1_1.charAt(var42_42 + 1) == '\"') {
                                    var41_41.append(68);
                                    if (++var42_42 == var1_1.length()) {
                                        var22_22 = var42_42 + 1;
                                    }
                                } else {
                                    var35_35 = false;
                                }
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                        } else {
                            if (var43_43 == var8_8 || var43_43 == var3_3 || var43_43 == var14_14 || var43_43 == var4_4 || var43_43 == var5_5) {
                                if (this.m_TextPlaceHolderShown[var24_24]) {
                                    throw new IllegalArgumentException("Unexpected '#' in pattern \"" + this.m_OriginalPattern + '\"');
                                }
                                this.m_DigitShown[var24_24] = true;
                                var40_40 = 1;
                                --var42_42;
                                continue block9;
                            }
                            if (var43_43 == 164) {
                                v0 = var44_44 = var42_42 + 1 < var1_1.length() && var1_1.charAt(var42_42 + 1) == '\u00a4' ? 1 : 0;
                                if (var44_44 != 0) {
                                    ++var42_42;
                                }
                                this.m_IsCurrencyFormat = true;
                                var41_41.append(var44_44 != 0 ? "\"\u00a4\u00a4" : "\"\u00a4");
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == 34) {
                                if (var42_42 + 1 < var1_1.length() && var1_1.charAt(var42_42 + 1) == '\"') {
                                    ++var42_42;
                                    var41_41.append(68);
                                } else {
                                    var35_35 = true;
                                }
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var9_9) {
                                if (var24_24 == var23_23) {
                                    throw new IllegalArgumentException("Unquoted special character '" + (char)var43_43 + "' in pattern \"" + var1_1 + '\"');
                                }
                                var22_22 = var42_42 + 1;
                                var42_42 = var1_1.length();
                                continue block9;
                            }
                            if (var43_43 == var6_6) {
                                if (var20_20 != 1) {
                                    throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + var1_1 + '\"');
                                }
                                var20_20 = 100;
                                var41_41.append("\"%");
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var7_7) {
                                if (var20_20 != 1) {
                                    throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + var1_1 + '\"');
                                }
                                var20_20 = 1000;
                                var41_41.append("\"\u2030");
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var11_11) {
                                var41_41.append("\"-");
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var15_15) {
                                if (var40_40 == 0) {
                                    var34_34 = var41_41.length() == 0 ? 0 : 1;
                                } else if (var40_40 == 2) {
                                    var34_34 = var41_41.length() == 0 ? 2 : 3;
                                }
                                if (var42_42 + 1 < var1_1.length()) {
                                    this.m_RepeatChars[var24_24] = String.valueOf(var1_1.charAt(var42_42 + 1));
                                }
                                if (++var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var16_16) {
                                if (var42_42 + 1 < var1_1.length()) {
                                    this.m_SkipChars[var24_24] = String.valueOf(var1_1.charAt(var42_42 + 1));
                                }
                                if (var42_42 + 2 < var1_1.length() && var1_1.charAt(var42_42 + 2) == var9_9 || var1_1.length() == var42_42 + 2) {
                                    var37_37.append("\" ");
                                } else {
                                    var41_41.append("\" ");
                                }
                                if (++var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var17_17) {
                                if (this.m_DigitShown[var24_24]) {
                                    throw new IllegalArgumentException("Unexpected '@' in pattern \"" + this.m_OriginalPattern + '\"');
                                }
                                this.m_TextPlaceHolderShown[var24_24] = true;
                                var40_40 = 1;
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var18_18) {
                                if (var42_42 + 1 < var1_1.length()) {
                                    if (this.m_RepeatChars[var24_24] != null && var40_40 == 0) {
                                        var38_38.append(var1_1.charAt(var42_42 + 1));
                                    } else {
                                        var41_41.append(var1_1.charAt(var42_42 + 1));
                                    }
                                }
                                if (++var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == 91) {
                                var44_45 = new StringBuffer();
                                while (++var42_42 < var1_1.length() && var1_1.charAt(var42_42) != ']') {
                                    var44_45.append(var1_1.charAt(var42_42));
                                }
                                var45_46 = var44_45.toString();
                                var46_49 = false;
                                for (var47_51 = 0; var47_51 < ExcelNumberFormat.COLOR_FORMAT_MASKS.length; ++var47_51) {
                                    if (!ExcelNumberFormat.COLOR_FORMAT_MASKS[var47_51].equals(var45_46)) continue;
                                    this.m_Colors[var24_24] = ExcelNumberFormat.COLOR_NUMS[var47_51];
                                    var46_49 = true;
                                    break;
                                }
                                if (!var46_49) {
                                    for (var47_51 = 0; var47_51 < ExcelNumberFormat.CONDITION_FORMAT_MASKS.length; ++var47_51) {
                                        var48_54 = var45_46.indexOf(ExcelNumberFormat.CONDITION_FORMAT_MASKS[var47_51]);
                                        if (var48_54 == -1) continue;
                                        this.m_Conditions[var24_24] = ExcelNumberFormat.CONDITION_NUMS[var47_51];
                                        var49_56 = var45_46.substring(var48_54 + ExcelNumberFormat.CONDITION_FORMAT_MASKS[var47_51].length(), var45_46.length());
                                        try {
                                            this.m_ConditionValues[var24_24] = var50_57 = new BigDecimal(var49_56);
                                            var46_49 = true;
                                            this.m_UseCondition = true;
                                            break;
                                        }
                                        catch (NumberFormatException var50_58) {
                                            throw new IllegalArgumentException("Condition is not defined properly with \"" + var1_1 + '\"');
                                        }
                                    }
                                }
                                if (!var46_49 && var45_46.startsWith("$")) {
                                    var47_52 = "";
                                    var48_54 = var45_46.indexOf("-");
                                    if (var48_54 != -1) {
                                        var47_52 = var45_46.substring(1, var48_54);
                                        var46_49 = true;
                                    } else {
                                        var47_52 = var45_46.substring(1, var45_46.length());
                                        var46_49 = true;
                                    }
                                    var41_41.append(var47_52);
                                }
                                if (!var46_49) {
                                    throw new IllegalArgumentException("Color or Condition is not defined properly with \"" + var1_1 + '\"');
                                }
                                if (var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                        }
                        if (!var35_35) {
                            for (var44_44 = 0; var44_44 < ExcelNumberFormat.profibitedMask.length; ++var44_44) {
                                if (var43_43 != ExcelNumberFormat.profibitedMask[var44_44]) continue;
                                throw new IllegalArgumentException("'" + ExcelNumberFormat.profibitedMask[var44_44] + "' in \"" + this.m_OriginalPattern + '\"' + " is not allowed to use in number formatting.");
                            }
                        }
                        if (this.m_RepeatChars[var24_24] != null && var40_40 == 0) {
                            var38_38.append((char)var43_43);
                        } else {
                            var41_41.append((char)var43_43);
                        }
                        if (var42_42 != var1_1.length() - 1) ** GOTO lbl392
                        var22_22 = var42_42 + 1;
                        ** GOTO lbl392
                    }
                    case 1: {
                        if (var43_43 != var8_8) ** GOTO lbl255
                        if (var29_29 > 0 && var25_25 < 0 || var28_28 > 0 && var25_25 < 0) {
                            throw new IllegalArgumentException("Unexpected '#' in pattern \"" + this.m_OriginalPattern + '\"');
                        }
                        if (var29_29 > 0 || var28_28 > 0) {
                            ++var31_31;
                        } else {
                            ++var27_27;
                        }
                        if (var32_32 >= 0 && var25_25 < 0) {
                            var32_32 = (byte)(var32_32 + 1);
                        }
                        ** GOTO lbl392
lbl255:
                        // 1 sources

                        if (var43_43 != var14_14) ** GOTO lbl263
                        if (var29_29 > 0) {
                            ++var30_30;
                        } else {
                            ++var28_28;
                        }
                        if (var32_32 >= 0 && var25_25 < 0) {
                            var32_32 = (byte)(var32_32 + 1);
                        }
                        ** GOTO lbl392
lbl263:
                        // 1 sources

                        if (var43_43 != var3_3) ** GOTO lbl270
                        if (var30_30 > 0 || var31_31 > 0) {
                            throw new IllegalArgumentException("Unexpected '0' in pattern \"" + this.m_OriginalPattern + '\"');
                        }
                        ++var29_29;
                        if (var32_32 >= 0 && var25_25 < 0) {
                            var32_32 = (byte)(var32_32 + 1);
                        }
                        ** GOTO lbl392
lbl270:
                        // 1 sources

                        if (var43_43 != var4_4) ** GOTO lbl288
                        if (var42_42 + 1 < var1_1.length() && var1_1.charAt(var42_42 + 1) == var4_4) {
                            var26_26 += var39_39 != false ? var32_32 : 3;
                        } else if (var42_42 + 1 < var1_1.length() && var1_1.charAt(var42_42 + 1) == var5_5) {
                            var26_26 += var39_39 != false ? var32_32 : 3;
                        } else if (var42_42 + 1 < var1_1.length() && var1_1.charAt(var42_42 + 1) == var9_9) {
                            var26_26 += var39_39 != false ? var32_32 : 3;
                        } else if (var42_42 == var1_1.length() - 1) {
                            var26_26 += var39_39 != false ? var32_32 : 3;
                        } else {
                            if (var39_39) {
                                var33_33 = var32_32;
                            }
                            var32_32 = 0;
                            var39_39 = true;
                        }
                        ** GOTO lbl392
lbl288:
                        // 1 sources

                        if (var43_43 == var5_5) {
                            if (var25_25 >= 0) {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + var1_1 + '\"');
                            }
                            var25_25 = var28_28 + var27_27 + var29_29 + var31_31 + var30_30;
                        } else {
                            if (var43_43 == var13_13 || var43_43 == Character.toLowerCase((char)var13_13)) {
                                if (this.m_UseFraction[var24_24]) {
                                    throw new IllegalArgumentException("Multiple fraction symbols in pattern \"" + var1_1 + '\"');
                                }
                                var37_37 = new StringBuffer();
                                this.m_UseFraction[var24_24] = true;
                                this.m_MinFractionDigits[var24_24] = 0;
                                var44_44 = var42_42;
                                var45_47 = 0;
                                while (++var45_47 < var42_42 && var1_1.charAt(var42_42 - var45_47) != ' ') {
                                    if (var1_1.charAt(var42_42 - var45_47) == var3_3) {
                                        if (var29_29 <= 0) continue;
                                        --var29_29;
                                        var32_32 = (byte)(var32_32 - 1);
                                        continue;
                                    }
                                    if (var1_1.charAt(var42_42 - var45_47) == var8_8) {
                                        if (var29_29 > 0) {
                                            if (var31_31 <= 0) continue;
                                            --var31_31;
                                            var32_32 = (byte)(var32_32 - 1);
                                            continue;
                                        }
                                        if (var27_27 <= 0) continue;
                                        --var27_27;
                                        var32_32 = (byte)(var32_32 - 1);
                                        continue;
                                    }
                                    if (var1_1.charAt(var42_42 - 1) != var14_14) continue;
                                    if (var29_29 > 0) {
                                        if (var30_30 <= 0) continue;
                                        --var30_30;
                                        var32_32 = (byte)(var32_32 - 1);
                                        continue;
                                    }
                                    if (var28_28 <= 0) continue;
                                    --var28_28;
                                    var32_32 = (byte)(var32_32 - 1);
                                }
                                ++var44_44;
                                var46_50 = new StringBuffer();
                                var47_53 = false;
                                while (var44_44 < var1_1.length()) {
                                    if (var1_1.charAt(var44_44) == var3_3 || var1_1.charAt(var44_44) == var8_8 || var1_1.charAt(var44_44) == var14_14) {
                                        if (var46_50.length() > 0) {
                                            throw new IllegalArgumentException("Malformed fraction pattern \"" + this.m_OriginalPattern + '\"');
                                        }
                                        var47_53 = true;
                                        v1 = var24_24;
                                        this.m_MinFractionDigits[v1] = this.m_MinFractionDigits[v1] + 1;
                                    } else {
                                        if (!Character.isDigit(var1_1.charAt(var44_44))) break;
                                        if (var47_53) {
                                            throw new IllegalArgumentException("Malformed fraction pattern \"" + this.m_OriginalPattern + '\"');
                                        }
                                        var46_50.append(var1_1.charAt(var44_44));
                                    }
                                    ++var44_44;
                                }
                                if (var46_50.length() > 0) {
                                    try {
                                        this.m_FractionNum[var24_24] = var48_54 = Integer.parseInt(var46_50.toString());
                                        if (this.m_FractionNum[var24_24] <= 0) {
                                            throw new IllegalArgumentException("Malformed fraction pattern \"" + this.m_OriginalPattern + '\"');
                                        }
                                        this.m_MinFractionDigits[var24_24] = Integer.toString(var48_54).length();
                                    }
                                    catch (NumberFormatException var48_55) {
                                        throw new IllegalArgumentException("Malformed fraction pattern \"" + this.m_OriginalPattern + '\"');
                                    }
                                }
                                this.setMinimumFractionDigits(20);
                                var42_42 = var44_44;
                                var40_40 = 2;
                                var41_41 = var37_37;
                                if (--var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            if (var43_43 == var10_10 || var43_43 == Character.toLowerCase((char)var10_10)) {
                                if (this.m_UseExponentialNotation[var24_24]) {
                                    throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + var1_1 + '\"');
                                }
                                this.m_UseExponentialNotation[var24_24] = true;
                                if (var42_42 + 1 < var1_1.length()) {
                                    if (var1_1.charAt(var42_42 + 1) == var12_12) {
                                        this.m_UseExponentialSign[var24_24] = true;
                                        ++var42_42;
                                    } else if (var1_1.charAt(var42_42 + 1) == var11_11) {
                                        ++var42_42;
                                    }
                                }
                                this.m_MinExponentDigits[var24_24] = 0;
                                while (var42_42 < var1_1.length()) {
                                    if (var1_1.charAt(var42_42) == var3_3 || var1_1.charAt(var42_42) == var8_8 || var1_1.charAt(var42_42) == var14_14) {
                                        v2 = var24_24;
                                        this.m_MinExponentDigits[v2] = (byte)(this.m_MinExponentDigits[v2] + 1);
                                    } else if (var1_1.charAt(var42_42) != var12_12 && var1_1.charAt(var42_42) != var11_11) break;
                                    ++var42_42;
                                }
                                if (var27_27 + var28_28 + var29_29 < 1 || this.m_MinExponentDigits[var24_24] < 1) {
                                    throw new IllegalArgumentException("Malformed exponential pattern \"" + this.m_OriginalPattern + '\"');
                                }
                                var40_40 = 2;
                                var41_41 = var37_37;
                                if (--var42_42 != var1_1.length() - 1) continue block9;
                                var22_22 = var42_42 + 1;
                                continue block9;
                            }
                            var40_40 = 2;
                            var41_41 = var37_37;
                            --var42_42;
                            continue block9;
                        }
                    }
lbl392:
                    // 12 sources

                    default: {
                        if (var42_42 != var1_1.length() - 1) continue block9;
                        var22_22 = var42_42 + 1;
                    }
                }
            }
            if (var29_29 == 0 && var27_27 > 0 && var25_25 >= 0) {
                var42_42 = var25_25;
                if (var42_42 == 0) {
                    ++var42_42;
                }
                var31_31 = var27_27 - var42_42;
                var27_27 = var42_42 - 1;
                var29_29 = 1;
            }
            if (var29_29 == 0 && var28_28 > 0 && var25_25 >= 0) {
                var42_42 = var25_25;
                if (var42_42 == 0) {
                    ++var42_42;
                }
                var30_30 = var28_28 - var42_42;
                var28_28 = var42_42 - 1;
                var29_29 = 1;
            }
            if (var25_25 < 0 && var31_31 > 0 || var25_25 >= 0 && (var25_25 < var28_28 + var27_27 || var25_25 > var28_28 + var27_27 + var29_29) || var32_32 == 0 || var35_35) {
                throw new IllegalArgumentException("Malformed pattern \"" + this.m_OriginalPattern + '\"');
            }
            this.m_PrefixPatterns[var24_24] = var36_36.toString();
            this.m_SuffixPatterns[var24_24] = var37_37.toString();
            this.m_Prefix2Patterns[var24_24] = var38_38.toString();
            var42_42 = var28_28 + var27_27 + var29_29 + var31_31 + var30_30;
            var43_43 = var27_27 + var29_29 + var31_31;
            var44_44 = var25_25 >= 0 ? var25_25 : var42_42;
            this.m_IntegerSpaceCount[var24_24] = var28_28;
            this.m_FractionSpaceCount[var24_24] = var30_30;
            this.setMinimumIntegerDigits(var24_24, var44_44 - var27_27);
            this.setMaximumIntegerDigits(var24_24, this.m_UseExponentialNotation[var24_24] != false ? var27_27 + this.getMinimumIntegerDigits(var24_24) : 309);
            if (!this.m_UseFraction[var24_24]) {
                this.setMaximumFractionDigits(var24_24, var25_25 >= 0 ? var42_42 - var25_25 : 0);
                this.setMinimumFractionDigits(var24_24, var25_25 >= 0 ? var27_27 + var28_28 + var29_29 + var30_30 - var25_25 : 0);
            }
            this.setGroupingUsed(var24_24, var32_32 > 0);
            v3 = var32_32 > 0 ? (var32_32 == 1 ? 3 : var32_32) : (this.m_FirstGroupingSize[var24_24] = 0);
            this.m_SecondGroupingSize[var24_24] = var33_33 > 0 && var33_33 != var32_32 ? (var33_33 == 1 ? 3 : var33_33) : this.m_FirstGroupingSize[var24_24];
            this.setMultiplier(var24_24, var20_20);
            this.setScale(var24_24, var26_26);
            this.setDecimalSeparatorAlwaysShown(var24_24, var25_25 == 0 || var25_25 == var42_42);
            this.m_RepeatPositions[var24_24] = var34_34;
            if (var24_24 == 0) {
                for (var45_48 = 1; var45_48 < 3; ++var45_48) {
                    this.m_DigitShown[var45_48] = this.m_DigitShown[var24_24];
                    this.m_TextPlaceHolderShown[var45_48] = this.m_TextPlaceHolderShown[var24_24];
                    this.m_UseFraction[var45_48] = this.m_UseFraction[var24_24];
                    this.m_FractionNum[var45_48] = this.m_FractionNum[var24_24];
                    this.m_UseExponentialNotation[var45_48] = this.m_UseExponentialNotation[var24_24];
                    this.m_UseExponentialSign[var45_48] = this.m_UseExponentialSign[var24_24];
                    this.m_MinFractionDigits[var45_48] = this.m_MinFractionDigits[var24_24];
                    this.m_MinExponentDigits[var45_48] = this.m_MinExponentDigits[var24_24];
                    this.m_IntegerSpaceCount[var45_48] = var28_28;
                    this.m_FractionSpaceCount[var45_48] = var30_30;
                    this.m_PrefixPatterns[var45_48] = this.m_PrefixPatterns[var24_24];
                    this.m_SuffixPatterns[var45_48] = this.m_SuffixPatterns[var24_24];
                    this.m_Prefix2Patterns[var45_48] = this.m_Prefix2Patterns[var24_24];
                    this.setMinimumIntegerDigits(var45_48, this.getMinimumIntegerDigits(var24_24));
                    this.setMaximumIntegerDigits(var45_48, this.getMaximumIntegerDigits(var24_24));
                    this.setMinimumFractionDigits(var45_48, this.getMinimumFractionDigits(var24_24));
                    this.setMaximumFractionDigits(var45_48, this.getMaximumFractionDigits(var24_24));
                    this.setGroupingUsed(var45_48, var32_32 > 0);
                    this.m_FirstGroupingSize[var45_48] = this.m_FirstGroupingSize[var24_24];
                    this.m_SecondGroupingSize[var45_48] = this.m_SecondGroupingSize[var24_24];
                }
                for (var45_48 = 1; var45_48 < 4; ++var45_48) {
                    this.m_RepeatChars[var45_48] = this.m_RepeatChars[var24_24];
                    this.m_RepeatPositions[var45_48] = var34_34;
                }
                continue;
            }
            if (var24_24 != 1) continue;
            var19_19 = true;
        }
        if (var1_1.length() == 0) {
            this.m_SuffixPatterns[0] = "";
            this.m_PrefixPatterns[0] = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(309);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(340);
        }
        if (!this.m_UseCondition && (!var19_19 || this.m_PrefixPatterns[1].equals(this.m_PrefixPatterns[0]) && this.m_SuffixPatterns[1].equals(this.m_SuffixPatterns[0]))) {
            this.m_SuffixPatterns[1] = this.m_SuffixPatterns[0];
            this.m_PrefixPatterns[1] = "\"-" + this.m_PrefixPatterns[0];
        }
        this.expandAffixes();
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            if (this.m_PrefixPatterns[i] != null) {
                this.m_Prefixes[i] = this.expandAffix(this.m_PrefixPatterns[i], stringBuffer);
            }
            if (this.m_SuffixPatterns[i] != null) {
                this.m_Suffixes[i] = this.expandAffix(this.m_SuffixPatterns[i], stringBuffer);
            }
            if (this.m_Prefix2Patterns[i] == null) continue;
            this.m_Prefixes2[i] = this.expandAffix(this.m_Prefix2Patterns[i], stringBuffer);
        }
    }

    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        block6: while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\"') {
                c = string.charAt(n++);
                switch (c) {
                    case '\u00a4': {
                        if (n < string.length() && string.charAt(n) == '\u00a4') {
                            ++n;
                            stringBuffer.append(this.m_Symbols.mIntlCurrencySymbol);
                            continue block6;
                        }
                        stringBuffer.append(this.m_Symbols.mCurrencySymbol);
                        continue block6;
                    }
                    case '%': {
                        c = this.m_Symbols.mPercent;
                        break;
                    }
                    case '\u2030': {
                        c = this.m_Symbols.mPerMill;
                        break;
                    }
                    case '-': {
                        c = this.m_Symbols.mMinusSign;
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean subparse(String string, ParsePosition parsePosition, DigitList digitList, boolean bl, boolean[] blArray) {
        int n = parsePosition.mIndex;
        int n2 = parsePosition.mIndex;
        boolean bl2 = string.regionMatches(n, this.m_Prefixes[0], 0, this.m_Prefixes[0].length());
        boolean bl3 = string.regionMatches(n, this.m_Prefixes[1], 0, this.m_Prefixes[1].length());
        if (bl2 && bl3) {
            if (this.m_Prefixes[0].length() > this.m_Prefixes[1].length()) {
                bl3 = false;
            } else if (this.m_Prefixes[0].length() < this.m_Prefixes[1].length()) {
                bl2 = false;
            }
        }
        if (bl2) {
            n += this.m_Prefixes[0].length();
        } else if (bl3) {
            n += this.m_Prefixes[1].length();
        } else {
            parsePosition.mErrorIndex = n;
            return false;
        }
        blArray[0] = false;
        if (!bl && string.regionMatches(n, this.m_Symbols.mInfinity, 0, this.m_Symbols.mInfinity.length())) {
            n += this.m_Symbols.mInfinity.length();
            blArray[0] = true;
        } else {
            digitList.mCount = 0;
            digitList.mDecimalAt = 0;
            char c = this.m_Symbols.mZeroDigit;
            char c2 = this.m_IsCurrencyFormat ? this.m_Symbols.mMonetarySeparator : this.m_Symbols.mDecimalSeparator;
            char c3 = this.m_Symbols.mGroupingSeparator;
            char c4 = Character.toUpperCase(this.m_Symbols.mExponential);
            char c5 = this.m_Symbols.mPlusSign;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            while (n < string.length()) {
                char c6 = string.charAt(n);
                int n6 = c6 - c;
                if (n6 < 0 || n6 > 9) {
                    n6 = Character.digit(c6, 10);
                }
                if (n6 == 0) {
                    n5 = -1;
                    bl6 = true;
                    if (digitList.mCount == 0) {
                        if (bl4) {
                            --digitList.mDecimalAt;
                        }
                    } else {
                        ++n4;
                        digitList.append((char)(n6 + 48));
                    }
                } else if (n6 > 0 && n6 <= 9) {
                    bl6 = true;
                    ++n4;
                    digitList.append((char)(n6 + 48));
                    n5 = -1;
                } else if (!bl && c6 == c2) {
                    if (this.isParseIntegerOnly() || bl4) break;
                    digitList.mDecimalAt = n4;
                    bl4 = true;
                } else if (!bl && c6 == c3 && this.isGroupingUsed()) {
                    if (bl4) break;
                    n5 = n;
                } else {
                    if (!(bl || c6 != c4 && c6 != Character.toLowerCase(c4) || bl5)) {
                        boolean[] blArray2;
                        DigitList digitList2;
                        ParsePosition parsePosition2;
                        if (n + 1 < string.length() && string.charAt(n + 1) == c5) {
                            ++n;
                        }
                        if (!this.subparse(string, parsePosition2 = new ParsePosition(n + 1), digitList2 = new DigitList(), true, blArray2 = new boolean[2])) break;
                        n = parsePosition2.mIndex;
                        n3 = (int)digitList2.getLong();
                        if (!blArray2[1]) {
                            n3 = -n3;
                        }
                        bl5 = true;
                        break;
                    }
                    if (bl || c6 != '\"') break;
                    while (n < string.length()) {
                        char c7 = string.charAt(n);
                        if (c6 == '\"') break;
                        ++n;
                    }
                }
                ++n;
            }
            if (n5 != -1) {
                n = n5;
            }
            if (!bl4) {
                digitList.mDecimalAt = n4;
            }
            digitList.mDecimalAt += n3;
            if (!bl6 && n4 == 0) {
                parsePosition.mIndex = n2;
                parsePosition.mErrorIndex = n2;
                return false;
            }
        }
        if (bl2) {
            bl2 = string.regionMatches(n, this.m_Suffixes[0], 0, this.m_Suffixes[0].length());
        }
        if (bl3) {
            bl3 = string.regionMatches(n, this.m_Suffixes[1], 0, this.m_Suffixes[1].length());
        }
        if (bl2 && bl3) {
            if (this.m_Suffixes[0].length() > this.m_Suffixes[1].length()) {
                bl3 = false;
            } else if (this.m_Suffixes[0].length() < this.m_Suffixes[1].length()) {
                bl2 = false;
            }
        }
        if (bl2 == bl3) {
            parsePosition.mErrorIndex = n;
            return false;
        }
        parsePosition.mIndex = n + (bl2 ? this.m_Suffixes[0].length() : this.m_Suffixes[1].length());
        blArray[1] = bl2;
        if (parsePosition.mIndex == n2) {
            parsePosition.mErrorIndex = n;
            return false;
        }
        return true;
    }

    private static int[] getFractionValue(double d, int n) {
        if (n == 0) {
            int[] nArray = new int[]{0, 0};
            return nArray;
        }
        double d2 = 1.0 / (double)n;
        int n2 = 1;
        if (n > 500) {
            int n3 = n / 500;
            for (int i = 1; i < n3; ++i) {
                if (!(d < (double)(i / n3)) || i - 1 <= 0) continue;
                n2 = n / i - 1;
                break;
            }
        }
        while (n2 <= n && !(d <= d2 * (double)n2)) {
            ++n2;
        }
        double d3 = (double)n2 / (double)n;
        double d4 = (double)(n2 - 1) / (double)n;
        int[] nArray = new int[]{n2, n};
        if (Math.abs(d - d3) > Math.abs(d - d4)) {
            nArray[0] = n2 - 1;
        }
        return nArray;
    }

    private static int[] getCloseFractionValue(double d, int n) {
        double d2;
        double d3;
        double d4;
        int n2;
        int n3 = 1;
        double d5 = d;
        for (n2 = 0; n2 < n; ++n2) {
            d5 *= 10.0;
            n3 *= 10;
        }
        n2 = (int)d5 % n3 - 1;
        if (n3 == 10) {
            n2 = (int)d5 % n3;
        }
        double d6 = 0.0;
        if (n3 != 10) {
            int n4 = (int)(d * (double)n3 / 10.0) + 1;
            d6 = (double)(n4 *= 10) / (double)n3;
        }
        int[] nArray = new int[]{n2, n3};
        int n5 = 0;
        while (nArray[1] - n5 != 0 && !((d4 = (double)nArray[0] / (double)(nArray[1] - n5)) > d)) {
            ++n5;
        }
        int n6 = 0;
        while (!((d3 = (double)(nArray[0] - n6) / (double)(nArray[1] - n5)) < d)) {
            ++n6;
        }
        int n7 = 0;
        while (!((d2 = (double)(nArray[0] + n7) / (double)(nArray[1] - (n5 - 1))) > d)) {
            ++n7;
        }
        int[] nArray2 = new int[]{nArray[0] - n6, nArray[1] - n5};
        int[] nArray3 = new int[]{nArray[0] + n7 - 1, nArray[1] - (n5 - 1)};
        int[] nArray4 = ExcelNumberFormat.calculateCloseFraction(nArray2, d, d6);
        int[] nArray5 = ExcelNumberFormat.calculateCloseFraction(nArray3, d, d6);
        double d7 = (double)nArray4[0] / (double)nArray4[1];
        double d8 = (double)nArray5[0] / (double)nArray5[1];
        if (Math.abs(d - d7) < Math.abs(d - d8)) {
            return nArray4;
        }
        return nArray5;
    }

    private static int[] calculateCloseFraction(int[] nArray, double d, double d2) {
        int[] nArray2 = new int[]{nArray[0], nArray[1]};
        if (nArray[1] == 0) {
            nArray2[0] = 0;
            nArray2[1] = 0;
            return nArray2;
        }
        boolean bl = false;
        double d3 = (double)nArray[0] / (double)nArray[1];
        int n = 1;
        int n2 = 1;
        while (nArray[0] - n2 > 0 && !bl) {
            int n3 = n;
            while (nArray[1] - n3 > 0) {
                double d4 = n2 * nArray[1];
                double d5 = n3 * nArray[0];
                if (d4 < d5) {
                    double d6 = (double)(nArray[0] - n2) / (double)(nArray[1] - n3);
                    if (Math.abs(d - d3) > Math.abs(d - d6)) {
                        d3 = d6;
                        nArray2[0] = nArray[0] - n2;
                        nArray2[1] = nArray[1] - n3;
                    }
                    if (d6 > d2 || d6 < 0.0) {
                        bl = true;
                    }
                    n = n3;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        n2 = ExcelNumberFormat.getGCF(nArray2[1], nArray2[0]);
        if (n2 != 1 || n2 != 0) {
            nArray2[0] = nArray2[0] / n2;
            nArray2[1] = nArray2[1] / n2;
        }
        return nArray2;
    }

    private static int getGCF(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = n % n2;
        if (n3 == 0) {
            return n2;
        }
        return ExcelNumberFormat.getGCF(n2, n3);
    }

    private void reset() {
        for (int i = 0; i < 4; ++i) {
            this.m_Divider[i] = 1;
            this.m_Scale[i] = 0;
            this.m_IntegerSpaceCount[i] = 0;
            this.m_FractionSpaceCount[i] = 0;
            this.m_DigitShown[i] = false;
            this.m_TextPlaceHolderShown[i] = false;
            this.m_DecimalSeparatorAlwaysShown[i] = false;
            this.m_GroupingUsed[i] = true;
            this.m_UseFraction[i] = false;
            this.m_MinFractionDigits[i] = 0;
            this.m_FractionNum[i] = -1;
            this.m_UseExponentialNotation[i] = false;
            this.m_UseExponentialSign[i] = false;
            this.m_MinExponentDigits[i] = 0;
            this.m_MinimumIntegerDigits[i] = 0;
            this.m_MaximumIntegerDigits[i] = 0;
            this.m_MinimumFractionDigits[i] = 0;
            this.m_MaximumFractionDigits[i] = 0;
            this.m_Prefixes2[i] = "";
            this.m_Suffixes[i] = "";
            this.m_PrefixPatterns[i] = null;
            this.m_Prefix2Patterns[i] = null;
            this.m_SuffixPatterns[i] = null;
            this.m_RepeatChars[i] = null;
            this.m_RepeatPositions[i] = -1;
            this.m_SkipChars[i] = null;
            this.m_Colors[i] = -1;
            this.m_ConditionValues[i] = new BigDecimal("0");
        }
        this.m_Prefixes[0] = "";
        this.m_Prefixes[1] = "-";
        this.m_Prefixes[2] = "";
        this.m_Prefixes[3] = "";
        this.m_Conditions[0] = 4;
        this.m_Conditions[1] = 5;
        this.m_Conditions[2] = 3;
        this.m_Conditions[3] = -1;
        this.m_UseCondition = false;
        this.m_IsCurrencyFormat = false;
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.m_Prefixes[0].hashCode() + this.m_Prefixes[1].hashCode() + this.m_Prefixes[2].hashCode() + this.m_Prefixes[3].hashCode();
    }

    public Object clone() {
        try {
            ExcelNumberFormat excelNumberFormat = (ExcelNumberFormat)super.clone();
            excelNumberFormat.m_Symbols = (ExcelNumberFormatSymbols)this.m_Symbols.clone();
            excelNumberFormat.m_DigitList = (DigitList)this.m_DigitList.clone();
            return excelNumberFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ExcelNumberFormat excelNumberFormat = (ExcelNumberFormat)object;
        return (this.m_PrefixPatterns[0] == excelNumberFormat.m_PrefixPatterns[0] && this.m_Prefixes[0].equals(excelNumberFormat.m_Prefixes[0]) || this.m_PrefixPatterns[0] != null && this.m_PrefixPatterns[0].equals(excelNumberFormat.m_PrefixPatterns[0])) && (this.m_SuffixPatterns[0] == excelNumberFormat.m_SuffixPatterns[0] && this.m_Suffixes[0].equals(excelNumberFormat.m_Suffixes[0]) || this.m_SuffixPatterns[0] != null && this.m_SuffixPatterns[0].equals(excelNumberFormat.m_SuffixPatterns[0])) && (this.m_PrefixPatterns[1] == excelNumberFormat.m_PrefixPatterns[1] && this.m_Prefixes[1].equals(excelNumberFormat.m_Prefixes[1]) || this.m_PrefixPatterns[1] != null && this.m_PrefixPatterns[1].equals(excelNumberFormat.m_PrefixPatterns[1])) && (this.m_SuffixPatterns[1] == excelNumberFormat.m_SuffixPatterns[1] && this.m_Suffixes[1].equals(excelNumberFormat.m_Suffixes[1]) || this.m_SuffixPatterns[1] != null && this.m_SuffixPatterns[1].equals(excelNumberFormat.m_SuffixPatterns[1])) && (this.m_PrefixPatterns[2] == excelNumberFormat.m_PrefixPatterns[2] && this.m_Prefixes[2].equals(excelNumberFormat.m_Prefixes[2]) || this.m_PrefixPatterns[2] != null && this.m_PrefixPatterns[2].equals(excelNumberFormat.m_PrefixPatterns[2])) && (this.m_SuffixPatterns[2] == excelNumberFormat.m_SuffixPatterns[2] && this.m_Suffixes[2].equals(excelNumberFormat.m_Suffixes[2]) || this.m_SuffixPatterns[2] != null && this.m_SuffixPatterns[2].equals(excelNumberFormat.m_SuffixPatterns[2])) && (this.m_PrefixPatterns[3] == excelNumberFormat.m_PrefixPatterns[3] && this.m_Prefixes[3].equals(excelNumberFormat.m_Prefixes[3]) || this.m_PrefixPatterns[3] != null && this.m_PrefixPatterns[3].equals(excelNumberFormat.m_PrefixPatterns[3])) && (this.m_SuffixPatterns[3] == excelNumberFormat.m_SuffixPatterns[3] && this.m_Suffixes[3].equals(excelNumberFormat.m_Suffixes[3]) || this.m_SuffixPatterns[3] != null && this.m_SuffixPatterns[3].equals(excelNumberFormat.m_SuffixPatterns[3])) && this.m_Multiplier == excelNumberFormat.m_Multiplier && this.m_Divider == excelNumberFormat.m_Divider && this.m_Scale == excelNumberFormat.m_Scale && this.m_FirstGroupingSize[0] == excelNumberFormat.m_FirstGroupingSize[0] && this.m_FirstGroupingSize[1] == excelNumberFormat.m_FirstGroupingSize[1] && this.m_FirstGroupingSize[2] == excelNumberFormat.m_FirstGroupingSize[2] && this.m_FirstGroupingSize[3] == excelNumberFormat.m_FirstGroupingSize[3] && this.m_SecondGroupingSize[0] == excelNumberFormat.m_SecondGroupingSize[0] && this.m_SecondGroupingSize[1] == excelNumberFormat.m_SecondGroupingSize[1] && this.m_SecondGroupingSize[2] == excelNumberFormat.m_SecondGroupingSize[2] && this.m_SecondGroupingSize[3] == excelNumberFormat.m_SecondGroupingSize[3] && this.m_DecimalSeparatorAlwaysShown[0] == excelNumberFormat.m_DecimalSeparatorAlwaysShown[0] && this.m_DecimalSeparatorAlwaysShown[1] == excelNumberFormat.m_DecimalSeparatorAlwaysShown[1] && this.m_DecimalSeparatorAlwaysShown[2] == excelNumberFormat.m_DecimalSeparatorAlwaysShown[2] && this.m_DecimalSeparatorAlwaysShown[3] == excelNumberFormat.m_DecimalSeparatorAlwaysShown[3] && this.m_UseExponentialNotation[0] == excelNumberFormat.m_UseExponentialNotation[0] && this.m_UseExponentialNotation[1] == excelNumberFormat.m_UseExponentialNotation[1] && this.m_UseExponentialNotation[2] == excelNumberFormat.m_UseExponentialNotation[2] && this.m_UseExponentialNotation[3] == excelNumberFormat.m_UseExponentialNotation[3] && this.m_UseExponentialSign[0] == excelNumberFormat.m_UseExponentialSign[0] && this.m_UseExponentialSign[1] == excelNumberFormat.m_UseExponentialSign[1] && this.m_UseExponentialSign[2] == excelNumberFormat.m_UseExponentialSign[2] && this.m_UseExponentialSign[3] == excelNumberFormat.m_UseExponentialSign[3] && (!this.m_UseExponentialNotation[0] || this.m_MinExponentDigits[0] == excelNumberFormat.m_MinExponentDigits[0]) && (!this.m_UseExponentialNotation[1] || this.m_MinExponentDigits[1] == excelNumberFormat.m_MinExponentDigits[1]) && (!this.m_UseExponentialNotation[2] || this.m_MinExponentDigits[2] == excelNumberFormat.m_MinExponentDigits[2]) && (!this.m_UseExponentialNotation[3] || this.m_MinExponentDigits[3] == excelNumberFormat.m_MinExponentDigits[3]) && this.m_Symbols.equals(excelNumberFormat.m_Symbols);
    }
}

