/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DecimalFormat;
import oracle.apps.fnd.i18n.common.text.DecimalFormatSymbols;
import oracle.apps.fnd.i18n.common.text.FieldPosition;
import oracle.apps.fnd.i18n.common.text.Format;
import oracle.apps.fnd.i18n.common.text.ParsePosition;

public abstract class NumberFormat
extends Format {
    public static final String RCS_ID = "$Header: NumberFormat.java 120.0 2005/05/07 08:29:32 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: NumberFormat.java 120.0 2005/05/07 08:29:32 appldev ship $", "oracle.apps.fnd.i18n.common.text");
    private static final int NUMBERSTYLE = 0;
    private static final int PERCENTSTYLE = 2;
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static final Hashtable m_CachedLocaleData = new Hashtable(3);
    private boolean m_GroupingUsed = true;
    private boolean m_ParseIntegerOnly = false;
    private int m_MaximumIntegerDigits = 40;
    private int m_MinimumIntegerDigits = 1;
    private int m_MaximumFractionDigits = 3;
    private int m_MinimumFractionDigits = 0;

    public String format(double d) {
        return this.format(d, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(long l) {
        return this.format(l, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(BigDecimal bigDecimal) {
        return this.format(bigDecimal, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(BigInteger bigInteger) {
        return this.format(bigInteger, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Number number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Integer) {
            return this.format(((Integer)object).longValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof BigDecimal) {
            return this.format((BigDecimal)object, stringBuffer, fieldPosition);
        }
        if (object instanceof BigInteger) {
            return this.format((BigInteger)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(BigDecimal var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(BigInteger var1, StringBuffer var2, FieldPosition var3);

    public Number parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.parse(string, parsePosition);
        if (parsePosition.mIndex == 0) {
            throw new ParseException("Unparseable number: \"" + string + "\"", parsePosition.mErrorIndex);
        }
        return number;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public static Locale[] getAvailableLocales() {
        return java.text.NumberFormat.getAvailableLocales();
    }

    public int hashCode() {
        return this.m_MaximumIntegerDigits * 37 + this.m_MaximumFractionDigits;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NumberFormat numberFormat = (NumberFormat)object;
        return this.m_MaximumIntegerDigits == numberFormat.getMaximumIntegerDigits() && this.m_MinimumIntegerDigits == numberFormat.getMinimumIntegerDigits() && this.m_MaximumFractionDigits == numberFormat.getMaximumFractionDigits() && this.m_MinimumFractionDigits == numberFormat.getMinimumFractionDigits() && this.m_GroupingUsed == numberFormat.isGroupingUsed() && this.m_ParseIntegerOnly == numberFormat.isParseIntegerOnly();
    }

    public Object clone() {
        NumberFormat numberFormat = (NumberFormat)super.clone();
        return numberFormat;
    }

    public boolean isParseIntegerOnly() {
        return this.m_ParseIntegerOnly;
    }

    public void setParseIntegerOnly(boolean bl) {
        this.m_ParseIntegerOnly = bl;
    }

    public boolean isGroupingUsed() {
        return this.m_GroupingUsed;
    }

    public void setGroupingUsed(boolean bl) {
        this.m_GroupingUsed = bl;
    }

    public int getMaximumIntegerDigits() {
        return this.m_MaximumIntegerDigits;
    }

    public void setMaximumIntegerDigits(int n) {
        this.m_MaximumIntegerDigits = Math.max(0, n);
        if (this.m_MinimumIntegerDigits > this.m_MaximumIntegerDigits) {
            this.m_MinimumIntegerDigits = this.m_MaximumIntegerDigits;
        }
    }

    public int getMinimumIntegerDigits() {
        return this.m_MinimumIntegerDigits;
    }

    public void setMinimumIntegerDigits(int n) {
        this.m_MinimumIntegerDigits = Math.max(0, n);
        if (this.m_MinimumIntegerDigits > this.m_MaximumIntegerDigits) {
            this.m_MaximumIntegerDigits = this.m_MinimumIntegerDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.m_MaximumFractionDigits;
    }

    public void setMaximumFractionDigits(int n) {
        this.m_MaximumFractionDigits = Math.max(0, n);
        if (this.m_MaximumFractionDigits < this.m_MinimumFractionDigits) {
            this.m_MinimumFractionDigits = this.m_MaximumFractionDigits;
        }
    }

    public int getMinimumFractionDigits() {
        return this.m_MinimumFractionDigits;
    }

    public void setMinimumFractionDigits(int n) {
        this.m_MinimumFractionDigits = Math.max(0, n);
        if (this.m_MaximumFractionDigits < this.m_MinimumFractionDigits) {
            this.m_MaximumFractionDigits = this.m_MinimumFractionDigits;
        }
    }

    public static NumberFormat getInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 2);
    }

    private static NumberFormat getInstance(Locale locale, int n) {
        Cloneable cloneable;
        String string = locale.toString() + n;
        String string2 = (String)m_CachedLocaleData.get(locale.toString() + n);
        if (string2 == null) {
            switch (n) {
                case 0: {
                    cloneable = java.text.NumberFormat.getNumberInstance(locale);
                    string2 = ((java.text.DecimalFormat)cloneable).toPattern();
                    break;
                }
                case 2: {
                    cloneable = java.text.NumberFormat.getPercentInstance(locale);
                    string2 = ((java.text.DecimalFormat)cloneable).toPattern();
                    break;
                }
                default: {
                    cloneable = java.text.NumberFormat.getNumberInstance(locale);
                    string2 = ((java.text.DecimalFormat)cloneable).toPattern();
                    break;
                }
            }
            m_CachedLocaleData.put(string, string2);
        }
        cloneable = new DecimalFormatSymbols(locale);
        DecimalFormat decimalFormat = new DecimalFormat(11, string2, (DecimalFormatSymbols)cloneable);
        return decimalFormat;
    }
}

