/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DefaultNumberFormatter;

public abstract class NumberFormatter {
    public static final String RCS_ID = "$Header: NumberFormatter.java 120.0 2005/05/07 08:29:33 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: NumberFormatter.java 120.0 2005/05/07 08:29:33 appldev ship $", "oracle.apps.fnd.i18n.common.text");
    public static final int FORMAT_ORACLE = 10;
    public static final int FORMAT_JAVA = 11;
    public static final int FORMAT_MS = 12;
    protected int mRoundingMode = 6;
    protected int mScale = 0;

    public static NumberFormatter getInstance(Locale locale) {
        return new DefaultNumberFormatter(locale);
    }

    public String format(double d, int n, String string) {
        return this.format(d, n, string, (char[])null);
    }

    public abstract String format(double var1, int var3, String var4, char[] var5);

    public String format(long l, int n, String string) {
        return this.format(l, n, string, (char[])null);
    }

    public abstract String format(long var1, int var3, String var4, char[] var5);

    public String format(BigInteger bigInteger, int n, String string) {
        return this.format(bigInteger, n, string, null);
    }

    public abstract String format(BigInteger var1, int var2, String var3, char[] var4);

    public String format(BigDecimal bigDecimal, int n, String string) {
        return this.format(bigDecimal, n, string, null);
    }

    public abstract String format(BigDecimal var1, int var2, String var3, char[] var4);

    public String format(Number number, int n, String string) {
        return this.format(number, n, string, null);
    }

    public abstract String format(Number var1, int var2, String var3, char[] var4);

    public Number parse(String string, int n, String string2) throws ParseException {
        char[] cArray = null;
        return this.parse(string, n, string2, cArray);
    }

    public abstract Number parse(String var1, int var2, String var3, char[] var4) throws ParseException;

    public void setRoundingMode(int n) {
        this.mRoundingMode = n;
    }

    public int getRoundingMode() {
        return this.mRoundingMode;
    }

    public int getScale() {
        return this.mScale;
    }

    public void setScale(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative scale");
        }
        this.mScale = n;
    }

    public static boolean mlsFormatValidate(int n, String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        String string2 = new String();
        switch (n) {
            case 10: {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == '0' || cArray[i] == '9' || cArray[i] == 'D' || cArray[i] == 'G') continue;
                    string2 = string2 + cArray[i];
                }
                break;
            }
            default: {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == '0' || cArray[i] == '#' || cArray[i] == '.' || cArray[i] == ',' || cArray[i] == ';') continue;
                    string2 = string2 + cArray[i];
                }
            }
        }
        return string2.length() <= 0;
    }
}

