/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DateFormat;
import oracle.apps.fnd.i18n.common.text.DateFormatSymbols;
import oracle.apps.fnd.i18n.common.text.DecimalFormat;
import oracle.apps.fnd.i18n.common.text.FieldPosition;
import oracle.apps.fnd.i18n.common.text.NumberFormat;
import oracle.apps.fnd.i18n.common.text.ParsePosition;
import oracle.apps.fnd.i18n.common.text.resources.CalendarResourceAccessor;
import oracle.apps.fnd.i18n.common.util.Calendar;

public class SimpleDateFormat
extends DateFormat {
    public static final String RCS_ID = "$Header: SimpleDateFormat.java 120.15 2012/09/24 19:49:41 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: SimpleDateFormat.java 120.15 2012/09/24 19:49:41 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text");
    private static final String GMT = "GMT";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT_PLUS = "GMT+";
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15, 15, 17, 18, 19, 20, 1, 2, 5, 14, 1, 1, 0, 1, 6, 5, 21};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 1, 2, 3, 8, 1, 1, 0, 1, 10, 3, 22};
    private static final String[] DIGIT_WEEK_STRINGS = new String[]{"", "1", "2", "3", "4", "5", "6", "7"};
    private static final String[] DIGIT_MONTH_STRINGS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static final String[] DIGIT_MONTH_STRINGS_WITH_ZERO = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final char[] HAN_YEAR_CHARS = new char[]{'\u3007', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final String[] HAN_MONTH_STRINGS = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    private static final String[] HAN_DATE_STRINGS = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u4e8c\u5341\u4e00", "\u4e8c\u5341\u4e8c", "\u4e8c\u5341\u4e09", "\u4e8c\u5341\u56db", "\u4e8c\u5341\u4e94", "\u4e8c\u5341\u516d", "\u4e8c\u5341\u4e03", "\u4e8c\u5341\u516b", "\u4e8c\u5341\u4e5d", "\u4e09\u5341", "\u4e09\u5341\u4e00"};
    private static Hashtable m_CachedLocaleData = new Hashtable(3);
    private static Hashtable m_CachedConvertedPatternOracle = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternMS = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternJava = new Hashtable(50);
    private DateFormatSymbols m_Symbols;
    private Date m_DefaultCenturyStart;
    private transient int m_DefaultCenturyStartYear;
    private String m_Pattern;
    private int m_RoundingMode = 1;
    private transient char m_ZeroDigit;
    private char m_DecimalSeparator = (char)46;
    private Locale m_Locale;
    private Calendar m_LocalCalendar;
    private Calendar m_DefaultCalendar;
    private boolean m_LocalCalendarMode = false;

    public SimpleDateFormat() {
        this(11, 11, Locale.getDefault());
    }

    public SimpleDateFormat(Locale locale) {
        this(11, 11, locale);
    }

    SimpleDateFormat(int n, int n2, Locale locale) {
        this.m_Symbols = new DateFormatSymbols(locale);
        if (n >= 0 && n2 >= 0) {
            this.m_Pattern = CalendarResourceAccessor.getDateFormatMask(n2, locale) + " " + CalendarResourceAccessor.getTimeFormatMask(n, locale);
        } else if (n >= 0) {
            this.m_Pattern = CalendarResourceAccessor.getTimeFormatMask(n, locale);
        } else if (n2 >= 0) {
            this.m_Pattern = CalendarResourceAccessor.getDateFormatMask(n2, locale);
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(locale);
        this.applyPattern(11, this.m_Pattern);
    }

    public SimpleDateFormat(int n, String string) {
        this(n, string, Locale.getDefault());
    }

    public SimpleDateFormat(int n, String string, DateFormatSymbols dateFormatSymbols) {
        this.m_Symbols = (DateFormatSymbols)dateFormatSymbols.clone();
        this.initialize(this.m_Symbols.mLocale);
        this.applyPattern(n, string);
    }

    public SimpleDateFormat(int n, String string, Locale locale) {
        this.m_Symbols = new DateFormatSymbols(locale);
        this.initialize(locale);
        this.applyPattern(n, string);
    }

    public void applyPattern(int n, String string) {
        if (this.useLocalCalendar(n, string, this.m_Locale)) {
            this.m_LocalCalendarMode = true;
            if (this.mCalendar.getType() != this.m_LocalCalendar.getType()) {
                this.m_LocalCalendar.setTimestamp(this.mCalendar.getTimestamp());
                this.mCalendar = this.m_LocalCalendar;
                this.m_Symbols.setCalendarResources(this.mCalendar.getType());
            }
        } else {
            this.m_LocalCalendarMode = false;
            if (this.mCalendar.getType() != this.m_DefaultCalendar.getType()) {
                this.m_DefaultCalendar.setTimestamp(this.mCalendar.getTimestamp());
                this.mCalendar = this.m_DefaultCalendar;
                this.m_Symbols.setCalendarResources(this.mCalendar.getType());
            }
        }
        this.m_Pattern = this.translatePattern(n, string);
    }

    public Date get2DigitYearStart() {
        return this.m_DefaultCenturyStart;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.m_Symbols.clone();
    }

    public void set2DigitYearStart(Date date) {
        this.parseAmbiguousDatesAsAfter(date);
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.m_Symbols = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    public void setCalendar(Calendar calendar) {
        if (!this.m_LocalCalendarMode) {
            super.setCalendar(calendar);
            this.m_DefaultCalendar = calendar;
            this.m_Symbols.setCalendarResources(calendar.getType());
            this.initializeDefaultCentury();
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.m_LocalCalendar.setTimeZone(timeZone);
        this.m_DefaultCalendar.setTimeZone(timeZone);
    }

    public void setLenient(boolean bl) {
        super.setLenient(bl);
        this.m_LocalCalendar.setLenient(bl);
        this.m_DefaultCalendar.setLenient(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            this.mCalendar.setTime(date);
            return this.formatImpl(stringBuffer, fieldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Timestamp timestamp, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            this.mCalendar.setTimestamp(timestamp);
            return this.formatImpl(stringBuffer, fieldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Number number, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.mBeginIndex = 0;
        fieldPosition.mEndIndex = 0;
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            this.mCalendar.setTime(new Date(number.longValue()));
            return this.formatImpl(stringBuffer, fieldPosition);
        }
    }

    private StringBuffer formatImpl(StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl = false;
        char c = '\u0000';
        int n = 0;
        for (int i = 0; i < this.m_Pattern.length(); ++i) {
            char c2 = this.m_Pattern.charAt(i);
            if (c2 != c && n > 0) {
                this.subFormat(c, n, fieldPosition, stringBuffer);
                n = 0;
            }
            if (c2 == '\'') {
                if (i + 1 < this.m_Pattern.length() && this.m_Pattern.charAt(i + 1) == '\'') {
                    stringBuffer.append('\'');
                    ++i;
                    continue;
                }
                bl = !bl;
                continue;
            }
            if (!bl && (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                c = c2;
                ++n;
                continue;
            }
            stringBuffer.append(c2);
        }
        if (n > 0) {
            this.subFormat(c, n, fieldPosition, stringBuffer);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = n = parsePosition.mIndex;
        boolean[] blArray = new boolean[]{false};
        Calendar calendar = this.mCalendar;
        synchronized (calendar) {
            Date date;
            int n3;
            this.mCalendar.clear();
            boolean bl = false;
            char c = '\u0000';
            int n4 = 0;
            int n5 = 1;
            for (n3 = 0; n3 < this.m_Pattern.length(); ++n3) {
                int n6;
                char c2 = this.m_Pattern.charAt(n3);
                if (bl) {
                    if (c2 == '\'') {
                        bl = false;
                        if (n4 == 0) {
                            if (n >= string.length() || c2 != string.charAt(n)) {
                                parsePosition.mIndex = n2;
                                parsePosition.mErrorIndex = n;
                                return null;
                            }
                            ++n;
                        }
                        n4 = 0;
                        n5 = 0;
                        continue;
                    }
                    if (n >= string.length() || c2 != string.charAt(n)) {
                        parsePosition.mIndex = n2;
                        parsePosition.mErrorIndex = n;
                        return null;
                    }
                    ++n4;
                    ++n;
                    continue;
                }
                if (c2 == '\'') {
                    bl = true;
                    if (n4 > 0) {
                        n6 = n;
                        if ((n = this.subParse(string, n, c, n4, false, blArray)) < 0) {
                            parsePosition.mErrorIndex = n6;
                            parsePosition.mIndex = n2;
                            return null;
                        }
                        n4 = 0;
                    }
                    if (n5 == 0) {
                        n6 = n;
                        if (n >= string.length() || c2 != string.charAt(n)) {
                            parsePosition.mErrorIndex = n6;
                            parsePosition.mIndex = n2;
                            return null;
                        }
                        ++n;
                        n4 = 1;
                    }
                } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                    if (c2 != c && n4 > 0) {
                        n6 = n;
                        if ((n = this.subParse(string, n, c, n4, true, blArray)) < 0) {
                            parsePosition.mErrorIndex = n6;
                            parsePosition.mIndex = n2;
                            return null;
                        }
                        c = c2;
                        n4 = 1;
                    } else {
                        if (c2 != c) {
                            c = c2;
                        }
                        ++n4;
                    }
                } else if (n4 > 0) {
                    n6 = n;
                    if ((n = this.subParse(string, n, c, n4, false, blArray)) < 0) {
                        parsePosition.mErrorIndex = n6;
                        parsePosition.mIndex = n2;
                        return null;
                    }
                    if ((n >= string.length() || string.charAt(n) != '/' && string.charAt(n) != '-' && string.charAt(n) != '.' && string.charAt(n) != ' ' && string.charAt(n) != ':' && string.charAt(n) != ',') && (n >= string.length() || c2 != string.charAt(n))) {
                        parsePosition.mErrorIndex = n;
                        parsePosition.mIndex = n2;
                        return null;
                    }
                    ++n;
                    n4 = 0;
                    c = '\u0000';
                } else {
                    if (n >= string.length() || c2 != string.charAt(n)) {
                        parsePosition.mErrorIndex = n;
                        parsePosition.mIndex = n2;
                        return null;
                    }
                    ++n;
                }
                ++n5;
            }
            if (n4 > 0) {
                n3 = n;
                if ((n = this.subParse(string, n, c, n4, false, blArray)) < 0) {
                    parsePosition.mErrorIndex = n3;
                    parsePosition.mIndex = n2;
                    return null;
                }
            }
            parsePosition.mIndex = n;
            try {
                if (blArray[0]) {
                    Calendar calendar2 = (Calendar)this.mCalendar.clone();
                    date = this.mCalendar.getTime();
                    if (date.before(this.m_DefaultCenturyStart)) {
                        calendar2.set(1, this.m_DefaultCenturyStartYear + 100);
                        date = calendar2.getTime();
                    }
                } else {
                    date = this.mCalendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                parsePosition.mErrorIndex = n;
                parsePosition.mIndex = n2;
                return null;
            }
            return date;
        }
    }

    private void initialize(Locale locale) {
        this.m_Locale = locale;
        this.mCalendar = this.m_DefaultCalendar = Calendar.getInstance(TimeZone.getDefault(), locale);
        this.m_LocalCalendar = this.createLocalCalendar(locale);
        this.mNumberFormat = NumberFormat.getInstance(locale);
        this.mNumberFormat.setGroupingUsed(false);
        if (this.mNumberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.mNumberFormat).applyPattern(11, "#;#");
            ((DecimalFormat)this.mNumberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.mNumberFormat.setParseIntegerOnly(true);
        this.mNumberFormat.setMinimumFractionDigits(0);
        this.initializeDefaultCentury();
    }

    private boolean useLocalCalendar(int n, String string, Locale locale) {
        if (n != 12) {
            return false;
        }
        return string != null && string.indexOf("EE") == -1 && string.toLowerCase(Locale.US).indexOf("e") != -1 && locale.getLanguage().compareTo("ja") == 0 && locale.getCountry().compareTo("JP") == 0;
    }

    private Calendar createLocalCalendar(Locale locale) {
        if (locale.getLanguage().compareTo("ja") == 0 && locale.getCountry().compareTo("JP") == 0) {
            return Calendar.getInstance(TimeZone.getDefault(), locale, 1);
        }
        return Calendar.getInstance(TimeZone.getDefault(), locale);
    }

    private void initializeDefaultCentury() {
        this.mCalendar.setTime(new Date());
        this.mCalendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.mCalendar.getTime());
    }

    private int matchString(String string, int n, int n2, String[] stringArray) {
        int n3 = 0;
        int n4 = stringArray.length;
        if (n2 == 7) {
            n3 = 1;
        }
        int n5 = 0;
        int n6 = -1;
        while (n3 < n4) {
            int n7 = stringArray[n3].length();
            if (n7 > n5 && string.regionMatches(true, n, stringArray[n3], 0, n7)) {
                n6 = n3;
                n5 = n7;
            }
            ++n3;
        }
        if (n6 >= 0) {
            if (n2 == 0) {
                this.mCalendar.set(n2, n4 - n6 - 1);
            } else {
                this.mCalendar.set(n2, n6);
            }
            return n + n5;
        }
        return -n;
    }

    private int matchZoneString(String string, int n, int n2) {
        int n3;
        for (n3 = 4; n3 >= 1 && !string.regionMatches(true, n, this.m_Symbols.mZoneStrings[n2][n3], 0, this.m_Symbols.mZoneStrings[n2][n3].length()); --n3) {
        }
        return n3 > 4 ? -1 : n3;
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.m_DefaultCenturyStart = date;
        this.mCalendar.setTime(date);
        this.m_DefaultCenturyStartYear = this.mCalendar.get(1);
    }

    private void subFormat(char c, int n, FieldPosition fieldPosition, StringBuffer stringBuffer) throws IllegalArgumentException {
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        String string = "";
        int n4 = stringBuffer.length();
        n2 = "GyMdkHmsSEDFwWahKzZtTfCYOAxRrgoUuI".indexOf(c);
        if (n2 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + c + "'");
        }
        int n5 = PATTERN_INDEX_TO_CALENDAR_FIELD[n2];
        int n6 = this.mCalendar.get(n5);
        switch (n2) {
            case 0: {
                if (n >= 3) {
                    string = this.m_Symbols.mEras[this.m_Symbols.mEras.length - 1 - n6];
                    break;
                }
                if (n >= 2) {
                    if (this.mCalendar.getType() == 1 && "ja".equalsIgnoreCase(this.m_Locale.getLanguage())) {
                        string = this.m_Symbols.mEras[this.m_Symbols.mEras.length - 1 - n6].substring(0, 1);
                        break;
                    }
                    string = this.m_Symbols.mEras[this.m_Symbols.mEras.length - 1 - n6];
                    break;
                }
                string = this.m_Symbols.mShortEras[this.m_Symbols.mShortEras.length - 1 - n6];
                break;
            }
            case 1: {
                if (n >= 4) {
                    this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                    break;
                }
                if (n == 3) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n == 2) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n6 % 100 < 10) {
                    this.zeroPaddingNumber(n6, 1, 1, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                break;
            }
            case 2: {
                if (n >= 4) {
                    string = this.m_Symbols.mMonths[n6];
                    break;
                }
                if (n == 3) {
                    string = this.m_Symbols.mShortMonths[n6];
                    break;
                }
                this.zeroPaddingNumber(n6 + 1, n, n3, stringBuffer);
                break;
            }
            case 4: {
                if (n6 == 0) {
                    this.zeroPaddingNumber(this.mCalendar.getMaximum(11) + 1, n, n3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                break;
            }
            case 9: {
                if (n >= 4) {
                    string = this.m_Symbols.mWeekdays[n6];
                    break;
                }
                if (n >= 2) {
                    string = this.m_Symbols.mShortWeekdays[n6];
                    break;
                }
                stringBuffer.append(n6);
                break;
            }
            case 14: {
                string = this.m_Symbols.mAmpms[n6];
                break;
            }
            case 15: {
                if (n6 == 0) {
                    this.zeroPaddingNumber(this.mCalendar.getLeastMaximum(10) + 1, n, n3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                break;
            }
            case 17: {
                int n7 = this.m_Symbols.getZoneIndex(this.mCalendar.getTimeZone().getID());
                if (n7 == -1) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    n6 = this.mCalendar.get(15) + this.mCalendar.get(16);
                    if (n6 < 0) {
                        stringBuffer2.append(GMT_MINUS);
                        n6 = -n6;
                    } else {
                        stringBuffer2.append(GMT_PLUS);
                    }
                    this.zeroPaddingNumber(n6 / 3600000, 2, 2, stringBuffer2);
                    stringBuffer2.append(':');
                    this.zeroPaddingNumber(n6 % 3600000 / 60000, 2, 2, stringBuffer2);
                    string = stringBuffer2.toString();
                    break;
                }
                if (this.mCalendar.get(16) > 0) {
                    if (n >= 4) {
                        string = this.m_Symbols.mZoneStrings[n7][3];
                        break;
                    }
                    string = this.m_Symbols.mZoneStrings[n7][4];
                    break;
                }
                if (n >= 4) {
                    string = this.m_Symbols.mZoneStrings[n7][1];
                    break;
                }
                string = this.m_Symbols.mZoneStrings[n7][2];
                break;
            }
            case 18: {
                n6 = this.mCalendar.get(15) + this.mCalendar.get(16);
                if (n6 < 0) {
                    stringBuffer.append('-');
                    n6 = -n6;
                } else {
                    stringBuffer.append('+');
                }
                int n8 = n6 / 3600000;
                if (n8 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n8);
                n8 = n6 % 3600000 / 60000;
                if (n8 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n8);
                break;
            }
            case 19: {
                int n9 = this.mCalendar.get(17);
                if (n9 < 0) {
                    stringBuffer.append('-');
                    n9 = -n9;
                } else {
                    stringBuffer.append('+');
                }
                if (n > 1 && n9 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n9);
                break;
            }
            case 20: {
                int n10 = this.mCalendar.get(18);
                n10 = Math.abs(n10);
                if (n > 1 && n10 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n10);
                break;
            }
            case 21: {
                int n11 = 1;
                for (int i = 0; i < 9 - n; ++i) {
                    n11 *= 10;
                }
                this.zeroPaddingNumber(n6 /= n11, n, n, stringBuffer);
                break;
            }
            case 23: {
                String string2 = Long.toString(n6);
                int n12 = string2.length();
                if (n12 < n) {
                    n = n12;
                }
                string2 = string2.substring(n12 - n, n12);
                for (int i = 0; i < n; ++i) {
                    string = string + HAN_YEAR_CHARS[Integer.parseInt(string2.substring(i, i + 1))];
                }
                break;
            }
            case 24: {
                string = HAN_MONTH_STRINGS[n6];
                break;
            }
            case 25: {
                string = HAN_DATE_STRINGS[n6];
                break;
            }
            case 26: {
                string = String.valueOf(this.m_DecimalSeparator);
                break;
            }
            case 27: {
                if (n >= 4) {
                    this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                    break;
                }
                if (n == 3) {
                    this.zeroPaddingNumber(n6, 3, 3, stringBuffer);
                    break;
                }
                if (n == 2) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n6 % 100 < 10) {
                    this.zeroPaddingNumber(n6, 1, 1, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                break;
            }
            case 28: {
                if (n >= 4) {
                    this.zeroPaddingNumber(n6, n, n3, stringBuffer);
                    break;
                }
                if (n == 3) {
                    this.zeroPaddingNumber(n6, 3, 3, stringBuffer);
                    break;
                }
                if (n == 2) {
                    this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                    break;
                }
                if (n6 % 100 < 10) {
                    this.zeroPaddingNumber(n6, 1, 1, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n6, 2, 2, stringBuffer);
                break;
            }
            case 29: {
                if (n >= 2) {
                    string = this.m_Symbols.mEras[this.m_Symbols.mEras.length - 1 - n6];
                    break;
                }
                string = this.m_Symbols.mShortEras[this.m_Symbols.mShortEras.length - 1 - n6];
                break;
            }
            case 30: {
                stringBuffer.append(n6);
                break;
            }
            case 31: {
                this.zeroPaddingNumber((n6 - 1) / 7 + 1, 2, 2, stringBuffer);
                break;
            }
            case 32: {
                stringBuffer.append((n6 - 1) / 7 + 1);
                break;
            }
            default: {
                this.zeroPaddingNumber(n6, n, n3, stringBuffer);
            }
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        if (fieldPosition.mField == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n2] && fieldPosition.mBeginIndex == 0 && fieldPosition.mEndIndex == 0) {
            fieldPosition.mBeginIndex = n4;
            fieldPosition.mEndIndex = stringBuffer.length();
        }
    }

    private int subParse(String string, int n, char c, int n2, boolean bl, boolean[] blArray) {
        int n3;
        Number number = null;
        int n4 = 0;
        ParsePosition parsePosition = new ParsePosition(0);
        int n5 = -1;
        n5 = "GyMdkHmsSEDFwWahKzZtTfCYOAxRrgoUuI".indexOf(c);
        if (n5 == -1) {
            return -n;
        }
        parsePosition.mIndex = n;
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n5];
        while (true) {
            if (parsePosition.mIndex >= string.length()) {
                return -n;
            }
            n3 = string.charAt(parsePosition.mIndex);
            if (n3 != 32 && n3 != 9) break;
            ++parsePosition.mIndex;
        }
        if (n5 == 4 || n5 == 15 || n5 == 2 && n2 <= 2 || n5 == 1 || n5 == 27 || n5 == 28 || n5 == 22 || n5 == 30 || n5 == 31 || n5 == 32) {
            if (bl) {
                if (n + n2 > string.length()) {
                    return -n;
                }
                number = this.mNumberFormat.parse(string.substring(0, n + n2), parsePosition);
            } else {
                number = this.mNumberFormat.parse(string, parsePosition);
                if (number == null) {
                    ((DecimalFormat)this.mNumberFormat).ignorePrefixWhenParsing(true);
                    number = this.mNumberFormat.parse(string, parsePosition);
                    ((DecimalFormat)this.mNumberFormat).ignorePrefixWhenParsing(false);
                }
                if (number != null) {
                    for (n3 = n + 1; n3 < parsePosition.getIndex(); ++n3) {
                        if (!Character.isDigit(string.charAt(n3))) continue;
                        n = n3;
                        break;
                    }
                }
            }
            if (number == null) {
                return -n;
            }
            n4 = number.intValue();
        }
        switch (n5) {
            case 0: {
                if (n2 >= 3) {
                    return this.matchString(string, n, 0, this.m_Symbols.mEras);
                }
                if (n2 >= 2) {
                    if (this.mCalendar.getType() == 1 && "ja".equalsIgnoreCase(this.m_Locale.getLanguage())) {
                        String[] stringArray = new String[this.m_Symbols.mEras.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = this.m_Symbols.mEras[i].substring(0, 1);
                        }
                        return this.matchString(string, n, 0, stringArray);
                    }
                    return this.matchString(string, n, 0, this.m_Symbols.mEras);
                }
                return this.matchString(string, n, 0, this.m_Symbols.mShortEras);
            }
            case 1: {
                n4 = this.adjustYear(n2, bl, parsePosition, n, string, n4, blArray, this.m_DefaultCenturyStartYear);
                if (n4 < 0) {
                    n4 = -n4;
                }
                this.mCalendar.set(1, n4);
                return parsePosition.mIndex;
            }
            case 2: {
                if (n2 <= 2) {
                    this.mCalendar.set(2, n4 - 1);
                    return parsePosition.mIndex;
                }
                int n7 = 0;
                if (n2 >= 4 && (n7 = this.matchString(string, n, 2, this.m_Symbols.mMonths)) > 0) {
                    return n7;
                }
                n7 = this.matchString(string, n, 2, this.m_Symbols.mShortMonths);
                if (n7 > 0) {
                    return n7;
                }
                n7 = this.matchString(string, n, 2, DIGIT_MONTH_STRINGS);
                if (n7 > 0) {
                    return n7;
                }
                return this.matchString(string, n, 2, DIGIT_MONTH_STRINGS_WITH_ZERO);
            }
            case 4: {
                if (n4 == this.mCalendar.getMaximum(11) + 1) {
                    n4 = 0;
                }
                this.mCalendar.set(11, n4);
                return parsePosition.mIndex;
            }
            case 9: {
                int n8 = 0;
                n8 = this.matchString(string, n, 7, this.m_Symbols.mWeekdays);
                if (n8 > 0) {
                    return n8;
                }
                n8 = this.matchString(string, n, 7, this.m_Symbols.mShortWeekdays);
                if (n8 > 0) {
                    return n8;
                }
                return this.matchString(string, n, 7, DIGIT_WEEK_STRINGS);
            }
            case 14: {
                return this.matchString(string, n, 9, this.m_Symbols.mAmpms);
            }
            case 15: {
                if (n4 == this.mCalendar.getLeastMaximum(10) + 1) {
                    n4 = 0;
                }
                this.mCalendar.set(10, n4);
                return parsePosition.mIndex;
            }
            case 17: 
            case 18: {
                int n9;
                int n10 = 0;
                if (string.length() - n >= GMT.length() && string.regionMatches(true, n, GMT, 0, GMT.length())) {
                    this.mCalendar.set(16, 0);
                    parsePosition.mIndex = n + GMT.length();
                    try {
                        if (string.charAt(parsePosition.mIndex) == '+') {
                            n10 = 1;
                        } else if (string.charAt(parsePosition.mIndex) == '-') {
                            n10 = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (n10 == 0) {
                        this.mCalendar.set(15, 0);
                        return parsePosition.mIndex;
                    }
                    ++parsePosition.mIndex;
                    Number number2 = this.mNumberFormat.parse(string, parsePosition);
                    if (number2 == null) {
                        return -n;
                    }
                    if (string.charAt(parsePosition.mIndex) == ':') {
                        n9 = number2.intValue() * 60;
                        ++parsePosition.mIndex;
                        number2 = this.mNumberFormat.parse(string, parsePosition);
                        if (number2 == null) {
                            return -n;
                        }
                        n9 += number2.intValue();
                    } else {
                        n9 = number2.intValue();
                        n9 = n9 < 24 ? (n9 *= 60) : n9 % 100 + n9 / 100 * 60;
                    }
                } else {
                    int n11 = this.subParseZoneString(string, n);
                    if (n11 != 0) {
                        return n11;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(11, "+####;-####");
                    decimalFormat.setParseIntegerOnly(true);
                    Number number3 = decimalFormat.parse(string, parsePosition);
                    if (number3 == null) {
                        return -n;
                    }
                    n9 = number3.intValue();
                    n10 = 1;
                    if (n9 < 0) {
                        n10 = -1;
                        n9 = -n9;
                    }
                    n9 = n9 < 24 ? (n9 *= 60) : n9 % 100 + n9 / 100 * 60;
                }
                if (n10 != 0) {
                    n9 *= 60000 * n10;
                    this.mCalendar.set(16, 3600000);
                    this.mCalendar.set(15, n9 -= 3600000);
                    return parsePosition.mIndex;
                }
                return -n;
            }
            case 19: {
                int n12 = 0;
                this.mCalendar.set(17, 0);
                parsePosition.mIndex = n;
                try {
                    if (string.charAt(parsePosition.mIndex) == '+') {
                        n12 = 1;
                    } else if (string.charAt(parsePosition.mIndex) == '-') {
                        n12 = -1;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (n12 == 0) {
                    this.mCalendar.set(17, 0);
                    return parsePosition.mIndex;
                }
                ++parsePosition.mIndex;
                Number number4 = this.mNumberFormat.parse(string.substring(0, parsePosition.mIndex + n2), parsePosition);
                if (number4 == null) {
                    return -n;
                }
                int n13 = number4.intValue();
                this.mCalendar.set(17, n13 * n12);
                return parsePosition.mIndex;
            }
            case 20: {
                this.mCalendar.set(18, 0);
                parsePosition.mIndex = n;
                Number number5 = this.mNumberFormat.parse(string, parsePosition);
                if (number5 == null) {
                    return -n;
                }
                int n14 = number5.intValue();
                this.mCalendar.set(18, n14);
                return parsePosition.mIndex;
            }
            case 21: {
                int n15 = this.mNumberFormat.parse(string, parsePosition).intValue();
                int n16 = 1;
                for (int i = 0; i < 9 - n2; ++i) {
                    n16 *= 10;
                }
                this.mCalendar.set(n6, n15 * n16);
                return parsePosition.mIndex;
            }
            case 8: {
                int n17 = this.mNumberFormat.parse(string, parsePosition).intValue();
                this.mCalendar.set(14, n17);
                this.mCalendar.set(19, n17 * 1000000);
                return parsePosition.mIndex;
            }
            case 22: {
                this.m_DefaultCenturyStartYear = (n4 - 1) * 100;
                this.mCalendar.set(20, n4);
                return parsePosition.mIndex;
            }
            case 23: {
                int n18 = 0;
                int n19 = 0;
                for (int i = 0; i < n2; ++i) {
                    char c2 = string.charAt(n + i);
                    boolean bl2 = false;
                    for (int j = 0; j < HAN_YEAR_CHARS.length; ++j) {
                        if (c2 != HAN_YEAR_CHARS[j]) continue;
                        n18 = n18 * 10 + j;
                        bl2 = true;
                        ++n19;
                        break;
                    }
                    if (!bl2) break;
                }
                if (n2 == 2 && this.isNLSDigit(string.charAt(n)) && this.isNLSDigit(string.charAt(n + 1)) || n2 == 1 && this.isNLSDigit(string.charAt(n))) {
                    n4 = this.adjustYear(n4, blArray, this.m_DefaultCenturyStartYear);
                }
                parsePosition.mIndex = n + n19;
                if (n18 < 0) {
                    n18 = -n4;
                }
                this.mCalendar.set(1, n18);
                return parsePosition.mIndex;
            }
            case 24: {
                return this.matchString(string, n, 2, HAN_MONTH_STRINGS);
            }
            case 25: {
                return this.matchString(string, n, 5, HAN_DATE_STRINGS);
            }
            case 26: {
                parsePosition.mIndex = n + 1;
                return parsePosition.mIndex;
            }
            case 27: {
                n4 = this.adjustYear(n2, bl, parsePosition, n, string, n4, blArray, this.mCalendar.getType() == 0 ? 1950 : this.m_DefaultCenturyStartYear);
                if (n2 == 4 && (!bl || bl && parsePosition.mIndex - n == 2) && Character.isDigit(string.charAt(n)) && (parsePosition.mIndex - n <= 1 || Character.isDigit(string.charAt(n + 1)))) {
                    n4 = this.adjustYear(n4, blArray, this.m_DefaultCenturyStartYear);
                }
                if (n4 < 0) {
                    n4 = -n4;
                }
                this.mCalendar.set(1, n4);
                return parsePosition.mIndex;
            }
            case 28: {
                n4 = this.adjustYear(n2, bl, parsePosition, n, string, n4, blArray, this.m_DefaultCenturyStartYear);
                if (n4 < 0) {
                    n4 = -n4;
                }
                this.mCalendar.set(1, n4);
                return parsePosition.mIndex;
            }
            case 29: {
                if (n2 >= 2) {
                    return this.matchString(string, n, 0, this.m_Symbols.mEras);
                }
                return this.matchString(string, n, 0, this.m_Symbols.mShortEras);
            }
            case 30: {
                n4 = this.adjustYear(n2, bl, parsePosition, n, string, n4, blArray, this.mCalendar.getType() == 0 ? 1950 : this.m_DefaultCenturyStartYear);
                if (n4 < 0) {
                    n4 = -n4;
                }
                this.mCalendar.set(1, n4);
                return parsePosition.mIndex;
            }
            case 31: {
                this.mCalendar.set(6, n4 * 7 - 6);
                return parsePosition.mIndex;
            }
            case 32: {
                this.mCalendar.set(5, n4 * 7 - 6);
                return parsePosition.mIndex;
            }
        }
        if (bl) {
            if (n + n2 > string.length()) {
                return -n;
            }
            number = this.mNumberFormat.parse(string.substring(0, n + n2), parsePosition);
        } else {
            number = this.mNumberFormat.parse(string, parsePosition);
            if (number == null) {
                ((DecimalFormat)this.mNumberFormat).ignorePrefixWhenParsing(true);
                number = this.mNumberFormat.parse(string, parsePosition);
                ((DecimalFormat)this.mNumberFormat).ignorePrefixWhenParsing(false);
            }
        }
        if (number != null) {
            this.mCalendar.set(n6, Math.abs(number.intValue()));
            return parsePosition.mIndex;
        }
        return -n;
    }

    private int adjustYear(int n, boolean bl, ParsePosition parsePosition, int n2, String string, int n3, boolean[] blArray, int n4) {
        if (n == 2 && (!bl || bl && parsePosition.mIndex - n2 == 2) && Character.isDigit(string.charAt(n2)) && (parsePosition.mIndex - n2 <= 1 || Character.isDigit(string.charAt(n2 + 1))) || n == 1 && (!bl || bl && parsePosition.mIndex - n2 == 1) && Character.isDigit(string.charAt(n2))) {
            n3 = this.adjustYear(n3, blArray, n4);
        }
        return n3;
    }

    private int adjustYear(int n, boolean[] blArray, int n2) {
        if ((this.mCalendar.getType() == 0 || this.mCalendar.getType() == 4 || this.mCalendar.getType() == 3 || this.mCalendar.getType() == 2) && n <= 99 && n >= -99) {
            int n3 = n2 % 100;
            boolean bl = blArray[0] = n == n3;
            n = n >= 0 ? (n += n2 / 100 * 100 + (n < n3 ? 100 : 0)) : (n -= n2 / 100 * 100 + (n < n3 ? 100 : 0));
        }
        return n;
    }

    private int subParseZoneString(String string, int n) {
        int n2 = this.m_Symbols.getZoneIndex(this.getTimeZone().getID());
        TimeZone timeZone = null;
        int n3 = 0;
        int n4 = 0;
        if (n2 != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.m_Symbols.mZoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null && (n2 = this.m_Symbols.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.m_Symbols.mZoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null) {
            for (n4 = 0; n4 < this.m_Symbols.mZoneStrings.length; ++n4) {
                n3 = this.matchZoneString(string, n, n4);
                if (n3 <= 0) continue;
                timeZone = TimeZone.getTimeZone(this.m_Symbols.mZoneStrings[n4][0]);
                break;
            }
        }
        if (timeZone != null) {
            this.mCalendar.set(15, timeZone.getRawOffset());
            return n + this.m_Symbols.mZoneStrings[n4][n3].length();
        }
        return 0;
    }

    private String translatePattern(int n, String string) {
        switch (n) {
            case 11: {
                return this.getFormatFromJava(string);
            }
            case 12: {
                return this.getFormatFromMS(string);
            }
            case 10: {
                return this.getFormatFromOracle(string);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zeroPaddingNumber(long l, int n, int n2, StringBuffer stringBuffer) {
        try {
            if (this.m_ZeroDigit == '\u0000') {
                this.m_ZeroDigit = ((DecimalFormat)this.mNumberFormat).getDecimalFormatSymbols().getZeroDigit();
            }
            if (l >= 0L) {
                if (l < 100L && n >= 1 && n <= 2) {
                    if (l < 10L) {
                        if (n == 2) {
                            stringBuffer.append(this.m_ZeroDigit);
                        }
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l));
                    } else {
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l / 10L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l % 10L));
                    }
                    return;
                }
                if (l >= 1000L && l < 10000L) {
                    if (n == 4) {
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l / 1000L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + (l %= 1000L) / 100L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + (l %= 100L) / 10L));
                        stringBuffer.append((char)((long)this.m_ZeroDigit + l % 10L));
                        return;
                    }
                    if (n == 2 && n2 == 2) {
                        this.zeroPaddingNumber(l % 100L, 2, 2, stringBuffer);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        NumberFormat numberFormat = this.mNumberFormat;
        synchronized (numberFormat) {
            this.mNumberFormat.setMinimumIntegerDigits(n);
            this.mNumberFormat.setMaximumIntegerDigits(n2);
            this.mNumberFormat.format(l, stringBuffer, new FieldPosition(0));
        }
    }

    private boolean isNLSDigit(char c) {
        for (int i = 0; i < HAN_YEAR_CHARS.length; ++i) {
            if (c != HAN_YEAR_CHARS[i]) continue;
            return true;
        }
        return Character.isDigit(c);
    }

    private String getFormatFromOracle(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternOracle.get(string);
        if (string2 == null) {
            string2 = this.convertFromOracle(string, "");
            m_CachedConvertedPatternOracle.put(string, string2);
        }
        return string2;
    }

    private String getFormatFromMS(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = (String[])m_CachedConvertedPatternMS.get(string);
        if (stringArray == null) {
            stringArray = new String[2];
            stringArray[0] = this.convertFromMS(string, "");
            m_CachedConvertedPatternMS.put(string, stringArray);
        }
        return stringArray[0];
    }

    private String getFormatFromJava(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternJava.get(string);
        if (string2 == null) {
            string2 = this.convertFromJava(string, "");
            m_CachedConvertedPatternJava.put(string, string2);
        }
        return string2;
    }

    private String convertInTextFromOracle(String string, String string2) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convertFromOracle(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return this.convertInTextFromOracle(string, string2);
    }

    private String convertInTextFromMS(String string, String string2) {
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convertFromMS(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return this.convertInTextFromMS(string, string2);
    }

    private String convertFromOracle(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.toUpperCase(Locale.US).startsWith("AD")) {
            string = string.substring(2);
            string2 = string2 + "GGG";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("A.D.")) {
            string = string.substring(4);
            string2 = string2 + "GGG";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("BC")) {
            string = string.substring(2);
            string2 = string2 + "GGG";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("B.C.")) {
            string = string.substring(4);
            string2 = string2 + "GGG";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("EE")) {
            string = string.substring(2);
            string2 = string2 + "GGG";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("E")) {
            string = string.substring(1);
            string2 = string2 + "G";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("SCC")) {
            string = string.substring(3);
            string2 = string2 + "CC";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("CC")) {
            string = string.substring(2);
            string2 = string2 + "CC";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("AM")) {
            string = string.substring(2);
            string2 = string2 + "a";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("A.M.")) {
            string = string.substring(4);
            string2 = string2 + "a";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("PM")) {
            string = string.substring(2);
            string2 = string2 + "a";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("P.M.")) {
            string = string.substring(4);
            string2 = string2 + "a";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FM")) {
            string = string.substring(2);
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FX")) {
            string = string.substring(2);
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("DDD")) {
            string = string.substring(3);
            string2 = string2 + "DDD";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("DAY")) {
            string = string.substring(3);
            string2 = string2 + "EEEE";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("DY")) {
            string = string.substring(2);
            string2 = string2 + "EE";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("DD")) {
            string = string.substring(2);
            string2 = string2 + "dd";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("DS")) {
            string = string.substring(2);
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.m_Locale);
            string2 = string2 + calendarResourceAccessor.getShortDatePattern();
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("DL")) {
            string = string.substring(2);
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.m_Locale);
            string2 = string2 + calendarResourceAccessor.getLongDatePattern();
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("D")) {
            string = string.substring(1);
            string2 = string2 + "E";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH24")) {
            string = string.substring(4);
            string2 = string2 + "HH";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH12")) {
            string = string.substring(4);
            string2 = string2 + "hh";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH")) {
            string = string.substring(2);
            string2 = string2 + "hh";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("IW")) {
            string = string.substring(2);
            string2 = string2 + "II";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("MI")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("MM")) {
            string = string.substring(2);
            string2 = string2 + "MM";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("MONTH")) {
            string = string.substring(5);
            string2 = string2 + "MMMMM";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("MON")) {
            string = string.substring(3);
            string2 = string2 + "MMM";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("SS")) {
            string = string.substring(2);
            string2 = string2 + "ss";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("WW")) {
            string = string.substring(2);
            string2 = string2 + "U";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("W")) {
            string = string.substring(1);
            string2 = string2 + "u";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYYYYY")) {
            string = string.substring(6);
            string2 = string2 + "rrrrrr";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYYYY")) {
            string = string.substring(5);
            string2 = string2 + "rrrrr";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYYY")) {
            string = string.substring(4);
            string2 = string2 + "rrrr";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYY")) {
            string = string.substring(3);
            string2 = string2 + "rrr";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("YY")) {
            string = string.substring(2);
            string2 = string2 + "rr";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("Y")) {
            string = string.substring(1);
            string2 = string2 + "r";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRRRRR")) {
            string = string.substring(6);
            string2 = string2 + "RRRRRR";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRRRR")) {
            string = string.substring(5);
            string2 = string2 + "RRRRR";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRRR")) {
            string = string.substring(4);
            string2 = string2 + "RRRR";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRR")) {
            string = string.substring(3);
            string2 = string2 + "RRR";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("RR")) {
            string = string.substring(2);
            string2 = string2 + "RR";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("R")) {
            string = string.substring(1);
            string2 = string2 + "R";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("X")) {
            string = string.substring(1);
            string2 = string2 + "x";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF1")) {
            string = string.substring(3);
            string2 = string2 + "f";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF2")) {
            string = string.substring(3);
            string2 = string2 + "ff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF3")) {
            string = string.substring(3);
            string2 = string2 + "fff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF4")) {
            string = string.substring(3);
            string2 = string2 + "ffff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF5")) {
            string = string.substring(3);
            string2 = string2 + "fffff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF6")) {
            string = string.substring(3);
            string2 = string2 + "ffffff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF7")) {
            string = string.substring(3);
            string2 = string2 + "fffffff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF5")) {
            string = string.substring(3);
            string2 = string2 + "ffffffff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF9")) {
            string = string.substring(3);
            string2 = string2 + "fffffffff";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZD")) {
            string = string.substring(3);
            string2 = string2 + "z";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZR")) {
            string = string.substring(3);
            string2 = string2 + "zzzz";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZH")) {
            string = string.substring(3);
            string2 = string2 + "tt";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZM")) {
            string = string.substring(3);
            string2 = string2 + "TT";
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("TS")) {
            string = string.substring(2);
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.m_Locale);
            string2 = string2 + calendarResourceAccessor.getShortTimePattern();
            return this.convertFromOracle(string, string2);
        }
        if (string.toUpperCase(Locale.US).startsWith("TL")) {
            string = string.substring(2);
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(this.m_Locale);
            string2 = string2 + calendarResourceAccessor.getLongTimePattern();
            return this.convertFromOracle(string, string2);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "''";
            return this.convertFromOracle(string, string2);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convertInTextFromOracle(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return this.convertFromOracle(string, string2);
    }

    private String convertFromMS(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.startsWith("ggg")) {
            string = string.substring(3);
            string2 = string2 + "GGG";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("gg")) {
            string = string.substring(2);
            string2 = string2 + "GG";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("g")) {
            string = string.substring(1);
            string2 = string2 + "G";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("EEEE")) {
            string = string.substring(4);
            string2 = string2 + "YYYY";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("EEE")) {
            string = string.substring(3);
            string2 = string2 + "YYY";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            string2 = string2 + "YY";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("E")) {
            string = string.substring(1);
            string2 = string2 + "YY";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("ee")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("e")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("\u661f\u671fW")) {
            string = string.substring(3);
            string2 = string2 + "EEEE";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("O")) {
            string = string.substring(1);
            string2 = string2 + "O";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("aaa")) {
            string = string.substring(3);
            string2 = string2 + "EE";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("AMPM")) {
            string = string.substring(4);
            string2 = string2 + "a";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("A")) {
            string = string.substring(1);
            string2 = string2 + "A";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("am/pm")) {
            string = string.substring(5);
            string2 = string2 + "a";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("dddd")) {
            string = string.substring(4);
            string2 = string2 + "EEEE";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("ddd")) {
            string = string.substring(3);
            string2 = string2 + "EE";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("yyyyyy")) {
            string = string.substring(6);
            string2 = string2 + "yyyyyy";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("yyyyy")) {
            string = string.substring(5);
            string2 = string2 + "yyyyy";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("yyyy")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("yyy")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("yy")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("y")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("zzzz")) {
            string = string.substring(4);
            string2 = string2 + "tt:TT";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("zzz")) {
            string = string.substring(3);
            string2 = string2 + "tt:TT";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("zz")) {
            string = string.substring(2);
            string2 = string2 + "tt";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("z")) {
            string = string.substring(1);
            string2 = string2 + "t";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("tt")) {
            string = string.substring(2);
            string2 = string2 + "a";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("t")) {
            string = string.substring(1);
            string2 = string2 + "a";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convertFromMS(string, string2);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return this.convertInTextFromMS(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return this.convertFromMS(string, string2);
    }

    private String convertFromJava(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.startsWith("GG")) {
            string = string.substring(2);
            string2 = string2 + "GGG";
            return this.convertFromJava(string, string2);
        }
        if (string.startsWith("G")) {
            string = string.substring(1);
            string2 = string2 + "G";
            return this.convertFromJava(string, string2);
        }
        if (string.startsWith("EEEEE")) {
            string = string.substring(5);
            string2 = string2 + "EEEEE";
            return this.convertFromJava(string, string2);
        }
        if (string.startsWith("EEEE")) {
            string = string.substring(4);
            string2 = string2 + "EEEE";
            return this.convertFromJava(string, string2);
        }
        if (string.startsWith("EEE")) {
            string = string.substring(3);
            string2 = string2 + "EEE";
            return this.convertFromJava(string, string2);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            string2 = string2 + "EE";
            return this.convertFromJava(string, string2);
        }
        if (string.startsWith("E")) {
            string = string.substring(1);
            string2 = string2 + "EE";
            return this.convertFromJava(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return this.convertFromJava(string, string2);
    }

    boolean isLocaleCalendarMode() {
        return this.m_LocalCalendarMode;
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.m_Symbols = (DateFormatSymbols)this.m_Symbols.clone();
        return simpleDateFormat;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.m_Pattern.equals(simpleDateFormat.m_Pattern) && this.m_Symbols.equals(simpleDateFormat.m_Symbols);
    }

    public int hashCode() {
        return this.m_Pattern.hashCode();
    }
}

