/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text.resources;

import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.resources.DefaultCalendarResourceAccessor;

public abstract class CalendarResourceAccessor {
    public static final String RCS_ID = "$Header: CalendarResourceAccessor.java 120.0 2005/05/07 08:27:12 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: CalendarResourceAccessor.java 120.0 2005/05/07 08:27:12 appldev ship $", "oracle.apps.fnd.i18n.common.text.resources");
    public static final int SHORT = 10;
    public static final int MEDIUM = 11;
    public static final int LONG = 12;
    public static final int MONTH_YEAR = 13;
    public static final int DOW_MONTH_DAY = 14;
    public static final int TIME_12 = 15;
    public static final int TIME_24 = 16;
    public static final int TIME_DEFAULT = 17;
    public static final int SHORT_TIME = 20;
    public static final int MEDIUM_TIME = 21;
    public static final int LONG_TIME = 22;
    public static final int SHORT_TIME_TZ = 30;
    public static final int MEDIUM_TIME_TZ = 31;
    public static final int LONG_TIME_TZ = 32;
    private static final int CACHE_SIZE_RESOURCE_ACCESSOR = 100;
    private static final int CACHE_SIZE_FORMAT_MASK = 15;
    private static Hashtable m_CashedCalendarResourceAccessor = new Hashtable(100);
    private static Hashtable m_CachedDateFormatMask = new Hashtable(15);
    private static Hashtable m_CachedTimeFormatMask = new Hashtable(15);
    private static Hashtable m_CachedDateTimeFormatMask = new Hashtable(15);

    public static CalendarResourceAccessor getInstance(Locale locale) {
        return CalendarResourceAccessor.getCalendarResourceAccessor(locale);
    }

    private static CalendarResourceAccessor getCalendarResourceAccessor(Locale locale) {
        CalendarResourceAccessor calendarResourceAccessor = (CalendarResourceAccessor)m_CashedCalendarResourceAccessor.get(locale);
        if (calendarResourceAccessor == null) {
            calendarResourceAccessor = new DefaultCalendarResourceAccessor(locale);
            m_CashedCalendarResourceAccessor.put(locale, calendarResourceAccessor);
        }
        return calendarResourceAccessor;
    }

    public static String getTimeFormatMask(int n, Locale locale) {
        String string = locale.toString() + n;
        String string2 = (String)m_CachedTimeFormatMask.get(string);
        if (string2 == null) {
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(locale);
            switch (n) {
                case 10: {
                    string2 = calendarResourceAccessor.getShortTimePattern();
                    break;
                }
                case 11: {
                    string2 = calendarResourceAccessor.getMediumTimePattern();
                    break;
                }
                case 12: {
                    string2 = calendarResourceAccessor.getLongTimePattern();
                    break;
                }
                case 30: {
                    string2 = calendarResourceAccessor.getShortTimePattern();
                    break;
                }
                case 31: {
                    string2 = calendarResourceAccessor.getMediumTimePattern();
                    break;
                }
                case 32: {
                    string2 = calendarResourceAccessor.getLongTimePattern();
                    break;
                }
                default: {
                    string2 = calendarResourceAccessor.getMediumTimePattern();
                }
            }
        }
        m_CachedTimeFormatMask.put(string, string2);
        return string2;
    }

    public static String getDateFormatMask(int n, Locale locale) {
        String string = locale.toString() + n;
        String string2 = (String)m_CachedDateFormatMask.get(string);
        if (string2 == null) {
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(locale);
            switch (n) {
                case 10: {
                    string2 = calendarResourceAccessor.getShortDatePattern();
                    break;
                }
                case 11: {
                    string2 = calendarResourceAccessor.getMediumDatePattern();
                    break;
                }
                case 12: {
                    string2 = calendarResourceAccessor.getLongDatePattern();
                    break;
                }
                default: {
                    string2 = calendarResourceAccessor.getMediumDatePattern();
                }
            }
        }
        m_CachedDateFormatMask.put(string, string2);
        return string2;
    }

    public static String getDateTimeFormatMask(int n, Locale locale) {
        String string = locale.toString() + n;
        String string2 = (String)m_CachedDateFormatMask.get(string);
        if (string2 == null) {
            CalendarResourceAccessor calendarResourceAccessor = CalendarResourceAccessor.getInstance(locale);
            switch (n) {
                case 10: {
                    string2 = calendarResourceAccessor.getShortDatePattern();
                    break;
                }
                case 11: {
                    string2 = calendarResourceAccessor.getMediumDatePattern();
                    break;
                }
                case 12: {
                    string2 = calendarResourceAccessor.getLongDatePattern();
                    break;
                }
                case 20: {
                    string2 = calendarResourceAccessor.getShortDatePattern() + " " + calendarResourceAccessor.getTimePattern();
                    break;
                }
                case 21: {
                    string2 = calendarResourceAccessor.getMediumDatePattern() + " " + calendarResourceAccessor.getTimePattern();
                    break;
                }
                case 22: {
                    string2 = calendarResourceAccessor.getLongDatePattern() + " " + calendarResourceAccessor.getTimePattern();
                    break;
                }
                case 30: {
                    string2 = calendarResourceAccessor.getShortDatePattern() + " " + calendarResourceAccessor.getTimePattern() + " " + calendarResourceAccessor.getTimeZonePattern();
                    break;
                }
                case 31: {
                    string2 = calendarResourceAccessor.getMediumDatePattern() + " " + calendarResourceAccessor.getTimePattern() + " " + calendarResourceAccessor.getTimeZonePattern();
                    break;
                }
                case 32: {
                    string2 = calendarResourceAccessor.getLongDatePattern() + " " + calendarResourceAccessor.getTimePattern() + " " + calendarResourceAccessor.getTimeZonePattern();
                    break;
                }
                case 13: {
                    string2 = calendarResourceAccessor.getMonthYearDatePattern();
                    break;
                }
                case 14: {
                    string2 = calendarResourceAccessor.getDowMonthDayDatePattern();
                    break;
                }
                case 15: {
                    string2 = calendarResourceAccessor.get12TimePattern();
                    break;
                }
                case 16: {
                    string2 = calendarResourceAccessor.get24TimePattern();
                    break;
                }
                case 17: {
                    string2 = calendarResourceAccessor.getTimePattern();
                    break;
                }
                default: {
                    string2 = calendarResourceAccessor.getMediumDatePattern();
                }
            }
        }
        m_CachedDateFormatMask.put(string, string2);
        return string2;
    }

    public abstract String getShortDatePattern();

    public abstract String getMediumDatePattern();

    public abstract String getLongDatePattern();

    public abstract String getDowMonthDayDatePattern();

    public abstract String getMonthYearDatePattern();

    public abstract String get12TimePattern();

    public abstract String get24TimePattern();

    public abstract String getTimePattern();

    public abstract String getShortTimePattern();

    public abstract String getMediumTimePattern();

    public abstract String getLongTimePattern();

    public abstract String getAmPmTimeElement();

    public abstract String[] getAmPmMarkers();

    public abstract String getStartDow();

    public abstract String getTimeZonePattern();

    public abstract String[][] getTimeZoneResources();

    public abstract String[] getEraResources();

    public abstract String[] getShortEraResources();

    public abstract String[] getHijrahShortMonthResources();

    public abstract String[] getHijrahLongMonthResources();

    public abstract String[] getJapaneseEraResources();

    public abstract String[] getJapaneseShortEraResources();

    public abstract String[] getHijrahEraResources();

    public abstract String[] getHijrahShortEraResources();

    public abstract String[] getThaiEraResources();

    public abstract String[] getThaiShortEraResources();

    public abstract String[] getChinaEraResources();

    public abstract String[] getChinaShortEraResources();
}

