/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text.resources;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.resources.JavaDateResourceAccessor;
import oracle.apps.fnd.i18n.common.text.resources.V8DateResourceAccessor;
import oracle.apps.fnd.i18n.common.text.resources.V9DateResourceAccessor;

public abstract class DateResourceAccessor {
    public static final String RCS_ID = "$Header: DateResourceAccessor.java 120.0 2005/05/07 08:27:13 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DateResourceAccessor.java 120.0 2005/05/07 08:27:13 appldev ship $", "oracle.apps.fnd.i18n.common.text.resources");
    private static Hashtable m_CashedDateResourceAccessor = new Hashtable();
    private static Hashtable m_CashedDateFormatSymbols = new Hashtable();
    public static final int RESOURCE_JAVA = 7;
    public static final int RESOURCE_ORACLE_V8 = 8;
    public static final int RESOURCE_ORACLE_V9 = 9;
    public static final int RESOURCE_ORACLE = 9;
    public static final int RESOURCE_DEFAULT = 9;
    private static final String TWO_DIGIT_YEAR_START_STRING = "50";
    private static final Date TWO_DIGIT_YEAR_START;

    public static DateResourceAccessor getInstance(Locale locale, int n) {
        return DateResourceAccessor.getDateResourceAccessor(locale, n);
    }

    public static DateResourceAccessor getInstance(Locale locale) {
        return DateResourceAccessor.getInstance(locale, 9);
    }

    private static DateResourceAccessor getDateResourceAccessor(Locale locale, int n) {
        String string = locale.toString() + n;
        DateResourceAccessor dateResourceAccessor = (DateResourceAccessor)m_CashedDateResourceAccessor.get(string);
        if (dateResourceAccessor == null) {
            switch (n) {
                case 7: {
                    dateResourceAccessor = new JavaDateResourceAccessor(locale);
                    break;
                }
                case 8: {
                    dateResourceAccessor = new V8DateResourceAccessor(locale);
                    break;
                }
                case 9: {
                    dateResourceAccessor = new V9DateResourceAccessor(locale);
                    break;
                }
                default: {
                    dateResourceAccessor = new V9DateResourceAccessor(locale);
                }
            }
            m_CashedDateResourceAccessor.put(string, dateResourceAccessor);
        }
        return dateResourceAccessor;
    }

    public abstract String[] getEras();

    public abstract String[] getShortEras();

    public abstract String[] getShortMonthNames();

    public abstract String[] getMonthNames();

    public abstract String[] getHijrahShortMonthNames();

    public abstract String[] getHijrahMonthNames();

    public abstract String[] getShortDowNames();

    public abstract String[] getDowNames();

    public abstract String[] getAmPmMarkers();

    public abstract String[][] getTimeZoneStrings();

    public Date get2DigitYearStart() {
        String string = this.get2DigitYearStartAsString();
        if (TWO_DIGIT_YEAR_START_STRING.equals(string)) {
            return TWO_DIGIT_YEAR_START;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(string), 0, 0);
        return gregorianCalendar.getTime();
    }

    public abstract String get2DigitYearStartAsString();

    public abstract boolean isLenient();

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1950, 0, 0);
        TWO_DIGIT_YEAR_START = gregorianCalendar.getTime();
    }
}

