/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text.resources;

import java.text.DateFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.resources.CalendarResourceAccessor;

class DefaultCalendarResourceAccessor
extends CalendarResourceAccessor {
    public static final String RCS_ID = "$Header: DefaultCalendarResourceAccessor.java 120.1 2012/09/10 19:44:31 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultCalendarResourceAccessor.java 120.1 2012/09/10 19:44:31 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text.resources");
    private static int AM_PM_AFTER = 0;
    private static int AM_PM_BEFORE = 1;
    private static int TIME_12 = 0;
    private static int TIME_24 = 1;
    private static int TIME_TWO_DIGIT = 0;
    private static int TIME_ONE_DIGIT = 1;
    private static final String PACKAGE_NAME = "oracle.apps.fnd.i18n.common.text.resources.calendarDefault";
    private String m_ShortDatePattern;
    private String m_MediumDatePattern;
    private String m_LongDatePattern;
    private String m_DowMonthDayPattern;
    private String m_MonthYearPattern;
    private String m_AmPmTimeElement;
    private String m_TimeSaparator;
    private String m_Time12Pattern;
    private String m_Time24Pattern;
    private String m_TimeDefaultPattern;
    private String m_ShortTimePattern;
    private String m_MediumTimePattern;
    private String m_LongTimePattern;
    private String m_StartDow;
    private String[] m_AmPmMarkers;
    private String m_ZonePattern;
    private String[][] m_ZoneStrings;
    private String[] m_EraRes;
    private String[] m_ShortEraRes;
    private String[] m_HijrahLongMonth;
    private String[] m_HijrahShortMonth;
    private String[] m_JapaneseEraRes;
    private String[] m_JapaneseShortEraRes;
    private String[] m_HijrahEraRes;
    private String[] m_HijrahShortEraRes;
    private String[] m_ThaiEraRes;
    private String[] m_ThaiShortEraRes;
    private String[] m_ChinaEraRes;
    private String[] m_ChinaShortEraRes;

    public DefaultCalendarResourceAccessor(Locale locale) {
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        int n;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.apps.fnd.i18n.common.text.resources.calendarDefault.LocaleElements", locale);
        this.m_ShortDatePattern = resourceBundle.getString("Date_Short_Format_Mask");
        this.m_MediumDatePattern = resourceBundle.getString("Date_Medium_Format_Mask");
        this.m_LongDatePattern = resourceBundle.getString("Date_Long_Format_Mask");
        this.m_DowMonthDayPattern = resourceBundle.getString("Date_Dow_Month_Day_Format_Mask");
        this.m_MonthYearPattern = resourceBundle.getString("Date_Month_Year_Format_Mask");
        this.m_AmPmTimeElement = resourceBundle.getString("Time_AM_PM");
        this.m_TimeSaparator = resourceBundle.getString("Time_Separator");
        String string = resourceBundle.getString("Time_AM_PM_Position");
        String string2 = resourceBundle.getString("Time_Digit");
        String string3 = "";
        string3 = Integer.parseInt(string2) == TIME_TWO_DIGIT ? (Integer.parseInt(string) == AM_PM_AFTER ? "hh" + this.m_TimeSaparator + "mm a" : "a hh" + this.m_TimeSaparator + "mm") : (Integer.parseInt(string) == AM_PM_AFTER ? "h" + this.m_TimeSaparator + "mm a" : "a h" + this.m_TimeSaparator + "mm");
        this.m_Time12Pattern = string3;
        string3 = Integer.parseInt(string2) == TIME_TWO_DIGIT ? "HH" + this.m_TimeSaparator + "mm" : "H" + this.m_TimeSaparator + "mm";
        this.m_Time24Pattern = string3;
        int n2 = Integer.parseInt(this.getAmPmTimeElement());
        this.m_TimeDefaultPattern = n2 == TIME_12 ? this.get12TimePattern() : this.get24TimePattern();
        this.m_ShortTimePattern = this.getTimePattern();
        this.m_MediumTimePattern = this.getTimePattern();
        this.m_LongTimePattern = this.getTimePattern();
        this.m_StartDow = resourceBundle.getString("Calendar_Start_Dow");
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        this.m_AmPmMarkers = dateFormatSymbols.getAmPmStrings();
        this.m_ZonePattern = "zzzz";
        String[] stringArray = dateFormatSymbols.getEras();
        int n3 = stringArray.length;
        this.m_EraRes = new String[n3];
        for (n = 0; n < n3; ++n) {
            this.m_EraRes[n] = stringArray[n3 - n - 1];
        }
        this.m_ShortEraRes = new String[n3];
        for (n = 0; n < n3; ++n) {
            this.m_ShortEraRes[n] = stringArray[n3 - n - 1];
        }
        String[] stringArray2 = dateFormatSymbols.getEras();
        String[] stringArray3 = (String[])resourceBundle.getObject("JapaneseEra");
        int n4 = stringArray2.length + stringArray3.length;
        String[] stringArray4 = new String[n4];
        stringArray4[n4 - 1] = stringArray2[0];
        stringArray4[n4 - 2] = stringArray2[1];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray4[i] = stringArray3[i];
        }
        this.m_JapaneseEraRes = stringArray4;
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("oracle.apps.fnd.i18n.common.text.resources.calendarDefault.LocaleElements", new Locale("en", ""));
        stringArray3 = (String[])resourceBundle2.getObject("JapaneseEra");
        n4 = stringArray2.length + stringArray3.length;
        String[] stringArray5 = new String[n4];
        stringArray5[n4 - 1] = stringArray2[0].substring(0, 1);
        stringArray5[n4 - 2] = stringArray2[1].substring(0, 1);
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray5[i] = stringArray3[i].substring(0, 1);
        }
        this.m_JapaneseShortEraRes = stringArray5;
        Hashtable hashtable = (Hashtable)resourceBundle.getObject("Time Zone Resources");
        String[][] stringArray6 = dateFormatSymbols.getZoneStrings();
        for (int i = 0; i < stringArray6.length; ++i) {
            String[] stringArray7 = stringArray6[i];
            String string4 = stringArray7[0];
            String string5 = (String)hashtable.get(string4);
            if (string5 == null) continue;
            stringArray7[1] = string5;
            stringArray7[3] = string5;
        }
        this.m_ZoneStrings = stringArray6;
        this.m_HijrahShortMonth = (String[])resourceBundle.getObject("HijrahShortMonth");
        this.m_HijrahLongMonth = (String[])resourceBundle.getObject("HijrahLongMonth");
        this.m_HijrahEraRes = (String[])resourceBundle.getObject("HijrahEra");
        this.m_HijrahShortEraRes = (String[])resourceBundle.getObject("HijrahEra");
        this.m_ThaiEraRes = (String[])resourceBundle.getObject("ThaiEra");
        this.m_ThaiShortEraRes = (String[])resourceBundle.getObject("ThaiShortEra");
        this.m_ChinaEraRes = (String[])resourceBundle.getObject("ChinaEra");
        this.m_ChinaShortEraRes = (String[])resourceBundle.getObject("ChinaShortEra");
    }

    public String getShortDatePattern() {
        return this.m_ShortDatePattern;
    }

    public String getMediumDatePattern() {
        return this.m_MediumDatePattern;
    }

    public String getLongDatePattern() {
        return this.m_LongDatePattern;
    }

    public String getDowMonthDayDatePattern() {
        return this.m_DowMonthDayPattern;
    }

    public String getMonthYearDatePattern() {
        return this.m_MonthYearPattern;
    }

    public String get12TimePattern() {
        return this.m_Time12Pattern;
    }

    public String get24TimePattern() {
        return this.m_Time24Pattern;
    }

    public String getTimePattern() {
        return this.m_TimeDefaultPattern;
    }

    public String getShortTimePattern() {
        return this.getTimePattern();
    }

    public String getMediumTimePattern() {
        return this.getTimePattern();
    }

    public String getLongTimePattern() {
        return this.getTimePattern() + this.m_TimeSaparator + "ss";
    }

    public String getAmPmTimeElement() {
        return this.m_AmPmTimeElement;
    }

    public String[] getAmPmMarkers() {
        return this.m_AmPmMarkers;
    }

    public String getStartDow() {
        return this.m_StartDow;
    }

    public String getTimeZonePattern() {
        return this.m_ZonePattern;
    }

    public String[][] getTimeZoneResources() {
        return this.m_ZoneStrings;
    }

    public String[] getEraResources() {
        return this.m_EraRes;
    }

    public String[] getShortEraResources() {
        return this.m_ShortEraRes;
    }

    public String[] getJapaneseEraResources() {
        return this.m_JapaneseEraRes;
    }

    public String[] getJapaneseShortEraResources() {
        return this.m_JapaneseShortEraRes;
    }

    public String[] getHijrahShortMonthResources() {
        return this.m_HijrahShortMonth;
    }

    public String[] getHijrahLongMonthResources() {
        return this.m_HijrahLongMonth;
    }

    public String[] getHijrahEraResources() {
        return this.m_HijrahEraRes;
    }

    public String[] getHijrahShortEraResources() {
        return this.m_HijrahShortEraRes;
    }

    public String[] getThaiEraResources() {
        return this.m_ThaiEraRes;
    }

    public String[] getThaiShortEraResources() {
        return this.m_ThaiShortEraRes;
    }

    public String[] getChinaEraResources() {
        return this.m_ChinaEraRes;
    }

    public String[] getChinaShortEraResources() {
        return this.m_ChinaShortEraRes;
    }
}

