/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text.resources;

import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.resources.CheckNumberResourceAccessor;

public class DefaultCheckNumberResourceAccessor
extends CheckNumberResourceAccessor {
    public static final String RCS_ID = "$Header: DefaultCheckNumberResourceAccessor.java 120.8 2013/04/04 20:55:19 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultCheckNumberResourceAccessor.java 120.8 2013/04/04 20:55:19 rsuzuki ship $", "oracle.apps.fnd.i18n.common.text.resources");
    private static final Locale FALLBACK_LOCALE = new Locale("en", "");
    private Locale m_Locale;
    private int m_DecimalStyle = 10;
    private String m_AndString = " ";
    private String m_ZeroString = "x";
    private Hashtable m_RuleDefLocale;
    private DecimalFormatSymbols m_DecimalFormatSymbols;
    private static final Hashtable m_RuleDefinition = new Hashtable();
    private static final Hashtable da_Def = new Hashtable();
    private static final Hashtable de_Def;
    private static final Hashtable en_Def;
    private static final Hashtable enGB_Def;
    private static final Hashtable eo_Def;
    private static final Hashtable es_Def;
    private static final Hashtable fa_Def;
    private static final Hashtable faAF_Def;
    private static final Hashtable fr_Def;
    private static final Hashtable frBE_Def;
    private static final Hashtable frCA_Def;
    private static final Hashtable frCH_Def;
    private static final Hashtable ga_Def;
    private static final Hashtable it_Def;
    private static final Hashtable iw_Def;
    private static final Hashtable ja_Def;
    private static final Hashtable ko_Def;
    private static final Hashtable mt_Def;
    private static final Hashtable nl_Def;
    private static final Hashtable pl_Def;
    private static final Hashtable pt_Def;
    private static final Hashtable ru_Def;
    private static final Hashtable sv_Def;
    private static final Hashtable th_Def;
    private static final Hashtable uk_Def;
    private static final Hashtable zh_Def;
    private static final Hashtable zhTW_Def;
    private static final Hashtable ar_Def;
    private static final Hashtable hr_Def;
    private static final Hashtable cs_Def;
    private static final Hashtable fi_Def;
    private static final Hashtable el_Def;
    private static final Hashtable hu_Def;
    private static final Hashtable sr_Def;
    private static final Hashtable sh_Def;
    private static final Hashtable lt_Def;
    private static final Hashtable ro_Def;
    private static final Hashtable sk_Def;
    private static final Hashtable sl_Def;
    private static final Hashtable sq_Def;
    private static final Hashtable tr_Def;
    private static final Hashtable vi_Def;
    private static final Hashtable id_Def;
    private static final Hashtable no_Def;
    private static final Hashtable kk_Def;
    private static Hashtable DefaultAndData;
    private static Hashtable Fraction1AndData;
    private static Hashtable Fraction2ZeroData;
    private static final int DECIMAL_STYLE_DEFAULT = 10;
    private static Hashtable DEFAULT_DECIMAL_STYLE_MAP;

    public DefaultCheckNumberResourceAccessor(Locale locale) {
        this.m_Locale = this.initRuleDefLocale(locale);
        this.m_DecimalFormatSymbols = new DecimalFormatSymbols(this.m_Locale);
        this.initDecimalStyle(this.m_Locale);
        this.initAndData(this.m_Locale, this.m_DecimalStyle);
        this.initZeroString(this.m_Locale, this.m_DecimalStyle);
    }

    public DefaultCheckNumberResourceAccessor(Locale locale, int n) {
        this.m_Locale = this.initRuleDefLocale(locale);
        this.m_DecimalFormatSymbols = new DecimalFormatSymbols(this.m_Locale);
        this.m_DecimalStyle = n;
        this.initAndData(this.m_Locale, this.m_DecimalStyle);
        this.initZeroString(this.m_Locale, this.m_DecimalStyle);
    }

    private Locale initRuleDefLocale(Locale locale) {
        Locale locale2 = locale;
        Hashtable hashtable = (Hashtable)m_RuleDefinition.get(locale);
        if (hashtable == null) {
            locale2 = new Locale(locale.getLanguage(), "");
            hashtable = (Hashtable)m_RuleDefinition.get(locale2);
        }
        if (hashtable == null) {
            locale2 = FALLBACK_LOCALE;
            hashtable = (Hashtable)m_RuleDefinition.get(locale2);
        }
        this.m_RuleDefLocale = hashtable;
        return locale2;
    }

    private void initAndData(Locale locale, int n) {
        String string = (String)DefaultAndData.get(locale);
        if (string == null) {
            string = (String)DefaultAndData.get(new Locale(locale.getLanguage(), ""));
        }
        if (string != null) {
            this.m_AndString = string;
        }
        if (n == 10) {
            string = (String)Fraction1AndData.get(locale);
            if (string == null) {
                string = (String)Fraction1AndData.get(new Locale(locale.getLanguage(), ""));
            }
            if (string != null) {
                this.m_AndString = string;
            }
        } else if (n == 11) {
            this.m_AndString = "/";
            String string2 = (String)Fraction2ZeroData.get(locale);
            if (string2 == null && (string2 = (String)Fraction2ZeroData.get(new Locale(locale.getLanguage(), ""))) != null) {
                this.m_ZeroString = string2;
            }
        }
    }

    private void initZeroString(Locale locale, int n) {
        if (n == 11) {
            String string = (String)Fraction2ZeroData.get(locale);
            if (string == null) {
                string = (String)Fraction2ZeroData.get(new Locale(locale.getLanguage(), ""));
                if (string != null) {
                    this.m_ZeroString = string;
                }
            } else {
                this.m_ZeroString = string;
            }
        }
    }

    private void initDecimalStyle(Locale locale) {
        Integer n = (Integer)DEFAULT_DECIMAL_STYLE_MAP.get(locale);
        if (n == null) {
            n = (Integer)DEFAULT_DECIMAL_STYLE_MAP.get(new Locale(locale.getLanguage(), ""));
        }
        this.m_DecimalStyle = n == null ? 10 : n;
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public Hashtable getRuleDefinition() {
        return this.m_RuleDefLocale;
    }

    public String getAndData() {
        return this.m_AndString;
    }

    public String getZeroString() {
        return this.m_ZeroString;
    }

    public int getDecimalStyle() {
        return this.m_DecimalStyle;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.m_DecimalFormatSymbols;
    }

    /*
     * Opcode count of 20642 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        String[] stringArray = new String[]{"0/1/1:[nul];[];[];[];[];[];[];[];[false];[];[nul]", "1/1/1:[en];[];[];[];[];[];[];[];[false];[];[en]", "2/1/1:[to];[];[];[];[];[];[];[];[false];[];[to]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[fire];[];[];[];[];[];[];[];[false];[];[fire]", "5/1/1:[fem];[];[];[];[];[];[];[];[false];[];[fem]", "6/1/1:[seks];[];[];[];[];[];[];[];[false];[];[seks]", "7/1/1:[syv];[];[];[];[];[];[];[];[false];[];[syv]", "8/1/1:[otte];[];[];[];[];[];[];[];[false];[];[otte]", "9/1/1:[ni];[];[];[];[];[];[];[];[false];[];[ni]", "10/10/2:[ti];[];[];[];[];[];[];[];[false];[];[ti]", "11/10/2:[elleve];[];[];[];[];[];[];[];[false];[];[elleve]", "12/10/2:[tolv];[];[];[];[];[];[];[];[false];[];[tolv]", "13/10/2:[tretten];[];[];[];[];[];[];[];[false];[];[tretten]", "14/10/2:[fjorten];[];[];[];[];[];[];[];[false];[];[fjorten]", "15/10/2:[femten];[];[];[];[];[];[];[];[false];[];[femten]", "16/10/2:[seksten];[];[];[];[];[];[];[];[false];[];[seksten]", "17/10/2:[sytten];[];[];[];[];[];[];[];[false];[];[sytten]", "18/10/2:[atten];[];[];[];[];[];[];[];[false];[];[atten]", "19/10/2:[nitten];[];[];[];[];[];[];[];[false];[];[nitten]", "20/10/2:[];[];[];[default];[];[og];[];[];[true];[tyve];[]", "30/10/2:[];[default];[ti];[default];[];[];[];[];[true];[];[]", "40/10/2:[firti];[];[];[default];[];[];[];[];[true];[];[]", "50/10/2:[];[default];[ti];[default];[];[];[];[];[true];[];[]", "60/10/2:[];[default];[ti];[default];[];[];[];[];[true];[];[]", "70/10/2:[];[default];[ti];[default];[];[];[];[];[true];[];[]", "80/10/2:[otti];[];[];[default];[];[];[];[];[true];[];[]", "90/10/2:[];[default];[ti];[default];[];[];[];[];[true];[];[]", "100/100/3:[et hundrede];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ hundrede];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[et tusinde];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[ tusinde];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[en million];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ millioner];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[en milliard];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ milliarder];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[en billion];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ billioner];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        da_Def.put("default", stringArray);
        String[] stringArray2 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        da_Def.put("minus", stringArray2);
        da_Def.put("decimal", stringArray);
        m_RuleDefinition.put(new Locale("da", ""), da_Def);
        de_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[null];[];[];[];[];[];[];[];[false];[];[null]", "1/1/1:[eins];[];[];[];[];[];[];[];[false];[];[eins]", "2/1/1:[];[];[];[];[];[];[base];[];[false];[];[]"};
        de_Def.put("zero-one-two", stringArray);
        stringArray2 = new String[]{"0/1/1:[null];[];[];[];[];[];[];[];[false];[];[null]", "1/1/1:[ein];[];[];[];[];[];[];[];[false];[];[ein]", "2/1/1:[zwei];[];[];[];[];[];[];[];[false];[];[zwei]", "3/1/1:[drei];[];[];[];[];[];[];[];[false];[];[drei]", "4/1/1:[vier];[];[];[];[];[];[];[];[false];[];[vier]", "5/1/1:[f\u00fcnf];[];[];[];[];[];[];[];[false];[];[f\u00fcnf]", "6/1/1:[sechs];[];[];[];[];[];[];[];[false];[];[sechs]", "7/1/1:[sieben];[];[];[];[];[];[];[];[false];[];[sieben]", "8/1/1:[acht];[];[];[];[];[];[];[];[false];[];[acht]", "9/1/1:[neun];[];[];[];[];[];[];[];[false];[];[neun]", "10/10/2:[zehn];[];[];[];[];[];[];[];[false];[];[zehn]", "11/10/2:[elf];[];[];[];[];[];[];[];[false];[];[elf]", "12/10/2:[zw\u00f6lf];[];[];[];[];[];[];[];[false];[];[zw\u00f6lf]", "13/10/2:[];[];[];[base];[];[];[];[];[false];[zehn];[]", "20/10/2:[];[];[];[base];[];[und];[];[];[true];[zwanzig];[]", "30/10/2:[];[];[];[base];[];[und];[];[];[true];[drei\u00dfig];[]", "40/10/2:[];[];[];[base];[];[und];[];[];[true];[vierzig];[]", "50/10/2:[];[];[];[base];[];[und];[];[];[true];[f\u00fcnfzig];[]", "60/10/2:[];[];[];[base];[];[und];[];[];[true];[sechzig];[]", "70/10/2:[];[];[];[base];[];[und];[];[];[true];[siebzig];[]", "80/10/2:[];[];[];[base];[];[und];[];[];[true];[achtzig];[]", "90/10/2:[];[];[];[base];[];[und];[];[];[true];[neunzig];[]", "100/100/3:[hundert];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "200/100/3:[];[base];[hundert];[zero-one-two];[];[];[];[];[true];[];[]", "1000/1000/4:[tausend];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "1100/1000/4:[tausendein];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "1200/1000/4:[tausend];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "2000/1000/4:[];[base];[tausend];[zero-one-two];[];[];[];[];[true];[];[]", "1000000/1000000/7:[eine Million];[];[];[zero-one-two];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[base];[ Millionen];[zero-one-two];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[eine Milliarde];[];[];[zero-one-two];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[base];[ Milliarden];[zero-one-two];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[eine Billion];[];[];[zero-one-two];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[base];[ Billionen];[zero-one-two];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        de_Def.put("base", stringArray2);
        String[] stringArray3 = new String[]{"0/1/1:[null];[];[];[];[];[];[];[];[false];[];[null]", "1/1/1:[eins];[];[];[];[];[];[];[];[false];[];[eins]", "2/1/1:[];[];[];[];[];[];[base];[];[false];[];[]"};
        de_Def.put("default", stringArray3);
        String[] stringArray4 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        de_Def.put("minus", stringArray4);
        String[] stringArray5 = new String[]{"0/1/1:[null];[];[];[];[];[];[];[];[false];[];[null]", "1/1/1:[eins];[];[];[];[];[];[];[];[false];[];[eins]", "2/1/1:[];[];[];[];[];[];[base];[];[false];[];[]"};
        de_Def.put("decimal", stringArray5);
        m_RuleDefinition.put(new Locale("de", ""), de_Def);
        en_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[one];[];[];[];[];[];[];[];[false];[];[one]", "2/1/1:[two];[];[];[];[];[];[];[];[false];[];[two]", "3/1/1:[three];[];[];[];[];[];[];[];[false];[];[three]", "4/1/1:[four];[];[];[];[];[];[];[];[false];[];[four]", "5/1/1:[five];[];[];[];[];[];[];[];[false];[];[five]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[seven];[];[];[];[];[];[];[];[false];[];[seven]", "8/1/1:[eight];[];[];[];[];[];[];[];[false];[];[eight]", "9/1/1:[nine];[];[];[];[];[];[];[];[false];[];[nine]", "10/10/2:[ten];[];[];[];[];[];[];[];[false];[];[ten]", "11/10/2:[eleven];[];[];[];[];[];[];[];[false];[];[eleven]", "12/10/2:[twelve];[];[];[];[];[];[];[];[false];[];[twelve]", "13/10/2:[thirteen];[];[];[];[];[];[];[];[false];[];[thirteen]", "14/10/2:[fourteen];[];[];[];[];[];[];[];[false];[];[fourteen]", "15/10/2:[fifteen];[];[];[];[];[];[];[];[false];[];[fifteen]", "16/10/2:[sixteen];[];[];[];[];[];[];[];[false];[];[sixteen]", "17/10/2:[seventeen];[];[];[];[];[];[];[];[false];[];[seventeen]", "18/10/2:[eighteen];[];[];[];[];[];[];[];[false];[];[eighteen]", "19/10/2:[nineteen];[];[];[];[];[];[];[];[false];[];[nineteen]", "20/10/2:[twenty];[];[];[default];[-];[];[];[];[true];[];[]", "30/10/2:[thirty];[];[];[default];[-];[];[];[];[true];[];[]", "40/10/2:[forty];[];[];[default];[-];[];[];[];[true];[];[]", "50/10/2:[fifty];[];[];[default];[-];[];[];[];[true];[];[]", "60/10/2:[sixty];[];[];[default];[-];[];[];[];[true];[];[]", "70/10/2:[seventy];[];[];[default];[-];[];[];[];[true];[];[]", "80/10/2:[eighty];[];[];[default];[-];[];[];[];[true];[];[]", "90/10/2:[ninety];[];[];[default];[-];[];[];[];[true];[];[]", "100/100/3:[];[default];[ hundred];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ thousand];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ million];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ billion];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ trillion];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        en_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        en_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[and ];[];[];[];[];[];[default];[];[false];[];[]", "100/100/3:[];[];[];[];[];[];[default];[];[false];[];[]"};
        en_Def.put("and", stringArray3);
        stringArray4 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[one];[];[];[];[];[];[];[];[false];[];[one]", "2/1/1:[two];[];[];[];[];[];[];[];[false];[];[two]", "3/1/1:[three];[];[];[];[];[];[];[];[false];[];[three]", "4/1/1:[four];[];[];[];[];[];[];[];[false];[];[four]", "5/1/1:[five];[];[];[];[];[];[];[];[false];[];[five]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[seven];[];[];[];[];[];[];[];[false];[];[seven]", "8/1/1:[eight];[];[];[];[];[];[];[];[false];[];[eight]", "9/1/1:[nine];[];[];[];[];[];[];[];[false];[];[nine]", "10/10/2:[ten];[];[];[];[];[];[];[];[false];[];[ten]", "11/10/2:[eleven];[];[];[];[];[];[];[];[false];[];[eleven]", "12/10/2:[twelve];[];[];[];[];[];[];[];[false];[];[twelve]", "13/10/2:[thirteen];[];[];[];[];[];[];[];[false];[];[thirteen]", "14/10/2:[fourteen];[];[];[];[];[];[];[];[false];[];[fourteen]", "15/10/2:[fifteen];[];[];[];[];[];[];[];[false];[];[fifteen]", "16/10/2:[sixteen];[];[];[];[];[];[];[];[false];[];[sixteen]", "17/10/2:[seventeen];[];[];[];[];[];[];[];[false];[];[seventeen]", "18/10/2:[eighteen];[];[];[];[];[];[];[];[false];[];[eighteen]", "19/10/2:[nineteen];[];[];[];[];[];[];[];[false];[];[nineteen]", "20/10/2:[twenty];[];[];[decimal];[-];[];[];[];[true];[];[]", "30/10/2:[thirty];[];[];[decimal];[-];[];[];[];[true];[];[]", "40/10/2:[forty];[];[];[decimal];[-];[];[];[];[true];[];[]", "50/10/2:[fifty];[];[];[decimal];[-];[];[];[];[true];[];[]", "60/10/2:[sixty];[];[];[decimal];[-];[];[];[];[true];[];[]", "70/10/2:[seventy];[];[];[decimal];[-];[];[];[];[true];[];[]", "80/10/2:[eighty];[];[];[decimal];[-];[];[];[];[true];[];[]", "90/10/2:[ninety];[];[];[decimal];[-];[];[];[];[true];[];[]", "100/100/3:[];[decimal];[ hundred];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[decimal];[ thousand];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ million];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ billion];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ trillion];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        en_Def.put("decimal", stringArray4);
        m_RuleDefinition.put(new Locale("en", ""), en_Def);
        enGB_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[one];[];[];[];[];[];[];[];[false];[];[one]", "2/1/1:[two];[];[];[];[];[];[];[];[false];[];[two]", "3/1/1:[three];[];[];[];[];[];[];[];[false];[];[three]", "4/1/1:[four];[];[];[];[];[];[];[];[false];[];[four]", "5/1/1:[five];[];[];[];[];[];[];[];[false];[];[five]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[seven];[];[];[];[];[];[];[];[false];[];[seven]", "8/1/1:[eight];[];[];[];[];[];[];[];[false];[];[eight]", "9/1/1:[nine];[];[];[];[];[];[];[];[false];[];[nine]", "10/10/2:[ten];[];[];[];[];[];[];[];[false];[];[ten]", "11/10/2:[eleven];[];[];[];[];[];[];[];[false];[];[eleven]", "12/10/2:[twelve];[];[];[];[];[];[];[];[false];[];[twelve]", "13/10/2:[thirteen];[];[];[];[];[];[];[];[false];[];[thirteen]", "14/10/2:[fourteen];[];[];[];[];[];[];[];[false];[];[fourteen]", "15/10/2:[fifteen];[];[];[];[];[];[];[];[false];[];[fifteen]", "16/10/2:[sixteen];[];[];[];[];[];[];[];[false];[];[sixteen]", "17/10/2:[seventeen];[];[];[];[];[];[];[];[false];[];[seventeen]", "18/10/2:[eighteen];[];[];[];[];[];[];[];[false];[];[eighteen]", "19/10/2:[nineteen];[];[];[];[];[];[];[];[false];[];[nineteen]", "20/10/2:[twenty];[];[];[default];[-];[];[];[];[true];[];[]", "30/10/2:[thirty];[];[];[default];[-];[];[];[];[true];[];[]", "40/10/2:[forty];[];[];[default];[-];[];[];[];[true];[];[]", "50/10/2:[fifty];[];[];[default];[-];[];[];[];[true];[];[]", "60/10/2:[sixty];[];[];[default];[-];[];[];[];[true];[];[]", "70/10/2:[seventy];[];[];[default];[-];[];[];[];[true];[];[]", "80/10/2:[eighty];[];[];[default];[-];[];[];[];[true];[];[]", "90/10/2:[ninety];[];[];[default];[-];[];[];[];[true];[];[]", "100/100/3:[];[default];[ hundred];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ thousand];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ million];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ billion];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        enGB_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        enGB_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[and ];[];[];[];[];[];[default];[];[false];[];[]", "100/100/3:[];[];[];[];[];[];[default];[];[false];[];[]"};
        enGB_Def.put("and", stringArray3);
        stringArray4 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[one];[];[];[];[];[];[];[];[false];[];[one]", "2/1/1:[two];[];[];[];[];[];[];[];[false];[];[two]", "3/1/1:[three];[];[];[];[];[];[];[];[false];[];[three]", "4/1/1:[four];[];[];[];[];[];[];[];[false];[];[four]", "5/1/1:[five];[];[];[];[];[];[];[];[false];[];[five]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[seven];[];[];[];[];[];[];[];[false];[];[seven]", "8/1/1:[eight];[];[];[];[];[];[];[];[false];[];[eight]", "9/1/1:[nine];[];[];[];[];[];[];[];[false];[];[nine]", "10/10/2:[ten];[];[];[];[];[];[];[];[false];[];[ten]", "11/10/2:[eleven];[];[];[];[];[];[];[];[false];[];[eleven]", "12/10/2:[twelve];[];[];[];[];[];[];[];[false];[];[twelve]", "13/10/2:[thirteen];[];[];[];[];[];[];[];[false];[];[thirteen]", "14/10/2:[fourteen];[];[];[];[];[];[];[];[false];[];[fourteen]", "15/10/2:[fifteen];[];[];[];[];[];[];[];[false];[];[fifteen]", "16/10/2:[sixteen];[];[];[];[];[];[];[];[false];[];[sixteen]", "17/10/2:[seventeen];[];[];[];[];[];[];[];[false];[];[seventeen]", "18/10/2:[eighteen];[];[];[];[];[];[];[];[false];[];[eighteen]", "19/10/2:[nineteen];[];[];[];[];[];[];[];[false];[];[nineteen]", "20/10/2:[twenty];[];[];[decimal];[-];[];[];[];[true];[];[]", "30/10/2:[thirty];[];[];[decimal];[-];[];[];[];[true];[];[]", "40/10/2:[forty];[];[];[decimal];[-];[];[];[];[true];[];[]", "50/10/2:[fifty];[];[];[decimal];[-];[];[];[];[true];[];[]", "60/10/2:[sixty];[];[];[decimal];[-];[];[];[];[true];[];[]", "70/10/2:[seventy];[];[];[decimal];[-];[];[];[];[true];[];[]", "80/10/2:[eighty];[];[];[decimal];[-];[];[];[];[true];[];[]", "90/10/2:[ninety];[];[];[decimal];[-];[];[];[];[true];[];[]", "100/100/3:[];[decimal];[ hundred];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[decimal];[ thousand];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ million];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ billion];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        enGB_Def.put("decimal", stringArray4);
        m_RuleDefinition.put(new Locale("en", "GB"), enGB_Def);
        eo_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nulo];[];[];[];[];[];[];[];[false];[];[nulo]", "1/1/1:[unu];[];[];[];[];[];[];[];[false];[];[unu]", "2/1/1:[du];[];[];[];[];[];[];[];[false];[];[du]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[kvar];[];[];[];[];[];[];[];[false];[];[kvar]", "5/1/1:[kvin];[];[];[];[];[];[];[];[false];[];[kvin]", "6/1/1:[ses];[];[];[];[];[];[];[];[false];[];[ses]", "7/1/1:[sep];[];[];[];[];[];[];[];[false];[];[sep]", "8/1/1:[ok];[];[];[];[];[];[];[];[false];[];[ok]", "9/1/1:[na\u016d];[];[];[];[];[];[];[];[false];[];[na\u016d]", "10/10/2:[dek];[];[];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[default];[dek];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[cent];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[mil];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[mil];[default];[ ];[];[];[];[true];[];[]", "10000/10000/5:[dekmil];[];[];[default];[ ];[];[];[];[true];[];[]", "11000/1000/4:[];[default];[ mil];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[miliono];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milionoj];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[miliardo];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ miliardoj];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[biliono];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ bilionoj];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        eo_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        eo_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[nulo];[];[];[];[];[];[];[];[false];[];[nulo]", "1/1/1:[unu];[];[];[];[];[];[];[];[false];[];[unu]", "2/1/1:[du];[];[];[];[];[];[];[];[false];[];[du]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[kvar];[];[];[];[];[];[];[];[false];[];[kvar]", "5/1/1:[kvin];[];[];[];[];[];[];[];[false];[];[kvin]", "6/1/1:[ses];[];[];[];[];[];[];[];[false];[];[ses]", "7/1/1:[sep];[];[];[];[];[];[];[];[false];[];[sep]", "8/1/1:[ok];[];[];[];[];[];[];[];[false];[];[ok]", "9/1/1:[na\u016d];[];[];[];[];[];[];[];[false];[];[na\u016d]", "10/10/2:[dek];[];[];[decimal];[ ];[];[];[];[true];[];[]", "20/10/2:[];[decimal];[dek];[decimal];[ ];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[cent];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[mil];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[decimal];[mil];[decimal];[ ];[];[];[];[true];[];[]", "10000/10000/5:[dekmil];[];[];[decimal];[ ];[];[];[];[true];[];[]", "11000/1000/4:[];[decimal];[ mil];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[miliono];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[decimal];[ milionoj];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[miliardo];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[decimal];[ miliardoj];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[biliono];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[decimal];[ bilionoj];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        eo_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("eo", ""), eo_Def);
        es_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[cero];[];[];[];[];[];[];[];[false];[];[cero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[dos];[];[];[];[];[];[];[];[false];[];[dos]", "3/1/1:[tres];[];[];[];[];[];[];[];[false];[];[tres]", "4/1/1:[cuatro];[];[];[];[];[];[];[];[false];[];[cuatro]", "5/1/1:[cinco];[];[];[];[];[];[];[];[false];[];[cinco]", "6/1/1:[seis];[];[];[];[];[];[];[];[false];[];[seis]", "7/1/1:[siete];[];[];[];[];[];[];[];[false];[];[siete]", "8/1/1:[ocho];[];[];[];[];[];[];[];[false];[];[ocho]", "9/1/1:[nueve];[];[];[];[];[];[];[];[false];[];[nueve]", "10/10/2:[diez];[];[];[];[];[];[];[];[false];[];[diez]", "11/10/2:[once];[];[];[];[];[];[];[];[false];[];[once]", "12/10/2:[doce];[];[];[];[];[];[];[];[false];[];[doce]", "13/10/2:[trece];[];[];[];[];[];[];[];[false];[];[trece]", "14/10/2:[catorce];[];[];[];[];[];[];[];[false];[];[catorce]", "15/10/2:[quince];[];[];[];[];[];[];[];[false];[];[quince]", "16/10/2:[diecis\u00e9is];[];[];[];[];[];[];[];[false];[];[diecis\u00e9is]", "17/10/2:[diecisiete];[];[];[];[];[];[];[];[false];[];[diecisiete]", "18/10/2:[dieciocho];[];[];[];[];[];[];[];[false];[];[dieciocho]", "19/10/2:[diecinueve];[];[];[];[];[];[];[];[false];[];[diecinueve]", "20/10/2:[veinte];[];[];[];[];[];[];[];[false];[];[veinte]", "21/10/2:[veintiuno];[];[];[];[];[];[];[];[false];[];[veintiuno]", "22/10/2:[veintid\u00f3s];[];[];[];[];[];[];[];[false];[];[veintid\u00f3s]", "23/10/2:[veintitr\u00e9s];[];[];[];[];[];[];[];[false];[];[veintitr\u00e9s]", "24/10/2:[veinticuatro];[];[];[];[];[];[];[];[false];[];[veinticuatro]", "25/10/2:[veinticinco];[];[];[];[];[];[];[];[false];[];[veinticinco]", "26/10/2:[veintis\u00e9is];[];[];[];[];[];[];[];[false];[];[veintis\u00e9is]", "27/10/2:[veintisiete];[];[];[];[];[];[];[];[false];[];[veintisiete]", "28/10/2:[veintiocho];[];[];[];[];[];[];[];[false];[];[veintiocho]", "29/10/2:[veintinueve];[];[];[];[];[];[];[];[false];[];[veintinueve]", "30/10/2:[treinta];[];[];[default];[ y ];[];[];[];[true];[];[]", "40/10/2:[cuarenta];[];[];[default];[ y ];[];[];[];[true];[];[]", "50/10/2:[cincuenta];[];[];[default];[ y ];[];[];[];[true];[];[]", "60/10/2:[sesenta];[];[];[default];[ y ];[];[];[];[true];[];[]", "70/10/2:[setenta];[];[];[default];[ y ];[];[];[];[true];[];[]", "80/10/2:[ochenta];[];[];[default];[ y ];[];[];[];[true];[];[]", "90/10/2:[noventa];[];[];[default];[ y ];[];[];[];[true];[];[]", "100/100/3:[cien];[];[];[];[];[];[];[];[false];[];[cien]", "101/100/3:[ciento ];[];[];[default];[];[];[];[];[false];[];[]", "200/100/3:[doscientos];[];[];[default];[ ];[];[];[];[true];[];[]", "300/100/3:[trescientos];[];[];[default];[ ];[];[];[];[true];[];[]", "400/100/3:[cuatrocientos];[];[];[default];[ ];[];[];[];[true];[];[]", "500/100/3:[quinientos];[];[];[default];[ ];[];[];[];[true];[];[]", "600/100/3:[seiscientos];[];[];[default];[ ];[];[];[];[true];[];[]", "700/100/3:[setecientos];[];[];[default];[ ];[];[];[];[true];[];[]", "800/100/3:[ochocientos];[];[];[default];[ ];[];[];[];[true];[];[]", "900/100/3:[novecientos];[];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[mil];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[ mil];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[un mill\u00f3n];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ millones];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[];[];[];[];[];[#,##0];[];[false];[ (incomplete data)];[]"};
        es_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[menos ];[];[];[];[];[];[default];[];[false];[];[]"};
        es_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[cero];[];[];[];[];[];[];[];[false];[];[cero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[dos];[];[];[];[];[];[];[];[false];[];[dos]", "3/1/1:[tres];[];[];[];[];[];[];[];[false];[];[tres]", "4/1/1:[cuatro];[];[];[];[];[];[];[];[false];[];[cuatro]", "5/1/1:[cinco];[];[];[];[];[];[];[];[false];[];[cinco]", "6/1/1:[seis];[];[];[];[];[];[];[];[false];[];[seis]", "7/1/1:[siete];[];[];[];[];[];[];[];[false];[];[siete]", "8/1/1:[ocho];[];[];[];[];[];[];[];[false];[];[ocho]", "9/1/1:[nueve];[];[];[];[];[];[];[];[false];[];[nueve]", "10/10/2:[diez];[];[];[];[];[];[];[];[false];[];[diez]", "11/10/2:[once];[];[];[];[];[];[];[];[false];[];[once]", "12/10/2:[doce];[];[];[];[];[];[];[];[false];[];[doce]", "13/10/2:[trece];[];[];[];[];[];[];[];[false];[];[trece]", "14/10/2:[catorce];[];[];[];[];[];[];[];[false];[];[catorce]", "15/10/2:[quince];[];[];[];[];[];[];[];[false];[];[quince]", "16/10/2:[diecis\u00e9is];[];[];[];[];[];[];[];[false];[];[diecis\u00e9is]", "17/10/2:[diecisiete];[];[];[];[];[];[];[];[false];[];[diecisiete]", "18/10/2:[dieciocho];[];[];[];[];[];[];[];[false];[];[dieciocho]", "19/10/2:[diecinueve];[];[];[];[];[];[];[];[false];[];[diecinueve]", "20/10/2:[veinte];[];[];[];[];[];[];[];[false];[];[veinte]", "21/10/2:[veintiuno];[];[];[];[];[];[];[];[false];[];[veintiuno]", "22/10/2:[veintid\u00f3s];[];[];[];[];[];[];[];[false];[];[veintid\u00f3s]", "23/10/2:[veintitr\u00e9s];[];[];[];[];[];[];[];[false];[];[veintitr\u00e9s]", "24/10/2:[veinticuatro];[];[];[];[];[];[];[];[false];[];[veinticuatro]", "25/10/2:[veinticinco];[];[];[];[];[];[];[];[false];[];[veinticinco]", "26/10/2:[veintis\u00e9is];[];[];[];[];[];[];[];[false];[];[veintis\u00e9is]", "27/10/2:[veintisiete];[];[];[];[];[];[];[];[false];[];[veintisiete]", "28/10/2:[veintiocho];[];[];[];[];[];[];[];[false];[];[veintiocho]", "29/10/2:[veintinueve];[];[];[];[];[];[];[];[false];[];[veintinueve]", "30/10/2:[treinta];[];[];[decimal];[ y ];[];[];[];[true];[];[]", "40/10/2:[cuarenta];[];[];[decimal];[ y ];[];[];[];[true];[];[]", "50/10/2:[cincuenta];[];[];[decimal];[ y ];[];[];[];[true];[];[]", "60/10/2:[sesenta];[];[];[decimal];[ y ];[];[];[];[true];[];[]", "70/10/2:[setenta];[];[];[decimal];[ y ];[];[];[];[true];[];[]", "80/10/2:[ochenta];[];[];[decimal];[ y ];[];[];[];[true];[];[]", "90/10/2:[noventa];[];[];[decimal];[ y ];[];[];[];[true];[];[]", "100/100/3:[cien];[];[];[];[];[];[];[];[false];[];[cien]", "101/100/3:[ciento ];[];[];[decimal];[];[];[];[];[false];[];[]", "200/100/3:[doscientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "300/100/3:[trescientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "400/100/3:[cuatrocientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "500/100/3:[quinientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "600/100/3:[seiscientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "700/100/3:[setecientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "800/100/3:[ochocientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "900/100/3:[novecientos];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[mil];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[decimal];[ mil];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[un mill\u00f3n];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[decimal];[ millones];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[];[];[];[];[];[#,##0];[];[false];[ (incomplete data)];[]"};
        es_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("es", ""), es_Def);
        fa_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u0635\u0641\u0631];[];[];[];[];[];[];[];[false];[];[\u0635\u0641\u0631]", "1/1/1:[\u06cc\u06a9];[];[];[];[];[];[];[];[false];[];[\u06cc\u06a9]", "2/1/1:[\u062f\u0648];[];[];[];[];[];[];[];[false];[];[\u062f\u0648]", "3/1/1:[\u0633\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u0647]", "4/1/1:[\u0686\u0647\u0627\u0631];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631]", "5/1/1:[\u067e\u0646\u062c];[];[];[];[];[];[];[];[false];[];[\u067e\u0646\u062c]", "6/1/1:[\u0634\u0634];[];[];[];[];[];[];[];[false];[];[\u0634\u0634]", "7/1/1:[\u0647\u0641\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062a]", "8/1/1:[\u0647\u0634\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0634\u062a]", "9/1/1:[\u0646\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0647]", "10/10/2:[\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0647]", "11/10/2:[\u06cc\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u06cc\u0627\u0632\u062f\u0647]", "12/10/2:[\u062f\u0648\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0648\u0627\u0632\u062f\u0647]", "13/10/2:[\u0633\u06cc\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u06cc\u0632\u062f\u0647]", "14/10/2:[\u0686\u0647\u0627\u0631\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631\u062f\u0647]", "15/10/2:[\u067e\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u067e\u0627\u0646\u0632\u062f\u0647]", "16/10/2:[\u0634\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0634\u0627\u0646\u0632\u062f\u0647]", "17/10/2:[\u0647\u0641\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062f\u0647]", "18/10/2:[\u0647\u062c\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u062c\u062f\u0647]", "19/10/2:[\u0646\u0648\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0648\u0632\u062f\u0647]", "20/10/2:[\u0628\u06cc\u0633\u062a];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "30/10/2:[\u0633\u06cc];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "40/10/2:[\u0686\u0647\u0644];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "50/10/2:[\u067e\u0646\u062c\u0627\u0647];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "60/10/2:[\u0634\u0635\u062a];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "70/10/2:[\u0647\u0641\u062a\u0627\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "80/10/2:[\u0647\u0634\u062a\u0627\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "90/10/2:[\u0646\u0648\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "100/100/3:[\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "200/100/3:[\u062f\u0648\u06cc\u0633\u062a];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "300/100/3:[\u0633\u06cc\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "400/100/3:[\u0686\u0647\u0627\u0631\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "500/100/3:[\u067e\u0627\u0646\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "600/100/3:[\u0634\u0634\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "700/100/3:[\u0647\u0641\u062a\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "800/100/3:[\u0647\u0634\u062a\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "900/100/3:[\u0646\u0647\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ \u0647\u0632\u0627\u0631];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ \u0645\u06cc\u0644\u06cc\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ \u0645\u06cc\u0644\u06cc\u0627\u0631\u062f];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        fa_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u0645\u0646\u0641\u06cc ];[];[];[];[];[];[default];[];[false];[];[]"};
        fa_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u0635\u0641\u0631];[];[];[];[];[];[];[];[false];[];[\u0635\u0641\u0631]", "1/1/1:[\u06cc\u06a9];[];[];[];[];[];[];[];[false];[];[\u06cc\u06a9]", "2/1/1:[\u062f\u0648];[];[];[];[];[];[];[];[false];[];[\u062f\u0648]", "3/1/1:[\u0633\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u0647]", "4/1/1:[\u0686\u0647\u0627\u0631];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631]", "5/1/1:[\u067e\u0646\u062c];[];[];[];[];[];[];[];[false];[];[\u067e\u0646\u062c]", "6/1/1:[\u0634\u0634];[];[];[];[];[];[];[];[false];[];[\u0634\u0634]", "7/1/1:[\u0647\u0641\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062a]", "8/1/1:[\u0647\u0634\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0634\u062a]", "9/1/1:[\u0646\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0647]", "10/10/2:[\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0647]", "11/10/2:[\u06cc\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u06cc\u0627\u0632\u062f\u0647]", "12/10/2:[\u062f\u0648\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0648\u0627\u0632\u062f\u0647]", "13/10/2:[\u0633\u06cc\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u06cc\u0632\u062f\u0647]", "14/10/2:[\u0686\u0647\u0627\u0631\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631\u062f\u0647]", "15/10/2:[\u067e\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u067e\u0627\u0646\u0632\u062f\u0647]", "16/10/2:[\u0634\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0634\u0627\u0646\u0632\u062f\u0647]", "17/10/2:[\u0647\u0641\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062f\u0647]", "18/10/2:[\u0647\u062c\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u062c\u062f\u0647]", "19/10/2:[\u0646\u0648\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0648\u0632\u062f\u0647]", "20/10/2:[\u0628\u06cc\u0633\u062a];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "30/10/2:[\u0633\u06cc];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "40/10/2:[\u0686\u0647\u0644];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "50/10/2:[\u067e\u0646\u062c\u0627\u0647];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "60/10/2:[\u0634\u0635\u062a];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "70/10/2:[\u0647\u0641\u062a\u0627\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "80/10/2:[\u0647\u0634\u062a\u0627\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "90/10/2:[\u0646\u0648\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "100/100/3:[\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "200/100/3:[\u062f\u0648\u06cc\u0633\u062a];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "300/100/3:[\u0633\u06cc\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "400/100/3:[\u0686\u0647\u0627\u0631\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "500/100/3:[\u067e\u0627\u0646\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "600/100/3:[\u0634\u0634\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "700/100/3:[\u0647\u0641\u062a\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "800/100/3:[\u0647\u0634\u062a\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "900/100/3:[\u0646\u0647\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000/1000/4:[];[decimal];[ \u0647\u0632\u0627\u0631];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ \u0645\u06cc\u0644\u06cc\u0648\u0646];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ \u0645\u06cc\u0644\u06cc\u0627\u0631\u062f];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        fa_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("fa", ""), fa_Def);
        faAF_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u0635\u0641\u0631];[];[];[];[];[];[];[];[false];[];[\u0635\u0641\u0631]", "1/1/1:[\u06cc\u06a9];[];[];[];[];[];[];[];[false];[];[\u06cc\u06a9]", "2/1/1:[\u062f\u0648];[];[];[];[];[];[];[];[false];[];[\u062f\u0648]", "3/1/1:[\u0633\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u0647]", "4/1/1:[\u0686\u0647\u0627\u0631];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631]", "5/1/1:[\u067e\u0646\u062c];[];[];[];[];[];[];[];[false];[];[\u067e\u0646\u062c]", "6/1/1:[\u0634\u0634];[];[];[];[];[];[];[];[false];[];[\u0634\u0634]", "7/1/1:[\u0647\u0641\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062a]", "8/1/1:[\u0647\u0634\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0634\u062a]", "9/1/1:[\u0646\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0647]", "10/10/2:[\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0647]", "11/10/2:[\u06cc\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u06cc\u0627\u0632\u062f\u0647]", "12/10/2:[\u062f\u0648\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0648\u0627\u0632\u062f\u0647]", "13/10/2:[\u0633\u06cc\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u06cc\u0632\u062f\u0647]", "14/10/2:[\u0686\u0647\u0627\u0631\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631\u062f\u0647]", "15/10/2:[\u067e\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u067e\u0627\u0646\u0632\u062f\u0647]", "16/10/2:[\u0634\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0634\u0627\u0646\u0632\u062f\u0647]", "17/10/2:[\u0647\u0641\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062f\u0647]", "18/10/2:[\u0647\u062c\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u062c\u062f\u0647]", "19/10/2:[\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0632\u062f\u0647]", "20/10/2:[\u0628\u06cc\u0633\u062a];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "30/10/2:[\u0633\u06cc];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "40/10/2:[\u0686\u0647\u0644];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "50/10/2:[\u067e\u0646\u062c\u0627\u0647];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "60/10/2:[\u0634\u0635\u062a];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "70/10/2:[\u0647\u0641\u062a\u0627\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "80/10/2:[\u0647\u0634\u062a\u0627\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "90/10/2:[\u0646\u0648\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "100/100/3:[\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "200/100/3:[\u062f\u0648\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "300/100/3:[\u0633\u0647\u200c\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "400/100/3:[\u0686\u0647\u0627\u0631\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "500/100/3:[\u067e\u0646\u062c\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "600/100/3:[\u0634\u0634\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "700/100/3:[\u0647\u0641\u062a\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "800/100/3:[\u0647\u0634\u062a\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "900/100/3:[\u0646\u0647\u0635\u062f];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ \u0647\u0632\u0627\u0631];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ \u0645\u06cc\u0644\u06cc\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ \u0645\u06cc\u0644\u06cc\u0627\u0631\u062f];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        faAF_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u0645\u0646\u0641\u06cc ];[];[];[];[];[];[default];[];[false];[];[]"};
        faAF_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u0635\u0641\u0631];[];[];[];[];[];[];[];[false];[];[\u0635\u0641\u0631]", "1/1/1:[\u06cc\u06a9];[];[];[];[];[];[];[];[false];[];[\u06cc\u06a9]", "2/1/1:[\u062f\u0648];[];[];[];[];[];[];[];[false];[];[\u062f\u0648]", "3/1/1:[\u0633\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u0647]", "4/1/1:[\u0686\u0647\u0627\u0631];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631]", "5/1/1:[\u067e\u0646\u062c];[];[];[];[];[];[];[];[false];[];[\u067e\u0646\u062c]", "6/1/1:[\u0634\u0634];[];[];[];[];[];[];[];[false];[];[\u0634\u0634]", "7/1/1:[\u0647\u0641\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062a]", "8/1/1:[\u0647\u0634\u062a];[];[];[];[];[];[];[];[false];[];[\u0647\u0634\u062a]", "9/1/1:[\u0646\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0647]", "10/10/2:[\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0647]", "11/10/2:[\u06cc\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u06cc\u0627\u0632\u062f\u0647]", "12/10/2:[\u062f\u0648\u0627\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u062f\u0648\u0627\u0632\u062f\u0647]", "13/10/2:[\u0633\u06cc\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0633\u06cc\u0632\u062f\u0647]", "14/10/2:[\u0686\u0647\u0627\u0631\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0686\u0647\u0627\u0631\u062f\u0647]", "15/10/2:[\u067e\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u067e\u0627\u0646\u0632\u062f\u0647]", "16/10/2:[\u0634\u0627\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0634\u0627\u0646\u0632\u062f\u0647]", "17/10/2:[\u0647\u0641\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u0641\u062f\u0647]", "18/10/2:[\u0647\u062c\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0647\u062c\u062f\u0647]", "19/10/2:[\u0646\u0632\u062f\u0647];[];[];[];[];[];[];[];[false];[];[\u0646\u0632\u062f\u0647]", "20/10/2:[\u0628\u06cc\u0633\u062a];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "30/10/2:[\u0633\u06cc];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "40/10/2:[\u0686\u0647\u0644];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "50/10/2:[\u067e\u0646\u062c\u0627\u0647];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "60/10/2:[\u0634\u0635\u062a];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "70/10/2:[\u0647\u0641\u062a\u0627\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "80/10/2:[\u0647\u0634\u062a\u0627\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "90/10/2:[\u0646\u0648\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "100/100/3:[\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "200/100/3:[\u062f\u0648\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "300/100/3:[\u0633\u0647\u200c\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "400/100/3:[\u0686\u0647\u0627\u0631\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "500/100/3:[\u067e\u0646\u062c\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "600/100/3:[\u0634\u0634\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "700/100/3:[\u0647\u0641\u062a\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "800/100/3:[\u0647\u0634\u062a\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "900/100/3:[\u0646\u0647\u0635\u062f];[];[];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000/1000/4:[];[decimal];[ \u0647\u0632\u0627\u0631];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ \u0645\u06cc\u0644\u06cc\u0648\u0646];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ \u0645\u06cc\u0644\u06cc\u0627\u0631\u062f];[decimal];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        faAF_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("fa", "AF"), faAF_Def);
        fr_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/20/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "71/10/2:[soixante et onze];[];[];[];[];[];[];[];[false];[];[soixante et onze]", "72/20/2:[soixante-];[];[];[zero-one-two];[];[];[];[];[false];[];[]", "80/10/2:[quatre-vingts];[];[];[];[];[];[];[];[false];[];[quatre-vingts]", "81/20/2:[quatre-vingt-];[];[];[default];[];[];[];[];[false];[];[]", "100/100/3:[cent];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[default];[ cent];[default];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[default];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[default];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[default];[];[];[];[];[false];[];[]", "2000/1000/4:[];[default];[ mille];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ million];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ milliard];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ billion];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        fr_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[moins ];[];[];[];[];[];[default];[];[false];[];[]"};
        fr_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/20/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "71/10/2:[soixante et onze];[];[];[];[];[];[];[];[false];[];[soixante et onze]", "72/20/2:[soixante-];[];[];[zero-one-two];[];[];[];[];[false];[];[]", "80/10/2:[quatre-vingts];[];[];[];[];[];[];[];[false];[];[quatre-vingts]", "81/20/2:[quatre-vingt-];[];[];[base];[];[];[];[];[false];[];[]", "100/100/3:[cent];[];[];[base];[ ];[];[];[];[true];[];[]", "200/100/3:[];[base];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[base];[ cent];[base];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[base];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[base];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[base];[];[];[];[];[false];[];[]", "2000/1000/4:[];[base];[ mille];[base];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[base];[ million];[base];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[base];[ milliard];[base];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[base];[ billion];[base];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        fr_Def.put("base", stringArray3);
        stringArray4 = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[et-un];[];[];[];[];[];[];[];[false];[];[et-un]", "2/1/1:[];[];[];[];[];[];[base];[];[false];[];[]"};
        fr_Def.put("zero-one-two", stringArray4);
        stringArray5 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/20/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "71/10/2:[soixante et onze];[];[];[];[];[];[];[];[false];[];[soixante et onze]", "72/20/2:[soixante-];[];[];[zero-one-two];[];[];[];[];[false];[];[]", "80/10/2:[quatre-vingts];[];[];[];[];[];[];[];[false];[];[quatre-vingts]", "81/20/2:[quatre-vingt-];[];[];[decimal];[];[];[];[];[false];[];[]", "100/100/3:[cent];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[decimal];[ cent];[decimal];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[decimal];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[decimal];[];[];[];[];[false];[];[]", "2000/1000/4:[];[decimal];[ mille];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ million];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ milliard];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ billion];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        fr_Def.put("decimal", stringArray5);
        m_RuleDefinition.put(new Locale("fr", ""), fr_Def);
        frBE_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/10/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "70/10/2:[septante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "80/10/2:[huitante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "90/10/2:[nonante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[default];[ cent];[default];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[default];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[default];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[default];[];[];[];[];[false];[];[]", "2000/1000/4:[];[default];[ mille];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ million];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ milliarde];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ billion];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frBE_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[moins ];[];[];[];[];[];[default];[];[false];[];[]"};
        frBE_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/10/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "70/10/2:[septante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "80/10/2:[huitante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "90/10/2:[nonante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[base];[ ];[];[];[];[true];[];[]", "200/100/3:[];[base];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[base];[ cent];[base];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[base];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[base];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[base];[];[];[];[];[false];[];[]", "2000/1000/4:[];[base];[ mille];[base];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[base];[ million];[base];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[base];[ milliarde];[base];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[base];[ billion];[base];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frBE_Def.put("base", stringArray3);
        stringArray4 = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[et-un];[];[];[];[];[];[];[];[false];[];[et-un]", "2/1/1:[];[];[];[];[];[];[base];[];[false];[];[]"};
        frBE_Def.put("zero-one-two", stringArray4);
        stringArray5 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/10/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "70/10/2:[septante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "80/10/2:[huitante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "90/10/2:[nonante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[decimal];[ cent];[decimal];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[decimal];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[decimal];[];[];[];[];[false];[];[]", "2000/1000/4:[];[decimal];[ mille];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ million];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ milliarde];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ billion];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frBE_Def.put("decimal", stringArray5);
        m_RuleDefinition.put(new Locale("fr", "BE"), frBE_Def);
        frCA_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/20/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "71/10/2:[soixante et onze];[];[];[];[];[];[];[];[false];[];[soixante et onze]", "72/20/2:[soixante-];[];[];[zero-one-two];[];[];[];[];[false];[];[]", "80/10/2:[quatre-vingts];[];[];[];[];[];[];[];[false];[];[quatre-vingts]", "81/20/2:[quatre-vingt-];[];[];[default];[];[];[];[];[false];[];[]", "100/100/3:[cent];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[default];[ cent];[default];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[default];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[default];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[default];[];[];[];[];[false];[];[]", "2000/1000/4:[];[default];[ mille];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ million];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ milliard];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ billion];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frCA_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[moins ];[];[];[];[];[];[default];[];[false];[];[]"};
        frCA_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/20/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "71/10/2:[soixante et onze];[];[];[];[];[];[];[];[false];[];[soixante et onze]", "72/20/2:[soixante-];[];[];[zero-one-two];[];[];[];[];[false];[];[]", "80/10/2:[quatre-vingts];[];[];[];[];[];[];[];[false];[];[quatre-vingts]", "81/20/2:[quatre-vingt-];[];[];[base];[];[];[];[];[false];[];[]", "100/100/3:[cent];[];[];[base];[ ];[];[];[];[true];[];[]", "200/100/3:[];[base];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[base];[ cent];[base];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[base];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[base];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[base];[];[];[];[];[false];[];[]", "2000/1000/4:[];[base];[ mille];[base];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[base];[ million];[base];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[base];[ milliard];[base];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[base];[ billion];[base];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frCA_Def.put("base", stringArray3);
        stringArray4 = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[et-un];[];[];[];[];[];[];[];[false];[];[et-un]", "2/1/1:[];[];[];[];[];[];[base];[];[false];[];[]"};
        frCA_Def.put("zero-one-two", stringArray4);
        stringArray5 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/20/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "71/10/2:[soixante et onze];[];[];[];[];[];[];[];[false];[];[soixante et onze]", "72/20/2:[soixante-];[];[];[zero-one-two];[];[];[];[];[false];[];[]", "80/10/2:[quatre-vingts];[];[];[];[];[];[];[];[false];[];[quatre-vingts]", "81/20/2:[quatre-vingt-];[];[];[decimal];[];[];[];[];[false];[];[]", "100/100/3:[cent];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[decimal];[ cent];[decimal];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[decimal];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[decimal];[];[];[];[];[false];[];[]", "2000/1000/4:[];[decimal];[ mille];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ million];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ milliard];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ billion];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frCA_Def.put("decimal", stringArray5);
        m_RuleDefinition.put(new Locale("fr", "CA"), frCA_Def);
        frCH_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/10/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "70/10/2:[septante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "80/10/2:[huitante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "90/10/2:[nonante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[default];[ cent];[default];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[default];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[default];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[default];[];[];[];[];[false];[];[]", "2000/1000/4:[];[default];[ mille];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ million];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ milliarde];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ billion];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frCH_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[moins ];[];[];[];[];[];[default];[];[false];[];[]"};
        frCH_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/10/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "70/10/2:[septante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "80/10/2:[huitante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "90/10/2:[nonante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[base];[ ];[];[];[];[true];[];[]", "200/100/3:[];[base];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[base];[ cent];[base];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[base];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[base];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[base];[];[];[];[];[false];[];[]", "2000/1000/4:[];[base];[ mille];[base];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[base];[ million];[base];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[base];[ milliarde];[base];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[base];[ billion];[base];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frCH_Def.put("base", stringArray3);
        stringArray4 = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[et-un];[];[];[];[];[];[];[];[false];[];[et-un]", "2/1/1:[];[];[];[];[];[];[base];[];[false];[];[]"};
        frCH_Def.put("zero-one-two", stringArray4);
        stringArray5 = new String[]{"0/1/1:[z\u00e9ro];[];[];[];[];[];[];[];[false];[];[z\u00e9ro]", "1/1/1:[un];[];[];[];[];[];[];[];[false];[];[un]", "2/1/1:[deux];[];[];[];[];[];[];[];[false];[];[deux]", "3/1/1:[trois];[];[];[];[];[];[];[];[false];[];[trois]", "4/1/1:[quatre];[];[];[];[];[];[];[];[false];[];[quatre]", "5/1/1:[cinq];[];[];[];[];[];[];[];[false];[];[cinq]", "6/1/1:[six];[];[];[];[];[];[];[];[false];[];[six]", "7/1/1:[sept];[];[];[];[];[];[];[];[false];[];[sept]", "8/1/1:[huit];[];[];[];[];[];[];[];[false];[];[huit]", "9/1/1:[neuf];[];[];[];[];[];[];[];[false];[];[neuf]", "10/10/2:[dix];[];[];[];[];[];[];[];[false];[];[dix]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[douze];[];[];[];[];[];[];[];[false];[];[douze]", "13/10/2:[treize];[];[];[];[];[];[];[];[false];[];[treize]", "14/10/2:[quatorze];[];[];[];[];[];[];[];[false];[];[quatorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[seize];[];[];[];[];[];[];[];[false];[];[seize]", "17/10/2:[dix-sept];[];[];[];[];[];[];[];[false];[];[dix-sept]", "18/10/2:[dix-huit];[];[];[];[];[];[];[];[false];[];[dix-huit]", "19/10/2:[dix-neuf];[];[];[];[];[];[];[];[false];[];[dix-neuf]", "20/10/2:[vingt];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "30/10/2:[trente];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "40/10/2:[quarante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "50/10/2:[cinquante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "60/10/2:[soixante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "70/10/2:[septante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "80/10/2:[huitante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "90/10/2:[nonante];[];[];[zero-one-two];[-];[];[];[];[true];[];[]", "100/100/3:[cent];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[ cents];[];[];[];[];[];[false];[];[]", "201/100/3:[];[decimal];[ cent];[decimal];[ ];[];[];[s];[true];[];[]", "1000/1000/4:[mille];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1100/100/3:[onze cents];[];[];[];[];[];[];[];[false];[];[onze cents]", "1101/100/3:[onze cent ];[];[];[decimal];[];[];[];[];[false];[];[]", "1200/1000/4:[mille ];[];[];[decimal];[];[];[];[];[false];[];[]", "2000/1000/4:[];[decimal];[ mille];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ million];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ milliarde];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ billion];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        frCH_Def.put("decimal", stringArray5);
        m_RuleDefinition.put(new Locale("fr", "CH"), frCH_Def);
        ga_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[aon];[];[];[];[];[];[];[];[false];[];[aon]", "2/1/1:[dh\u00e1];[];[];[];[];[];[];[];[false];[];[dh\u00e1]", "3/1/1:[tr\u00ed];[];[];[];[];[];[];[];[false];[];[tr\u00ed]", "4/1/1:[ceithre];[];[];[];[];[];[];[];[false];[];[ceithre]", "5/1/1:[c\u00faig];[];[];[];[];[];[];[];[false];[];[c\u00faig]", "6/1/1:[s\u00e9];[];[];[];[];[];[];[];[false];[];[s\u00e9]", "7/1/1:[seacht];[];[];[];[];[];[];[];[false];[];[seacht]", "8/1/1:[ocht];[];[];[];[];[];[];[];[false];[];[ocht]", "9/1/1:[naoi];[];[];[];[];[];[];[];[false];[];[naoi]", "10/10/2:[deich];[];[];[];[];[];[];[];[false];[];[deich]", "11/10/2:[aon];[];[];[];[];[];[];[];[false];[];[aon]", "12/10/2:[dh\u00e1];[];[];[];[];[];[];[];[false];[];[dh\u00e1]", "13/10/2:[tr\u00ed];[];[];[];[];[];[];[];[false];[];[tr\u00ed]", "14/10/2:[ceithre];[];[];[];[];[];[];[];[false];[];[ceithre]", "15/10/2:[c\u00faig];[];[];[];[];[];[];[];[false];[];[c\u00faig]", "16/10/2:[s\u00e9];[];[];[];[];[];[];[];[false];[];[s\u00e9]", "17/10/2:[seacht];[];[];[];[];[];[];[];[false];[];[seacht]", "18/10/2:[ocht];[];[];[];[];[];[];[];[false];[];[ocht]", "19/10/2:[naoi];[];[];[];[];[];[];[];[false];[];[naoi]", "20/10/2:[fiche];[];[];[base];[ is ];[];[];[];[true];[];[]", "30/10/2:[tr\u00edocha];[];[];[base];[ is ];[];[];[];[true];[];[]", "40/10/2:[daichead];[];[];[base];[ is ];[];[];[];[true];[];[]", "50/10/2:[caoga];[];[];[base];[ is ];[];[];[];[true];[];[]", "60/10/2:[seasca];[];[];[base];[ is ];[];[];[];[true];[];[]", "70/10/2:[seacht\u00f3];[];[];[base];[ is ];[];[];[];[true];[];[]", "80/10/2:[ocht\u00f3];[];[];[base];[ is ];[];[];[];[true];[];[]", "90/10/2:[n\u00f3cha];[];[];[base];[ is ];[];[];[];[true];[];[]", "100/100/3:[];[hundreds];[];[hundreds_is];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[base];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[base];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[base];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[base];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ga_Def.put("base", stringArray);
        stringArray2 = new String[]{"0/1/1:[a n\u00e1id];[];[];[];[];[];[];[];[false];[];[a n\u00e1id]", "1/1/1:[a haon];[];[];[];[];[];[];[];[false];[];[a haon]", "2/1/1:[a d\u00f3];[];[];[];[];[];[];[];[false];[];[a d\u00f3]", "3/1/1:[a tr\u00ed];[];[];[];[];[];[];[];[false];[];[a tr\u00ed]", "4/1/1:[a ceathair];[];[];[];[];[];[];[];[false];[];[a ceathair]", "5/1/1:[a c\u00faig];[];[];[];[];[];[];[];[false];[];[a c\u00faig]", "6/1/1:[a s\u00e9];[];[];[];[];[];[];[];[false];[];[a s\u00e9]", "7/1/1:[a seacht];[];[];[];[];[];[];[];[false];[];[a seacht]", "8/1/1:[a hocht];[];[];[];[];[];[];[];[false];[];[a hocht]", "9/1/1:[a naoi];[];[];[];[];[];[];[];[false];[];[a naoi]", "10/10/2:[a deich];[];[];[];[];[];[];[];[false];[];[a deich]", "11/10/2:[a haon d\u00e9ag];[];[];[];[];[];[];[];[false];[];[a haon d\u00e9ag]", "12/10/2:[a d\u00f3 dh\u00e9ag];[];[];[];[];[];[];[];[false];[];[a d\u00f3 dh\u00e9ag]", "13/10/2:[];[];[];[default];[];[];[];[];[false];[ d\u00e9ag];[]", "20/10/2:[fiche];[];[];[default];[ ];[];[];[];[true];[];[]", "30/10/2:[tr\u00edocha];[];[];[default];[ ];[];[];[];[true];[];[]", "40/10/2:[daichead];[];[];[default];[ ];[];[];[];[true];[];[]", "50/10/2:[caoga];[];[];[default];[ ];[];[];[];[true];[];[]", "60/10/2:[seasca];[];[];[default];[ ];[];[];[];[true];[];[]", "70/10/2:[seacht\u00f3];[];[];[default];[ ];[];[];[];[true];[];[]", "80/10/2:[ocht\u00f3];[];[];[default];[ ];[];[];[];[true];[];[]", "90/10/2:[n\u00f3cha];[];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[];[hundreds];[];[hundreds_is];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[default];[, ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[default];[, ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[default];[, ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[default];[, ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ga_Def.put("default", stringArray2);
        stringArray3 = new String[]{"1/1/1:[milli\u00fan];[];[];[];[];[];[];[];[false];[];[milli\u00fan]", "2/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "7/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "11/1/1:[];[base];[ thrilli\u00fan d\u00e9ag];[];[];[];[];[];[false];[];[]", "17/1/1:[];[base];[ dtrilli\u00fan d\u00e9ag];[];[];[];[];[];[false];[];[]", "20/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "21/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "27/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "31/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "37/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "41/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "47/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "51/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "57/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "61/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "67/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "71/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "77/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "81/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "87/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "91/1/1:[];[base];[ thrilli\u00fan];[];[];[];[];[];[false];[];[]", "97/1/1:[];[base];[ dtrilli\u00fan];[];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[trillions_is];[];[];[];[];[false];[];[]"};
        ga_Def.put("trillions", stringArray3);
        stringArray4 = new String[]{"1/1/1:[c\u00e9ad];[];[];[];[];[];[];[];[false];[];[c\u00e9ad]", "2/1/1:[];[base];[ ch\u00e9ad];[];[];[];[];[];[false];[];[]", "7/1/1:[];[base];[ gc\u00e9ad];[];[];[];[];[];[false];[];[]"};
        ga_Def.put("hundreds", stringArray4);
        stringArray5 = new String[]{"0/1/1:[m\u00edneas ];[];[];[];[];[];[default];[];[false];[];[]"};
        ga_Def.put("minus", stringArray5);
        String[] stringArray6 = new String[]{"0/1/1:[billi\u00fan];[];[];[];[];[];[];[];[false];[];[billi\u00fan]", "1/1/1:[is ];[];[];[];[];[];[base];[];[false];[ billi\u00fan];[]", "7/1/1:[is ];[];[];[];[];[];[base];[];[false];[ billi\u00fan];[]", "11/1/1:[is ];[billions];[];[];[];[];[];[];[false];[];[]", "20/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "21/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]", "30/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "31/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]", "40/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "41/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]", "50/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "51/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]", "60/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "61/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]", "70/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "71/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]", "80/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "81/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]", "90/10/2:[is ];[];[];[];[];[];[billions];[];[false];[];[]", "91/10/2:[];[];[];[];[];[];[billions];[];[false];[];[]"};
        ga_Def.put("billions_is", stringArray6);
        String[] stringArray7 = new String[]{"1/1/1:[billi\u00fan];[];[];[];[];[];[];[];[false];[];[billi\u00fan]", "2/1/1:[];[base];[ billi\u00fan];[];[];[];[];[];[false];[];[]", "11/1/1:[];[base];[ billi\u00fan d\u00e9ag];[];[];[];[];[];[false];[];[]", "20/1/1:[];[base];[ billi\u00fan];[];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[billions_is];[];[];[];[];[false];[];[]"};
        ga_Def.put("billions", stringArray7);
        String[] stringArray8 = new String[]{"1/1/1:[milli\u00fan];[];[];[];[];[];[];[];[false];[];[milli\u00fan]", "2/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "7/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "11/1/1:[];[base];[ mhilli\u00fan d\u00e9ag];[];[];[];[];[];[false];[];[]", "17/1/1:[];[base];[ milli\u00fan d\u00e9ag];[];[];[];[];[];[false];[];[]", "20/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "21/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "27/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "31/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "37/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "41/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "47/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "51/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "57/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "61/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "67/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "71/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "77/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "81/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "87/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "91/1/1:[];[base];[ mhilli\u00fan];[];[];[];[];[];[false];[];[]", "97/1/1:[];[base];[ milli\u00fan];[];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[millions_is];[];[];[];[];[false];[];[]"};
        ga_Def.put("millions", stringArray8);
        String[] stringArray9 = new String[]{"0/1/1:[a n\u00e1id];[];[];[];[];[];[];[];[false];[];[a n\u00e1id]", "1/1/1:[a haon];[];[];[];[];[];[];[];[false];[];[a haon]", "2/1/1:[a d\u00f3];[];[];[];[];[];[];[];[false];[];[a d\u00f3]", "3/1/1:[a tr\u00ed];[];[];[];[];[];[];[];[false];[];[a tr\u00ed]", "4/1/1:[a ceathair];[];[];[];[];[];[];[];[false];[];[a ceathair]", "5/1/1:[a c\u00faig];[];[];[];[];[];[];[];[false];[];[a c\u00faig]", "6/1/1:[a s\u00e9];[];[];[];[];[];[];[];[false];[];[a s\u00e9]", "7/1/1:[a seacht];[];[];[];[];[];[];[];[false];[];[a seacht]", "8/1/1:[a hocht];[];[];[];[];[];[];[];[false];[];[a hocht]", "9/1/1:[a naoi];[];[];[];[];[];[];[];[false];[];[a naoi]", "10/10/2:[a deich];[];[];[];[];[];[];[];[false];[];[a deich]", "11/10/2:[a haon d\u00e9ag];[];[];[];[];[];[];[];[false];[];[a haon d\u00e9ag]", "12/10/2:[a d\u00f3 dh\u00e9ag];[];[];[];[];[];[];[];[false];[];[a d\u00f3 dh\u00e9ag]", "13/10/2:[];[];[];[decimal];[];[];[];[];[false];[ d\u00e9ag];[]", "20/10/2:[fiche];[];[];[decimal];[ ];[];[];[];[true];[];[]", "30/10/2:[tr\u00edocha];[];[];[decimal];[ ];[];[];[];[true];[];[]", "40/10/2:[daichead];[];[];[decimal];[ ];[];[];[];[true];[];[]", "50/10/2:[caoga];[];[];[decimal];[ ];[];[];[];[true];[];[]", "60/10/2:[seasca];[];[];[decimal];[ ];[];[];[];[true];[];[]", "70/10/2:[seacht\u00f3];[];[];[decimal];[ ];[];[];[];[true];[];[]", "80/10/2:[ocht\u00f3];[];[];[decimal];[ ];[];[];[];[true];[];[]", "90/10/2:[n\u00f3cha];[];[];[decimal];[ ];[];[];[];[true];[];[]", "100/100/3:[];[hundreds];[];[hundreds_is];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[decimal];[, ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[decimal];[, ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[decimal];[, ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[decimal];[, ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ga_Def.put("decimal", stringArray9);
        String[] stringArray10 = new String[]{"0/1/1:[milli\u00fan];[];[];[];[];[];[];[];[false];[];[milli\u00fan]", "1/1/1:[is ];[];[];[];[];[];[base];[];[false];[ mhilli\u00fan];[]", "7/1/1:[is ];[];[];[];[];[];[base];[];[false];[ milli\u00fan];[]", "11/1/1:[is ];[millions];[];[];[];[];[];[];[false];[];[]", "20/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "21/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]", "30/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "31/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]", "40/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "41/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]", "50/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "51/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]", "60/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "61/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]", "70/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "71/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]", "80/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "81/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]", "90/10/2:[is ];[];[];[];[];[];[millions];[];[false];[];[]", "91/10/2:[];[];[];[];[];[];[millions];[];[false];[];[]"};
        ga_Def.put("millions_is", stringArray10);
        String[] stringArray11 = new String[]{"0/1/1:[m\u00edle];[];[];[];[];[];[];[];[false];[];[m\u00edle]", "2/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "7/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "11/1/1:[];[base];[ mh\u00edle dh\u00e9ag];[];[];[];[];[];[false];[];[]", "17/1/1:[];[base];[ m\u00edle dh\u00e9ag];[];[];[];[];[];[false];[];[]", "20/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "21/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "27/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "31/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "37/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "41/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "47/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "51/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "57/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "61/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "67/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "71/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "77/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "81/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "87/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "91/1/1:[];[base];[ mh\u00edle];[];[];[];[];[];[false];[];[]", "97/1/1:[];[base];[ m\u00edle];[];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[thousands_is];[];[];[];[];[false];[];[]"};
        ga_Def.put("thousands", stringArray11);
        String[] stringArray12 = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[];[];[];[];[];[];[default];[];[false];[];[]", "20/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "21/10/2:[];[];[];[];[];[];[default];[];[false];[];[]", "30/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "31/10/2:[];[];[];[];[];[];[default];[];[false];[];[]", "40/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "41/10/2:[];[];[];[];[];[];[default];[];[false];[];[]", "50/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "51/10/2:[];[];[];[];[];[];[default];[];[false];[];[]", "60/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "61/10/2:[];[];[];[];[];[];[default];[];[false];[];[]", "70/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "71/10/2:[];[];[];[];[];[];[default];[];[false];[];[]", "80/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "81/10/2:[];[];[];[];[];[];[default];[];[false];[];[]", "90/10/2:[is ];[];[];[];[];[];[default];[];[false];[];[]", "91/10/2:[];[];[];[];[];[];[default];[];[false];[];[]"};
        ga_Def.put("hundreds_is", stringArray12);
        String[] stringArray13 = new String[]{"0/1/1:[trilli\u00fan];[];[];[];[];[];[];[];[false];[];[trilli\u00fan]", "1/1/1:[is ];[];[];[];[];[];[base];[];[false];[ thrilli\u00fan];[]", "7/1/1:[is ];[];[];[];[];[];[base];[];[false];[ dtrilli\u00fan];[]", "11/1/1:[is ];[trillions];[];[];[];[];[];[];[false];[];[]", "20/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "21/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]", "30/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "31/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]", "40/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "41/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]", "50/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "51/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]", "60/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "61/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]", "70/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "71/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]", "80/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "81/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]", "90/10/2:[is ];[];[];[];[];[];[trillions];[];[false];[];[]", "91/10/2:[];[];[];[];[];[];[trillions];[];[false];[];[]"};
        ga_Def.put("trillions_is", stringArray13);
        String[] stringArray14 = new String[]{"0/1/1:[m\u00edle];[];[];[];[];[];[];[];[false];[];[m\u00edle]", "1/1/1:[is ];[];[];[];[];[];[base];[];[false];[ mh\u00edle];[]", "7/1/1:[is ];[];[];[];[];[];[base];[];[false];[ m\u00edle];[]", "11/1/1:[is ];[thousands];[];[];[];[];[];[];[false];[];[]", "20/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "21/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]", "30/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "31/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]", "40/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "41/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]", "50/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "51/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]", "60/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "61/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]", "70/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "71/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]", "80/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "81/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]", "90/10/2:[is ];[];[];[];[];[];[thousands];[];[false];[];[]", "91/10/2:[];[];[];[];[];[];[thousands];[];[false];[];[]"};
        ga_Def.put("thousands_is", stringArray14);
        m_RuleDefinition.put(new Locale("ga", ""), ga_Def);
        it_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[due];[];[];[];[];[];[];[];[false];[];[due]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[quattro];[];[];[];[];[];[];[];[false];[];[quattro]", "5/1/1:[cinque];[];[];[];[];[];[];[];[false];[];[cinque]", "6/1/1:[sei];[];[];[];[];[];[];[];[false];[];[sei]", "7/1/1:[sette];[];[];[];[];[];[];[];[false];[];[sette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[nove];[];[];[];[];[];[];[];[false];[];[nove]", "10/10/2:[dieci];[];[];[];[];[];[];[];[false];[];[dieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[dodici];[];[];[];[];[];[];[];[false];[];[dodici]", "13/10/2:[tredici];[];[];[];[];[];[];[];[false];[];[tredici]", "14/10/2:[quattordici];[];[];[];[];[];[];[];[false];[];[quattordici]", "15/10/2:[quindici];[];[];[];[];[];[];[];[false];[];[quindici]", "16/10/2:[sedici];[];[];[];[];[];[];[];[false];[];[sedici]", "17/10/2:[diciasette];[];[];[];[];[];[];[];[false];[];[diciasette]", "18/10/2:[diciotto];[];[];[];[];[];[];[];[false];[];[diciotto]", "19/10/2:[diciannove];[];[];[];[];[];[];[];[false];[];[diciannove]", "20/10/2:[venti];[];[];[];[];[];[];[];[false];[];[venti]", "21/10/2:[vent];[];[];[ends-i];[];[];[];[];[false];[];[]", "30/10/2:[trenta];[];[];[];[];[];[];[];[false];[];[trenta]", "31/10/2:[trent];[];[];[ends-a];[];[];[];[];[false];[];[]", "40/10/2:[quaranta];[];[];[];[];[];[];[];[false];[];[quaranta]", "41/10/2:[quarant];[];[];[ends-a];[];[];[];[];[false];[];[]", "50/10/2:[cinquanta];[];[];[];[];[];[];[];[false];[];[cinquanta]", "51/10/2:[cinquant];[];[];[ends-a];[];[];[];[];[false];[];[]", "60/10/2:[sessanta];[];[];[];[];[];[];[];[false];[];[sessanta]", "61/10/2:[sessant];[];[];[ends-a];[];[];[];[];[false];[];[]", "70/10/2:[settanta];[];[];[];[];[];[];[];[false];[];[settanta]", "71/10/2:[settant];[];[];[ends-a];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a];[];[];[];[];[false];[];[]", "90/10/2:[novanta];[];[];[];[];[];[];[];[false];[];[novanta]", "91/10/2:[novant];[];[];[ends-a];[];[];[];[];[false];[];[]", "100/100/3:[cento];[];[];[];[];[];[];[];[false];[];[cento]", "101/100/3:[cent];[];[];[ends-o];[];[];[];[];[true];[];[]", "200/100/3:[];[base];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[base];[cent];[ends-o];[];[];[];[o];[true];[];[]", "1000/1000/4:[mille];[];[];[];[];[];[];[];[false];[];[mille]", "1001/1000/4:[mille];[];[];[base];[];[];[];[];[false];[];[]", "2000/1000/4:[];[continue];[mila];[];[];[];[];[];[false];[];[]", "2001/1000/4:[];[continue];[mila];[base];[];[];[];[];[true];[];[]", "100000/1000/4:[];[continue];[mila];[base];[];[];[];[];[true];[];[]", "1000000/1000000/7:[un milione];[];[];[base];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[base];[ milioni];[base];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[un miliardo];[];[];[base];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[base];[ miliardi];[base];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[ (incomplete data)];[]"};
        it_Def.put("base", stringArray);
        stringArray2 = new String[]{"0/1/1:[azero];[];[];[];[];[];[];[];[false];[];[azero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[adue];[];[];[];[];[];[];[];[false];[];[adue]", "3/1/1:[atr\u00e9];[];[];[];[];[];[];[];[false];[];[atr\u00e9]", "4/1/1:[aquattro];[];[];[];[];[];[];[];[false];[];[aquattro]", "5/1/1:[acinque];[];[];[];[];[];[];[];[false];[];[acinque]", "6/1/1:[asei];[];[];[];[];[];[];[];[false];[];[asei]", "7/1/1:[asette];[];[];[];[];[];[];[];[false];[];[asette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[anove];[];[];[];[];[];[];[];[false];[];[anove]", "10/10/2:[adieci];[];[];[];[];[];[];[];[false];[];[adieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[adodici];[];[];[];[];[];[];[];[false];[];[adodici]", "13/10/2:[atredici];[];[];[];[];[];[];[];[false];[];[atredici]", "14/10/2:[aquattordici];[];[];[];[];[];[];[];[false];[];[aquattordici]", "15/10/2:[aquindici];[];[];[];[];[];[];[];[false];[];[aquindici]", "16/10/2:[asedici];[];[];[];[];[];[];[];[false];[];[asedici]", "17/10/2:[adiciasette];[];[];[];[];[];[];[];[false];[];[adiciasette]", "18/10/2:[adiciotto];[];[];[];[];[];[];[];[false];[];[adiciotto]", "19/10/2:[adiciannove];[];[];[];[];[];[];[];[false];[];[adiciannove]", "20/10/2:[aventi];[];[];[];[];[];[];[];[false];[];[aventi]", "21/10/2:[avent];[];[];[ends-i];[];[];[];[];[false];[];[]", "30/10/2:[atrenta];[];[];[];[];[];[];[];[false];[];[atrenta]", "31/10/2:[atrent];[];[];[ends-a];[];[];[];[];[false];[];[]", "40/10/2:[aquaranta];[];[];[];[];[];[];[];[false];[];[aquaranta]", "41/10/2:[aquarant];[];[];[ends-a];[];[];[];[];[false];[];[]", "50/10/2:[acinquanta];[];[];[];[];[];[];[];[false];[];[acinquanta]", "51/10/2:[acinquant];[];[];[ends-a];[];[];[];[];[false];[];[]", "60/10/2:[asessanta];[];[];[];[];[];[];[];[false];[];[asessanta]", "61/10/2:[asessant];[];[];[ends-a];[];[];[];[];[false];[];[]", "70/10/2:[asettanta];[];[];[];[];[];[];[];[false];[];[asettanta]", "71/10/2:[asettant];[];[];[ends-a];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a];[];[];[];[];[false];[];[]", "90/10/2:[anovanta];[];[];[];[];[];[];[];[false];[];[anovanta]", "91/10/2:[anovant];[];[];[ends-a];[];[];[];[];[false];[];[]", "100/100/3:[acento];[];[];[];[];[];[];[];[false];[];[acento]", "101/100/3:[acent];[];[];[ends-o];[];[];[];[];[true];[];[]", "200/100/3:[];[ends-a];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[ends-a];[cent];[ends-o];[];[];[];[o];[true];[];[]", "1000/1000/4:[amille];[];[];[];[];[];[];[];[false];[];[amille]", "1001/1000/4:[amill];[];[];[ends-i];[];[];[];[];[true];[];[]", "2000/1000/4:[];[ends-a];[mila];[];[];[];[];[];[false];[];[]", "2001/1000/4:[];[ends-a];[mil];[ends-a];[];[];[];[a];[true];[];[]", "100000/100000/6:[];[];[];[];[];[];[base];[];[false];[];[]"};
        it_Def.put("ends-a", stringArray2);
        stringArray3 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[due];[];[];[];[];[];[];[];[false];[];[due]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[quattro];[];[];[];[];[];[];[];[false];[];[quattro]", "5/1/1:[cinque];[];[];[];[];[];[];[];[false];[];[cinque]", "6/1/1:[sei];[];[];[];[];[];[];[];[false];[];[sei]", "7/1/1:[sette];[];[];[];[];[];[];[];[false];[];[sette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[nove];[];[];[];[];[];[];[];[false];[];[nove]", "10/10/2:[dieci];[];[];[];[];[];[];[];[false];[];[dieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[dodici];[];[];[];[];[];[];[];[false];[];[dodici]", "13/10/2:[tredici];[];[];[];[];[];[];[];[false];[];[tredici]", "14/10/2:[quattordici];[];[];[];[];[];[];[];[false];[];[quattordici]", "15/10/2:[quindici];[];[];[];[];[];[];[];[false];[];[quindici]", "16/10/2:[sedici];[];[];[];[];[];[];[];[false];[];[sedici]", "17/10/2:[diciasette];[];[];[];[];[];[];[];[false];[];[diciasette]", "18/10/2:[diciotto];[];[];[];[];[];[];[];[false];[];[diciotto]", "19/10/2:[diciannove];[];[];[];[];[];[];[];[false];[];[diciannove]", "20/10/2:[venti];[];[];[];[];[];[];[];[false];[];[venti]", "21/10/2:[vent];[];[];[ends-i];[];[];[];[];[false];[];[]", "30/10/2:[trenta];[];[];[];[];[];[];[];[false];[];[trenta]", "31/10/2:[trent];[];[];[ends-a];[];[];[];[];[false];[];[]", "40/10/2:[quaranta];[];[];[];[];[];[];[];[false];[];[quaranta]", "41/10/2:[quarant];[];[];[ends-a];[];[];[];[];[false];[];[]", "50/10/2:[cinquanta];[];[];[];[];[];[];[];[false];[];[cinquanta]", "51/10/2:[cinquant];[];[];[ends-a];[];[];[];[];[false];[];[]", "60/10/2:[sessanta];[];[];[];[];[];[];[];[false];[];[sessanta]", "61/10/2:[sessant];[];[];[ends-a];[];[];[];[];[false];[];[]", "70/10/2:[settanta];[];[];[];[];[];[];[];[false];[];[settanta]", "71/10/2:[settant];[];[];[ends-a];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a];[];[];[];[];[false];[];[]", "90/10/2:[novanta];[];[];[];[];[];[];[];[false];[];[novanta]", "91/10/2:[novant];[];[];[ends-a];[];[];[];[];[false];[];[]", "100/100/3:[cento];[];[];[];[];[];[];[];[false];[];[cento]", "101/100/3:[cent];[];[];[ends-o];[];[];[];[];[true];[];[]", "200/100/3:[];[default];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[default];[cent];[ends-o];[];[];[];[o];[true];[];[]", "1000/1000/4:[mille];[];[];[];[];[];[];[];[false];[];[mille]", "1001/1000/4:[mille];[];[];[default];[];[];[];[];[false];[];[]", "2000/1000/4:[];[continue];[mila];[];[];[];[];[];[false];[];[]", "2001/1000/4:[];[continue];[mila];[default];[];[];[];[];[true];[];[]", "100000/1000/4:[];[continue];[mila];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[un milione];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milioni];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[un miliardo];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ miliardi];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[ (incomplete data)];[]"};
        it_Def.put("default", stringArray3);
        stringArray4 = new String[]{"0/1/1:[ozero];[];[];[];[];[];[];[];[false];[];[ozero]", "1/1/1:[ouno];[];[];[];[];[];[];[];[false];[];[ouno]", "2/1/1:[odue];[];[];[];[];[];[];[];[false];[];[odue]", "3/1/1:[otre];[];[];[];[];[];[];[];[false];[];[otre]", "4/1/1:[oquattro];[];[];[];[];[];[];[];[false];[];[oquattro]", "5/1/1:[ocinque];[];[];[];[];[];[];[];[false];[];[ocinque]", "6/1/1:[osei];[];[];[];[];[];[];[];[false];[];[osei]", "7/1/1:[osette];[];[];[];[];[];[];[];[false];[];[osette]", "8/1/1:[ootto];[];[];[];[];[];[];[];[false];[];[ootto]", "9/1/1:[onove];[];[];[];[];[];[];[];[false];[];[onove]", "10/10/2:[odieci];[];[];[];[];[];[];[];[false];[];[odieci]", "11/10/2:[oundici];[];[];[];[];[];[];[];[false];[];[oundici]", "12/10/2:[ododici];[];[];[];[];[];[];[];[false];[];[ododici]", "13/10/2:[otredici];[];[];[];[];[];[];[];[false];[];[otredici]", "14/10/2:[oquattordici];[];[];[];[];[];[];[];[false];[];[oquattordici]", "15/10/2:[oquindici];[];[];[];[];[];[];[];[false];[];[oquindici]", "16/10/2:[osedici];[];[];[];[];[];[];[];[false];[];[osedici]", "17/10/2:[odiciasette];[];[];[];[];[];[];[];[false];[];[odiciasette]", "18/10/2:[odiciotto];[];[];[];[];[];[];[];[false];[];[odiciotto]", "19/10/2:[odiciannove];[];[];[];[];[];[];[];[false];[];[odiciannove]", "20/10/2:[oventi];[];[];[];[];[];[];[];[false];[];[oventi]", "21/10/2:[ovent];[];[];[ends-i-continue];[];[];[];[];[false];[];[]", "30/10/2:[otrenta];[];[];[];[];[];[];[];[false];[];[otrenta]", "31/10/2:[otrent];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "40/10/2:[oquaranta];[];[];[];[];[];[];[];[false];[];[oquaranta]", "41/10/2:[oquarant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "50/10/2:[ocinquanta];[];[];[];[];[];[];[];[false];[];[ocinquanta]", "51/10/2:[ocinquant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "60/10/2:[osessanta];[];[];[];[];[];[];[];[false];[];[osessanta]", "61/10/2:[osessant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "70/10/2:[osettanta];[];[];[];[];[];[];[];[false];[];[osettanta]", "71/10/2:[osettant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "80/10/2:[oottanta];[];[];[];[];[];[];[];[false];[];[oottanta]", "81/10/2:[oottant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "90/10/2:[onovanta];[];[];[];[];[];[];[];[false];[];[onovanta]", "91/10/2:[onovant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "100/100/3:[ocento];[];[];[];[];[];[];[];[false];[];[ocento]", "101/100/3:[ocent];[];[];[ends-o-continue];[];[];[];[];[true];[];[]", "200/100/3:[];[ends-o-continue];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[ends-o-continue];[cent];[ends-o-continue];[];[];[];[o];[true];[];[]", "1000/1000/4:[];[];[];[];[];[];[base];[];[false];[];[]"};
        it_Def.put("ends-o-continue", stringArray4);
        stringArray5 = new String[]{"0/1/1:[ozero];[];[];[];[];[];[];[];[false];[];[ozero]", "1/1/1:[ouno];[];[];[];[];[];[];[];[false];[];[ouno]", "2/1/1:[odue];[];[];[];[];[];[];[];[false];[];[odue]", "3/1/1:[otr\u00e9];[];[];[];[];[];[];[];[false];[];[otr\u00e9]", "4/1/1:[oquattro];[];[];[];[];[];[];[];[false];[];[oquattro]", "5/1/1:[ocinque];[];[];[];[];[];[];[];[false];[];[ocinque]", "6/1/1:[osei];[];[];[];[];[];[];[];[false];[];[osei]", "7/1/1:[osette];[];[];[];[];[];[];[];[false];[];[osette]", "8/1/1:[ootto];[];[];[];[];[];[];[];[false];[];[ootto]", "9/1/1:[onove];[];[];[];[];[];[];[];[false];[];[onove]", "10/10/2:[odieci];[];[];[];[];[];[];[];[false];[];[odieci]", "11/10/2:[oundici];[];[];[];[];[];[];[];[false];[];[oundici]", "12/10/2:[ododici];[];[];[];[];[];[];[];[false];[];[ododici]", "13/10/2:[otredici];[];[];[];[];[];[];[];[false];[];[otredici]", "14/10/2:[oquattordici];[];[];[];[];[];[];[];[false];[];[oquattordici]", "15/10/2:[oquindici];[];[];[];[];[];[];[];[false];[];[oquindici]", "16/10/2:[osedici];[];[];[];[];[];[];[];[false];[];[osedici]", "17/10/2:[odiciasette];[];[];[];[];[];[];[];[false];[];[odiciasette]", "18/10/2:[odiciotto];[];[];[];[];[];[];[];[false];[];[odiciotto]", "19/10/2:[odiciannove];[];[];[];[];[];[];[];[false];[];[odiciannove]", "20/10/2:[oventi];[];[];[];[];[];[];[];[false];[];[oventi]", "21/10/2:[ovent];[];[];[ends-i];[];[];[];[];[false];[];[]", "30/10/2:[otrenta];[];[];[];[];[];[];[];[false];[];[otrenta]", "31/10/2:[otrent];[];[];[ends-a];[];[];[];[];[false];[];[]", "40/10/2:[oquaranta];[];[];[];[];[];[];[];[false];[];[oquaranta]", "41/10/2:[oquarant];[];[];[ends-a];[];[];[];[];[false];[];[]", "50/10/2:[ocinquanta];[];[];[];[];[];[];[];[false];[];[ocinquanta]", "51/10/2:[ocinquant];[];[];[ends-a];[];[];[];[];[false];[];[]", "60/10/2:[osessanta];[];[];[];[];[];[];[];[false];[];[osessanta]", "61/10/2:[osessant];[];[];[ends-a];[];[];[];[];[false];[];[]", "70/10/2:[osettanta];[];[];[];[];[];[];[];[false];[];[osettanta]", "71/10/2:[osettant];[];[];[ends-a];[];[];[];[];[false];[];[]", "80/10/2:[oottanta];[];[];[];[];[];[];[];[false];[];[oottanta]", "81/10/2:[oottant];[];[];[ends-a];[];[];[];[];[false];[];[]", "90/10/2:[onovanta];[];[];[];[];[];[];[];[false];[];[onovanta]", "91/10/2:[onovant];[];[];[ends-a];[];[];[];[];[false];[];[]", "100/100/3:[ocento];[];[];[];[];[];[];[];[false];[];[ocento]", "101/100/3:[ocent];[];[];[ends-o];[];[];[];[];[true];[];[]", "200/100/3:[];[ends-o];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[ends-o];[cent];[ends-o];[];[];[];[o];[true];[];[]", "1000/1000/4:[omille];[];[];[];[];[];[];[];[false];[];[omille]", "1001/1000/4:[omill];[];[];[ends-i];[];[];[];[];[true];[];[]", "2000/1000/4:[];[ends-o];[mila];[];[];[];[];[];[false];[];[]", "2001/1000/4:[];[ends-o];[mil];[ends-a];[];[];[];[a];[true];[];[]", "100000/100000/6:[];[];[];[];[];[];[base];[];[false];[];[]"};
        it_Def.put("ends-o", stringArray5);
        stringArray6 = new String[]{"0/1/1:[meno ];[];[];[];[];[];[default];[];[false];[];[]"};
        it_Def.put("minus", stringArray6);
        stringArray7 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[due];[];[];[];[];[];[];[];[false];[];[due]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[quattro];[];[];[];[];[];[];[];[false];[];[quattro]", "5/1/1:[cinque];[];[];[];[];[];[];[];[false];[];[cinque]", "6/1/1:[sei];[];[];[];[];[];[];[];[false];[];[sei]", "7/1/1:[sette];[];[];[];[];[];[];[];[false];[];[sette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[nove];[];[];[];[];[];[];[];[false];[];[nove]", "10/10/2:[dieci];[];[];[];[];[];[];[];[false];[];[dieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[dodici];[];[];[];[];[];[];[];[false];[];[dodici]", "13/10/2:[tredici];[];[];[];[];[];[];[];[false];[];[tredici]", "14/10/2:[quattordici];[];[];[];[];[];[];[];[false];[];[quattordici]", "15/10/2:[quindici];[];[];[];[];[];[];[];[false];[];[quindici]", "16/10/2:[sedici];[];[];[];[];[];[];[];[false];[];[sedici]", "17/10/2:[diciasette];[];[];[];[];[];[];[];[false];[];[diciasette]", "18/10/2:[diciotto];[];[];[];[];[];[];[];[false];[];[diciotto]", "19/10/2:[diciannove];[];[];[];[];[];[];[];[false];[];[diciannove]", "20/10/2:[venti];[];[];[];[];[];[];[];[false];[];[venti]", "21/10/2:[vent];[];[];[ends-i-continue];[];[];[];[];[false];[];[]", "30/10/2:[trenta];[];[];[];[];[];[];[];[false];[];[trenta]", "31/10/2:[trent];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "40/10/2:[quaranta];[];[];[];[];[];[];[];[false];[];[quaranta]", "41/10/2:[quarant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "50/10/2:[cinquanta];[];[];[];[];[];[];[];[false];[];[cinquanta]", "51/10/2:[cinquant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "60/10/2:[sessanta];[];[];[];[];[];[];[];[false];[];[sessanta]", "61/10/2:[sessant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "70/10/2:[settanta];[];[];[];[];[];[];[];[false];[];[settanta]", "71/10/2:[settant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "90/10/2:[novanta];[];[];[];[];[];[];[];[false];[];[novanta]", "91/10/2:[novant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "100/100/3:[cento];[];[];[];[];[];[];[];[false];[];[cento]", "101/100/3:[cent];[];[];[ends-o-continue];[];[];[];[];[true];[];[]", "200/100/3:[];[continue];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[continue];[cent];[ends-o-continue];[];[];[];[o];[true];[];[]", "1000/1000/4:[];[];[];[];[];[];[base];[];[false];[];[]"};
        it_Def.put("continue", stringArray7);
        stringArray8 = new String[]{"0/1/1:[azero];[];[];[];[];[];[];[];[false];[];[azero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[adue];[];[];[];[];[];[];[];[false];[];[adue]", "3/1/1:[atre];[];[];[];[];[];[];[];[false];[];[atre]", "4/1/1:[aquattro];[];[];[];[];[];[];[];[false];[];[aquattro]", "5/1/1:[acinque];[];[];[];[];[];[];[];[false];[];[acinque]", "6/1/1:[asei];[];[];[];[];[];[];[];[false];[];[asei]", "7/1/1:[asette];[];[];[];[];[];[];[];[false];[];[asette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[anove];[];[];[];[];[];[];[];[false];[];[anove]", "10/10/2:[adieci];[];[];[];[];[];[];[];[false];[];[adieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[adodici];[];[];[];[];[];[];[];[false];[];[adodici]", "13/10/2:[atredici];[];[];[];[];[];[];[];[false];[];[atredici]", "14/10/2:[aquattordici];[];[];[];[];[];[];[];[false];[];[aquattordici]", "15/10/2:[aquindici];[];[];[];[];[];[];[];[false];[];[aquindici]", "16/10/2:[asedici];[];[];[];[];[];[];[];[false];[];[asedici]", "17/10/2:[adiciasette];[];[];[];[];[];[];[];[false];[];[adiciasette]", "18/10/2:[adiciotto];[];[];[];[];[];[];[];[false];[];[adiciotto]", "19/10/2:[adiciannove];[];[];[];[];[];[];[];[false];[];[adiciannove]", "20/10/2:[aventi];[];[];[];[];[];[];[];[false];[];[aventi]", "21/10/2:[avent];[];[];[ends-i-continue];[];[];[];[];[false];[];[]", "30/10/2:[atrenta];[];[];[];[];[];[];[];[false];[];[atrenta]", "31/10/2:[atrent];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "40/10/2:[aquaranta];[];[];[];[];[];[];[];[false];[];[aquaranta]", "41/10/2:[aquarant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "50/10/2:[acinquanta];[];[];[];[];[];[];[];[false];[];[acinquanta]", "51/10/2:[acinquant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "60/10/2:[asessanta];[];[];[];[];[];[];[];[false];[];[asessanta]", "61/10/2:[asessant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "70/10/2:[asettanta];[];[];[];[];[];[];[];[false];[];[asettanta]", "71/10/2:[asettant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "90/10/2:[anovanta];[];[];[];[];[];[];[];[false];[];[anovanta]", "91/10/2:[anovant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "100/100/3:[acento];[];[];[];[];[];[];[];[false];[];[acento]", "101/100/3:[acent];[];[];[ends-o-continue];[];[];[];[];[true];[];[]", "200/100/3:[];[ends-a-continue];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[ends-a-continue];[cent];[ends-o-continue];[];[];[];[o];[true];[];[]", "1000/1000/4:[];[];[];[];[];[];[base];[];[false];[];[]"};
        it_Def.put("ends-a-continue", stringArray8);
        stringArray9 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[due];[];[];[];[];[];[];[];[false];[];[due]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[quattro];[];[];[];[];[];[];[];[false];[];[quattro]", "5/1/1:[cinque];[];[];[];[];[];[];[];[false];[];[cinque]", "6/1/1:[sei];[];[];[];[];[];[];[];[false];[];[sei]", "7/1/1:[sette];[];[];[];[];[];[];[];[false];[];[sette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[nove];[];[];[];[];[];[];[];[false];[];[nove]", "10/10/2:[dieci];[];[];[];[];[];[];[];[false];[];[dieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[dodici];[];[];[];[];[];[];[];[false];[];[dodici]", "13/10/2:[tredici];[];[];[];[];[];[];[];[false];[];[tredici]", "14/10/2:[quattordici];[];[];[];[];[];[];[];[false];[];[quattordici]", "15/10/2:[quindici];[];[];[];[];[];[];[];[false];[];[quindici]", "16/10/2:[sedici];[];[];[];[];[];[];[];[false];[];[sedici]", "17/10/2:[diciasette];[];[];[];[];[];[];[];[false];[];[diciasette]", "18/10/2:[diciotto];[];[];[];[];[];[];[];[false];[];[diciotto]", "19/10/2:[diciannove];[];[];[];[];[];[];[];[false];[];[diciannove]", "20/10/2:[venti];[];[];[];[];[];[];[];[false];[];[venti]", "21/10/2:[vent];[];[];[ends-i];[];[];[];[];[false];[];[]", "30/10/2:[trenta];[];[];[];[];[];[];[];[false];[];[trenta]", "31/10/2:[trent];[];[];[ends-a];[];[];[];[];[false];[];[]", "40/10/2:[quaranta];[];[];[];[];[];[];[];[false];[];[quaranta]", "41/10/2:[quarant];[];[];[ends-a];[];[];[];[];[false];[];[]", "50/10/2:[cinquanta];[];[];[];[];[];[];[];[false];[];[cinquanta]", "51/10/2:[cinquant];[];[];[ends-a];[];[];[];[];[false];[];[]", "60/10/2:[sessanta];[];[];[];[];[];[];[];[false];[];[sessanta]", "61/10/2:[sessant];[];[];[ends-a];[];[];[];[];[false];[];[]", "70/10/2:[settanta];[];[];[];[];[];[];[];[false];[];[settanta]", "71/10/2:[settant];[];[];[ends-a];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a];[];[];[];[];[false];[];[]", "90/10/2:[novanta];[];[];[];[];[];[];[];[false];[];[novanta]", "91/10/2:[novant];[];[];[ends-a];[];[];[];[];[false];[];[]", "100/100/3:[cento];[];[];[];[];[];[];[];[false];[];[cento]", "101/100/3:[cent];[];[];[ends-o];[];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[decimal];[cent];[ends-o];[];[];[];[o];[true];[];[]", "1000/1000/4:[mille];[];[];[];[];[];[];[];[false];[];[mille]", "1001/1000/4:[mille];[];[];[decimal];[];[];[];[];[false];[];[]", "2000/1000/4:[];[continue];[mila];[];[];[];[];[];[false];[];[]", "2001/1000/4:[];[continue];[mila];[decimal];[];[];[];[];[true];[];[]", "100000/1000/4:[];[continue];[mila];[decimal];[];[];[];[];[true];[];[]", "1000000/1000000/7:[un milione];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[decimal];[ milioni];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[un miliardo];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[decimal];[ miliardi];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[ (incomplete data)];[]"};
        it_Def.put("decimal", stringArray9);
        stringArray10 = new String[]{"0/1/1:[izero];[];[];[];[];[];[];[];[false];[];[izero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[idue];[];[];[];[];[];[];[];[false];[];[idue]", "3/1/1:[itr\u00e9];[];[];[];[];[];[];[];[false];[];[itr\u00e9]", "4/1/1:[iquattro];[];[];[];[];[];[];[];[false];[];[iquattro]", "5/1/1:[icinque];[];[];[];[];[];[];[];[false];[];[icinque]", "6/1/1:[isei];[];[];[];[];[];[];[];[false];[];[isei]", "7/1/1:[isette];[];[];[];[];[];[];[];[false];[];[isette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[inove];[];[];[];[];[];[];[];[false];[];[inove]", "10/10/2:[idieci];[];[];[];[];[];[];[];[false];[];[idieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[idodici];[];[];[];[];[];[];[];[false];[];[idodici]", "13/10/2:[itredici];[];[];[];[];[];[];[];[false];[];[itredici]", "14/10/2:[iquattordici];[];[];[];[];[];[];[];[false];[];[iquattordici]", "15/10/2:[iquindici];[];[];[];[];[];[];[];[false];[];[iquindici]", "16/10/2:[isedici];[];[];[];[];[];[];[];[false];[];[isedici]", "17/10/2:[idiciasette];[];[];[];[];[];[];[];[false];[];[idiciasette]", "18/10/2:[idiciotto];[];[];[];[];[];[];[];[false];[];[idiciotto]", "19/10/2:[idiciannove];[];[];[];[];[];[];[];[false];[];[idiciannove]", "20/10/2:[iventi];[];[];[];[];[];[];[];[false];[];[iventi]", "21/10/2:[ivent];[];[];[ends-i];[];[];[];[];[false];[];[]", "30/10/2:[itrenta];[];[];[];[];[];[];[];[false];[];[itrenta]", "31/10/2:[itrent];[];[];[ends-a];[];[];[];[];[false];[];[]", "40/10/2:[iquaranta];[];[];[];[];[];[];[];[false];[];[iquaranta]", "41/10/2:[iquarant];[];[];[ends-a];[];[];[];[];[false];[];[]", "50/10/2:[icinquanta];[];[];[];[];[];[];[];[false];[];[icinquanta]", "51/10/2:[icinquant];[];[];[ends-a];[];[];[];[];[false];[];[]", "60/10/2:[isessanta];[];[];[];[];[];[];[];[false];[];[isessanta]", "61/10/2:[isessant];[];[];[ends-a];[];[];[];[];[false];[];[]", "70/10/2:[isettanta];[];[];[];[];[];[];[];[false];[];[isettanta]", "71/10/2:[isettant];[];[];[ends-a];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a];[];[];[];[];[false];[];[]", "90/10/2:[inovanta];[];[];[];[];[];[];[];[false];[];[inovanta]", "91/10/2:[inovant];[];[];[ends-a];[];[];[];[];[false];[];[]", "100/100/3:[icento];[];[];[];[];[];[];[];[false];[];[icento]", "101/100/3:[icent];[];[];[ends-o];[];[];[];[];[true];[];[]", "200/100/3:[];[ends-i];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[ends-i];[cent];[ends-o];[];[];[];[o];[true];[];[]", "1000/1000/4:[imille];[];[];[];[];[];[];[];[false];[];[imille]", "1001/1000/4:[imill];[];[];[ends-i];[];[];[];[];[true];[];[]", "2000/1000/4:[];[ends-i];[mila];[];[];[];[];[];[false];[];[]", "2001/1000/4:[];[ends-i];[mil];[ends-a];[];[];[];[a];[true];[];[]", "100000/100000/6:[];[];[];[];[];[];[base];[];[false];[];[]"};
        it_Def.put("ends-i", stringArray10);
        stringArray11 = new String[]{"0/1/1:[izero];[];[];[];[];[];[];[];[false];[];[izero]", "1/1/1:[uno];[];[];[];[];[];[];[];[false];[];[uno]", "2/1/1:[idue];[];[];[];[];[];[];[];[false];[];[idue]", "3/1/1:[itre];[];[];[];[];[];[];[];[false];[];[itre]", "4/1/1:[iquattro];[];[];[];[];[];[];[];[false];[];[iquattro]", "5/1/1:[icinque];[];[];[];[];[];[];[];[false];[];[icinque]", "6/1/1:[isei];[];[];[];[];[];[];[];[false];[];[isei]", "7/1/1:[isette];[];[];[];[];[];[];[];[false];[];[isette]", "8/1/1:[otto];[];[];[];[];[];[];[];[false];[];[otto]", "9/1/1:[inove];[];[];[];[];[];[];[];[false];[];[inove]", "10/10/2:[idieci];[];[];[];[];[];[];[];[false];[];[idieci]", "11/10/2:[undici];[];[];[];[];[];[];[];[false];[];[undici]", "12/10/2:[idodici];[];[];[];[];[];[];[];[false];[];[idodici]", "13/10/2:[itredici];[];[];[];[];[];[];[];[false];[];[itredici]", "14/10/2:[iquattordici];[];[];[];[];[];[];[];[false];[];[iquattordici]", "15/10/2:[iquindici];[];[];[];[];[];[];[];[false];[];[iquindici]", "16/10/2:[isedici];[];[];[];[];[];[];[];[false];[];[isedici]", "17/10/2:[idiciasette];[];[];[];[];[];[];[];[false];[];[idiciasette]", "18/10/2:[idiciotto];[];[];[];[];[];[];[];[false];[];[idiciotto]", "19/10/2:[idiciannove];[];[];[];[];[];[];[];[false];[];[idiciannove]", "20/10/2:[iventi];[];[];[];[];[];[];[];[false];[];[iventi]", "21/10/2:[ivent];[];[];[ends-i-continue];[];[];[];[];[false];[];[]", "30/10/2:[itrenta];[];[];[];[];[];[];[];[false];[];[itrenta]", "31/10/2:[itrent];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "40/10/2:[iquaranta];[];[];[];[];[];[];[];[false];[];[iquaranta]", "41/10/2:[iquarant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "50/10/2:[icinquanta];[];[];[];[];[];[];[];[false];[];[icinquanta]", "51/10/2:[icinquant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "60/10/2:[isessanta];[];[];[];[];[];[];[];[false];[];[isessanta]", "61/10/2:[isessant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "70/10/2:[isettanta];[];[];[];[];[];[];[];[false];[];[isettanta]", "71/10/2:[isettant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "80/10/2:[ottanta];[];[];[];[];[];[];[];[false];[];[ottanta]", "81/10/2:[ottant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "90/10/2:[inovanta];[];[];[];[];[];[];[];[false];[];[inovanta]", "91/10/2:[inovant];[];[];[ends-a-continue];[];[];[];[];[false];[];[]", "100/100/3:[icento];[];[];[];[];[];[];[];[false];[];[icento]", "101/100/3:[icent];[];[];[ends-o-continue];[];[];[];[];[true];[];[]", "200/100/3:[];[ends-i-continue];[cento];[];[];[];[];[];[false];[];[]", "201/100/3:[];[ends-i-continue];[cent];[ends-o-continue];[];[];[];[o];[true];[];[]", "1000/1000/4:[];[];[];[];[];[];[base];[];[false];[];[]"};
        it_Def.put("ends-i-continue", stringArray11);
        m_RuleDefinition.put(new Locale("it", ""), it_Def);
        iw_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[\u05d5\u05d0\u05d7\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05d7\u05ea]", "2/1/1:[\u05d5\u05e9\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05ea\u05d9\u05d9\u05dd]", "3/1/1:[\u05d5\u05e9\u05dc\u05d5\u05e9];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9]", "4/1/1:[\u05d5\u05d0\u05e8\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2]", "5/1/1:[\u05d5\u05d7\u05de\u05e9];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05e9]", "6/1/1:[\u05d5\u05e9\u05e9];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05e9]", "7/1/1:[\u05d5\u05e9\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2]", "8/1/1:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4]", "9/1/1:[\u05d5\u05ea\u05e9\u05e2];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2]", "10/10/2:[\u05d5\u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e2\u05e9\u05e8]", "11/10/2:[\u05d5\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4]", "12/10/2:[\u05d5\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4]", "13/10/2:[\u05d5\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4]", "14/10/2:[\u05d5\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "15/10/2:[\u05d5\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4]", "16/10/2:[\u05d5\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4]", "17/10/2:[\u05d5\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "18/10/2:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4]", "19/10/2:[\u05d5\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4]", "20/10/2:[\u05d5\u05e2\u05e9\u05e8\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e2\u05e9\u05e8\u05d9\u05dd]", "21/10/2:[\u05e2\u05e9\u05e8\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "30/10/2:[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd]", "31/10/2:[\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "40/10/2:[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd]", "41/10/2:[\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "50/10/2:[\u05d5\u05d7\u05de\u05d9\u05e9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05d9\u05e9\u05d9\u05dd]", "51/10/2:[\u05d7\u05de\u05d9\u05e9\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "60/10/2:[\u05d5\u05e9\u05d9\u05e9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d9\u05e9\u05d9\u05dd]", "61/10/2:[\u05e9\u05d9\u05e9\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "70/10/2:[\u05d5\u05e9\u05d1\u05e2\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2\u05d9\u05dd]", "71/10/2:[\u05e9\u05d1\u05e2\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "80/10/2:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d9\u05dd]", "81/10/2:[\u05e9\u05de\u05d5\u05e0\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "90/10/2:[\u05d5\u05ea\u05e9\u05e2\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2\u05d9\u05dd]", "91/10/2:[\u05ea\u05e9\u05e2\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "100/100/3:[\u05d5\u05de\u05d0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05de\u05d0\u05d4]", "101/100/3:[\u05de\u05d0\u05d4 ];[];[];[female-mod];[];[];[];[];[false];[];[]", "200/100/3:[\u05d5\u05de\u05d0\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05de\u05d0\u05ea\u05d9\u05d9\u05dd]", "201/100/3:[\u05de\u05d0\u05ea\u05d9\u05d9\u05dd ];[];[];[female-mod];[];[];[];[];[false];[];[]", "300/100/3:[\u05d5\u05e9\u05dc\u05d5\u05e9 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9 \u05de\u05d0\u05d5\u05ea]", "301/100/3:[\u05e9\u05dc\u05d5\u05e9 \u05de\u05d0\u05d5\u05ea ];[];[];[female-mod];[];[];[];[];[false];[];[]", "400/100/3:[\u05d5\u05d0\u05e8\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea]", "401/100/3:[\u05d0\u05e8\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea ];[];[];[female-mod];[];[];[];[];[false];[];[]", "500/100/3:[\u05d5\u05d7\u05de\u05e9 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05e9 \u05de\u05d0\u05d5\u05ea]", "501/100/3:[\u05d7\u05de\u05e9 \u05de\u05d0\u05d5\u05ea ];[];[];[female-mod];[];[];[];[];[false];[];[]", "600/100/3:[\u05d5\u05e9\u05e9 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05e9 \u05de\u05d0\u05d5\u05ea]", "601/100/3:[\u05e9\u05e9 \u05de\u05d0\u05d5\u05ea ];[];[];[female-mod];[];[];[];[];[false];[];[]", "700/100/3:[\u05d5\u05e9\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea]", "701/100/3:[\u05e9\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea ];[];[];[female-mod];[];[];[];[];[false];[];[]", "800/100/3:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05de\u05d0\u05d5\u05ea]", "801/100/3:[\u05e9\u05de\u05d5\u05e0\u05d4 \u05de\u05d0\u05d5\u05ea ];[];[];[female-mod];[];[];[];[];[false];[];[]", "900/100/3:[\u05d5\u05ea\u05e9\u05e2 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2 \u05de\u05d0\u05d5\u05ea]", "901/100/3:[\u05ea\u05e9\u05e2 \u05de\u05d0\u05d5\u05ea ];[];[];[female-mod];[];[];[];[];[false];[];[]", "1000/1000/4:[\u05d5\u05d0\u05dc\u05e3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000/1000/4:[\u05d5\u05d0\u05dc\u05e4\u05d9\u05d9\u05dd];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000/1000/4:[];[thousands_mod];[ \u05d0\u05dc\u05e4\u05d9\u05dd];[female-mod];[ ];[];[];[];[true];[];[]", "11000/1000/5:[];[male-mod];[ \u05d0\u05dc\u05e3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u05d5\u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[\u05d5\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000/1000000/7:[];[male-mod];[ \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u05d5\u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[\u05d5\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000/1000000000/10:[];[male-mod];[ \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u05d5\u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[\u05d5\u05e9\u05e0\u05d9 \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000000/1000000000000/13:[];[male-mod];[ \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,###.##];[];[false];[];[]"};
        iw_Def.put("female-mod", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u05d0\u05e4\u05e1];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e4\u05e1]", "1/1/1:[\u05d0\u05d7\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05ea]", "2/1/1:[\u05e9\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05e9\u05ea\u05d9\u05d9\u05dd]", "3/1/1:[\u05e9\u05dc\u05d5\u05e9];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9]", "4/1/1:[\u05d0\u05e8\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2]", "5/1/1:[\u05d7\u05de\u05e9];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05e9]", "6/1/1:[\u05e9\u05e9];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e9]", "7/1/1:[\u05e9\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2]", "8/1/1:[\u05e9\u05de\u05d5\u05e0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4]", "9/1/1:[\u05ea\u05e9\u05e2];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2]", "10/10/2:[\u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e2\u05e9\u05e8]", "11/10/2:[\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4]", "12/10/2:[\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4]", "13/10/2:[\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4]", "14/10/2:[\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "15/10/2:[\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4]", "16/10/2:[\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4]", "17/10/2:[\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "18/10/2:[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4]", "19/10/2:[\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4]", "20/10/2:[\u05e2\u05e9\u05e8\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "30/10/2:[\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "40/10/2:[\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "50/10/2:[\u05d7\u05de\u05d9\u05e9\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "60/10/2:[\u05e9\u05d9\u05e9\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "70/10/2:[\u05e9\u05d1\u05e2\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "80/10/2:[\u05e9\u05de\u05d5\u05e0\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "90/10/2:[\u05ea\u05e9\u05e2\u05d9\u05dd];[];[];[female-base];[ \u05d5];[];[];[];[true];[];[]", "100/100/3:[\u05de\u05d0\u05d4];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "200/100/3:[\u05de\u05d0\u05ea\u05d9\u05d9\u05dd];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "300/100/3:[];[female-base];[ \u05de\u05d0\u05d5\u05ea];[female-mod];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u05d0\u05dc\u05e3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000/1000/4:[\u05d0\u05dc\u05e4\u05d9\u05d9\u05dd];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000/1000/4:[];[thousands];[ \u05d0\u05dc\u05e4\u05d9\u05dd];[female-mod];[ ];[];[];[];[true];[];[]", "11000/1000/5:[];[male-base];[ \u05d0\u05dc\u05e3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000/1000000/7:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000/1000000000/10:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[\u05e9\u05e0\u05d9 \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000000/1000000000000/13:[];[male-base];[ \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,###.##];[];[false];[];[]"};
        iw_Def.put("female-base", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u05d0\u05e4\u05e1];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e4\u05e1]", "1/1/1:[\u05d0\u05d7\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05ea]", "2/1/1:[\u05e9\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05e9\u05ea\u05d9\u05d9\u05dd]", "3/1/1:[\u05e9\u05dc\u05d5\u05e9];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9]", "4/1/1:[\u05d0\u05e8\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2]", "5/1/1:[\u05d7\u05de\u05e9];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05e9]", "6/1/1:[\u05e9\u05e9];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e9]", "7/1/1:[\u05e9\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2]", "8/1/1:[\u05e9\u05de\u05d5\u05e0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4]", "9/1/1:[\u05ea\u05e9\u05e2];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2]", "10/10/2:[\u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e2\u05e9\u05e8]", "11/10/2:[\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4]", "12/10/2:[\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4]", "13/10/2:[\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4]", "14/10/2:[\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "15/10/2:[\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4]", "16/10/2:[\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4]", "17/10/2:[\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "18/10/2:[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4]", "19/10/2:[\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4]", "20/10/2:[\u05e2\u05e9\u05e8\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "30/10/2:[\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "40/10/2:[\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "50/10/2:[\u05d7\u05de\u05d9\u05e9\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "60/10/2:[\u05e9\u05d9\u05e9\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "70/10/2:[\u05e9\u05d1\u05e2\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "80/10/2:[\u05e9\u05de\u05d5\u05e0\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "90/10/2:[\u05ea\u05e9\u05e2\u05d9\u05dd];[];[];[default];[ \u05d5];[];[];[];[true];[];[]", "100/100/3:[\u05de\u05d0\u05d4];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "200/100/3:[\u05de\u05d0\u05ea\u05d9\u05d9\u05dd];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "300/100/3:[];[default];[ \u05de\u05d0\u05d5\u05ea];[female-mod];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u05d0\u05dc\u05e3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000/1000/4:[\u05d0\u05dc\u05e4\u05d9\u05d9\u05dd];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000/1000/4:[];[thousands];[ \u05d0\u05dc\u05e4\u05d9\u05dd];[female-mod];[ ];[];[];[];[true];[];[]", "11000/1000/5:[];[male-base];[ \u05d0\u05dc\u05e3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000/1000000/7:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000/1000000000/10:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[\u05e9\u05e0\u05d9 \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000000/1000000000000/13:[];[male-base];[ \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,###.##];[];[false];[];[]"};
        iw_Def.put("default", stringArray3);
        stringArray4 = new String[]{"0/1/1:[\u05d0\u05e4\u05e1];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e4\u05e1]", "1/1/1:[\u05d0\u05d7\u05d3];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05d3]", "2/1/1:[\u05e9\u05e0\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e0\u05d9\u05d9\u05dd]", "3/1/1:[\u05e9\u05dc\u05d5\u05e9\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9\u05d4]", "4/1/1:[\u05d0\u05e8\u05d1\u05e2\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2\u05d4]", "5/1/1:[\u05d7\u05de\u05d9\u05e9\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05d9\u05e9\u05d4]", "6/1/1:[\u05e9\u05d9\u05e9\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d9\u05e9\u05d4]", "7/1/1:[\u05e9\u05d1\u05e2\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2\u05d4]", "8/1/1:[\u05e9\u05de\u05d5\u05e0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4]", "9/1/1:[\u05ea\u05e9\u05e2\u05d4];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2\u05d4]", "10/10/2:[\u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e2\u05e9\u05e8\u05d4]", "11/10/2:[\u05d0\u05d7\u05d3 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05d3 \u05e2\u05e9\u05e8]", "12/10/2:[\u05e9\u05e0\u05d9\u05dd \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e0\u05d9\u05dd \u05e2\u05e9\u05e8]", "13/10/2:[\u05e9\u05dc\u05d5\u05e9\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9\u05d4 \u05e2\u05e9\u05e8]", "14/10/2:[\u05d0\u05e8\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8]", "15/10/2:[\u05d7\u05de\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8]", "16/10/2:[\u05e9\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8]", "17/10/2:[\u05e9\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8]", "18/10/2:[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8]", "19/10/2:[\u05ea\u05e9\u05e2\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2\u05d4 \u05e2\u05e9\u05e8]", "20/10/2:[\u05e2\u05e9\u05e8\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "30/10/2:[\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "40/10/2:[\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "50/10/2:[\u05d7\u05de\u05d9\u05e9\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "60/10/2:[\u05e9\u05d9\u05e9\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "70/10/2:[\u05e9\u05d1\u05e2\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "80/10/2:[\u05e9\u05de\u05d5\u05e0\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "90/10/2:[\u05ea\u05e9\u05e2\u05d9\u05dd];[];[];[male-base];[ \u05d5];[];[];[];[true];[];[]", "100/100/3:[\u05de\u05d0\u05d4];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "200/100/3:[\u05de\u05d0\u05ea\u05d9\u05d9\u05dd];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "300/100/3:[];[female-base];[ \u05de\u05d0\u05d5\u05ea];[male-mod];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u05d0\u05dc\u05e3];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000/1000/4:[\u05d0\u05dc\u05e4\u05d9\u05d9\u05dd];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000/1000/4:[];[thousands];[ \u05d0\u05dc\u05e4\u05d9\u05dd];[male-mod];[ ];[];[];[];[true];[];[]", "11000/1000/5:[];[male-base];[ \u05d0\u05dc\u05e3];[male-mod];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000000/1000000/7:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[male-mod];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000000000/1000000000/10:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[male-mod];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[\u05e9\u05e0\u05d9 \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000000000000/1000000000000/13:[];[male-base];[ \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[male-mod];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,###.##];[];[false];[];[]"};
        iw_Def.put("male-base", stringArray4);
        stringArray5 = new String[]{"0/1/1:[\u05d0\u05e4\u05e1];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e4\u05e1]", "1/1/1:[\u05d0\u05d7\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05ea]", "2/1/1:[\u05e9\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05e9\u05ea\u05d9\u05d9\u05dd]", "3/1/1:[\u05e9\u05dc\u05d5\u05e9\u05ea];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9\u05ea]", "4/1/1:[\u05d0\u05e8\u05d1\u05e2\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2\u05ea]", "5/1/1:[\u05d7\u05de\u05e9\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05e9\u05ea]", "6/1/1:[\u05e9\u05e9\u05ea];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e9\u05ea]", "7/1/1:[\u05e9\u05d1\u05e2\u05ea];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2\u05ea]", "8/1/1:[\u05e9\u05de\u05d5\u05e0\u05ea];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05ea]", "9/1/1:[\u05ea\u05e9\u05e2\u05ea];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2\u05ea]", "10/10/2:[\u05e2\u05e9\u05e8\u05ea];[];[];[];[];[];[];[];[false];[];[\u05e2\u05e9\u05e8\u05ea]", "11/10/2:[];[];[];[];[];[];[male-base];[];[false];[];[]"};
        iw_Def.put("thousands", stringArray5);
        stringArray6 = new String[]{"0/1/1:[\u05de\u05d9\u05e0\u05d5\u05e1 ];[];[];[];[];[];[default];[];[false];[];[]"};
        iw_Def.put("minus", stringArray6);
        stringArray7 = new String[]{"0/1/1:[\u05d5\u05d0\u05e4\u05e1];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e4\u05e1]", "1/1/1:[\u05d5\u05d0\u05d7\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05d7\u05ea]", "2/1/1:[\u05d5\u05e9\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05ea\u05d9\u05d9\u05dd]", "3/1/1:[\u05d5\u05e9\u05dc\u05d5\u05e9\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9\u05ea]", "4/1/1:[\u05d5\u05d0\u05e8\u05d1\u05e2\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2\u05ea]", "5/1/1:[\u05d5\u05d7\u05de\u05e9\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05e9\u05ea]", "6/1/1:[\u05d5\u05e9\u05e9\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05e9\u05ea]", "7/1/1:[\u05d5\u05e9\u05d1\u05e2\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2\u05ea]", "8/1/1:[\u05d5\u05e9\u05de\u05d5\u05e0\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05ea]", "9/1/1:[\u05d5\u05ea\u05e9\u05e2\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2\u05ea]", "10/10/2:[\u05d5\u05e2\u05e9\u05e8\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e2\u05e9\u05e8\u05ea]", "11/10/2:[];[];[];[];[];[];[male-mod];[];[false];[];[]"};
        iw_Def.put("thousands_mod", stringArray7);
        stringArray8 = new String[]{"0/1/1:[\u05d0\u05e4\u05e1];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e4\u05e1]", "1/1/1:[\u05d0\u05d7\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05ea]", "2/1/1:[\u05e9\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05e9\u05ea\u05d9\u05d9\u05dd]", "3/1/1:[\u05e9\u05dc\u05d5\u05e9];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9]", "4/1/1:[\u05d0\u05e8\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2]", "5/1/1:[\u05d7\u05de\u05e9];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05e9]", "6/1/1:[\u05e9\u05e9];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e9]", "7/1/1:[\u05e9\u05d1\u05e2];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2]", "8/1/1:[\u05e9\u05de\u05d5\u05e0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4]", "9/1/1:[\u05ea\u05e9\u05e2];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2]", "10/10/2:[\u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05e2\u05e9\u05e8]", "11/10/2:[\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d0\u05d7\u05ea \u05e2\u05e9\u05e8\u05d4]", "12/10/2:[\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05ea\u05d9\u05dd \u05e2\u05e9\u05e8\u05d4]", "13/10/2:[\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05dc\u05d5\u05e9 \u05e2\u05e9\u05e8\u05d4]", "14/10/2:[\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d0\u05e8\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "15/10/2:[\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d7\u05de\u05e9 \u05e2\u05e9\u05e8\u05d4]", "16/10/2:[\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05e9 \u05e2\u05e9\u05e8\u05d4]", "17/10/2:[\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05d1\u05e2 \u05e2\u05e9\u05e8\u05d4]", "18/10/2:[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8\u05d4]", "19/10/2:[\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05ea\u05e9\u05e2 \u05e2\u05e9\u05e8\u05d4]", "20/10/2:[\u05e2\u05e9\u05e8\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "30/10/2:[\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "40/10/2:[\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "50/10/2:[\u05d7\u05de\u05d9\u05e9\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "60/10/2:[\u05e9\u05d9\u05e9\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "70/10/2:[\u05e9\u05d1\u05e2\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "80/10/2:[\u05e9\u05de\u05d5\u05e0\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "90/10/2:[\u05ea\u05e9\u05e2\u05d9\u05dd];[];[];[decimal];[ \u05d5];[];[];[];[true];[];[]", "100/100/3:[\u05de\u05d0\u05d4];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "200/100/3:[\u05de\u05d0\u05ea\u05d9\u05d9\u05dd];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "300/100/3:[];[decimal];[ \u05de\u05d0\u05d5\u05ea];[female-mod];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u05d0\u05dc\u05e3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000/1000/4:[\u05d0\u05dc\u05e4\u05d9\u05d9\u05dd];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000/1000/4:[];[thousands];[ \u05d0\u05dc\u05e4\u05d9\u05dd];[female-mod];[ ];[];[];[];[true];[];[]", "11000/1000/5:[];[male-base];[ \u05d0\u05dc\u05e3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000/1000000/7:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000/1000000000/10:[];[male-base];[ \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[\u05e9\u05e0\u05d9 \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[female-mod];[ ];[];[];[];[true];[];[]", "3000000000000/1000000000000/13:[];[male-base];[ \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[female-mod];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,###.##];[];[false];[];[]"};
        iw_Def.put("decimal", stringArray8);
        stringArray9 = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[\u05d5\u05d0\u05d7\u05d3];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05d7\u05d3]", "2/1/1:[\u05d5\u05e9\u05e0\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05e0\u05d9\u05d9\u05dd]", "3/1/1:[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d4]", "4/1/1:[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d4]", "5/1/1:[\u05d5\u05d7\u05de\u05d9\u05e9\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05d9\u05e9\u05d4]", "6/1/1:[\u05d5\u05e9\u05d9\u05e9\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d9\u05e9\u05d4]", "7/1/1:[\u05d5\u05e9\u05d1\u05e2\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2\u05d4]", "8/1/1:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4]", "9/1/1:[\u05d5\u05ea\u05e9\u05e2\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2\u05d4]", "10/10/2:[\u05d5\u05e2\u05e9\u05e8\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e2\u05e9\u05e8\u05d4]", "11/10/2:[\u05d5\u05d0\u05d7\u05d3 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05d7\u05d3 \u05e2\u05e9\u05e8]", "12/10/2:[\u05d5\u05e9\u05e0\u05d9\u05dd \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05e0\u05d9\u05dd \u05e2\u05e9\u05e8]", "13/10/2:[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d4 \u05e2\u05e9\u05e8]", "14/10/2:[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8]", "15/10/2:[\u05d5\u05d7\u05de\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8]", "16/10/2:[\u05d5\u05e9\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d9\u05e9\u05d4 \u05e2\u05e9\u05e8]", "17/10/2:[\u05d5\u05e9\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2\u05d4 \u05e2\u05e9\u05e8]", "18/10/2:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05e2\u05e9\u05e8]", "19/10/2:[\u05d5\u05ea\u05e9\u05e2\u05d4 \u05e2\u05e9\u05e8];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2\u05d4 \u05e2\u05e9\u05e8]", "20/10/2:[\u05d5\u05e2\u05e9\u05e8\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e2\u05e9\u05e8\u05d9\u05dd]", "21/10/2:[\u05e2\u05e9\u05e8\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "30/10/2:[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd]", "31/10/2:[\u05e9\u05dc\u05d5\u05e9\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "40/10/2:[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd]", "41/10/2:[\u05d0\u05e8\u05d1\u05e2\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "50/10/2:[\u05d5\u05d7\u05de\u05d9\u05e9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05d9\u05e9\u05d9\u05dd]", "51/10/2:[\u05d7\u05de\u05d9\u05e9\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "60/10/2:[\u05d5\u05e9\u05d9\u05e9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d9\u05e9\u05d9\u05dd]", "61/10/2:[\u05e9\u05d9\u05e9\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "70/10/2:[\u05d5\u05e9\u05d1\u05e2\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2\u05d9\u05dd]", "71/10/2:[\u05e9\u05d1\u05e2\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "80/10/2:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d9\u05dd]", "81/10/2:[\u05e9\u05de\u05d5\u05e0\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "90/10/2:[\u05d5\u05ea\u05e9\u05e2\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2\u05d9\u05dd]", "91/10/2:[\u05ea\u05e9\u05e2\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "100/100/3:[\u05d5\u05de\u05d0\u05d4];[];[];[];[];[];[];[];[false];[];[\u05d5\u05de\u05d0\u05d4]", "101/100/3:[\u05de\u05d0\u05d4 ];[];[];[male-mod];[];[];[];[];[false];[];[]", "200/100/3:[\u05d5\u05de\u05d0\u05ea\u05d9\u05d9\u05dd];[];[];[];[];[];[];[];[false];[];[\u05d5\u05de\u05d0\u05ea\u05d9\u05d9\u05dd]", "201/100/3:[\u05de\u05d0\u05ea\u05d9\u05d9\u05dd ];[];[];[male-mod];[];[];[];[];[false];[];[]", "300/100/3:[\u05d5\u05e9\u05dc\u05d5\u05e9 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05dc\u05d5\u05e9 \u05de\u05d0\u05d5\u05ea]", "301/100/3:[\u05e9\u05dc\u05d5\u05e9 \u05de\u05d0\u05d5\u05ea ];[];[];[male-mod];[];[];[];[];[false];[];[]", "400/100/3:[\u05d5\u05d0\u05e8\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d0\u05e8\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea]", "401/100/3:[\u05d0\u05e8\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea ];[];[];[male-mod];[];[];[];[];[false];[];[]", "500/100/3:[\u05d5\u05d7\u05de\u05e9 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05d7\u05de\u05e9 \u05de\u05d0\u05d5\u05ea]", "501/100/3:[\u05d7\u05de\u05e9 \u05de\u05d0\u05d5\u05ea ];[];[];[male-mod];[];[];[];[];[false];[];[]", "600/100/3:[\u05d5\u05e9\u05e9 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05e9 \u05de\u05d0\u05d5\u05ea]", "601/100/3:[\u05e9\u05e9 \u05de\u05d0\u05d5\u05ea ];[];[];[male-mod];[];[];[];[];[false];[];[]", "700/100/3:[\u05d5\u05e9\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea]", "701/100/3:[\u05e9\u05d1\u05e2 \u05de\u05d0\u05d5\u05ea ];[];[];[male-mod];[];[];[];[];[false];[];[]", "800/100/3:[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05e9\u05de\u05d5\u05e0\u05d4 \u05de\u05d0\u05d5\u05ea]", "801/100/3:[\u05e9\u05de\u05d5\u05e0\u05d4 \u05de\u05d0\u05d5\u05ea ];[];[];[male-mod];[];[];[];[];[false];[];[]", "900/100/3:[\u05d5\u05ea\u05e9\u05e2 \u05de\u05d0\u05d5\u05ea];[];[];[];[];[];[];[];[false];[];[\u05d5\u05ea\u05e9\u05e2 \u05de\u05d0\u05d5\u05ea]", "901/100/3:[\u05ea\u05e9\u05e2 \u05de\u05d0\u05d5\u05ea ];[];[];[male-mod];[];[];[];[];[false];[];[]", "1000/1000/4:[\u05d5\u05d0\u05dc\u05e3];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000/1000/4:[\u05d5\u05d0\u05dc\u05e4\u05d9\u05d9\u05dd];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000/1000/4:[];[thousands_mod];[ \u05d0\u05dc\u05e4\u05d9\u05dd];[male-mod];[ ];[];[];[];[true];[];[]", "11000/1000/5:[];[male-mod];[ \u05d0\u05dc\u05e3];[male-mod];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u05d5\u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[\u05d5\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000000/1000000/7:[];[male-mod];[ \u05de\u05d9\u05dc\u05d9\u05d5\u05df];[male-mod];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u05d5\u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[\u05d5\u05e9\u05e0\u05d9 \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000000000/1000000000/10:[];[male-mod];[ \u05de\u05d9\u05dc\u05d9\u05e8\u05d3];[male-mod];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u05d5\u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[\u05d5\u05e9\u05e0\u05d9 \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[];[];[male-mod];[ ];[];[];[];[true];[];[]", "3000000000000/1000000000000/13:[];[male-mod];[ \u05d8\u05e8\u05d9\u05dc\u05d9\u05d5\u05df];[male-mod];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,###.##];[];[false];[];[]"};
        iw_Def.put("male-mod", stringArray9);
        m_RuleDefinition.put(new Locale("iw", ""), iw_Def);
        ja_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u96f6];[];[];[];[];[];[];[];[false];[];[\u96f6]", "1/1/1:[\u58f1];[];[];[];[];[];[];[];[false];[];[\u58f1]", "2/1/1:[\u5f10];[];[];[];[];[];[];[];[false];[];[\u5f10]", "3/1/1:[\u53c2];[];[];[];[];[];[];[];[false];[];[\u53c2]", "4/1/1:[\u56db];[];[];[];[];[];[];[];[false];[];[\u56db]", "5/1/1:[\u4e94];[];[];[];[];[];[];[];[false];[];[\u4e94]", "6/1/1:[\u516d];[];[];[];[];[];[];[];[false];[];[\u516d]", "7/1/1:[\u4e03];[];[];[];[];[];[];[];[false];[];[\u4e03]", "8/1/1:[\u516b];[];[];[];[];[];[];[];[false];[];[\u516b]", "9/1/1:[\u4e5d];[];[];[];[];[];[];[];[false];[];[\u4e5d]", "10/10/2:[\u62fe];[];[];[default];[];[];[];[];[true];[];[]", "20/10/2:[];[default];[\u62fe];[default];[];[];[];[];[true];[];[]", "100/100/3:[];[default];[\u767e];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[\u5343];[default];[];[];[];[];[true];[];[]", "10000/10000/5:[];[default];[\u4e07];[default];[];[];[];[];[true];[];[]", "100000000/100000000/9:[];[default];[\u5104];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[\u5146];[default];[];[];[];[];[true];[];[]", "10000000000000000/10000000000000000/17:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ja_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u25b3];[];[];[];[];[];[default];[];[false];[];[]"};
        ja_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[];[];[];[];[];[];[];[];[false];[];[]", "1/1/1:[];[];[];[];[];[];[default];[];[false];[\u92ad];[]", "100/100/3:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ja_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("ja", ""), ja_Def);
        ko_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\uc601];[];[];[];[];[];[];[];[false];[];[\uc601]", "1/1/1:[\uc77c];[];[];[];[];[];[];[];[false];[];[\uc77c]", "2/1/1:[\uc774];[];[];[];[];[];[];[];[false];[];[\uc774]", "3/1/1:[\uc0bc];[];[];[];[];[];[];[];[false];[];[\uc0bc]", "4/1/1:[\uc0ac];[];[];[];[];[];[];[];[false];[];[\uc0ac]", "5/1/1:[\uc624];[];[];[];[];[];[];[];[false];[];[\uc624]", "6/1/1:[\uc721];[];[];[];[];[];[];[];[false];[];[\uc721]", "7/1/1:[\uce60];[];[];[];[];[];[];[];[false];[];[\uce60]", "8/1/1:[\ud314];[];[];[];[];[];[];[];[false];[];[\ud314]", "9/1/1:[\uad6c];[];[];[];[];[];[];[];[false];[];[\uad6c]", "10/10/2:[\uc2ed];[];[];[default];[];[];[];[];[true];[];[]", "20/10/2:[];[default];[\uc2ed];[default];[];[];[];[];[true];[];[]", "100/100/3:[];[default];[\ubc31];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[\ucc9c];[default];[];[];[];[];[true];[];[]", "10000/10000/5:[];[default];[\ub9cc];[default];[];[];[];[];[true];[];[]", "100000000/100000000/9:[];[default];[\uc5b5];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ko_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\uff0d ];[];[];[];[];[];[default];[];[false];[];[]"};
        ko_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\uc601];[];[];[];[];[];[];[];[false];[];[\uc601]", "1/1/1:[\uc77c];[];[];[];[];[];[];[];[false];[];[\uc77c]", "2/1/1:[\uc774];[];[];[];[];[];[];[];[false];[];[\uc774]", "3/1/1:[\uc0bc];[];[];[];[];[];[];[];[false];[];[\uc0bc]", "4/1/1:[\uc0ac];[];[];[];[];[];[];[];[false];[];[\uc0ac]", "5/1/1:[\uc624];[];[];[];[];[];[];[];[false];[];[\uc624]", "6/1/1:[\uc721];[];[];[];[];[];[];[];[false];[];[\uc721]", "7/1/1:[\uce60];[];[];[];[];[];[];[];[false];[];[\uce60]", "8/1/1:[\ud314];[];[];[];[];[];[];[];[false];[];[\ud314]", "9/1/1:[\uad6c];[];[];[];[];[];[];[];[false];[];[\uad6c]", "10/10/2:[\uc2ed];[];[];[decimal];[];[];[];[];[true];[];[]", "20/10/2:[];[decimal];[\uc2ed];[decimal];[];[];[];[];[true];[];[]", "100/100/3:[];[decimal];[\ubc31];[decimal];[];[];[];[];[true];[];[]", "1000/1000/4:[];[decimal];[\ucc9c];[decimal];[];[];[];[];[true];[];[]", "10000/10000/5:[];[decimal];[\ub9cc];[decimal];[];[];[];[];[true];[];[]", "100000000/100000000/9:[];[decimal];[\uc5b5];[decimal];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ko_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("ko", ""), ko_Def);
        mt_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[];[];[];[];[];[];[base];[];[false];[];[]", "100/100/3:[mija];[];[];[and];[ ];[];[];[];[true];[];[]", "200/100/3:[mitejn];[];[];[and];[ ];[];[];[];[true];[];[]", "300/100/3:[tlett mija];[];[];[and];[ ];[];[];[];[true];[];[]", "400/100/3:[erbg\u0127a mija];[];[];[and];[ ];[];[];[];[true];[];[]", "500/100/3:[\u0127ames mija];[];[];[and];[ ];[];[];[];[true];[];[]", "600/100/3:[sitt mija];[];[];[and];[ ];[];[];[];[true];[];[]", "700/100/3:[sebg\u0127a mija];[];[];[and];[ ];[];[];[];[true];[];[]", "800/100/3:[tmin mija];[];[];[and];[ ];[];[];[];[true];[];[]", "900/100/3:[disg\u0127a mija];[];[];[and];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ elf];[and];[ ];[];[];[];[true];[];[]", "100000/1000/4:[];[default];[ thousand];[commas];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ million];[commas];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ billion];[commas];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ trillion];[commas];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        mt_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u017cero];[];[];[];[];[];[];[];[false];[];[\u017cero]", "1/1/1:[wie\u0127ed];[];[];[];[];[];[];[];[false];[];[wie\u0127ed]", "2/1/1:[tnejn];[];[];[];[];[];[];[];[false];[];[tnejn]", "3/1/1:[tlieta];[];[];[];[];[];[];[];[false];[];[tlieta]", "4/1/1:[erbg\u0127a];[];[];[];[];[];[];[];[false];[];[erbg\u0127a]", "5/1/1:[\u0127amsa];[];[];[];[];[];[];[];[false];[];[\u0127amsa]", "6/1/1:[sitta];[];[];[];[];[];[];[];[false];[];[sitta]", "7/1/1:[sebg\u0127a];[];[];[];[];[];[];[];[false];[];[sebg\u0127a]", "8/1/1:[tmienja];[];[];[];[];[];[];[];[false];[];[tmienja]", "9/1/1:[disg\u0127a];[];[];[];[];[];[];[];[false];[];[disg\u0127a]", "10/10/2:[g\u0127axra];[];[];[];[];[];[];[];[false];[];[g\u0127axra]", "11/10/2:[\u0127dax];[];[];[];[];[];[];[];[false];[];[\u0127dax]", "12/10/2:[tnax];[];[];[];[];[];[];[];[false];[];[tnax]", "13/10/2:[tlettax];[];[];[];[];[];[];[];[false];[];[tlettax]", "14/10/2:[erbatax];[];[];[];[];[];[];[];[false];[];[erbatax]", "15/10/2:[\u0127mistax];[];[];[];[];[];[];[];[false];[];[\u0127mistax]", "16/10/2:[sittax];[];[];[];[];[];[];[];[false];[];[sittax]", "17/10/2:[sbatax];[];[];[];[];[];[];[];[false];[];[sbatax]", "18/10/2:[tmintax];[];[];[];[];[];[];[];[false];[];[tmintax]", "19/10/2:[dsatax];[];[];[];[];[];[];[];[false];[];[dsatax]", "20/10/2:[];[];[];[base];[];[ u ];[];[];[true];[g\u0127oxrin];[]", "30/10/2:[];[];[];[base];[];[ u ];[];[];[true];[tletin];[]", "40/10/2:[];[];[];[base];[];[ u ];[];[];[true];[erbg\u0127in];[]", "50/10/2:[];[];[];[base];[];[ u ];[];[];[true];[\u0127amsin];[]", "60/10/2:[];[];[];[base];[];[ u ];[];[];[true];[sittin];[]", "70/10/2:[];[];[];[base];[];[ u ];[];[];[true];[sebg\u0127in];[]", "80/10/2:[];[];[];[base];[];[ u ];[];[];[true];[tmenin];[]", "90/10/2:[];[];[];[base];[];[ u ];[];[];[true];[disg\u0127in];[]", "100/100/3:[mija];[];[];[base];[ u ];[];[];[];[true];[];[]", "200/100/3:[mitejn];[];[];[base];[ u ];[];[];[];[true];[];[]", "1000/1000/4:[];[base];[ elf];[base];[ u ];[];[];[];[true];[];[]", "2000/1000/4:[];[base];[ elfejn];[base];[ u ];[];[];[];[true];[];[]", "3000/1000/4:[tliet elef ];[];[];[base];[ u ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[base];[ miljun];[base];[ u ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[base];[ biljun];[base];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[base];[ triljun];[base];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        mt_Def.put("base", stringArray2);
        stringArray3 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        mt_Def.put("minus", stringArray3);
        stringArray4 = new String[]{"0/1/1:[u ];[];[];[];[];[];[default];[];[false];[];[]", "100/100/3:[];[];[];[];[];[];[default];[];[false];[];[]"};
        mt_Def.put("and", stringArray4);
        stringArray5 = new String[]{"0/1/1:[ and ];[];[];[];[];[];[default];[];[false];[];[]", "100/100/3:[, ];[];[];[];[];[];[default];[];[false];[];[]", "1000/1000/4:[, ];[default];[ thousand, ];[default];[];[];[];[];[false];[];[]", "1000000/1000000/7:[, ];[];[];[];[];[];[default];[];[false];[];[]"};
        mt_Def.put("commas", stringArray5);
        stringArray6 = new String[]{"0/1/1:[];[];[];[];[];[];[base];[];[false];[];[]", "100/100/3:[mija];[];[];[and];[ ];[];[];[];[true];[];[]", "200/100/3:[mitejn];[];[];[and];[ ];[];[];[];[true];[];[]", "300/100/3:[tlett mija];[];[];[and];[ ];[];[];[];[true];[];[]", "400/100/3:[erbg\u0127a mija];[];[];[and];[ ];[];[];[];[true];[];[]", "500/100/3:[\u0127ames mija];[];[];[and];[ ];[];[];[];[true];[];[]", "600/100/3:[sitt mija];[];[];[and];[ ];[];[];[];[true];[];[]", "700/100/3:[sebg\u0127a mija];[];[];[and];[ ];[];[];[];[true];[];[]", "800/100/3:[tmin mija];[];[];[and];[ ];[];[];[];[true];[];[]", "900/100/3:[disg\u0127a mija];[];[];[and];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[decimal];[ elf];[and];[ ];[];[];[];[true];[];[]", "100000/1000/4:[];[decimal];[ thousand];[commas];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ million];[commas];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ billion];[commas];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ trillion];[commas];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        mt_Def.put("decimal", stringArray6);
        m_RuleDefinition.put(new Locale("mt", ""), mt_Def);
        nl_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nul];[];[];[];[];[];[];[];[false];[];[nul]", "1/1/1:[een];[];[];[];[];[];[];[];[false];[];[een]", "2/1/1:[twee];[];[];[];[];[];[];[];[false];[];[twee]", "3/1/1:[drie];[];[];[];[];[];[];[];[false];[];[drie]", "4/1/1:[vier];[];[];[];[];[];[];[];[false];[];[vier]", "5/1/1:[vijf];[];[];[];[];[];[];[];[false];[];[vijf]", "6/1/1:[zes];[];[];[];[];[];[];[];[false];[];[zes]", "7/1/1:[zeven];[];[];[];[];[];[];[];[false];[];[zeven]", "8/1/1:[acht];[];[];[];[];[];[];[];[false];[];[acht]", "9/1/1:[negen];[];[];[];[];[];[];[];[false];[];[negen]", "10/10/2:[tien];[];[];[];[];[];[];[];[false];[];[tien]", "11/10/2:[elf];[];[];[];[];[];[];[];[false];[];[elf]", "12/10/2:[twaalf];[];[];[];[];[];[];[];[false];[];[twaalf]", "13/10/2:[dertien];[];[];[];[];[];[];[];[false];[];[dertien]", "14/10/2:[veertien];[];[];[];[];[];[];[];[false];[];[veertien]", "15/10/2:[vijftien];[];[];[];[];[];[];[];[false];[];[vijftien]", "16/10/2:[zestien];[];[];[];[];[];[];[];[false];[];[zestien]", "17/10/2:[zeventien];[];[];[];[];[];[];[];[false];[];[zeventien]", "18/10/2:[achtien];[];[];[];[];[];[];[];[false];[];[achtien]", "19/10/2:[negentien];[];[];[];[];[];[];[];[false];[];[negentien]", "20/10/2:[];[];[];[default];[];[en];[];[];[true];[twintig];[]", "30/10/2:[];[];[];[default];[];[en];[];[];[true];[dertig];[]", "40/10/2:[];[];[];[default];[];[en];[];[];[true];[veertig];[]", "50/10/2:[];[];[];[default];[];[en];[];[];[true];[vijftig];[]", "60/10/2:[];[];[];[default];[];[en];[];[];[true];[zestig];[]", "70/10/2:[];[];[];[default];[];[en];[];[];[true];[zeventig];[]", "80/10/2:[];[];[];[default];[];[en];[];[];[true];[tachtig];[]", "90/10/2:[];[];[];[default];[];[en];[];[];[true];[negentig];[]", "100/100/3:[honderd];[];[];[default];[];[];[];[];[true];[];[]", "200/100/3:[];[default];[honderd];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[duizend];[];[];[default];[];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[duizend];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[miljoen];[];[];[default];[];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[miljoen];[default];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[miljard];[];[];[default];[];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[miljard];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[biljoen];[];[];[default];[];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[biljoen];[default];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        nl_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[min ];[];[];[];[];[];[default];[];[false];[];[]"};
        nl_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[];[];[];[];[nul];[];[];[];[false];[];[]", "1/1/1:[een];[];[];[];[];[];[];[];[false];[];[een]", "2/1/1:[twee];[];[];[];[];[];[];[];[false];[];[twee]", "3/1/1:[drie];[];[];[];[];[];[];[];[false];[];[drie]", "4/1/1:[vier];[];[];[];[];[];[];[];[false];[];[vier]", "5/1/1:[vijf];[];[];[];[];[];[];[];[false];[];[vijf]", "6/1/1:[zes];[];[];[];[];[];[];[];[false];[];[zes]", "7/1/1:[zeven];[];[];[];[];[];[];[];[false];[];[zeven]", "8/1/1:[acht];[];[];[];[];[];[];[];[false];[];[acht]", "9/1/1:[negen];[];[];[];[];[];[];[];[false];[];[negen]", "10/10/2:[tien];[];[];[];[];[];[];[];[false];[];[tien]", "11/10/2:[elf];[];[];[];[];[];[];[];[false];[];[elf]", "12/10/2:[twaalf];[];[];[];[];[];[];[];[false];[];[twaalf]", "13/10/2:[dertien];[];[];[];[];[];[];[];[false];[];[dertien]", "14/10/2:[veertien];[];[];[];[];[];[];[];[false];[];[veertien]", "15/10/2:[vijftien];[];[];[];[];[];[];[];[false];[];[vijftien]", "16/10/2:[zestien];[];[];[];[];[];[];[];[false];[];[zestien]", "17/10/2:[zeventien];[];[];[];[];[];[];[];[false];[];[zeventien]", "18/10/2:[achtien];[];[];[];[];[];[];[];[false];[];[achtien]", "19/10/2:[negentien];[];[];[];[];[];[];[];[false];[];[negentien]", "20/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[twintig];[]", "30/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[dertig];[]", "40/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[veertig];[]", "50/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[vijftig];[]", "60/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[zestig];[]", "70/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[zeventig];[]", "80/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[tachtig];[]", "90/10/2:[];[];[];[default];[];[\u00ebn];[];[];[true];[negentig];[]", "100/100/3:[];[default];[honderd];[decimal];[];[];[];[];[true];[];[]"};
        nl_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("nl", ""), nl_Def);
        pl_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[];[teens];[];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[];[hundreds];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[quadrillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        pl_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[jeden];[];[];[];[];[];[];[];[false];[];[jeden]", "2/1/1:[dwa];[];[];[];[];[];[];[];[false];[];[dwa]", "3/1/1:[trzy];[];[];[];[];[];[];[];[false];[];[trzy]", "4/1/1:[cztery];[];[];[];[];[];[];[];[false];[];[cztery]", "5/1/1:[pi\u0119\u0107];[];[];[];[];[];[];[];[false];[];[pi\u0119\u0107]", "6/1/1:[sze\u015b\u0107];[];[];[];[];[];[];[];[false];[];[sze\u015b\u0107]", "7/1/1:[siedem];[];[];[];[];[];[];[];[false];[];[siedem]", "8/1/1:[osiem];[];[];[];[];[];[];[];[false];[];[osiem]", "9/1/1:[dziewi\u0119\u0107];[];[];[];[];[];[];[];[false];[];[dziewi\u0119\u0107]", "10/10/2:[dziesi\u0119\u0107];[];[];[];[];[];[];[];[false];[];[dziesi\u0119\u0107]", "11/10/2:[jedena\u015bcie];[];[];[];[];[];[];[];[false];[];[jedena\u015bcie]", "12/10/2:[dwana\u015bcie];[];[];[];[];[];[];[];[false];[];[dwana\u015bcie]", "13/10/2:[trzyna\u015bcie];[];[];[];[];[];[];[];[false];[];[trzyna\u015bcie]", "14/10/2:[czterna\u015bcie];[];[];[];[];[];[];[];[false];[];[czterna\u015bcie]", "15/10/2:[pi\u0119tna\u015bcie];[];[];[];[];[];[];[];[false];[];[pi\u0119tna\u015bcie]", "16/10/2:[szesna\u015bcie];[];[];[];[];[];[];[];[false];[];[szesna\u015bcie]", "17/10/2:[siedemna\u015bcie];[];[];[];[];[];[];[];[false];[];[siedemna\u015bcie]", "18/10/2:[osiemna\u015bcie];[];[];[];[];[];[];[];[false];[];[osiemna\u015bcie]", "19/10/2:[dziewi\u0119tna\u015bcie];[];[];[];[];[];[];[];[false];[];[dziewi\u0119tna\u015bcie]"};
        pl_Def.put("teens", stringArray2);
        stringArray3 = new String[]{"2/1/1:[dwadzie\u015bcia];[];[];[default];[ ];[];[];[];[true];[];[]", "3/1/1:[trzydzie\u015bci];[];[];[default];[ ];[];[];[];[true];[];[]", "4/1/1:[czterdzie\u015bci];[];[];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[pi\u0119\u0107dziesi\u0105t];[];[];[default];[ ];[];[];[];[true];[];[]", "6/1/1:[sze\u015b\u0107dziesi\u0105t];[];[];[default];[ ];[];[];[];[true];[];[]", "7/1/1:[siedemdziesi\u0105t];[];[];[default];[ ];[];[];[];[true];[];[]", "8/1/1:[osiemdziesi\u0105t];[];[];[default];[ ];[];[];[];[true];[];[]", "9/1/1:[dziewi\u0119\u0107dziesi\u0105t];[];[];[default];[ ];[];[];[];[true];[];[]"};
        pl_Def.put("tenths", stringArray3);
        stringArray4 = new String[]{"1/1/1:[sto];[];[];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[dwie\u015bcie];[];[];[default];[ ];[];[];[];[true];[];[]", "3/1/1:[trzysta];[];[];[default];[ ];[];[];[];[true];[];[]", "4/1/1:[czterysta];[];[];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[pi\u0119\u0107set];[];[];[default];[ ];[];[];[];[true];[];[]", "6/1/1:[sze\u015b\u0107set];[];[];[default];[ ];[];[];[];[true];[];[]", "7/1/1:[siedemset];[];[];[default];[ ];[];[];[];[true];[];[]", "8/1/1:[osiemset];[];[];[default];[ ];[];[];[];[true];[];[]", "9/1/1:[dziewi\u0119\u0107set];[];[];[default];[ ];[];[];[];[true];[];[]"};
        pl_Def.put("hundreds", stringArray4);
        stringArray5 = new String[]{"0/1/1:[tysi\u0105c];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ tysi\u0105c];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ tysi\u0105ce];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ tysi\u0119cy];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-thousands];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[ten-thousands];[];[];[];[];[false];[];[]"};
        pl_Def.put("thousands", stringArray5);
        stringArray6 = new String[]{"0/1/1:[tysi\u0119cy];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ tysi\u0119cy];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ tysi\u0105ce];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ tysi\u0119cy];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-thousands];[];[];[];[];[false];[];[]"};
        pl_Def.put("ten-thousands", stringArray6);
        stringArray7 = new String[]{"0/1/1:[milion];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ milion];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ miliony];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ milion\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-millions];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[ten-millions];[];[];[];[];[false];[];[]"};
        pl_Def.put("millions", stringArray7);
        stringArray8 = new String[]{"0/1/1:[milion\u00f3w];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ milion\u00f3w];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ miliony];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ milion\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-millions];[];[];[];[];[false];[];[]"};
        pl_Def.put("ten-millions", stringArray8);
        stringArray9 = new String[]{"0/1/1:[miliard];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ miliard];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ miliardy];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ miliard\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-billions];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[ten-billions];[];[];[];[];[false];[];[]"};
        pl_Def.put("billions", stringArray9);
        stringArray10 = new String[]{"0/1/1:[miliard\u00f3w];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ miliard\u00f3w];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ miliardy];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ miliard\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-billions];[];[];[];[];[false];[];[]"};
        pl_Def.put("ten-billions", stringArray10);
        stringArray11 = new String[]{"0/1/1:[bilion];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ bilion];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ biliony];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ bilion\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-trillions];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[ten-trillions];[];[];[];[];[false];[];[]"};
        pl_Def.put("trillions", stringArray11);
        stringArray12 = new String[]{"0/1/1:[bilion\u00f3w];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ bilion\u00f3w];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ biliony];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ bilion\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-trillions];[];[];[];[];[false];[];[]"};
        pl_Def.put("ten-trillions", stringArray12);
        stringArray13 = new String[]{"0/1/1:[biliard];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ biliard];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ biliardy];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ biliard\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-quadrillions];[];[];[];[];[false];[];[]", "100/100/3:[];[hundreds];[ ];[ten-quadrillions];[];[];[];[];[false];[];[]"};
        pl_Def.put("quadrillions", stringArray13);
        stringArray14 = new String[]{"0/1/1:[biliard\u00f3w];[];[];[default];[ ];[];[];[];[true];[];[]", "1/1/1:[];[teens];[ biliard\u00f3w];[default];[ ];[];[];[];[true];[];[]", "2/1/1:[];[teens];[ biliardy];[default];[ ];[];[];[];[true];[];[]", "5/1/1:[];[teens];[ biliard\u00f3w];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[];[tenths];[ ];[ten-quadrillions];[];[];[];[];[false];[];[]"};
        pl_Def.put("ten-quadrillions", stringArray14);
        String[] stringArray15 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        pl_Def.put("minus", stringArray15);
        pl_Def.put("decimal", stringArray);
        m_RuleDefinition.put(new Locale("pl", ""), pl_Def);
        pt_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[um];[];[];[];[];[];[];[];[false];[];[um]", "2/1/1:[dois];[];[];[];[];[];[];[];[false];[];[dois]", "3/1/1:[tr\u00eas];[];[];[];[];[];[];[];[false];[];[tr\u00eas]", "4/1/1:[quatro];[];[];[];[];[];[];[];[false];[];[quatro]", "5/1/1:[cinco];[];[];[];[];[];[];[];[false];[];[cinco]", "6/1/1:[seis];[];[];[];[];[];[];[];[false];[];[seis]", "7/1/1:[sete];[];[];[];[];[];[];[];[false];[];[sete]", "8/1/1:[oito];[];[];[];[];[];[];[];[false];[];[oito]", "9/1/1:[nove];[];[];[];[];[];[];[];[false];[];[nove]", "10/10/2:[dez];[];[];[];[];[];[];[];[false];[];[dez]", "11/10/2:[onze];[];[];[];[];[];[];[];[false];[];[onze]", "12/10/2:[doze];[];[];[];[];[];[];[];[false];[];[doze]", "13/10/2:[treze];[];[];[];[];[];[];[];[false];[];[treze]", "14/10/2:[catorze];[];[];[];[];[];[];[];[false];[];[catorze]", "15/10/2:[quinze];[];[];[];[];[];[];[];[false];[];[quinze]", "16/10/2:[dezasseis];[];[];[];[];[];[];[];[false];[];[dezasseis]", "17/10/2:[dezassete];[];[];[];[];[];[];[];[false];[];[dezassete]", "18/10/2:[dezoito];[];[];[];[];[];[];[];[false];[];[dezoito]", "19/10/2:[dezanove];[];[];[];[];[];[];[];[false];[];[dezanove]", "20/10/2:[vinte];[];[];[];[];[];[];[];[false];[];[vinte]", "21/10/2:[vinte e um];[];[];[];[];[];[];[];[false];[];[vinte e um]", "22/10/2:[vinte e dois];[];[];[];[];[];[];[];[false];[];[vinte e dois]", "23/10/2:[vinte e tr\u00eas];[];[];[];[];[];[];[];[false];[];[vinte e tr\u00eas]", "24/10/2:[vinte e quatro];[];[];[];[];[];[];[];[false];[];[vinte e quatro]", "25/10/2:[vinte e cinco];[];[];[];[];[];[];[];[false];[];[vinte e cinco]", "26/10/2:[vinte e seis];[];[];[];[];[];[];[];[false];[];[vinte e seis]", "27/10/2:[vinte e sete];[];[];[];[];[];[];[];[false];[];[vinte e sete]", "28/10/2:[vinte e oito];[];[];[];[];[];[];[];[false];[];[vinte e oito]", "29/10/2:[vinte e nove];[];[];[];[];[];[];[];[false];[];[vinte e nove]", "30/10/2:[trinta];[];[];[default];[ e ];[];[];[];[true];[];[]", "40/10/2:[quarenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "50/10/2:[cinquenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "60/10/2:[sessenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "70/10/2:[setenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "80/10/2:[oitenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "90/10/2:[noventa];[];[];[default];[ e ];[];[];[];[true];[];[]", "100/100/3:[cem];[];[];[];[];[];[];[];[false];[];[cem]", "101/100/3:[cento e ];[];[];[default];[];[];[];[];[false];[];[]", "200/100/3:[duzentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "300/100/3:[trezentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "400/100/3:[quatrocentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "500/100/3:[quinhentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "600/100/3:[seiscentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "700/100/3:[setecentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "800/100/3:[oitocentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "900/100/3:[novecentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "1000/1000/4:[mil];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[ mil];[ends-e];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[um milh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[um bilh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ bilh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[um trilh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ trilh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[um quatrilh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ quatrilh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        pt_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[menos ];[];[];[];[];[];[default];[];[false];[];[]"};
        pt_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[e um];[];[];[];[];[];[];[];[false];[];[e um]", "2/1/1:[e dois];[];[];[];[];[];[];[];[false];[];[e dois]", "3/1/1:[e tr\u00eas];[];[];[];[];[];[];[];[false];[];[e tr\u00eas]", "4/1/1:[e quatro];[];[];[];[];[];[];[];[false];[];[e quatro]", "5/1/1:[e cinco];[];[];[];[];[];[];[];[false];[];[e cinco]", "6/1/1:[e seis];[];[];[];[];[];[];[];[false];[];[e seis]", "7/1/1:[e sete];[];[];[];[];[];[];[];[false];[];[e sete]", "8/1/1:[e oito];[];[];[];[];[];[];[];[false];[];[e oito]", "9/1/1:[e nove];[];[];[];[];[];[];[];[false];[];[e nove]", "10/10/2:[e dez];[];[];[];[];[];[];[];[false];[];[e dez]", "11/10/2:[e onze];[];[];[];[];[];[];[];[false];[];[e onze]", "12/10/2:[e doze];[];[];[];[];[];[];[];[false];[];[e doze]", "13/10/2:[e treze];[];[];[];[];[];[];[];[false];[];[e treze]", "14/10/2:[e catorze];[];[];[];[];[];[];[];[false];[];[e catorze]", "15/10/2:[e quinze];[];[];[];[];[];[];[];[false];[];[e quinze]", "16/10/2:[e dezasseis];[];[];[];[];[];[];[];[false];[];[e dezasseis]", "17/10/2:[e dezassete];[];[];[];[];[];[];[];[false];[];[e dezassete]", "18/10/2:[e dezoito];[];[];[];[];[];[];[];[false];[];[e dezoito]", "19/10/2:[e dezanove];[];[];[];[];[];[];[];[false];[];[e dezanove]", "20/10/2:[e vinte];[];[];[];[];[];[];[];[false];[];[e vinte]", "21/10/2:[vinte];[];[];[default];[ e ];[];[];[];[true];[];[]", "30/10/2:[e trinta];[];[];[];[];[];[];[];[false];[];[e trinta]", "31/10/2:[trinta];[];[];[default];[ e ];[];[];[];[true];[];[]", "40/10/2:[e quarenta];[];[];[];[];[];[];[];[false];[];[e quarenta]", "41/10/2:[quarenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "50/10/2:[e cinquenta];[];[];[];[];[];[];[];[false];[];[e cinquenta]", "51/10/2:[cinquenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "60/10/2:[e sessenta];[];[];[];[];[];[];[];[false];[];[e sessenta]", "61/10/2:[sessenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "70/10/2:[e setenta];[];[];[];[];[];[];[];[false];[];[e setenta]", "71/10/2:[setenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "80/10/2:[e oitenta];[];[];[];[];[];[];[];[false];[];[e oitenta]", "81/10/2:[oitenta];[];[];[default];[ e ];[];[];[];[true];[];[]", "90/10/2:[e noventa];[];[];[];[];[];[];[];[false];[];[e noventa]", "91/10/2:[noventa];[];[];[default];[ e ];[];[];[];[true];[];[]", "100/100/3:[e cem];[];[];[];[];[];[];[];[false];[];[e cem]", "101/100/3:[cento ];[];[];[default];[e ];[];[];[];[true];[];[]", "200/100/3:[e duzentos];[];[];[];[];[];[];[];[false];[];[e duzentos]", "201/100/3:[duzentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "300/100/3:[e trezentos];[];[];[];[];[];[];[];[false];[];[e trezentos]", "301/100/3:[trezentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "400/100/3:[e quatrocentos];[];[];[];[];[];[];[];[false];[];[e quatrocentos]", "401/100/3:[quatrocentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "500/100/3:[e quinhentos];[];[];[];[];[];[];[];[false];[];[e quinhentos]", "501/100/3:[quinhentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "600/100/3:[e seiscentos];[];[];[];[];[];[];[];[false];[];[e seiscentos]", "601/100/3:[seiscentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "700/100/3:[e setecentos];[];[];[];[];[];[];[];[false];[];[e setecentos]", "701/100/3:[setecentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "800/100/3:[e oitocentos];[];[];[];[];[];[];[];[false];[];[e oitocentos]", "801/100/3:[oitocentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "900/100/3:[e novecentos];[];[];[];[];[];[];[];[false];[];[e novecentos]", "901/100/3:[novecentos];[];[];[default];[ e ];[];[];[];[true];[];[]", "1000/1000/4:[e mil];[];[];[];[];[];[];[];[false];[];[e mil]", "1001/1000/4:[mil];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[ends-e];[ mil];[ends-e];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[um milh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[ends-e];[ milh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[um bilh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[ends-e];[ bilh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[um trilh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[ends-e];[ trilh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[um quatrilh\u00e3o];[];[];[ends-e];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[ends-e];[ quatrilh\u00f5es];[ends-e];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        pt_Def.put("ends-e", stringArray3);
        pt_Def.put("decimal", stringArray);
        m_RuleDefinition.put(new Locale("pt", ""), pt_Def);
        ru_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u043d\u043e\u043b\u044c];[];[];[];[];[];[];[];[false];[];[\u043d\u043e\u043b\u044c]", "1/1/1:[\u043e\u0434\u0438\u043d];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d]", "2/1/1:[\u0434\u0432\u0430];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430]", "3/1/1:[\u0442\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438]", "4/1/1:[\u0447\u0435\u0442\u044b\u0440\u0435];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u044b\u0440\u0435]", "5/1/1:[\u043f\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u044f\u0442\u044c]", "6/1/1:[\u0448\u0435\u0441\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u0442\u044c]", "7/1/1:[\u0441\u0435\u043c\u044c];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u043c\u044c]", "8/1/1:[\u0432\u043e\u0441\u0435\u043c\u044c];[];[];[];[];[];[];[];[false];[];[\u0432\u043e\u0441\u0435\u043c\u044c]", "9/1/1:[\u0434\u0435\u0432\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u044f\u0442\u044c]", "10/10/2:[\u0434\u0435\u0441\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0441\u044f\u0442\u044c]", "11/10/2:[\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "12/10/2:[\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "13/10/2:[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "14/10/2:[\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "15/10/2:[\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "16/10/2:[\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "17/10/2:[\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "18/10/2:[\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "19/10/2:[\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "20/10/2:[\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[default];[ ];[];[];[];[true];[];[]", "30/10/2:[\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c];[];[];[default];[ ];[];[];[];[true];[];[]", "40/10/2:[\u0441\u043e\u0440\u043e\u043a];[];[];[default];[ ];[];[];[];[true];[];[]", "50/10/2:[\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "60/10/2:[\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "70/10/2:[\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "80/10/2:[\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "90/10/2:[\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e];[];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[\u0441\u0442\u043e];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[\u0434\u0432\u0435\u0441\u0442\u0438];[];[];[default];[ ];[];[];[];[true];[];[]", "300/100/3:[\u0442\u0440\u0438\u0441\u0442\u0430];[];[];[default];[ ];[];[];[];[true];[];[]", "400/100/3:[\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430];[];[];[default];[ ];[];[];[];[true];[];[]", "500/100/3:[\u043f\u044f\u0442\u044c\u0441\u043e\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "600/100/3:[\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "700/100/3:[\u0441\u0435\u043c\u044c\u0441\u043e\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "800/100/3:[\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "900/100/3:[\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442];[];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ru_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u0442\u044b\u0441\u044f\u0447];[];[];[];[];[];[];[];[false];[];[\u0442\u044b\u0441\u044f\u0447]", "1/1/1:[\u043e\u0434\u043d\u0430 \u0442\u044b\u0441\u044f\u0447\u0430];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u043d\u0430 \u0442\u044b\u0441\u044f\u0447\u0430]", "2/1/1:[\u0434\u0432\u0435 \u0442\u044b\u0441\u044f\u0447\u0438];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0435 \u0442\u044b\u0441\u044f\u0447\u0438]", "3/1/1:[];[default];[ \u0442\u044b\u0441\u044f\u0447\u0438];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default];[ \u0442\u044b\u0441\u044f\u0447];[];[];[];[];[];[false];[];[]", "20/10/2:[\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c ];[];[];[thousands];[];[];[];[];[false];[];[]", "30/10/2:[\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c ];[];[];[thousands];[];[];[];[];[false];[];[]", "40/10/2:[\u0441\u043e\u0440\u043e\u043a ];[];[];[thousands];[];[];[];[];[false];[];[]", "50/10/2:[\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "60/10/2:[\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "70/10/2:[\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "80/10/2:[\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "90/10/2:[\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e ];[];[];[thousands];[];[];[];[];[false];[];[]", "100/100/3:[\u0441\u0442\u043e ];[];[];[thousands];[];[];[];[];[false];[];[]", "200/100/3:[\u0434\u0432\u0435\u0441\u0442\u0438 ];[];[];[thousands];[];[];[];[];[false];[];[]", "300/100/3:[\u0442\u0440\u0438\u0441\u0442\u0430 ];[];[];[thousands];[];[];[];[];[false];[];[]", "400/100/3:[\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430 ];[];[];[thousands];[];[];[];[];[false];[];[]", "500/100/3:[\u043f\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "600/100/3:[\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "700/100/3:[\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "800/100/3:[\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]", "900/100/3:[\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[thousands];[];[];[];[];[false];[];[]"};
        ru_Def.put("thousands", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432];[];[];[];[];[];[];[];[false];[];[\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432]", "1/1/1:[\u043e\u0434\u0438\u043d \u043c\u0438\u043b\u043b\u0438\u043e\u043d];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d \u043c\u0438\u043b\u043b\u0438\u043e\u043d]", "2/1/1:[\u0434\u0432\u0430 \u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430 \u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430]", "3/1/1:[];[default];[ \u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default];[ \u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432];[];[];[];[];[];[false];[];[]", "20/10/2:[\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c ];[];[];[millions];[];[];[];[];[false];[];[]", "30/10/2:[\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c ];[];[];[millions];[];[];[];[];[false];[];[]", "40/10/2:[\u0441\u043e\u0440\u043e\u043a ];[];[];[millions];[];[];[];[];[false];[];[]", "50/10/2:[\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "60/10/2:[\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "70/10/2:[\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "80/10/2:[\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "90/10/2:[\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e ];[];[];[millions];[];[];[];[];[false];[];[]", "100/100/3:[\u0441\u0442\u043e ];[];[];[millions];[];[];[];[];[false];[];[]", "200/100/3:[\u0434\u0432\u0435\u0441\u0442\u0438 ];[];[];[millions];[];[];[];[];[false];[];[]", "300/100/3:[\u0442\u0440\u0438\u0441\u0442\u0430 ];[];[];[millions];[];[];[];[];[false];[];[]", "400/100/3:[\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430 ];[];[];[millions];[];[];[];[];[false];[];[]", "500/100/3:[\u043f\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "600/100/3:[\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "700/100/3:[\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "800/100/3:[\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "900/100/3:[\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[millions];[];[];[];[];[false];[];[]", "1000/1000/4:[];[thousands];[ ];[millions];[];[];[];[];[false];[];[]"};
        ru_Def.put("millions", stringArray3);
        stringArray4 = new String[]{"0/1/1:[\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432];[];[];[];[];[];[];[];[false];[];[\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432]", "1/1/1:[\u043e\u0434\u0438\u043d \u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d \u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434]", "2/1/1:[\u0434\u0432\u0430 \u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430 \u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430]", "3/1/1:[];[default];[ \u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default];[ \u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432];[];[];[];[];[];[false];[];[]", "20/10/2:[\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c ];[];[];[billions];[];[];[];[];[false];[];[]", "30/10/2:[\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c ];[];[];[billions];[];[];[];[];[false];[];[]", "40/10/2:[\u0441\u043e\u0440\u043e\u043a ];[];[];[billions];[];[];[];[];[false];[];[]", "50/10/2:[\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "60/10/2:[\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "70/10/2:[\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "80/10/2:[\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "90/10/2:[\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e ];[];[];[billions];[];[];[];[];[false];[];[]", "100/100/3:[\u0441\u0442\u043e ];[];[];[billions];[];[];[];[];[false];[];[]", "200/100/3:[\u0434\u0432\u0435\u0441\u0442\u0438 ];[];[];[billions];[];[];[];[];[false];[];[]", "300/100/3:[\u0442\u0440\u0438\u0441\u0442\u0430 ];[];[];[billions];[];[];[];[];[false];[];[]", "400/100/3:[\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430 ];[];[];[billions];[];[];[];[];[false];[];[]", "500/100/3:[\u043f\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "600/100/3:[\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "700/100/3:[\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "800/100/3:[\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "900/100/3:[\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[billions];[];[];[];[];[false];[];[]", "1000/1000/4:[];[thousands];[ ];[billions];[];[];[];[];[false];[];[]"};
        ru_Def.put("billions", stringArray4);
        stringArray5 = new String[]{"0/1/1:[\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432]", "1/1/1:[\u043e\u0434\u0438\u043d \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d]", "2/1/1:[\u0434\u0432\u0430 \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430 \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430]", "3/1/1:[];[default];[ \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default];[ \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432];[];[];[];[];[];[false];[];[]", "20/10/2:[\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c ];[];[];[trillions];[];[];[];[];[false];[];[]", "30/10/2:[\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c ];[];[];[trillions];[];[];[];[];[false];[];[]", "40/10/2:[\u0441\u043e\u0440\u043e\u043a ];[];[];[trillions];[];[];[];[];[false];[];[]", "50/10/2:[\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "60/10/2:[\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "70/10/2:[\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "80/10/2:[\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "90/10/2:[\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e ];[];[];[trillions];[];[];[];[];[false];[];[]", "100/100/3:[\u0441\u0442\u043e ];[];[];[trillions];[];[];[];[];[false];[];[]", "200/100/3:[\u0434\u0432\u0435\u0441\u0442\u0438 ];[];[];[trillions];[];[];[];[];[false];[];[]", "300/100/3:[\u0442\u0440\u0438\u0441\u0442\u0430 ];[];[];[trillions];[];[];[];[];[false];[];[]", "400/100/3:[\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430 ];[];[];[trillions];[];[];[];[];[false];[];[]", "500/100/3:[\u043f\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "600/100/3:[\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "700/100/3:[\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "800/100/3:[\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "900/100/3:[\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442 ];[];[];[trillions];[];[];[];[];[false];[];[]", "1000/1000/4:[];[thousands];[ ];[trillions];[];[];[];[];[false];[];[]"};
        ru_Def.put("trillions", stringArray5);
        stringArray6 = new String[]{"0/1/1:[\u043c\u0438\u043d\u0443\u0441 ];[];[];[];[];[];[default];[];[false];[];[]"};
        ru_Def.put("minus", stringArray6);
        stringArray7 = new String[]{"0/1/1:[\u043d\u043e\u043b\u044c];[];[];[];[];[];[];[];[false];[];[\u043d\u043e\u043b\u044c]", "1/1/1:[\u043e\u0434\u0438\u043d];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d]", "2/1/1:[\u0434\u0432\u0430];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430]", "3/1/1:[\u0442\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438]", "4/1/1:[\u0447\u0435\u0442\u044b\u0440\u0435];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u044b\u0440\u0435]", "5/1/1:[\u043f\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u044f\u0442\u044c]", "6/1/1:[\u0448\u0435\u0441\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u0442\u044c]", "7/1/1:[\u0441\u0435\u043c\u044c];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u043c\u044c]", "8/1/1:[\u0432\u043e\u0441\u0435\u043c\u044c];[];[];[];[];[];[];[];[false];[];[\u0432\u043e\u0441\u0435\u043c\u044c]", "9/1/1:[\u0434\u0435\u0432\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u044f\u0442\u044c]", "10/10/2:[\u0434\u0435\u0441\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0441\u044f\u0442\u044c]", "11/10/2:[\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "12/10/2:[\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "13/10/2:[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "14/10/2:[\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "15/10/2:[\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "16/10/2:[\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "17/10/2:[\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "18/10/2:[\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "19/10/2:[\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c]", "20/10/2:[\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c];[];[];[decimal];[ ];[];[];[];[true];[];[]", "30/10/2:[\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c];[];[];[decimal];[ ];[];[];[];[true];[];[]", "40/10/2:[\u0441\u043e\u0440\u043e\u043a];[];[];[decimal];[ ];[];[];[];[true];[];[]", "50/10/2:[\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "60/10/2:[\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "70/10/2:[\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "80/10/2:[\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "90/10/2:[\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e];[];[];[decimal];[ ];[];[];[];[true];[];[]", "100/100/3:[\u0441\u0442\u043e];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[\u0434\u0432\u0435\u0441\u0442\u0438];[];[];[decimal];[ ];[];[];[];[true];[];[]", "300/100/3:[\u0442\u0440\u0438\u0441\u0442\u0430];[];[];[decimal];[ ];[];[];[];[true];[];[]", "400/100/3:[\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430];[];[];[decimal];[ ];[];[];[];[true];[];[]", "500/100/3:[\u043f\u044f\u0442\u044c\u0441\u043e\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "600/100/3:[\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "700/100/3:[\u0441\u0435\u043c\u044c\u0441\u043e\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "800/100/3:[\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "900/100/3:[\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ru_Def.put("decimal", stringArray7);
        m_RuleDefinition.put(new Locale("ru", ""), ru_Def);
        sv_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[noll];[];[];[];[];[];[];[];[false];[];[noll]", "1/1/1:[en];[];[];[];[];[];[];[];[false];[];[en]", "2/1/1:[tv\u00e5];[];[];[];[];[];[];[];[false];[];[tv\u00e5]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[fyra];[];[];[];[];[];[];[];[false];[];[fyra]", "5/1/1:[fem];[];[];[];[];[];[];[];[false];[];[fem]", "6/1/1:[sex];[];[];[];[];[];[];[];[false];[];[sex]", "7/1/1:[sju];[];[];[];[];[];[];[];[false];[];[sju]", "8/1/1:[\u00e5tta];[];[];[];[];[];[];[];[false];[];[\u00e5tta]", "9/1/1:[nio];[];[];[];[];[];[];[];[false];[];[nio]", "10/10/2:[tio];[];[];[];[];[];[];[];[false];[];[tio]", "11/10/2:[elva];[];[];[];[];[];[];[];[false];[];[elva]", "12/10/2:[tolv];[];[];[];[];[];[];[];[false];[];[tolv]", "13/10/2:[tretton];[];[];[];[];[];[];[];[false];[];[tretton]", "14/10/2:[fjorton];[];[];[];[];[];[];[];[false];[];[fjorton]", "15/10/2:[femton];[];[];[];[];[];[];[];[false];[];[femton]", "16/10/2:[sexton];[];[];[];[];[];[];[];[false];[];[sexton]", "17/10/2:[sjutton];[];[];[];[];[];[];[];[false];[];[sjutton]", "18/10/2:[arton];[];[];[];[];[];[];[];[false];[];[arton]", "19/10/2:[nitton];[];[];[];[];[];[];[];[false];[];[nitton]", "20/10/2:[tjugo];[];[];[default];[];[];[];[];[true];[];[]", "30/10/2:[trettio];[];[];[default];[];[];[];[];[true];[];[]", "40/10/2:[fyrtio];[];[];[default];[];[];[];[];[true];[];[]", "50/10/2:[femtio];[];[];[default];[];[];[];[];[true];[];[]", "60/10/2:[sextio];[];[];[default];[];[];[];[];[true];[];[]", "70/10/2:[sjuttio];[];[];[default];[];[];[];[];[true];[];[]", "80/10/2:[\u00e5ttio];[];[];[default];[];[];[];[];[true];[];[]", "90/10/2:[nittio];[];[];[default];[];[];[];[];[true];[];[]", "100/100/3:[etthundra];[];[];[default];[];[];[];[];[true];[];[]", "200/100/3:[];[default];[hundra];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[ettusen];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[tusen];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[en miljon];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ miljoner];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[en miljard];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ miljarder];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[en biljon];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ biljoner];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[en triljon];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ triljoner];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sv_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        sv_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[noll];[];[];[];[];[];[];[];[false];[];[noll]", "1/1/1:[en];[];[];[];[];[];[];[];[false];[];[en]", "2/1/1:[tv\u00e5];[];[];[];[];[];[];[];[false];[];[tv\u00e5]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[fyra];[];[];[];[];[];[];[];[false];[];[fyra]", "5/1/1:[fem];[];[];[];[];[];[];[];[false];[];[fem]", "6/1/1:[sex];[];[];[];[];[];[];[];[false];[];[sex]", "7/1/1:[sju];[];[];[];[];[];[];[];[false];[];[sju]", "8/1/1:[\u00e5tta];[];[];[];[];[];[];[];[false];[];[\u00e5tta]", "9/1/1:[nio];[];[];[];[];[];[];[];[false];[];[nio]", "10/10/2:[tio];[];[];[];[];[];[];[];[false];[];[tio]", "11/10/2:[elva];[];[];[];[];[];[];[];[false];[];[elva]", "12/10/2:[tolv];[];[];[];[];[];[];[];[false];[];[tolv]", "13/10/2:[tretton];[];[];[];[];[];[];[];[false];[];[tretton]", "14/10/2:[fjorton];[];[];[];[];[];[];[];[false];[];[fjorton]", "15/10/2:[femton];[];[];[];[];[];[];[];[false];[];[femton]", "16/10/2:[sexton];[];[];[];[];[];[];[];[false];[];[sexton]", "17/10/2:[sjutton];[];[];[];[];[];[];[];[false];[];[sjutton]", "18/10/2:[arton];[];[];[];[];[];[];[];[false];[];[arton]", "19/10/2:[nitton];[];[];[];[];[];[];[];[false];[];[nitton]", "20/10/2:[tjugo];[];[];[decimal];[];[];[];[];[true];[];[]", "30/10/2:[trettio];[];[];[decimal];[];[];[];[];[true];[];[]", "40/10/2:[fyrtio];[];[];[decimal];[];[];[];[];[true];[];[]", "50/10/2:[femtio];[];[];[decimal];[];[];[];[];[true];[];[]", "60/10/2:[sextio];[];[];[decimal];[];[];[];[];[true];[];[]", "70/10/2:[sjuttio];[];[];[decimal];[];[];[];[];[true];[];[]", "80/10/2:[\u00e5ttio];[];[];[decimal];[];[];[];[];[true];[];[]", "90/10/2:[nittio];[];[];[decimal];[];[];[];[];[true];[];[]", "100/100/3:[etthundra];[];[];[decimal];[];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[hundra];[decimal];[];[];[];[];[true];[];[]", "1000/1000/4:[ettusen];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[decimal];[tusen];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[en miljon];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[decimal];[ miljoner];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[en miljard];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[decimal];[ miljarder];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[en biljon];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[decimal];[ biljoner];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[en triljon];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[decimal];[ triljoner];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sv_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("sv", ""), sv_Def);
        th_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u0e28\u0e39\u0e19\u0e22\u0e4c];[];[];[];[];[];[];[];[false];[];[\u0e28\u0e39\u0e19\u0e22\u0e4c]", "1/1/1:[\u0e2b\u0e19\u0e36\u0e48\u0e07];[];[];[];[];[];[];[];[false];[];[\u0e2b\u0e19\u0e36\u0e48\u0e07]", "2/1/1:[\u0e2a\u0e2d\u0e07];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e2d\u0e07]", "3/1/1:[\u0e2a\u0e32\u0e21];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e32\u0e21]", "4/1/1:[\u0e2a\u0e35\u0e48];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e35\u0e48]", "5/1/1:[\u0e2b\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e2b\u0e49\u0e32]", "6/1/1:[\u0e2b\u0e01];[];[];[];[];[];[];[];[false];[];[\u0e2b\u0e01]", "7/1/1:[\u0e40\u0e08\u0e47\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e40\u0e08\u0e47\u0e14]", "8/1/1:[\u0e41\u0e1b\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e41\u0e1b\u0e14]", "9/1/1:[\u0e40\u0e01\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e40\u0e01\u0e49\u0e32]", "10/10/2:[\u0e2a\u0e34\u0e1a];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a]", "11/10/2:[\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14]", "12/10/2:[\u0e2a\u0e34\u0e1a\u0e2a\u0e2d\u0e07];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2a\u0e2d\u0e07]", "13/10/2:[\u0e2a\u0e34\u0e1a\u0e2a\u0e32\u0e21];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2a\u0e32\u0e21]", "14/10/2:[\u0e2a\u0e34\u0e1a\u0e2a\u0e35\u0e48];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2a\u0e35\u0e48]", "15/10/2:[\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32]", "16/10/2:[\u0e2a\u0e34\u0e1a\u0e2b\u0e01];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2b\u0e01]", "17/10/2:[\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14]", "18/10/2:[\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14]", "19/10/2:[\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32]", "20/10/2:[\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "30/10/2:[\u0e2a\u0e32\u0e21\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "40/10/2:[\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "50/10/2:[\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "60/10/2:[\u0e2b\u0e01\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "70/10/2:[\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "80/10/2:[\u0e41\u0e1b\u0e14\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "90/10/2:[\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "100/100/3:[];[default];[\u0e23\u0e49\u0e2d\u0e22];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[\u0e1e\u0e31\u0e19];[default];[];[];[];[];[true];[];[]", "10000/10000/5:[];[default];[\u0e2b\u0e21\u0e37\u0e48\u0e19];[default];[];[];[];[];[true];[];[]", "100000/100000/6:[];[default];[\u0e41\u0e2a\u0e19];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[\u0e25\u0e49\u0e32\u0e19];[default];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[\u0e1e\u0e31\u0e19\u0e25\u0e49\u0e32\u0e19];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[\u0e25\u0e49\u0e32\u0e19\u0e25\u0e49\u0e32\u0e19];[default];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        th_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u0e25\u0e1a];[];[];[];[];[];[default];[];[false];[];[]"};
        th_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u0e28\u0e39\u0e19\u0e22\u0e4c];[];[];[];[];[];[];[];[false];[];[\u0e28\u0e39\u0e19\u0e22\u0e4c]", "1/1/1:[\u0e40\u0e2d\u0e47\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e40\u0e2d\u0e47\u0e14]", "2/1/1:[];[];[];[];[];[];[default];[];[false];[];[]"};
        th_Def.put("zero-one-two", stringArray3);
        stringArray4 = new String[]{"0/1/1:[\u0e28\u0e39\u0e19\u0e22\u0e4c];[];[];[];[];[];[];[];[false];[];[\u0e28\u0e39\u0e19\u0e22\u0e4c]", "1/1/1:[\u0e2b\u0e19\u0e36\u0e48\u0e07];[];[];[];[];[];[];[];[false];[];[\u0e2b\u0e19\u0e36\u0e48\u0e07]", "2/1/1:[\u0e2a\u0e2d\u0e07];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e2d\u0e07]", "3/1/1:[\u0e2a\u0e32\u0e21];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e32\u0e21]", "4/1/1:[\u0e2a\u0e35\u0e48];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e35\u0e48]", "5/1/1:[\u0e2b\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e2b\u0e49\u0e32]", "6/1/1:[\u0e2b\u0e01];[];[];[];[];[];[];[];[false];[];[\u0e2b\u0e01]", "7/1/1:[\u0e40\u0e08\u0e47\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e40\u0e08\u0e47\u0e14]", "8/1/1:[\u0e41\u0e1b\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e41\u0e1b\u0e14]", "9/1/1:[\u0e40\u0e01\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e40\u0e01\u0e49\u0e32]", "10/10/2:[\u0e2a\u0e34\u0e1a];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a]", "11/10/2:[\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14]", "12/10/2:[\u0e2a\u0e34\u0e1a\u0e2a\u0e2d\u0e07];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2a\u0e2d\u0e07]", "13/10/2:[\u0e2a\u0e34\u0e1a\u0e2a\u0e32\u0e21];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2a\u0e32\u0e21]", "14/10/2:[\u0e2a\u0e34\u0e1a\u0e2a\u0e35\u0e48];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2a\u0e35\u0e48]", "15/10/2:[\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32]", "16/10/2:[\u0e2a\u0e34\u0e1a\u0e2b\u0e01];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e2b\u0e01]", "17/10/2:[\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14]", "18/10/2:[\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14]", "19/10/2:[\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32];[];[];[];[];[];[];[];[false];[];[\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32]", "20/10/2:[\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "30/10/2:[\u0e2a\u0e32\u0e21\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "40/10/2:[\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "50/10/2:[\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "60/10/2:[\u0e2b\u0e01\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "70/10/2:[\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "80/10/2:[\u0e41\u0e1b\u0e14\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "90/10/2:[\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a];[];[];[zero-one-two];[];[];[];[];[true];[];[]", "100/100/3:[];[decimal];[\u0e23\u0e49\u0e2d\u0e22];[decimal];[];[];[];[];[true];[];[]", "1000/1000/4:[];[decimal];[\u0e1e\u0e31\u0e19];[decimal];[];[];[];[];[true];[];[]", "10000/10000/5:[];[decimal];[\u0e2b\u0e21\u0e37\u0e48\u0e19];[decimal];[];[];[];[];[true];[];[]", "100000/100000/6:[];[decimal];[\u0e41\u0e2a\u0e19];[decimal];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[\u0e25\u0e49\u0e32\u0e19];[decimal];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[\u0e1e\u0e31\u0e19\u0e25\u0e49\u0e32\u0e19];[decimal];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[\u0e25\u0e49\u0e32\u0e19\u0e25\u0e49\u0e32\u0e19];[decimal];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        th_Def.put("decimal", stringArray4);
        m_RuleDefinition.put(new Locale("th", ""), th_Def);
        uk_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u043d\u0443\u043b\u044c];[];[];[];[];[];[];[];[false];[];[\u043d\u0443\u043b\u044c]", "1/1/1:[\u043e\u0434\u043d\u0430];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u043d\u0430]", "2/1/1:[\u0434\u0432\u0456];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0456]", "3/1/1:[\u0442\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438]", "4/1/1:[\u0447\u043e\u0442\u0438\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0447\u043e\u0442\u0438\u0440\u0438]", "5/1/1:[\u043f\u02bc\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u02bc\u044f\u0442\u044c]", "6/1/1:[\u0448\u0456\u0441\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0456\u0441\u0442\u044c]", "7/1/1:[\u0441\u0456\u043c];[];[];[];[];[];[];[];[false];[];[\u0441\u0456\u043c]", "8/1/1:[\u0432\u0456\u0441\u0456\u043c];[];[];[];[];[];[];[];[false];[];[\u0432\u0456\u0441\u0456\u043c]", "9/1/1:[\u0434\u0435\u0432\u02bc\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u02bc\u044f\u0442\u044c]", "10/10/2:[\u0434\u0435\u0441\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0441\u044f\u0442\u044c]", "11/10/2:[\u043e\u0434\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "12/10/2:[\u0434\u0432\u0430\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "13/10/2:[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "14/10/2:[\u0447\u043e\u0442\u0438\u0440\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0447\u043e\u0442\u0438\u0440\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "15/10/2:[\u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "16/10/2:[\u0448\u0456\u0441\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0456\u0441\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "17/10/2:[\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "18/10/2:[\u0432\u0456\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0432\u0456\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "19/10/2:[\u0434\u0435\u0432\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c]"};
        uk_Def.put("default-alt", stringArray);
        stringArray2 = new String[]{"2/1/1:[\u0434\u0432\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[ ];[];[];[];[true];[];[]", "3/1/1:[\u0442\u0440\u0438\u0434\u0446\u044f\u0442\u044c];[];[];[];[ ];[];[];[];[true];[];[]", "4/1/1:[\u0441\u043e\u0440\u043e\u043a];[];[];[];[ ];[];[];[];[true];[];[]", "5/1/1:[\u043f\u02bc\u044f\u0442\u0434\u0435\u0441\u044f\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "6/1/1:[\u0448\u0456\u0441\u0442\u0434\u0435\u0441\u044f\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "7/1/1:[\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "8/1/1:[\u0432\u0456\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "9/1/1:[\u0434\u0435\u0432\u02bc\u044f\u043d\u043e\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]"};
        uk_Def.put("tenth", stringArray2);
        stringArray3 = new String[]{"1/1/1:[\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]", "2/1/1:[\u0434\u0432\u0456\u0441\u0442\u0456];[];[];[];[ ];[];[];[];[true];[];[]", "3/1/1:[\u0442\u0440\u0438\u0441\u0442\u0430];[];[];[];[ ];[];[];[];[true];[];[]", "4/1/1:[\u0447\u043e\u0442\u0438\u0440\u0438\u0441\u0442\u0430];[];[];[];[ ];[];[];[];[true];[];[]", "5/1/1:[\u043f\u02bc\u044f\u0442\u0441\u043e\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "6/1/1:[\u0448\u0456\u0441\u0442\u0441\u043e\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "7/1/1:[\u0441\u0456\u043c\u0441\u043e\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "8/1/1:[\u0432\u0456\u0441\u0456\u043c\u0441\u043e\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "9/1/1:[\u0434\u0435\u0432\u02bc\u044f\u0442\u0441\u043e\u0442];[];[];[];[ ];[];[];[];[true];[];[]"};
        uk_Def.put("hundreds", stringArray3);
        stringArray4 = new String[]{"1/1/1:[];[default-alt];[ \u0442\u0438\u0441\u044f\u0447\u0430];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default-alt];[ \u0442\u0438\u0441\u044f\u0447\u0456];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default-alt];[ \u0442\u0438\u0441\u044f\u0447];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[thousands];[];[];[];[\u0442\u0438\u0441\u044f\u0447];[true];[];[]", "100/100/3:[];[hundreds];[ ];[thousands];[];[];[];[\u0442\u0438\u0441\u044f\u0447];[true];[];[]"};
        uk_Def.put("thousands", stringArray4);
        stringArray5 = new String[]{"1/1/1:[];[default];[ \u043c\u0456\u043b\u044c\u0439\u043e\u043d];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ \u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0438];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default];[ \u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0456\u0432];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[millions];[];[];[];[\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0456\u0432];[true];[];[]", "100/100/3:[];[hundreds];[ ];[millions];[];[];[];[\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0456\u0432];[true];[];[]"};
        uk_Def.put("millions", stringArray5);
        stringArray6 = new String[]{"1/1/1:[];[default];[ \u043c\u0456\u043b\u044c\u044f\u0440\u0434];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ \u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0438];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default];[ \u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0456\u0432];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[billions];[];[];[];[\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0456\u0432];[true];[];[]", "100/100/3:[];[hundreds];[ ];[billions];[];[];[];[\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0456\u0432];[true];[];[]"};
        uk_Def.put("billions", stringArray6);
        stringArray7 = new String[]{"1/1/1:[];[default];[ \u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ \u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0438];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default];[ \u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[trillions];[];[];[];[\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432];[true];[];[]", "100/100/3:[];[hundreds];[ ];[trillions];[];[];[];[\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432];[true];[];[]"};
        uk_Def.put("trillions", stringArray7);
        stringArray8 = new String[]{"0/1/1:[\u043d\u0443\u043b\u044c];[];[];[];[];[];[];[];[false];[];[\u043d\u0443\u043b\u044c]", "1/1/1:[\u043e\u0434\u0438\u043d];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d]", "2/1/1:[\u0434\u0432\u0430];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430]", "3/1/1:[\u0442\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438]", "4/1/1:[\u0447\u043e\u0442\u0438\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0447\u043e\u0442\u0438\u0440\u0438]", "5/1/1:[\u043f\u02bc\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u02bc\u044f\u0442\u044c]", "6/1/1:[\u0448\u0456\u0441\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0456\u0441\u0442\u044c]", "7/1/1:[\u0441\u0456\u043c];[];[];[];[];[];[];[];[false];[];[\u0441\u0456\u043c]", "8/1/1:[\u0432\u0456\u0441\u0456\u043c];[];[];[];[];[];[];[];[false];[];[\u0432\u0456\u0441\u0456\u043c]", "9/1/1:[\u0434\u0435\u0432\u02bc\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u02bc\u044f\u0442\u044c]", "10/10/2:[\u0434\u0435\u0441\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0441\u044f\u0442\u044c]", "11/10/2:[\u043e\u0434\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043e\u0434\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "12/10/2:[\u0434\u0432\u0430\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "13/10/2:[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "14/10/2:[\u0447\u043e\u0442\u0438\u0440\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0447\u043e\u0442\u0438\u0440\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "15/10/2:[\u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "16/10/2:[\u0448\u0456\u0441\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0448\u0456\u0441\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "17/10/2:[\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "18/10/2:[\u0432\u0456\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0432\u0456\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "19/10/2:[\u0434\u0435\u0432\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c]", "20/10/2:[];[tenth];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[];[hundreds];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u0442\u0438\u0441\u044f\u0447\u0430];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[thousands];[];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u043c\u0456\u043b\u044c\u0439\u043e\u043d];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[millions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        uk_Def.put("default", stringArray8);
        stringArray9 = new String[]{"0/1/1:[\u043c\u0456\u043d\u0443\u0441 ];[];[];[];[];[];[default];[];[false];[];[]"};
        uk_Def.put("minus", stringArray9);
        uk_Def.put("decimal", stringArray8);
        m_RuleDefinition.put(new Locale("uk", ""), uk_Def);
        zh_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u96f6];[];[];[];[];[];[];[];[false];[];[\u96f6]", "1/1/1:[\u58f9];[];[];[];[];[];[];[];[false];[];[\u58f9]", "2/1/1:[\u8d30];[];[];[];[];[];[];[];[false];[];[\u8d30]", "3/1/1:[\u53c1];[];[];[];[];[];[];[];[false];[];[\u53c1]", "4/1/1:[\u8086];[];[];[];[];[];[];[];[false];[];[\u8086]", "5/1/1:[\u4f0d];[];[];[];[];[];[];[];[false];[];[\u4f0d]", "6/1/1:[\u9646];[];[];[];[];[];[];[];[false];[];[\u9646]", "7/1/1:[\u67d2];[];[];[];[];[];[];[];[false];[];[\u67d2]", "8/1/1:[\u634c];[];[];[];[];[];[];[];[false];[];[\u634c]", "9/1/1:[\u7396];[];[];[];[];[];[];[];[false];[];[\u7396]", "10/10/2:[];[default];[\u62fe];[default];[];[];[];[];[true];[];[]", "100/100/3:[];[default];[\u4f70];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[\u4edf];[default];[];[];[];[];[true];[];[]", "10000/10000/5:[];[default];[\u4e07];[default];[];[];[];[];[true];[];[]", "100000000/100000000/9:[];[default];[\u4ebf];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[\u5146];[default];[];[];[];[];[true];[];[]", "10000000000000000/10000000000000000/17:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        zh_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u8d1f];[];[];[];[];[];[default];[];[false];[];[]"};
        zh_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u6b63];[];[];[];[];[];[];[];[false];[];[\u6b63]", "1/1/1:[\u58f9\u5206];[];[];[];[];[];[];[];[false];[];[\u58f9\u5206]", "2/1/1:[\u8cb3\u5206];[];[];[];[];[];[];[];[false];[];[\u8cb3\u5206]", "3/1/1:[\u53c1\u5206];[];[];[];[];[];[];[];[false];[];[\u53c1\u5206]", "4/1/1:[\u8086\u5206];[];[];[];[];[];[];[];[false];[];[\u8086\u5206]", "5/1/1:[\u4f0d\u5206];[];[];[];[];[];[];[];[false];[];[\u4f0d\u5206]", "6/1/1:[\u9646\u5206];[];[];[];[];[];[];[];[false];[];[\u9646\u5206]", "7/1/1:[\u67d2\u5206];[];[];[];[];[];[];[];[false];[];[\u67d2\u5206]", "8/1/1:[\u634c\u5206];[];[];[];[];[];[];[];[false];[];[\u634c\u5206]", "9/1/1:[\u7396\u5206];[];[];[];[];[];[];[];[false];[];[\u7396\u5206]", "10/10/2:[];[default];[\u89d2];[decimal];[];[];[];[\u6b63];[true];[];[]"};
        zh_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("zh", ""), zh_Def);
        zhTW_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u96f6];[];[];[];[];[];[];[];[false];[];[\u96f6]", "1/1/1:[\u58f9];[];[];[];[];[];[];[];[false];[];[\u58f9]", "2/1/1:[\u8cb3];[];[];[];[];[];[];[];[false];[];[\u8cb3]", "3/1/1:[\u53c3];[];[];[];[];[];[];[];[false];[];[\u53c3]", "4/1/1:[\u8086];[];[];[];[];[];[];[];[false];[];[\u8086]", "5/1/1:[\u4f0d];[];[];[];[];[];[];[];[false];[];[\u4f0d]", "6/1/1:[\u9678];[];[];[];[];[];[];[];[false];[];[\u9678]", "7/1/1:[\u67d2];[];[];[];[];[];[];[];[false];[];[\u67d2]", "8/1/1:[\u634c];[];[];[];[];[];[];[];[false];[];[\u634c]", "9/1/1:[\u7396];[];[];[];[];[];[];[];[false];[];[\u7396]", "10/10/2:[];[default];[\u62fe];[default];[];[];[];[];[true];[];[]", "100/100/3:[];[default];[\u4f70];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[\u4edf];[default];[];[];[];[];[true];[];[]", "10000/10000/5:[];[default];[\u842c];[default];[];[];[];[];[true];[];[]", "100000000/100000000/9:[];[default];[\u5104];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[\u5146];[default];[];[];[];[];[true];[];[]", "10000000000000000/10000000000000000/17:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        zhTW_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u8ca0];[];[];[];[];[];[default];[];[false];[];[]"};
        zhTW_Def.put("minus", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u6574];[];[];[];[];[];[];[];[false];[];[\u6574]", "1/1/1:[\u58f9\u5206];[];[];[];[];[];[];[];[false];[];[\u58f9\u5206]", "2/1/1:[\u8cb3\u5206];[];[];[];[];[];[];[];[false];[];[\u8cb3\u5206]", "3/1/1:[\u53c3\u5206];[];[];[];[];[];[];[];[false];[];[\u53c3\u5206]", "4/1/1:[\u8086\u5206];[];[];[];[];[];[];[];[false];[];[\u8086\u5206]", "5/1/1:[\u4f0d\u5206];[];[];[];[];[];[];[];[false];[];[\u4f0d\u5206]", "6/1/1:[\u9678\u5206];[];[];[];[];[];[];[];[false];[];[\u9678\u5206]", "7/1/1:[\u67d2\u5206];[];[];[];[];[];[];[];[false];[];[\u67d2\u5206]", "8/1/1:[\u634c\u5206];[];[];[];[];[];[];[];[false];[];[\u634c\u5206]", "9/1/1:[\u7396\u5206];[];[];[];[];[];[];[];[false];[];[\u7396\u5206]", "10/10/2:[];[default];[\u89d2];[decimal];[];[];[];[\u6574];[true];[];[]"};
        zhTW_Def.put("decimal", stringArray3);
        m_RuleDefinition.put(new Locale("zh", "TW"), zhTW_Def);
        m_RuleDefinition.put(new Locale("zh", "HK"), zhTW_Def);
        ar_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u0635\u0641\u0631];[];[];[];[];[];[];[];[false];[];[\u0635\u0641\u0631]", "1/1/1:[\u0648\u0627\u062d\u062f];[];[];[];[];[];[];[];[false];[];[\u0648\u0627\u062d\u062f]", "2/1/1:[\u0625\u062b\u0646\u0627\u0646];[];[];[];[];[];[];[];[false];[];[\u0625\u062b\u0646\u0627\u0646]", "3/1/1:[\u062b\u0644\u0627\u062b\u0629];[];[];[];[];[];[];[];[false];[];[\u062b\u0644\u0627\u062b\u0629]", "4/1/1:[\u0623\u0631\u0628\u0639\u0629];[];[];[];[];[];[];[];[false];[];[\u0623\u0631\u0628\u0639\u0629]", "5/1/1:[\u062e\u0645\u0633\u0629];[];[];[];[];[];[];[];[false];[];[\u062e\u0645\u0633\u0629]", "6/1/1:[\u0633\u062a\u0629];[];[];[];[];[];[];[];[false];[];[\u0633\u062a\u0629]", "7/1/1:[\u0633\u0628\u0639\u0629];[];[];[];[];[];[];[];[false];[];[\u0633\u0628\u0639\u0629]", "8/1/1:[\u062b\u0645\u0627\u0646\u064a\u0629];[];[];[];[];[];[];[];[false];[];[\u062b\u0645\u0627\u0646\u064a\u0629]", "9/1/1:[\u062a\u0633\u0639\u0629];[];[];[];[];[];[];[];[false];[];[\u062a\u0633\u0639\u0629]", "10/10/2:[\u0639\u0634\u0631\u0629];[];[];[];[];[];[];[];[false];[];[\u0639\u0634\u0631\u0629]", "11/10/2:[\u0623\u062d\u062f\u0639\u0634\u0631];[];[];[];[];[];[];[];[false];[];[\u0623\u062d\u062f\u0639\u0634\u0631]", "12/10/2:[\u0625\u062b\u0646\u0627 \u0639\u0634\u0631];[];[];[];[];[];[];[];[false];[];[\u0625\u062b\u0646\u0627 \u0639\u0634\u0631]", "13/10/2:[];[];[];[default-alt];[];[];[];[];[false];[ \u0639\u0634\u0631];[]", "20/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u0639\u0634\u0631\u0648\u0646];[]", "30/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u062b\u0644\u0627\u062b\u0648\u0646];[]", "40/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u0623\u0631\u0628\u0639\u0648\u0646];[]", "50/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u062e\u0645\u0633\u0648\u0646];[]", "60/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u0633\u062a\u0648\u0646];[]", "70/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u0633\u0628\u0639\u0648\u0646];[]", "80/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u062b\u0645\u0627\u0646\u0648\u0646];[]", "90/10/2:[];[];[];[default-alt];[];[ \u0648 ];[];[];[true];[\u062a\u0633\u0639\u0648\u0646];[]", "100/100/3:[\u0645\u0627\u0626\u0629];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "200/100/3:[\u0645\u0627\u0626\u062a\u0627\u0646];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "300/100/3:[];[default-alt2];[ \u0645\u0627\u0626\u0629];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "1000/1000/4:[\u0623\u0644\u0641];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "2000/1000/4:[\u0623\u0644\u0641\u0627];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "3000/1000/4:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "11000/1000/5:[];[default-alt];[ \u0623\u0644\u0641];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u0645\u0644\u064a\u0648\u0646];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt];[ \u0645\u0644\u064a\u0648\u0646\u0627];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u0645\u0644\u064a\u0627\u0631];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ \u0645\u0644\u064a\u0627\u0631];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u0628\u0644\u064a\u0648\u0646];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt];[ \u0628\u0644\u064a\u0648\u0646];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[\u0628\u0644\u064a\u0627\u0631];[];[];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ \u0628\u0644\u064a\u0627\u0631];[default-alt];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ar_Def.put("default-alt", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u0635\u0641\u0631];[];[];[];[];[];[];[];[false];[];[\u0635\u0641\u0631]", "1/1/1:[\u0648\u0627\u062d\u062f\u0629];[];[];[];[];[];[];[];[false];[];[\u0648\u0627\u062d\u062f\u0629]", "2/1/1:[\u0625\u062b\u0646\u062a\u0627\u0646];[];[];[];[];[];[];[];[false];[];[\u0625\u062b\u0646\u062a\u0627\u0646]", "3/1/1:[\u062b\u0644\u0627\u062b];[];[];[];[];[];[];[];[false];[];[\u062b\u0644\u0627\u062b]", "4/1/1:[\u0623\u0631\u0628\u0639];[];[];[];[];[];[];[];[false];[];[\u0623\u0631\u0628\u0639]", "5/1/1:[\u062e\u0645\u0633];[];[];[];[];[];[];[];[false];[];[\u062e\u0645\u0633]", "6/1/1:[\u0633\u062a];[];[];[];[];[];[];[];[false];[];[\u0633\u062a]", "7/1/1:[\u0633\u0628\u0639];[];[];[];[];[];[];[];[false];[];[\u0633\u0628\u0639]", "8/1/1:[\u062b\u0645\u0627\u0646\u064a];[];[];[];[];[];[];[];[false];[];[\u062b\u0645\u0627\u0646\u064a]", "9/1/1:[\u062a\u0633\u0639];[];[];[];[];[];[];[];[false];[];[\u062a\u0633\u0639]", "10/10/2:[\u0639\u0634\u0631];[];[];[];[];[];[];[];[false];[];[\u0639\u0634\u0631]", "11/10/2:[\u0625\u062d\u062f\u0649 \u0639\u0634\u0631];[];[];[];[];[];[];[];[false];[];[\u0625\u062d\u062f\u0649 \u0639\u0634\u0631]", "12/10/2:[\u0625\u062b\u0646\u062a\u0627 \u0639\u0634\u0631\u0629];[];[];[];[];[];[];[];[false];[];[\u0625\u062b\u0646\u062a\u0627 \u0639\u0634\u0631\u0629]", "13/10/2:[];[];[];[default-alt2];[];[];[];[];[false];[ \u0639\u0634\u0631];[]", "20/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0639\u0634\u0631\u0648\u0646];[]", "30/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062b\u0644\u0627\u062b\u0648\u0646];[]", "40/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0623\u0631\u0628\u0639\u0648\u0646];[]", "50/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062e\u0645\u0633\u0648\u0646];[]", "60/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0633\u062a\u0648\u0646];[]", "70/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0633\u0628\u0639\u0648\u0646];[]", "80/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062b\u0645\u0627\u0646\u0648\u0646];[]", "90/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062a\u0633\u0639\u0648\u0646];[]", "100/100/3:[\u0645\u0627\u0626\u0629];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "200/100/3:[\u0645\u0627\u0626\u062a\u0627\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "300/100/3:[];[default-alt];[ \u0645\u0627\u0626\u0629];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000/1000/4:[\u0623\u0644\u0641];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000/1000/4:[\u0623\u0644\u0641\u0627];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "3000/1000/4:[];[default];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "11000/1000/5:[];[default-alt];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u0645\u0644\u064a\u0648\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt];[ \u0645\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u0645\u0644\u064a\u0627\u0631];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ \u0645\u0644\u064a\u0627\u0631];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u0628\u0644\u064a\u0648\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt];[ \u0628\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[\u0628\u0644\u064a\u0627\u0631];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ \u0628\u0644\u064a\u0627\u0631];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ar_Def.put("default-alt2", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u0635\u0641\u0631];[];[];[];[];[];[];[];[false];[];[\u0635\u0641\u0631]", "1/1/1:[\u0648\u0627\u062d\u062f];[];[];[];[];[];[];[];[false];[];[\u0648\u0627\u062d\u062f]", "2/1/1:[\u0625\u062b\u0646\u0627\u0646];[];[];[];[];[];[];[];[false];[];[\u0625\u062b\u0646\u0627\u0646]", "3/1/1:[\u062b\u0644\u0627\u062b\u0629];[];[];[];[];[];[];[];[false];[];[\u062b\u0644\u0627\u062b\u0629]", "4/1/1:[\u0623\u0631\u0628\u0639\u0629];[];[];[];[];[];[];[];[false];[];[\u0623\u0631\u0628\u0639\u0629]", "5/1/1:[\u062e\u0645\u0633\u0629];[];[];[];[];[];[];[];[false];[];[\u062e\u0645\u0633\u0629]", "6/1/1:[\u0633\u062a\u0629];[];[];[];[];[];[];[];[false];[];[\u0633\u062a\u0629]", "7/1/1:[\u0633\u0628\u0639\u0629];[];[];[];[];[];[];[];[false];[];[\u0633\u0628\u0639\u0629]", "8/1/1:[\u062b\u0645\u0627\u0646\u064a\u0629];[];[];[];[];[];[];[];[false];[];[\u062b\u0645\u0627\u0646\u064a\u0629]", "9/1/1:[\u062a\u0633\u0639\u0629];[];[];[];[];[];[];[];[false];[];[\u062a\u0633\u0639\u0629]", "10/10/2:[\u0639\u0634\u0631\u0629];[];[];[];[];[];[];[];[false];[];[\u0639\u0634\u0631\u0629]", "11/10/2:[\u0623\u062d\u062f\u0639\u0634\u0631];[];[];[];[];[];[];[];[false];[];[\u0623\u062d\u062f\u0639\u0634\u0631]", "12/10/2:[\u0625\u062b\u0646\u0627 \u0639\u0634\u0631];[];[];[];[];[];[];[];[false];[];[\u0625\u062b\u0646\u0627 \u0639\u0634\u0631]", "13/10/2:[];[];[];[default];[];[];[];[];[false];[ \u0639\u0634\u0631];[]", "20/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0639\u0634\u0631\u0648\u0646];[]", "30/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062b\u0644\u0627\u062b\u0648\u0646];[]", "40/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0623\u0631\u0628\u0639\u0648\u0646];[]", "50/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062e\u0645\u0633\u0648\u0646];[]", "60/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0633\u062a\u0648\u0646];[]", "70/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u0633\u0628\u0639\u0648\u0646];[]", "80/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062b\u0645\u0627\u0646\u0648\u0646];[]", "90/10/2:[];[];[];[default];[];[ \u0648 ];[];[];[true];[\u062a\u0633\u0639\u0648\u0646];[]", "100/100/3:[\u0645\u0627\u0626\u0629];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "200/100/3:[\u0645\u0627\u0626\u062a\u0627\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "300/100/3:[];[default-alt2];[ \u0645\u0627\u0626\u0629];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000/1000/4:[\u0623\u0644\u0641];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000/1000/4:[\u0623\u0644\u0641\u0627\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "3000/1000/4:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "11000/1000/5:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "100000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "103000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "111000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "200000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "203000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "211000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "300000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "303000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "311000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "400000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "403000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "411000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "500000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "503000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "511000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "600000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "603000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "611000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "700000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "703000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "711000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "800000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "803000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "811000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "900000/1000/6:[];[default];[ \u0623\u0644\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "903000/1000/6:[];[default-alt];[ \u0622\u0644\u0627\u0641];[default];[ \u0648 ];[];[];[];[true];[];[]", "911000/1000/6:[];[default];[ \u0623\u0644\u0641\u0627];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000/1000000/7:[\u0645\u0644\u064a\u0648\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ \u0645\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "3000000/1000000/7:[];[default];[ \u0645\u0644\u0627\u064a\u064a\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "11000000/1000000/8:[];[default];[ \u0645\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u0645\u0644\u064a\u0627\u0631];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ \u0645\u0644\u064a\u0627\u0631];[default];[ \u0648 ];[];[];[];[true];[];[]", "3000000000/1000000000/10:[];[default-alt];[ \u0645\u0644\u064a\u0627\u0631\u0627\u062a];[default];[ \u0648 ];[];[];[];[true];[];[]", "11000000000/1000000000/11:[];[default-alt];[ \u0645\u0644\u064a\u0627\u0631];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u062a\u0631\u064a\u0644\u064a\u0648\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt];[ \u062a\u0631\u064a\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "3000000000000/1000000000000/13:[];[default-alt];[ \u062a\u0631\u064a\u0644\u064a\u0648\u0646\u0627\u062a];[default];[ \u0648 ];[];[];[];[true];[];[]", "11000000000000/1000000000000/14:[];[default-alt];[ \u062a\u0631\u064a\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[\u0643\u062f\u0631\u064a\u0644\u064a\u0648\u0646];[];[];[default];[ \u0648 ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ \u0643\u062f\u0631\u064a\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "3000000000000000/1000000000000000/16:[];[default-alt];[ \u0643\u062f\u0631\u064a\u0644\u064a\u0648\u0646\u0627\u062a];[default];[ \u0648 ];[];[];[];[true];[];[]", "11000000000000000/1000000000000000/17:[];[default-alt];[ \u0643\u062f\u0631\u064a\u0644\u064a\u0648\u0646];[default];[ \u0648 ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ar_Def.put("default", stringArray3);
        ar_Def.put("decimal", stringArray3);
        stringArray4 = new String[]{"0/1/1:[\u0646\u0627\u0642\u0635 ];[];[];[];[];[];[default];[];[false];[];[]"};
        ar_Def.put("minus", stringArray4);
        m_RuleDefinition.put(new Locale("ar", ""), ar_Def);
        hr_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedan];[];[];[];[];[];[];[];[false];[];[jedan]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[\u010detiri];[];[];[];[];[];[];[];[false];[];[\u010detiri]", "5/1/1:[pet];[];[];[];[];[];[];[];[false];[];[pet]", "6/1/1:[\u0161est];[];[];[];[];[];[];[];[false];[];[\u0161est]", "7/1/1:[sedam];[];[];[];[];[];[];[];[false];[];[sedam]", "8/1/1:[osam];[];[];[];[];[];[];[];[false];[];[osam]", "9/1/1:[devet];[];[];[];[];[];[];[];[false];[];[devet]", "10/10/2:[deset];[];[];[];[];[];[];[];[false];[];[deset]", "11/10/2:[jedanaest];[];[];[];[];[];[];[];[false];[];[jedanaest]", "12/10/2:[dvanaest];[];[];[];[];[];[];[];[false];[];[dvanaest]", "13/10/2:[trinaest];[];[];[];[];[];[];[];[false];[];[trinaest]", "14/10/2:[\u010detrnaest];[];[];[];[];[];[];[];[false];[];[\u010detrnaest]", "15/10/2:[petnaest];[];[];[];[];[];[];[];[false];[];[petnaest]", "16/10/2:[\u0161estnaest];[];[];[];[];[];[];[];[false];[];[\u0161estnaest]", "17/10/2:[sedamnaest];[];[];[];[];[];[];[];[false];[];[sedamnaest]", "18/10/2:[osamnaest];[];[];[];[];[];[];[];[false];[];[osamnaest]", "19/10/2:[devetnaest];[];[];[];[];[];[];[];[false];[];[devetnaest]", "20/10/2:[dvadeset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "30/10/2:[trideset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "40/10/2:[\u010detrdeset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "50/10/2:[pedeset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "60/10/2:[\u0161ezdeset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "70/10/2:[sedamdeset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "80/10/2:[osamdeset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "90/10/2:[devedeset];[];[];[decimal];[ ];[];[];[];[true];[];[]", "100/100/3:[sto];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[dvjesto];[];[];[decimal];[ ];[];[];[];[true];[];[]", "300/100/3:[tristo];[];[];[decimal];[ ];[];[];[];[true];[];[]", "400/100/3:[\u010detristo];[];[];[decimal];[ ];[];[];[];[true];[];[]", "500/100/3:[petsto];[];[];[decimal];[ ];[];[];[];[true];[];[]", "600/100/3:[\u0161esto];[];[];[decimal];[ ];[];[];[];[true];[];[]", "700/100/3:[sedamsto];[];[];[decimal];[ ];[];[];[];[true];[];[]", "800/100/3:[osamsto];[];[];[decimal];[ ];[];[];[];[true];[];[]", "900/100/3:[devetsto];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[tisu\u0107u];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt];[ tisu\u0107e];[decimal];[ ];[];[];[];[true];[];[]", "5000/1000/4:[];[default-alt];[ tisu\u0107a];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ milijun];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milijuna];[decimal];[ ];[];[];[];[true];[];[]", "5000000/1000000/7:[];[default];[ milijuna];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt];[ milijarda];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ milijarde];[decimal];[ ];[];[];[];[true];[];[]", "5000000000/1000000000/10:[];[default-alt];[ milijardi];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ bilijun];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ bilijuna];[decimal];[ ];[];[];[];[true];[];[]", "5000000000000/1000000000000/13:[];[default];[ bilijuna];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt];[ bilijarda];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ bilijarde];[decimal];[ ];[];[];[];[true];[];[]", "5000000000000000/1000000000000000/16:[];[default-alt];[ bilijardi];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        hr_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedna];[];[];[];[];[];[];[];[false];[];[jedna]", "2/1/1:[dvije];[];[];[];[];[];[];[];[false];[];[dvije]", "3/1/1:[];[];[];[];[];[];[default];[];[false];[];[]", "20/10/2:[dvadeset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "30/10/2:[trideset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "40/10/2:[\u010detrdeset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "50/10/2:[pedeset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "60/10/2:[\u0161ezdeset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "70/10/2:[sedamdeset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "80/10/2:[osamdeset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "90/10/2:[devedeset];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "100/100/3:[sto];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "200/100/3:[dvjesto];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "300/100/3:[tristo];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "400/100/3:[\u010detristo];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "500/100/3:[petsto];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "600/100/3:[\u0161esto];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "700/100/3:[sedamsto];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "800/100/3:[osamsto];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "900/100/3:[devetsto];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "1000/1000/4:[tisu\u0107u];[];[];[default-alt];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt];[ tisu\u0107e];[default-alt];[ ];[];[];[];[true];[];[]", "5000/1000/4:[];[default-alt];[ tisu\u0107a];[default-alt];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ milijun];[default-alt];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milijuna];[default-alt];[ ];[];[];[];[true];[];[]", "5000000/1000000/7:[];[default];[ milijuna];[default-alt];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt];[ milijarda];[default-alt];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ milijarde];[default-alt];[ ];[];[];[];[true];[];[]", "5000000000/1000000000/10:[];[default-alt];[ milijardi];[default-alt];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ bilijun];[default-alt];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ bilijuna];[default-alt];[ ];[];[];[];[true];[];[]", "5000000000000/1000000000000/13:[];[default];[ bilijuna];[default-alt];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt];[ bilijarda];[default-alt];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ bilijarde];[default-alt];[ ];[];[];[];[true];[];[]", "5000000000000000/1000000000000000/16:[];[default-alt];[ bilijardi];[default-alt];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        hr_Def.put("default-alt", stringArray2);
        stringArray3 = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedan];[];[];[];[];[];[];[];[false];[];[jedan]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[\u010detiri];[];[];[];[];[];[];[];[false];[];[\u010detiri]", "5/1/1:[pet];[];[];[];[];[];[];[];[false];[];[pet]", "6/1/1:[\u0161est];[];[];[];[];[];[];[];[false];[];[\u0161est]", "7/1/1:[sedam];[];[];[];[];[];[];[];[false];[];[sedam]", "8/1/1:[osam];[];[];[];[];[];[];[];[false];[];[osam]", "9/1/1:[devet];[];[];[];[];[];[];[];[false];[];[devet]", "10/10/2:[deset];[];[];[];[];[];[];[];[false];[];[deset]", "11/10/2:[jedanaest];[];[];[];[];[];[];[];[false];[];[jedanaest]", "12/10/2:[dvanaest];[];[];[];[];[];[];[];[false];[];[dvanaest]", "13/10/2:[trinaest];[];[];[];[];[];[];[];[false];[];[trinaest]", "14/10/2:[\u010detrnaest];[];[];[];[];[];[];[];[false];[];[\u010detrnaest]", "15/10/2:[petnaest];[];[];[];[];[];[];[];[false];[];[petnaest]", "16/10/2:[\u0161estnaest];[];[];[];[];[];[];[];[false];[];[\u0161estnaest]", "17/10/2:[sedamnaest];[];[];[];[];[];[];[];[false];[];[sedamnaest]", "18/10/2:[osamnaest];[];[];[];[];[];[];[];[false];[];[osamnaest]", "19/10/2:[devetnaest];[];[];[];[];[];[];[];[false];[];[devetnaest]", "20/10/2:[dvadeset];[];[];[default];[ ];[];[];[];[true];[];[]", "30/10/2:[trideset];[];[];[default];[ ];[];[];[];[true];[];[]", "40/10/2:[\u010detrdeset];[];[];[default];[ ];[];[];[];[true];[];[]", "50/10/2:[pedeset];[];[];[default];[ ];[];[];[];[true];[];[]", "60/10/2:[\u0161ezdeset];[];[];[default];[ ];[];[];[];[true];[];[]", "70/10/2:[sedamdeset];[];[];[default];[ ];[];[];[];[true];[];[]", "80/10/2:[osamdeset];[];[];[default];[ ];[];[];[];[true];[];[]", "90/10/2:[devedeset];[];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[sto];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[dvjesto];[];[];[default];[ ];[];[];[];[true];[];[]", "300/100/3:[tristo];[];[];[default];[ ];[];[];[];[true];[];[]", "400/100/3:[\u010detristo];[];[];[default];[ ];[];[];[];[true];[];[]", "500/100/3:[petsto];[];[];[default];[ ];[];[];[];[true];[];[]", "600/100/3:[\u0161esto];[];[];[default];[ ];[];[];[];[true];[];[]", "700/100/3:[sedamsto];[];[];[default];[ ];[];[];[];[true];[];[]", "800/100/3:[osamsto];[];[];[default];[ ];[];[];[];[true];[];[]", "900/100/3:[devetsto];[];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[tisu\u0107u];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt];[ tisu\u0107e];[default];[ ];[];[];[];[true];[];[]", "5000/1000/4:[];[default-alt];[ tisu\u0107a];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ milijun];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milijuna];[default];[ ];[];[];[];[true];[];[]", "5000000/1000000/7:[];[default];[ milijuna];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt];[ milijarda];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ milijarde];[default];[ ];[];[];[];[true];[];[]", "5000000000/1000000000/10:[];[default-alt];[ milijardi];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ bilijun];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ bilijuna];[default];[ ];[];[];[];[true];[];[]", "5000000000000/1000000000000/13:[];[default];[ bilijuna];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt];[ bilijarda];[default];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ bilijarde];[default];[ ];[];[];[];[true];[];[]", "5000000000000000/1000000000000000/16:[];[default-alt];[ bilijardi];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        hr_Def.put("default", stringArray3);
        stringArray4 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        hr_Def.put("minus", stringArray4);
        m_RuleDefinition.put(new Locale("hr", ""), hr_Def);
        cs_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jeden];[];[];[];[];[];[];[];[false];[];[jeden]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[];[];[];[];[];[];[default];[];[false];[];[]"};
        cs_Def.put("default-alt2", stringArray);
        stringArray2 = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedna];[];[];[];[];[];[];[];[false];[];[jedna]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[t\u0159i];[];[];[];[];[];[];[];[false];[];[t\u0159i]", "4/1/1:[\u010dty\u0159i];[];[];[];[];[];[];[];[false];[];[\u010dty\u0159i]", "5/1/1:[p\u011bt];[];[];[];[];[];[];[];[false];[];[p\u011bt]", "6/1/1:[\u0161est];[];[];[];[];[];[];[];[false];[];[\u0161est]", "7/1/1:[sedm];[];[];[];[];[];[];[];[false];[];[sedm]", "8/1/1:[osm];[];[];[];[];[];[];[];[false];[];[osm]", "9/1/1:[dev\u011bt];[];[];[];[];[];[];[];[false];[];[dev\u011bt]", "10/10/2:[deset];[];[];[];[];[];[];[];[false];[];[deset]", "11/10/2:[jeden\u00e1ct];[];[];[];[];[];[];[];[false];[];[jeden\u00e1ct]", "12/10/2:[dvan\u00e1ct];[];[];[];[];[];[];[];[false];[];[dvan\u00e1ct]", "13/10/2:[t\u0159in\u00e1ct];[];[];[];[];[];[];[];[false];[];[t\u0159in\u00e1ct]", "14/10/2:[\u010dtrn\u00e1ct];[];[];[];[];[];[];[];[false];[];[\u010dtrn\u00e1ct]", "15/10/2:[patn\u00e1ct];[];[];[];[];[];[];[];[false];[];[patn\u00e1ct]", "16/10/2:[\u0161estn\u00e1ct];[];[];[];[];[];[];[];[false];[];[\u0161estn\u00e1ct]", "17/10/2:[sedmn\u00e1ct];[];[];[];[];[];[];[];[false];[];[sedmn\u00e1ct]", "18/10/2:[osmn\u00e1ct];[];[];[];[];[];[];[];[false];[];[osmn\u00e1ct]", "19/10/2:[devaten\u00e1ct];[];[];[];[];[];[];[];[false];[];[devaten\u00e1ct]", "20/10/2:[];[default];[cet];[default];[];[];[];[];[true];[];[]", "50/10/2:[pades\u00e1t];[];[];[default];[];[];[];[];[true];[];[]", "60/10/2:[\u0161edes\u00e1t];[];[];[default];[];[];[];[];[true];[];[]", "70/10/2:[sedmdes\u00e1t];[];[];[default];[];[];[];[];[true];[];[]", "80/10/2:[osmdes\u00e1t];[];[];[default];[];[];[];[];[true];[];[]", "90/10/2:[devades\u00e1t];[];[];[default];[];[];[];[];[true];[];[]", "100/100/3:[sto];[];[];[default];[];[];[];[];[true];[];[]", "200/100/3:[];[default-alt1];[st\u011b];[default];[];[];[];[];[true];[];[]", "300/100/3:[];[default-alt1];[sta];[default];[];[];[];[];[true];[];[]", "500/100/3:[];[default-alt1];[set];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[];[default-alt2];[tis\u00edc];[default];[];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt2];[tis\u00edce];[default];[];[];[];[];[true];[];[]", "5000/1000/4:[];[default-alt2];[tis\u00edc];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default-alt2];[mili\u00f3n];[default];[];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt2];[mili\u00f3ny];[default];[];[];[];[];[true];[];[]", "5000000/1000000/7:[];[default-alt2];[mili\u00f3n\u016f];[default];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt1];[miliarda];[default];[];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt1];[miliardy];[default];[];[];[];[];[true];[];[]", "5000000000/1000000000/10:[];[default-alt1];[miliard];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default-alt2];[bili\u00f3n];[default];[];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt2];[bili\u00f3ny];[default];[];[];[];[];[true];[];[]", "5000000000000/1000000000000/13:[];[default-alt2];[bili\u00f3n\u016f];[default];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt1];[biliarda];[default];[];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt1];[biliardy];[default];[];[];[];[];[true];[];[]", "5000000000000000/1000000000000000/16:[];[default-alt1];[biliard];[default];[];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        cs_Def.put("default", stringArray2);
        stringArray3 = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedna];[];[];[];[];[];[];[];[false];[];[jedna]", "2/1/1:[dv\u011b];[];[];[];[];[];[];[];[false];[];[dv\u011b]", "3/1/1:[];[];[];[];[];[];[default];[];[false];[];[]"};
        cs_Def.put("default-alt1", stringArray3);
        cs_Def.put("decimal", stringArray2);
        stringArray4 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        cs_Def.put("minus", stringArray4);
        m_RuleDefinition.put(new Locale("cs", ""), cs_Def);
        fi_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nolla];[];[];[];[];[];[];[];[false];[];[nolla]", "1/1/1:[yksi];[];[];[];[];[];[];[];[false];[];[yksi]", "2/1/1:[kaksi];[];[];[];[];[];[];[];[false];[];[kaksi]", "3/1/1:[kolme];[];[];[];[];[];[];[];[false];[];[kolme]", "4/1/1:[nelj\u00e4];[];[];[];[];[];[];[];[false];[];[nelj\u00e4]", "5/1/1:[viisi];[];[];[];[];[];[];[];[false];[];[viisi]", "6/1/1:[kuusi];[];[];[];[];[];[];[];[false];[];[kuusi]", "7/1/1:[seitsem\u00e4n];[];[];[];[];[];[];[];[false];[];[seitsem\u00e4n]", "8/1/1:[kahdeksan];[];[];[];[];[];[];[];[false];[];[kahdeksan]", "9/1/1:[yhdeks\u00e4n];[];[];[];[];[];[];[];[false];[];[yhdeks\u00e4n]", "10/10/2:[kymmenen];[];[];[];[];[];[];[];[false];[];[kymmenen]", "11/10/2:[];[];[];[decimal];[];[];[];[];[false];[toista];[]", "20/10/2:[];[decimal];[kymment\u00e4];[decimal];[\u00ad];[];[];[];[true];[];[]", "100/100/3:[];[];[sata];[decimal];[\u00ad];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[sataa];[decimal];[\u00ad];[];[];[];[true];[];[]", "1000/1000/4:[];[];[tuhat];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[decimal];[\u00adtuhatta];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[];[miljoona];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[decimal];[ miljoonaa];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[];[miljardi];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[decimal];[ miljardia];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[biljoona];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[decimal];[ biljoonan];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[biljardi];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[decimal];[ biljardin];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        fi_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[nolla];[];[];[];[];[];[];[];[false];[];[nolla]", "1/1/1:[yksi];[];[];[];[];[];[];[];[false];[];[yksi]", "2/1/1:[kaksi];[];[];[];[];[];[];[];[false];[];[kaksi]", "3/1/1:[kolme];[];[];[];[];[];[];[];[false];[];[kolme]", "4/1/1:[nelj\u00e4];[];[];[];[];[];[];[];[false];[];[nelj\u00e4]", "5/1/1:[viisi];[];[];[];[];[];[];[];[false];[];[viisi]", "6/1/1:[kuusi];[];[];[];[];[];[];[];[false];[];[kuusi]", "7/1/1:[seitsem\u00e4n];[];[];[];[];[];[];[];[false];[];[seitsem\u00e4n]", "8/1/1:[kahdeksan];[];[];[];[];[];[];[];[false];[];[kahdeksan]", "9/1/1:[yhdeks\u00e4n];[];[];[];[];[];[];[];[false];[];[yhdeks\u00e4n]", "10/10/2:[kymmenen];[];[];[];[];[];[];[];[false];[];[kymmenen]", "11/10/2:[];[];[];[default];[];[];[];[];[false];[toista];[]", "20/10/2:[];[default];[kymment\u00e4];[default];[\u00ad];[];[];[];[true];[];[]", "100/100/3:[];[];[sata];[default];[\u00ad];[];[];[];[true];[];[]", "200/100/3:[];[default];[sataa];[default];[\u00ad];[];[];[];[true];[];[]", "1000/1000/4:[];[];[tuhat];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[\u00adtuhatta];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[];[miljoona];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ miljoonaa];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[];[miljardi];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ miljardia];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[biljoona];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ biljoonan];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[biljardi];[default];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ biljardin];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        fi_Def.put("default", stringArray2);
        stringArray3 = new String[]{"0/1/1:[miinus ];[];[];[];[];[];[default];[];[false];[];[]"};
        fi_Def.put("minus", stringArray3);
        m_RuleDefinition.put(new Locale("fi", ""), fi_Def);
        el_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u03bc\u03b7\u03b4\u03ad\u03bd];[];[];[];[];[];[];[];[false];[];[\u03bc\u03b7\u03b4\u03ad\u03bd]", "1/1/1:[\u03ad\u03bd\u03b1];[];[];[];[];[];[];[];[false];[];[\u03ad\u03bd\u03b1]", "2/1/1:[\u03b4\u03cd\u03bf];[];[];[];[];[];[];[];[false];[];[\u03b4\u03cd\u03bf]", "3/1/1:[\u03c4\u03c1\u03af\u03b1];[];[];[];[];[];[];[];[false];[];[\u03c4\u03c1\u03af\u03b1]", "4/1/1:[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1];[];[];[];[];[];[];[];[false];[];[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1]", "5/1/1:[\u03c0\u03ad\u03bd\u03c4\u03b5];[];[];[];[];[];[];[];[false];[];[\u03c0\u03ad\u03bd\u03c4\u03b5]", "6/1/1:[\u03ad\u03be\u03b9];[];[];[];[];[];[];[];[false];[];[\u03ad\u03be\u03b9]", "7/1/1:[\u03b5\u03c0\u03c4\u03ac];[];[];[];[];[];[];[];[false];[];[\u03b5\u03c0\u03c4\u03ac]", "8/1/1:[\u03bf\u03ba\u03c4\u03ce];[];[];[];[];[];[];[];[false];[];[\u03bf\u03ba\u03c4\u03ce]", "9/1/1:[\u03b5\u03bd\u03bd\u03ad\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b5\u03bd\u03bd\u03ad\u03b1]", "10/10/2:[\u03b4\u03ad\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ad\u03ba\u03b1]", "11/10/2:[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1]", "12/10/2:[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1]", "13/10/2:[\u03b4\u03b5\u03ba\u03b1\u00ad];[];[];[decimal];[];[];[];[];[false];[];[]", "20/10/2:[\u03b5\u03af\u03ba\u03bf\u03c3\u03b9];[];[];[decimal];[ ];[];[];[];[true];[];[]", "30/10/2:[\u03c4\u03c1\u03b9\u03ac\u03bd\u03c4\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "40/10/2:[\u03c3\u03b1\u03c1\u03ac\u03bd\u03c4\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "50/10/2:[\u03c0\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "60/10/2:[\u03b5\u03be\u03ae\u03bd\u03c4\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "70/10/2:[\u03b5\u03b2\u03b4\u03bf\u03bc\u03ae\u03bd\u03c4\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "80/10/2:[\u03bf\u03b3\u03b4\u03cc\u03bd\u03c4\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "90/10/2:[\u03b5\u03bd\u03bd\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "100/100/3:[\u03b5\u03ba\u03b1\u03c4\u03cc];[];[];[decimal];[\u03bd ];[];[];[];[true];[];[]", "200/100/3:[\u03b4\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "300/100/3:[\u03c4\u03c1\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "400/100/3:[\u03c4\u03b5\u03c4\u03c1\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "500/100/3:[\u03c0\u03b5\u03bd\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "600/100/3:[\u03b5\u03be\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "700/100/3:[\u03b5\u03c0\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "800/100/3:[\u03bf\u03ba\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "900/100/3:[\u03b5\u03bd\u03bd\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u03c7\u03b9\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt1];[ \u03c7\u03af\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        el_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u03bc\u03b7\u03b4\u03ad\u03bd];[];[];[];[];[];[];[];[false];[];[\u03bc\u03b7\u03b4\u03ad\u03bd]", "1/1/1:[\u03ad\u03bd\u03b1\u03c2];[];[];[];[];[];[];[];[false];[];[\u03ad\u03bd\u03b1\u03c2]", "2/1/1:[\u03b4\u03cd\u03bf];[];[];[];[];[];[];[];[false];[];[\u03b4\u03cd\u03bf]", "3/1/1:[\u03c4\u03c1\u03b5\u03b9\u03c2];[];[];[];[];[];[];[];[false];[];[\u03c4\u03c1\u03b5\u03b9\u03c2]", "4/1/1:[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b9\u03c2];[];[];[];[];[];[];[];[false];[];[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b9\u03c2]", "5/1/1:[\u03c0\u03ad\u03bd\u03c4\u03b5];[];[];[];[];[];[];[];[false];[];[\u03c0\u03ad\u03bd\u03c4\u03b5]", "6/1/1:[\u03ad\u03be\u03b9];[];[];[];[];[];[];[];[false];[];[\u03ad\u03be\u03b9]", "7/1/1:[\u03b5\u03c0\u03c4\u03ac];[];[];[];[];[];[];[];[false];[];[\u03b5\u03c0\u03c4\u03ac]", "8/1/1:[\u03bf\u03ba\u03c4\u03ce];[];[];[];[];[];[];[];[false];[];[\u03bf\u03ba\u03c4\u03ce]", "9/1/1:[\u03b5\u03bd\u03bd\u03ad\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b5\u03bd\u03bd\u03ad\u03b1]", "10/10/2:[\u03b4\u03ad\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ad\u03ba\u03b1]", "11/10/2:[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1]", "12/10/2:[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1]", "13/10/2:[\u03b4\u03b5\u03ba\u03b1\u00ad];[];[];[default-alt2];[];[];[];[];[false];[];[]", "20/10/2:[\u03b5\u03af\u03ba\u03bf\u03c3\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "30/10/2:[\u03c4\u03c1\u03b9\u03ac\u03bd\u03c4\u03b1];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "40/10/2:[\u03c3\u03b1\u03c1\u03ac\u03bd\u03c4\u03b1];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "50/10/2:[\u03c0\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "60/10/2:[\u03b5\u03be\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "70/10/2:[\u03b5\u03b2\u03b4\u03bf\u03bc\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "80/10/2:[\u03bf\u03b3\u03b4\u03cc\u03bd\u03c4\u03b1];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "90/10/2:[\u03b5\u03bd\u03bd\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "100/100/3:[\u03b5\u03ba\u03b1\u03c4\u03cc];[];[];[default-alt2];[\u03bd ];[];[];[];[true];[];[]", "200/100/3:[\u03b4\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "300/100/3:[\u03c4\u03c1\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "400/100/3:[\u03c4\u03b5\u03c4\u03c1\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "500/100/3:[\u03c0\u03b5\u03bd\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "600/100/3:[\u03b5\u03be\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "700/100/3:[\u03b5\u03c0\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "800/100/3:[\u03bf\u03ba\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "900/100/3:[\u03b5\u03bd\u03bd\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03bf\u03b9];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u03c7\u03b9\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt1];[ \u03c7\u03af\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        el_Def.put("default-alt2", stringArray2);
        stringArray3 = new String[]{"0/1/1:[\u03bc\u03b7\u03b4\u03ad\u03bd];[];[];[];[];[];[];[];[false];[];[\u03bc\u03b7\u03b4\u03ad\u03bd]", "1/1/1:[\u03bc\u03af\u03b1];[];[];[];[];[];[];[];[false];[];[\u03bc\u03af\u03b1]", "2/1/1:[\u03b4\u03cd\u03bf];[];[];[];[];[];[];[];[false];[];[\u03b4\u03cd\u03bf]", "3/1/1:[\u03c4\u03c1\u03b5\u03b9\u03c2];[];[];[];[];[];[];[];[false];[];[\u03c4\u03c1\u03b5\u03b9\u03c2]", "4/1/1:[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b9\u03c2];[];[];[];[];[];[];[];[false];[];[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b9\u03c2]", "5/1/1:[\u03c0\u03ad\u03bd\u03c4\u03b5];[];[];[];[];[];[];[];[false];[];[\u03c0\u03ad\u03bd\u03c4\u03b5]", "6/1/1:[\u03ad\u03be\u03b9];[];[];[];[];[];[];[];[false];[];[\u03ad\u03be\u03b9]", "7/1/1:[\u03b5\u03c0\u03c4\u03ac];[];[];[];[];[];[];[];[false];[];[\u03b5\u03c0\u03c4\u03ac]", "8/1/1:[\u03bf\u03ba\u03c4\u03ce];[];[];[];[];[];[];[];[false];[];[\u03bf\u03ba\u03c4\u03ce]", "9/1/1:[\u03b5\u03bd\u03bd\u03ad\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b5\u03bd\u03bd\u03ad\u03b1]", "10/10/2:[\u03b4\u03ad\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ad\u03ba\u03b1]", "11/10/2:[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1]", "12/10/2:[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1]", "13/10/2:[\u03b4\u03b5\u03ba\u03b1\u00ad];[];[];[default-alt1];[];[];[];[];[false];[];[]", "20/10/2:[\u03b5\u03af\u03ba\u03bf\u03c3\u03b9];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "30/10/2:[\u03c4\u03c1\u03b9\u03ac\u03bd\u03c4\u03b1];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "40/10/2:[\u03c3\u03b1\u03c1\u03ac\u03bd\u03c4\u03b1];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "50/10/2:[\u03c0\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "60/10/2:[\u03b5\u03be\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "70/10/2:[\u03b5\u03b2\u03b4\u03bf\u03bc\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "80/10/2:[\u03bf\u03b3\u03b4\u03cc\u03bd\u03c4\u03b1];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "90/10/2:[\u03b5\u03bd\u03bd\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "100/100/3:[\u03b5\u03ba\u03b1\u03c4\u03cc];[];[];[default-alt1];[\u03bd ];[];[];[];[true];[];[]", "200/100/3:[\u03b4\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "300/100/3:[\u03c4\u03c1\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "400/100/3:[\u03c4\u03b5\u03c4\u03c1\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "500/100/3:[\u03c0\u03b5\u03bd\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "600/100/3:[\u03b5\u03be\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "700/100/3:[\u03b5\u03c0\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "800/100/3:[\u03bf\u03ba\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "900/100/3:[\u03b5\u03bd\u03bd\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u03c7\u03b9\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt1];[ \u03c7\u03af\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        el_Def.put("default-alt1", stringArray3);
        stringArray4 = new String[]{"0/1/1:[\u03bc\u03b7\u03b4\u03ad\u03bd];[];[];[];[];[];[];[];[false];[];[\u03bc\u03b7\u03b4\u03ad\u03bd]", "1/1/1:[\u03ad\u03bd\u03b1];[];[];[];[];[];[];[];[false];[];[\u03ad\u03bd\u03b1]", "2/1/1:[\u03b4\u03cd\u03bf];[];[];[];[];[];[];[];[false];[];[\u03b4\u03cd\u03bf]", "3/1/1:[\u03c4\u03c1\u03af\u03b1];[];[];[];[];[];[];[];[false];[];[\u03c4\u03c1\u03af\u03b1]", "4/1/1:[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1];[];[];[];[];[];[];[];[false];[];[\u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1]", "5/1/1:[\u03c0\u03ad\u03bd\u03c4\u03b5];[];[];[];[];[];[];[];[false];[];[\u03c0\u03ad\u03bd\u03c4\u03b5]", "6/1/1:[\u03ad\u03be\u03b9];[];[];[];[];[];[];[];[false];[];[\u03ad\u03be\u03b9]", "7/1/1:[\u03b5\u03c0\u03c4\u03ac];[];[];[];[];[];[];[];[false];[];[\u03b5\u03c0\u03c4\u03ac]", "8/1/1:[\u03bf\u03ba\u03c4\u03ce];[];[];[];[];[];[];[];[false];[];[\u03bf\u03ba\u03c4\u03ce]", "9/1/1:[\u03b5\u03bd\u03bd\u03ad\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b5\u03bd\u03bd\u03ad\u03b1]", "10/10/2:[\u03b4\u03ad\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ad\u03ba\u03b1]", "11/10/2:[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03ad\u03bd\u03c4\u03b5\u03ba\u03b1]", "12/10/2:[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1];[];[];[];[];[];[];[];[false];[];[\u03b4\u03ce\u03b4\u03b5\u03ba\u03b1]", "13/10/2:[\u03b4\u03b5\u03ba\u03b1\u00ad];[];[];[default];[];[];[];[];[false];[];[]", "20/10/2:[\u03b5\u03af\u03ba\u03bf\u03c3\u03b9];[];[];[default];[ ];[];[];[];[true];[];[]", "30/10/2:[\u03c4\u03c1\u03b9\u03ac\u03bd\u03c4\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "40/10/2:[\u03c3\u03b1\u03c1\u03ac\u03bd\u03c4\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "50/10/2:[\u03c0\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "60/10/2:[\u03b5\u03be\u03ae\u03bd\u03c4\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "70/10/2:[\u03b5\u03b2\u03b4\u03bf\u03bc\u03ae\u03bd\u03c4\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "80/10/2:[\u03bf\u03b3\u03b4\u03cc\u03bd\u03c4\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "90/10/2:[\u03b5\u03bd\u03bd\u03b5\u03bd\u03ae\u03bd\u03c4\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[\u03b5\u03ba\u03b1\u03c4\u03cc];[];[];[default];[\u03bd ];[];[];[];[true];[];[]", "200/100/3:[\u03b4\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "300/100/3:[\u03c4\u03c1\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "400/100/3:[\u03c4\u03b5\u03c4\u03c1\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "500/100/3:[\u03c0\u03b5\u03bd\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "600/100/3:[\u03b5\u03be\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "700/100/3:[\u03b5\u03c0\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "800/100/3:[\u03bf\u03ba\u03c4\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "900/100/3:[\u03b5\u03bd\u03bd\u03b9\u03b1\u03ba\u03cc\u03c3\u03b9\u03b1];[];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u03c7\u03b9\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt1];[ \u03c7\u03af\u03bb\u03b9\u03ac\u03b4\u03b5\u03c2];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ \u03b4\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[ \u03c4\u03c1\u03b9\u03c3\u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03bf];[default];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ \u03c4\u03b5\u03c4\u03c1\u03ac\u03ba\u03b9\u03c2 \u03b5\u03ba\u03b1\u03c4\u03bf\u03bc\u03bc\u03cd\u03c1\u03b9\u03b1];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        el_Def.put("default", stringArray4);
        stringArray5 = new String[]{"0/1/1:[\u03bc\u03b5\u03af\u03bf\u03bd ];[];[];[];[];[];[default];[];[false];[];[]"};
        el_Def.put("minus", stringArray5);
        m_RuleDefinition.put(new Locale("el", ""), el_Def);
        hu_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nulla];[];[];[];[];[];[];[];[false];[];[nulla]", "1/1/1:[egy];[];[];[];[];[];[];[];[false];[];[egy]", "2/1/1:[kett\u0151];[];[];[];[];[];[];[];[false];[];[kett\u0151]", "3/1/1:[h\u00e1rom];[];[];[];[];[];[];[];[false];[];[h\u00e1rom]", "4/1/1:[n\u00e9gy];[];[];[];[];[];[];[];[false];[];[n\u00e9gy]", "5/1/1:[\u00f6t];[];[];[];[];[];[];[];[false];[];[\u00f6t]", "6/1/1:[hat];[];[];[];[];[];[];[];[false];[];[hat]", "7/1/1:[h\u00e9t];[];[];[];[];[];[];[];[false];[];[h\u00e9t]", "8/1/1:[nyolc];[];[];[];[];[];[];[];[false];[];[nyolc]", "9/1/1:[kilenc];[];[];[];[];[];[];[];[false];[];[kilenc]", "10/10/2:[t\u00edz];[];[];[];[];[];[];[];[false];[];[t\u00edz]", "11/10/2:[tizen\u00ad];[];[];[default];[];[];[];[];[false];[];[]", "20/10/2:[h\u00fasz];[];[];[];[];[];[];[];[false];[];[h\u00fasz]", "21/10/2:[huszon\u00ad];[];[];[default];[];[];[];[];[false];[];[]", "30/10/2:[harminc];[];[];[default];[\u00ad];[];[];[];[true];[];[]", "40/10/2:[negyven];[];[];[default];[\u00ad];[];[];[];[true];[];[]", "50/10/2:[\u00f6tven];[];[];[default];[\u00ad];[];[];[];[true];[];[]", "60/10/2:[hatvan];[];[];[default];[\u00ad];[];[];[];[true];[];[]", "70/10/2:[hetven];[];[];[default];[\u00ad];[];[];[];[true];[];[]", "80/10/2:[nyolcvan];[];[];[default];[\u00ad];[];[];[];[true];[];[]", "90/10/2:[kilencven];[];[];[default];[\u00ad];[];[];[];[true];[];[]", "100/100/3:[];[default];[\u00adsz\u00e1z];[default];[\u00ad];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[\u00adezer];[default];[-];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[milli\u00f3];[default];[-];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[milli\u00e1rd];[default];[-];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[billi\u00f3];[default];[-];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[billi\u00e1rd];[default];[-];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        hu_Def.put("default", stringArray);
        hu_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[minusz ];[];[];[];[];[];[default];[];[false];[];[]"};
        hu_Def.put("minus", stringArray2);
        m_RuleDefinition.put(new Locale("hu", ""), hu_Def);
        sr_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[\u0458\u0435\u0434\u043d\u0430];[];[];[];[];[];[];[];[false];[];[\u0458\u0435\u0434\u043d\u0430]", "2/1/1:[\u0434\u0432\u0435];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0435]", "3/1/1:[\u0442\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438]", "4/1/1:[\u0447\u0435\u0442\u0438\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u0438\u0440\u0438]", "5/1/1:[\u043f\u0435\u0442];[];[];[];[];[];[];[];[false];[];[\u043f\u0435\u0442]", "6/1/1:[\u0448\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u0442]", "7/1/1:[\u0441\u0435\u0434\u0430\u043c];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u0434\u0430\u043c]", "8/1/1:[\u043e\u0441\u0430\u043c];[];[];[];[];[];[];[];[false];[];[\u043e\u0441\u0430\u043c]", "9/1/1:[\u0434\u0435\u0432\u0435\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u0435\u0442]", "10/10/2:[\u0434\u0435\u0441\u0435\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0441\u0435\u0442]", "11/10/2:[\u0458\u0435\u0434\u0430\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0458\u0435\u0434\u0430\u043d\u0430\u0435\u0441\u0442]", "12/10/2:[\u0434\u0432\u0430\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430\u043d\u0430\u0435\u0441\u0442]", "13/10/2:[\u0442\u0440\u0438\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438\u043d\u0430\u0435\u0441\u0442]", "14/10/2:[\u0447\u0435\u0442\u0440\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u0440\u043d\u0430\u0435\u0441\u0442]", "15/10/2:[\u043f\u0435\u0442\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u043f\u0435\u0442\u043d\u0430\u0435\u0441\u0442]", "16/10/2:[\u0448\u0435\u0441\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u043d\u0430\u0435\u0441\u0442]", "17/10/2:[\u0441\u0435\u0434\u0430\u043c\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u0434\u0430\u043c\u043d\u0430\u0435\u0441\u0442]", "18/10/2:[\u043e\u0441\u0430\u043c\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u043e\u0441\u0430\u043c\u043d\u0430\u0435\u0441\u0442]", "19/10/2:[\u0434\u0435\u0432\u0435\u0442\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u0435\u0442\u043d\u0430\u0435\u0441\u0442]"};
        sr_Def.put("default-alt", stringArray);
        stringArray2 = new String[]{"2/1/1:[\u0434\u0432\u0430\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "3/1/1:[\u0442\u0440\u0438\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "4/1/1:[\u0447\u0435\u0442\u0440\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "5/1/1:[\u043f\u0435\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "6/1/1:[\u0448\u0435\u0437\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "7/1/1:[\u0441\u0435\u0434\u0430\u043c\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "8/1/1:[\u043e\u0441\u0430\u043c\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]", "9/1/1:[\u0434\u0435\u0432\u0435\u0434\u0435\u0441\u0435\u0442];[];[];[];[ ];[];[];[];[true];[];[]"};
        sr_Def.put("tenth", stringArray2);
        stringArray3 = new String[]{"1/1/1:[\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]", "2/1/1:[\u0434\u0432\u0435\u0441\u0442\u0430];[];[];[];[ ];[];[];[];[true];[];[]", "3/1/1:[\u0442\u0440\u0438\u0441\u0442\u0430];[];[];[];[ ];[];[];[];[true];[];[]", "4/1/1:[\u0447\u0435\u0442\u0438\u0440\u0438\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]", "5/1/1:[\u043f\u0435\u0442\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]", "6/1/1:[\u0448\u0435\u0441\u0442\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]", "7/1/1:[\u0441\u0435\u0434\u0430\u043c\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]", "8/1/1:[\u043e\u0441\u0430\u043c\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]", "9/1/1:[\u0434\u0435\u0432\u0435\u0442\u0441\u0442\u043e];[];[];[];[ ];[];[];[];[true];[];[]"};
        sr_Def.put("hundreds", stringArray3);
        stringArray4 = new String[]{"1/1/1:[];[default-alt];[ \u0445\u0438\u0459\u0430\u0434\u0430];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default-alt];[ \u0445\u0438\u0459\u0430\u0434\u0435];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default-alt];[ \u0445\u0438\u0459\u0430\u0434\u0430];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[thousands];[];[];[];[\u0445\u0438\u0459\u0430\u0434\u0430];[true];[];[]", "100/100/3:[];[hundreds];[ ];[thousands];[];[];[];[\u0445\u0438\u0459\u0430\u0434\u0430];[true];[];[]"};
        sr_Def.put("thousands", stringArray4);
        stringArray5 = new String[]{"1/1/1:[];[default];[ \u043c\u0438\u043b\u0438\u043e\u043d];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ \u043c\u0438\u043b\u0438\u043e\u043d\u0430];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[millions];[];[];[];[\u043c\u0438\u043b\u0438\u043e\u043d\u0430];[true];[];[]", "100/100/3:[];[hundreds];[ ];[millions];[];[];[];[\u043c\u0438\u043b\u0438\u043e\u043d\u0430];[true];[];[]"};
        sr_Def.put("millions", stringArray5);
        stringArray6 = new String[]{"1/1/1:[];[default-alt];[ \u043c\u0438\u043b\u0438\u0458\u0430\u0440\u0434\u0430];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default-alt];[ \u043c\u0438\u043b\u0438\u0458\u0430\u0440\u0434\u0435];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default-alt];[ \u043c\u0438\u043b\u0438\u0458\u0430\u0440\u0434\u0438];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[billions];[];[];[];[\u043c\u0438\u043b\u0438\u0458\u0430\u0440\u0434\u0438];[true];[];[]", "100/100/3:[];[hundreds];[ ];[billions];[];[];[];[\u043c\u0438\u043b\u0438\u0458\u0430\u0440\u0434\u0438];[true];[];[]"};
        sr_Def.put("billions", stringArray6);
        stringArray7 = new String[]{"1/1/1:[];[default];[ \u0431\u0438\u043b\u0438\u043e\u043d];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ \u0431\u0438\u043b\u0438\u043e\u043d\u0430];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[trillions];[];[];[];[\u0431\u0438\u043b\u0438\u043e\u043d\u0430];[true];[];[]", "100/100/3:[];[hundreds];[ ];[trillions];[];[];[];[\u0431\u0438\u043b\u0438\u043e\u043d\u0430];[true];[];[]"};
        sr_Def.put("trillions", stringArray7);
        stringArray8 = new String[]{"1/1/1:[];[default];[ \u0442\u0440\u0438\u043b\u0438\u043e\u043d];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ \u0442\u0440\u0438\u043b\u0438\u043e\u043d\u0430];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[quadrillions];[];[];[];[\u0442\u0440\u0438\u043b\u0438\u043e\u043d\u0430];[true];[];[]", "100/100/3:[];[hundreds];[ ];[quadrillions];[];[];[];[\u0442\u0440\u0438\u043b\u0438\u043e\u043d\u0430];[true];[];[]"};
        sr_Def.put("quadrillions", stringArray8);
        stringArray9 = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[\u0458\u0435\u0434\u0430\u043d];[];[];[];[];[];[];[];[false];[];[\u0458\u0435\u0434\u0430\u043d]", "2/1/1:[\u0434\u0432\u0430];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430]", "3/1/1:[\u0442\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438]", "4/1/1:[\u0447\u0435\u0442\u0438\u0440\u0438];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u0438\u0440\u0438]", "5/1/1:[\u043f\u0435\u0442];[];[];[];[];[];[];[];[false];[];[\u043f\u0435\u0442]", "6/1/1:[\u0448\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u0442]", "7/1/1:[\u0441\u0435\u0434\u0430\u043c];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u0434\u0430\u043c]", "8/1/1:[\u043e\u0441\u0430\u043c];[];[];[];[];[];[];[];[false];[];[\u043e\u0441\u0430\u043c]", "9/1/1:[\u0434\u0435\u0432\u0435\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u0435\u0442]", "10/10/2:[\u0434\u0435\u0441\u0435\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0441\u0435\u0442]", "11/10/2:[\u0458\u0435\u0434\u0430\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0458\u0435\u0434\u0430\u043d\u0430\u0435\u0441\u0442]", "12/10/2:[\u0434\u0432\u0430\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0432\u0430\u043d\u0430\u0435\u0441\u0442]", "13/10/2:[\u0442\u0440\u0438\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0442\u0440\u0438\u043d\u0430\u0435\u0441\u0442]", "14/10/2:[\u0447\u0435\u0442\u0440\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0447\u0435\u0442\u0440\u043d\u0430\u0435\u0441\u0442]", "15/10/2:[\u043f\u0435\u0442\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u043f\u0435\u0442\u043d\u0430\u0435\u0441\u0442]", "16/10/2:[\u0448\u0435\u0441\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0448\u0435\u0441\u043d\u0430\u0435\u0441\u0442]", "17/10/2:[\u0441\u0435\u0434\u0430\u043c\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u0434\u0430\u043c\u043d\u0430\u0435\u0441\u0442]", "18/10/2:[\u043e\u0441\u0430\u043c\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u043e\u0441\u0430\u043c\u043d\u0430\u0435\u0441\u0442]", "19/10/2:[\u0434\u0435\u0432\u0435\u0442\u043d\u0430\u0435\u0441\u0442];[];[];[];[];[];[];[];[false];[];[\u0434\u0435\u0432\u0435\u0442\u043d\u0430\u0435\u0441\u0442]", "20/10/2:[];[tenth];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[];[hundreds];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[quadrillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sr_Def.put("default", stringArray9);
        stringArray10 = new String[]{"0/1/1:[];[];[];[];[];[];[default];[];[false];[ \u0441\u0442\u043e\u0442\u0438\u0445];[]"};
        sr_Def.put("decimal", stringArray10);
        stringArray11 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        sr_Def.put("minus", stringArray11);
        m_RuleDefinition.put(new Locale("sr", ""), sr_Def);
        sh_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedna];[];[];[];[];[];[];[];[false];[];[jedna]", "2/1/1:[dve];[];[];[];[];[];[];[];[false];[];[dve]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[\u010detiri];[];[];[];[];[];[];[];[false];[];[\u010detiri]", "5/1/1:[pet];[];[];[];[];[];[];[];[false];[];[pet]", "6/1/1:[\u0161est];[];[];[];[];[];[];[];[false];[];[\u0161est]", "7/1/1:[sedam];[];[];[];[];[];[];[];[false];[];[sedam]", "8/1/1:[osam];[];[];[];[];[];[];[];[false];[];[osam]", "9/1/1:[devet];[];[];[];[];[];[];[];[false];[];[devet]", "10/10/2:[deset];[];[];[];[];[];[];[];[false];[];[deset]", "11/10/2:[jedanaest];[];[];[];[];[];[];[];[false];[];[jedanaest]", "12/10/2:[dvanaest];[];[];[];[];[];[];[];[false];[];[dvanaest]", "13/10/2:[trinaest];[];[];[];[];[];[];[];[false];[];[trinaest]", "14/10/2:[\u010detrnaest];[];[];[];[];[];[];[];[false];[];[\u010detrnaest]", "15/10/2:[petnaest];[];[];[];[];[];[];[];[false];[];[petnaest]", "16/10/2:[\u0161esnaest];[];[];[];[];[];[];[];[false];[];[\u0161esnaest]", "17/10/2:[sedamnaest];[];[];[];[];[];[];[];[false];[];[sedamnaest]", "18/10/2:[osamnaest];[];[];[];[];[];[];[];[false];[];[osamnaest]", "19/10/2:[devetnaest];[];[];[];[];[];[];[];[false];[];[devetnaest]"};
        sh_Def.put("default-alt", stringArray);
        stringArray2 = new String[]{"2/1/1:[dvadeset];[];[];[];[ ];[];[];[];[true];[];[]", "3/1/1:[trideset];[];[];[];[ ];[];[];[];[true];[];[]", "4/1/1:[\u010detrdeset];[];[];[];[ ];[];[];[];[true];[];[]", "5/1/1:[pedeset];[];[];[];[ ];[];[];[];[true];[];[]", "6/1/1:[\u0161ezdeset];[];[];[];[ ];[];[];[];[true];[];[]", "7/1/1:[sedamdeset];[];[];[];[ ];[];[];[];[true];[];[]", "8/1/1:[osamdeset];[];[];[];[ ];[];[];[];[true];[];[]", "9/1/1:[devedeset];[];[];[];[ ];[];[];[];[true];[];[]"};
        sh_Def.put("tenth", stringArray2);
        stringArray3 = new String[]{"1/1/1:[sto];[];[];[];[ ];[];[];[];[true];[];[]", "2/1/1:[dvesta];[];[];[];[ ];[];[];[];[true];[];[]", "3/1/1:[trista];[];[];[];[ ];[];[];[];[true];[];[]", "4/1/1:[\u010detiristo];[];[];[];[ ];[];[];[];[true];[];[]", "5/1/1:[petsto];[];[];[];[ ];[];[];[];[true];[];[]", "6/1/1:[\u0161eststo];[];[];[];[ ];[];[];[];[true];[];[]", "7/1/1:[sedamsto];[];[];[];[ ];[];[];[];[true];[];[]", "8/1/1:[osamsto];[];[];[];[ ];[];[];[];[true];[];[]", "9/1/1:[devetsto];[];[];[];[ ];[];[];[];[true];[];[]"};
        sh_Def.put("hundreds", stringArray3);
        stringArray4 = new String[]{"1/1/1:[];[default-alt];[ hiljada];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default-alt];[ hiljade];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default-alt];[ hiljada];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[thousands];[];[];[];[hiljada];[true];[];[]", "100/100/3:[];[hundreds];[ ];[thousands];[];[];[];[hiljada];[true];[];[]"};
        sh_Def.put("thousands", stringArray4);
        stringArray5 = new String[]{"1/1/1:[];[default];[ milion];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ miliona];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[millions];[];[];[];[miliona];[true];[];[]", "100/100/3:[];[hundreds];[ ];[millions];[];[];[];[miliona];[true];[];[]"};
        sh_Def.put("millions", stringArray5);
        stringArray6 = new String[]{"1/1/1:[];[default-alt];[ milijarda];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default-alt];[ milijarde];[];[];[];[];[];[false];[];[]", "5/1/1:[];[default-alt];[ milijardi];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[billions];[];[];[];[milijardi];[true];[];[]", "100/100/3:[];[hundreds];[ ];[billions];[];[];[];[milijardi];[true];[];[]"};
        sh_Def.put("billions", stringArray6);
        stringArray7 = new String[]{"1/1/1:[];[default];[ bilion];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ biliona];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[trillions];[];[];[];[biliona];[true];[];[]", "100/100/3:[];[hundreds];[ ];[trillions];[];[];[];[biliona];[true];[];[]"};
        sh_Def.put("trillions", stringArray7);
        stringArray8 = new String[]{"1/1/1:[];[default];[ trilion];[];[];[];[];[];[false];[];[]", "2/1/1:[];[default];[ triliona];[];[];[];[];[];[false];[];[]", "20/10/2:[];[tenth];[ ];[quadrillions];[];[];[];[triliona];[true];[];[]", "100/100/3:[];[hundreds];[ ];[quadrillions];[];[];[];[triliona];[true];[];[]"};
        sh_Def.put("quadrillions", stringArray8);
        stringArray9 = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedan];[];[];[];[];[];[];[];[false];[];[jedan]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[\u010detiri];[];[];[];[];[];[];[];[false];[];[\u010detiri]", "5/1/1:[pet];[];[];[];[];[];[];[];[false];[];[pet]", "6/1/1:[\u0161est];[];[];[];[];[];[];[];[false];[];[\u0161est]", "7/1/1:[sedam];[];[];[];[];[];[];[];[false];[];[sedam]", "8/1/1:[osam];[];[];[];[];[];[];[];[false];[];[osam]", "9/1/1:[devet];[];[];[];[];[];[];[];[false];[];[devet]", "10/10/2:[deset];[];[];[];[];[];[];[];[false];[];[deset]", "11/10/2:[jedanaest];[];[];[];[];[];[];[];[false];[];[jedanaest]", "12/10/2:[dvanaest];[];[];[];[];[];[];[];[false];[];[dvanaest]", "13/10/2:[trinaest];[];[];[];[];[];[];[];[false];[];[trinaest]", "14/10/2:[\u010detrnaest];[];[];[];[];[];[];[];[false];[];[\u010detrnaest]", "15/10/2:[petnaest];[];[];[];[];[];[];[];[false];[];[petnaest]", "16/10/2:[\u0161esnaest];[];[];[];[];[];[];[];[false];[];[\u0161esnaest]", "17/10/2:[sedamnaest];[];[];[];[];[];[];[];[false];[];[sedamnaest]", "18/10/2:[osamnaest];[];[];[];[];[];[];[];[false];[];[osamnaest]", "19/10/2:[devetnaest];[];[];[];[];[];[];[];[false];[];[devetnaest]", "20/10/2:[];[tenth];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[];[hundreds];[];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[thousands];[];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[millions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[billions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[trillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[quadrillions];[];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sh_Def.put("default", stringArray9);
        stringArray10 = new String[]{"0/1/1:[];[];[];[];[];[];[default];[];[false];[ stotih];[]"};
        sh_Def.put("decimal", stringArray10);
        stringArray11 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        sh_Def.put("minus", stringArray11);
        m_RuleDefinition.put(new Locale("sh", ""), sh_Def);
        lt_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nulis];[];[];[];[];[];[];[];[false];[];[nulis]", "1/1/1:[vienas];[];[];[];[];[];[];[];[false];[];[vienas]", "2/1/1:[du];[];[];[];[];[];[];[];[false];[];[du]", "3/1/1:[trys];[];[];[];[];[];[];[];[false];[];[trys]", "4/1/1:[keturi];[];[];[];[];[];[];[];[false];[];[keturi]", "5/1/1:[penki];[];[];[];[];[];[];[];[false];[];[penki]", "6/1/1:[\u0161e\u0161i];[];[];[];[];[];[];[];[false];[];[\u0161e\u0161i]", "7/1/1:[septyni];[];[];[];[];[];[];[];[false];[];[septyni]", "8/1/1:[a\u0161tuoni];[];[];[];[];[];[];[];[false];[];[a\u0161tuoni]", "9/1/1:[devyni];[];[];[];[];[];[];[];[false];[];[devyni]", "10/10/2:[de\u0161imt];[];[];[];[];[];[];[];[false];[];[de\u0161imt]", "11/10/2:[vienuolika];[];[];[];[];[];[];[];[false];[];[vienuolika]", "12/10/2:[dvylika];[];[];[];[];[];[];[];[false];[];[dvylika]", "13/10/2:[trylika];[];[];[];[];[];[];[];[false];[];[trylika]", "14/10/2:[];[];[];[decimal];[];[];[];[];[false];[olika];[]", "20/10/2:[];[default-alt2];[de\u0161imt];[decimal];[ ];[];[];[];[true];[];[]", "100/100/3:[Vienas \u0161imtas];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ \u0161imtai];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[t\u016bkstantis];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt];[];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[vienas milijonas];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milijon\u0173];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[vienas milijardas];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ milijard\u0173];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[vienas trilijonas];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[trilijon\u0173];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[vienas kvadrilijonas];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ kvadrilijon\u0173];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        lt_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[0];[];[];[];[];[];[];[];[false];[];[0]", "2/1/1:[dvi];[];[];[];[];[];[];[];[false];[];[dvi]", "3/1/1:[tris];[];[];[];[];[];[];[];[false];[];[tris]", "4/1/1:[keturias];[];[];[];[];[];[];[];[false];[];[keturias]", "5/1/1:[penkias];[];[];[];[];[];[];[];[false];[];[penkias]", "6/1/1:[\u0161e\u0161ias];[];[];[];[];[];[];[];[false];[];[\u0161e\u0161ias]", "7/1/1:[septynias];[];[];[];[];[];[];[];[false];[];[septynias]", "8/1/1:[a\u0161tuonias];[];[];[];[];[];[];[];[false];[];[a\u0161tuonias]", "9/1/1:[devynias];[];[];[];[];[];[];[];[false];[];[devynias]", "10/10/2:[10];[];[];[];[];[];[];[];[false];[];[10]"};
        lt_Def.put("default-alt2", stringArray2);
        stringArray3 = new String[]{"0/1/1:[t\u016bkstan\u010di\u0173];[];[];[];[];[];[];[];[false];[];[t\u016bkstan\u010di\u0173]", "1/1/1:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "2/1/1:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "10/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "21/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "22/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "30/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "31/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "32/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "40/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "41/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "42/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "50/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "51/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "52/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "60/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "61/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "62/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "70/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "71/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "72/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "80/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "81/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "82/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "90/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010di\u0173];[]", "91/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstantis];[]", "92/10/2:[];[];[];[];[];[];[default];[];[false];[ t\u016bkstan\u010diai];[]", "100/100/3:[Vienas \u0161imtas ];[];[];[default-alt];[];[];[];[];[false];[];[]", "200/100/3:[];[default];[ \u0161imtai ];[default-alt];[];[];[];[];[false];[];[]"};
        lt_Def.put("default-alt", stringArray3);
        stringArray4 = new String[]{"0/1/1:[nulis];[];[];[];[];[];[];[];[false];[];[nulis]", "1/1/1:[vienas];[];[];[];[];[];[];[];[false];[];[vienas]", "2/1/1:[du];[];[];[];[];[];[];[];[false];[];[du]", "3/1/1:[trys];[];[];[];[];[];[];[];[false];[];[trys]", "4/1/1:[keturi];[];[];[];[];[];[];[];[false];[];[keturi]", "5/1/1:[penki];[];[];[];[];[];[];[];[false];[];[penki]", "6/1/1:[\u0161e\u0161i];[];[];[];[];[];[];[];[false];[];[\u0161e\u0161i]", "7/1/1:[septyni];[];[];[];[];[];[];[];[false];[];[septyni]", "8/1/1:[a\u0161tuoni];[];[];[];[];[];[];[];[false];[];[a\u0161tuoni]", "9/1/1:[devyni];[];[];[];[];[];[];[];[false];[];[devyni]", "10/10/2:[de\u0161imt];[];[];[];[];[];[];[];[false];[];[de\u0161imt]", "11/10/2:[vienuolika];[];[];[];[];[];[];[];[false];[];[vienuolika]", "12/10/2:[dvylika];[];[];[];[];[];[];[];[false];[];[dvylika]", "13/10/2:[trylika];[];[];[];[];[];[];[];[false];[];[trylika]", "14/10/2:[];[];[];[default];[];[];[];[];[false];[olika];[]", "20/10/2:[];[default-alt2];[de\u0161imt];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[Vienas \u0161imtas];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ \u0161imtai];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[t\u016bkstantis];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt];[];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[vienas milijonas];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milijon\u0173];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[vienas milijardas];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[ milijard\u0173];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[vienas trilijonas];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[trilijon\u0173];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[vienas kvadrilijonas];[];[];[default];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[ kvadrilijon\u0173];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        lt_Def.put("default", stringArray4);
        stringArray5 = new String[]{"0/1/1:[m\u012bnus ];[];[];[];[];[];[default];[];[false];[];[]"};
        lt_Def.put("minus", stringArray5);
        m_RuleDefinition.put(new Locale("lt", ""), lt_Def);
        ro_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[unu];[];[];[];[];[];[];[];[false];[];[unu]", "2/1/1:[doi];[];[];[];[];[];[];[];[false];[];[doi]", "3/1/1:[trei];[];[];[];[];[];[];[];[false];[];[trei]", "4/1/1:[patru];[];[];[];[];[];[];[];[false];[];[patru]", "5/1/1:[cinci];[];[];[];[];[];[];[];[false];[];[cinci]", "6/1/1:[\u015fase];[];[];[];[];[];[];[];[false];[];[\u015fase]", "7/1/1:[\u015fapte];[];[];[];[];[];[];[];[false];[];[\u015fapte]", "8/1/1:[opt];[];[];[];[];[];[];[];[false];[];[opt]", "9/1/1:[nou\u0103];[];[];[];[];[];[];[];[false];[];[nou\u0103]", "10/10/2:[zece];[];[];[];[];[];[];[];[false];[];[zece]", "11/10/2:[unsprezece];[];[];[];[];[];[];[];[false];[];[unsprezece]", "12/10/2:[];[];[];[decimal];[];[];[];[];[false];[sprezece];[]", "20/10/2:[];[default-alt2];[zeci];[decimal];[ \u015fi ];[];[];[];[true];[];[]", "100/100/3:[O sut\u0103];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default-alt2];[ sute];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[O mie];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt2];[ mii];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default-alt1];[ milion];[decimal];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt1];[ milioane];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt1];[ miliard];[decimal];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt1];[ miliarde];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default-alt1];[ bilion];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt1];[ bilioane];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt1];[ biliard];[decimal];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt1];[ biliarde];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ro_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[una];[];[];[];[];[];[];[];[false];[];[una]", "2/1/1:[dou\u0103];[];[];[];[];[];[];[];[false];[];[dou\u0103]", "3/1/1:[];[];[];[];[];[];[default];[];[false];[];[]", "12/10/2:[];[];[];[default-alt2];[];[];[];[];[false];[sprezece];[]", "20/10/2:[];[default-alt2];[zeci];[default-alt2];[ \u015fi ];[];[];[];[true];[];[]", "100/100/3:[O sut\u0103];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default-alt2];[ sute];[default-alt2];[ ];[];[];[];[true];[];[]", "1000/1000/4:[O mie];[];[];[default-alt2];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt2];[ mii];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default-alt1];[ milion];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt1];[ milioane];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt1];[ miliard];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt1];[ miliarde];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default-alt1];[ bilion];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt1];[ bilioane];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt1];[ biliard];[default-alt2];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt1];[ biliarde];[default-alt2];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ro_Def.put("default-alt2", stringArray2);
        stringArray3 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[unu];[];[];[];[];[];[];[];[false];[];[unu]", "2/1/1:[];[];[];[];[];[];[default-alt2];[];[false];[];[]", "20/10/2:[];[default-alt2];[zeci];[default-alt1];[ \u015fi ];[];[];[];[true];[];[]", "100/100/3:[O sut\u0103];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default-alt2];[ sute];[default-alt1];[ ];[];[];[];[true];[];[]", "1000/1000/4:[O mie];[];[];[default-alt1];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt2];[ mii];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default-alt1];[ milion];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt1];[ milioane];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt1];[ miliard];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt1];[ miliarde];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default-alt1];[ bilion];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt1];[ bilioane];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt1];[ biliard];[default-alt1];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt1];[ biliarde];[default-alt1];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ro_Def.put("default-alt1", stringArray3);
        stringArray4 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[unu];[];[];[];[];[];[];[];[false];[];[unu]", "2/1/1:[doi];[];[];[];[];[];[];[];[false];[];[doi]", "3/1/1:[trei];[];[];[];[];[];[];[];[false];[];[trei]", "4/1/1:[patru];[];[];[];[];[];[];[];[false];[];[patru]", "5/1/1:[cinci];[];[];[];[];[];[];[];[false];[];[cinci]", "6/1/1:[\u015fase];[];[];[];[];[];[];[];[false];[];[\u015fase]", "7/1/1:[\u015fapte];[];[];[];[];[];[];[];[false];[];[\u015fapte]", "8/1/1:[opt];[];[];[];[];[];[];[];[false];[];[opt]", "9/1/1:[nou\u0103];[];[];[];[];[];[];[];[false];[];[nou\u0103]", "10/10/2:[zece];[];[];[];[];[];[];[];[false];[];[zece]", "11/10/2:[unsprezece];[];[];[];[];[];[];[];[false];[];[unsprezece]", "12/10/2:[];[];[];[default];[];[];[];[];[false];[sprezece];[]", "20/10/2:[];[default-alt2];[zeci];[default];[ \u015fi ];[];[];[];[true];[];[]", "100/100/3:[O sut\u0103];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default-alt2];[ sute];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[O mie];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default-alt2];[ mii];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default-alt1];[ milion];[default];[ ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt1];[ milioane];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default-alt1];[ miliard];[default];[ ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt1];[ miliarde];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default-alt1];[ bilion];[default];[ ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt1];[ bilioane];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default-alt1];[ biliard];[default];[ ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt1];[ biliarde];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        ro_Def.put("default", stringArray4);
        stringArray5 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        ro_Def.put("minus", stringArray5);
        m_RuleDefinition.put(new Locale("ro", ""), ro_Def);
        sk_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jedna];[];[];[];[];[];[];[];[false];[];[jedna]", "2/1/1:[dve];[];[];[];[];[];[];[];[false];[];[dve]", "3/1/1:[];[];[];[];[];[];[default];[];[false];[];[]", "20/10/2:[dvadsa\u0165];[];[];[default-alt1];[];[];[];[];[true];[];[]", "30/10/2:[tridsa\u0165];[];[];[default-alt1];[];[];[];[];[true];[];[]", "40/10/2:[\u0161tyridsa\u0165];[];[];[default-alt1];[];[];[];[];[true];[];[]", "50/10/2:[];[default-alt1];[desiat];[default-alt1];[];[];[];[];[true];[];[]", "100/100/3:[];[];[sto];[default-alt1];[];[];[];[];[true];[];[]", "200/100/3:[];[default-alt1];[sto];[default-alt1];[];[];[];[];[true];[];[]", "1000/1000/4:[];[];[ tis\u00edc];[default-alt1];[];[];[];[];[true];[];[]"};
        sk_Def.put("default-alt1", stringArray);
        stringArray2 = new String[]{"0/1/1:[nula];[];[];[];[];[];[];[];[false];[];[nula]", "1/1/1:[jeden];[];[];[];[];[];[];[];[false];[];[jeden]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[\u0161tyri];[];[];[];[];[];[];[];[false];[];[\u0161tyri]", "5/1/1:[p\u00e4\u0165];[];[];[];[];[];[];[];[false];[];[p\u00e4\u0165]", "6/1/1:[\u0161es\u0165];[];[];[];[];[];[];[];[false];[];[\u0161es\u0165]", "7/1/1:[sedem];[];[];[];[];[];[];[];[false];[];[sedem]", "8/1/1:[osem];[];[];[];[];[];[];[];[false];[];[osem]", "9/1/1:[dev\u00e4\u0165];[];[];[];[];[];[];[];[false];[];[dev\u00e4\u0165]", "10/10/2:[desa\u0165];[];[];[];[];[];[];[];[false];[];[desa\u0165]", "11/10/2:[jeden\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[jeden\u00e1s\u0165]", "12/10/2:[dvan\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[dvan\u00e1s\u0165]", "13/10/2:[trin\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[trin\u00e1s\u0165]", "14/10/2:[\u0161trn\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[\u0161trn\u00e1s\u0165]", "15/10/2:[p\u00e4tn\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[p\u00e4tn\u00e1s\u0165]", "16/10/2:[\u0161estn\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[\u0161estn\u00e1s\u0165]", "17/10/2:[sedemn\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[sedemn\u00e1s\u0165]", "18/10/2:[osemn\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[osemn\u00e1s\u0165]", "19/10/2:[dev\u00e4tn\u00e1s\u0165];[];[];[];[];[];[];[];[false];[];[dev\u00e4tn\u00e1s\u0165]", "20/10/2:[dvadsa\u0165];[];[];[default];[];[];[];[];[true];[];[]", "30/10/2:[tridsa\u0165];[];[];[default];[];[];[];[];[true];[];[]", "40/10/2:[\u0161tyridsa\u0165];[];[];[default];[];[];[];[];[true];[];[]", "50/10/2:[];[default];[desiat];[default];[];[];[];[];[true];[];[]", "100/100/3:[];[];[sto];[default];[];[];[];[];[true];[];[]", "200/100/3:[];[default-alt1];[sto];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[];[];[tis\u00edc];[default];[];[];[];[];[true];[];[]", "2000/1000/4:[];[];[dvetis\u00edc];[default];[];[];[];[];[true];[];[]", "3000/1000/4:[];[default];[tis\u00edc];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[];[mili\u00f3n];[default];[];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ mili\u00f3ny];[default];[];[];[];[];[true];[];[]", "5000000/1000000/7:[];[default];[ mili\u00f3nov];[default];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[];[miliarda];[default];[];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt1];[ miliardy];[default];[];[];[];[];[true];[];[]", "5000000000/1000000000/10:[];[default-alt1];[ miliardov];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[];[bili\u00f3n];[default];[];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[bili\u00f3ny];[default];[];[];[];[];[true];[];[]", "5000000000000/1000000000000/13:[];[default];[bili\u00f3nov];[default];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[biliarda];[default];[];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[biliardy];[default];[];[];[];[];[true];[];[]", "5000000000000000/1000000000000000/16:[];[default];[biliardov];[default];[];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sk_Def.put("default", stringArray2);
        sk_Def.put("decimal", stringArray2);
        stringArray3 = new String[]{"0/1/1:[m\u00ednus ];[];[];[];[];[];[default];[];[false];[];[]"};
        sk_Def.put("minus", stringArray3);
        m_RuleDefinition.put(new Locale("sk", ""), sk_Def);
        sl_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[ni\u010d];[];[];[];[];[];[];[];[false];[];[ni\u010d]", "1/1/1:[en];[];[];[];[];[];[];[];[false];[];[en]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[\u0161tiri];[];[];[];[];[];[];[];[false];[];[\u0161tiri]", "5/1/1:[pet];[];[];[];[];[];[];[];[false];[];[pet]", "6/1/1:[\u0161est];[];[];[];[];[];[];[];[false];[];[\u0161est]", "7/1/1:[sedem];[];[];[];[];[];[];[];[false];[];[sedem]", "8/1/1:[osem];[];[];[];[];[];[];[];[false];[];[osem]", "9/1/1:[devet];[];[];[];[];[];[];[];[false];[];[devet]", "10/10/2:[deset];[];[];[];[];[];[];[];[false];[];[deset]", "11/10/2:[enajst];[];[];[];[];[];[];[];[false];[];[enajst]", "12/10/2:[dvanajst];[];[];[];[];[];[];[];[false];[];[dvanajst]", "13/10/2:[trinajst];[];[];[];[];[];[];[];[false];[];[trinajst]", "14/10/2:[\u0161trinajst];[];[];[];[];[];[];[];[false];[];[\u0161trinajst]", "15/10/2:[petnajst];[];[];[];[];[];[];[];[false];[];[petnajst]", "16/10/2:[\u0161estnajst];[];[];[];[];[];[];[];[false];[];[\u0161estnajst]", "17/10/2:[sedemnajst];[];[];[];[];[];[];[];[false];[];[sedemnajst]", "18/10/2:[Osemnajst];[];[];[];[];[];[];[];[false];[];[Osemnajst]", "19/10/2:[devetnajst];[];[];[];[];[];[];[];[false];[];[devetnajst]", "20/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[dvajset];[]", "30/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[trideset];[]", "40/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[\u0161tirideset];[]", "50/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[petdeset];[]", "60/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[\u0161estdeset];[]", "70/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[sedemdeset];[]", "80/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[osemdeset];[]", "90/10/2:[];[];[];[default-alt2];[];[in];[];[];[true];[devetdeset];[]", "100/100/3:[sto];[];[];[default];[];[];[];[];[true];[];[]", "200/100/3:[dvesto];[];[];[default];[];[];[];[];[true];[];[]", "300/100/3:[tristo];[];[];[default];[];[];[];[];[true];[];[]", "400/100/3:[\u0161tiristo];[];[];[default];[];[];[];[];[true];[];[]", "500/100/3:[petsto];[];[];[default];[];[];[];[];[true];[];[]", "600/100/3:[\u0161eststo];[];[];[default];[];[];[];[];[true];[];[]", "700/100/3:[sedemsto];[];[];[default];[];[];[];[];[true];[];[]", "800/100/3:[osemsto];[];[];[default];[];[];[];[];[true];[];[]", "900/100/3:[devetsto];[];[];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[tiso\u010d];[];[];[default];[];[];[];[];[true];[];[]", "2000/1000/4:[dvatiso\u010d];[];[];[default];[];[];[];[];[true];[];[]", "3000/1000/4:[];[default];[tiso\u010d];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[milijon];[default];[];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[milijona];[default];[];[];[];[];[true];[];[]", "3000000/1000000/7:[];[default];[milijone];[default];[];[];[];[];[true];[];[]", "5000000/1000000/7:[];[default];[milijonov];[default];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[milijarda];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[bilijon];[default];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[bilijarda];[default];[];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sl_Def.put("default", stringArray);
        stringArray2 = new String[]{"0/1/1:[ni\u010d];[];[];[];[];[];[];[];[false];[];[ni\u010d]", "1/1/1:[ena];[];[];[];[];[];[];[];[false];[];[ena]", "2/1/1:[dva];[];[];[];[];[];[];[];[false];[];[dva]", "3/1/1:[];[];[];[];[];[];[default];[];[false];[];[]"};
        sl_Def.put("default-alt2", stringArray2);
        sl_Def.put("decimal", stringArray);
        stringArray3 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        sl_Def.put("minus", stringArray3);
        m_RuleDefinition.put(new Locale("sl", ""), sl_Def);
        sq_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[nj\u00eb];[];[];[];[];[];[];[];[false];[];[nj\u00eb]", "2/1/1:[dy];[];[];[];[];[];[];[];[false];[];[dy]", "3/1/1:[tri];[];[];[];[];[];[];[];[false];[];[tri]", "4/1/1:[];[];[];[];[];[];[default];[];[false];[];[]", "20/10/2:[nj\u00ebzet];[];[];[default-alt];[ e ];[];[];[];[true];[];[]", "30/10/2:[tridhjet\u00eb];[];[];[default-alt];[ e ];[];[];[];[true];[];[]", "40/10/2:[dyzet];[];[];[default-alt];[ e ];[];[];[];[true];[];[]", "50/10/2:[];[default-alt];[dhjet\u00eb];[default-alt];[ e ];[];[];[];[true];[];[]", "100/100/3:[];[default];[qind];[default-alt];[ e ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ mij\u00eb];[default-alt];[ e ];[];[];[];[true];[];[]", "1000000/1000000/7:[nj\u00eb milion];[];[];[default-alt];[ e ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default-alt];[ milion];[default-alt];[ e ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[nj\u00eb miliard];[];[];[default-alt];[ e ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ miliard];[default-alt];[ e ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[nj\u00eb trilion];[];[];[default-alt];[ e ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt];[ trilion];[default-alt];[ e ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[nj\u00eb kuadrilion];[];[];[default-alt];[ e ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ kuadrilion];[default-alt];[ e ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sq_Def.put("default-alt", stringArray);
        stringArray2 = new String[]{"0/1/1:[zero];[];[];[];[];[];[];[];[false];[];[zero]", "1/1/1:[nj\u00eb];[];[];[];[];[];[];[];[false];[];[nj\u00eb]", "2/1/1:[dy];[];[];[];[];[];[];[];[false];[];[dy]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[kat\u00ebr];[];[];[];[];[];[];[];[false];[];[kat\u00ebr]", "5/1/1:[pes\u00eb];[];[];[];[];[];[];[];[false];[];[pes\u00eb]", "6/1/1:[gjasht\u00eb];[];[];[];[];[];[];[];[false];[];[gjasht\u00eb]", "7/1/1:[shtat\u00eb];[];[];[];[];[];[];[];[false];[];[shtat\u00eb]", "8/1/1:[tet\u00eb];[];[];[];[];[];[];[];[false];[];[tet\u00eb]", "9/1/1:[n\u00ebnt\u00eb];[];[];[];[];[];[];[];[false];[];[n\u00ebnt\u00eb]", "10/10/2:[dhjet\u00eb];[];[];[];[];[];[];[];[false];[];[dhjet\u00eb]", "11/10/2:[];[];[];[default];[];[];[];[];[false];[mb\u00ebdhjet\u00eb];[]", "20/10/2:[nj\u00ebzet];[];[];[default];[ e ];[];[];[];[true];[];[]", "30/10/2:[tridhjet\u00eb];[];[];[default];[ e ];[];[];[];[true];[];[]", "40/10/2:[dyzet];[];[];[default];[ e ];[];[];[];[true];[];[]", "50/10/2:[];[default-alt];[dhjet\u00eb];[default];[ e ];[];[];[];[true];[];[]", "100/100/3:[];[default];[qind];[default];[ e ];[];[];[];[true];[];[]", "1000/1000/4:[];[default-alt];[ mij\u00eb];[default];[ e ];[];[];[];[true];[];[]", "1000000/1000000/7:[nj\u00eb milion];[];[];[default];[ e ];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[ milion];[default];[ e ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[nj\u00eb miliard];[];[];[default];[ e ];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default-alt];[ miliard];[default];[ e ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[nj\u00eb trilion];[];[];[default];[ e ];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default-alt];[ trilion];[default];[ e ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[nj\u00eb kuadrilion];[];[];[default];[ e ];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default-alt];[ kuadrilion];[default];[ e ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        sq_Def.put("default", stringArray2);
        sq_Def.put("decimal", stringArray2);
        stringArray3 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        sq_Def.put("minus", stringArray3);
        m_RuleDefinition.put(new Locale("sq", ""), sq_Def);
        tr_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[s\u0131f\u0131r.];[];[];[];[];[];[];[];[false];[];[s\u0131f\u0131r.]", "1/1/1:[bir.];[];[];[];[];[];[];[];[false];[];[bir.]", "2/1/1:[iki.];[];[];[];[];[];[];[];[false];[];[iki.]", "3/1/1:[\u00fc\u00e7.];[];[];[];[];[];[];[];[false];[];[\u00fc\u00e7.]", "4/1/1:[d\u00f6rt.];[];[];[];[];[];[];[];[false];[];[d\u00f6rt.]", "5/1/1:[be\u015f.];[];[];[];[];[];[];[];[false];[];[be\u015f.]", "6/1/1:[alt\u0131.];[];[];[];[];[];[];[];[false];[];[alt\u0131.]", "7/1/1:[yedi.];[];[];[];[];[];[];[];[false];[];[yedi.]", "8/1/1:[sekiz.];[];[];[];[];[];[];[];[false];[];[sekiz.]", "9/1/1:[dokuz.];[];[];[];[];[];[];[];[false];[];[dokuz.]", "10/10/2:[on];[];[];[decimal];[];[];[];[];[true];[];[]", "20/10/2:[yirmi];[];[];[decimal];[];[];[];[];[true];[];[]", "30/10/2:[otuz];[];[];[decimal];[];[];[];[];[true];[];[]", "40/10/2:[k\u0131rk];[];[];[decimal];[];[];[];[];[true];[];[]", "50/10/2:[elli];[];[];[decimal];[];[];[];[];[true];[];[]", "60/10/2:[altm\u0131\u015f];[];[];[decimal];[];[];[];[];[true];[];[]", "70/10/2:[yetmi\u015f];[];[];[decimal];[];[];[];[];[true];[];[]", "80/10/2:[seksen];[];[];[decimal];[];[];[];[];[true];[];[]", "90/10/2:[doksan];[];[];[decimal];[];[];[];[];[true];[];[]", "100/100/3:[y\u00fcz];[];[];[decimal];[];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[ y\u00fcz];[decimal];[];[];[];[];[true];[];[]", "1000/1000/4:[bin];[];[];[decimal];[];[];[];[];[true];[];[]", "2000/1000/4:[];[decimal];[ bin];[decimal];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ milyon];[decimal];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ milyar];[decimal];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ trilyon];[decimal];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[decimal];[ katrilyon];[decimal];[];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        tr_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[s\u0131f\u0131r];[];[];[];[];[];[];[];[false];[];[s\u0131f\u0131r]", "1/1/1:[bir];[];[];[];[];[];[];[];[false];[];[bir]", "2/1/1:[iki];[];[];[];[];[];[];[];[false];[];[iki]", "3/1/1:[\u00fc\u00e7];[];[];[];[];[];[];[];[false];[];[\u00fc\u00e7]", "4/1/1:[d\u00f6rt];[];[];[];[];[];[];[];[false];[];[d\u00f6rt]", "5/1/1:[be\u015f];[];[];[];[];[];[];[];[false];[];[be\u015f]", "6/1/1:[alt\u0131];[];[];[];[];[];[];[];[false];[];[alt\u0131]", "7/1/1:[yedi];[];[];[];[];[];[];[];[false];[];[yedi]", "8/1/1:[sekiz];[];[];[];[];[];[];[];[false];[];[sekiz]", "9/1/1:[dokuz];[];[];[];[];[];[];[];[false];[];[dokuz]", "10/10/2:[on];[];[];[default];[];[];[];[];[true];[];[]", "20/10/2:[yirmi];[];[];[default];[];[];[];[];[true];[];[]", "30/10/2:[otuz];[];[];[default];[];[];[];[];[true];[];[]", "40/10/2:[k\u0131rk];[];[];[default];[];[];[];[];[true];[];[]", "50/10/2:[elli];[];[];[default];[];[];[];[];[true];[];[]", "60/10/2:[altm\u0131\u015f];[];[];[default];[];[];[];[];[true];[];[]", "70/10/2:[yetmi\u015f];[];[];[default];[];[];[];[];[true];[];[]", "80/10/2:[seksen];[];[];[default];[];[];[];[];[true];[];[]", "90/10/2:[doksan];[];[];[default];[];[];[];[];[true];[];[]", "100/100/3:[y\u00fcz];[];[];[default];[];[];[];[];[true];[];[]", "200/100/3:[];[default];[ y\u00fcz];[default];[];[];[];[];[true];[];[]", "1000/1000/4:[bin];[];[];[default];[];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[ bin];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ milyon];[default];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ milyar];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ trilyon];[default];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[ katrilyon];[default];[];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        tr_Def.put("default", stringArray2);
        stringArray3 = new String[]{"0/1/1:[eksi ];[];[];[];[];[];[default];[];[false];[];[]"};
        tr_Def.put("minus", stringArray3);
        m_RuleDefinition.put(new Locale("tr", ""), tr_Def);
        vi_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[kh\u00f4ng h\u00e0o];[];[];[];[];[];[];[];[false];[];[kh\u00f4ng h\u00e0o]", "1/1/1:[m\u1ed9t h\u00e0o];[];[];[];[];[];[];[];[false];[];[m\u1ed9t h\u00e0o]", "2/1/1:[hai h\u00e0o];[];[];[];[];[];[];[];[false];[];[hai h\u00e0o]", "3/1/1:[ba h\u00e0o];[];[];[];[];[];[];[];[false];[];[ba h\u00e0o]", "4/1/1:[b\u1ed1n h\u00e0o];[];[];[];[];[];[];[];[false];[];[b\u1ed1n h\u00e0o]", "5/1/1:[n\u0103m h\u00e0o];[];[];[];[];[];[];[];[false];[];[n\u0103m h\u00e0o]", "6/1/1:[s\u00e1u h\u00e0o];[];[];[];[];[];[];[];[false];[];[s\u00e1u h\u00e0o]", "7/1/1:[b\u1ea3y h\u00e0o];[];[];[];[];[];[];[];[false];[];[b\u1ea3y h\u00e0o]", "8/1/1:[t\u00e1m h\u00e0o];[];[];[];[];[];[];[];[false];[];[t\u00e1m h\u00e0o]", "9/1/1:[ch\u00edn h\u00e0o];[];[];[];[];[];[];[];[false];[];[ch\u00edn h\u00e0o]", "10/10/2:[m\u01b0\u1eddi];[];[];[decimal-10];[ ];[];[];[];[true];[];[]", "20/10/2:[];[default];[ m\u01b0\u01a1i];[decimal-20];[ ];[];[];[];[true];[];[]", "100/100/3:[];[default];[ tr\u0103m];[decimal-100];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ ngh\u00ecn];[decimal-1000];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ tri\u1ec7u];[decimal-1000];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ t\u1ef7];[decimal-1000];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        vi_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[kh\u00f4ng tr\u0103m ];[];[];[];[];[];[decimal-100];[];[false];[];[]", "100/100/3:[];[];[];[];[];[];[default];[];[false];[];[]"};
        vi_Def.put("decimal-1000", stringArray2);
        stringArray3 = new String[]{"0/1/1:[];[];[];[];[];[];[decimal];[];[false];[];[]", "5/1/1:[n\u0103m];[];[];[];[];[];[];[];[false];[];[n\u0103m]", "6/1/1:[];[];[];[];[];[];[decimal];[];[false];[];[]"};
        vi_Def.put("decimal-10", stringArray3);
        stringArray4 = new String[]{"0/1/1:[];[];[];[];[];[];[decimal];[];[false];[];[]", "1/1/1:[m\u1ed1t];[];[];[];[];[];[];[];[false];[];[m\u1ed1t]", "2/1/1:[];[];[];[];[];[];[decimal-10];[];[false];[];[]"};
        vi_Def.put("decimal-20", stringArray4);
        stringArray5 = new String[]{"0/1/1:[l\u1ebb ];[];[];[];[];[];[decimal];[];[false];[];[]", "10/10/2:[];[];[];[];[];[];[decimal];[];[false];[];[]"};
        vi_Def.put("decimal-100", stringArray5);
        stringArray6 = new String[]{"0/1/1:[kh\u00f4ng];[];[];[];[];[];[];[];[false];[];[kh\u00f4ng]", "1/1/1:[m\u1ed9t];[];[];[];[];[];[];[];[false];[];[m\u1ed9t]", "2/1/1:[hai];[];[];[];[];[];[];[];[false];[];[hai]", "3/1/1:[ba];[];[];[];[];[];[];[];[false];[];[ba]", "4/1/1:[b\u1ed1n];[];[];[];[];[];[];[];[false];[];[b\u1ed1n]", "5/1/1:[n\u0103m];[];[];[];[];[];[];[];[false];[];[n\u0103m]", "6/1/1:[s\u00e1u];[];[];[];[];[];[];[];[false];[];[s\u00e1u]", "7/1/1:[b\u1ea3y];[];[];[];[];[];[];[];[false];[];[b\u1ea3y]", "8/1/1:[t\u00e1m];[];[];[];[];[];[];[];[false];[];[t\u00e1m]", "9/1/1:[ch\u00edn];[];[];[];[];[];[];[];[false];[];[ch\u00edn]", "10/10/2:[m\u01b0\u1eddi];[];[];[default-10];[ ];[];[];[];[true];[];[]", "20/10/2:[];[default];[ m\u01b0\u01a1i];[default-20];[ ];[];[];[];[true];[];[]", "100/100/3:[];[default];[ tr\u0103m];[default-100];[ ];[];[];[];[true];[];[]", "1000/1000/4:[];[default];[ ngh\u00ecn];[default-1000];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ tri\u1ec7u];[default-1000];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ t\u1ef7];[default-1000];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        vi_Def.put("default", stringArray6);
        stringArray7 = new String[]{"0/1/1:[kh\u00f4ng tr\u0103m ];[];[];[];[];[];[default-100];[];[false];[];[]", "100/100/3:[];[];[];[];[];[];[default];[];[false];[];[]"};
        vi_Def.put("default-1000", stringArray7);
        stringArray8 = new String[]{"0/1/1:[];[];[];[];[];[];[default];[];[false];[];[]", "5/1/1:[n\u0103m];[];[];[];[];[];[];[];[false];[];[n\u0103m]", "6/1/1:[];[];[];[];[];[];[default];[];[false];[];[]"};
        vi_Def.put("default-10", stringArray8);
        stringArray9 = new String[]{"0/1/1:[];[];[];[];[];[];[default];[];[false];[];[]", "1/1/1:[m\u1ed1t];[];[];[];[];[];[];[];[false];[];[m\u1ed1t]", "2/1/1:[];[];[];[];[];[];[default-10];[];[false];[];[]"};
        vi_Def.put("default-20", stringArray9);
        stringArray10 = new String[]{"0/1/1:[l\u1ebb ];[];[];[];[];[];[default];[];[false];[];[]", "10/10/2:[];[];[];[];[];[];[default];[];[false];[];[]"};
        vi_Def.put("default-100", stringArray10);
        stringArray11 = new String[]{"0/1/1:[\u00e2m ];[];[];[];[];[];[default];[];[false];[];[]"};
        vi_Def.put("minus", stringArray11);
        m_RuleDefinition.put(new Locale("vi", ""), vi_Def);
        id_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[kosong];[];[];[];[];[];[];[];[false];[];[kosong]", "1/1/1:[satu];[];[];[];[];[];[];[];[false];[];[satu]", "2/1/1:[dua];[];[];[];[];[];[];[];[false];[];[dua]", "3/1/1:[tiga];[];[];[];[];[];[];[];[false];[];[tiga]", "4/1/1:[empat];[];[];[];[];[];[];[];[false];[];[empat]", "5/1/1:[lima];[];[];[];[];[];[];[];[false];[];[lima]", "6/1/1:[enam];[];[];[];[];[];[];[];[false];[];[enam]", "7/1/1:[tujuh];[];[];[];[];[];[];[];[false];[];[tujuh]", "8/1/1:[delapan];[];[];[];[];[];[];[];[false];[];[delapan]", "9/1/1:[sembilan];[];[];[];[];[];[];[];[false];[];[sembilan]", "10/10/2:[sepuluh];[];[];[];[];[];[];[];[false];[];[sepuluh]", "11/10/2:[sebelas];[];[];[];[];[];[];[];[false];[];[sebelas]", "12/10/2:[];[];[];[decimal];[];[];[];[];[false];[ belas];[]", "20/10/2:[];[decimal];[ puluh];[decimal];[ ];[];[];[];[true];[];[]", "100/100/3:[seratus];[];[];[decimal];[ ];[];[];[];[true];[];[]", "200/100/3:[];[decimal];[ ratus];[decimal];[ ];[];[];[];[true];[];[]", "1000/1000/4:[seribu];[];[];[decimal];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[decimal];[ ribu];[decimal];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[decimal];[ juta];[decimal];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[decimal];[ Miliar];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[decimal];[ Triliun];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[decimal];[ bilyar];[decimal];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0.#];[];[false];[];[]"};
        id_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[kosong];[];[];[];[];[];[];[];[false];[];[kosong]", "1/1/1:[satu];[];[];[];[];[];[];[];[false];[];[satu]", "2/1/1:[dua];[];[];[];[];[];[];[];[false];[];[dua]", "3/1/1:[tiga];[];[];[];[];[];[];[];[false];[];[tiga]", "4/1/1:[empat];[];[];[];[];[];[];[];[false];[];[empat]", "5/1/1:[lima];[];[];[];[];[];[];[];[false];[];[lima]", "6/1/1:[enam];[];[];[];[];[];[];[];[false];[];[enam]", "7/1/1:[tujuh];[];[];[];[];[];[];[];[false];[];[tujuh]", "8/1/1:[delapan];[];[];[];[];[];[];[];[false];[];[delapan]", "9/1/1:[sembilan];[];[];[];[];[];[];[];[false];[];[sembilan]", "10/10/2:[sepuluh];[];[];[];[];[];[];[];[false];[];[sepuluh]", "11/10/2:[sebelas];[];[];[];[];[];[];[];[false];[];[sebelas]", "12/10/2:[];[];[];[default];[];[];[];[];[false];[ belas];[]", "20/10/2:[];[default];[ puluh];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[seratus];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ ratus];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[seribu];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[ ribu];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ juta];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ Miliar];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ Triliun];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[default];[ bilyar];[default];[ ];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0.#];[];[false];[];[]"};
        id_Def.put("default", stringArray2);
        stringArray3 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        id_Def.put("minus", stringArray3);
        m_RuleDefinition.put(new Locale("id", ""), id_Def);
        no_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[null];[];[];[];[];[];[];[];[false];[];[null]", "1/1/1:[ett];[];[];[];[];[];[];[];[false];[];[ett]", "2/1/1:[];[];[];[];[];[];[default];[];[false];[];[]"};
        no_Def.put("default-alt", stringArray);
        stringArray2 = new String[]{"0/1/1:[null];[];[];[];[];[];[];[];[false];[];[null]", "1/1/1:[\u00e9n];[];[];[];[];[];[];[];[false];[];[\u00e9n]", "2/1/1:[to];[];[];[];[];[];[];[];[false];[];[to]", "3/1/1:[tre];[];[];[];[];[];[];[];[false];[];[tre]", "4/1/1:[fire];[];[];[];[];[];[];[];[false];[];[fire]", "5/1/1:[fem];[];[];[];[];[];[];[];[false];[];[fem]", "6/1/1:[seks];[];[];[];[];[];[];[];[false];[];[seks]", "7/1/1:[sju];[];[];[];[];[];[];[];[false];[];[sju]", "8/1/1:[\u00e5tte];[];[];[];[];[];[];[];[false];[];[\u00e5tte]", "9/1/1:[ni];[];[];[];[];[];[];[];[false];[];[ni]", "10/10/2:[ti];[];[];[];[];[];[];[];[false];[];[ti]", "11/10/2:[elleve];[];[];[];[];[];[];[];[false];[];[elleve]", "12/10/2:[tolv];[];[];[];[];[];[];[];[false];[];[tolv]", "13/10/2:[tretten];[];[];[];[];[];[];[];[false];[];[tretten]", "14/10/2:[fjorten];[];[];[];[];[];[];[];[false];[];[fjorten]", "15/10/2:[femten];[];[];[];[];[];[];[];[false];[];[femten]", "16/10/2:[seksten];[];[];[];[];[];[];[];[false];[];[seksten]", "17/10/2:[sytten];[];[];[];[];[];[];[];[false];[];[sytten]", "18/10/2:[atten];[];[];[];[];[];[];[];[false];[];[atten]", "19/10/2:[nitten];[];[];[];[];[];[];[];[false];[];[nitten]", "20/10/2:[tjue];[];[];[default];[];[];[];[];[true];[];[]", "30/10/2:[tretti];[];[];[default];[];[];[];[];[true];[];[]", "40/10/2:[f\u00f8rti];[];[];[default];[];[];[];[];[true];[];[]", "50/10/2:[femti];[];[];[default];[];[];[];[];[true];[];[]", "60/10/2:[seksti];[];[];[default];[];[];[];[];[true];[];[]", "70/10/2:[sytti];[];[];[default];[];[];[];[];[true];[];[]", "80/10/2:[\u00e5tti];[];[];[default];[];[];[];[];[true];[];[]", "90/10/2:[nitti];[];[];[default];[];[];[];[];[true];[];[]", "100/100/3:[];[default-alt];[hundre];[default];[og];[];[];[];[true];[];[]", "1000/1000/4:[];[default-alt];[tusen];[default];[];[];[];[];[true];[];[]", "1000000/1000000/7:[\u00e9inmillion];[];[];[default];[];[];[];[];[true];[];[]", "2000000/1000000/7:[];[default];[millioner];[default];[];[];[];[];[true];[];[]", "1000000000/1000000000/10:[\u00e9inmiljard];[];[];[default];[];[];[];[];[true];[];[]", "2000000000/1000000000/10:[];[default];[miljarder];[default];[];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[\u00e9inbiljon];[];[];[default];[];[];[];[];[true];[];[]", "2000000000000/1000000000000/13:[];[default];[biljoner];[default];[];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[\u00e9inbiljard];[];[];[default];[];[];[];[];[true];[];[]", "2000000000000000/1000000000000000/16:[];[default];[biljarder];[default];[];[];[];[];[true];[];[]", "1000000000000000000/1000000000000000000/19:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        no_Def.put("default", stringArray2);
        no_Def.put("decimal", stringArray2);
        stringArray3 = new String[]{"0/1/1:[minus ];[];[];[];[];[];[default];[];[false];[];[]"};
        no_Def.put("minus", stringArray3);
        m_RuleDefinition.put(new Locale("no", ""), no_Def);
        kk_Def = new Hashtable();
        stringArray = new String[]{"0/1/1:[\u043d\u04e9\u043b];[];[];[];[];[];[];[];[false];[];[\u043d\u04e9\u043b]", "1/1/1:[\u0431\u0456\u0440];[];[];[];[];[];[];[];[false];[];[\u0431\u0456\u0440]", "2/1/1:[\u0435\u043a\u0456];[];[];[];[];[];[];[];[false];[];[\u0435\u043a\u0456]", "3/1/1:[\u04af\u0448];[];[];[];[];[];[];[];[false];[];[\u04af\u0448]", "4/1/1:[\u0442\u04e9\u0440\u0442];[];[];[];[];[];[];[];[false];[];[\u0442\u04e9\u0440\u0442]", "5/1/1:[\u0431\u0435\u0441];[];[];[];[];[];[];[];[false];[];[\u0431\u0435\u0441]", "6/1/1:[\u0430\u043b\u0442\u044b];[];[];[];[];[];[];[];[false];[];[\u0430\u043b\u0442\u044b]", "7/1/1:[\u0436\u0435\u0442\u0456];[];[];[];[];[];[];[];[false];[];[\u0436\u0435\u0442\u0456]", "8/1/1:[\u0441\u0435\u0433\u0456\u0437];[];[];[];[];[];[];[];[false];[];[\u0441\u0435\u0433\u0456\u0437]", "9/1/1:[\u0442\u043e\u0493\u044b\u0437];[];[];[];[];[];[];[];[false];[];[\u0442\u043e\u0493\u044b\u0437]", "10/10/2:[\u043e\u043d];[];[];[default];[ ];[];[];[];[true];[];[]", "20/10/2:[\u0436\u0438\u044b\u0440\u043c\u0430];[];[];[default];[ ];[];[];[];[true];[];[]", "30/10/2:[\u043e\u0442\u044b\u0437];[];[];[default];[ ];[];[];[];[true];[];[]", "40/10/2:[\u049b\u044b\u0440\u044b\u049b];[];[];[default];[ ];[];[];[];[true];[];[]", "50/10/2:[\u0435\u043b\u0443];[];[];[default];[ ];[];[];[];[true];[];[]", "60/10/2:[\u0430\u043b\u043f\u044b\u0441];[];[];[default];[ ];[];[];[];[true];[];[]", "70/10/2:[\u0436\u0435\u0442\u043f\u0456\u0441];[];[];[default];[ ];[];[];[];[true];[];[]", "80/10/2:[\u0441\u0435\u043a\u0441\u0435\u043d];[];[];[default];[ ];[];[];[];[true];[];[]", "90/10/2:[\u0442\u043e\u049b\u0441\u0430\u043d];[];[];[default];[ ];[];[];[];[true];[];[]", "100/100/3:[\u0436\u04af\u0437];[];[];[default];[ ];[];[];[];[true];[];[]", "200/100/3:[];[default];[ \u0436\u04af\u0437];[default];[ ];[];[];[];[true];[];[]", "1000/1000/4:[\u043c\u044b\u04a3];[];[];[default];[ ];[];[];[];[true];[];[]", "2000/1000/4:[];[default];[ \u043c\u044b\u04a3];[default];[ ];[];[];[];[true];[];[]", "1000000/1000000/7:[];[default];[ \u043c\u0438\u043b\u043b\u0438\u043e\u043d];[default];[ ];[];[];[];[true];[];[]", "1000000000/1000000000/10:[];[default];[ \u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434];[default];[ ];[];[];[];[true];[];[]", "1000000000000/1000000000000/13:[];[default];[ \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d];[default];[ ];[];[];[];[true];[];[]", "1000000000000000/1000000000000000/16:[];[];[];[];[];[];[#,##0];[];[false];[];[]"};
        kk_Def.put("default", stringArray);
        kk_Def.put("decimal", stringArray);
        stringArray2 = new String[]{"0/1/1:[\u043c\u0438\u043d\u0443\u0441 ];[];[];[];[];[];[default];[];[false];[];[]"};
        kk_Def.put("minus", stringArray2);
        m_RuleDefinition.put(new Locale("kk", ""), kk_Def);
        DefaultAndData = new Hashtable();
        DefaultAndData.put(new Locale("en", ""), " and ");
        DefaultAndData.put(new Locale("de", ""), " ");
        DefaultAndData.put(new Locale("fr", ""), " et ");
        DefaultAndData.put(new Locale("nl", ""), " ");
        DefaultAndData.put(new Locale("es", ""), " con ");
        DefaultAndData.put(new Locale("no", ""), " ");
        DefaultAndData.put(new Locale("pt", ""), " e ");
        DefaultAndData.put(new Locale("pl", ""), " i ");
        DefaultAndData.put(new Locale("ru", ""), " \u0438 ");
        DefaultAndData.put(new Locale("sv", ""), " och ");
        DefaultAndData.put(new Locale("da", ""), " og ");
        DefaultAndData.put(new Locale("it", ""), " e ");
        DefaultAndData.put(new Locale("th", ""), "\u0e08\u0e38\u0e14");
        DefaultAndData.put(new Locale("zh", "TW"), "\u5143");
        DefaultAndData.put(new Locale("zh", "HK"), "\u5143");
        DefaultAndData.put(new Locale("zh", ""), "\u5706");
        DefaultAndData.put(new Locale("ja", ""), "\u5186");
        DefaultAndData.put(new Locale("ar", ""), " \u0648 ");
        DefaultAndData.put(new Locale("hr", ""), ", ");
        DefaultAndData.put(new Locale("cs", ""), "");
        DefaultAndData.put(new Locale("fi", ""), ", ");
        DefaultAndData.put(new Locale("hu", ""), "eg\u00e9sz-");
        DefaultAndData.put(new Locale("el", ""), " \u03ba\u03b1\u03b9 ");
        DefaultAndData.put(new Locale("sk", ""), ", ");
        DefaultAndData.put(new Locale("ro", ""), " \u015fi ");
        DefaultAndData.put(new Locale("iw", ""), "\u05d4 \u05d5-");
        DefaultAndData.put(new Locale("lt", ""), " ir ");
        DefaultAndData.put(new Locale("id", ""), " dan ");
        DefaultAndData.put(new Locale("sh", ""), " celih i ");
        DefaultAndData.put(new Locale("sr", ""), " \u0446\u0435\u043b\u0438\u0445 \u0438 ");
        DefaultAndData.put(new Locale("tr", ""), ", ");
        DefaultAndData.put(new Locale("vi", ""), " \u0111\u1ed3ng ");
        DefaultAndData.put(new Locale("sq", ""), " presje ");
        DefaultAndData.put(new Locale("kk", ""), " \u0431\u04af\u0442\u0456\u043d \u0436\u04af\u0437\u0434\u0435\u043d ");
        Fraction1AndData = new Hashtable();
        Fraction1AndData.put(new Locale("da", ""), " ");
        Fraction1AndData.put(new Locale("it", ""), " ");
        Fraction1AndData.put(new Locale("th", ""), " ");
        Fraction1AndData.put(new Locale("zh", ""), " ");
        Fraction1AndData.put(new Locale("ja", ""), " ");
        Fraction2ZeroData = new Hashtable();
        Fraction2ZeroData.put(new Locale("it", ""), "0");
        DEFAULT_DECIMAL_STYLE_MAP = new Hashtable();
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("de", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("fr", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("fr", "CA"), new Integer(10));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("nl", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("es", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("it", ""), new Integer(11));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("pt", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("ru", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("sv", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("th", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("zh", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("ar", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("hr", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("cs", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("fi", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("hu", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("ro", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("sk", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("sr", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("sh", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("sq", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("tr", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("ja", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("vi", ""), new Integer(20));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("uk", ""), new Integer(30));
        DEFAULT_DECIMAL_STYLE_MAP.put(new Locale("kk", ""), new Integer(20));
    }
}

