/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.text.resources;

import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.resources.JavaNumberResourceAccessor;

public abstract class NumberResourceAccessor {
    public static final String RCS_ID = "$Header: NumberResourceAccessor.java 120.0 2005/05/07 08:27:19 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: NumberResourceAccessor.java 120.0 2005/05/07 08:27:19 appldev ship $", "oracle.apps.fnd.i18n.common.text.resources");
    private static Hashtable m_CashedResourceAccessor = new Hashtable();
    public static final int RESOURCE_JAVA = 7;
    public static final int RESOURCE_DEFAULT = 7;

    public static NumberResourceAccessor getInstance(Locale locale, int n) {
        return NumberResourceAccessor.getNumberResourceAccessor(locale, n);
    }

    public static NumberResourceAccessor getInstance(Locale locale) {
        return NumberResourceAccessor.getInstance(locale, 7);
    }

    private static NumberResourceAccessor getNumberResourceAccessor(Locale locale, int n) {
        String string = locale.toString() + n;
        NumberResourceAccessor numberResourceAccessor = (NumberResourceAccessor)m_CashedResourceAccessor.get(string);
        if (numberResourceAccessor == null) {
            switch (n) {
                case 7: {
                    numberResourceAccessor = new JavaNumberResourceAccessor(locale);
                    break;
                }
                default: {
                    numberResourceAccessor = new JavaNumberResourceAccessor(locale);
                }
            }
            m_CashedResourceAccessor.put(string, numberResourceAccessor);
        }
        return numberResourceAccessor;
    }

    public abstract char getZeroDigitRes();

    public abstract char getGroupingSeparatorRes();

    public abstract char getDecimalSeparatorRes();

    public abstract char getPerMillRes();

    public abstract char getPercentRes();

    public abstract char getDigitRes();

    public abstract char getPatternSeparatorRes();

    public abstract String getInfinityRes();

    public abstract String getNaNRes();

    public abstract char getMinusSignRes();

    public abstract String getCurrencySymbolRes();

    public abstract String getInternationalCurrencySymbolRes();

    public abstract char getMonetaryDecimalSeparatorRes();
}

