/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.BuddhistCalendar;
import oracle.apps.fnd.i18n.common.util.GregorianCalendar;
import oracle.apps.fnd.i18n.common.util.HijrahCalendar;
import oracle.apps.fnd.i18n.common.util.JapaneseCalendar;
import oracle.apps.fnd.i18n.common.util.ROCCalendar;

public abstract class Calendar
implements Serializable,
Cloneable {
    public static final String RCS_ID = "$Header: Calendar.java 120.8 2011/11/14 18:52:17 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: Calendar.java 120.8 2011/11/14 18:52:17 rsuzuki ship $", "oracle.apps.fnd.i18n.common.util");
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int ZONE_HOUR = 17;
    public static final int ZONE_MINUTE = 18;
    public static final int NANOSECOND = 19;
    public static final int CENTURY = 20;
    public static final int ISO_WEEK_OF_YEAR = 21;
    public static final int FIELD_COUNT = 22;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int GREGORIAN = 0;
    public static final int JAPANESE_IMPERIAL = 1;
    public static final int THAI_BUDDHA = 2;
    public static final int ENGLISH_HIJRAH = 3;
    public static final int ARABIC_HIJRAH = 4;
    public static final int ROC_OFFICIAL = 5;
    protected int[] mFields = new int[22];
    protected transient int[] mStamp = new int[22];
    protected long mTime;
    protected int mNanos = 0;
    protected int mCalendarType = 0;
    private boolean m_IsTimeSet;
    private boolean m_AreFieldsSet;
    private transient boolean m_AreAllFieldsSet;
    private boolean m_Lenient = true;
    private TimeZone m_Zone;
    private java.util.GregorianCalendar m_JavaCal;
    private int m_FirstDayOfWeek;
    private int m_MinimalDaysInFirstWeek;
    private static Hashtable m_CachedLocaleData = new Hashtable(3);
    protected static final int UNSET = 0;
    protected static final int INTERNALLY_SET = 1;
    protected static final int MINIMUM_USER_STAMP = 2;
    protected int mNextStamp = 2;
    protected static final int BE = 0;
    protected static final int AE = 1;
    private static final int EPOCH_YEAR = 1970;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final int GREGORIAN_JAN_1_1_JULIAN_DAY = 1721426;
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final String[] FIELD_NAME = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET=", ",ZONE_HOUR=", ",ZONE_MINUTE=", ",NANOSECOND=", ",CENTURY="};
    private static final int[] GREGORIAN_NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] GREGORIAN_LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this.m_Zone = timeZone;
        this.m_JavaCal = new java.util.GregorianCalendar(this.m_Zone);
        this.m_JavaCal.setGregorianChange(new Date(Long.MIN_VALUE));
        this.setWeekCountData(locale);
    }

    public static Calendar getInstance() {
        return Calendar.createCalendar(TimeZone.getDefault(), Locale.getDefault(), 0);
    }

    public static Calendar getInstance(int n) {
        return Calendar.createCalendar(TimeZone.getDefault(), Locale.getDefault(), n);
    }

    public static Calendar getInstance(TimeZone timeZone) {
        return Calendar.createCalendar(timeZone, Locale.getDefault(), 0);
    }

    public static Calendar getInstance(TimeZone timeZone, int n) {
        return Calendar.createCalendar(timeZone, Locale.getDefault(), n);
    }

    public static Calendar getInstance(Locale locale) {
        return Calendar.createCalendar(TimeZone.getDefault(), locale, 0);
    }

    public static Calendar getInstance(Locale locale, int n) {
        return Calendar.createCalendar(TimeZone.getDefault(), locale, n);
    }

    public static Calendar getInstance(TimeZone timeZone, Locale locale) {
        return Calendar.createCalendar(timeZone, locale, 0);
    }

    public static Calendar getInstance(TimeZone timeZone, Locale locale, int n) {
        return Calendar.createCalendar(timeZone, locale, n);
    }

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public final Timestamp getTimestamp() {
        Timestamp timestamp = new Timestamp(this.getTimeInMillis() / 1000L * 1000L);
        timestamp.setNanos(this.mNanos);
        return timestamp;
    }

    public final long getTimeInMillis() {
        if (!this.m_IsTimeSet) {
            this.updateTime();
        }
        return this.mTime;
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public final void setTimestamp(Timestamp timestamp) {
        int n = timestamp.getNanos();
        long l = timestamp.getTime() / 1000L * 1000L + (long)(n / 1000000);
        this.setTimeInNanos(l, n);
    }

    public final void setTimeInMillis(long l) {
        int n = (int)(l % 1000L * 1000000L);
        if (n < 0) {
            n = 1000000000 + n;
        }
        this.setTimeInNanos(l, n);
    }

    private void setTimeInNanos(long l, int n) {
        this.mNanos = n;
        this.mTime = l;
        this.m_IsTimeSet = true;
        this.m_AreFieldsSet = false;
        if (!this.m_AreFieldsSet) {
            this.computeFields();
            this.m_AreFieldsSet = true;
            this.m_AreAllFieldsSet = true;
        }
    }

    public int get(int n) {
        this.complete();
        return this.internalGet(n);
    }

    final int internalGet(int n) {
        return this.mFields[n];
    }

    final void internalSet(int n, int n2) {
        this.mFields[n] = n2;
    }

    final void internalClear(int n) {
        this.mFields[n] = 0;
        this.mStamp[n] = 0;
        this.m_AreFieldsSet = false;
        this.m_AreAllFieldsSet = false;
    }

    public void set(int n, int n2) {
        this.m_IsTimeSet = false;
        if (n == 14) {
            this.internalSet(n, n2);
            this.internalSet(19, n2 * 1000000);
            ++this.mNextStamp;
        } else if (n == 19) {
            if (n2 > 999999999 || n2 < 0) {
                throw new IllegalArgumentException("nanosecond > 999999999 or < 0");
            }
            this.internalSet(n, n2);
            this.internalSet(14, n2 / 1000000);
            ++this.mNextStamp;
        } else {
            this.internalSet(n, n2);
        }
        ++this.mNextStamp;
        if (this.mNextStamp == Integer.MAX_VALUE) {
            this.adjustStamp();
        }
        this.m_AreFieldsSet = false;
    }

    public final void set(int n, int n2, int n3) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
        this.set(19, n7);
    }

    public final void clear() {
        this.mFields = new int[22];
        this.mStamp = new int[22];
        this.m_AreFieldsSet = false;
        this.m_AreAllFieldsSet = false;
        this.m_IsTimeSet = false;
    }

    public final void clear(int n) {
        this.mFields[n] = 0;
        this.mStamp[n] = 0;
        this.m_AreFieldsSet = false;
        this.m_AreAllFieldsSet = false;
        this.m_IsTimeSet = false;
    }

    public final boolean isSet(int n) {
        return this.mStamp[n] != 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        return this.getTimeInMillis() == calendar.getTimeInMillis() && this.m_Lenient == calendar.m_Lenient && this.m_FirstDayOfWeek == calendar.m_FirstDayOfWeek && this.m_MinimalDaysInFirstWeek == calendar.m_MinimalDaysInFirstWeek && this.m_Zone.equals(calendar.m_Zone);
    }

    public int hashCode() {
        return (this.m_Lenient ? 1 : 0) | this.m_FirstDayOfWeek << 1 | this.m_MinimalDaysInFirstWeek << 4 | this.m_Zone.hashCode() << 7;
    }

    public boolean before(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean after(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.complete();
        if (n == 1) {
            int n3 = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                } else {
                    this.set(1, 1 - n3);
                    this.set(0, 0);
                }
            } else if (this.internalGetEra() == 0) {
                if ((n3 -= n2) > 0) {
                    this.set(1, n3);
                } else {
                    this.set(1, 1 - n3);
                    this.set(0, 1);
                }
            } else if (this.internalGetEra() == this.getCurrentEra()) {
                this.set(1, n3 += n2);
            } else {
                this.handleEra(this.internalGetEra(), n3 + n2);
            }
            this.pinDayOfMonth();
        } else if (n == 2) {
            int n4 = this.internalGet(2) + n2;
            int n5 = this.internalGet(1);
            int n6 = n4 >= 0 ? n4 / 12 : (n4 + 1) / 12 - 1;
            if (n6 != 0) {
                if (this.internalGetEra() == 1) {
                    if ((n5 += n6) > 0) {
                        this.set(1, n5);
                    } else {
                        this.set(1, 1 - n5);
                        this.set(0, 0);
                    }
                } else if (this.internalGetEra() == 0) {
                    if ((n5 -= n6) > 0) {
                        this.set(1, n5);
                    } else {
                        this.set(1, 1 - n5);
                        this.set(0, 1);
                    }
                } else if (this.internalGetEra() == this.getCurrentEra()) {
                    this.set(1, n5 += n6);
                } else {
                    this.handleEra(this.internalGetEra(), n5 + n6);
                }
            }
            if (n4 >= 0) {
                this.set(2, n4 % 12);
            } else {
                if ((n4 %= 12) < 0) {
                    n4 += 12;
                }
                this.set(2, 0 + n4);
            }
            this.pinDayOfMonth();
        } else if (n == 0) {
            int n7 = this.internalGet(0) + n2;
            if (n7 < 0) {
                n7 = 0;
            }
            if (n7 > this.getCurrentEra()) {
                n7 = this.getCurrentEra();
            }
            this.set(0, n7);
        } else {
            long l = n2;
            boolean bl = true;
            switch (n) {
                case 3: 
                case 4: 
                case 8: 
                case 21: {
                    l *= 604800000L;
                    break;
                }
                case 9: {
                    l *= 43200000L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    l *= 86400000L;
                    break;
                }
                case 10: 
                case 11: {
                    l *= 3600000L;
                    bl = false;
                    break;
                }
                case 12: {
                    l *= 60000L;
                    bl = false;
                    break;
                }
                case 13: {
                    l *= 1000L;
                    bl = false;
                    break;
                }
                case 14: {
                    bl = false;
                    break;
                }
                case 19: {
                    l = (this.mNanos + n2) / 1000000;
                    this.mNanos = (this.mNanos + n2) % 1000000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            long l2 = 0L;
            if (bl) {
                l2 = this.internalGet(16);
            }
            this.setTimeInMillis(this.mTime + l);
            if (bl && (l2 -= (long)this.internalGet(16)) != 0L) {
                this.setTimeInMillis(this.mTime + l2);
            }
        }
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    public void roll(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        if (n >= 0 && n < 22) {
            this.complete();
            n3 = this.getMinimum(n);
            n4 = this.getMaximum(n);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                Date date = this.getTime();
                int n5 = this.internalGet(n);
                int n6 = (n5 + n2) % (n4 + 1);
                if (n6 < 0) {
                    n6 += n4 + 1;
                }
                this.setTime(new Date(date.getTime() + (long)(3600000 * (n6 - n5))));
                return;
            }
            case 2: {
                int n7 = (this.internalGet(2) + n2) % 12;
                if (n7 < 0) {
                    n7 += 12;
                }
                this.set(2, n7);
                int n8 = this.monthLength(n7);
                int n9 = this.internalGet(5);
                if (n9 > n8) {
                    this.set(5, n8);
                }
                return;
            }
            case 3: {
                this.rollWeekOfYear(3, n2, this.getFirstDayOfWeek(), this.getMinimalDaysInFirstWeek());
                return;
            }
            case 21: {
                this.rollWeekOfYear(21, n2, 2, 4);
                return;
            }
            case 4: {
                int n10;
                int n11 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n11 < 0) {
                    n11 += 7;
                }
                if ((n10 = (n11 - this.internalGet(5) + 1) % 7) < 0) {
                    n10 += 7;
                }
                int n12 = 7 - n10 < this.getMinimalDaysInFirstWeek() ? 8 - n10 : 1 - n10;
                int n13 = this.monthLength(this.internalGet(2));
                int n14 = (n13 - this.internalGet(5) + n11) % 7;
                int n15 = n13 + 7 - n14;
                int n16 = n15 - n12;
                int n17 = (this.internalGet(5) + n2 * 7 - n12) % n16;
                if (n17 < 0) {
                    n17 += n16;
                }
                if ((n17 += n12) < 1) {
                    n17 = 1;
                }
                if (n17 > n13) {
                    n17 = n13;
                }
                this.set(5, n17);
                return;
            }
            case 5: {
                n4 = this.monthLength(this.internalGet(2));
                break;
            }
            case 6: {
                long l = (long)n2 * 86400000L;
                long l2 = this.mTime - (long)(this.internalGet(6) - 1) * 86400000L;
                int n18 = this.yearLength();
                this.mTime = (this.mTime + l - l2) % ((long)n18 * 86400000L);
                if (this.mTime < 0L) {
                    this.mTime += (long)n18 * 86400000L;
                }
                long l3 = this.internalGet(16);
                this.setTimeInMillis(this.mTime + l2);
                if ((l3 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.mTime + l3);
                }
                return;
            }
            case 7: {
                long l = (long)n2 * 86400000L;
                int n19 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n19 < 0) {
                    n19 += 7;
                }
                long l4 = this.mTime - (long)n19 * 86400000L;
                this.mTime = (this.mTime + l - l4) % 604800000L;
                if (this.mTime < 0L) {
                    this.mTime += 604800000L;
                }
                long l5 = this.internalGet(16);
                this.setTimeInMillis(this.mTime + l4);
                if ((l5 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.mTime + l5);
                }
                return;
            }
            case 8: {
                long l = (long)n2 * 604800000L;
                int n20 = (this.internalGet(5) - 1) / 7;
                int n21 = (this.monthLength(this.internalGet(2)) - this.internalGet(5)) / 7;
                long l6 = this.mTime - (long)n20 * 604800000L;
                long l7 = 604800000L * (long)(n20 + n21 + 1);
                this.mTime = (this.mTime + l - l6) % l7;
                if (this.mTime < 0L) {
                    this.mTime += l7;
                }
                long l8 = this.internalGet(16);
                this.setTimeInMillis(this.mTime + l6);
                if ((l8 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.mTime + l8);
                }
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n22 = n4 - n3 + 1;
        int n23 = this.internalGet(n) + n2;
        n23 = (n23 - n3) % n22;
        if (n23 < 0) {
            n23 += n22;
        }
        this.set(n, n23 += n3);
    }

    private void rollWeekOfYear(int n, int n2, int n3, int n4) {
        int n5 = this.internalGet(n);
        int n6 = this.internalGet(1);
        int n7 = this.internalGet(6);
        if (this.internalGet(2) == 0) {
            if (n5 >= 52) {
                n7 += this.yearLength(--n6);
            }
        } else if (n5 == 1) {
            n7 -= this.yearLength(n6);
            ++n6;
        }
        if ((n5 += n2) < 1 || n5 > 52) {
            int n8;
            int n9;
            int n10 = this.yearLength(n6);
            int n11 = this.internalGet(7) - n3;
            if (n11 < 0) {
                n11 += 7;
            }
            if ((n9 = (n10 - n7 + n11) % 7) < 0) {
                n9 += 7;
            }
            if ((n10 -= n9 + 1) - (n8 = n10 / 7) * 7 >= n4) {
                ++n8;
            }
            if (6 - n9 < n4) {
                ++n8;
            }
            n5 = (n5 + n8 - 1) % n8 + 1;
        }
        this.set(n, n5);
        this.set(1, n6);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.m_Zone = timeZone;
        this.m_JavaCal.setTimeZone(this.m_Zone);
        this.m_AreFieldsSet = false;
    }

    public TimeZone getTimeZone() {
        return this.m_Zone;
    }

    public int getType() {
        return this.mCalendarType;
    }

    public static synchronized Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    public void setLenient(boolean bl) {
        this.m_Lenient = bl;
    }

    public boolean isLenient() {
        return this.m_Lenient;
    }

    public void setFirstDayOfWeek(int n) {
        if (this.m_FirstDayOfWeek == n) {
            return;
        }
        this.m_FirstDayOfWeek = n;
        this.invalidateWeekFields();
    }

    public int getFirstDayOfWeek() {
        return this.m_FirstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        if (this.m_MinimalDaysInFirstWeek == n) {
            return;
        }
        this.m_MinimalDaysInFirstWeek = n;
        this.invalidateWeekFields();
    }

    public int getMinimalDaysInFirstWeek() {
        return this.m_MinimalDaysInFirstWeek;
    }

    public abstract boolean isLeapYear(int var1);

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int n) {
        int n2;
        int n3 = this.getGreatestMinimum(n);
        if (n3 == (n2 = this.getMinimum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3--;
        } while (n3 >= n2);
        return n4;
    }

    public int getActualMaximum(int n) {
        int n2;
        int n3 = this.getLeastMaximum(n);
        if (n3 == (n2 = this.getMaximum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        if (n == 3 || n == 4) {
            calendar.set(7, this.m_FirstDayOfWeek);
        }
        if (n == 21) {
            calendar.set(7, 2);
        }
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3++;
        } while (n3 <= n2);
        return n4;
    }

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.mFields = new int[22];
            calendar.mStamp = new int[22];
            System.arraycopy(this.mFields, 0, calendar.mFields, 0, 22);
            System.arraycopy(this.mStamp, 0, calendar.mStamp, 0, 22);
            calendar.m_Zone = (TimeZone)this.m_Zone.clone();
            calendar.m_JavaCal = (java.util.GregorianCalendar)this.m_JavaCal.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[time=");
        stringBuffer.append(this.m_IsTimeSet ? String.valueOf(this.mTime) : "?");
        stringBuffer.append(",areFieldsSet=");
        stringBuffer.append(this.m_AreFieldsSet);
        stringBuffer.append(",areAllFieldsSet=");
        stringBuffer.append(this.m_AreAllFieldsSet);
        stringBuffer.append(",lenient=");
        stringBuffer.append(this.m_Lenient);
        stringBuffer.append(",zone=");
        stringBuffer.append(this.m_Zone);
        stringBuffer.append(",firstDayOfWeek=");
        stringBuffer.append(this.m_FirstDayOfWeek);
        stringBuffer.append(",minimalDaysInFirstWeek=");
        stringBuffer.append(this.m_MinimalDaysInFirstWeek);
        for (int i = 0; i < 22; ++i) {
            stringBuffer.append(FIELD_NAME[i]);
            stringBuffer.append(this.isSet(i) ? String.valueOf(this.mFields[i]) : "?");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void complete() {
        if (!this.m_IsTimeSet) {
            this.updateTime();
        }
        if (!this.m_AreFieldsSet) {
            this.computeFields();
            this.m_AreFieldsSet = true;
            this.m_AreAllFieldsSet = true;
        }
    }

    private void updateTime() {
        this.computeTime();
        if (this.isLenient() || !this.m_AreAllFieldsSet) {
            this.m_AreFieldsSet = false;
        }
        this.m_IsTimeSet = true;
    }

    private void computeTime() {
        int n;
        int n2;
        int n3;
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        int n4 = this.mStamp[1] != 0 ? this.internalGet(1) : 1970;
        int n5 = 2;
        int n6 = this.getCurrentEra();
        if (this.mStamp[0] != 0) {
            n6 = this.internalGet(0);
            n5 |= 1;
        }
        int[] nArray = new int[]{n5};
        long l = this.computeJulianDay(n6, n4, nArray);
        long l2 = Calendar.julianDayToMillis(l);
        n5 = nArray[0];
        int n7 = 0;
        int n8 = this.mStamp[10];
        int n9 = this.mStamp[11];
        int n10 = n3 = n8 > n9 ? n8 : n9;
        if (n3 != 0) {
            if (n3 == n9) {
                n7 += this.internalGet(11);
                n5 |= 0x800;
            } else {
                n7 += this.internalGet(10);
                n5 |= 0x400;
                if (this.mStamp[9] != 0) {
                    n7 += 12 * this.internalGet(9);
                    n5 |= 0x200;
                }
            }
        }
        n7 *= 60;
        if (this.mStamp[12] != 0) {
            n7 += this.internalGet(12);
            n5 |= 0x1000;
        }
        n7 *= 60;
        if (this.mStamp[13] != 0) {
            n7 += this.internalGet(13);
            n5 |= 0x2000;
        }
        n7 *= 1000;
        if (this.mStamp[14] != 0) {
            n5 |= 0x4000;
        }
        if (this.mStamp[19] != 0) {
            this.mNanos = this.internalGet(19);
            n7 += this.mNanos / 1000000;
            n5 |= 0x80000;
        }
        l2 += (long)n7;
        if (this.mStamp[17] >= 2 || this.mStamp[18] >= 2) {
            n2 = 0;
            n = 0;
            if (this.mStamp[17] >= 2) {
                n = this.internalGet(17) * 3600000;
                n5 |= 0x20000;
            }
            int n11 = 0;
            if (this.mStamp[18] >= 2) {
                n11 = this.internalGet(18) * 60000;
                n5 |= 0x40000;
            }
            n2 = n > 0 ? n + n11 : (n < 0 ? n - n11 : n11);
            this.mTime = l2 - (long)n2;
        } else {
            n2 = 0;
            if (this.mStamp[15] >= 2) {
                n2 = this.internalGet(15);
                n5 |= 0x8000;
            } else {
                n2 = this.m_Zone.getRawOffset();
            }
            if (this.mStamp[16] >= 2) {
                n2 += this.internalGet(16);
                n5 |= 0x10000;
            } else {
                n = this.getOffsets(l2)[1];
                n2 += n;
            }
            this.mTime = l2 - (long)n2;
        }
        if (this.isLenient()) {
            this.computeFieldsImpl();
        }
        for (n2 = 0; n2 < this.mFields.length; ++n2) {
            if (!this.isSet(n2)) continue;
            n = 1 << n2;
            if ((n5 & n) != n) {
                this.internalClear(n2);
                continue;
            }
            this.mStamp[n2] = 1;
        }
    }

    private void computeFields() {
        this.computeFieldsImpl();
        for (int i = 0; i < 22; ++i) {
            this.mStamp[i] = 1;
        }
    }

    private void computeFieldsImpl() {
        int[] nArray = new int[2];
        this.m_JavaCal.setTime(new Date(this.mTime));
        nArray[0] = this.m_JavaCal.get(15);
        nArray[1] = this.m_JavaCal.get(16);
        int n = nArray[0] + nArray[1];
        long l = this.mTime + (long)n;
        if (this.mTime > 0L && l < 0L && n > 0) {
            l = Long.MAX_VALUE;
        } else if (this.mTime < 0L && l > 0L && n < 0) {
            l = Long.MIN_VALUE;
        }
        this.timeToFields(l, false);
        long l2 = Calendar.floorDivide(l, 86400000L);
        int n2 = (int)(l - l2 * 86400000L);
        if (n2 < 0) {
            n2 = (int)((long)n2 + 86400000L);
        }
        this.internalSet(14, n2 % 1000);
        this.internalSet(13, (n2 /= 1000) % 60);
        this.internalSet(12, (n2 /= 60) % 60);
        this.internalSet(11, n2 /= 60);
        this.internalSet(9, n2 / 12);
        this.internalSet(10, n2 % 12);
        this.internalSet(15, nArray[0]);
        this.internalSet(16, nArray[1]);
        this.internalSet(17, n / 3600000);
        this.internalSet(18, n % 3600000 / 60000);
        this.internalSet(19, this.mNanos);
        this.internalSet(20, this.internalGet(1) / 100 + (this.internalGet(1) % 100 > 0 ? 1 : 0));
    }

    private final int[] getOffsets(long l) {
        int[] nArray = this.gregorianFieldInfo(this.millisToJulianDay(l));
        int n = nArray[1];
        int n2 = nArray[2];
        int n3 = nArray[3];
        long l2 = l / 86400000L;
        int n4 = (int)(l - l2 * 86400000L);
        if (n4 < 0) {
            n4 = (int)((long)n4 + 86400000L);
        }
        int n5 = n4 % 1000;
        int n6 = (n4 /= 1000) % 60;
        int n7 = (n4 /= 60) % 60;
        int n8 = n4 /= 60;
        this.m_JavaCal.set(n, n2, n3, n8, n7, n6);
        this.m_JavaCal.set(14, n5);
        long l3 = this.m_JavaCal.getTime().getTime();
        int n9 = this.m_Zone.getRawOffset();
        int n10 = (int)(l - l3 - (long)n9);
        int[] nArray2 = new int[]{n9, n10};
        return nArray2;
    }

    private final long computeJulianDay(int n, int n2, int[] nArray) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        long l = 0L;
        int n6 = nArray[0];
        int n7 = this.mStamp[7];
        int n8 = this.mStamp[2];
        int n9 = this.mStamp[5];
        int n10 = Calendar.aggregateStamp(this.mStamp[4], n7);
        int n11 = Calendar.aggregateStamp(this.mStamp[8], n7);
        int n12 = this.mStamp[6];
        int n13 = Calendar.aggregateStamp(this.mStamp[3], n7);
        int n14 = Calendar.aggregateStamp(this.mStamp[21], n7);
        int n15 = n9;
        if (n10 > n15) {
            n15 = n10;
        }
        if (n11 > n15) {
            n15 = n11;
        }
        if (n12 > n15) {
            n15 = n12;
        }
        if (n13 > n15) {
            n15 = n13;
        }
        if (n14 > n15) {
            n15 = n14;
        }
        if (n15 == 0) {
            n10 = this.mStamp[4];
            n11 = Math.max(this.mStamp[8], n7);
            n13 = this.mStamp[3];
            n15 = Math.max(Math.max(n10, n11), n13);
            n14 = this.mStamp[21];
            n15 = Math.max(Math.max(Math.max(n10, n11), n13), n14);
            if (n15 == 0) {
                n15 = n9 = n8;
            }
        }
        boolean bl = false;
        if (n15 == n9 || n15 == n10 && this.mStamp[4] >= Math.max(this.mStamp[3], this.mStamp[21]) || n15 == n11 && this.mStamp[8] >= Math.max(this.mStamp[3], this.mStamp[21])) {
            bl = true;
            int n16 = n4 = n8 != 0 ? this.internalGet(2) - 0 : 0;
            if (n4 < 0 || n4 > 11) {
                int[] nArray2 = new int[1];
                n2 += Calendar.floorDivide(n4, 12, nArray2);
                n4 = nArray2[0];
            }
            n6 |= 4;
        }
        long l2 = this.yearToJulianDay(n, n2);
        int n17 = this.getFirstDayOfWeek();
        int n18 = this.getMinimalDaysInFirstWeek();
        int n19 = n3 = n == 0 ? 1 - n2 : n2;
        if (bl) {
            l2 += (long)this.monthDays(n4, n3);
            if (n15 == n9) {
                if (this.mStamp[5] != 0) {
                    n5 = this.internalGet(5);
                    n6 |= 0x20;
                } else {
                    n5 = 1;
                }
            } else {
                int n20 = Calendar.julianDayToDayOfWeek(l2 + 1L) - n17;
                if (n20 < 0) {
                    n20 += 7;
                }
                int n21 = 0;
                if (n7 != 0) {
                    n21 = this.internalGet(7) - n17;
                    if (n21 < 0) {
                        n21 += 7;
                    }
                    n6 |= 0x80;
                }
                n5 = 1 - n20 + n21;
                if (n15 == n10) {
                    if (7 - n20 < n18) {
                        n5 += 7;
                    }
                    n5 += 7 * (this.internalGet(4) - 1);
                    n6 |= 0x10;
                } else {
                    int n22;
                    if (n5 < 1) {
                        n5 += 7;
                    }
                    if (this.mStamp[8] != 0) {
                        n22 = this.internalGet(8);
                        n6 |= 0x100;
                    } else {
                        n22 = 1;
                    }
                    n5 = n22 >= 0 ? (n5 += 7 * (n22 - 1)) : (n5 += ((this.monthLength(n4, n3) - n5) / 7 + n22 + 1) * 7);
                }
            }
            l2 += (long)n5;
        } else if (n15 == n12) {
            l2 += (long)this.internalGet(6);
            n6 |= 0x40;
        } else {
            int n23;
            int n24 = 3;
            if (n14 > n13) {
                n17 = 2;
                n18 = 4;
                n24 = 21;
            }
            if ((n23 = Calendar.julianDayToDayOfWeek(l2 + 1L) - n17) < 0) {
                n23 += 7;
            }
            int n25 = 0;
            if (n7 != 0) {
                n25 = this.internalGet(7) - n17;
                if (n25 < 0) {
                    n25 += 7;
                }
                n6 |= 0x80;
            }
            n5 = 1 - n23 + n25;
            if (7 - n23 < n18) {
                n5 += 7;
            }
            n6 |= 1 << n24;
            l2 += (long)(n5 += 7 * (this.internalGet(n24) - 1));
        }
        nArray[0] = n6;
        return l2;
    }

    private final void timeToFields(long l, boolean bl) {
        int[] nArray = this.fieldInfo(this.millisToJulianDay(l));
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        this.internalSet(0, n);
        this.internalSet(1, n2);
        this.internalSet(2, n3 + 0);
        this.internalSet(5, n4);
        this.internalSet(7, n5);
        this.internalSet(6, ++n6);
        if (bl) {
            return;
        }
        int n7 = n == 1 ? n2 : 1 - n2;
        int n8 = this.getFirstDayOfWeek();
        int n9 = this.getMinimalDaysInFirstWeek();
        int n10 = this.getWeekOfYear(n5, n6, n7, n8, n9);
        this.internalSet(3, n10);
        int n11 = this.getWeekOfYear(n5, n6, n7, 2, 4);
        this.internalSet(21, n11);
        this.internalSet(4, this.weekNumber(n4, n5, n8, n9));
        this.internalSet(8, (n4 - 1) / 7 + 1);
    }

    private int getWeekOfYear(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n + 7 - n4) % 7;
        int n7 = (n - n2 + 701 - n4) % 7;
        int n8 = (n2 - 1 + n7) / 7;
        if (7 - n7 >= n5) {
            ++n8;
        }
        if (n2 > 359) {
            int n9 = this.yearLength(n3);
            int n10 = (n6 + n9 - n2) % 7;
            if (n10 < 0) {
                n10 += 7;
            }
            if (6 - n10 >= n5 && n2 + 7 - n6 > n9) {
                n8 = 1;
            }
        } else if (n8 == 0) {
            int n11 = n2 + this.yearLength(n3 - 1);
            n8 = this.weekNumber(n11, n, n4, n5);
        }
        return n8;
    }

    private final long millisToJulianDay(long l) {
        return 2440588L + Calendar.floorDivide(l, 86400000L);
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    private static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private static final int aggregateStamp(int n, int n2) {
        return n != 0 && n2 != 0 ? Math.max(n, n2) : 0;
    }

    private final int weekNumber(int n, int n2, int n3, int n4) {
        int n5 = (n2 - n3 - n + 1) % 7;
        if (n5 < 0) {
            n5 += 7;
        }
        int n6 = (n + n5 - 1) / 7;
        if (7 - n5 >= n4) {
            ++n6;
        }
        return n6;
    }

    private final void pinDayOfMonth() {
        int n = this.monthLength(this.internalGet(2));
        int n2 = this.internalGet(5);
        if (n2 > n) {
            this.set(5, n);
        }
    }

    private final boolean boundsCheck(int n, int n2) {
        return n >= this.getMinimum(n2) && n <= this.getMaximum(n2);
    }

    private final void adjustStamp() {
        int n;
        int n2 = 2;
        int n3 = 2;
        do {
            int n4;
            n = Integer.MAX_VALUE;
            for (n4 = 0; n4 < this.mStamp.length; ++n4) {
                int n5 = this.mStamp[n4];
                if (n5 >= n3 && n > n5) {
                    n = n5;
                }
                if (n2 >= n5) continue;
                n2 = n5;
            }
            if (n2 != n && n == Integer.MAX_VALUE) break;
            for (n4 = 0; n4 < this.mStamp.length; ++n4) {
                if (this.mStamp[n4] != n) continue;
                this.mStamp[n4] = n3;
            }
            ++n3;
        } while (n != n2);
        this.mNextStamp = n3;
    }

    private boolean validateFields() {
        int n;
        for (n = 0; n < 22; ++n) {
            if (n == 5 || n == 6 || !this.isSet(n) || this.boundsCheck(this.internalGet(n), n)) continue;
            return false;
        }
        if (this.mStamp[5] >= 2 && ((n = this.internalGet(5)) < this.getMinimum(5) || n > this.monthLength(this.internalGet(2)))) {
            return false;
        }
        if (this.mStamp[6] >= 2 && ((n = this.internalGet(6)) < 1 || n > this.yearLength())) {
            return false;
        }
        return !this.isSet(8) || 0 != this.internalGet(8);
    }

    private void invalidateWeekFields() {
        if (this.mStamp[4] == 1) {
            this.mStamp[4] = 0;
            this.m_AreFieldsSet = false;
        }
        if (this.mStamp[3] == 1) {
            this.mStamp[3] = 0;
            this.m_AreFieldsSet = false;
        }
    }

    private static Calendar createCalendar(TimeZone timeZone, Locale locale, int n) {
        switch (n) {
            case 0: {
                return new GregorianCalendar(timeZone, locale);
            }
            case 4: {
                return new HijrahCalendar(timeZone, locale);
            }
            case 3: {
                HijrahCalendar hijrahCalendar = new HijrahCalendar(timeZone, locale);
                hijrahCalendar.setType(3);
                return hijrahCalendar;
            }
            case 1: {
                return new JapaneseCalendar(timeZone, locale);
            }
            case 2: {
                return new BuddhistCalendar(timeZone, locale);
            }
            case 5: {
                return new ROCCalendar(timeZone, locale);
            }
        }
        return new GregorianCalendar(timeZone, locale);
    }

    private void setWeekCountData(Locale locale) {
        int[] nArray = (int[])m_CachedLocaleData.get(locale);
        if (nArray == null) {
            java.util.Calendar calendar = java.util.Calendar.getInstance(locale);
            nArray = new int[]{calendar.getFirstDayOfWeek(), calendar.getMinimalDaysInFirstWeek()};
            m_CachedLocaleData.put(locale, nArray);
        }
        this.m_FirstDayOfWeek = nArray[0];
        this.m_MinimalDaysInFirstWeek = nArray[1];
    }

    private static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    private static final int floorDivide(int n, int n2, int[] nArray) {
        if (n >= 0) {
            nArray[0] = n % n2;
            return n / n2;
        }
        int n3 = (n + 1) / n2 - 1;
        nArray[0] = n - n3 * n2;
        return n3;
    }

    private static final int floorDivide(long l, int n, int[] nArray) {
        if (l >= 0L) {
            nArray[0] = (int)(l % (long)n);
            return (int)(l / (long)n);
        }
        int n2 = (int)((l + 1L) / (long)n - 1L);
        nArray[0] = (int)(l - (long)(n2 * n));
        return n2;
    }

    protected abstract int[] fieldInfo(long var1);

    protected abstract long yearToJulianDay(int var1, int var2);

    protected abstract int monthDays(int var1, int var2);

    protected abstract int monthDays(int var1);

    protected abstract int monthLength(int var1, int var2);

    protected abstract int monthLength(int var1);

    protected abstract int yearLength(int var1);

    protected abstract int yearLength();

    protected abstract void handleEra(int var1, int var2);

    protected abstract int getCurrentEra();

    protected final int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : this.getCurrentEra();
    }

    final int[] gregorianFieldInfo(long l) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l2 = l - 1721426L;
        if (l2 > 0L) {
            n6 = (int)(l2 / 146097L);
            n5 = (int)(l2 % 146097L);
            n4 = n5 / 36524;
            n3 = (n5 %= 36524) / 1461;
            n2 = (n5 %= 1461) / 365;
            n5 %= 365;
        } else {
            int[] nArray = new int[1];
            n6 = Calendar.floorDivide(l2, 146097, nArray);
            n4 = Calendar.floorDivide(nArray[0], 36524, nArray);
            n3 = Calendar.floorDivide(nArray[0], 1461, nArray);
            n2 = Calendar.floorDivide(nArray[0], 365, nArray);
            n5 = nArray[0];
        }
        int n7 = 400 * n6 + 100 * n4 + 4 * n3 + n2;
        if (n4 == 4 || n2 == 4) {
            n5 = 365;
        } else {
            ++n7;
        }
        boolean bl = n7 % 4 == 0 && (n7 % 100 != 0 || n7 % 400 == 0);
        int n8 = (int)((l2 + 1L) % 7L);
        int n9 = 0;
        int n10 = n = bl ? 60 : 59;
        if (n5 >= n) {
            n9 = bl ? 1 : 2;
        }
        int n11 = (12 * (n5 + n9) + 6) / 367;
        int n12 = n5 - (bl ? GREGORIAN_LEAP_NUM_DAYS[n11] : GREGORIAN_NUM_DAYS[n11]) + 1;
        n8 += n8 < 0 ? 8 : 1;
        int n13 = n7;
        int[] nArray = new int[]{n13 < 1 ? 0 : 1, n13 < 1 ? 1 - n13 : n13, n11, n12, n8, n5};
        return nArray;
    }
}

