/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;

public class DateFormatMaskConverter {
    public static final String RCS_ID = "$Header: DateFormatMaskConverter.java 120.9 2011/11/14 19:05:28 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DateFormatMaskConverter.java 120.9 2011/11/14 19:05:28 rsuzuki ship $", "oracle.apps.fnd.i18n.common.util");
    private static Hashtable m_CachedConvertedPatternOracleToJava = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternMSToJava = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternOracleToExcel = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternMSToExcel = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternJavaToExcel = new Hashtable(50);

    public static String getJavaDateFormatFromOracle(String string) {
        return DateFormatMaskConverter.getJavaDateFormatFromOracle(string, Locale.getDefault());
    }

    public static String getJavaDateFormatFromOracle(String string, Locale locale) {
        return DateFormatMaskConverter.getJavaDateFormatFromOracle(string, locale, true);
    }

    static String getJavaDateFormatFromOracle(String string, Locale locale, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternOracleToJava.get(string + locale.toString());
        if (string2 == null) {
            string2 = DateFormatMaskConverter.convertFromOracleToJava(string, "", locale, bl);
            m_CachedConvertedPatternOracleToJava.put(string + locale.toString(), string2);
        }
        return string2;
    }

    public static String getJavaDateFormatFromMS(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternMSToJava.get(string);
        if (string2 == null) {
            string2 = DateFormatMaskConverter.convertFromMSToJava(string, "");
            m_CachedConvertedPatternMSToJava.put(string, string2);
        }
        return string2;
    }

    private static String convertInTextFromOracleToJava(String string, String string2, Locale locale, boolean bl) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return DateFormatMaskConverter.convertInTextFromOracleToJava(string, string2, locale, bl);
    }

    private static String convertInTextFromMSToJava(String string, String string2) {
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return DateFormatMaskConverter.convertInTextFromMSToJava(string, string2);
    }

    private static String convertFromOracleToJava(String string, String string2, Locale locale, boolean bl) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return string2.trim();
        }
        if (string.toUpperCase(Locale.US).startsWith("AD")) {
            string = string.substring(2);
            string2 = string2 + "G";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("A.D.")) {
            string = string.substring(4);
            string2 = string2 + "G";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("BC")) {
            string = string.substring(2);
            string2 = string2 + "G";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("B.C.")) {
            string = string.substring(4);
            string2 = string2 + "G";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("AM")) {
            string = string.substring(2);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("A.M.")) {
            string = string.substring(4);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("PM")) {
            string = string.substring(2);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("P.M.")) {
            string = string.substring(4);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("FM")) {
            string = string.substring(2);
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("FX")) {
            string = string.substring(2);
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DDD")) {
            string = string.substring(3);
            string2 = string2 + "DDD";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DAY")) {
            string = string.substring(3);
            string2 = string2 + "EEEE";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DY")) {
            string = string.substring(2);
            string2 = string2 + "EEE";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DD")) {
            string = string.substring(2);
            string2 = string2 + "dd";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH24")) {
            string = string.substring(4);
            string2 = string2 + "HH";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH12")) {
            string = string.substring(4);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH")) {
            string = string.substring(2);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("IW")) {
            string = string.substring(2);
            string2 = string2 + "ww";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MI")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MM")) {
            string = string.substring(2);
            string2 = string2 + "MM";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MONTH")) {
            string = string.substring(5);
            string2 = string2 + "MMMMM";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MON")) {
            string = string.substring(3);
            string2 = string2 + "MMM";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("SS")) {
            string = string.substring(2);
            string2 = string2 + "ss";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("WW")) {
            string = string.substring(2);
            string2 = string2 + "ww";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("W")) {
            string = string.substring(1);
            string2 = string2 + "W";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYYY")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYY")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("YY")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("Y")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRRR")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRR")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("RR")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("R")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("X")) {
            string = string.substring(1);
            string2 = string2 + new DecimalFormatSymbols(locale).getDecimalSeparator();
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("FF3")) {
            string = string.substring(3);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZD")) {
            string = string.substring(3);
            string2 = string2 + "z";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZR")) {
            string = string.substring(3);
            string2 = string2 + "zzzz";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "''";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertInTextFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("-")) {
            string = string.substring(1);
            string2 = string2 + "-";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
            string2 = string2 + "/";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith(",")) {
            string = string.substring(1);
            string2 = string2 + ",";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
            string2 = string2 + ".";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith(";")) {
            string = string.substring(1);
            string2 = string2 + ";";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith(":")) {
            string = string.substring(1);
            string2 = string2 + ":";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith(" ")) {
            string = string.substring(1);
            string2 = string2 + " ";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("CC")) {
            string = string.substring(2);
            string2 = string2 + "CC";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("D")) {
            string = string.substring(1);
            string2 = string2 + "D";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("DL")) {
            string = string.substring(2);
            string2 = string2 + "DL";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("DS")) {
            string = string.substring(2);
            string2 = string2 + "DS";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            string2 = string2 + "EE";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("TZH")) {
            string = string.substring(3);
            string2 = string2 + "TZH";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("TZM")) {
            string = string.substring(3);
            string2 = string2 + "TZM";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF1")) {
            string = string.substring(3);
            string2 = string2 + "FF1";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF2")) {
            string = string.substring(3);
            string2 = string2 + "FF2";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF3")) {
            string = string.substring(3);
            string2 = string2 + "FF3";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF4")) {
            string = string.substring(3);
            string2 = string2 + "FF4";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF5")) {
            string = string.substring(3);
            string2 = string2 + "FF5";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF6")) {
            string = string.substring(3);
            string2 = string2 + "FF6";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF7")) {
            string = string.substring(3);
            string2 = string2 + "FF7";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF8")) {
            string = string.substring(3);
            string2 = string2 + "FF8";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (string.startsWith("FF9")) {
            string = string.substring(3);
            string2 = string2 + "FF9";
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        if (bl) {
            String string3 = string.substring(0, 1);
            string = string.substring(1);
            string2 = string2 + string3;
            return DateFormatMaskConverter.convertFromOracleToJava(string, string2, locale, bl);
        }
        throw new IllegalArgumentException();
    }

    private static String convertFromMSToJava(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2.trim();
        }
        if (string.startsWith("ggg")) {
            string = string.substring(3);
            string2 = string2 + "G";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("gg")) {
            string = string.substring(2);
            string2 = string2 + "G";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("g")) {
            string = string.substring(1);
            string2 = string2 + "G";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("EEEE")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("EEE")) {
            string = string.substring(3);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("E")) {
            string = string.substring(1);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("e")) {
            string = string.substring(1);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("\u661f\u671fW")) {
            string = string.substring(3);
            string2 = string2 + "EEEE";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("O")) {
            string = string.substring(1);
            string2 = string2 + "M";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("aaa")) {
            string = string.substring(3);
            string2 = string2 + "E";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("AMPM")) {
            string = string.substring(4);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("A")) {
            string = string.substring(1);
            string2 = string2 + "d";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("am/pm")) {
            string = string.substring(5);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("dddd")) {
            string = string.substring(4);
            string2 = string2 + "EEEE";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("ddd")) {
            string = string.substring(3);
            string2 = string2 + "E";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("yyyy")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("yyy")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("yy")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("y")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("zzz")) {
            string = string.substring(3);
            string2 = string2 + "zzzz";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("zz")) {
            string = string.substring(2);
            string2 = string2 + "zzzz";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("z")) {
            string = string.substring(1);
            string2 = string2 + "zzzz";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("tt")) {
            string = string.substring(2);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("t")) {
            string = string.substring(1);
            string2 = string2 + "a";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("fffffff")) {
            string = string.substring(7);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("ffffff")) {
            string = string.substring(6);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("fffff")) {
            string = string.substring(5);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("ffff")) {
            string = string.substring(4);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("fff")) {
            string = string.substring(3);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("ff")) {
            string = string.substring(2);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("f")) {
            string = string.substring(1);
            string2 = string2 + "SSS";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertFromMSToJava(string, string2);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertInTextFromMSToJava(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return DateFormatMaskConverter.convertFromMSToJava(string, string2);
    }

    public static String getExcelDateFormatFromOracle(String string) {
        return DateFormatMaskConverter.getExcelDateFormatFromOracle(string, true);
    }

    static String getExcelDateFormatFromOracle(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternOracleToExcel.get(string);
        if (string2 == null) {
            string2 = DateFormatMaskConverter.convertFromOracleToExcel(string, "", bl);
            m_CachedConvertedPatternOracleToExcel.put(string, string2);
        }
        return string2;
    }

    public static String getExcelDateFormatFromMS(String string) {
        return DateFormatMaskConverter.getExcelDateFormatFromMS(string, true);
    }

    private static String getExcelDateFormatFromMS(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternMSToExcel.get(string);
        if (string2 == null) {
            string2 = DateFormatMaskConverter.convertFromMSToExcel(string, "", bl);
            m_CachedConvertedPatternMSToExcel.put(string, string2);
        }
        return string2;
    }

    public static String getExcelDateFormatFromJava(String string) {
        return DateFormatMaskConverter.getExcelDateFormatFromJava(string, true);
    }

    private static String getExcelDateFormatFromJava(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternJavaToExcel.get(string);
        if (string2 == null) {
            string2 = DateFormatMaskConverter.convertFromJavaToExcel(string, "", bl);
            m_CachedConvertedPatternJavaToExcel.put(string, string2);
        }
        return string2;
    }

    private static String convertFromMSToExcel(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0) {
            return string2.trim();
        }
        if (string.startsWith("AMPM")) {
            string = string.substring(4);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("am/pm")) {
            string = string.substring(5);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("dddd")) {
            string = string.substring(4);
            string2 = string2 + "dddd";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("ddd")) {
            string = string.substring(3);
            string2 = string2 + "ddd";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("dd")) {
            string = string.substring(2);
            string2 = string2 + "dd";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("d")) {
            string = string.substring(1);
            string2 = string2 + "d";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("MMMM")) {
            string = string.substring(4);
            string2 = string2 + "mmmm";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("MMM")) {
            string = string.substring(3);
            string2 = string2 + "mmm";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("MM")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("M")) {
            string = string.substring(1);
            string2 = string2 + "m";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("yyyy")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("yyy")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("yy")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("y")) {
            string = string.substring(1);
            string2 = string2 + "y";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("hh")) {
            string = string.substring(2);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("h")) {
            string = string.substring(1);
            string2 = string2 + "h";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("HH")) {
            string = string.substring(2);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("H")) {
            string = string.substring(1);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("mm")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("m")) {
            string = string.substring(1);
            string2 = string2 + "m";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("ss")) {
            string = string.substring(2);
            string2 = string2 + "ss";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("s")) {
            string = string.substring(1);
            string2 = string2 + "s";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("fffffff")) {
            string = string.substring(7);
            string2 = string2 + "0000000";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("ffffff")) {
            string = string.substring(6);
            string2 = string2 + "000000";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("fffff")) {
            string = string.substring(5);
            string2 = string2 + "00000";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("ffff")) {
            string = string.substring(4);
            string2 = string2 + "0000";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("fff")) {
            string = string.substring(3);
            string2 = string2 + "000";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("ff")) {
            string = string.substring(2);
            string2 = string2 + "00";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("f")) {
            string = string.substring(1);
            string2 = string2 + "0";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("tt")) {
            string = string.substring(2);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("t")) {
            string = string.substring(1);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("ggg")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("gg")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("g")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("EEEE")) {
            string = string.substring(4);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("EEE")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("E")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("ee")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("e")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("\u661f\u671fW")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("O")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("aaa")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("zzzz")) {
            string = string.substring(4);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("zzz")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("zz")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("z")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("A")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertInTextFromMSToExcelDouble(string, string2, bl);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertInTextFromMSToExcelSingle(string, string2, bl);
        }
        if (bl) {
            String string3 = string.substring(0, 1);
            string = string.substring(1);
            string2 = string2 + string3;
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        throw new IllegalArgumentException();
    }

    private static String convertInTextFromMSToExcelSingle(String string, String string2, boolean bl) {
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        String string3 = string.substring(0, 1);
        string = string.startsWith("\"") ? string.substring(1) : string.substring(1);
        string2 = string2 + string3;
        return DateFormatMaskConverter.convertInTextFromMSToExcelSingle(string, string2, bl);
    }

    private static String convertInTextFromMSToExcelDouble(String string, String string2, boolean bl) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertFromMSToExcel(string, string2, bl);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return DateFormatMaskConverter.convertInTextFromMSToExcelDouble(string, string2, bl);
    }

    private static String convertFromOracleToExcel(String string, String string2, boolean bl) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return string2.trim();
        }
        if (string.toUpperCase(Locale.US).startsWith("AM")) {
            string = string.substring(2);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("A.M.")) {
            string = string.substring(4);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("PM")) {
            string = string.substring(2);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("P.M.")) {
            string = string.substring(4);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("FM")) {
            string = string.substring(2);
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("FX")) {
            string = string.substring(2);
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DAY")) {
            string = string.substring(3);
            string2 = string2 + "dddd";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DY")) {
            string = string.substring(2);
            string2 = string2 + "ddd";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DD")) {
            string = string.substring(2);
            string2 = string2 + "dd";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH24")) {
            string = string.substring(4);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH12")) {
            string = string.substring(4);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("HH")) {
            string = string.substring(2);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MI")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MM")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MONTH")) {
            string = string.substring(5);
            string2 = string2 + "mmmm";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("MON")) {
            string = string.substring(3);
            string2 = string2 + "mmm";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("SS")) {
            string = string.substring(2);
            string2 = string2 + "ss";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYYY")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("YYY")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("YY")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("Y")) {
            string = string.substring(1);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRRR")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("RRR")) {
            string = string.substring(3);
            string2 = string2 + "yyy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("RR")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("R")) {
            string = string.substring(1);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF1")) {
            string = string.substring(3);
            string2 = string2 + "0";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF2")) {
            string = string.substring(3);
            string2 = string2 + "00";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF3")) {
            string = string.substring(3);
            string2 = string2 + "000";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertInTextFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("-")) {
            string = string.substring(1);
            string2 = string2 + "-";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
            string2 = string2 + "/";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith(",")) {
            string = string.substring(1);
            string2 = string2 + ",";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
            string2 = string2 + ".";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith(";")) {
            string = string.substring(1);
            string2 = string2 + ";";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith(":")) {
            string = string.substring(1);
            string2 = string2 + ":";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith(" ")) {
            string = string.substring(1);
            string2 = string2 + " ";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("AD")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("A.D.")) {
            string = string.substring(4);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("BC")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("B.C.")) {
            string = string.substring(4);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("DDD")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("IW")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("WW")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("W")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("X")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("CC")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("DL")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("DS")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("D")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("E")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("TZH")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("TZM")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZD")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.toUpperCase(Locale.US).startsWith("TZR")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF4")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF5")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF6")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF7")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF8")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (string.startsWith("FF9")) {
            string = string.substring(3);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        if (bl) {
            String string3 = string.substring(0, 1);
            string = string.substring(1);
            string2 = string2 + string3;
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        throw new IllegalArgumentException();
    }

    private static String convertInTextFromOracleToExcel(String string, String string2, boolean bl) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertFromOracleToExcel(string, string2, bl);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return DateFormatMaskConverter.convertInTextFromOracleToExcel(string, string2, bl);
    }

    private static String convertFromJavaToExcel(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0) {
            return string2.trim();
        }
        if (string.startsWith("yyyyy")) {
            string = string.substring(5);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("yyyy")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("yyy")) {
            string = string.substring(3);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("yy")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("y")) {
            string = string.substring(1);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("MMMMM")) {
            string = string.substring(5);
            string2 = string2 + "mmmm";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("MMMM")) {
            string = string.substring(4);
            string2 = string2 + "mmmm";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("MMM")) {
            string = string.substring(3);
            string2 = string2 + "mmm";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("MM")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("M")) {
            string = string.substring(1);
            string2 = string2 + "m";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("dd")) {
            string = string.substring(2);
            string2 = string2 + "dd";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("d")) {
            string = string.substring(1);
            string2 = string2 + "d";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("EEEE")) {
            string = string.substring(4);
            string2 = string2 + "dddd";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("EEE")) {
            string = string.substring(3);
            string2 = string2 + "ddd";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("EE")) {
            string = string.substring(2);
            string2 = string2 + "ddd";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("E")) {
            string = string.substring(1);
            string2 = string2 + "ddd";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("aaa")) {
            string = string.substring(3);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("aa")) {
            string = string.substring(2);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("a")) {
            string = string.substring(1);
            string2 = string2 + "AM/PM";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("H")) {
            string = string.substring(1);
            string2 = string2 + "h";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("HH")) {
            string = string.substring(2);
            string2 = string2 + "hh";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("h")) {
            string = string.substring(1);
            string2 = string2 + "h";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("hh")) {
            string = string.substring(2);
            string2 = string2 + "h";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("h")) {
            string = string.substring(1);
            string2 = string2 + "h";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("mm")) {
            string = string.substring(2);
            string2 = string2 + "mm";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("m")) {
            string = string.substring(1);
            string2 = string2 + "m";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("ss")) {
            string = string.substring(2);
            string2 = string2 + "ss";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("s")) {
            string = string.substring(1);
            string2 = string2 + "s";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("SSS")) {
            string = string.substring(3);
            string2 = string2 + "000";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("SS")) {
            string = string.substring(2);
            string2 = string2 + "00";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("S")) {
            string = string.substring(1);
            string2 = string2 + "0";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("oooo")) {
            string = string.substring(4);
            string2 = string2 + "yyyy";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("oo")) {
            string = string.substring(2);
            string2 = string2 + "yy";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("G")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("g")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("w")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("W")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("D")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("F")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("k")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("K")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("z")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("Z")) {
            string = string.substring(1);
            if (!bl) {
                throw new IllegalArgumentException();
            }
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("''")) {
            string = string.substring(2);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertInTextFromJavaToExcel(string, string2, bl);
        }
        if (bl) {
            String string3 = string.substring(0, 1);
            string = string.substring(1);
            string2 = string2 + string3;
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        throw new IllegalArgumentException();
    }

    private static String convertInTextFromJavaToExcel(String string, String string2, boolean bl) {
        if (string.startsWith("''")) {
            string = string.substring(2);
            string2 = string2 + "'";
            return DateFormatMaskConverter.convertInTextFromJavaToExcel(string, string2, bl);
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return DateFormatMaskConverter.convertFromJavaToExcel(string, string2, bl);
        }
        String string3 = string.substring(0, 1);
        string = string.startsWith("\"") ? string.substring(1) : string.substring(1);
        string2 = string2 + string3;
        return DateFormatMaskConverter.convertInTextFromJavaToExcel(string, string2, bl);
    }
}

