/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.SimpleDateFormat;
import oracle.apps.fnd.i18n.common.util.GregorianCalendar;
import oracle.apps.fnd.i18n.common.util.HijrahCalendar;

public class Deviation
implements Cloneable,
Serializable {
    public static final String RCS_ID = "$Header: Deviation.java 120.13 2012/09/10 23:26:15 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: Deviation.java 120.13 2012/09/10 23:26:15 rsuzuki ship $", "oracle.apps.fnd.i18n.common.util");
    Hashtable mAdjustedMonthDays = new Hashtable();
    Hashtable mAdjustedMonthLengths = new Hashtable();
    Hashtable mAdjustedCycleYears = new Hashtable();
    Long[] mAdjustedCycles = null;
    Integer[] mAdjustedMinValues = null;
    Integer[] mAdjustedLeastMaxValues = null;
    Integer[] mAdjustedMaxValues = null;
    private Vector deviationElements = new Vector();
    private String configFileLocation = null;
    private static Deviation m_Deviation = null;
    private static final long MAX_DEVIATION_MILLS = 95256086400000L;
    private static final long MIN_DEVIATION_MILLS = -42521846400000L;
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final char FILE_SEP = File.separatorChar;
    private static final String PATH_SEP = File.pathSeparator;
    private static final String DEFAULT_CONFIG_FILENAME = "deviation.cfg";
    private static final String DEFAULT_CONFIG_PATH = "oracle" + FILE_SEP + "apps" + FILE_SEP + "fnd" + FILE_SEP + "i18n" + FILE_SEP + "common" + FILE_SEP + "util";
    private static final String JAR_PREFIX = "jar:";
    private static final String ZIP_PREFIX = "zip:";
    private static final String FILE_PREFIX = "file:";
    private static final String FILE_SEP_URL = "/";
    private static final String DEFAULT_CONFIG_PATH_URL = "i18n/common/util";
    private static final String DEVIATION_CLASS_NAME = "Deviation.class";
    private static final int MAX_ADJUSTED_CYCLE = 150;
    static /* synthetic */ Class class$oracle$apps$fnd$i18n$common$util$Deviation;

    public Deviation() {
        int n;
        this.mAdjustedCycles = new Long[150];
        for (n = 0; n < this.mAdjustedCycles.length; ++n) {
            this.mAdjustedCycles[n] = new Long(10631 * n);
        }
        this.mAdjustedMinValues = new Integer[HijrahCalendar.MIN_VALUES.length];
        for (n = 0; n < HijrahCalendar.MIN_VALUES.length; ++n) {
            this.mAdjustedMinValues[n] = new Integer(HijrahCalendar.MIN_VALUES[n]);
        }
        this.mAdjustedLeastMaxValues = new Integer[HijrahCalendar.LEAST_MAX_VALUES.length];
        for (n = 0; n < HijrahCalendar.LEAST_MAX_VALUES.length; ++n) {
            this.mAdjustedLeastMaxValues[n] = new Integer(HijrahCalendar.LEAST_MAX_VALUES[n]);
        }
        this.mAdjustedMaxValues = new Integer[HijrahCalendar.MAX_VALUES.length];
        for (n = 0; n < HijrahCalendar.MAX_VALUES.length; ++n) {
            this.mAdjustedMaxValues[n] = new Integer(HijrahCalendar.MAX_VALUES[n]);
        }
    }

    public static synchronized Deviation getDeviation() throws ParseException, IOException {
        String string = System.getProperty("oracle.apps.fnd.i18n.common.util.deviation.reload");
        boolean bl = false;
        if ("true".equals(string)) {
            bl = true;
        }
        if (m_Deviation == null || bl) {
            m_Deviation = new Deviation();
            try {
                Deviation.setConfig(m_Deviation);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Deviation.m_Deviation.configFileLocation = null;
            }
            catch (ParseException parseException) {
                m_Deviation = null;
                throw parseException;
            }
            catch (IOException iOException) {
                m_Deviation = null;
                throw iOException;
            }
        }
        return (Deviation)m_Deviation.clone();
    }

    public void addDeviation(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT_TIMEZONE);
        gregorianCalendar.set(n, n2, n3, 0, 0, 0, 0);
        Date date = gregorianCalendar.getTime();
        gregorianCalendar.set(n4, n5, n6, 0, 0, 0, 0);
        Date date2 = gregorianCalendar.getTime();
        if (n7 < 0) {
            throw new IllegalArgumentException("Negative number cannot be specified as offset value.");
        }
        if (date.getTime() < -42521846400000L) {
            throw new IllegalArgumentException("Start date < Jul-16-622 00:00:00 GMT in Gregorina Calendar.");
        }
        if (date2.getTime() > 95256086400000L) {
            throw new IllegalArgumentException("End date > Jul-18-4988 00:00:00 GMT in Gregorina Calendar.");
        }
        if (date2.getTime() < date.getTime()) {
            throw new IllegalArgumentException("Start date > End date");
        }
        HijrahCalendar hijrahCalendar = new HijrahCalendar(GMT_TIMEZONE, Locale.getDefault(), false);
        hijrahCalendar.m_Deviation = this;
        hijrahCalendar.setTime(date);
        int n8 = hijrahCalendar.get(0);
        int n9 = hijrahCalendar.get(1);
        int n10 = hijrahCalendar.get(2);
        int n11 = hijrahCalendar.get(5);
        hijrahCalendar.setTime(date2);
        int n12 = hijrahCalendar.get(0);
        int n13 = hijrahCalendar.get(1);
        int n14 = hijrahCalendar.get(2);
        int n15 = hijrahCalendar.get(5);
        if (n11 == 29 || n11 == 30) {
            if (n9 == n13 && n10 == n14) {
                if (n10 == 11) {
                    n14 = 0;
                    ++n13;
                } else {
                    ++n14;
                }
            }
            this.addDeviationAsHijrah(n9, n10, n13, n14, n7);
        } else if (n11 == 1) {
            n7 = -n7 + 10;
            if (n10 == 0) {
                n10 = 11;
                --n9;
            } else {
                --n10;
            }
            this.addDeviationAsHijrah(n9, n10, n13, n14, n7);
        }
    }

    public void addDeviationAsHijrah(int n, int n2, int n3, int n4, int n5) {
        Integer[] integerArray;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n < 1) {
            throw new IllegalArgumentException("startYear < 1");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("endYear < 1");
        }
        if (n3 > 4500) {
            throw new IllegalArgumentException("endYear > 4500");
        }
        if (n2 < 0 || n2 > 11) {
            throw new IllegalArgumentException("startMonth < 0 || startMonth > 11");
        }
        if (n4 < 0 || n4 > 11) {
            throw new IllegalArgumentException("endMonth < 0 || endMonth > 11");
        }
        if (n3 < n) {
            throw new IllegalArgumentException("startYear > endYear");
        }
        if (n3 == n && n4 < n2) {
            throw new IllegalArgumentException("startYear == endYear && endMonth < startMonth");
        }
        boolean bl = HijrahCalendar.isLeapYearInternal(n);
        Integer[] integerArray2 = (Integer[])this.mAdjustedMonthDays.get(new Integer(n));
        if (integerArray2 == null) {
            int n10;
            if (bl) {
                integerArray2 = new Integer[HijrahCalendar.LEAP_NUM_DAYS.length];
                for (n10 = 0; n10 < HijrahCalendar.LEAP_NUM_DAYS.length; ++n10) {
                    integerArray2[n10] = new Integer(HijrahCalendar.LEAP_NUM_DAYS[n10]);
                }
            } else {
                integerArray2 = new Integer[HijrahCalendar.NUM_DAYS.length];
                for (n10 = 0; n10 < HijrahCalendar.NUM_DAYS.length; ++n10) {
                    integerArray2[n10] = new Integer(HijrahCalendar.NUM_DAYS[n10]);
                }
            }
        }
        Integer[] integerArray3 = new Integer[integerArray2.length];
        for (int i = 0; i < 12; ++i) {
            integerArray3[i] = i > n2 ? new Integer(integerArray2[i] - n5) : new Integer(integerArray2[i]);
        }
        this.mAdjustedMonthDays.put(new Integer(n), integerArray3);
        Integer[] integerArray4 = (Integer[])this.mAdjustedMonthLengths.get(new Integer(n));
        if (integerArray4 == null) {
            int n11;
            if (bl) {
                integerArray4 = new Integer[HijrahCalendar.LEAP_MONTH_LENGTH.length];
                for (n11 = 0; n11 < HijrahCalendar.LEAP_MONTH_LENGTH.length; ++n11) {
                    integerArray4[n11] = new Integer(HijrahCalendar.LEAP_MONTH_LENGTH[n11]);
                }
            } else {
                integerArray4 = new Integer[HijrahCalendar.MONTH_LENGTH.length];
                for (n11 = 0; n11 < HijrahCalendar.MONTH_LENGTH.length; ++n11) {
                    integerArray4[n11] = new Integer(HijrahCalendar.MONTH_LENGTH[n11]);
                }
            }
        }
        Integer[] integerArray5 = new Integer[integerArray4.length];
        for (n9 = 0; n9 < 12; ++n9) {
            integerArray5[n9] = n9 == n2 ? new Integer(integerArray4[n9] - n5) : new Integer(integerArray4[n9]);
        }
        this.mAdjustedMonthLengths.put(new Integer(n), integerArray5);
        if (n != n3) {
            int n12;
            n9 = (n - 1) / 30;
            int n13 = (n - 1) % 30;
            Integer[] integerArray6 = (Integer[])this.mAdjustedCycleYears.get(new Integer(n9));
            if (integerArray6 == null) {
                integerArray6 = new Integer[HijrahCalendar.CYCLEYEAR_START_DATE.length];
                for (n8 = 0; n8 < integerArray6.length; ++n8) {
                    integerArray6[n8] = new Integer(HijrahCalendar.CYCLEYEAR_START_DATE[n8]);
                }
            }
            for (n8 = n13 + 1; n8 < HijrahCalendar.CYCLEYEAR_START_DATE.length; ++n8) {
                integerArray6[n8] = new Integer(integerArray6[n8] - n5);
            }
            this.mAdjustedCycleYears.put(new Integer(n9), integerArray6);
            n8 = (n - 1) / 30;
            n7 = (n3 - 1) / 30;
            if (n8 != n7) {
                for (n6 = n8 + 1; n6 < this.mAdjustedCycles.length; ++n6) {
                    this.mAdjustedCycles[n6] = new Long(this.mAdjustedCycles[n6] - (long)n5);
                }
                for (n6 = n7 + 1; n6 < this.mAdjustedCycles.length; ++n6) {
                    this.mAdjustedCycles[n6] = new Long(this.mAdjustedCycles[n6] + (long)n5);
                }
            }
            n6 = (n3 - 1) / 30;
            int n14 = (n3 - 1) % 30;
            integerArray = (Integer[])this.mAdjustedCycleYears.get(new Integer(n6));
            if (integerArray == null) {
                integerArray = new Integer[HijrahCalendar.CYCLEYEAR_START_DATE.length];
                for (n12 = 0; n12 < integerArray.length; ++n12) {
                    integerArray[n12] = new Integer(HijrahCalendar.CYCLEYEAR_START_DATE[n12]);
                }
            }
            for (n12 = n14 + 1; n12 < HijrahCalendar.CYCLEYEAR_START_DATE.length; ++n12) {
                integerArray[n12] = new Integer(integerArray[n12] + n5);
            }
            this.mAdjustedCycleYears.put(new Integer(n6), integerArray);
        }
        n9 = HijrahCalendar.isLeapYearInternal(n3) ? 1 : 0;
        Integer[] integerArray7 = (Integer[])this.mAdjustedMonthDays.get(new Integer(n3));
        if (integerArray7 == null) {
            if (n9 != 0) {
                integerArray7 = new Integer[HijrahCalendar.LEAP_NUM_DAYS.length];
                for (int i = 0; i < HijrahCalendar.LEAP_NUM_DAYS.length; ++i) {
                    integerArray7[i] = new Integer(HijrahCalendar.LEAP_NUM_DAYS[i]);
                }
            } else {
                integerArray7 = new Integer[HijrahCalendar.NUM_DAYS.length];
                for (int i = 0; i < HijrahCalendar.NUM_DAYS.length; ++i) {
                    integerArray7[i] = new Integer(HijrahCalendar.NUM_DAYS[i]);
                }
            }
        }
        Integer[] integerArray8 = new Integer[integerArray7.length];
        for (n8 = 0; n8 < 12; ++n8) {
            integerArray8[n8] = n8 > n4 ? new Integer(integerArray7[n8] + n5) : new Integer(integerArray7[n8]);
        }
        this.mAdjustedMonthDays.put(new Integer(n3), integerArray8);
        Integer[] integerArray9 = (Integer[])this.mAdjustedMonthLengths.get(new Integer(n3));
        if (integerArray9 == null) {
            if (n9 != 0) {
                integerArray9 = new Integer[HijrahCalendar.LEAP_MONTH_LENGTH.length];
                for (n7 = 0; n7 < HijrahCalendar.LEAP_MONTH_LENGTH.length; ++n7) {
                    integerArray9[n7] = new Integer(HijrahCalendar.LEAP_MONTH_LENGTH[n7]);
                }
            } else {
                integerArray9 = new Integer[HijrahCalendar.MONTH_LENGTH.length];
                for (n7 = 0; n7 < HijrahCalendar.MONTH_LENGTH.length; ++n7) {
                    integerArray9[n7] = new Integer(HijrahCalendar.MONTH_LENGTH[n7]);
                }
            }
        }
        Integer[] integerArray10 = new Integer[integerArray9.length];
        for (n6 = 0; n6 < 12; ++n6) {
            integerArray10[n6] = n6 == n4 ? new Integer(integerArray9[n6] + n5) : new Integer(integerArray9[n6]);
        }
        this.mAdjustedMonthLengths.put(new Integer(n3), integerArray10);
        Integer[] integerArray11 = (Integer[])this.mAdjustedMonthLengths.get(new Integer(n));
        Integer[] integerArray12 = (Integer[])this.mAdjustedMonthLengths.get(new Integer(n3));
        integerArray = (Integer[])this.mAdjustedMonthDays.get(new Integer(n));
        Integer[] integerArray13 = (Integer[])this.mAdjustedMonthDays.get(new Integer(n3));
        int n15 = integerArray11[n2];
        int n16 = integerArray12[n4];
        int n17 = integerArray[11] + integerArray11[11];
        int n18 = integerArray13[11] + integerArray12[11];
        int n19 = this.mAdjustedMaxValues[5];
        int n20 = this.mAdjustedLeastMaxValues[5];
        if (n19 < n15) {
            n19 = n15;
        }
        if (n19 < n16) {
            n19 = n16;
        }
        this.mAdjustedMaxValues[5] = new Integer(n19);
        if (n20 > n15) {
            n20 = n15;
        }
        if (n20 > n16) {
            n20 = n16;
        }
        this.mAdjustedLeastMaxValues[5] = new Integer(n20);
        int n21 = this.mAdjustedMaxValues[6];
        int n22 = this.mAdjustedLeastMaxValues[6];
        if (n21 < n17) {
            n21 = n17;
        }
        if (n21 < n18) {
            n21 = n18;
        }
        this.mAdjustedMaxValues[6] = new Integer(n21);
        if (n22 > n17) {
            n22 = n17;
        }
        if (n22 > n18) {
            n22 = n18;
        }
        this.mAdjustedLeastMaxValues[6] = new Integer(n22);
        this.deviationElements.addElement(n + FILE_SEP_URL + n2 + "-" + n3 + FILE_SEP_URL + n4 + ":" + n5);
    }

    public Vector getDeviationElements() {
        return this.deviationElements;
    }

    public String getConfigFileLocation() {
        return this.configFileLocation;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Deviation)) {
            return false;
        }
        Deviation deviation = (Deviation)object;
        return this.deviationElements.equals(deviation.deviationElements);
    }

    public Object clone() {
        try {
            Deviation deviation = (Deviation)super.clone();
            this.copyMembers(this, deviation);
            return deviation;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n = 1;
        Vector vector = this.getDeviationElements();
        for (int i = 0; i < vector.size(); ++i) {
            n = n * 17 + ((String)vector.elementAt(i)).hashCode();
        }
        return n;
    }

    private void copyMembers(Deviation deviation, Deviation deviation2) {
        Long[] longArray = new Long[deviation.mAdjustedCycles.length];
        System.arraycopy(deviation.mAdjustedCycles, 0, longArray, 0, deviation.mAdjustedCycles.length);
        deviation2.mAdjustedCycles = longArray;
        this.copyHashTable(deviation.mAdjustedCycleYears, deviation2.mAdjustedCycleYears);
        this.copyHashTable(deviation.mAdjustedMonthDays, deviation2.mAdjustedMonthDays);
        this.copyHashTable(deviation.mAdjustedMonthLengths, deviation2.mAdjustedMonthLengths);
        Integer[] integerArray = new Integer[deviation.mAdjustedLeastMaxValues.length];
        System.arraycopy(deviation.mAdjustedLeastMaxValues, 0, integerArray, 0, deviation.mAdjustedLeastMaxValues.length);
        deviation2.mAdjustedLeastMaxValues = integerArray;
        Integer[] integerArray2 = new Integer[deviation.mAdjustedMaxValues.length];
        System.arraycopy(deviation.mAdjustedMaxValues, 0, integerArray2, 0, deviation.mAdjustedMaxValues.length);
        deviation2.mAdjustedMaxValues = integerArray2;
        Integer[] integerArray3 = new Integer[deviation.mAdjustedMinValues.length];
        System.arraycopy(deviation.mAdjustedMinValues, 0, integerArray3, 0, deviation.mAdjustedMinValues.length);
        deviation2.mAdjustedMinValues = integerArray3;
        deviation2.deviationElements = new Vector();
        for (int i = 0; i < deviation.deviationElements.size(); ++i) {
            deviation2.deviationElements.addElement(deviation.deviationElements.elementAt(i));
        }
    }

    private void copyHashTable(Hashtable hashtable, Hashtable hashtable2) {
        hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            hashtable2.put(k, v);
        }
    }

    private static InputStream getConfigFileInputStreamThroughLoader(Deviation deviation) throws IOException {
        URL uRL = (class$oracle$apps$fnd$i18n$common$util$Deviation == null ? (class$oracle$apps$fnd$i18n$common$util$Deviation = Deviation.class$("oracle.apps.fnd.i18n.common.util.Deviation")) : class$oracle$apps$fnd$i18n$common$util$Deviation).getResource(DEVIATION_CLASS_NAME);
        String string = uRL.toString();
        if (string.startsWith(JAR_PREFIX) || string.startsWith(ZIP_PREFIX)) {
            int n = string.indexOf("!");
            if (n != -1) {
                Object object;
                Object object2;
                int n2;
                String string2 = string.substring(4, n);
                if (string2.startsWith(FILE_PREFIX)) {
                    string2 = string2.substring(FILE_PREFIX.length(), string2.length());
                }
                if ((n2 = string2.lastIndexOf(FILE_SEP_URL)) != -1 && ((File)(object2 = new File((String)(object = string2.substring(0, n2) + FILE_SEP_URL + ".." + FILE_SEP_URL + DEFAULT_CONFIG_PATH_URL + FILE_SEP_URL) + DEFAULT_CONFIG_FILENAME))).exists()) {
                    FileInputStream fileInputStream = new FileInputStream((File)object2);
                    deviation.configFileLocation = ((File)object2).getAbsolutePath();
                    return fileInputStream;
                }
                object = null;
                object = new ZipFile(string2);
                if (object != null) {
                    object2 = string.substring(n + 1, string.length() - DEVIATION_CLASS_NAME.length());
                    String string3 = ((String)object2).substring(((String)object2).startsWith(FILE_SEP_URL) ? 1 : 0, ((String)object2).length()) + DEFAULT_CONFIG_FILENAME;
                    ZipEntry zipEntry = ((ZipFile)object).getEntry(string3);
                    if (zipEntry == null) {
                        if (FILE_SEP == '/') {
                            string3 = string3.replace('/', '\\');
                        } else if (FILE_SEP == '\\') {
                            string3 = string3.replace('\\', '/');
                        }
                        zipEntry = ((ZipFile)object).getEntry(string3);
                    }
                    if (zipEntry != null) {
                        InputStream inputStream = ((ZipFile)object).getInputStream(zipEntry);
                        deviation.configFileLocation = string2 + ":" + zipEntry.toString();
                        return inputStream;
                    }
                }
            }
            return null;
        }
        if (string.startsWith(FILE_PREFIX)) {
            String string4 = string.substring(FILE_PREFIX.length(), string.length() - DEVIATION_CLASS_NAME.length());
            File file = new File(string4 + DEFAULT_CONFIG_FILENAME);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                deviation.configFileLocation = file.getAbsolutePath();
                return fileInputStream;
            }
            return null;
        }
        return null;
    }

    private static InputStream getConfigFileInputStream(Deviation deviation) throws IOException {
        String string;
        String string2 = System.getProperty("oracle.apps.fnd.i18n.common.util.deviation.configFile");
        if (string2 == null) {
            string2 = DEFAULT_CONFIG_FILENAME;
        }
        if ((string = System.getProperty("oracle.apps.fnd.i18n.common.util.deviation.configDir")) != null) {
            File file;
            if (string.length() != 0 || !string.endsWith(System.getProperty("file.separator"))) {
                string = string + System.getProperty("file.separator");
            }
            if ((file = new File(string + FILE_SEP + string2)).exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                deviation.configFileLocation = file.getAbsolutePath();
                return fileInputStream;
            }
            return null;
        }
        InputStream inputStream = Deviation.getConfigFileInputStreamThroughLoader(deviation);
        if (inputStream != null) {
            return inputStream;
        }
        String string3 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, PATH_SEP);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            String string4 = stringTokenizer.nextToken();
            File file = new File(string4);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                object2 = new File(string4 + FILE_SEP + DEFAULT_CONFIG_PATH, string2);
                if (!((File)object2).exists()) continue;
                object = new FileInputStream((File)object2);
                deviation.configFileLocation = ((File)object2).getAbsolutePath();
                return object;
            }
            object2 = null;
            try {
                object2 = new ZipFile(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object2 == null) continue;
            object = DEFAULT_CONFIG_PATH + FILE_SEP + string2;
            ZipEntry zipEntry = ((ZipFile)object2).getEntry((String)object);
            if (zipEntry == null) {
                if (FILE_SEP == '/') {
                    object = ((String)object).replace('/', '\\');
                } else if (FILE_SEP == '\\') {
                    object = ((String)object).replace('\\', '/');
                }
                zipEntry = ((ZipFile)object2).getEntry((String)object);
            }
            if (zipEntry == null) continue;
            InputStream inputStream2 = ((ZipFile)object2).getInputStream(zipEntry);
            deviation.configFileLocation = file.getAbsolutePath() + ":" + zipEntry.toString();
            return inputStream2;
        }
        return null;
    }

    private static void setConfig(Deviation deviation) throws IOException, FileNotFoundException, ParseException {
        InputStream inputStream = Deviation.getConfigFileInputStream(deviation);
        if (inputStream == null) {
            throw new FileNotFoundException("No config file found.");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(11, "MMM-dd-yyyy G", Locale.US);
        simpleDateFormat.setTimeZone(GMT_TIMEZONE);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = "";
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
            if ("".equals(string = string.trim())) continue;
            char[] cArray = string.toCharArray();
            int n2 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            Date date = new Date(-42521846400000L);
            Date date2 = new Date(95256086400000L);
            int n3 = -1;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '<') {
                    if (n2 != 0) {
                        throw new ParseException("'<' is not used properly at line " + n + ".", n);
                    }
                    n2 = 10;
                    continue;
                }
                if (c == '>') {
                    if (n2 < 12) {
                        throw new ParseException("'<' is used improperly at line " + n + ".", n);
                    }
                    n2 = 20;
                    continue;
                }
                if (c == '\"' && n2 < 10) {
                    throw new ParseException("'\"' is used improperly at line " + n + ".", n);
                }
                if (c == ':' && n2 < 20) {
                    throw new ParseException("':' is used improperly at line " + n + ".", n);
                }
                if (10 <= n2 && n2 < 20) {
                    if (n2 == 10 && c == '\"') {
                        n2 = 11;
                        continue;
                    }
                    if (n2 == 11 && c == '\"') {
                        n2 = 12;
                        continue;
                    }
                    if (n2 == 11) {
                        string3 = string3 + c;
                    }
                    if (n2 == 12 && c == '\"') {
                        n2 = 13;
                        continue;
                    }
                    if (n2 == 13 && c == '\"') {
                        n2 = 14;
                        continue;
                    }
                    if (n2 == 13) {
                        string4 = string4 + c;
                    }
                }
                if (n2 < 20) continue;
                if (c == ':') {
                    n2 = 21;
                    continue;
                }
                if (n2 != 21) continue;
                string2 = string2 + c;
            }
            if (!"".equals(string3)) {
                try {
                    date = simpleDateFormat.parse(string3);
                }
                catch (ParseException parseException) {
                    new ParseException("Start date is not properly defined at line " + n + ".", n);
                }
            } else {
                throw new ParseException("Start date is not properly defined at line " + n + ".", n);
            }
            if (!"".equals(string2)) {
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    new ParseException("Offset date is not properly defined at line " + n + ".", n);
                }
            } else {
                throw new ParseException("Offset is not properly defined at line " + n + ".", n);
            }
            if (!"".equals(string4)) {
                try {
                    date2 = simpleDateFormat.parse(string4);
                }
                catch (ParseException parseException) {
                    throw new ParseException("End date is not properly defined at line " + n + ".", n);
                }
            }
            deviation.addDeviation(date, date2, n3);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
    }

    private void addDeviation(Date date, Date date2, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT_TIMEZONE);
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(2);
        int n4 = gregorianCalendar.get(5);
        gregorianCalendar.setTime(date2);
        int n5 = gregorianCalendar.get(1);
        int n6 = gregorianCalendar.get(2);
        int n7 = gregorianCalendar.get(5);
        this.addDeviation(n2, n3, n4, n5, n6, n7, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

