/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DecimalFormat;
import oracle.apps.fnd.i18n.common.text.DecimalFormatSymbols;
import oracle.apps.fnd.i18n.common.text.ExcelDateFormat;
import oracle.apps.fnd.i18n.common.text.ExcelNumberFormat;
import oracle.apps.fnd.i18n.common.text.Format;
import oracle.apps.fnd.i18n.common.util.DateFormatMaskConverter;

public class FormatMaskUtil {
    public static final String RCS_ID = "$Header: FormatMaskUtil.java 120.9 2010/02/25 03:01:49 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED;
    public static final int FORMAT_ORACLE = 10;
    public static final int FORMAT_JAVA = 11;
    public static final int FORMAT_MS = 12;
    public static final int FORMAT_UNKNOWN = 13;
    public static final int FORMAT_EXCEL_NUMBER = 14;
    public static final int FORMAT_EXCEL_DATETIME = 15;
    private static String[] MS_SPECIFIC_PATTERNS;
    private static String[] JAVA_SPECIFIC_PATTERNS;
    private static String[] ORA_SPECIFIC_PATTERNS;
    private static Hashtable CURRENCY_PRECISION_INFO;
    private static Hashtable JAVA_CURRENCY_NUMBER_FORMATS;
    private static Hashtable ORACLE_CURRENCY_NUMBER_FORMATS;
    private static ExcelNumberFormat NUMBER_FORMAT_DETECTOR;
    private static ExcelDateFormat DATE_FORMAT_DETECTOR;
    private static Hashtable DEFAULT_CURRENCY_SYMBOLS;
    private static Hashtable LOCAL_CURRENCY_SYMBOLS;
    private static Hashtable DEFAULT_CURRENCY_POSITIVE_STYLES;
    private static Hashtable LOCAL_CURRENCY_POSITIVE_STYLES;
    private static Hashtable DEFAULT_CURRENCY_NEGATIVE_STYLES;
    private static Hashtable LOCAL_CURRENCY_NEGATIVE_STYLES;
    private static final int POSITIVE_STYLE_$X = 0;
    private static final int POSITIVE_STYLE_X$ = 1;
    private static final int POSITIVE_STYLE_$_X = 2;
    private static final int POSITIVE_STYLE_X_$ = 3;
    private static final int POSITVE_STYLE_COUNT = 4;
    private static final int NEGATIVE_STYLE_S$X = 0;
    private static final int NEGATIVE_STYLE_$SX = 1;
    private static final int NEGATIVE_STYLE_$XS = 2;
    private static final int NEGATIVE_STYLE_SX$ = 3;
    private static final int NEGATIVE_STYLE_XS$ = 4;
    private static final int NEGATIVE_STYLE_X$S = 5;
    private static final int NEGATIVE_STYLE_S$_X = 6;
    private static final int NEGATIVE_STYLE_$_SX = 7;
    private static final int NEGATIVE_STYLE_$_XS = 8;
    private static final int NEGATIVE_STYLE_SX_$ = 9;
    private static final int NEGATIVE_STYLE_XS_$ = 10;
    private static final int NEGATIVE_STYLE_X_$S = 11;
    private static final int NEGATIVE_STYLE_COUNT = 12;
    private static Hashtable LOCALE_POSITIVE_STYLES;
    private static Hashtable LOCALE_NEGATIVE_STYLES;
    private static final boolean ENABLE_LOCAL_CURRENCY_FORMAT = true;
    private static final boolean ENABLE_LOCAL_CURRENCY_SYMBOL = true;
    private static final int DEFAULT_CURRENCY_POSITIVE_STYLE = 2;
    private static final int DEFAULT_CURRENCY_NEGATIVE_STYLE = 7;
    private static final Hashtable SYMBOL_TO_CODE_POSITIVE_POSITION_MAP;
    private static final Hashtable SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP;
    private static final String ASCII_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Hashtable IS_SYMBOL_CODE_CACHE;

    public static Hashtable getCurrencyFormats(int n) {
        if (n == 11 || n == 12) {
            return (Hashtable)JAVA_CURRENCY_NUMBER_FORMATS.clone();
        }
        return (Hashtable)ORACLE_CURRENCY_NUMBER_FORMATS.clone();
    }

    private static String buildFormatMask(String string, String string2, int n) {
        String string3 = "";
        int n2 = 2;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n == 11 || n == 12) {
            string3 = "#,##0";
            if (n2 != 0) {
                string3 = string3 + ".";
            }
            for (int i = 0; i < n2; ++i) {
                string3 = string3 + "0";
            }
        } else {
            string3 = "9G990";
            if (n2 != 0) {
                string3 = string3 + "D";
            }
            for (int i = 0; i < n2; ++i) {
                string3 = string3 + "0";
            }
            string3 = "FM" + string3;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int detectExcelFormatMaskType(String string) throws IllegalArgumentException {
        try {
            Format format = NUMBER_FORMAT_DETECTOR;
            synchronized (format) {
                NUMBER_FORMAT_DETECTOR.applyPattern(string);
            }
            try {
                format = DATE_FORMAT_DETECTOR;
                synchronized (format) {
                    DATE_FORMAT_DETECTOR.applyPattern(string);
                }
                return 14;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return 14;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                ExcelDateFormat excelDateFormat = DATE_FORMAT_DETECTOR;
                synchronized (excelDateFormat) {
                    DATE_FORMAT_DETECTOR.applyPattern(string);
                }
                return 15;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw new IllegalArgumentException(string + " is not valid format mask.");
            }
        }
    }

    public static int detectDateFormatMaskType(String string) throws IllegalArgumentException {
        int n = 13;
        if (string == null || "".equals(string)) {
            return n;
        }
        if (FormatMaskUtil.hasOracleSpecificPattern(string)) {
            try {
                if (FormatMaskUtil.isOracleCompatible(string)) {
                    return 10;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (FormatMaskUtil.hasMSSpecificPattern(string)) {
            try {
                if (FormatMaskUtil.isMSCompatible(string)) {
                    return 12;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (FormatMaskUtil.hasJavaSpecificPattern(string)) {
            try {
                if (FormatMaskUtil.isJavaCompatible(string)) {
                    return 11;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            FormatMaskUtil.isJavaCompatible(string);
            try {
                FormatMaskUtil.isMSCompatible(string);
                try {
                    FormatMaskUtil.isOracleCompatible(string);
                    n = 13;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    n = 11;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    FormatMaskUtil.isOracleCompatible(string);
                    n = 13;
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    n = 11;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FormatMaskUtil.isMSCompatible(string);
                try {
                    FormatMaskUtil.isOracleCompatible(string);
                    n = 13;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    n = 12;
                }
            }
            catch (IllegalArgumentException illegalArgumentException4) {
                try {
                    FormatMaskUtil.isOracleCompatible(string);
                    n = 10;
                }
                catch (IllegalArgumentException illegalArgumentException5) {
                    throw new IllegalArgumentException(string + " is not valid format mask.");
                }
            }
        }
        return n;
    }

    private static boolean isOracleCompatible(String string) throws IllegalArgumentException {
        DateFormatMaskConverter.getJavaDateFormatFromOracle(string, Locale.getDefault(), false);
        return true;
    }

    private static boolean isMSCompatible(String string) throws IllegalArgumentException {
        try {
            oracle.apps.fnd.i18n.common.text.SimpleDateFormat simpleDateFormat = new oracle.apps.fnd.i18n.common.text.SimpleDateFormat(12, string);
            String string2 = simpleDateFormat.format(new Date());
            Date date = simpleDateFormat.parse(string2);
            return true;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
    }

    private static boolean isJavaCompatible(String string) throws IllegalArgumentException {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            String string2 = simpleDateFormat.format(new Date());
            Date date = simpleDateFormat.parse(string2);
            return true;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
    }

    private static boolean hasOracleSpecificPattern(String string) {
        for (int i = 0; i < ORA_SPECIFIC_PATTERNS.length; ++i) {
            if (string.indexOf(ORA_SPECIFIC_PATTERNS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMSSpecificPattern(String string) {
        for (int i = 0; i < MS_SPECIFIC_PATTERNS.length; ++i) {
            if (string.indexOf(MS_SPECIFIC_PATTERNS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean hasJavaSpecificPattern(String string) {
        for (int i = 0; i < JAVA_SPECIFIC_PATTERNS.length; ++i) {
            if (string.indexOf(JAVA_SPECIFIC_PATTERNS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static String getCurrencyFormatWithCode(int n, String string, Locale locale) {
        if (string == null) {
            throw new IllegalArgumentException("Currency code cannot be null.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null.");
        }
        Integer n2 = (Integer)SYMBOL_TO_CODE_POSITIVE_POSITION_MAP.get(new Integer(FormatMaskUtil.getPositiveStyle(locale)));
        Integer n3 = (Integer)SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.get(new Integer(FormatMaskUtil.getNegativeStyle(locale)));
        int n4 = n2;
        int n5 = n3;
        String string2 = string;
        return FormatMaskUtil.getCurrencyFormatWithSymbol(n, n4, n5, string, string2, locale);
    }

    public static String getCurrencyFormatWithSymbol(int n, String string, Locale locale) {
        if (string == null) {
            throw new IllegalArgumentException("Currency code cannot be null.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null.");
        }
        String string2 = FormatMaskUtil.getSymbol(string, locale);
        int n2 = FormatMaskUtil.getPositiveStyle(locale);
        int n3 = FormatMaskUtil.getNegativeStyle(locale);
        if (FormatMaskUtil.isAllUpperASCIIChars(string2)) {
            Integer n4 = (Integer)SYMBOL_TO_CODE_POSITIVE_POSITION_MAP.get(new Integer(n2));
            Integer n5 = (Integer)SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.get(new Integer(n3));
            n2 = n4;
            n3 = n5;
        }
        return FormatMaskUtil.getCurrencyFormatWithSymbol(n, n2, n3, string, string2, locale);
    }

    private static String getCurrencyFormatWithSymbol(int n, int n2, int n3, String string, String string2, Locale locale) {
        if (n2 < 0 && n2 > 4) {
            throw new IllegalArgumentException("Unsupported positive style.");
        }
        if (n3 < 0 && n3 > 12) {
            throw new IllegalArgumentException("Unsupported negative style.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Currency code cannot be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Currency symbol cannot be null.");
        }
        if (n == 11 || n == 12) {
            return FormatMaskUtil.buildJavaPositiveFormat(n2, string, string2, locale) + ";" + FormatMaskUtil.buildJavaNegativeFormat(n3, string, string2, locale);
        }
        throw new IllegalArgumentException("Only Java and MS format mask type are supported.");
    }

    private static String getSymbol(String string, Locale locale) {
        String[][] stringArray;
        if (string == null || "".equals(string)) {
            return "";
        }
        String string2 = (String)DEFAULT_CURRENCY_SYMBOLS.get(string);
        if (locale != null && (stringArray = (String[][])LOCAL_CURRENCY_SYMBOLS.get(string)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                String string3 = stringArray2[0];
                String string4 = stringArray2[1];
                if (!string3.equals(locale.toString())) continue;
                string2 = string4;
                break;
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    private static int getPositiveStyle(String string, Locale locale) {
        Integer n = (Integer)DEFAULT_CURRENCY_POSITIVE_STYLES.get(string);
        Integer n2 = FormatMaskUtil.getLocalCurrecyStyle(LOCAL_CURRENCY_POSITIVE_STYLES, string, locale);
        if (n2 != null) {
            n = n2;
        }
        int n3 = 2;
        if (n != null) {
            n3 = n;
        }
        return n3;
    }

    private static int getNegativeStyle(String string, Locale locale) {
        Integer n = (Integer)DEFAULT_CURRENCY_NEGATIVE_STYLES.get(string);
        Integer n2 = FormatMaskUtil.getLocalCurrecyStyle(LOCAL_CURRENCY_NEGATIVE_STYLES, string, locale);
        if (n2 != null) {
            n = n2;
        }
        int n3 = 7;
        if (n != null) {
            n3 = n;
        }
        return n3;
    }

    private static Integer getLocalCurrecyStyle(Hashtable hashtable, String string, Locale locale) {
        Object[][] objectArray;
        Integer n = null;
        if (locale != null && (objectArray = (Object[][])hashtable.get(string)) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2 = objectArray[i];
                String string2 = (String)objectArray2[0];
                Integer n2 = (Integer)objectArray2[1];
                if (!string2.equals(locale.toString())) continue;
                return n2;
            }
        }
        return n;
    }

    private static int getPositiveStyle(Locale locale) {
        int n = 2;
        Integer n2 = (Integer)LOCALE_POSITIVE_STYLES.get(locale.toString());
        if (n2 == null) {
            n2 = (Integer)LOCALE_POSITIVE_STYLES.get(locale.getLanguage());
        }
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    private static int getNegativeStyle(Locale locale) {
        int n = 7;
        Integer n2 = (Integer)LOCALE_NEGATIVE_STYLES.get(locale.toString());
        if (n2 == null) {
            n2 = (Integer)LOCALE_NEGATIVE_STYLES.get(locale.getLanguage());
        }
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    private static String buildJavaNegativeFormat(int n, String string, String string2, Locale locale) {
        String string3 = "";
        String string4 = "'" + string2 + "'";
        String string5 = "-";
        String string6 = FormatMaskUtil.getNumberFormatMask(string, 11);
        String string7 = string4;
        String string8 = " ";
        switch (n) {
            case 0: {
                string3 = string5 + string7 + string6;
                break;
            }
            case 1: {
                string3 = string7 + string5 + string6;
                break;
            }
            case 2: {
                string3 = string7 + string6 + string5;
                break;
            }
            case 3: {
                string3 = string5 + string6 + string7;
                break;
            }
            case 4: {
                string3 = string6 + string5 + string7;
                break;
            }
            case 5: {
                string3 = string6 + string7 + string5;
                break;
            }
            case 6: {
                string3 = string5 + string7 + string8 + string6;
                break;
            }
            case 7: {
                string3 = string7 + string8 + string5 + string6;
                break;
            }
            case 8: {
                string3 = string7 + string8 + string6 + string5;
                break;
            }
            case 9: {
                string3 = string5 + string6 + string8 + string7;
                break;
            }
            case 10: {
                string3 = string6 + string5 + string8 + string7;
                break;
            }
            case 11: {
                string3 = string6 + string8 + string7 + string5;
                break;
            }
            default: {
                string3 = string7 + string5 + string6;
            }
        }
        return string3;
    }

    private static String buildJavaPositiveFormat(int n, String string, String string2, Locale locale) {
        String string3 = "";
        String string4 = "'" + string2 + "'";
        String string5 = FormatMaskUtil.getNumberFormatMask(string, 11);
        String string6 = string4;
        String string7 = " ";
        switch (n) {
            case 0: {
                string3 = string6 + string5;
                break;
            }
            case 1: {
                string3 = string5 + string6;
                break;
            }
            case 2: {
                string3 = string6 + string7 + string5;
                break;
            }
            case 3: {
                string3 = string5 + string7 + string6;
                break;
            }
            default: {
                string3 = string6 + string5;
            }
        }
        return string3;
    }

    private static String getNumberFormatMask(String string, int n) {
        String string2 = null;
        if (n == 11 || n == 12) {
            string2 = (String)JAVA_CURRENCY_NUMBER_FORMATS.get(string);
            if (string2 == null) {
                string2 = FormatMaskUtil.buildFormatMask(string, "2", n);
                JAVA_CURRENCY_NUMBER_FORMATS.put(string, string2);
                return string2;
            }
            return string2;
        }
        if (n == 10) {
            string2 = (String)ORACLE_CURRENCY_NUMBER_FORMATS.get(string);
            if (string2 == null) {
                string2 = FormatMaskUtil.buildFormatMask(string, "2", n);
                ORACLE_CURRENCY_NUMBER_FORMATS.put(string, string2);
                return string2;
            }
            return string2;
        }
        return string2;
    }

    public static String getCurrencyFormatWithCode(int n, String string, Locale locale, int n2, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Currency code cannot be null.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null.");
        }
        Integer n3 = (Integer)SYMBOL_TO_CODE_POSITIVE_POSITION_MAP.get(new Integer(FormatMaskUtil.getPositiveStyle(locale)));
        Integer n4 = (Integer)SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.get(new Integer(FormatMaskUtil.getNegativeStyle(locale)));
        int n5 = n3;
        int n6 = n4;
        String string3 = string;
        return FormatMaskUtil.getCurrencyFormatWithSymbol(n, string, string3, locale, n2, string2, n5, n6);
    }

    public static String getCurrencyFormatWithSymbol(int n, String string, Locale locale, int n2, String string2) {
        int n3 = FormatMaskUtil.getPositiveStyle(locale);
        int n4 = FormatMaskUtil.getNegativeStyle(locale);
        String string3 = FormatMaskUtil.getSymbol(string, locale);
        return FormatMaskUtil.getCurrencyFormatWithSymbol(n, string, string3, locale, n2, string2, n3, n4);
    }

    private static String getCurrencyFormatWithSymbol(int n, String string, String string2, Locale locale, int n2, String string3, int n3, int n4) {
        if (n != 11 && n != 12) {
            throw new IllegalArgumentException("Only Java and MS format mask type are supported.");
        }
        DecimalFormat decimalFormat = new DecimalFormat(n2, string3, locale);
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setInternationalCurrencySymbol(string);
        decimalFormatSymbols.setCurrencySymbol(string2);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        String string4 = decimalFormat.toPattern();
        String string5 = decimalFormat.getPositivePrefix();
        String string6 = decimalFormat.getPositiveSuffix();
        String string7 = decimalFormat.getNegativePrefix();
        String string8 = decimalFormat.getNegativeSuffix();
        if (string4.indexOf("\u00a4\u00a4") != -1) {
            if (string5.indexOf(string) != -1) {
                decimalFormat.setPositivePrefix(string5);
            }
            if (string6.indexOf(string) != -1) {
                decimalFormat.setPositiveSuffix(string6);
            }
            if (string7.indexOf(string) != -1) {
                decimalFormat.setNegativePrefix(string7);
            }
            if (string8.indexOf(string) != -1) {
                decimalFormat.setNegativeSuffix(string8);
            }
        } else if (string4.indexOf("\u00a4") != -1) {
            if (string5.indexOf(string2) != -1) {
                decimalFormat.setPositivePrefix(string5);
            }
            if (string6.indexOf(string2) != -1) {
                decimalFormat.setPositiveSuffix(string6);
            }
            if (string7.indexOf(string2) != -1) {
                decimalFormat.setNegativePrefix(string7);
            }
            if (string8.indexOf(string2) != -1) {
                decimalFormat.setNegativeSuffix(string8);
            }
        } else {
            String string9 = string2;
            String string10 = " ";
            FormatMaskUtil.setAffix(decimalFormat, n3, n4, string9, string10, string5, string6, string7, string8);
        }
        string4 = decimalFormat.toPattern();
        return string4;
    }

    private static void setAffix(DecimalFormat decimalFormat, int n, int n2, String string, String string2, String string3, String string4, String string5, String string6) {
        switch (n2) {
            case 0: {
                decimalFormat.setPositivePrefix(string3 + string);
                decimalFormat.setNegativePrefix(string5 + string);
                break;
            }
            case 1: {
                decimalFormat.setPositivePrefix(string3 + string);
                decimalFormat.setNegativePrefix(string5 + string);
                break;
            }
            case 2: {
                decimalFormat.setPositivePrefix(string3 + string);
                decimalFormat.setNegativePrefix(string5 + string);
                break;
            }
            case 3: {
                decimalFormat.setPositiveSuffix(string + string4);
                decimalFormat.setNegativeSuffix(string + string6);
                break;
            }
            case 4: {
                decimalFormat.setPositiveSuffix(string + string4);
                decimalFormat.setNegativeSuffix(string + string6);
                break;
            }
            case 5: {
                decimalFormat.setPositiveSuffix(string + string4);
                decimalFormat.setNegativeSuffix(string + string6);
                break;
            }
            case 6: {
                decimalFormat.setPositivePrefix(string3 + string + string2);
                decimalFormat.setNegativePrefix(string5 + string + string2);
                break;
            }
            case 7: {
                decimalFormat.setPositivePrefix(string3 + string + string2);
                decimalFormat.setNegativePrefix(string5 + string + string2);
                break;
            }
            case 8: {
                decimalFormat.setPositivePrefix(string3 + string + string2);
                decimalFormat.setNegativePrefix(string5 + string + string2);
                break;
            }
            case 9: {
                decimalFormat.setPositiveSuffix(string2 + string + string4);
                decimalFormat.setNegativeSuffix(string2 + string + string6);
                break;
            }
            case 10: {
                decimalFormat.setPositiveSuffix(string2 + string + string4);
                decimalFormat.setNegativeSuffix(string2 + string + string6);
                break;
            }
            case 11: {
                decimalFormat.setPositiveSuffix(string2 + string + string4);
                decimalFormat.setNegativeSuffix(string2 + string + string6);
                break;
            }
            default: {
                decimalFormat.setPositivePrefix(string3 + string);
                decimalFormat.setNegativePrefix(string5 + string);
            }
        }
    }

    private static boolean isAllUpperASCIIChars(String string) {
        Boolean bl = (Boolean)IS_SYMBOL_CODE_CACHE.get(string);
        if (bl != null) {
            return bl;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (ASCII_CHARS.indexOf(cArray[i]) != -1) continue;
            bl = new Boolean(false);
            IS_SYMBOL_CODE_CACHE.put(string, bl);
            return bl;
        }
        bl = new Boolean(true);
        IS_SYMBOL_CODE_CACHE.put(string, bl);
        return bl;
    }

    public static int getCurrencyPrecision(String string) {
        String string2 = (String)CURRENCY_PRECISION_INFO.get(string);
        int n = 2;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    static {
        String string;
        String string2;
        String string3;
        RCS_ID_RECORDED = VersionInfo.recordClassVersion(RCS_ID, "oracle.apps.fnd.i18n.common.util");
        MS_SPECIFIC_PATTERNS = new String[]{"gg", "fff", "ffff", "fffff", "ffffff", "fffffff", "tt", "gggg", "ggge", "AMPM", "am/pm"};
        JAVA_SPECIFIC_PATTERNS = new String[]{"GG", "MMMMM", "DDDD", "k", "kk", "K", "KK", "SS", "ZZ", "ZZZ"};
        ORA_SPECIFIC_PATTERNS = new String[]{"ad", "Ad", "aD", "AD", "a.d.", "A.d.", "a.D.", "A.D.", "Am", "aM", "a.m.", "A.m.", "a.M.", "A.M.", "bc", "Bc", "bC", "BC", "b.c.", "B.c.", "b.C.", "B.C.", "cc", "Cc", "cC", "CC", "day", "Day", "DAY", "dl", "Dl", "dL", "DL", "ds", "Ds", "dS", "DS", "dy", "Dy", "dY", "DY", "ee", "Ee", "eE", "ff1", "FF1", "ff2", "FF2", "ff3", "FF3", "ff4", "FF4", "ff5", "FF5", "ff6", "FF6", "ff7", "FF7", "ff8", "FF8", "ff9", "FF9", "Hh", "hH", "hh12", "Hh12", "hH12", "HH12", "hh24", "Hh24", "hH24", "HH24", "mi", "Mi", "mI", "MI", "Mm", "mon", "Mon", "MON", "month", "Month", "MONTH", "Pm", "pM", "p.m.", "P.m.", "p.M.", "P.M.", "r", "R", "rr", "RR", "rrr", "RRR", "rrrr", "RRRR", "tzd", "Tzd", "TZD", "tzh", "Tzh", "TZH", "tzm", "Tzm", "TZM", "tzr", "Tzr", "TZR", "x", "X", "YYYY", "YYY", "YY", "Y"};
        CURRENCY_PRECISION_INFO = new Hashtable();
        CURRENCY_PRECISION_INFO.put("ADP", "0");
        CURRENCY_PRECISION_INFO.put("AED", "2");
        CURRENCY_PRECISION_INFO.put("AFA", "2");
        CURRENCY_PRECISION_INFO.put("AFN", "2");
        CURRENCY_PRECISION_INFO.put("ALL", "2");
        CURRENCY_PRECISION_INFO.put("AMD", "2");
        CURRENCY_PRECISION_INFO.put("ANG", "2");
        CURRENCY_PRECISION_INFO.put("AOA", "2");
        CURRENCY_PRECISION_INFO.put("AOK", "0");
        CURRENCY_PRECISION_INFO.put("AON", "2");
        CURRENCY_PRECISION_INFO.put("ARA", "2");
        CURRENCY_PRECISION_INFO.put("ARS", "2");
        CURRENCY_PRECISION_INFO.put("ATS", "2");
        CURRENCY_PRECISION_INFO.put("AUD", "2");
        CURRENCY_PRECISION_INFO.put("AWG", "2");
        CURRENCY_PRECISION_INFO.put("AZM", "2");
        CURRENCY_PRECISION_INFO.put("BAM", "2");
        CURRENCY_PRECISION_INFO.put("BBD", "2");
        CURRENCY_PRECISION_INFO.put("BDT", "2");
        CURRENCY_PRECISION_INFO.put("BEF", "0");
        CURRENCY_PRECISION_INFO.put("BGL", "2");
        CURRENCY_PRECISION_INFO.put("BGN", "2");
        CURRENCY_PRECISION_INFO.put("BHD", "3");
        CURRENCY_PRECISION_INFO.put("BIF", "0");
        CURRENCY_PRECISION_INFO.put("BMD", "2");
        CURRENCY_PRECISION_INFO.put("BND", "2");
        CURRENCY_PRECISION_INFO.put("BOB", "2");
        CURRENCY_PRECISION_INFO.put("BOV", "2");
        CURRENCY_PRECISION_INFO.put("BRC", "2");
        CURRENCY_PRECISION_INFO.put("BRL", "2");
        CURRENCY_PRECISION_INFO.put("BSD", "2");
        CURRENCY_PRECISION_INFO.put("BTN", "2");
        CURRENCY_PRECISION_INFO.put("BUK", "2");
        CURRENCY_PRECISION_INFO.put("BWP", "2");
        CURRENCY_PRECISION_INFO.put("BYB", "0");
        CURRENCY_PRECISION_INFO.put("BYR", "0");
        CURRENCY_PRECISION_INFO.put("BZD", "2");
        CURRENCY_PRECISION_INFO.put("CAD", "2");
        CURRENCY_PRECISION_INFO.put("CDF", "2");
        CURRENCY_PRECISION_INFO.put("CHE", "2");
        CURRENCY_PRECISION_INFO.put("CHF", "2");
        CURRENCY_PRECISION_INFO.put("CHW", "2");
        CURRENCY_PRECISION_INFO.put("CLF", "0");
        CURRENCY_PRECISION_INFO.put("CLP", "0");
        CURRENCY_PRECISION_INFO.put("CNY", "2");
        CURRENCY_PRECISION_INFO.put("COP", "2");
        CURRENCY_PRECISION_INFO.put("COU", "2");
        CURRENCY_PRECISION_INFO.put("CRC", "2");
        CURRENCY_PRECISION_INFO.put("CSK", "2");
        CURRENCY_PRECISION_INFO.put("CUP", "2");
        CURRENCY_PRECISION_INFO.put("CVE", "2");
        CURRENCY_PRECISION_INFO.put("CYP", "2");
        CURRENCY_PRECISION_INFO.put("CZK", "2");
        CURRENCY_PRECISION_INFO.put("DEM", "2");
        CURRENCY_PRECISION_INFO.put("DJF", "0");
        CURRENCY_PRECISION_INFO.put("DKK", "2");
        CURRENCY_PRECISION_INFO.put("DOP", "2");
        CURRENCY_PRECISION_INFO.put("DZD", "2");
        CURRENCY_PRECISION_INFO.put("ECS", "2");
        CURRENCY_PRECISION_INFO.put("ECV", "2");
        CURRENCY_PRECISION_INFO.put("EEK", "2");
        CURRENCY_PRECISION_INFO.put("EGP", "2");
        CURRENCY_PRECISION_INFO.put("ERN", "2");
        CURRENCY_PRECISION_INFO.put("ESB", "0");
        CURRENCY_PRECISION_INFO.put("ESP", "0");
        CURRENCY_PRECISION_INFO.put("ETB", "2");
        CURRENCY_PRECISION_INFO.put("EUR", "2");
        CURRENCY_PRECISION_INFO.put("FIM", "2");
        CURRENCY_PRECISION_INFO.put("FJD", "2");
        CURRENCY_PRECISION_INFO.put("FKP", "2");
        CURRENCY_PRECISION_INFO.put("FRF", "2");
        CURRENCY_PRECISION_INFO.put("GBP", "2");
        CURRENCY_PRECISION_INFO.put("GEK", "0");
        CURRENCY_PRECISION_INFO.put("GEL", "2");
        CURRENCY_PRECISION_INFO.put("GHC", "2");
        CURRENCY_PRECISION_INFO.put("GHS", "2");
        CURRENCY_PRECISION_INFO.put("GIP", "2");
        CURRENCY_PRECISION_INFO.put("GMD", "2");
        CURRENCY_PRECISION_INFO.put("GNF", "0");
        CURRENCY_PRECISION_INFO.put("GRD", "0");
        CURRENCY_PRECISION_INFO.put("GTQ", "2");
        CURRENCY_PRECISION_INFO.put("GWP", "2");
        CURRENCY_PRECISION_INFO.put("GYD", "2");
        CURRENCY_PRECISION_INFO.put("HKD", "2");
        CURRENCY_PRECISION_INFO.put("HNL", "2");
        CURRENCY_PRECISION_INFO.put("HRD", "0");
        CURRENCY_PRECISION_INFO.put("HRK", "2");
        CURRENCY_PRECISION_INFO.put("HTG", "2");
        CURRENCY_PRECISION_INFO.put("HUF", "2");
        CURRENCY_PRECISION_INFO.put("IDR", "2");
        CURRENCY_PRECISION_INFO.put("IEP", "2");
        CURRENCY_PRECISION_INFO.put("ILS", "2");
        CURRENCY_PRECISION_INFO.put("INR", "2");
        CURRENCY_PRECISION_INFO.put("IQD", "3");
        CURRENCY_PRECISION_INFO.put("IRR", "2");
        CURRENCY_PRECISION_INFO.put("ISK", "2");
        CURRENCY_PRECISION_INFO.put("ITL", "0");
        CURRENCY_PRECISION_INFO.put("JMD", "2");
        CURRENCY_PRECISION_INFO.put("JOD", "3");
        CURRENCY_PRECISION_INFO.put("JPY", "0");
        CURRENCY_PRECISION_INFO.put("KES", "2");
        CURRENCY_PRECISION_INFO.put("KGS", "2");
        CURRENCY_PRECISION_INFO.put("KHR", "2");
        CURRENCY_PRECISION_INFO.put("KMF", "0");
        CURRENCY_PRECISION_INFO.put("KPW", "2");
        CURRENCY_PRECISION_INFO.put("KRW", "0");
        CURRENCY_PRECISION_INFO.put("KWD", "3");
        CURRENCY_PRECISION_INFO.put("KYD", "2");
        CURRENCY_PRECISION_INFO.put("KZT", "2");
        CURRENCY_PRECISION_INFO.put("LAK", "2");
        CURRENCY_PRECISION_INFO.put("LBP", "2");
        CURRENCY_PRECISION_INFO.put("LKR", "2");
        CURRENCY_PRECISION_INFO.put("LRD", "2");
        CURRENCY_PRECISION_INFO.put("LSL", "2");
        CURRENCY_PRECISION_INFO.put("LTL", "2");
        CURRENCY_PRECISION_INFO.put("LUC", "0");
        CURRENCY_PRECISION_INFO.put("LUF", "0");
        CURRENCY_PRECISION_INFO.put("LUL", "0");
        CURRENCY_PRECISION_INFO.put("LVL", "2");
        CURRENCY_PRECISION_INFO.put("LVR", "2");
        CURRENCY_PRECISION_INFO.put("LYD", "3");
        CURRENCY_PRECISION_INFO.put("MAD", "2");
        CURRENCY_PRECISION_INFO.put("MDL", "2");
        CURRENCY_PRECISION_INFO.put("MGA", "2");
        CURRENCY_PRECISION_INFO.put("MGF", "0");
        CURRENCY_PRECISION_INFO.put("MKD", "2");
        CURRENCY_PRECISION_INFO.put("MMK", "2");
        CURRENCY_PRECISION_INFO.put("MNT", "2");
        CURRENCY_PRECISION_INFO.put("MOP", "2");
        CURRENCY_PRECISION_INFO.put("MRO", "2");
        CURRENCY_PRECISION_INFO.put("MTL", "2");
        CURRENCY_PRECISION_INFO.put("MUR", "2");
        CURRENCY_PRECISION_INFO.put("MVR", "2");
        CURRENCY_PRECISION_INFO.put("MWK", "2");
        CURRENCY_PRECISION_INFO.put("MXN", "2");
        CURRENCY_PRECISION_INFO.put("MXP", "0");
        CURRENCY_PRECISION_INFO.put("MXV", "2");
        CURRENCY_PRECISION_INFO.put("MYR", "2");
        CURRENCY_PRECISION_INFO.put("MZM", "2");
        CURRENCY_PRECISION_INFO.put("NAD", "2");
        CURRENCY_PRECISION_INFO.put("NGN", "2");
        CURRENCY_PRECISION_INFO.put("NIC", "2");
        CURRENCY_PRECISION_INFO.put("NIO", "2");
        CURRENCY_PRECISION_INFO.put("NLG", "2");
        CURRENCY_PRECISION_INFO.put("NOK", "2");
        CURRENCY_PRECISION_INFO.put("NPR", "2");
        CURRENCY_PRECISION_INFO.put("NZD", "2");
        CURRENCY_PRECISION_INFO.put("OMR", "3");
        CURRENCY_PRECISION_INFO.put("PAB", "2");
        CURRENCY_PRECISION_INFO.put("PEI", "2");
        CURRENCY_PRECISION_INFO.put("PEN", "2");
        CURRENCY_PRECISION_INFO.put("PGK", "2");
        CURRENCY_PRECISION_INFO.put("PHP", "2");
        CURRENCY_PRECISION_INFO.put("PKR", "2");
        CURRENCY_PRECISION_INFO.put("PLN", "2");
        CURRENCY_PRECISION_INFO.put("PLZ", "2");
        CURRENCY_PRECISION_INFO.put("PTE", "0");
        CURRENCY_PRECISION_INFO.put("PYG", "0");
        CURRENCY_PRECISION_INFO.put("QAR", "2");
        CURRENCY_PRECISION_INFO.put("ROL", "2");
        CURRENCY_PRECISION_INFO.put("RON", "2");
        CURRENCY_PRECISION_INFO.put("RSD", "2");
        CURRENCY_PRECISION_INFO.put("RUB", "2");
        CURRENCY_PRECISION_INFO.put("RUR", "2");
        CURRENCY_PRECISION_INFO.put("RWF", "0");
        CURRENCY_PRECISION_INFO.put("SAR", "2");
        CURRENCY_PRECISION_INFO.put("SBD", "2");
        CURRENCY_PRECISION_INFO.put("SCR", "2");
        CURRENCY_PRECISION_INFO.put("SDD", "2");
        CURRENCY_PRECISION_INFO.put("SDG", "2");
        CURRENCY_PRECISION_INFO.put("SDP", "2");
        CURRENCY_PRECISION_INFO.put("SEK", "2");
        CURRENCY_PRECISION_INFO.put("SGD", "2");
        CURRENCY_PRECISION_INFO.put("SHP", "2");
        CURRENCY_PRECISION_INFO.put("SIT", "2");
        CURRENCY_PRECISION_INFO.put("SKK", "2");
        CURRENCY_PRECISION_INFO.put("SLL", "2");
        CURRENCY_PRECISION_INFO.put("SOS", "2");
        CURRENCY_PRECISION_INFO.put("SRG", "2");
        CURRENCY_PRECISION_INFO.put("SRD", "2");
        CURRENCY_PRECISION_INFO.put("STAT", "2");
        CURRENCY_PRECISION_INFO.put("STD", "2");
        CURRENCY_PRECISION_INFO.put("SUR", "2");
        CURRENCY_PRECISION_INFO.put("SVC", "2");
        CURRENCY_PRECISION_INFO.put("SYP", "2");
        CURRENCY_PRECISION_INFO.put("SZL", "2");
        CURRENCY_PRECISION_INFO.put("THB", "2");
        CURRENCY_PRECISION_INFO.put("TJR", "0");
        CURRENCY_PRECISION_INFO.put("TJS", "2");
        CURRENCY_PRECISION_INFO.put("TMM", "2");
        CURRENCY_PRECISION_INFO.put("TND", "3");
        CURRENCY_PRECISION_INFO.put("TOP", "2");
        CURRENCY_PRECISION_INFO.put("TPE", "0");
        CURRENCY_PRECISION_INFO.put("TRL", "0");
        CURRENCY_PRECISION_INFO.put("TRY", "2");
        CURRENCY_PRECISION_INFO.put("TTD", "2");
        CURRENCY_PRECISION_INFO.put("TWD", "2");
        CURRENCY_PRECISION_INFO.put("TZS", "2");
        CURRENCY_PRECISION_INFO.put("UAH", "2");
        CURRENCY_PRECISION_INFO.put("UAK", "2");
        CURRENCY_PRECISION_INFO.put("UGS", "2");
        CURRENCY_PRECISION_INFO.put("UGX", "2");
        CURRENCY_PRECISION_INFO.put("USD", "2");
        CURRENCY_PRECISION_INFO.put("USN", "2");
        CURRENCY_PRECISION_INFO.put("USS", "2");
        CURRENCY_PRECISION_INFO.put("UYI", "0");
        CURRENCY_PRECISION_INFO.put("UYP", "2");
        CURRENCY_PRECISION_INFO.put("UYU", "2");
        CURRENCY_PRECISION_INFO.put("UZS", "2");
        CURRENCY_PRECISION_INFO.put("VEB", "2");
        CURRENCY_PRECISION_INFO.put("VEF", "2");
        CURRENCY_PRECISION_INFO.put("VND", "2");
        CURRENCY_PRECISION_INFO.put("VUV", "0");
        CURRENCY_PRECISION_INFO.put("WST", "2");
        CURRENCY_PRECISION_INFO.put("XAF", "0");
        CURRENCY_PRECISION_INFO.put("XAG", "");
        CURRENCY_PRECISION_INFO.put("XAU", "");
        CURRENCY_PRECISION_INFO.put("XB5", "");
        CURRENCY_PRECISION_INFO.put("XBA", "");
        CURRENCY_PRECISION_INFO.put("XBB", "");
        CURRENCY_PRECISION_INFO.put("XBC", "");
        CURRENCY_PRECISION_INFO.put("XBD", "");
        CURRENCY_PRECISION_INFO.put("XCD", "2");
        CURRENCY_PRECISION_INFO.put("XDR", "");
        CURRENCY_PRECISION_INFO.put("XEU", "2");
        CURRENCY_PRECISION_INFO.put("XFO", "");
        CURRENCY_PRECISION_INFO.put("XFU", "");
        CURRENCY_PRECISION_INFO.put("XOF", "0");
        CURRENCY_PRECISION_INFO.put("XPD", "");
        CURRENCY_PRECISION_INFO.put("XPF", "0");
        CURRENCY_PRECISION_INFO.put("XPT", "");
        CURRENCY_PRECISION_INFO.put("XTS", "");
        CURRENCY_PRECISION_INFO.put("XXX", "");
        CURRENCY_PRECISION_INFO.put("YDD", "3");
        CURRENCY_PRECISION_INFO.put("YER", "2");
        CURRENCY_PRECISION_INFO.put("YUD", "0");
        CURRENCY_PRECISION_INFO.put("YUM", "2");
        CURRENCY_PRECISION_INFO.put("YUN", "2");
        CURRENCY_PRECISION_INFO.put("ZAL", "2");
        CURRENCY_PRECISION_INFO.put("ZAR", "2");
        CURRENCY_PRECISION_INFO.put("ZMK", "2");
        CURRENCY_PRECISION_INFO.put("ZRN", "2");
        CURRENCY_PRECISION_INFO.put("ZRZ", "2");
        CURRENCY_PRECISION_INFO.put("ZWD", "2");
        JAVA_CURRENCY_NUMBER_FORMATS = null;
        ORACLE_CURRENCY_NUMBER_FORMATS = null;
        NUMBER_FORMAT_DETECTOR = new ExcelNumberFormat();
        DATE_FORMAT_DETECTOR = new ExcelDateFormat();
        JAVA_CURRENCY_NUMBER_FORMATS = new Hashtable();
        Enumeration enumeration = CURRENCY_PRECISION_INFO.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = (String)CURRENCY_PRECISION_INFO.get(string3);
            string = FormatMaskUtil.buildFormatMask(string3, string2, 11);
            JAVA_CURRENCY_NUMBER_FORMATS.put(string3, string);
        }
        ORACLE_CURRENCY_NUMBER_FORMATS = new Hashtable();
        enumeration = CURRENCY_PRECISION_INFO.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = (String)CURRENCY_PRECISION_INFO.get(string3);
            string = FormatMaskUtil.buildFormatMask(string3, string2, 10);
            ORACLE_CURRENCY_NUMBER_FORMATS.put(string3, string);
        }
        DEFAULT_CURRENCY_SYMBOLS = new Hashtable();
        LOCAL_CURRENCY_SYMBOLS = new Hashtable();
        DEFAULT_CURRENCY_POSITIVE_STYLES = new Hashtable();
        LOCAL_CURRENCY_POSITIVE_STYLES = new Hashtable();
        DEFAULT_CURRENCY_NEGATIVE_STYLES = new Hashtable();
        LOCAL_CURRENCY_NEGATIVE_STYLES = new Hashtable();
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("AED", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("ALL", new Integer(1));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("AMD", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("ARS", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("AUD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("AZM", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BAM", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BGL", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BHD", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BND", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BOB", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BRL", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BYB", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("BZD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("CHF", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("CLP", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("CNY", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("COP", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("CRC", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("CSD", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("CZK", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("DKK", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("DOP", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("DZD", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("EEK", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("EGP", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("GBP", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("GEL", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("GTQ", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("HKD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("HNL", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("HRK", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("HUF", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("IDR", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("ILS", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("INR", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("IQD", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("IRR", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("ISK", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("JMD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("JOD", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("JPY", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("KES", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("KGS", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("KRW", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("KWD", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("KZT", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("LBP", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("LTL", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("LVL", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("LYD", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MAD", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MKD", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MNT", new Integer(1));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MOP", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MTL", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MVR", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MXN", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("MYR", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("NIO", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("NOK", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("NZD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("OMR", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("PAB", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("PEN", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("PHP", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("PKR", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("PLN", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("PYG", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("QAR", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("ROL", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("SAR", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("SEK", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("SGD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("SIT", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("SKK", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("SYP", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("THB", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("TND", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("TRL", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("TTD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("TWD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("UAH", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("UYU", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("UZS", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("VEB", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("VND", new Integer(3));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("YER", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("ZAR", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("ZWD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("RUR", new Integer(1));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("CAD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("EUR", new Integer(2));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("USD", new Integer(0));
        DEFAULT_CURRENCY_POSITIVE_STYLES.put("TRY", new Integer(3));
        LOCAL_CURRENCY_POSITIVE_STYLES.put("RUR", new Object[][]{{new String("ru_RU"), new Integer(1)}, {new String("tt_RU"), new Integer(3)}});
        LOCAL_CURRENCY_POSITIVE_STYLES.put("CAD", new Object[][]{{new String("en_CA"), new Integer(0)}, {new String("fr_CA"), new Integer(3)}});
        LOCAL_CURRENCY_POSITIVE_STYLES.put("EUR", new Object[][]{{new String("fi_FI"), new Integer(3)}, {new String("sv_FI"), new Integer(3)}, {new String("fr_MC"), new Integer(3)}, {new String("de_AT"), new Integer(2)}, {new String("ca_ES"), new Integer(3)}, {new String("en_IE"), new Integer(0)}, {new String("de_DE"), new Integer(3)}, {new String("de_LU"), new Integer(3)}, {new String("es_ES"), new Integer(3)}, {new String("eu_ES"), new Integer(3)}, {new String("nl_NL"), new Integer(2)}, {new String("fr_LU"), new Integer(3)}, {new String("it_IT"), new Integer(2)}, {new String("fr_FR"), new Integer(3)}, {new String("fr_BE"), new Integer(3)}, {new String("gl_ES"), new Integer(2)}, {new String("el_GR"), new Integer(3)}, {new String("pt_PT"), new Integer(3)}, {new String("nl_BE"), new Integer(3)}});
        LOCAL_CURRENCY_POSITIVE_STYLES.put("USD", new Object[][]{{new String("es_EC"), new Integer(2)}, {new String("en_US"), new Integer(0)}, {new String("es_PR"), new Integer(2)}, {new String("qu_EC"), new Integer(2)}, {new String("es_SV"), new Integer(0)}, {new String("en_CB"), new Integer(0)}});
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("AED", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("ALL", new Integer(3));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("AMD", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("ARS", new Integer(1));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("AUD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("AZM", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BAM", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BGL", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BHD", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BND", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BOB", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BRL", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BYB", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("BZD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("CHF", new Integer(1));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("CLP", new Integer(6));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("CNY", new Integer(1));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("COP", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("CRC", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("CSD", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("CZK", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("DKK", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("DOP", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("DZD", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("EEK", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("EGP", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("GBP", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("GEL", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("GTQ", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("HKD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("HNL", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("HRK", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("HUF", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("IDR", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("ILS", new Integer(1));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("INR", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("IQD", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("IRR", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("ISK", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("JMD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("JOD", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("JPY", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("KES", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("KGS", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("KRW", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("KWD", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("KZT", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("LBP", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("LTL", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("LVL", new Integer(6));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("LYD", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MAD", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MKD", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MNT", new Integer(3));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MOP", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MTL", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MVR", new Integer(11));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MXN", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("MYR", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("NIO", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("NOK", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("NZD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("OMR", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("PAB", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("PEN", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("PHP", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("PKR", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("PLN", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("PYG", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("QAR", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("ROL", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("SAR", new Integer(8));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("SEK", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("SGD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("SIT", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("SKK", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("SYP", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("THB", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("TND", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("TRL", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("TTD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("TWD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("UAH", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("UYU", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("UZS", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("VEB", new Integer(7));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("VND", new Integer(9));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("YER", new Integer(2));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("ZAR", new Integer(1));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("ZWD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("RUR", new Integer(3));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("CAD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("EUR", new Integer(6));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("USD", new Integer(0));
        DEFAULT_CURRENCY_NEGATIVE_STYLES.put("TRY", new Integer(9));
        LOCAL_CURRENCY_NEGATIVE_STYLES.put("RUR", new Object[][]{{new String("ru_RU"), new Integer(3)}, {new String("tt_RU"), new Integer(9)}});
        LOCAL_CURRENCY_NEGATIVE_STYLES.put("CAD", new Object[][]{{new String("fr_CA"), new Integer(9)}, {new String("en_CA"), new Integer(0)}});
        LOCAL_CURRENCY_NEGATIVE_STYLES.put("EUR", new Object[][]{{new String("sv_FI"), new Integer(9)}, {new String("fr_FR"), new Integer(9)}, {new String("fr_BE"), new Integer(9)}, {new String("de_LU"), new Integer(9)}, {new String("nl_NL"), new Integer(8)}, {new String("en_IE"), new Integer(0)}, {new String("el_GR"), new Integer(9)}, {new String("pt_PT"), new Integer(9)}, {new String("fr_MC"), new Integer(9)}, {new String("es_ES"), new Integer(9)}, {new String("gl_ES"), new Integer(9)}, {new String("it_IT"), new Integer(6)}, {new String("eu_ES"), new Integer(9)}, {new String("ca_ES"), new Integer(9)}, {new String("fr_LU"), new Integer(9)}, {new String("nl_BE"), new Integer(9)}, {new String("de_DE"), new Integer(9)}, {new String("de_AT"), new Integer(6)}, {new String("fi_FI"), new Integer(9)}});
        LOCAL_CURRENCY_NEGATIVE_STYLES.put("USD", new Object[][]{{new String("en_US"), new Integer(0)}, {new String("en_CB"), new Integer(0)}, {new String("qu_EC"), new Integer(7)}, {new String("es_EC"), new Integer(7)}, {new String("es_SV"), new Integer(0)}, {new String("es_PR"), new Integer(7)}});
        DEFAULT_CURRENCY_SYMBOLS.put("AED", "\u062f.\u0625.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("AFN", "\u060b");
        DEFAULT_CURRENCY_SYMBOLS.put("ALL", "Lek");
        DEFAULT_CURRENCY_SYMBOLS.put("AMD", "\u0564\u0580.");
        DEFAULT_CURRENCY_SYMBOLS.put("ANG", "\u0192");
        DEFAULT_CURRENCY_SYMBOLS.put("AOA", "Kz");
        DEFAULT_CURRENCY_SYMBOLS.put("ARS", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("AUD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("AWG", "\u0192");
        DEFAULT_CURRENCY_SYMBOLS.put("AZM", "\u043c\u0430\u043d.");
        DEFAULT_CURRENCY_SYMBOLS.put("AZN", "\u043c\u0430\u043d");
        DEFAULT_CURRENCY_SYMBOLS.put("BAM", "KM");
        DEFAULT_CURRENCY_SYMBOLS.put("BBD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("BEF", "\u20a3");
        DEFAULT_CURRENCY_SYMBOLS.put("BGL", "\u043b\u0432");
        DEFAULT_CURRENCY_SYMBOLS.put("BGN", "\u043b\u0432");
        DEFAULT_CURRENCY_SYMBOLS.put("BHD", "\u062f.\u0628.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("BIF", "FBu");
        DEFAULT_CURRENCY_SYMBOLS.put("BMD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("BND", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("BOB", "$b");
        DEFAULT_CURRENCY_SYMBOLS.put("BRC", "\u20a2");
        DEFAULT_CURRENCY_SYMBOLS.put("BRL", "R$");
        DEFAULT_CURRENCY_SYMBOLS.put("BSD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("BTN", "Nu.");
        DEFAULT_CURRENCY_SYMBOLS.put("BWP", "P");
        DEFAULT_CURRENCY_SYMBOLS.put("BYB", "\u0440.");
        DEFAULT_CURRENCY_SYMBOLS.put("BYR", "p.");
        DEFAULT_CURRENCY_SYMBOLS.put("BZD", "BZ$");
        DEFAULT_CURRENCY_SYMBOLS.put("CAD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("CDF", "F");
        DEFAULT_CURRENCY_SYMBOLS.put("CHF", "CHF");
        DEFAULT_CURRENCY_SYMBOLS.put("CLP", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("CNY", "\uffe5");
        DEFAULT_CURRENCY_SYMBOLS.put("COP", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("CRC", "\u20a1");
        DEFAULT_CURRENCY_SYMBOLS.put("CSD", "Din.");
        DEFAULT_CURRENCY_SYMBOLS.put("CUP", "\u20b1");
        DEFAULT_CURRENCY_SYMBOLS.put("CYP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("CZK", "K\u010d");
        DEFAULT_CURRENCY_SYMBOLS.put("DJF", "Fdj");
        DEFAULT_CURRENCY_SYMBOLS.put("DKK", "kr");
        DEFAULT_CURRENCY_SYMBOLS.put("DOP", "RD$");
        DEFAULT_CURRENCY_SYMBOLS.put("DZD", "\u062f.\u062c.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("EEK", "kr");
        DEFAULT_CURRENCY_SYMBOLS.put("EGP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("ERN", "Nfk");
        DEFAULT_CURRENCY_SYMBOLS.put("ESP", "\u20a7");
        DEFAULT_CURRENCY_SYMBOLS.put("ETB", "Br");
        DEFAULT_CURRENCY_SYMBOLS.put("EUR", "\u20ac");
        DEFAULT_CURRENCY_SYMBOLS.put("FJD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("FKP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("FRF", "\u20a3");
        DEFAULT_CURRENCY_SYMBOLS.put("GBP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("GEL", "Lari");
        DEFAULT_CURRENCY_SYMBOLS.put("GGP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("GHC", "\u00a2");
        DEFAULT_CURRENCY_SYMBOLS.put("GIP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("GMD", "D");
        DEFAULT_CURRENCY_SYMBOLS.put("GNF", "FG");
        DEFAULT_CURRENCY_SYMBOLS.put("GRD", "\u20af");
        DEFAULT_CURRENCY_SYMBOLS.put("GTQ", "Q");
        DEFAULT_CURRENCY_SYMBOLS.put("GYD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("HKD", "HK$");
        DEFAULT_CURRENCY_SYMBOLS.put("HNL", "L");
        DEFAULT_CURRENCY_SYMBOLS.put("HRK", "kn");
        DEFAULT_CURRENCY_SYMBOLS.put("HTG", "G");
        DEFAULT_CURRENCY_SYMBOLS.put("HUF", "Ft");
        DEFAULT_CURRENCY_SYMBOLS.put("IDR", "Rp");
        DEFAULT_CURRENCY_SYMBOLS.put("IEP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("ILS", "\u20aa");
        DEFAULT_CURRENCY_SYMBOLS.put("IMP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("INR", "\u20a8");
        DEFAULT_CURRENCY_SYMBOLS.put("IQD", "\u062f.\u0639.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("IRR", "\ufdfc");
        DEFAULT_CURRENCY_SYMBOLS.put("ISK", "kr");
        DEFAULT_CURRENCY_SYMBOLS.put("ITL", "\u20a4");
        DEFAULT_CURRENCY_SYMBOLS.put("JEP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("JMD", "J$");
        DEFAULT_CURRENCY_SYMBOLS.put("JOD", "\u062f.\u0627.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("JPY", "\u00a5");
        DEFAULT_CURRENCY_SYMBOLS.put("KES", "S");
        DEFAULT_CURRENCY_SYMBOLS.put("KGS", "\u043b\u0432");
        DEFAULT_CURRENCY_SYMBOLS.put("KHR", "\u17db");
        DEFAULT_CURRENCY_SYMBOLS.put("KPW", "\u20a9");
        DEFAULT_CURRENCY_SYMBOLS.put("KRW", "\u20a9");
        DEFAULT_CURRENCY_SYMBOLS.put("KWD", "\u062f.\u0643.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("KYD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("KZT", "\u043b\u0432");
        DEFAULT_CURRENCY_SYMBOLS.put("LAK", "\u20ad");
        DEFAULT_CURRENCY_SYMBOLS.put("LBP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("LKR", "\u20a8");
        DEFAULT_CURRENCY_SYMBOLS.put("LRD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("LTL", "Lt");
        DEFAULT_CURRENCY_SYMBOLS.put("LUF", "\u20a3");
        DEFAULT_CURRENCY_SYMBOLS.put("LVL", "Ls");
        DEFAULT_CURRENCY_SYMBOLS.put("LYD", "\u062f.\u0644.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("MAD", "\u062f.\u0645.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("MKD", "\u0434\u0435\u043d");
        DEFAULT_CURRENCY_SYMBOLS.put("MMK", "K");
        DEFAULT_CURRENCY_SYMBOLS.put("MNT", "\u20ae");
        DEFAULT_CURRENCY_SYMBOLS.put("MOP", "P");
        DEFAULT_CURRENCY_SYMBOLS.put("MRO", "UM");
        DEFAULT_CURRENCY_SYMBOLS.put("MTL", "Lm");
        DEFAULT_CURRENCY_SYMBOLS.put("MUR", "\u20a8");
        DEFAULT_CURRENCY_SYMBOLS.put("MVR", "\u0783.");
        DEFAULT_CURRENCY_SYMBOLS.put("MWK", "MK");
        DEFAULT_CURRENCY_SYMBOLS.put("MXN", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("MYR", "RM");
        DEFAULT_CURRENCY_SYMBOLS.put("MZN", "MT");
        DEFAULT_CURRENCY_SYMBOLS.put("NAD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("NGN", "\u20a6");
        DEFAULT_CURRENCY_SYMBOLS.put("NIO", "C$");
        DEFAULT_CURRENCY_SYMBOLS.put("NLG", "\u0192");
        DEFAULT_CURRENCY_SYMBOLS.put("NOK", "kr");
        DEFAULT_CURRENCY_SYMBOLS.put("NPR", "\u20a8");
        DEFAULT_CURRENCY_SYMBOLS.put("NZD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("OMR", "\ufdfc");
        DEFAULT_CURRENCY_SYMBOLS.put("PAB", "B/.");
        DEFAULT_CURRENCY_SYMBOLS.put("PEN", "S/.");
        DEFAULT_CURRENCY_SYMBOLS.put("PGK", "K");
        DEFAULT_CURRENCY_SYMBOLS.put("PHP", "Php");
        DEFAULT_CURRENCY_SYMBOLS.put("PKR", "\u20a8");
        DEFAULT_CURRENCY_SYMBOLS.put("PLN", "z\u0142");
        DEFAULT_CURRENCY_SYMBOLS.put("PYG", "Gs");
        DEFAULT_CURRENCY_SYMBOLS.put("QAR", "\ufdfc");
        DEFAULT_CURRENCY_SYMBOLS.put("ROL", "lei");
        DEFAULT_CURRENCY_SYMBOLS.put("RON", "lei");
        DEFAULT_CURRENCY_SYMBOLS.put("RSD", "\u0414\u0438\u043d.");
        DEFAULT_CURRENCY_SYMBOLS.put("RUB", "\u0440\u0443\u0431");
        DEFAULT_CURRENCY_SYMBOLS.put("RUR", "\u0440.");
        DEFAULT_CURRENCY_SYMBOLS.put("RWF", "RF");
        DEFAULT_CURRENCY_SYMBOLS.put("SAR", "\u0631.\u0633.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("SBD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("SCR", "\u20a8");
        DEFAULT_CURRENCY_SYMBOLS.put("SEK", "kr");
        DEFAULT_CURRENCY_SYMBOLS.put("SGD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("SHP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("SIT", "SIT");
        DEFAULT_CURRENCY_SYMBOLS.put("SKK", "SIT");
        DEFAULT_CURRENCY_SYMBOLS.put("SLL", "Le");
        DEFAULT_CURRENCY_SYMBOLS.put("SOS", "S");
        DEFAULT_CURRENCY_SYMBOLS.put("SRD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("STD", "Db");
        DEFAULT_CURRENCY_SYMBOLS.put("SVC", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("SYP", "\u00a3");
        DEFAULT_CURRENCY_SYMBOLS.put("THB", "\u0e3f");
        DEFAULT_CURRENCY_SYMBOLS.put("TMM", "m");
        DEFAULT_CURRENCY_SYMBOLS.put("TND", "\u062f.\u062a.\u200f");
        DEFAULT_CURRENCY_SYMBOLS.put("TOP", "T$");
        DEFAULT_CURRENCY_SYMBOLS.put("TRL", "\u20a4");
        DEFAULT_CURRENCY_SYMBOLS.put("TRY", "YTL");
        DEFAULT_CURRENCY_SYMBOLS.put("TTD", "TT$");
        DEFAULT_CURRENCY_SYMBOLS.put("TVD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("TWD", "NT$");
        DEFAULT_CURRENCY_SYMBOLS.put("UAH", "\u20b4");
        DEFAULT_CURRENCY_SYMBOLS.put("UGX", "USh");
        DEFAULT_CURRENCY_SYMBOLS.put("USD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("UYU", "$U");
        DEFAULT_CURRENCY_SYMBOLS.put("UZS", "\u043b\u0432");
        DEFAULT_CURRENCY_SYMBOLS.put("VAL", "\u20a4");
        DEFAULT_CURRENCY_SYMBOLS.put("VEB", "Bs");
        DEFAULT_CURRENCY_SYMBOLS.put("VND", "\u20ab");
        DEFAULT_CURRENCY_SYMBOLS.put("VUV", "Vt");
        DEFAULT_CURRENCY_SYMBOLS.put("WST", "WS$");
        DEFAULT_CURRENCY_SYMBOLS.put("XCD", "$");
        DEFAULT_CURRENCY_SYMBOLS.put("XEU", "\u20a0");
        DEFAULT_CURRENCY_SYMBOLS.put("XOF", "CFA");
        DEFAULT_CURRENCY_SYMBOLS.put("XPF", "F");
        DEFAULT_CURRENCY_SYMBOLS.put("YER", "\ufdfc");
        DEFAULT_CURRENCY_SYMBOLS.put("ZAR", "R");
        DEFAULT_CURRENCY_SYMBOLS.put("ZMK", "ZK");
        DEFAULT_CURRENCY_SYMBOLS.put("ZWD", "Z$");
        LOCAL_CURRENCY_SYMBOLS.put("AZM", new String[][]{{"az_AZ", "man."}});
        LOCAL_CURRENCY_SYMBOLS.put("CHF", new String[][]{{"fr_CH", "SFr."}, {"de_CH", "SFr."}, {"it_CH", "SFr."}});
        LOCAL_CURRENCY_SYMBOLS.put("CSD", new String[][]{{"sr_SP", "\u0414\u0438\u043d."}});
        LOCAL_CURRENCY_SYMBOLS.put("EGP", new String[][]{{"ar_EG", "\u062c.\u0645.\u200f"}});
        LOCAL_CURRENCY_SYMBOLS.put("HNL", new String[][]{{"es_HN", "L."}});
        LOCAL_CURRENCY_SYMBOLS.put("INR", new String[][]{{"hi_IN", "\u0930\u0941"}, {"te_IN", "\u0c30\u0c42"}, {"kok_IN", "\u0930\u0941"}, {"kn_IN", "\u0cb0\u0cc2"}, {"gu_IN", "\u0ab0\u0ac2"}, {"sa_IN", "\u0930\u0941"}, {"bn_IN", "\u099f\u09be"}, {"ml_IN", "\u0d15"}, {"ta_IN", "\u0bb0\u0bc2"}, {"mr_IN", "\u0930\u0941"}, {"pa_IN", "\u0a30\u0a41"}});
        LOCAL_CURRENCY_SYMBOLS.put("IRR", new String[][]{{"fa_IR", "\u0631\u064a\u0627\u0644"}});
        LOCAL_CURRENCY_SYMBOLS.put("ISK", new String[][]{{"is_IS", "kr."}});
        LOCAL_CURRENCY_SYMBOLS.put("KGS", new String[][]{{"ky_KG", "\u0441\u043e\u043c"}});
        LOCAL_CURRENCY_SYMBOLS.put("KZT", new String[][]{{"kk_KZ", "\u0422"}});
        LOCAL_CURRENCY_SYMBOLS.put("LBP", new String[][]{{"ar_LB", "\u0644.\u0644.\u200f"}});
        LOCAL_CURRENCY_SYMBOLS.put("MKD", new String[][]{{"mk_MK", "\u0434\u0435\u043d."}});
        LOCAL_CURRENCY_SYMBOLS.put("MYR", new String[][]{{"ms_MY", "R"}});
        LOCAL_CURRENCY_SYMBOLS.put("OMR", new String[][]{{"ar_OM", "\u0631.\u0639.\u200f"}});
        LOCAL_CURRENCY_SYMBOLS.put("PKR", new String[][]{{"ur_PK", "Rs"}});
        LOCAL_CURRENCY_SYMBOLS.put("QAR", new String[][]{{"ar_QA", "\u0631.\u0642.\u200f"}});
        LOCAL_CURRENCY_SYMBOLS.put("SAR", new String[][]{{"ar_SA", "\u0631.\u0633.\u200f"}});
        LOCAL_CURRENCY_SYMBOLS.put("SKK", new String[][]{{"sk_SK", "Sk"}});
        LOCAL_CURRENCY_SYMBOLS.put("SYP", new String[][]{{"syr_SY", "\u0644.\u0633.\u200f"}, {"ar_SY", "\u0644.\u0633.\u200f"}});
        LOCAL_CURRENCY_SYMBOLS.put("TRL", new String[][]{{"tr_TR", "TL"}});
        LOCAL_CURRENCY_SYMBOLS.put("UAH", new String[][]{{"uk_UA", "\u0433\u0440\u043d."}});
        LOCAL_CURRENCY_SYMBOLS.put("UZS", new String[][]{{"uz_UZ", "\u0441\u045e\u043c"}});
        LOCAL_CURRENCY_SYMBOLS.put("YER", new String[][]{{"ar_YE", "\u0631.\u064a.\u200f"}});
        LOCALE_POSITIVE_STYLES = new Hashtable();
        LOCALE_NEGATIVE_STYLES = new Hashtable();
        LOCALE_POSITIVE_STYLES.put("ar", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("be", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("be_BY", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("bg", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("bg_BG", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("ca", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("cs", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("cs_CZ", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("da", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("de", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("de_DE", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("de_LU", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("el", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("el_CY", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("el_GR", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("en", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("en_ZA", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("es", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("es_ES", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("es_UY", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("et", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("et_EE", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("fi", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("fi_FI", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("fr", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("fr_CH", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ga", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ga_IE", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("hi_IN", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("hr", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("hu", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("hu_HU", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("in", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("is", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("is_IS", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("it", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("iw", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("iw_IL", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("ja", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ja_JP", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("ko", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ko_KR", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("lt", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("lt_LT", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("lv", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("lv_LV", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("mk", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ms", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ms_MY", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("mt", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("mt_MT", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("nl", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("nl_BE", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("no", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("pl", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("pl_PL", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("pt", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("pt_PT", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("ro", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ro_RO", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("ru", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("ru_RU", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("sk", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("sk_SK", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("sl", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("sq", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("sq_AL", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("sr", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("sv", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("sv_SE", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("th", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("th_TH", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("tr", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("tr_TR", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("uk", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("uk_UA", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("vi", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("vi_VN", new Integer(3));
        LOCALE_POSITIVE_STYLES.put("zh", new Integer(2));
        LOCALE_POSITIVE_STYLES.put("zh_CN", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("zh_HK", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("zh_SG", new Integer(0));
        LOCALE_POSITIVE_STYLES.put("zh_TW", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("ar", new Integer(8));
        LOCALE_NEGATIVE_STYLES.put("be", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("be_BY", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("bg", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("bg_BG", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("ca", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("cs", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("cs_CZ", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("da", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("da_DK", new Integer(7));
        LOCALE_NEGATIVE_STYLES.put("de", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("de_CH", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("de_DE", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("de_LU", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("el", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("el_CY", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("el_GR", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("en", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("en_ZA", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("es", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("es_AR", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("es_CL", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("es_EC", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("es_ES", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("es_PE", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("es_UY", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("es_VE", new Integer(7));
        LOCALE_NEGATIVE_STYLES.put("et", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("et_EE", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("fi", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("fi_FI", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("fr", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("fr_CH", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("ga", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("ga_IE", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("hi_IN", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("hr", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("hu", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("hu_HU", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("in", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("is", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("is_IS", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("it", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("it_CH", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("iw", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("iw_IL", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("ja", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("ja_JP", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("ko", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("ko_KR", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("lt", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("lt_LT", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("lv", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("lv_LV", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("mk", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("ms", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("ms_MY", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("mt", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("mt_MT", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("nl", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("nl_BE", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("nl_NL", new Integer(8));
        LOCALE_NEGATIVE_STYLES.put("no", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("no_NO", new Integer(7));
        LOCALE_NEGATIVE_STYLES.put("pl", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("pl_PL", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("pt", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("pt_PT", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("ro", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("ro_RO", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("ru", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("ru_RU", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("sk", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("sk_SK", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("sl", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("sq", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("sq_AL", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("sr", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("sv", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("sv_SE", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("th", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("th_TH", new Integer(1));
        LOCALE_NEGATIVE_STYLES.put("tr", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("tr_TR", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("uk", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("uk_UA", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("vi", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("vi_VN", new Integer(9));
        LOCALE_NEGATIVE_STYLES.put("zh", new Integer(6));
        LOCALE_NEGATIVE_STYLES.put("zh_CN", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("zh_HK", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("zh_SG", new Integer(0));
        LOCALE_NEGATIVE_STYLES.put("zh_TW", new Integer(0));
        SYMBOL_TO_CODE_POSITIVE_POSITION_MAP = new Hashtable();
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP = new Hashtable();
        SYMBOL_TO_CODE_POSITIVE_POSITION_MAP.put(new Integer(0), new Integer(2));
        SYMBOL_TO_CODE_POSITIVE_POSITION_MAP.put(new Integer(1), new Integer(3));
        SYMBOL_TO_CODE_POSITIVE_POSITION_MAP.put(new Integer(2), new Integer(2));
        SYMBOL_TO_CODE_POSITIVE_POSITION_MAP.put(new Integer(3), new Integer(3));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(0), new Integer(7));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(1), new Integer(7));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(2), new Integer(8));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(3), new Integer(9));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(4), new Integer(10));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(5), new Integer(10));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(6), new Integer(7));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(7), new Integer(7));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(8), new Integer(8));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(9), new Integer(9));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(10), new Integer(10));
        SYMBOL_TO_CODE_NEGATIVE_POSITION_MAP.put(new Integer(11), new Integer(10));
        IS_SYMBOL_CODE_CACHE = new Hashtable();
    }
}

