/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.Calendar;

public class GregorianCalendar
extends Calendar {
    public static final String RCS_ID = "$Header: GregorianCalendar.java 120.4 2011/11/14 18:55:47 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: GregorianCalendar.java 120.4 2011/11/14 18:55:47 rsuzuki ship $", "oracle.apps.fnd.i18n.common.util");
    public static final int BC = 0;
    public static final int AD = 1;
    private static final int CURRENT_ERA = 1;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final int[] MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -46800000, 0, -13, -59, 0, -50, 1};
    private static final int[] LEAST_MAX_VALUES = new int[]{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 50400000, 3600000, 14, 59, 999999999, 999, 52};
    private static final int[] MAX_VALUES = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 3600000, 14, 59, 999999999, 999, 53};

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
        if (n7 > 999999999 || n7 < 0) {
            throw new IllegalArgumentException("nanosecond > 999999999 or < 0");
        }
        this.set(14, n7 / 1000000);
        this.set(19, n7);
    }

    public boolean isLeapYear(int n) {
        return this.isLeapYearInternal(n);
    }

    private boolean isLeapYearInternal(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof GregorianCalendar;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getMinimum(int n) {
        return MIN_VALUES[n];
    }

    public int getMaximum(int n) {
        return MAX_VALUES[n];
    }

    public int getGreatestMinimum(int n) {
        return MIN_VALUES[n];
    }

    public int getLeastMaximum(int n) {
        return LEAST_MAX_VALUES[n];
    }

    public int getActualMinimum(int n) {
        return this.getMinimum(n);
    }

    public int getActualMaximum(int n) {
        switch (n) {
            case 5: {
                return this.monthLength(this.get(2));
            }
            case 6: {
                return this.yearLength();
            }
            case 3: 
            case 4: 
            case 8: 
            case 21: {
                return super.getActualMaximum(n);
            }
            case 1: {
                Calendar calendar = (Calendar)this.clone();
                calendar.setLenient(true);
                int n2 = calendar.get(0);
                Date date = calendar.getTime();
                int n3 = LEAST_MAX_VALUES[1];
                int n4 = MAX_VALUES[1] + 1;
                while (n3 + 1 < n4) {
                    int n5 = (n3 + n4) / 2;
                    calendar.set(1, n5);
                    if (calendar.get(1) == n5 && calendar.get(0) == n2) {
                        n3 = n5;
                        continue;
                    }
                    n4 = n5;
                    calendar.setTime(date);
                }
                return n3;
            }
        }
        return this.getMaximum(n);
    }

    protected void handleEra(int n, int n2) {
    }

    protected int[] fieldInfo(long l) {
        return this.gregorianFieldInfo(l);
    }

    protected long yearToJulianDay(int n, int n2) {
        if (n == 0) {
            n2 = 1 - n2;
        }
        int n3 = n2 - 1;
        return 365L * (long)n3 + (long)GregorianCalendar.floorDivide(n3, 4) + (long)GregorianCalendar.floorDivide(n3, 400) - (long)GregorianCalendar.floorDivide(n3, 100) + 1721426L - 1L;
    }

    protected int monthDays(int n, int n2) {
        return this.isLeapYearInternal(n2) ? LEAP_NUM_DAYS[n] : NUM_DAYS[n];
    }

    protected int monthDays(int n) {
        int n2 = this.internalGet(1);
        int n3 = this.internalGetEra();
        n2 = n3 == 0 ? 1 - n2 : n2;
        return this.monthDays(n, n2);
    }

    protected int monthLength(int n, int n2) {
        return this.isLeapYearInternal(n2) ? LEAP_MONTH_LENGTH[n] : MONTH_LENGTH[n];
    }

    protected int monthLength(int n) {
        int n2 = this.internalGet(1);
        int n3 = this.internalGetEra();
        n2 = n3 == 0 ? 1 - n2 : n2;
        return this.monthLength(n, n2);
    }

    protected int yearLength(int n) {
        return this.isLeapYearInternal(n) ? 366 : 365;
    }

    protected int yearLength() {
        int n = this.internalGet(1);
        int n2 = this.internalGetEra();
        n = n2 == 1 ? n : 1 - n;
        return this.isLeapYearInternal(n) ? 366 : 365;
    }

    protected int getCurrentEra() {
        return 1;
    }

    private static final int floorDivide(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }
}

