/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.Calendar;
import oracle.apps.fnd.i18n.common.util.Deviation;

public class HijrahCalendar
extends Calendar {
    public static final String RCS_ID = "$Header: HijrahCalendar.java 120.8 2011/11/14 18:56:51 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED;
    public static final int BH = 0;
    public static final int AH = 1;
    private static final int CURRENT_ERA = 1;
    private static final int JAN_1_1_JULIAN_DAY = 1948440;
    static final int[] NUM_DAYS;
    static final int[] LEAP_NUM_DAYS;
    static final int[] MONTH_LENGTH;
    static final int[] LEAP_MONTH_LENGTH;
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    static final int[] MIN_VALUES;
    static final int[] LEAST_MAX_VALUES;
    static final int[] MAX_VALUES;
    static final int[] CYCLEYEAR_START_DATE;
    Deviation m_Deviation = new Deviation();
    private static Integer[] m_MonthDays;
    private static Integer[] m_LeapMonthDays;
    private static Integer[] m_MonthLengths;
    private static Integer[] m_LeapMonthLengths;
    private static Integer[] m_CycleYears;
    private static final boolean DEFAULT_DEVIATIONS_SET = true;

    public HijrahCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public HijrahCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public HijrahCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public HijrahCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.initDeviation(true);
        this.setTimeInMillis(System.currentTimeMillis());
        this.mCalendarType = 4;
    }

    HijrahCalendar(TimeZone timeZone, Locale locale, boolean bl) {
        super(timeZone, locale);
        this.initDeviation(bl);
        this.setTimeInMillis(System.currentTimeMillis());
        this.mCalendarType = 4;
    }

    public HijrahCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.initDeviation(true);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.mCalendarType = 4;
    }

    public HijrahCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.initDeviation(true);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.mCalendarType = 4;
    }

    public HijrahCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.initDeviation(true);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
        this.mCalendarType = 4;
    }

    public HijrahCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.initDeviation(true);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
        if (n7 > 999999999 || n7 < 0) {
            throw new IllegalArgumentException("nanosecond > 999999999 or < 0");
        }
        this.set(14, n7 / 1000000);
        this.set(19, n7);
        this.mCalendarType = 4;
    }

    private void initDeviation(boolean bl) {
        if (bl) {
            try {
                this.m_Deviation = Deviation.getDeviation();
            }
            catch (Exception exception) {
                this.m_Deviation = new Deviation();
            }
        } else {
            this.m_Deviation = new Deviation();
        }
    }

    public boolean isLeapYear(int n) {
        return HijrahCalendar.isLeapYearInternal(n);
    }

    static boolean isLeapYearInternal(int n) {
        return (14 + 11 * (n > 0 ? n : -n)) % 30 < 11;
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof HijrahCalendar;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getMinimum(int n) {
        return this.m_Deviation.mAdjustedMinValues[n];
    }

    public int getMaximum(int n) {
        return this.m_Deviation.mAdjustedMaxValues[n];
    }

    public int getGreatestMinimum(int n) {
        return this.m_Deviation.mAdjustedMinValues[n];
    }

    public int getLeastMaximum(int n) {
        return this.m_Deviation.mAdjustedLeastMaxValues[n];
    }

    public void setType(int n) {
        this.mCalendarType = n;
    }

    public void setDeviation(Deviation deviation) {
        this.m_Deviation = deviation;
    }

    public Deviation getDeviation() {
        return this.m_Deviation;
    }

    protected final int monthDays(int n, int n2) {
        Integer[] integerArray = this.getAdjustedMonthDays(n2);
        return integerArray[n];
    }

    protected final int monthDays(int n) {
        int n2 = this.internalGet(1);
        return this.monthDays(n, n2);
    }

    protected final int monthLength(int n, int n2) {
        Integer[] integerArray = this.getAdjustedMonthLength(n2);
        return integerArray[n];
    }

    protected final int monthLength(int n) {
        int n2 = this.internalGet(1);
        return this.monthLength(n, n2);
    }

    protected final int yearLength(int n) {
        int n2 = (n - 1) / 30;
        Integer[] integerArray = null;
        try {
            integerArray = (Integer[])this.m_Deviation.mAdjustedCycleYears.get(new Integer(n2));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (integerArray != null) {
            int n3 = (n - 1) % 30;
            if (n3 == 29) {
                return this.m_Deviation.mAdjustedCycles[n2 + 1].intValue() - this.m_Deviation.mAdjustedCycles[n2].intValue() - integerArray[n3];
            }
            return integerArray[n3 + 1] - integerArray[n3];
        }
        return this.isLeapYear(n) ? 355 : 354;
    }

    protected final int yearLength() {
        return this.yearLength(this.internalGet(1));
    }

    protected void handleEra(int n, int n2) {
    }

    protected int[] fieldInfo(long l) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        long l2 = l - 1948440L;
        if (l2 >= 0L) {
            int n6 = this.getCycleNumber(l2);
            int n7 = this.getDayOfCycle(l2, n6);
            int n8 = this.getYearInCycle(n6, n7);
            n5 = this.getDayOfYear(n6, n7, n8);
            n4 = n6 * 30 + n8 + 1;
            n3 = this.getMonthOfYear(n5, n4);
            n2 = this.getDayOfMonth(n5, n3, n4);
            ++n2;
            n = 1;
        } else {
            int n9 = (int)l2 / 10631;
            int n10 = (int)l2 % 10631;
            if (n10 == 0) {
                n10 = -10631;
                ++n9;
            }
            int n11 = this.getYearInCycle(n9, n10);
            n5 = this.getDayOfYear(n9, n10, n11);
            n4 = n9 * 30 - n11;
            n4 = 1 - n4;
            n3 = this.getMonthOfYear(n5, n4);
            n2 = this.getDayOfMonth(n5, n3, n4);
            ++n2;
            n = 0;
        }
        int n12 = (int)((l + 1L) % 7L);
        int[] nArray = new int[]{n, n4, n3, n2, n12 += n12 < 0 ? 8 : 1, n5};
        return nArray;
    }

    protected long yearToJulianDay(int n, int n2) {
        if (n == 0) {
            n2 = 1 - n2;
        }
        int n3 = (n2 - 1) / 30;
        int n4 = (n2 - 1) % 30;
        int n5 = this.getAdjustedCycle(n3)[Math.abs(n4)];
        if (n4 < 0) {
            n5 = -n5;
        }
        Long l = null;
        try {
            l = this.m_Deviation.mAdjustedCycles[n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (l == null) {
            l = new Long(n3 * 10631);
        }
        return l + (long)n5 + 1948440L - 1L;
    }

    protected int getCurrentEra() {
        return 1;
    }

    private int getCycleNumber(long l) {
        int n = (int)l / 10631;
        try {
            Long[] longArray = this.m_Deviation.mAdjustedCycles;
            for (int i = 0; i < longArray.length; ++i) {
                if (l >= longArray[i]) continue;
                return i - 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return n;
    }

    private int getDayOfCycle(long l, int n) {
        Long l2 = null;
        try {
            l2 = this.m_Deviation.mAdjustedCycles[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (l2 == null) {
            l2 = new Long(n * 10631);
        }
        return (int)(l - l2);
    }

    private int getYearInCycle(int n, long l) {
        Integer[] integerArray = this.getAdjustedCycle(n);
        if (l == 0L) {
            return 0;
        }
        if (l > 0L) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (l >= (long)integerArray[i].intValue()) continue;
                return i - 1;
            }
            return 29;
        }
        l = -l;
        for (int i = 0; i < integerArray.length; ++i) {
            if (l > (long)integerArray[i].intValue()) continue;
            return i - 1;
        }
        return 29;
    }

    private Integer[] getAdjustedCycle(int n) {
        Integer[] integerArray = null;
        try {
            integerArray = (Integer[])this.m_Deviation.mAdjustedCycleYears.get(new Integer(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (integerArray == null) {
            integerArray = m_CycleYears;
        }
        return integerArray;
    }

    private Integer[] getAdjustedMonthDays(int n) {
        Integer[] integerArray = null;
        try {
            integerArray = (Integer[])this.m_Deviation.mAdjustedMonthDays.get(new Integer(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (integerArray == null) {
            integerArray = this.isLeapYear(n) ? m_LeapMonthDays : m_MonthDays;
        }
        return integerArray;
    }

    private Integer[] getAdjustedMonthLength(int n) {
        Integer[] integerArray = null;
        try {
            integerArray = (Integer[])this.m_Deviation.mAdjustedMonthLengths.get(new Integer(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (integerArray == null) {
            integerArray = this.isLeapYear(n) ? m_LeapMonthLengths : m_MonthLengths;
        }
        return integerArray;
    }

    private int getDayOfYear(int n, int n2, int n3) {
        Integer[] integerArray = this.getAdjustedCycle(n);
        if (n2 > 0) {
            return n2 - integerArray[n3];
        }
        return integerArray[n3] + n2;
    }

    private int getMonthOfYear(int n, int n2) {
        Integer[] integerArray = this.getAdjustedMonthDays(n2);
        if (n >= 0) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (n >= integerArray[i]) continue;
                return i - 1;
            }
            return 11;
        }
        n = this.isLeapYear(n2) ? n + 355 : n + 354;
        for (int i = 0; i < integerArray.length; ++i) {
            if (n >= integerArray[i]) continue;
            return i - 1;
        }
        return 11;
    }

    private int getDayOfMonth(int n, int n2, int n3) {
        Integer[] integerArray = this.getAdjustedMonthDays(n3);
        if (n >= 0) {
            if (n2 > 0) {
                return n - integerArray[n2];
            }
            return n;
        }
        int n4 = n = this.isLeapYear(n3) ? n + 355 : n + 354;
        if (n2 > 0) {
            return n - integerArray[n2];
        }
        return n;
    }

    static {
        int n;
        RCS_ID_RECORDED = VersionInfo.recordClassVersion(RCS_ID, "oracle.apps.fnd.i18n.common.util");
        NUM_DAYS = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325};
        LEAP_NUM_DAYS = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325};
        MONTH_LENGTH = new int[]{30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29};
        LEAP_MONTH_LENGTH = new int[]{30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 30};
        MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -46800000, 0, -13, -59, 0, -45, 1};
        LEAST_MAX_VALUES = new int[]{1, 4500, 11, 51, 5, 29, 354, 7, 4, 1, 11, 23, 59, 59, 999, 50400000, 3600000, 14, 59, 999999999, 45, 51};
        MAX_VALUES = new int[]{1, 4500, 11, 52, 6, 30, 355, 7, 5, 1, 11, 23, 59, 59, 999, 50400000, 3600000, 14, 59, 999999999, 45, 52};
        CYCLEYEAR_START_DATE = new int[]{0, 354, 709, 1063, 1417, 1772, 2126, 2481, 2835, 3189, 3544, 3898, 4252, 4607, 4961, 5315, 5670, 6024, 6379, 6733, 7087, 7442, 7796, 8150, 8505, 8859, 9214, 9568, 9922, 10277};
        m_MonthDays = null;
        m_LeapMonthDays = null;
        m_MonthLengths = null;
        m_LeapMonthLengths = null;
        m_CycleYears = null;
        m_MonthDays = new Integer[NUM_DAYS.length];
        for (n = 0; n < NUM_DAYS.length; ++n) {
            HijrahCalendar.m_MonthDays[n] = new Integer(NUM_DAYS[n]);
        }
        m_LeapMonthDays = new Integer[LEAP_NUM_DAYS.length];
        for (n = 0; n < LEAP_NUM_DAYS.length; ++n) {
            HijrahCalendar.m_LeapMonthDays[n] = new Integer(LEAP_NUM_DAYS[n]);
        }
        m_MonthLengths = new Integer[MONTH_LENGTH.length];
        for (n = 0; n < MONTH_LENGTH.length; ++n) {
            HijrahCalendar.m_MonthLengths[n] = new Integer(MONTH_LENGTH[n]);
        }
        m_LeapMonthLengths = new Integer[LEAP_MONTH_LENGTH.length];
        for (n = 0; n < LEAP_MONTH_LENGTH.length; ++n) {
            HijrahCalendar.m_LeapMonthLengths[n] = new Integer(LEAP_MONTH_LENGTH[n]);
        }
        m_CycleYears = new Integer[CYCLEYEAR_START_DATE.length];
        for (n = 0; n < CYCLEYEAR_START_DATE.length; ++n) {
            HijrahCalendar.m_CycleYears[n] = new Integer(CYCLEYEAR_START_DATE[n]);
        }
    }
}

